"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
describe('State Transition Metrics', () => {
    test('add a named state transition metric', () => {
        // WHEN
        const metric = lib_1.StateTransitionMetric.metric('my-metric');
        // THEN
        verifyTransitionMetric(metric, 'my-metric', 'Average');
    });
    test('metric for available state transitions.', () => {
        // WHEN
        const metric = lib_1.StateTransitionMetric.metricProvisionedBucketSize();
        // THEN
        verifyTransitionMetric(metric, 'ProvisionedBucketSize', 'Average');
    });
    test('metric for provisioned steady-state execution rate', () => {
        // WHEN
        const metric = lib_1.StateTransitionMetric.metricProvisionedRefillRate();
        // THEN
        verifyTransitionMetric(metric, 'ProvisionedRefillRate', 'Average');
    });
    test('metric for state-transitions per second', () => {
        // WHEN
        const metric = lib_1.StateTransitionMetric.metricConsumedCapacity();
        // THEN
        verifyTransitionMetric(metric, 'ConsumedCapacity', 'Average');
    });
    test('metric for the number of throttled state transitions', () => {
        // WHEN
        const metric = lib_1.StateTransitionMetric.metricThrottledEvents();
        // THEN
        verifyTransitionMetric(metric, 'ThrottledEvents', 'Sum');
    });
});
function verifyTransitionMetric(metric, metricName, statistic) {
    expect(metric).toEqual({
        period: { amount: 5, unit: { label: 'minutes', inMillis: 60000 } },
        dimensions: { ServiceMetric: 'StateTransition' },
        namespace: 'AWS/States',
        metricName,
        statistic,
    });
}
//# sourceMappingURL=data:application/json;base64,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