"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestStack = exports.testFixtureEc2 = exports.testFixtureEip = exports.testFixtureNlb = exports.testFixtureAlb = exports.testFixtureNoVpc = exports.testFixture = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const core_1 = require("@aws-cdk/core");
function testFixture() {
    const { stack, app } = testFixtureNoVpc();
    const vpc = new ec2.Vpc(stack, 'VPC');
    return { stack, vpc, app };
}
exports.testFixture = testFixture;
function testFixtureNoVpc() {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Stack');
    return { stack, app };
}
exports.testFixtureNoVpc = testFixtureNoVpc;
function testFixtureAlb() {
    const { stack, app, vpc } = testFixture();
    const alb = new elbv2.ApplicationLoadBalancer(stack, 'ALB', { vpc, internetFacing: true });
    return { stack, app, alb, vpc };
}
exports.testFixtureAlb = testFixtureAlb;
function testFixtureNlb() {
    const { stack, app, vpc } = testFixture();
    const nlb = new elbv2.NetworkLoadBalancer(stack, 'NLB', { vpc, internetFacing: true });
    return { stack, app, nlb };
}
exports.testFixtureNlb = testFixtureNlb;
function testFixtureEip() {
    const { stack, app } = testFixtureNoVpc();
    const eip = new ec2.CfnEIP(stack, 'ElasticIpAddress');
    return { stack, app, eip };
}
exports.testFixtureEip = testFixtureEip;
function testFixtureEc2() {
    const { stack, app, vpc } = testFixture();
    const instance = new ec2.Instance(stack, 'Ec2', {
        vpc,
        machineImage: new ec2.AmazonLinuxImage(),
        instanceType: new ec2.InstanceType('t3.small'),
    });
    return { stack, app, instance };
}
exports.testFixtureEc2 = testFixtureEc2;
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
    }
}
exports.TestStack = TestStack;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsd0NBQXdDO0FBQ3hDLDZEQUE2RDtBQUM3RCx3Q0FBc0Q7QUFFdEQsU0FBZ0IsV0FBVztJQUN6QixNQUFNLEVBQUUsS0FBSyxFQUFFLEdBQUcsRUFBRSxHQUFHLGdCQUFnQixFQUFFLENBQUM7SUFDMUMsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztJQUV0QyxPQUFPLEVBQUUsS0FBSyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQztBQUM3QixDQUFDO0FBTEQsa0NBS0M7QUFFRCxTQUFnQixnQkFBZ0I7SUFDOUIsTUFBTSxHQUFHLEdBQUcsSUFBSSxVQUFHLEVBQUUsQ0FBQztJQUN0QixNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssQ0FBQyxHQUFHLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDdEMsT0FBTyxFQUFFLEtBQUssRUFBRSxHQUFHLEVBQUUsQ0FBQztBQUN4QixDQUFDO0FBSkQsNENBSUM7QUFFRCxTQUFnQixjQUFjO0lBQzVCLE1BQU0sRUFBRSxLQUFLLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLFdBQVcsRUFBRSxDQUFDO0lBQzFDLE1BQU0sR0FBRyxHQUFHLElBQUksS0FBSyxDQUFDLHVCQUF1QixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsRUFBRSxHQUFHLEVBQUUsY0FBYyxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7SUFFM0YsT0FBTyxFQUFFLEtBQUssRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDO0FBQ2xDLENBQUM7QUFMRCx3Q0FLQztBQUVELFNBQWdCLGNBQWM7SUFDNUIsTUFBTSxFQUFFLEtBQUssRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsV0FBVyxFQUFFLENBQUM7SUFDMUMsTUFBTSxHQUFHLEdBQUcsSUFBSSxLQUFLLENBQUMsbUJBQW1CLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRSxFQUFFLEdBQUcsRUFBRSxjQUFjLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztJQUV2RixPQUFPLEVBQUUsS0FBSyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQztBQUM3QixDQUFDO0FBTEQsd0NBS0M7QUFFRCxTQUFnQixjQUFjO0lBQzVCLE1BQU0sRUFBRSxLQUFLLEVBQUUsR0FBRyxFQUFFLEdBQUcsZ0JBQWdCLEVBQUUsQ0FBQztJQUMxQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLGtCQUFrQixDQUFDLENBQUM7SUFFdEQsT0FBTyxFQUFFLEtBQUssRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUM7QUFDN0IsQ0FBQztBQUxELHdDQUtDO0FBRUQsU0FBZ0IsY0FBYztJQUM1QixNQUFNLEVBQUUsS0FBSyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxXQUFXLEVBQUUsQ0FBQztJQUMxQyxNQUFNLFFBQVEsR0FBRyxJQUFJLEdBQUcsQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRTtRQUM5QyxHQUFHO1FBQ0gsWUFBWSxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixFQUFFO1FBQ3hDLFlBQVksRUFBRSxJQUFJLEdBQUcsQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDO0tBQy9DLENBQUMsQ0FBQztJQUVILE9BQU8sRUFBRSxLQUFLLEVBQUUsR0FBRyxFQUFFLFFBQVEsRUFBRSxDQUFDO0FBQ2xDLENBQUM7QUFURCx3Q0FTQztBQUVELE1BQWEsU0FBVSxTQUFRLFlBQUs7SUFDbEMsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztJQUNuQixDQUFDO0NBQ0Y7QUFKRCw4QkFJQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGVsYnYyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJztcbmltcG9ydCB7IEFwcCwgQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5leHBvcnQgZnVuY3Rpb24gdGVzdEZpeHR1cmUoKSB7XG4gIGNvbnN0IHsgc3RhY2ssIGFwcCB9ID0gdGVzdEZpeHR1cmVOb1ZwYygpO1xuICBjb25zdCB2cGMgPSBuZXcgZWMyLlZwYyhzdGFjaywgJ1ZQQycpO1xuXG4gIHJldHVybiB7IHN0YWNrLCB2cGMsIGFwcCB9O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gdGVzdEZpeHR1cmVOb1ZwYygpIHtcbiAgY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuICBjb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICdTdGFjaycpO1xuICByZXR1cm4geyBzdGFjaywgYXBwIH07XG59XG5cbmV4cG9ydCBmdW5jdGlvbiB0ZXN0Rml4dHVyZUFsYigpIHtcbiAgY29uc3QgeyBzdGFjaywgYXBwLCB2cGMgfSA9IHRlc3RGaXh0dXJlKCk7XG4gIGNvbnN0IGFsYiA9IG5ldyBlbGJ2Mi5BcHBsaWNhdGlvbkxvYWRCYWxhbmNlcihzdGFjaywgJ0FMQicsIHsgdnBjLCBpbnRlcm5ldEZhY2luZzogdHJ1ZSB9KTtcblxuICByZXR1cm4geyBzdGFjaywgYXBwLCBhbGIsIHZwYyB9O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gdGVzdEZpeHR1cmVObGIoKSB7XG4gIGNvbnN0IHsgc3RhY2ssIGFwcCwgdnBjIH0gPSB0ZXN0Rml4dHVyZSgpO1xuICBjb25zdCBubGIgPSBuZXcgZWxidjIuTmV0d29ya0xvYWRCYWxhbmNlcihzdGFjaywgJ05MQicsIHsgdnBjLCBpbnRlcm5ldEZhY2luZzogdHJ1ZSB9KTtcblxuICByZXR1cm4geyBzdGFjaywgYXBwLCBubGIgfTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHRlc3RGaXh0dXJlRWlwKCkge1xuICBjb25zdCB7IHN0YWNrLCBhcHAgfSA9IHRlc3RGaXh0dXJlTm9WcGMoKTtcbiAgY29uc3QgZWlwID0gbmV3IGVjMi5DZm5FSVAoc3RhY2ssICdFbGFzdGljSXBBZGRyZXNzJyk7XG5cbiAgcmV0dXJuIHsgc3RhY2ssIGFwcCwgZWlwIH07XG59XG5cbmV4cG9ydCBmdW5jdGlvbiB0ZXN0Rml4dHVyZUVjMigpIHtcbiAgY29uc3QgeyBzdGFjaywgYXBwLCB2cGMgfSA9IHRlc3RGaXh0dXJlKCk7XG4gIGNvbnN0IGluc3RhbmNlID0gbmV3IGVjMi5JbnN0YW5jZShzdGFjaywgJ0VjMicsIHtcbiAgICB2cGMsXG4gICAgbWFjaGluZUltYWdlOiBuZXcgZWMyLkFtYXpvbkxpbnV4SW1hZ2UoKSxcbiAgICBpbnN0YW5jZVR5cGU6IG5ldyBlYzIuSW5zdGFuY2VUeXBlKCd0My5zbWFsbCcpLFxuICB9KTtcblxuICByZXR1cm4geyBzdGFjaywgYXBwLCBpbnN0YW5jZSB9O1xufVxuXG5leHBvcnQgY2xhc3MgVGVzdFN0YWNrIGV4dGVuZHMgU3RhY2sge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgfVxufVxuIl19