"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const cdk = require("@aws-cdk/core");
const ga = require("../lib");
const testfixture = require("./util");
class GaStack extends testfixture.TestStack {
    constructor(scope, id) {
        super(scope, id);
        const vpc = new ec2.Vpc(this, 'VPC', { maxAzs: 3, natGateways: 1 });
        const accelerator = new ga.Accelerator(this, 'Accelerator');
        const listener = new ga.Listener(this, 'Listener', {
            accelerator,
            portRanges: [
                {
                    fromPort: 80,
                    toPort: 80,
                },
            ],
        });
        const endpointGroup = new ga.EndpointGroup(this, 'Group', { listener });
        const alb = new elbv2.ApplicationLoadBalancer(this, 'ALB', { vpc, internetFacing: true });
        const nlb = new elbv2.NetworkLoadBalancer(this, 'NLB', { vpc, internetFacing: true });
        const eip = new ec2.CfnEIP(this, 'ElasticIpAddress');
        const instances = new Array();
        for (let i = 0; i < 2; i++) {
            instances.push(new ec2.Instance(this, `Instance${i}`, {
                vpc,
                machineImage: new ec2.AmazonLinuxImage(),
                instanceType: new ec2.InstanceType('t3.small'),
            }));
        }
        endpointGroup.addLoadBalancer('AlbEndpoint', alb);
        endpointGroup.addLoadBalancer('NlbEndpoint', nlb);
        endpointGroup.addElasticIpAddress('EipEndpoint', eip);
        endpointGroup.addEc2Instance('InstanceEndpoint', instances[0]);
        endpointGroup.addEndpoint('InstanceEndpoint2', instances[1].instanceId);
    }
}
const app = new cdk.App();
new GaStack(app, 'integ-globalaccelerator');
//# sourceMappingURL=data:application/json;base64,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