"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ClientAffinity = exports.ConnectionProtocol = void 0;
const cdk = require("@aws-cdk/core");
const ga = require("./globalaccelerator.generated");
/**
 * The protocol for the connections from clients to the accelerator.
 */
var ConnectionProtocol;
(function (ConnectionProtocol) {
    /**
     * TCP
     */
    ConnectionProtocol["TCP"] = "TCP";
    /**
     * UDP
     */
    ConnectionProtocol["UDP"] = "UDP";
})(ConnectionProtocol = exports.ConnectionProtocol || (exports.ConnectionProtocol = {}));
/**
 * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
 * regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
 * route each client to the same specific endpoint. If you want a given client to always be routed to the same
 * endpoint, set client affinity to SOURCE_IP.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 */
var ClientAffinity;
(function (ClientAffinity) {
    /**
     * default affinity
     */
    ClientAffinity["NONE"] = "NONE";
    /**
     * affinity by source IP
     */
    ClientAffinity["SOURCE_IP"] = "SOURCE_IP";
})(ClientAffinity = exports.ClientAffinity || (exports.ClientAffinity = {}));
/**
 * The construct for the Listener
 */
class Listener extends cdk.Resource {
    constructor(scope, id, props) {
        var _a, _b, _c;
        super(scope, id);
        const resource = new ga.CfnListener(this, 'Resource', {
            acceleratorArn: props.accelerator.acceleratorArn,
            portRanges: props.portRanges.map(m => ({
                fromPort: m.fromPort,
                toPort: m.toPort,
            })),
            protocol: (_a = props.protocol) !== null && _a !== void 0 ? _a : ConnectionProtocol.TCP,
            clientAffinity: (_b = props.clientAffinity) !== null && _b !== void 0 ? _b : ClientAffinity.NONE,
        });
        this.listenerArn = resource.attrListenerArn;
        this.listenerName = (_c = props.listenerName) !== null && _c !== void 0 ? _c : resource.logicalId;
    }
    /**
     * import from ARN
     */
    static fromListenerArn(scope, id, listenerArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.listenerArn = listenerArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.Listener = Listener;
//# sourceMappingURL=data:application/json;base64,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