"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Accelerator = void 0;
const cdk = require("@aws-cdk/core");
const ga = require("./globalaccelerator.generated");
/**
 * The Accelerator construct
 */
class Accelerator extends cdk.Resource {
    constructor(scope, id, props = {}) {
        var _a, _b;
        super(scope, id);
        const resource = new ga.CfnAccelerator(this, 'Resource', {
            enabled: (_a = props.enabled) !== null && _a !== void 0 ? _a : true,
            name: (_b = props.acceleratorName) !== null && _b !== void 0 ? _b : id,
        });
        this.acceleratorArn = resource.attrAcceleratorArn;
        this.dnsName = resource.attrDnsName;
    }
    /**
     * import from attributes
     */
    static fromAcceleratorAttributes(scope, id, attrs) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.acceleratorArn = attrs.acceleratorArn;
                this.dnsName = attrs.dnsName;
            }
        }
        return new Import(scope, id);
    }
}
exports.Accelerator = Accelerator;
//# sourceMappingURL=data:application/json;base64,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