# AUTOGENERATED! DO NOT EDIT! File to edit: 01_PreProcessor.ipynb (unless otherwise specified).

__all__ = ['PreProcessor']

# Cell
from .DataFrameLoader import *

# Cell
# hide
import pandas as pd
from sklearn.compose import ColumnTransformer
from sklearn.pipeline import Pipeline
from sklearn.impute import SimpleImputer
from sklearn.preprocessing import OneHotEncoder, OrdinalEncoder, StandardScaler, MinMaxScaler
from sklearn.ensemble import RandomForestRegressor
from sklearn.metrics import mean_absolute_error

# Cell

class PreProcessor:
    """
    Represent PreProcessor class

    Attributes:
    numerical_transformer: Numerical Columns Tranformer
    categorical_transformer: Categorical Columns Transformer
    preprocessor: Preprocessor for Columns Tranformer
    """

    def __init__(self):
        self.numerical_transformer = None
        self.categorical_transformer = None
        self.columns_transfomer = None
        self.transformer_type = None
        self.OHE_categorical_transformer = None
        self.ORE_categorical_transformer = None

    def __str__(self):
        """Returns human readable string reprsentation"""
        attr_str = "numerical_transformer, categorical_transformer,columns_transfomer"
        return "PreProcessor object with attributes:" + attr_str

    def __repr__(self):
        return self.__str__()

    # PreProcessor core methods

    # Preprocessing for numerical data
    def preprocess_numerical_data(self, num_imputer, num_scaler):
        self.numerical_transformer = Pipeline(steps=[
            ('imputer', num_imputer),
            ('scaler',  num_scaler)
        ])

    # Preprocessing for categorical data
    def preprocess_OHE_categorical_data(self, cat_imputer):
        self.OHE_categorical_transformer = Pipeline(steps=[
        ('imputer', cat_imputer),
        ('onehot', OneHotEncoder(handle_unknown='ignore'))
        ])

    def preprocess_OE_categorical_data(self, cat_imputer):
        self.OE_categorical_transformer = Pipeline(steps=[
        ('imputer', cat_imputer),
        ('ordinal', OrdinalEncoder())
        ])

    #TO-DO
#     def reduce_dims(self):
#         pass

    # Bundle preprocessing pipelines based upon types of columns
    def preprocess_all_cols(self, dataframeloader,
                            num_imputer = SimpleImputer(strategy='median'),
                            num_scaler = StandardScaler(),
                            cat_imputer = SimpleImputer(strategy='constant')):

        # change preprocessor according to type of column found

        if len(dataframeloader.high_card_cat_cols) < 1:
            if len(dataframeloader.low_card_cat_cols) < 1:
#                 print("both high_card_cat_cols and low_card_cat_cols are None")
                self.preprocess_numerical_data(num_imputer, num_scaler)
                self.transformer_type = self.numerical_transformer

            elif len(dataframeloader.numerical_cols) < 1:
#                 print("both numeric nand high card cat cols are None")
                # create scikit-learn pipelines instances
                self.preprocess_OHE_categorical_data(cat_imputer)
                # convert all categorical columns to OneHotEncoder with Scikit-learn ColumnTranfomer
                self.columns_transfomer = ColumnTransformer(
                    transformers=[
                        ('low_card_cat_cols', self.OHE_categorical_transformer,
                         dataframeloader.low_card_cat_cols)
                    ])
                self.transformer_type = self.columns_transfomer

        elif len(dataframeloader.low_card_cat_cols) < 1:
            if len(dataframeloader.numerical_cols) < 1:
#                 print("both numeric nand low card cat cols are None")
                # create scikit-learn pipelines instances
                self.preprocess_OHE_categorical_data(cat_imputer)
                # convert all categorical columns to OneHotEncoder with Scikit-learn ColumnTranfomer
                self.columns_transfomer = ColumnTransformer(
                    transformers=[
                        ('high_card_cat_cols', self.OHE_categorical_transformer,
                         dataframeloader.high_card_cat_cols)
                    ])
                self.transformer_type = self.columns_transfomer

        elif len(dataframeloader.numerical_cols) < 1:
#             print("numeric cols are None")
            # create scikit-learn pipelines instances
            self.preprocess_OHE_categorical_data(cat_imputer)
            # convert all categorical columns to OneHotEncoder with Scikit-learn ColumnTranfomer
            self.columns_transfomer = ColumnTransformer(
                transformers=[
                    ('low_card_cat_cols', self.OHE_categorical_transformer,
                     dataframeloader.low_card_cat_cols),
                    ('high_card_cat_cols', self.OHE_categorical_transformer,
                     dataframeloader.high_card_cat_cols)
                ])
            self.transformer_type = self.columns_transfomer
        else:
            # create scikit-learn pipelines instances
#             print("No cols types are None, So ALL preprocessors called!")
            self.preprocess_numerical_data(num_imputer, num_scaler)
            self.preprocess_OHE_categorical_data(cat_imputer)
            self.preprocess_OE_categorical_data(cat_imputer)
            # convert to Scikit-learn ColumnTranfomer
            self.columns_transfomer = ColumnTransformer(
                transformers=[
                    ('num_cols', self.numerical_transformer,
                     dataframeloader.numerical_cols),
                    ('low_card_cat_cols', self.OHE_categorical_transformer,
                     dataframeloader.low_card_cat_cols),
                    ('high_card_cat_cols', self.OHE_categorical_transformer,
                     dataframeloader.high_card_cat_cols)
                ])
            self.transformer_type = self.columns_transfomer

        return self