""" This module is generated by Alembic.
Its runned when Alembic migration in started
"""
from __future__ import with_statement
import sys
from logging.config import fileConfig
from sqlalchemy import engine_from_config
from sqlalchemy import pool
from alembic import context
from loguru import logger
from pathlib import Path

root_path = Path(__file__).resolve().parent.parent.parent
sys.path.insert(0, str(root_path))

import backend.misc as ax_misc
import backend.model as ax_model
import main as ax_app


def include_object(object, name, type_, reflected, compare_to):
    if (type_ == "table" and not str(name).startswith('_')):
        return False
    else:
        return True


print('----------------------------------------------------')

# Sets alembic configuration. migration script distanation and database url
# Database contains alebnic _ax_alembic_version table with current version
alembic_folder = ax_misc.path("backend/alembic")
config = context.config
config.set_main_option('script_location', str(alembic_folder))

fileConfig(config.config_file_name)
ax_misc.load_configuration()
ax_app.init_model()

config.set_main_option('sqlalchemy.url', str(ax_model.db_url))
# target_metadata = ax_model.Base.metadata


def run_migrations_offline():
    """Run migrations in 'offline' mode.

    This configures the context with just a URL
    and not an Engine, though an Engine is acceptable
    here as well.  By skipping the Engine creation
    we don't even need a DBAPI to be available.

    Calls to context.execute() here emit the given string to the
    script output.

    """
    print('running offline Ax migration')
    err = 'env -> run_migrations_offline'
    with ax_model.Session() as db_session:
        url = config.get_main_option("sqlalchemy.url")
        ax_model.Base.query = db_session.query_property()
        target_metadata = ax_model.Base.metadata
        context.configure(
            url=url, target_metadata=target_metadata,
            literal_binds=True,
            include_object=include_object,
            version_table='_ax_alembic_version'
        )
        with context.begin_transaction():
            context.run_migrations()


def run_migrations_online():
    """Run migrations in 'online' mode.

    In this scenario we need to create an Engine
    and associate a connection with the context.

    """
    print('running offline migration')

    connectable = engine_from_config(
        config.get_section(config.config_ini_section),
        prefix="sqlalchemy.",
        poolclass=pool.NullPool,
    )

    with connectable.connect() as connection:
        context.configure(
            connection=connection,
            include_object=include_object,
            target_metadata=target_metadata,
            version_table='_ax_alembic_version'
        )

        with context.begin_transaction():
            context.run_migrations()


if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
