"""
Expression aims to be a solid, type-safe, pragmatic, and high
performance library for practical functional programming in Python 3.8+.
By pragmatic we mean that the goal of the library is to use simple
abstractions to enable you to do practical and productive functional
programming in Python.

GitHub: https://github.com/dbrattli/Expression
"""

from . import collections, core, effect
from ._version import get_versions
from .core import (
    AsyncReplyChannel,
    Builder,
    Case,
    Choice,
    Choice1of2,
    Choice1of3,
    Choice2,
    Choice2of2,
    Choice2of3,
    Choice3,
    Choice3of3,
    EffectError,
    Error,
    Failure,
    MailboxProcessor,
    MatchMixin,
    Nothing,
    Nothing_,
    Ok,
    Option,
    Result,
    Some,
    Success,
    TailCall,
    TailCallResult,
    Try,
    compose,
    curried,
    default_arg,
    downcast,
    failwith,
    flip,
    fst,
    identity,
    match,
    option,
    pipe,
    pipe2,
    pipe3,
    result,
    snd,
    tailrec,
    tailrec_async,
    try_downcast,
    upcast,
)

__all__ = [
    "AsyncReplyChannel",
    "Builder",
    "Case",
    "Choice",
    "Choice1of2",
    "Choice1of3",
    "Choice2",
    "Choice2of2",
    "Choice2of3",
    "Choice3",
    "Choice3of3",
    "collections",
    "compose",
    "core",
    "curried",
    "default_arg",
    "downcast",
    "effect",
    "EffectError",
    "Error",
    "Failure",
    "failwith",
    "flip",
    "fst",
    "identity",
    "MailboxProcessor",
    "match",
    "MatchMixin",
    "Nothing",
    "Nothing_",
    "Ok",
    "option",
    "Option",
    "pipe",
    "pipe2",
    "pipe3",
    "result",
    "Result",
    "snd",
    "Some",
    "Success",
    "TailCall",
    "TailCallResult",
    "tailrec",
    "tailrec_async",
    "Try",
    "try_downcast",
    "upcast",
]


__version__ = get_versions()["version"]  # type: ignore
del get_versions
