import logging
from cerberus import Validator
from datazen import DEFAULT_DIR as DEFAULT_DIR, ROOT_NAMESPACE as ROOT_NAMESPACE
from datazen.classes.target_resolver import TargetResolver as TargetResolver
from datazen.environment.config import ConfigEnvironment as ConfigEnvironment
from datazen.environment.template import TemplateEnvironment as TemplateEnvironment
from datazen.parsing import load_stream as load_stream, merge_dicts as merge_dicts
from datazen.paths import get_package_data as get_package_data, get_package_dir as get_package_dir, resolve_dir as resolve_dir
from datazen.schemas import inject_custom_schemas as inject_custom_schemas, load_types as load_types
from typing import Any, List, Tuple

LOG: Any

def get_output_dir(data: dict, rel_path: str, default: str = ...) -> str: ...
def set_output_dir(data: dict, rel_path: str, default: str = ...) -> None: ...

class ManifestEnvironment(ConfigEnvironment, TemplateEnvironment):
    manifest: Any
    target_resolver: Any
    def __init__(self) -> None: ...
    def load_dirs(self, data: dict, rel_path: str, namespace: str = ..., allow_dup: bool = ...) -> None: ...
    def default_target(self) -> str: ...
    def load_manifest_reent(self, path: str, manifest_dir: str, params: dict, files: List[str], logger: logging.Logger = ...) -> Tuple[dict, bool]: ...
    def load_manifest(self, path: str = ..., logger: logging.Logger = ...) -> bool: ...

def get_manifest_schema(require_all: bool = ..., logger: logging.Logger = ...) -> Validator: ...
def validate_manifest(manifest: dict, logger: logging.Logger = ...) -> bool: ...
