import logging
from datazen import ROOT_NAMESPACE as ROOT_NAMESPACE
from datazen.enums import DataType as DataType
from datazen.environment import EnvironmentNamespace as EnvironmentNamespace, clone as clone
from typing import Any, List, NamedTuple

SLUG_DELIM: str

class Task(NamedTuple):
    variant: str
    name: str
    @property
    def slug(self) -> str: ...

class TaskResult(NamedTuple):
    success: bool
    fresh: bool

def dep_slug_unwrap(slug: str, default_op: str) -> Task: ...

class BaseEnvironment:
    namespaces: Any
    lock: Any
    logger: Any
    logger_init: Any
    def __init__(self, default_ns: str = ..., logger: logging.Logger = ...) -> None: ...
    def add_namespace(self, name: str, clone_root: bool = ...) -> None: ...
    def get_valid(self, name: str = ...) -> bool: ...
    def set_valid(self, value: bool, name: str = ...) -> None: ...
    def get_to_load(self, dir_type: DataType, name: str = ...) -> List[str]: ...
    def get_data(self, dir_type: DataType, name: str = ...) -> dict: ...
    def unload_all(self, name: str = ...) -> None: ...
    def update_load_state(self, dir_type: DataType, to_load: List[str], name: str = ...) -> int: ...
    def add_dir(self, dir_type: DataType, dir_path: str, rel_path: str = ..., name: str = ..., allow_dup: bool = ...) -> bool: ...
    def add_dirs(self, dir_type: DataType, dir_paths: List[str], rel_path: str = ..., name: str = ..., allow_dup: bool = ...) -> int: ...
    def get_namespace(self, key_name: str, target: str, target_data: dict) -> str: ...
