import logging
from datazen import VERSION as VERSION
from datazen.compile import write_dir as write_dir
from datazen.load import LoadedFiles as LoadedFiles, load_dir_only as load_dir_only
from datazen.parsing import dedup_dict_lists as dedup_dict_lists, set_file_hash as set_file_hash
from typing import Any, Dict, List

LOG: Any
DATA_DEFAULT: Any

class FileInfoCache:
    data: Any
    removed_data: Any
    cache_dir: str
    logger: Any
    def __init__(self, cache_dir: str = ..., logger: logging.Logger = ...) -> None: ...
    def load(self, cache_dir: str) -> None: ...
    def get_hashes(self, sub_dir: str) -> Dict[str, dict]: ...
    def check_hit(self, sub_dir: str, path: str, also_cache: bool = ...) -> bool: ...
    def get_loaded(self, sub_dir: str) -> List[str]: ...
    def describe(self) -> None: ...
    def get_data(self, name: str) -> LoadedFiles: ...
    def clean(self) -> None: ...
    def write(self, out_type: str = ...) -> None: ...

def copy(cache: FileInfoCache) -> FileInfoCache: ...
def meld(cache_a: FileInfoCache, cache_b: FileInfoCache) -> None: ...
def time_str(time_s: float) -> str: ...
def cmp_loaded_count(cache_a: FileInfoCache, cache_b: FileInfoCache, name: str) -> int: ...
def cmp_loaded_count_from_set(cache_a: FileInfoCache, cache_b: FileInfoCache, name: str, files: List[str]) -> int: ...
def cmp_total_loaded(cache_a: FileInfoCache, cache_b: FileInfoCache, known_types: List[str], load_checks: Dict[str, List[str]] = ..., logger: logging.Logger = ...) -> int: ...
def sync_cache_data(cache_data: dict, removed_data: Dict[str, List[str]]) -> dict: ...
def remove_missing_hashed_files(data: dict, removed_data: Dict[str, List[str]]) -> dict: ...
def remove_missing_loaded_files(data: dict) -> dict: ...
