// Copyright (c) Mito
import React, { useEffect } from 'react';
import { getRandomId } from '../../jupyter/api';
import Dropdown from '../elements/Dropdown';
import DropdownItem from '../elements/DropdownItem';
/*
    Displays a set of actions one can perform on a graph sheet tab, including
    deleting, duplicating, or renaming.
*/
export default function GraphSheetTabActions(props) {
    // Log opening the graph sheet tab actions
    useEffect(() => {
        void props.mitoAPI.log('clicked_graph_sheet_tab_actions', {
            graph_id: props.graphID
        });
    }, []);
    const onDelete = async () => {
        // Close 
        props.closeOpenEditingPopups();
        await props.mitoAPI.editGraphDelete(props.graphID);
    };
    const onDuplicate = async () => {
        // Close 
        props.closeOpenEditingPopups();
        // Duplicate the graph
        const newGraphID = getRandomId();
        await props.mitoAPI.editGraphDuplicate(props.graphID, newGraphID);
    };
    /* Rename helper, which requires changes to the sheet tab itself */
    const onRename = () => {
        props.setIsRename(true);
    };
    return (React.createElement(Dropdown, { closeDropdown: () => props.setDisplayActions(false), width: 'small' },
        React.createElement(DropdownItem, { title: 'Delete', onClick: (e) => {
                // Stop propogation so that the onClick of the sheet tab div
                // doesn't compete updating the uiState to the graphID that is getting deleted
                e === null || e === void 0 ? void 0 : e.stopPropagation();
                void onDelete();
            } }),
        React.createElement(DropdownItem, { title: 'Duplicate', onClick: onDuplicate }),
        React.createElement(DropdownItem, { title: 'Rename', onClick: onRename })));
}
//# sourceMappingURL=GraphSheetTabActions.js.map