"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.RetryableLambdaInvoke = void 0;
const aws_stepfunctions_tasks_1 = require("@aws-cdk/aws-stepfunctions-tasks");
const core_1 = require("@aws-cdk/core");
function enableThrottlingRetry(task) {
    task.addRetry({
        errors: ['Lambda.TooManyRequestsException'], backoffRate: 1.5, interval: core_1.Duration.seconds(1), maxAttempts: 10,
    });
    return task;
}
class RetryableLambdaInvoke extends aws_stepfunctions_tasks_1.LambdaInvoke {
    constructor(scope, id, props) {
        super(scope, id, props);
        enableThrottlingRetry(this);
    }
}
exports.RetryableLambdaInvoke = RetryableLambdaInvoke;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9tYWNoaW5lcy91dGlsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxxRUFBcUU7QUFDckUsaUNBQWlDOzs7QUFHakMsOEVBQW1GO0FBQ25GLHdDQUFvRDtBQUVwRCxTQUFTLHFCQUFxQixDQUFDLElBQWtCO0lBQy9DLElBQUksQ0FBQyxRQUFRLENBQUM7UUFDWixNQUFNLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxFQUFFLFdBQVcsRUFBRSxHQUFHLEVBQUUsUUFBUSxFQUFFLGVBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsV0FBVyxFQUFFLEVBQUU7S0FDOUcsQ0FBQyxDQUFDO0lBQ0gsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBRUQsTUFBYSxxQkFBc0IsU0FBUSxzQ0FBWTtJQUNyRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3hCLHFCQUFxQixDQUFDLElBQUksQ0FBQyxDQUFDO0lBQzlCLENBQUM7Q0FDRjtBQUxELHNEQUtDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTUlULTBcblxuXG5pbXBvcnQgeyBMYW1iZGFJbnZva2UsIExhbWJkYUludm9rZVByb3BzIH0gZnJvbSAnQGF3cy1jZGsvYXdzLXN0ZXBmdW5jdGlvbnMtdGFza3MnO1xuaW1wb3J0IHsgRHVyYXRpb24sIENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5mdW5jdGlvbiBlbmFibGVUaHJvdHRsaW5nUmV0cnkodGFzazogTGFtYmRhSW52b2tlKSB7XG4gIHRhc2suYWRkUmV0cnkoe1xuICAgIGVycm9yczogWydMYW1iZGEuVG9vTWFueVJlcXVlc3RzRXhjZXB0aW9uJ10sIGJhY2tvZmZSYXRlOiAxLjUsIGludGVydmFsOiBEdXJhdGlvbi5zZWNvbmRzKDEpLCBtYXhBdHRlbXB0czogMTAsXG4gIH0pO1xuICByZXR1cm4gdGFzaztcbn1cblxuZXhwb3J0IGNsYXNzIFJldHJ5YWJsZUxhbWJkYUludm9rZSBleHRlbmRzIExhbWJkYUludm9rZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBMYW1iZGFJbnZva2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuICAgIGVuYWJsZVRocm90dGxpbmdSZXRyeSh0aGlzKTtcbiAgfVxufSJdfQ==