"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuccessAndFailMachine = void 0;
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const util_1 = require("./util");
class SuccessAndFailMachine {
    constructor(scope, lambdaFunction) {
        let successState = new sfn.Succeed(scope, 'Succeed');
        let failureState = new sfn.Fail(scope, 'Failure');
        let startRsTaskProcedure = new util_1.RetryableLambdaInvoke(scope, 'StartRedshiftStatementAndWaitForCallback', {
            lambdaFunction: lambdaFunction,
            integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
            payload: sfn.TaskInput.fromObject({
                'taskToken': sfn.JsonPath.taskToken,
                'executionArn.$': '$$.Execution.Id',
                'sqlStatement': 'select getdate()',
            }),
            heartbeat: cdk.Duration.seconds(3600),
        });
        startRsTaskProcedure.addCatch(failureState, { errors: ['States.ALL'] });
        let startInvalidRsTaskProcedure = new util_1.RetryableLambdaInvoke(scope, 'StartInvalidRedshiftStatementAndWaitForCallback', {
            lambdaFunction: lambdaFunction,
            integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
            payload: sfn.TaskInput.fromObject({
                'taskToken': sfn.JsonPath.taskToken,
                'executionArn.$': '$$.Execution.Id',
                'sqlStatement': 'select get_date()',
            }),
            heartbeat: cdk.Duration.seconds(3600),
        });
        startRsTaskProcedure.next(startInvalidRsTaskProcedure);
        startInvalidRsTaskProcedure.addCatch(successState, { errors: ['FAILED'] });
        //Completion of startInvalidRsTaskProcedure would be a bug.
        startInvalidRsTaskProcedure.next(failureState);
        this.definition = new sfn.StateMachine(scope, 'ExampleStateMachineRSIntegration', {
            definition: startRsTaskProcedure,
        });
    }
}
exports.SuccessAndFailMachine = SuccessAndFailMachine;
//# sourceMappingURL=data:application/json;base64,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