"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingleSuccessMachine = void 0;
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const util_1 = require("./util");
class SingleSuccessMachine {
    constructor(scope, lambdaFunction) {
        let successState1 = new sfn.Succeed(scope, 'Succeed1');
        let failureState1 = new sfn.Fail(scope, 'Failure1');
        let simpleSuccessfullRsTaskProcedure = new util_1.RetryableLambdaInvoke(scope, 'SimpleSuccessfullRsTaskProcedure', {
            lambdaFunction: lambdaFunction,
            integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
            payload: sfn.TaskInput.fromObject({
                'taskToken': sfn.JsonPath.taskToken,
                'executionArn.$': '$$.Execution.Id',
                'sqlStatement': 'select getdate()',
            }),
            heartbeat: cdk.Duration.seconds(3600),
            resultPath: '$.executionDetails',
        });
        let simpleSuccessfullRsTaskGetResult = new util_1.RetryableLambdaInvoke(scope, 'simpleSuccessfullRsTaskGetResult', {
            lambdaFunction: lambdaFunction,
            payloadResponseOnly: true,
            payload: sfn.TaskInput.fromObject({
                // When using callback the structure is following the Redshift Data Statement Status Change format.
                'statementId': 'LATEST',
                'executionArn.$': '$$.Execution.Id',
                'action': 'getStatementResult',
            }),
            heartbeat: cdk.Duration.seconds(3600),
            resultPath: '$.executionResult',
        });
        simpleSuccessfullRsTaskProcedure.next(simpleSuccessfullRsTaskGetResult);
        simpleSuccessfullRsTaskGetResult.next(successState1);
        simpleSuccessfullRsTaskProcedure.addCatch(failureState1, { errors: ['States.ALL'] });
        this.definition = new sfn.StateMachine(scope, 'SimpleStateMachineSuccessRSCallbackIntegration', {
            definition: simpleSuccessfullRsTaskProcedure,
        });
    }
}
exports.SingleSuccessMachine = SingleSuccessMachine;
//# sourceMappingURL=data:application/json;base64,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