"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingleFailureMachine = void 0;
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const util_1 = require("./util");
class SingleFailureMachine {
    constructor(scope, lambdaFunction) {
        let testFailed = new sfn.Fail(scope, 'testFailed');
        let testSucceeded = new sfn.Succeed(scope, 'testSucceeded');
        let simpleFailurefullRsTaskProcedure = new util_1.RetryableLambdaInvoke(scope, 'SimpleFailureRsTaskProcedure', {
            lambdaFunction: lambdaFunction,
            integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
            payload: sfn.TaskInput.fromObject({
                'taskToken': sfn.JsonPath.taskToken,
                'executionArn.$': '$$.Execution.Id',
                'sqlStatement': 'select get_date()',
            }),
            heartbeat: cdk.Duration.seconds(3600),
        });
        let simpleFailureDescribeTaskProcedure = new util_1.RetryableLambdaInvoke(scope, 'simpleFailureDescribeTaskProcedure', {
            lambdaFunction: lambdaFunction,
            payloadResponseOnly: true,
            payload: sfn.TaskInput.fromObject({
                'statementId': 'LATEST',
                'executionArn.$': '$$.Execution.Id',
                'action': 'describeStatement',
            }),
            heartbeat: cdk.Duration.seconds(3600),
        });
        simpleFailurefullRsTaskProcedure.next(testFailed);
        simpleFailurefullRsTaskProcedure.addCatch(simpleFailureDescribeTaskProcedure, { errors: ['FAILED'] });
        simpleFailurefullRsTaskProcedure.addCatch(testFailed, { errors: ['States.ALL'] });
        simpleFailureDescribeTaskProcedure.next(testSucceeded);
        this.definition = new sfn.StateMachine(scope, 'SimpleFailureRsTaskProcedureCallbackIntegration', {
            definition: simpleFailurefullRsTaskProcedure,
        });
    }
}
exports.SingleFailureMachine = SingleFailureMachine;
//# sourceMappingURL=data:application/json;base64,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