"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParallelNoConcurrencyMachine = void 0;
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const util_1 = require("./util");
class ParallelNoConcurrencyMachine {
    constructor(scope, lambdaFunction) {
        function createSlowSync(_scope, i) {
            let testFail = new sfn.Fail(_scope, `testFail${i}`);
            let successRun = new sfn.Succeed(_scope, `successParallel${i}`);
            let successAlreadyRunning = new sfn.Succeed(_scope, `successAlreadyRunning${i}`);
            return new util_1.RetryableLambdaInvoke(_scope, `startSlowQuery${i}`, {
                lambdaFunction: lambdaFunction,
                integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
                payload: sfn.TaskInput.fromObject({
                    'taskToken': sfn.JsonPath.taskToken,
                    'executionArn.$': '$$.Execution.Id',
                    'sqlStatement': 'select public.f_slow(getdate()::varchar(50), 59)',
                    'action': 'executeSingletonStatement',
                }),
                heartbeat: core_1.Duration.seconds(300),
                resultPath: '$.executionDetails',
            }).addCatch(successAlreadyRunning, { errors: ['ConcurrentExecution'] }).addCatch(testFail, { errors: ['States.Timeout'] }).addCatch(testFail, { errors: ['States.ALL'] }).next(successRun);
        }
        let launchParallelTasks = new sfn.Parallel(scope, 'parallelExecutions', { resultPath: '$.results' });
        for (let i = 0; i < 10; i++) {
            launchParallelTasks.branch(createSlowSync(scope, i.toString()));
        }
        this.definition = new sfn.StateMachine(scope, 'ParallelExecutions', {
            definition: launchParallelTasks,
        });
    }
}
exports.ParallelNoConcurrencyMachine = ParallelNoConcurrencyMachine;
//# sourceMappingURL=data:application/json;base64,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