"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChainedMachine = void 0;
const aws_stepfunctions_1 = require("@aws-cdk/aws-stepfunctions");
const aws_stepfunctions_tasks_1 = require("@aws-cdk/aws-stepfunctions-tasks");
class ChainedMachine {
    constructor(scope) {
        this.scope = scope;
        this.prev = new aws_stepfunctions_1.Succeed(scope, 'chainedTestSuccess');
    }
    /**
     * Add machine to the front of the chained machines such that it is the first chain.
     * @param name
     * @param machine
     */
    push_front(name, machine) {
        let new_task = new aws_stepfunctions_tasks_1.StepFunctionsStartExecution(this.scope, name, {
            integrationPattern: aws_stepfunctions_1.IntegrationPattern.RUN_JOB,
            stateMachine: machine,
        });
        new_task.next(this.prev);
        this.prev = new_task;
    }
    build() {
        return new aws_stepfunctions_1.StateMachine(this.scope, 'chainedMachines', {
            definition: this.prev,
        });
    }
}
exports.ChainedMachine = ChainedMachine;
//# sourceMappingURL=data:application/json;base64,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