import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as kms from '@aws-cdk/aws-kms';
import * as lambda from '@aws-cdk/aws-lambda';
import * as lambdaPython from '@aws-cdk/aws-lambda-python';
import * as sqs from '@aws-cdk/aws-sqs';
import * as cdk from '@aws-cdk/core';
/**
 * The details of the Redshift target in which you will execute SQL statements.
 *
 * @stability stable
 */
export interface RedshiftTargetProps {
    /**
     * The Redshift database user that will execute the Redshift tasks.
     *
     * @stability stable
     */
    readonly dbUser: string;
    /**
     * The Redshift database name in which the SQL statement will be executed.
     *
     * @stability stable
     */
    readonly dbName: string;
    /**
     * The cluster identifier (name) in which the SQL statement will be executed.
     *
     * This is the part of the FQDN up to the
     * first '.'.
     *
     * @stability stable
     */
    readonly clusterIdentifier: string;
}
/**
 * @stability stable
 * @summary The properties for the Construct
 */
export interface SfnRedshiftTaskerProps {
    /**
     * The details of the Redshift target in which you will execute SQL statements.
     *
     * @stability stable
     */
    readonly redshiftTargetProps: RedshiftTargetProps;
    /**
     * Existing instance of SQS queue object, if this is set then the queueProps is ignored.
     *
     * @default - None
     * @stability stable
     */
    readonly existingQueueObj?: sqs.Queue;
    /**
     * User provided props to override the default props for the SQS queue.
     *
     * @default - Default props are used
     * @stability stable
     */
    readonly queueProps?: sqs.QueueProps;
    /**
     * Whether to grant additional permissions to the Lambda function enabling it to purge the SQS queue.
     *
     * @default - "false", disabled by default.
     * @stability stable
     */
    readonly enableQueuePurging?: boolean;
    /**
     * Optional user provided properties for the dead letter queue.
     *
     * @default - Default props are used
     * @stability stable
     */
    readonly deadLetterQueueProps?: sqs.QueueProps;
    /**
     * Whether to deploy a secondary queue to be used as a dead letter queue.
     *
     * @default - true.
     * @stability stable
     */
    readonly deployDeadLetterQueue?: boolean;
    /**
     * The number of times a message can be unsuccessfully dequeued before being moved to the dead-letter queue.
     *
     * @default - required field if deployDeadLetterQueue=true.
     * @stability stable
     */
    readonly maxReceiveCount?: number;
    /**
     * Use a KMS Key, either managed by this CDK app, or imported.
     *
     * If importing an encryption key, it must be specified in
     * the encryptionKey property for this construct.
     *
     * @default - true (encryption enabled, managed by this CDK app).
     * @stability stable
     */
    readonly enableEncryptionWithCustomerManagedKey?: boolean;
    /**
     * An optional, imported encryption key to encrypt the SQS queue, and SNS Topic.
     *
     * @default - not specified.
     * @stability stable
     */
    readonly encryptionKey?: kms.Key;
    /**
     * Optional user-provided props to override the default props for the encryption key.
     *
     * @default - Default props are used.
     * @stability stable
     */
    readonly encryptionKeyProps?: kms.KeyProps;
    /**
     * Existing instance of Lambda Function object that starts execution, if this is set then the lambdaFunctionProps is ignored.
     *
     * @default - None
     * @stability stable
     */
    readonly starterExistingLambdaObj?: lambda.Function;
    /**
     * User provided props to override the default props for the Lambda function that starts execution.
     *
     * @default - Default props are used
     * @stability stable
     */
    readonly starterLambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Existing instance of Lambda Function object that completes execution, if this is set then the completerLambdaFunctionProps is ignored.
     *
     * @default - None
     * @stability stable
     */
    readonly completerExistingLambdaObj?: lambda.Function;
    /**
     * User provided props to override the default props for the Lambda function that completes execution.
     *
     * If
     * completerExistingLambdaObj and this is omitted the Lambda function for starting executions is re-used.
     *
     * @default - Re-use starter Lambda function.
     * @stability stable
     */
    readonly completerLambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Optional user provided props to override the default props.
     *
     * @default - Default props are used
     * @stability stable
     */
    readonly dynamoTableProps?: dynamodb.TableProps;
    /**
     * Existing instance of DynamoDB table object, If this is set then the dynamoTableProps is ignored.
     *
     * @default - None
     * @stability stable
     */
    readonly existingTableObj?: dynamodb.Table;
    /**
     * Optional table permissions to grant to the Lambda function.
     *
     * One of the following may be specified: "All", "Read", "ReadWrite", "Write".
     *
     * @default - Read/write access is given to the Lambda function if no value is specified.
     * @stability stable
     */
    readonly tablePermissions?: string;
    /**
     * Optional user provided props to override the shared layer.
     *
     * @default - None
     * @stability stable
     */
    readonly pythonLayerVersionProps?: lambdaPython.PythonLayerVersionProps;
    /**
     * Optional log level to be used for Lambda functions.
     *
     * @default - INFO
     * @stability stable
     */
    readonly logLevel?: string;
    /**
     * Setup the infrastructure to support the step function callback mechanism.
     *
     * If you never want to trigger Redshift
     * statements from a step function then set this to false to avoid creating an SQS queue and the required polling.
     * If you already have an SfnRedshiftTasker setup you should disable this as well (e.g. adding function for another cluster/database/username).
     *
     * @default - true
     * @stability stable
     */
    readonly createCallbackInfra?: boolean;
    /**
     * The ARN of a lambda layer containing the AWS Lambda powertools.
     *
     * @default - Not provided then an application will be created from the serverless application registry to get the layer. If you plan to create
     * multiple SfnRedshiftTaskers then you can reuse the powertoolsArn from the first instance.
     * @stability stable
     */
    readonly powertoolsArn?: string;
}
/**
 * Create infrastructure to easily create tasks in a Stepfunction that run a SQL statement on a Redshift cluster and await completion.
 *
 * @stability stable
 */
export declare class SfnRedshiftTasker extends cdk.Construct {
    /**
     * The Lambda function which can be used from a Step function task to invoke a SQL statement.
     *
     * @stability stable
     */
    readonly lambdaFunction: lambda.Function;
    /**
     * A state table that tracks the Redshift statements being executed.
     *
     * @stability stable
     */
    readonly trackingTable: dynamodb.Table;
    /**
     * The ARN of a layer hosting AWS Lambda powertools.
     *
     * @stability stable
     */
    readonly powertoolsArn: string;
    /**
     * Creates the infrastructure to allow stepfunction tasks that execute SQL commands and await their completion.
     *
     * @param scope Scope within where this infrastructure is created.
     * @param id Identifier to name this building block.
     * @param props The configuration properties of the infrastructure.
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: SfnRedshiftTaskerProps);
}
