# -*- coding: utf-8 -*-
#
# PyORBIT documentation build configuration file, created by
# sphinx-quickstart on Sat Dec 16 17:20:15 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
import matplotlib
matplotlib.use('agg')

sys.path.insert(0, os.path.abspath('../'))
import pyorbit


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['myst_parser',
    "sphinx.ext.autosummary",
    'sphinx.ext.autodoc',
    'sphinx.ext.mathjax',
    "sphinx.ext.viewcode",
    'sphinx.ext.napoleon']

myst_enable_extensions = ["dollarmath", "colon_fence"]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
#source_suffix = ['.rst', '.md']
source_suffix = {
    ".rst": "restructuredtext",
    ".ipynb": "myst-nb",
}
#source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'PyORBIT'
copyright = u'2016-2022, Luca Malavolta'
author = u'Luca Malavolta'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '.'.join(pyorbit.__version__.split('.')[:-1])
# The full version, including alpha/beta/rc tags.
release = pyorbit.__version__

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_book_theme'
html_logo = "_static/PyORBIT_logo_transp.png"
html_title = "PyORBIT"

html_copy_source = True
html_show_sourcelink = True
html_sourcelink_suffix = ""

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}
html_theme_options = {
    "path_to_docs": "docs",
    "repository_url": "https://github.com/LucaMalavolta/PyORBIT",
    "repository_branch": "main",
    "use_repository_button": True,
    "use_issues_button": True,
    #"home_page_in_toc": True,
    "show_navbar_depth": 3,
    "logo_only": True,
    #"show_related": True
}


# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']


# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#

#html_sidebars = {
#    '**': ['sidebar-logo.html','search-field.html',
#        'globaltoc.html',
#        'relations.html',  # needs 'show_related': True theme option to display
##        #'searchbox.html',
#    ]
#}


# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'PyORBITdoc'

