import setuptools, sys, protbuilder as prot
exec(open('src/prot/__version__.py').read())
ver = prot.VersionString(__version__)
doUpdate = True
doInstall = True
upgrade = False
if '--upgrade' in sys.argv or doUpdate:
	upgrade = True
	ver = ver.upgrade()
	try:
		sys.argv.remove('--upgrade')
	except: pass
print('building prot v' + ver + '...')
if upgrade:
	f = open('src/prot/__version__.py', 'w')
	f.write('__version__ = '+repr(ver))
	f.flush()
	f.close()
if len(sys.argv) <= 1:
	if doInstall:
		sys.argv += ['install']
	sys.argv += ['sdist', 'bdist_wheel', 'clean']

setuptools.setup(
	name="prot", version=ver,
	description='A Simple Tool That Contains Advance Functions.',
	long_description=open('README.md').read(), long_description_content_type='text/markdown',
	author="Alireza Poodineh", author_email='pa789892@gmail.com', url='https://www.pypi.org/user/Ali_p1986',
	packages=setuptools.find_packages(where="src"), package_dir={"": "src"},
	zip_safe=False,
	entry_points={"console_scripts": ["prot=prot:prot", "prot.pip=prot.pip:pip"]})