# Утилиты для работы с системой импорт/экспорта классификаторов в едином формате.
## Модуль table_to_file предлагает набор функций для импорта/экспорта таблиц из БД в формат json и обратно.
Структура json'а описана в [документации к протоколу передачи классификаторов](https://docs.google.com/document/d/1XU7UtD5oosbDpONwQqgiNW-qEnEAXwVVloymeKhN6uA/edit?usp=sharing) см раздел "2. Классификатор".

Протокол и структура хранения классификаторов в json, как его составная часть, разрабатываются как общесистемные решения для проектов Лаборатории.

### Ограничения: 
* Последовательности (Sequences) должны быть в той же схеме, что и таблица их использующая

### Интерфейс взаимодействия с модулем.
Модуль представляет API состоящее из 4х методов:
#### `export_table_to_dict` - Преобразует таблицу из бд в словарь содержащий структуру и данные таблицы.
    
Параметры:
* `table_name` - Имя таблицы в базе данных. 
* `dbname` - Имя базы данных. 
* `user` - Пользователь БД. 
* `password` - Пароль пользователя. 
* `host` - Адрес сервера баз данных. 
* `port` - Порт сервера баз данных.
  
Возвращаемое значение:
* Словарь со структурой и данными таблицы. Структура словаря соответствует описанной структуре классификатора в документации к протоколу.

#### `import_table_from_dict` - Импортирует данные из словаря подходящей структуры в базу данных. 
Если такой таблицы нет в БД то таблица будет создана и заполнена данными из словаря. В случае несоответствия структуры описанной в словаре таблице существующей в базе данных поднимает исключение ValueError.
  
Параметры:
* `table` - Структура таблицы и данные для импорта в виде словаря. 
* `table_name` - Имя таблицы в базе данных. 
* `dbname` - Имя базы данных. 
* `user` - Пользователь БД. 
* `password` - Пароль пользователя. 
* `host` - Адрес сервера баз данных.
* `port` - Порт сервера баз данных.
* `foreign_tables_mapping` Словарь соответствия имен связанных таблиц в словаре и в базе данных. Ключи и значения словаря кортежи состоящие из пары значений ('имя_схемы', 'имя_таблицы') ключ - имена в структуре данных, значения - имена в базе данных. Пример {('имя_схемы_в_структуре', 'имя_таблицы_в_структуре'): ('имя_схемы_в_бд', 'имя_таблицы_в_бд')}
  
Возвращаемое значение:
* нет
    
#### `dict_as_json` - Сохраняет словарь с таблицей в виде json в BytesIO объект

Параметры:
* `table` - Словарь содержащий структуру таблицы для сохранения в json формате.
  
Возвращаемое значение:
* Объект BytesIO содержащий "файл" с переданной структурой в json формате.

#### `json_to_table` - Принимает или путь к файлу с json или BytesIO объект из которого 
 
Параметры:
* `data_source` - Имя файла в системе или объект BytesIO содержащий в себе json соответствующего формата.
* `table_name` - Имя таблицы в базе данных. 
* `dbname` - Имя базы данных. 
* `user` - Пользователь БД.
* `password` - Пароль пользователя. 
* `host` - Адрес сервера баз данных.
* `port` - Порт сервера баз данных.
* `foreign_tables_mapping` Словарь соответствия имен связанных таблиц в словаре и в базе данных.
  
Возвращаемое значение: 
* нет

### Установка и использование

Этот проект использует [uv](https://github.com/astral-sh/uv) для управления зависимостями.

#### Установка зависимостей
```bash
uv sync
```

#### Активация виртуального окружения
```bash
uv shell
```

#### Установка дополнительных зависимостей для разработки
```bash
uv sync --group dev
```

### Запуск тестов.

Для запуска тестов необходимо установленный в системе Docker.
Тесты запускаются из директории проекта командой 
```bash
docker-compose -f docker-compose.pytest.yml run --build --rm tests
```
Также для запуска можно использовать вариант с двумя последовательными командами
```bash
docker-compose -f docker-compose.pytest.yml build --no-cache
docker-compose -f docker-compose.pytest.yml run --rm tests
```
После тестов желательно удалить созданные контейнеры 
```bash
docker-compose -f docker-compose.pytest.yml down -v
```
Альтернатива если в системе установлен make [Make for Windows](https://gnuwin32.sourceforge.net/packages/make.htm), [How to install and use "make" in Windows?](https://stackoverflow.com/questions/32127524/how-to-install-and-use-make-in-windows)
```bash
make test
```
### Последние зменения
### [0.3.0] - 2025-12-03
#### Добавлены:
- Модуль flk, содержащий класс FLKValidator с методом validate_classifier() для проведения форматно-логического контроля json файла перед его импортированием: обеспечивает проверку чтения данных, проверку схемы json, проверку соответствия данных структуре, проверку соответствия структур из json и из базы( допуская разные наименования таблицы).
- Возвращаемый после прохождения флк результат в виде json в формате:
```bash
{
  "ready_for_import": "bool",
  "receipt": {
    "id": "string",
    "msg_type": "string",
    "note": "string",
    "payload": {
      "comments": [
        "string"
      ],
      "data_and_structure_check": "bool",
      "error_details": "string",
      "flk_success": "bool",
      "parent_msg_id": "string",
      "proto_check": "bool",
      "read_check": "bool",
      "schema_check": "bool",
      "statistics": {
        "columns_count": 0,
        "records_count": 0,
        "table_exists": "bool",
        "table_name": "string"
    },
    "structure_check": "bool",
    "timestamp": "string"
  },
  "protocol_version": 0,
  "system_id": "string",
  "timestamp": "string"
}
```

### Полная история изменений
Смотрите полную историю всех изменений в файле [CHANGELOG.md](CHANGELOG.md) или [на странице проекта](https://git.lab.nexus/military_developer/unified_reference_book/-/blob/main/CHANGELOG.md)
