/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeoUtils {
    private static final Logger logger = LoggerFactory.getLogger(GeoUtils.class);
    static final double EARTH_EQUATORIAL_RADIUS_METERS = 6378100.0;
    static final double EARTH_EQUATORIAL_CIRCUMFERENCE_METERS = 4.007478420772212E7;

    public static double calculateAreaOfGPSPolygonOnEarthInSquareMeters(List<LatLong> latLongs) {
        if (latLongs.size() < 3) {
            return 0.0;
        }
        ArrayList<Double> listY = new ArrayList<Double>();
        ArrayList<Double> listX = new ArrayList<Double>();
        double latitudeRef = latLongs.get(0).latitude;
        double longitudeRef = latLongs.get(0).longitude;
        for (int i = 1; i < latLongs.size(); ++i) {
            double latitude = latLongs.get(i).latitude;
            double longitude = latLongs.get(i).longitude;
            listY.add(GeoUtils.calculateYSegment(latitudeRef, latitude));
            listX.add(GeoUtils.calculateXSegment(longitudeRef, longitude, latitude));
        }
        double areasSum = 0.0;
        for (int i = 1; i < listX.size(); ++i) {
            areasSum += GeoUtils.calculateAreaInSquareMeters((Double)listX.get(i - 1), (Double)listX.get(i), (Double)listY.get(i - 1), (Double)listY.get(i)).doubleValue();
        }
        return Math.abs(areasSum);
    }

    public static double calculateDistance(List<LatLong> points) {
        double totalDistance = 0.0;
        if (points.size() >= 2) {
            for (int i = 1; i < points.size(); ++i) {
                LatLong p1 = points.get(i - 1);
                LatLong p2 = points.get(i);
                double distance = GeoUtils.distanceBetween(p1, p2);
                GeoUtils.logDistance(p1, p2, distance, totalDistance += distance);
            }
        }
        return totalDistance;
    }

    private static void logDistance(LatLong p1, LatLong p2, double distance, double totalDistance) {
        logger.trace("\t{}\t{}\t{}\t{}\t{}\t{}", p1.latitude, p1.longitude, p2.latitude, p2.longitude, distance, totalDistance);
    }

    private static Double calculateAreaInSquareMeters(double x1, double x2, double y1, double y2) {
        return (y1 * x2 - x1 * y2) / 2.0;
    }

    private static double calculateYSegment(double latitudeRef, double latitude) {
        return (latitude - latitudeRef) * 4.007478420772212E7 / 360.0;
    }

    private static double calculateXSegment(double longitudeRef, double longitude, double latitude) {
        return (longitude - longitudeRef) * 4.007478420772212E7 * Math.cos(Math.toRadians(latitude)) / 360.0;
    }

    private static double distanceBetween(LatLong p1, LatLong p2) {
        double \u0394\u03bb = Math.toRadians(p1.longitude - p2.longitude);
        double \u03c61 = Math.toRadians(p1.latitude);
        double \u03c62 = Math.toRadians(p2.latitude);
        return Math.acos(Math.sin(\u03c61) * Math.sin(\u03c62) + Math.cos(\u03c61) * Math.cos(\u03c62) * Math.cos(\u0394\u03bb)) * 6378100.0;
    }

    public static class LatLong {
        private final double latitude;
        private final double longitude;

        public LatLong(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }
    }
}

