/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.actions.recordaudio;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.actions.Action;
import org.javarosa.core.model.actions.recordaudio.RecordAudioActions;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class RecordAudioAction
extends Action {
    private TreeReference targetReference;
    private String quality;

    public RecordAudioAction(TreeReference targetReference, String quality) {
        super("recordaudio");
        this.targetReference = targetReference;
        this.quality = quality;
    }

    public RecordAudioAction() {
    }

    @Override
    public TreeReference processAction(FormDef model, TreeReference contextRef) {
        TreeReference contextualizedTargetReference;
        TreeReference treeReference = contextualizedTargetReference = contextRef == null ? this.targetReference : this.targetReference.contextualize(contextRef);
        if (RecordAudioActions.getRecordAudioListener() != null) {
            RecordAudioActions.getRecordAudioListener().recordAudioTriggered(contextualizedTargetReference, this.quality);
        }
        return contextualizedTargetReference;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        super.readExternal(in, pf);
        this.targetReference = (TreeReference)ExtUtil.read(in, new ExtWrapNullable(TreeReference.class), pf);
        this.quality = (String)ExtUtil.read(in, new ExtWrapNullable(String.class), pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        super.writeExternal(out);
        ExtUtil.write(out, new ExtWrapNullable(this.targetReference));
        ExtUtil.write(out, new ExtWrapNullable(this.quality));
    }
}

