/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.List;
import java.util.Set;
import org.javarosa.core.model.condition.Condition;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.debug.EvaluationResult;

public final class QuickTriggerable {
    private final Triggerable triggerable;
    private final int hashCode;

    private QuickTriggerable(Triggerable triggerable, int hashCode) {
        this.triggerable = triggerable;
        this.hashCode = hashCode;
    }

    static QuickTriggerable of(Triggerable triggerable) {
        return new QuickTriggerable(triggerable, System.identityHashCode(triggerable));
    }

    public boolean isCondition() {
        return this.triggerable instanceof Condition;
    }

    boolean isRecalculate() {
        return this.triggerable instanceof Recalculate;
    }

    public List<EvaluationResult> apply(FormInstance mainInstance, EvaluationContext ec, TreeReference qualified) {
        return this.triggerable.apply(mainInstance, ec, qualified);
    }

    Set<TreeReference> getTargets() {
        return this.triggerable.getTargets();
    }

    public boolean contains(Triggerable triggerable) {
        return this.triggerable.equals(triggerable);
    }

    void intersectContextWith(Triggerable other) {
        this.triggerable.intersectContextWith(other);
    }

    void setImmediateCascades(Set<QuickTriggerable> deps) {
        this.triggerable.setImmediateCascades(deps);
    }

    public boolean canCascade() {
        return this.triggerable.canCascade();
    }

    boolean isCascadingToChildren() {
        return this.triggerable.isCascadingToChildren();
    }

    Set<QuickTriggerable> getImmediateCascades() {
        return this.triggerable.getImmediateCascades();
    }

    public Triggerable getTriggerable() {
        return this.triggerable;
    }

    public Object eval(FormInstance mainInstance, EvaluationContext evaluationContext) {
        return this.triggerable.eval(mainInstance, evaluationContext);
    }

    public TreeReference getContext() {
        return this.triggerable.getContext();
    }

    public TreeReference getOriginalContext() {
        return this.triggerable.getOriginalContext();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QuickTriggerable)) {
            return false;
        }
        return this.triggerable == ((QuickTriggerable)obj).triggerable;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.triggerable.toString();
    }
}

