# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dbt_coverage']

package_data = \
{'': ['*']}

install_requires = \
['typer>=0.4.0,<0.5.0']

entry_points = \
{'console_scripts': ['dbt-coverage = dbt_coverage.__init__:app']}

setup_kwargs = {
    'name': 'dbt-coverage',
    'version': '0.1.3',
    'description': 'A package for computing coverage of dbt-managed data warehouses',
    'long_description': '# dbt-coverage\n\nA CLI library with Python backend for computing docs and test coverage of dbt\nmanaged data warehouses.\n\n## Installation\n\n```\npip install dbt-coverage\n```\n\n## Usage\n\n`dbt-coverage` comes with two basic commands: `compute` and `compare`. The\ndocumentation for the individual commands can be shown by using the `--help`\noption.\n\n### Compute\n\nCompute coverage from `target/catalog.json` and `target/manifest.json` files\nfound in a dbt project, e.g.\n[jaffle_shop](https://github.com/dbt-labs/jaffle_shop). You need to select\ndocumentation or test coverage by using the respective CLI argument.\n\n```\n$ cd jaffle_shop\n$ dbt run  # Materialize models\n$ dbt docs generate  # Generate catalog.json and manifest.json\n$ dbt-coverage compute doc  # Compute doc coverage, print it and write it to coverage.json file\n\n# Coverage report\n# =====================================================================\n# customers                                              6/7      85.7%\n# orders                                                 9/9     100.0%\n# raw_customers                                          0/3       0.0%\n# raw_orders                                             0/4       0.0%\n# raw_payments                                           0/4       0.0%\n# stg_customers                                          0/3       0.0%\n# stg_orders                                             0/4       0.0%\n# stg_payments                                           0/4       0.0%\n# =====================================================================\n# Total                                                 15/38     39.5%\n\n$ dbt-coverage compute test  # Compute test coverage, print it and write it to coverage.json file\n\n# Coverage report\n# =====================================================================\n# customers                                              1/7      14.3%\n# orders                                                 8/9      88.9%\n# raw_customers                                          0/3       0.0%\n# raw_orders                                             0/4       0.0%\n# raw_payments                                           0/4       0.0%\n# stg_customers                                          1/3      33.3%\n# stg_orders                                             2/4      50.0%\n# stg_payments                                           2/4      50.0%\n# =====================================================================\n# Total                                                 14/38     36.8%\n```\n\n### Compare\n\nCompare two `coverage.json` files generated by the `compute` command. This is\nuseful to ensure that the coverage does not drop while making changes to the\nproject.\n\n```\n$ dbt-coverage compare coverage-after.json coverage-before.json\n\n# Coverage delta summary\n#               before     after            +/-\n# =============================================\n# Coverage      39.47%    38.46%         -1.01%\n# =============================================\n# Tables             8         8          +0/+0\n# Columns           38        39          +1/+0\n# =============================================\n# Hits              15        15          +0/+0\n# Misses            23        24          +1/+0\n# =============================================\n\n# New misses\n# ==============================================================\n# Catalog              15/38   (39.47%)  ->    15/39   (38.46%) \n# ==============================================================\n# - customers           6/7    (85.71%)  ->     6/8    (75.00%) \n# -- new_col            -/-       (-)    ->     0/1     (0.00%) \n# ==============================================================\n```\n\n### Combined use-case\n\n```\n$ cd my-dbt-project\n\n$ dbt run  # Materialize models\n$ dbt docs generate  # Generate catalog.json and manifest.json\n$ dbt-coverage compute doc --cov-report before.json --cov-fail-under 0.5 # Fail if coverage is lower than 50%\n\n# Make changes to the dbt project, e.g. add some columns to the DWH, document some columns, etc.\n\n$ dbt docs generate\n$ dbt-coverage compute doc --cov-report after.json --cov-fail-compare before.json  # Fail if the current coverage is lower than coverage in before.json\n$ dbt-coverage compare after.json before.json  # Generate a detailed coverage delta report\n```\n\n## Related packaged\n\nhttps://github.com/mikaelene/dbt-test-coverage\n\n## License\n\nLicensed under the MIT license (see [LICENSE.md](LICENSE.md) file for more\ndetails).',
    'author': 'Andrej Švec',
    'author_email': 'asvec@slido.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
