#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [ 
    'pyspark>=3.0'
]

test_requirements = [ ]

setup(
    author="Izhar Firdaus",
    author_email='kagesenshi.87@gmail.com',
    python_requires='>=3.6',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Apache Software License',
        'Natural Language :: English',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
    description="Standard data loaders for Apache Spark",
    entry_points={
        'console_scripts': [
            'full_ingestion=spark_dataloader.cli.full_ingestion:main',
            'incremental_append_ingestion=spark_dataloader.cli.incremental_append_ingestion:main',
            'incremental_merge_ingestion=spark_dataloader.cli.incremental_merge_ingestion:main',
        ],
    },
    install_requires=requirements,
    license="Apache Software License 2.0",
    long_description=readme + '\n\n' + history,
    include_package_data=True,
    keywords='spark_dataloader',
    name='spark_dataloader',
    packages=find_packages(include=['spark_dataloader', 'spark_dataloader.*']),
    test_suite='tests',
    tests_require=test_requirements,
    url='https://gitlab.com/kagesenshi/spark_dataloader',
    version='0.1.2',
    zip_safe=False,
)
