###########################################################################
# Copyright (c), The AiiDA team. All rights reserved.                     #
# This file is part of the AiiDA code.                                    #
#                                                                         #
# The code is hosted on GitHub at https://github.com/aiidateam/aiida-core #
# For further information on the license, see the LICENSE.txt file        #
# For further information please visit http://www.aiida.net               #
###########################################################################
"""Module with `Node` sub classes for array based data structures."""

# AUTO-GENERATED

# fmt: off

from .array import *
from .bands import *
from .kpoints import *
from .projection import *
from .trajectory import *
from .xy import *

__all__ = (
    'ArrayData',
    'BandsData',
    'KpointsData',
    'ProjectionData',
    'TrajectoryData',
    'XyData',
    'find_bandgap',
)

# fmt: on
