# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['checkpasswords', 'checkpasswords.io']

package_data = \
{'': ['*']}

install_requires = \
['pass-import>=3.2,<4', 'rich>=12.2.0,<13', 'zxcvbn-python>=4.4.24,<5']

entry_points = \
{'console_scripts': ['CheckPasswords = checkpasswords:cli']}

setup_kwargs = {
    'name': 'checkpasswords',
    'version': '2022',
    'description': 'CheckPasswords uses pass_import to read a password manager source file to check for duplicate passwords; check for weak passwords; identify http sites; list available 2fa options; list emails',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/CheckPasswords.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/CheckPasswords.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/CheckPasswords.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/CheckPasswords.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/CheckPasswords.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/CheckPasswords.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/CheckPasswords.svg?style=for-the-badge)](https://pypistats.org/packages/CheckPasswords)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fcheckpasswords)](https://pepy.tech/project/CheckPasswords)\n[![PyPI Version](https://img.shields.io/pypi/v/CheckPasswords.svg?style=for-the-badge)](https://pypi.org/project/CheckPasswords)\n\n<!-- omit in toc -->\n# CheckPasswords\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nUses pass_import to read a password manager source file storing raw data and infers data such as:\n\n- zxcvbnScore\n- isPasswordDuplicate\n- passwordPrint\n- isHttp\n- isMfaAvailable\n- isMfaEnabled\n\nUsed to:\n\n- check for duplicate passwords\n- check for weak passwords\n- identify http sites\n- list available 2fa options using data from https://2fa.directory/\n- list emails to submit to HIBP or similar\n\n<!-- omit in toc -->\n## Table of Contents\n\n- [Using](#using)\n\t- [CLI Help](#cli-help)\n\t- [Example Output](#example-output)\n- [Documentation](#documentation)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Using\n\n### CLI Help\n\n```txt\nusage: __main__.py [-h] [--output-format OUTPUT_FORMAT] [--input-format INPUT_FORMAT] [--file FILE] [--no-colour]\n                   credentials\n\ncheckpasswords: Uses pass_import to read a password manager source file storing raw\ndata and infers data such as:\n\n- zxcvbnScore\n- isPasswordDuplicate\n- passwordPrint\n- isHttp\n- isMfaAvailable\n- isMfaEnabled\n\nUsed to:\n\n- check for duplicate passwords\n- check for weak passwords\n- identify http sites\n- list available 2fa options using data from https://2fa.directory/\n- list emails to submit to HIBP or similar\n\npositional arguments:\n  credentials           Credentials/ passwords file to check\n\noptions:\n  -h, --help            show this help message and exit\n  --output-format OUTPUT_FORMAT, -o OUTPUT_FORMAT\n                        Output format. One of [\'ansi\', \'plain\', \'markdown\', \'json\', \'raw\', \'raw-csv\']. default=ansi\n  --input-format INPUT_FORMAT, -i INPUT_FORMAT\n                        Input format. One of [\'1password\', \'aegis\', \'andotp\', \'apple-keychain\', \'bitwarden\', \'blur\', \'buttercup\', \'chrome\', \'clipperz\', \'csv\', \'dashlane\', \'encryptr\', \'enpass\', \'firefox\', \'fpm\', \'freeotp+\', \'gnome\', \'gnome-auth\', \'gopass\', \'gorilla\', \'kedpm\', \'keepass\', \'keepassx\', \'keepassx2\', \'keepassxc\', \'keeper\', \'lastpass\', \'myki\', \'network-manager\', \'padlock\', \'pass\', \'passman\', \'passpack\', \'passpie\', \'pwsafe\', \'revelation\', \'roboform\', \'saferpass\', \'upm\', \'zoho\']\n  --file FILE, -f FILE  Filename to write to (omit for stdout)\n  --no-colour, -z       No ANSI colours\n```\n\n### Example Output\n\n```txt\n\n                Summary\n┏━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━┓\n┃ Issue               ┃ No. Instances ┃\n┡━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━┩\n│ Duplicate Passwords │ 2             │\n│ Weak Passwords      │ 9             │\n│ HTTP Sites          │ 9             │\n│ Enable 2FA          │ 16            │\n│ Emails              │ 17            │\n└─────────────────────┴───────────────┘\n\n...\n```\n\n## Documentation\n\nA high-level overview of how the documentation is organized organized will help you know\nwhere to look for certain things:\n\n<!--\n- [Tutorials](/documentation/tutorials) take you by the hand through a series of steps to get\n  started using the software. Start here if you’re new.\n-->\n- The [Technical Reference](/documentation/reference) documents APIs and other aspects of the\n  machinery. This documentation describes how to use the classes and functions at a lower level\n  and assume that you have a good high-level understanding of the software.\n<!--\n- The [Help](/documentation/help) guide provides a starting point and outlines common issues that you\n  may have.\n-->\n\n## Install With PIP\n\n```python\npip install CheckPasswords\n```\n\nHead to https://pypi.org/project/CheckPasswords/ for more info\n\n## Language information\n\n### Built for\n\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\n\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\n\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/CheckPasswords\n\t```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n\n### Licence\n\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\n\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\n\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\n\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\n\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\n\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\n\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/CheckPasswords',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
