#######################################################
#
# Takv.py
# Python implementation of the Class Takv
# Generated by Enterprise Architect
# Created on:      11-Feb-2020 11:08:09 AM
# Original author: Corvo
#
#######################################################
from FreeTAKServer.model.FTSModelVariables.TakvVariables import TakvVariables as vars

class Takv:

# default constructor
  def __init__(self):
    # the version of TAK running on the device
    self.version = None
    # the variant of TAK
    self.platform = None
    # type of physical device
    self.device = None
    # the operating system running TAK
    self.os = None

  @staticmethod
  def connection(VERSION = vars.connection().VERSION, PLATFORM = vars.connection().PLATFORM,
                 DEVICE = vars.connection().DEVICE, OS = vars.connection().OS):

    takv = Takv()
    takv.setversion(VERSION)
    takv.setplatform(PLATFORM)
    takv.setos(OS)
    takv.setdevice(DEVICE)
    return takv

  @staticmethod
  def UserUpdate(DEVICE=vars.UserUpdate().device, PLATFORM=vars.UserUpdate().platform, OS=vars.UserUpdate().os,
                 VERSION=vars.UserUpdate().version):
    takv = Takv()
    takv.setdevice(DEVICE)
    takv.setplatform(PLATFORM)
    takv.setos(OS)
    takv.setversion(VERSION)
    return takv

    # os getter
  def getos(self):
    return self.os

    # os setter
  def setos(self,os=0):
    self.os=os


    # version getter
  def getversion(self):
    return self.version

    # version setter
  def setversion(self, version=0):
    self.version=version


  def getplatform(self):
      return self.platform

    # platform setter
  def setplatform(self, platform=0):
      self.platform=platform

  # device getter
  def getdevice(self):
    return self.device

  # device setter
  def setdevice(self, device=0):
    self.device=device
