import { Repository, RepositoryProps } from '@aws-cdk/aws-ecr';
import { Rule } from '@aws-cdk/aws-events';
import { ITopic } from '@aws-cdk/aws-sns';
import { Construct } from '@aws-cdk/core';
export interface OnFindingOptions {
    readonly alarmTopic: ITopic;
    readonly severity: Severity;
    /**
     * Only watch changes to the image tags specified.
     * Leave it undefined to watch the full repository.
     *
     * @default - Watch the changes to the repository with all image tags
     */
    readonly imageTags?: string[];
}
export interface ImageRepositoryProps extends RepositoryProps {
    /**
     * If a repository contains images, forces the deletion during stack deletion.
     *
     * @default false
     */
    readonly forceDelete?: boolean;
}
export declare class ImageRepository extends Repository {
    constructor(scope: Construct, id: string, props?: ImageRepositoryProps);
    onFinding(id: string, options: OnFindingOptions): Rule;
}
export declare enum Severity {
    CRITICAL = "CRITICAL",
    HIGH = "HIGH",
    MEDIUM = "MEDIUM",
    LOW = "LOW",
    INFORMATIONAL = "INFORMATIONAL",
    UNDEFINED = "UNDEFINED"
}
