# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class OriginCA(object):

    def __init__(self, id=None, certificate=None, hostnames=None, expires_on=None, request_type=None, requested_validity=None, csr=None):
        """
        :param id: (Optional) The x509 serial number of the Origin CA certificate
        :param certificate: (Optional) The Origin CA certificate. Will be newline-encoded.
        :param hostnames: (Optional) Array of hostnames or wildcard names (e.g., *.example.com) bound to the certificate
        :param expires_on: (Optional) When the certificate will expire
        :param request_type: (Optional) Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa), or "keyless-certificate" (for Keyless SSL servers)
        :param requested_validity: (Optional) The number of days for which the certificate should be valid
        :param csr: (Optional) The Certificate Signing Request (CSR). Must be newline-encoded.
        """

        self.id = id
        self.certificate = certificate
        self.hostnames = hostnames
        self.expires_on = expires_on
        self.request_type = request_type
        self.requested_validity = requested_validity
        self.csr = csr
