# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class ForwardRuleSpec(object):

    def __init__(self, protocol, port, algorithm, originType, originPort, serviceIp=None, serviceIps=None, originAddr=None, onlineAddr=None, originDomain=None):
        """
        :param protocol:  协议: TCP 或者 UDP
        :param serviceIp: (Optional) 高防 IP, serviceIps 为空时生效
        :param serviceIps: (Optional) 高防 IP 列表, 不为空时忽略 serviceIp, 传多个时后台会在高防IP封禁后随机切换其他未封禁的IP
        :param port:  端口号, 取值范围[1, 65535]
        :param algorithm:  转发规则. <br>- wrr: 带权重的轮询<br>- rr:  不带权重的轮询<br>- sh:  源地址hash
        :param originType:  回源类型: A 或者 CNAME
        :param originAddr: (Optional) 
        :param onlineAddr: (Optional) 备用的回源地址列表, 可以配置为一个域名或者多个 ip 地址
        :param originDomain: (Optional) 回源域名
        :param originPort:  回源端口号, 取值范围[1, 65535]
        """

        self.protocol = protocol
        self.serviceIp = serviceIp
        self.serviceIps = serviceIps
        self.port = port
        self.algorithm = algorithm
        self.originType = originType
        self.originAddr = originAddr
        self.onlineAddr = onlineAddr
        self.originDomain = originDomain
        self.originPort = originPort
