# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DeployAppRequest(JDCloudRequest):
    """
    部署APP应用
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(DeployAppRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/hardwareId/{hardwareId}/os/{osId}/edgeApp:deployApp', 'POST', header, version)
        self.parameters = parameters


class DeployAppParameters(object):

    def __init__(self, instanceId, regionId, hardwareId, osId, appName, appVersion, edgeName, privileged, appType, useHost, cpuShares, memoryLimit, restartPolicy, deployAppStatus, ):
        """
        :param instanceId: 设备归属的实例ID
        :param regionId: 设备归属的实例所在区域
        :param hardwareId: 硬件版本
        :param osId: OSID
        :param appName: App内部名称
        :param appVersion: App版本
        :param edgeName: edge名称
        :param privileged: 是否特权模式运行(0-否 1-是)
        :param appType: App类型(1-设备服务 2-边缘应用)
        :param useHost: 是否使用Edge系统的Host配置(0-否 1-是)
        :param cpuShares: CPU权重（低-128 中-256 高-512）
        :param memoryLimit: 内存限制（0-无限 低-128 中-256 高-512）
        :param restartPolicy: 重启策略(0-never 1-always 2-onFailure)
        :param deployAppStatus: 部署APP状态(3-更新 其余都是安装)
        """

        self.instanceId = instanceId
        self.regionId = regionId
        self.hardwareId = hardwareId
        self.osId = osId
        self.appName = appName
        self.appVersion = appVersion
        self.edgeName = edgeName
        self.env = None
        self.privileged = privileged
        self.volume = None
        self.appType = appType
        self.useHost = useHost
        self.cpuShares = cpuShares
        self.memoryLimit = memoryLimit
        self.restartPolicy = restartPolicy
        self.deployAppStatus = deployAppStatus
        self.appStatus = None

    def setEnv(self, env):
        """
        :param env: (Optional) App安装变量（默认为空字符串）
        """
        self.env = env

    def setVolume(self, volume):
        """
        :param volume: (Optional) 硬盘操作卷
        """
        self.volume = volume

    def setAppStatus(self, appStatus):
        """
        :param appStatus: (Optional) App状态
        """
        self.appStatus = appStatus

