# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeProbeTasksRequest(JDCloudRequest):
    """
    查询可用性监控任务列表
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(DescribeProbeTasksRequest, self).__init__(
            '/probeTaskList', 'GET', header, version)
        self.parameters = parameters


class DescribeProbeTasksParameters(object):

    def __init__(self, ):
        """
        """

        self.pageNumber = None
        self.pageSize = None
        self.name = None
        self.type = None
        self.timeInterval = None
        self.withStats = None
        self.withDeleted = None
        self.enabled = None
        self.filters = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 当前所在页，默认为1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 页面大小，默认为20；取值范围[1, 100]
        """
        self.pageSize = pageSize

    def setName(self, name):
        """
        :param name: (Optional) 根据探测任务的名称查询，支持模糊查询
        """
        self.name = name

    def setType(self, type):
        """
        :param type: (Optional) 根据探测任务的类型查询，1、http 2、telnet
        """
        self.type = type

    def setTimeInterval(self, timeInterval):
        """
        :param timeInterval: (Optional) 查询的可用率、响应时间的时间间隔，为空时默认查询最新点,最大不超过30天，支持分钟级别,小时级别，天级别，例如：1m、1h、1d
        """
        self.timeInterval = timeInterval

    def setWithStats(self, withStats):
        """
        :param withStats: (Optional) 是否查询可用率、响应时间
        """
        self.withStats = withStats

    def setWithDeleted(self, withDeleted):
        """
        :param withDeleted: (Optional) 是否包含被删除的task
        """
        self.withDeleted = withDeleted

    def setEnabled(self, enabled):
        """
        :param enabled: (Optional) 任务状态：1为启用，0为禁用。默认为查所有的
        """
        self.enabled = enabled

    def setFilters(self, filters):
        """
        :param filters: (Optional) taskId - taskId，精确匹配，支持多个
name - task名称或探测地址，糊模匹配，支持单个
        """
        self.filters = filters

