# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ModifyParametersRequest(JDCloudRequest):
    """
    提交并修改实例的配置参数。 参数修改后，需要重启才能生效。
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ModifyParametersRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/parameters', 'PUT', header, version)
        self.parameters = parameters


class ModifyParametersParameters(object):

    def __init__(self, regionId,instanceId,):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        :param instanceId: 实例ID，唯一标识一个实例
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.parameters = None

    def setParameters(self, parameters):
        """
        :param parameters: (Optional) 目前支持的参数 keep_alive_timeout、max_connections、max_partition_size_to_drop、max_table_size_to_drop、max_concurrent_queries、uncompressed_cache_size、mark_cache_size、use_uncompressed_cache、max_memory_usage、distributed_ddl_task_timeout、background_pool_size、max_memory_usage_for_all_queries、max_query_size、max_partitions_per_insert_block
        """
        self.parameters = parameters

