# ``linearsolve``
A module for approximating, solving, and simulating dynamic stochastic general equilibrium (DSGE) models.

Free use of this software is welcome and subject to the terms of the [license](https://github.com/letsgoexploring/linearsolve/blob/gh-pages/LICENSE). Please send me comments, feedback, suggestions, etc. at bcjenkin@uci.edu.

## Installation
Install the module from PyPI with the shell command:

```pip install linearsolve```

Or download the source here: https://github.com/letsgoexploring/linearsolve/blob/gh-pages/dist/linearsolve-3.4.87.tar.gz

## Documentation
Documentation for linearsolve: https://www.briancjenkins.com/linearsolve/docs/build/html/index.html

## Examples
Example Jupyter Notebooks available in the ``examples`` directory or follow the links below for the examples rendered in nbviewer:
1. [Quickly Simulate an RBC Model](https://nbviewer.jupyter.org/github/letsgoexploring/linearsolve/blob/gh-pages/examples/quick_rbc_model.ipynb)
2. [A Detailed RBC Model Example](https://nbviewer.jupyter.org/github/letsgoexploring/linearsolve/blob/gh-pages/examples/detailed_rbc_model.ipynb)
3. [A New-Keynesian Model](https://nbviewer.jupyter.org/github/letsgoexploring/linearsolve/blob/gh-pages/examples/nk_model.ipynb)
4. [A Cash-in-Advance Model](https://nbviewer.jupyter.org/github/letsgoexploring/linearsolve/blob/gh-pages/examples/cia_model.ipynb)

_Updated: September 03, 2021_
