import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TemplateProviderConfig {
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/template#alias TemplateProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/template template}
*/
export declare class TemplateProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/template template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TemplateProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: TemplateProviderConfig);
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
