/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HtmlTextEscapingMode {
    PCDATA,
    CDATA,
    CDATA_SOMETIMES,
    RCDATA,
    PLAIN_TEXT,
    VOID;

    private static final ImmutableMap<String, HtmlTextEscapingMode> ESCAPING_MODES;

    public static HtmlTextEscapingMode getModeForTag(String canonTagName) {
        HtmlTextEscapingMode mode = ESCAPING_MODES.get(canonTagName);
        return mode != null ? mode : PCDATA;
    }

    public static boolean allowsEscapingTextSpan(String canonTagName) {
        return "style".equals(canonTagName) || "script".equals(canonTagName) || "noembed".equals(canonTagName) || "noscript".equals(canonTagName) || "noframes".equals(canonTagName);
    }

    public static boolean isTagFollowedByLiteralContent(String canonTagName) {
        HtmlTextEscapingMode mode = HtmlTextEscapingMode.getModeForTag(canonTagName);
        return mode != PCDATA && mode != VOID;
    }

    public static boolean isVoidElement(String canonTagName) {
        return HtmlTextEscapingMode.getModeForTag(canonTagName) == VOID;
    }

    static {
        ESCAPING_MODES = ImmutableMap.builder().put("iframe", CDATA).put("listing", CDATA_SOMETIMES).put("xmp", CDATA).put("comment", CDATA_SOMETIMES).put("plaintext", PLAIN_TEXT).put("script", CDATA).put("style", CDATA).put("textarea", RCDATA).put("title", RCDATA).put("area", VOID).put("base", VOID).put("br", VOID).put("col", VOID).put("command", VOID).put("embed", VOID).put("hr", VOID).put("img", VOID).put("input", VOID).put("keygen", VOID).put("link", VOID).put("meta", VOID).put("param", VOID).put("source", VOID).put("track", VOID).put("wbr", VOID).put("basefont", VOID).put("isindex", VOID).build();
    }
}

