/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.servlet;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.ServletContext;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class WebappLoader
extends ResourceLoader {
    protected String[] paths = null;
    protected HashMap templatePaths = null;
    protected ServletContext servletContext = null;

    public void init(ExtendedProperties configuration) {
        this.rsvc.debug("WebappLoader : initialization starting.");
        this.paths = configuration.getStringArray("path");
        if (this.paths == null || this.paths.length == 0) {
            this.paths = new String[1];
            this.paths[0] = "/";
        } else {
            for (int i = 0; i < this.paths.length; ++i) {
                if (!this.paths[i].endsWith("/")) {
                    int n = i;
                    this.paths[n] = this.paths[n] + '/';
                }
                this.rsvc.info("WebappLoader : added template path - '" + this.paths[i] + "'");
            }
        }
        Object obj = this.rsvc.getApplicationAttribute(ServletContext.class.getName());
        if (obj instanceof ServletContext) {
            this.servletContext = (ServletContext)obj;
        } else {
            this.rsvc.error("WebappLoader : unable to retrieve ServletContext");
        }
        this.templatePaths = new HashMap();
        this.rsvc.debug("WebappLoader : initialization complete.");
    }

    public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
        InputStream result = null;
        if (name == null || name.length() == 0) {
            throw new ResourceNotFoundException("WebappLoader : No template name provided");
        }
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        Throwable exception = null;
        for (int i = 0; i < this.paths.length; ++i) {
            try {
                result = this.servletContext.getResourceAsStream(this.paths[i] + name);
                if (result == null) continue;
                this.templatePaths.put(name, this.paths[i]);
                break;
            }
            catch (Exception e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (result == null) {
            String msg = exception == null ? "WebappLoader : Resource '" + name + "' not found." : exception.getMessage();
            throw new ResourceNotFoundException(msg);
        }
        return result;
    }

    private File getCachedFile(String rootPath, String fileName) {
        while (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        String savedPath = (String)this.templatePaths.get(fileName);
        return new File(rootPath + savedPath, fileName);
    }

    public boolean isSourceModified(Resource resource) {
        String rootPath = this.servletContext.getRealPath("/");
        if (rootPath == null) {
            return false;
        }
        String fileName = resource.getName();
        File cachedFile = this.getCachedFile(rootPath, fileName);
        if (!cachedFile.exists()) {
            return true;
        }
        File currentFile = null;
        for (int i = 0; i < this.paths.length && !(currentFile = new File(rootPath + this.paths[i], fileName)).canRead(); ++i) {
        }
        if (cachedFile.equals(currentFile) && cachedFile.canRead()) {
            return cachedFile.lastModified() != resource.getLastModified();
        }
        return true;
    }

    public long getLastModified(Resource resource) {
        String rootPath = this.servletContext.getRealPath("/");
        if (rootPath == null) {
            return 0L;
        }
        File cachedFile = this.getCachedFile(rootPath, resource.getName());
        if (cachedFile.canRead()) {
            return cachedFile.lastModified();
        }
        return 0L;
    }
}

