/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescription;
import org.apache.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.CommonsCompressAction;
import org.apache.logging.log4j.core.appender.rolling.action.CompositeAction;
import org.apache.logging.log4j.core.appender.rolling.action.FileRenameAction;
import org.apache.logging.log4j.core.appender.rolling.action.GzCompressAction;
import org.apache.logging.log4j.core.appender.rolling.action.ZipCompressAction;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="DefaultRolloverStrategy", category="Core", printObject=true)
public class DefaultRolloverStrategy
implements RolloverStrategy {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final int MIN_WINDOW_SIZE = 1;
    private static final int DEFAULT_WINDOW_SIZE = 7;
    private final int maxIndex;
    private final int minIndex;
    private final boolean useMax;
    private final StrSubstitutor strSubstitutor;
    private final int compressionLevel;
    private final List<Action> customActions;
    private final boolean stopCustomActionsOnError;

    @PluginFactory
    public static DefaultRolloverStrategy createStrategy(@PluginAttribute(value="max") String max, @PluginAttribute(value="min") String min, @PluginAttribute(value="fileIndex") String fileIndex, @PluginAttribute(value="compressionLevel") String compressionLevelStr, @PluginElement(value="Actions") Action[] customActions, @PluginAttribute(value="stopCustomActionsOnError", defaultBoolean=true) boolean stopCustomActionsOnError, @PluginConfiguration Configuration config) {
        boolean useMax = fileIndex == null ? true : fileIndex.equalsIgnoreCase("max");
        int minIndex = 1;
        if (min != null && (minIndex = Integer.parseInt(min)) < 1) {
            LOGGER.error("Minimum window size too small. Limited to 1");
            minIndex = 1;
        }
        int maxIndex = 7;
        if (max != null && (maxIndex = Integer.parseInt(max)) < minIndex) {
            maxIndex = minIndex < 7 ? 7 : minIndex;
            LOGGER.error("Maximum window size must be greater than the minimum windows size. Set to " + maxIndex);
        }
        int compressionLevel = Integers.parseInt(compressionLevelStr, -1);
        return new DefaultRolloverStrategy(minIndex, maxIndex, useMax, compressionLevel, config.getStrSubstitutor(), customActions, stopCustomActionsOnError);
    }

    protected DefaultRolloverStrategy(int minIndex, int maxIndex, boolean useMax, int compressionLevel, StrSubstitutor strSubstitutor, Action[] customActions, boolean stopCustomActionsOnError) {
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.useMax = useMax;
        this.compressionLevel = compressionLevel;
        this.strSubstitutor = strSubstitutor;
        this.stopCustomActionsOnError = stopCustomActionsOnError;
        this.customActions = customActions == null ? Collections.emptyList() : Arrays.asList(customActions);
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public List<Action> getCustomActions() {
        return this.customActions;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public StrSubstitutor getStrSubstitutor() {
        return this.strSubstitutor;
    }

    public boolean isStopCustomActionsOnError() {
        return this.stopCustomActionsOnError;
    }

    public boolean isUseMax() {
        return this.useMax;
    }

    private Action merge(Action compressAction, List<Action> custom, boolean stopOnError) {
        if (custom.isEmpty()) {
            return compressAction;
        }
        if (compressAction == null) {
            return new CompositeAction(custom, stopOnError);
        }
        ArrayList<Action> all = new ArrayList<Action>();
        all.add(compressAction);
        all.addAll(custom);
        return new CompositeAction(all, stopOnError);
    }

    private int purge(int lowIndex, int highIndex, RollingFileManager manager) {
        return this.useMax ? this.purgeAscending(lowIndex, highIndex, manager) : this.purgeDescending(lowIndex, highIndex, manager);
    }

    private int purgeAscending(int lowIndex, int highIndex, RollingFileManager manager) {
        int i;
        ArrayList<FileRenameAction> renames = new ArrayList<FileRenameAction>();
        StringBuilder buf = new StringBuilder();
        manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)highIndex);
        String highFilename = this.strSubstitutor.replace(buf);
        int suffixLength = this.suffixLength(highFilename);
        int curMaxIndex = 0;
        for (i = highIndex; i >= lowIndex; --i) {
            File toRename = new File(highFilename);
            if (i == highIndex && toRename.exists()) {
                curMaxIndex = highIndex;
            } else if (curMaxIndex == 0 && toRename.exists()) {
                curMaxIndex = i + 1;
                break;
            }
            boolean isBase = false;
            if (suffixLength > 0) {
                File toRenameBase = new File(highFilename.substring(0, highFilename.length() - suffixLength));
                if (toRename.exists()) {
                    if (toRenameBase.exists()) {
                        LOGGER.debug("DefaultRolloverStrategy.purgeAscending deleting {} base of {}.", (Object)toRenameBase, (Object)toRename);
                        toRenameBase.delete();
                    }
                } else {
                    toRename = toRenameBase;
                    isBase = true;
                }
            }
            if (toRename.exists()) {
                String lowFilename;
                if (i == lowIndex) {
                    LOGGER.debug("DefaultRolloverStrategy.purgeAscending deleting {} at low index {}: all slots full.", (Object)toRename, (Object)i);
                    if (toRename.delete()) break;
                    return -1;
                }
                buf.setLength(0);
                manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)(i - 1));
                String renameTo = lowFilename = this.strSubstitutor.replace(buf);
                if (isBase) {
                    renameTo = lowFilename.substring(0, lowFilename.length() - suffixLength);
                }
                renames.add(new FileRenameAction(toRename, new File(renameTo), true));
                highFilename = lowFilename;
                continue;
            }
            buf.setLength(0);
            manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)(i - 1));
            highFilename = this.strSubstitutor.replace(buf);
        }
        if (curMaxIndex == 0) {
            curMaxIndex = lowIndex;
        }
        for (i = renames.size() - 1; i >= 0; --i) {
            Action action = (Action)renames.get(i);
            try {
                LOGGER.debug("DefaultRolloverStrategy.purgeAscending executing {} of {}: {}", (Object)i, (Object)renames.size(), (Object)action);
                if (action.execute()) continue;
                return -1;
            }
            catch (Exception ex) {
                LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)ex);
                return -1;
            }
        }
        return curMaxIndex;
    }

    private int purgeDescending(int lowIndex, int highIndex, RollingFileManager manager) {
        int i;
        ArrayList<FileRenameAction> renames = new ArrayList<FileRenameAction>();
        StringBuilder buf = new StringBuilder();
        manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)lowIndex);
        String lowFilename = this.strSubstitutor.replace(buf);
        int suffixLength = this.suffixLength(lowFilename);
        for (i = lowIndex; i <= highIndex; ++i) {
            String highFilename;
            File toRename = new File(lowFilename);
            boolean isBase = false;
            if (suffixLength > 0) {
                File toRenameBase = new File(lowFilename.substring(0, lowFilename.length() - suffixLength));
                if (toRename.exists()) {
                    if (toRenameBase.exists()) {
                        LOGGER.debug("DefaultRolloverStrategy.purgeDescending deleting {} base of {}.", (Object)toRenameBase, (Object)toRename);
                        toRenameBase.delete();
                    }
                } else {
                    toRename = toRenameBase;
                    isBase = true;
                }
            }
            if (!toRename.exists()) break;
            if (i == highIndex) {
                LOGGER.debug("DefaultRolloverStrategy.purgeDescending deleting {} at high index {}: all slots full.", (Object)toRename, (Object)i);
                if (toRename.delete()) break;
                return -1;
            }
            buf.setLength(0);
            manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)(i + 1));
            String renameTo = highFilename = this.strSubstitutor.replace(buf);
            if (isBase) {
                renameTo = highFilename.substring(0, highFilename.length() - suffixLength);
            }
            renames.add(new FileRenameAction(toRename, new File(renameTo), true));
            lowFilename = highFilename;
        }
        for (i = renames.size() - 1; i >= 0; --i) {
            Action action = (Action)renames.get(i);
            try {
                LOGGER.debug("DefaultRolloverStrategy.purgeDescending executing {} of {}: {}", (Object)i, (Object)renames.size(), (Object)action);
                if (action.execute()) continue;
                return -1;
            }
            catch (Exception ex) {
                LOGGER.warn("Exception during purge in RollingFileAppender", (Throwable)ex);
                return -1;
            }
        }
        return lowIndex;
    }

    @Override
    public RolloverDescription rollover(RollingFileManager manager) throws SecurityException {
        String renameTo;
        if (this.maxIndex < 0) {
            return null;
        }
        long startNanos = System.nanoTime();
        int fileIndex = this.purge(this.minIndex, this.maxIndex, manager);
        if (fileIndex < 0) {
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            double durationMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            LOGGER.trace("DefaultRolloverStrategy.purge() took {} milliseconds", (Object)durationMillis);
        }
        StringBuilder buf = new StringBuilder(255);
        manager.getPatternProcessor().formatFileName(this.strSubstitutor, buf, (Object)fileIndex);
        String currentFileName = manager.getFileName();
        String compressedName = renameTo = buf.toString();
        Action compressAction = null;
        for (FileExtensions ext : FileExtensions.values()) {
            if (!ext.isExtensionFor(renameTo)) continue;
            renameTo = renameTo.substring(0, renameTo.length() - ext.length());
            compressAction = ext.createCompressAction(renameTo, compressedName, true, this.compressionLevel);
            break;
        }
        FileRenameAction renameAction = new FileRenameAction(new File(currentFileName), new File(renameTo), false);
        Action asyncAction = this.merge(compressAction, this.customActions, this.stopCustomActionsOnError);
        return new RolloverDescriptionImpl(currentFileName, false, renameAction, asyncAction);
    }

    private int suffixLength(String lowFilename) {
        for (FileExtensions extension : FileExtensions.values()) {
            if (!extension.isExtensionFor(lowFilename)) continue;
            return extension.length();
        }
        return 0;
    }

    public String toString() {
        return "DefaultRolloverStrategy(min=" + this.minIndex + ", max=" + this.maxIndex + ')';
    }

    static enum FileExtensions {
        ZIP(".zip"){

            @Override
            Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
                return new ZipCompressAction(this.source(renameTo), this.target(compressedName), deleteSource, compressionLevel);
            }
        }
        ,
        GZ(".gz"){

            @Override
            Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
                return new GzCompressAction(this.source(renameTo), this.target(compressedName), deleteSource);
            }
        }
        ,
        BZIP2(".bz2"){

            @Override
            Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
                return new CommonsCompressAction("bzip2", this.source(renameTo), this.target(compressedName), deleteSource);
            }
        }
        ,
        DEFLATE(".deflate"){

            @Override
            Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
                return new CommonsCompressAction("deflate", this.source(renameTo), this.target(compressedName), deleteSource);
            }
        }
        ,
        PACK200(".pack200"){

            @Override
            Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
                return new CommonsCompressAction("pack200", this.source(renameTo), this.target(compressedName), deleteSource);
            }
        }
        ,
        XZ(".xz"){

            @Override
            Action createCompressAction(String renameTo, String compressedName, boolean deleteSource, int compressionLevel) {
                return new CommonsCompressAction("xz", this.source(renameTo), this.target(compressedName), deleteSource);
            }
        };

        private final String extension;

        static FileExtensions lookup(String fileExtension) {
            for (FileExtensions ext : FileExtensions.values()) {
                if (!ext.isExtensionFor(fileExtension)) continue;
                return ext;
            }
            return null;
        }

        private FileExtensions(String extension) {
            Objects.requireNonNull(extension, "extension");
            this.extension = extension;
        }

        abstract Action createCompressAction(String var1, String var2, boolean var3, int var4);

        String getExtension() {
            return this.extension;
        }

        boolean isExtensionFor(String s) {
            return s.endsWith(this.extension);
        }

        int length() {
            return this.extension.length();
        }

        File source(String fileName) {
            return new File(fileName);
        }

        File target(String fileName) {
            return new File(fileName);
        }
    }
}

