/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

final class EscapeHtmlReference
implements ReferenceInsertionEventHandler {
    private static final PolicyFactory LINKS = new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements("a").allowAttributes("href").onElements("a").requireRelNofollowOnLinks().requireRelsOnLinks("noopener", "noreferrer").toFactory();

    EscapeHtmlReference() {
    }

    @Override
    public Object referenceInsert(String reference, Object value) {
        if (value == null) {
            return null;
        }
        if (reference.startsWith("$_sanitize_")) {
            return LINKS.sanitize(value.toString());
        }
        return StringEscapeUtils.escapeHtml(value.toString());
    }
}

