import requests
from ra_engine.core.app import RAEApp
from ra_engine.type_def.ml import TrainData, PredData, MLData
import pandas as pd
from ra_engine.ml.evaluator import Evaluator

base = "/api/v1/ml/classification"


class ANNCf(Evaluator):
    def __init__(
        self,
        app: RAEApp,
        train_df: pd.DataFrame,
        pred_df: pd.DataFrame,
        features: list,
        targets: list,
        train_config: dict = None,
        pred_config: dict = None,
    ):
        super().__init__(
            f"{base}/ann",
            app,
            train_df,
            pred_df,
            features,
            targets,
            train_config,
            pred_config,
        )


class GradientBoostingCf(Evaluator):
    def __init__(
        self,
        app: RAEApp,
        train_df: pd.DataFrame,
        pred_df: pd.DataFrame,
        features: list,
        targets: list,
        train_config: dict = None,
        pred_config: dict = None,
    ):
        super().__init__(
            f"{base}/gradboost",
            app,
            train_df,
            pred_df,
            features,
            targets,
            train_config,
            pred_config,
        )


class NaiveBayesCf(Evaluator):
    def __init__(
        self,
        app: RAEApp,
        train_df: pd.DataFrame,
        pred_df: pd.DataFrame,
        features: list,
        targets: list,
        train_config: dict = None,
        pred_config: dict = None,
    ):
        super().__init__(
            f"{base}/naivebayes",
            app,
            train_df,
            pred_df,
            features,
            targets,
            train_config,
            pred_config,
        )


class RandomForestCf(Evaluator):
    def __init__(
        self,
        app: RAEApp,
        train_df: pd.DataFrame,
        pred_df: pd.DataFrame,
        features: list,
        targets: list,
        train_config: dict = None,
        pred_config: dict = None,
    ):
        super().__init__(
            f"{base}/randomforest",
            app,
            train_df,
            pred_df,
            features,
            targets,
            train_config,
            pred_config,
        )


class SVMCf(Evaluator):
    def __init__(
        self,
        app: RAEApp,
        train_df: pd.DataFrame,
        pred_df: pd.DataFrame,
        features: list,
        targets: list,
        train_config: dict = None,
        pred_config: dict = None,
    ):
        super().__init__(
            f"{base}/svm",
            app,
            train_df,
            pred_df,
            features,
            targets,
            train_config,
            pred_config,
        )
