from matplotlib.colors import ListedColormap, LinearSegmentedColormap

xyz_data = {
    #    0.00    #0034a1    rgb(0,    52, 161)
    #    0.36    #2cbe8c    rgb(44,  190, 140)
    #    0.50    #eed700    rgb(238, 215,   0)
    #    0.64    #F5AA00    rgb(245, 170,   0)
    #    1.00    #DF0043    rgb(223,   0,  67)
    'red': ((0.00, 0 / 255, 0 / 255),
            (0.36, 44 / 255, 44 / 255),
            (0.50, 238 / 255, 238 / 255),
            (0.64, 245 / 255, 245 / 255),
            (1.00, 223 / 255, 223 / 255)),
    'green': ((0.00, 52 / 255, 52 / 255),
              (0.36, 190 / 255, 190 / 255),
              (0.50, 215 / 255, 215 / 255),
              (0.64, 170 / 255, 170 / 255),
              (1.00, 0 / 255, 0 / 255)),
    'blue': ((0.00, 161 / 255, 161 / 255),
             (0.36, 140 / 255, 140 / 255),
             (0.50, 0 / 255, 0 / 255),
             (0.64, 0 / 255, 0 / 255),
             (1.00, 67 / 255, 67 / 255))
}
xyz_cm = LinearSegmentedColormap('xyz', xyz_data)
xyz_r_cm = xyz_cm.reversed()


neon_data = {
    #    0.00    #0098ff    rgb(  0, 152, 255)
    #    0.25    #76d7ca    rgb(118, 215, 202)
    #    0.50    #ffc100    rgb(255, 193,   0)
    #    0.75    #ff7575    rgb(255, 117, 117)
    #    1.00    #e00073    rgb(224,   0, 115)

    'red': ((0.00, 0 / 255, 0 / 255),
            (0.25, 118 / 255, 118 / 255),
            (0.50, 255 / 255, 255 / 255),
            (0.75, 255 / 255, 255 / 255),
            (1.00, 224 / 255, 224 / 255)),
    'green': ((0.00, 152 / 255, 152 / 255),
              (0.25, 215 / 255, 215 / 255),
              (0.50, 193 / 255, 193 / 255),
              (0.75, 117 / 255, 117 / 255),
              (1.00, 0 / 255, 0 / 255)),
    'blue': ((0.00, 255 / 255, 255 / 255),
             (0.25, 202 / 255, 202 / 255),
             (0.50, 0 / 255, 0 / 255),
             (0.75, 117 / 255, 117 / 255),
             (1.00, 115 / 255, 115 / 255))
}
neon_cm = LinearSegmentedColormap('neon', neon_data)
neon_r_cm = neon_cm.reversed()

anti_data = {
    #    0.00    #1b32b6    rgb( 27,  50, 182)
    #    0.25    #a11da1    rgb(161,  29, 161)
    #    0.50    #e93b20    rgb(233,  59,  32)
    #    0.75    #fcd500    rgb(252, 213,   0)
    #    1.00    #89e996    rgb(137, 233, 150)
    'red': ((0.00, 27 / 255, 27 / 255),
            (0.25, 161 / 255, 161 / 255),
            (0.50, 233 / 255, 233 / 255),
            (0.75, 252 / 255, 252 / 255),
            (1.00, 137 / 255, 137 / 255)),
    'green': ((0.00, 50 / 255, 50 / 255),
              (0.25, 29 / 255, 29 / 255),
              (0.50, 59 / 255, 59 / 255),
              (0.75, 213 / 255, 213 / 255),
              (1.00, 233 / 255, 233 / 255)),
    'blue': ((0.00, 182 / 255, 182 / 255),
             (0.25, 161 / 255, 161 / 255),
             (0.50, 32 / 255, 32 / 255),
             (0.75, 0 / 255, 0 / 255),
             (1.00, 150 / 255, 150 / 255))
}
anti_cm = LinearSegmentedColormap('anti', anti_data)
anti_r_cm = anti_cm.reversed()

fruity_data = [[1.16359026e-04, 1.43226766e-01, 4.80894151e-01],
               [1.60020817e-02, 1.44621737e-01, 4.81032552e-01],
               [3.17259314e-02, 1.46027677e-01, 4.81314604e-01],
               [4.72353283e-02, 1.47405408e-01, 4.81685351e-01],
               [6.05071568e-02, 1.48755102e-01, 4.82140442e-01],
               [7.21396254e-02, 1.50072112e-01, 4.82671294e-01],
               [8.26277402e-02, 1.51359009e-01, 4.83277555e-01],
               [9.22715229e-02, 1.52616220e-01, 4.83956842e-01],
               [1.01261693e-01, 1.53844516e-01, 4.84707336e-01],
               [1.09736452e-01, 1.55042903e-01, 4.85525971e-01],
               [1.17793125e-01, 1.56210847e-01, 4.86410472e-01],
               [1.25498662e-01, 1.57349256e-01, 4.87359895e-01],
               [1.32904612e-01, 1.58458977e-01, 4.88373279e-01],
               [1.40048841e-01, 1.59541619e-01, 4.89450151e-01],
               [1.46972541e-01, 1.60595439e-01, 4.90587958e-01],
               [1.53710073e-01, 1.61618399e-01, 4.91784384e-01],
               [1.60266540e-01, 1.62616337e-01, 4.93041483e-01],
               [1.66686784e-01, 1.63580752e-01, 4.94353802e-01],
               [1.72961947e-01, 1.64520346e-01, 4.95724602e-01],
               [1.79126904e-01, 1.65427569e-01, 4.97149504e-01],
               [1.85183149e-01, 1.66306196e-01, 4.98629302e-01],
               [1.91136680e-01, 1.67158105e-01, 5.00163667e-01],
               [1.97015769e-01, 1.67975242e-01, 5.01749082e-01],
               [2.02814390e-01, 1.68763231e-01, 5.03386685e-01],
               [2.08540457e-01, 1.69521670e-01, 5.05075473e-01],
               [2.14201553e-01, 1.70249884e-01, 5.06814421e-01],
               [2.19814269e-01, 1.70942324e-01, 5.08601670e-01],
               [2.25374756e-01, 1.71602884e-01, 5.10437390e-01],
               [2.30888336e-01, 1.72230922e-01, 5.12320706e-01],
               [2.36344664e-01, 1.72845964e-01, 5.14215143e-01],
               [2.41755163e-01, 1.73455954e-01, 5.16083253e-01],
               [2.47124531e-01, 1.74060152e-01, 5.17924477e-01],
               [2.52455055e-01, 1.74659751e-01, 5.19736045e-01],
               [2.57748841e-01, 1.75256177e-01, 5.21514472e-01],
               [2.63009114e-01, 1.75847261e-01, 5.23264739e-01],
               [2.68238070e-01, 1.76433092e-01, 5.24986453e-01],
               [2.73437702e-01, 1.77013779e-01, 5.26679240e-01],
               [2.78609847e-01, 1.77589426e-01, 5.28342740e-01],
               [2.83756236e-01, 1.78160117e-01, 5.29976603e-01],
               [2.88878264e-01, 1.78726387e-01, 5.31579560e-01],
               [2.93976320e-01, 1.79291054e-01, 5.33145367e-01],
               [2.99053034e-01, 1.79851068e-01, 5.34680624e-01],
               [3.04109694e-01, 1.80406499e-01, 5.36185045e-01],
               [3.09147501e-01, 1.80957416e-01, 5.37658359e-01],
               [3.14167594e-01, 1.81503872e-01, 5.39100304e-01],
               [3.19171008e-01, 1.82045937e-01, 5.40510642e-01],
               [3.24158780e-01, 1.82583633e-01, 5.41889130e-01],
               [3.29130366e-01, 1.83120609e-01, 5.43228188e-01],
               [3.34088118e-01, 1.83653338e-01, 5.44534968e-01],
               [3.39032863e-01, 1.84181813e-01, 5.45809392e-01],
               [3.43965413e-01, 1.84706036e-01, 5.47051277e-01],
               [3.48886537e-01, 1.85226005e-01, 5.48260452e-01],
               [3.53796918e-01, 1.85741740e-01, 5.49436775e-01],
               [3.58697309e-01, 1.86253184e-01, 5.50580072e-01],
               [3.63587507e-01, 1.86762302e-01, 5.51686461e-01],
               [3.68468430e-01, 1.87268565e-01, 5.52756644e-01],
               [3.73341142e-01, 1.87770496e-01, 5.53793617e-01],
               [3.78206381e-01, 1.88267928e-01, 5.54797198e-01],
               [3.83064549e-01, 1.88760912e-01, 5.55767358e-01],
               [3.87916329e-01, 1.89249268e-01, 5.56703929e-01],
               [3.92762089e-01, 1.89733027e-01, 5.57606896e-01],
               [3.97602477e-01, 1.90211988e-01, 5.58476096e-01],
               [4.02437413e-01, 1.90687193e-01, 5.59309624e-01],
               [4.07267171e-01, 1.91159362e-01, 5.60105546e-01],
               [4.12092797e-01, 1.91626490e-01, 5.60867756e-01],
               [4.16914944e-01, 1.92088291e-01, 5.61596061e-01],
               [4.21733824e-01, 1.92544790e-01, 5.62290523e-01],
               [4.26550037e-01, 1.92995703e-01, 5.62950964e-01],
               [4.31363849e-01, 1.93440983e-01, 5.63577404e-01],
               [4.36175724e-01, 1.93880415e-01, 5.64169736e-01],
               [4.40986049e-01, 1.94313827e-01, 5.64727891e-01],
               [4.45795096e-01, 1.94741122e-01, 5.65251873e-01],
               [4.50603222e-01, 1.95162436e-01, 5.65740706e-01],
               [4.55410093e-01, 1.95579040e-01, 5.66192150e-01],
               [4.60216885e-01, 1.95988789e-01, 5.66609352e-01],
               [4.65023980e-01, 1.96391444e-01, 5.66992209e-01],
               [4.69831463e-01, 1.96786988e-01, 5.67340841e-01],
               [4.74639933e-01, 1.97174979e-01, 5.67654956e-01],
               [4.79449572e-01, 1.97555297e-01, 5.67934582e-01],
               [4.84260611e-01, 1.97927777e-01, 5.68179704e-01],
               [4.89073502e-01, 1.98292056e-01, 5.68390115e-01],
               [4.93888521e-01, 1.98647901e-01, 5.68565739e-01],
               [4.98705757e-01, 1.98995233e-01, 5.68706661e-01],
               [5.03525687e-01, 1.99333628e-01, 5.68812615e-01],
               [5.08348579e-01, 1.99662832e-01, 5.68883509e-01],
               [5.13174610e-01, 1.99982655e-01, 5.68919323e-01],
               [5.18004901e-01, 2.00292077e-01, 5.68919135e-01],
               [5.22820400e-01, 2.00624440e-01, 5.68851907e-01],
               [5.27618840e-01, 2.00986582e-01, 5.68707235e-01],
               [5.32399430e-01, 2.01380371e-01, 5.68484296e-01],
               [5.37159966e-01, 2.01809804e-01, 5.68181127e-01],
               [5.41898708e-01, 2.02277992e-01, 5.67796842e-01],
               [5.46616320e-01, 2.02784220e-01, 5.67333074e-01],
               [5.51311921e-01, 2.03330249e-01, 5.66789677e-01],
               [5.55984380e-01, 2.03917990e-01, 5.66167008e-01],
               [5.60632908e-01, 2.04548997e-01, 5.65465150e-01],
               [5.65256575e-01, 2.05224867e-01, 5.64684553e-01],
               [5.69854400e-01, 2.05947154e-01, 5.63825946e-01],
               [5.74425724e-01, 2.06717065e-01, 5.62889771e-01],
               [5.78969555e-01, 2.07535982e-01, 5.61877189e-01],
               [5.83485203e-01, 2.08404947e-01, 5.60789093e-01],
               [5.87971917e-01, 2.09324952e-01, 5.59626692e-01],
               [5.92428875e-01, 2.10297046e-01, 5.58391206e-01],
               [5.96850962e-01, 2.11329586e-01, 5.57078763e-01],
               [6.01242169e-01, 2.12415281e-01, 5.55696455e-01],
               [6.05602027e-01, 2.13554461e-01, 5.54245933e-01],
               [6.09930078e-01, 2.14747333e-01, 5.52729044e-01],
               [6.14225942e-01, 2.15993951e-01, 5.51147704e-01],
               [6.18489311e-01, 2.17294214e-01, 5.49503892e-01],
               [6.22719938e-01, 2.18647878e-01, 5.47799657e-01],
               [6.26917615e-01, 2.20054583e-01, 5.46037187e-01],
               [6.31082289e-01, 2.21513778e-01, 5.44218477e-01],
               [6.35213798e-01, 2.23024891e-01, 5.42346026e-01],
               [6.39309441e-01, 2.24591838e-01, 5.40418648e-01],
               [6.43370866e-01, 2.26210989e-01, 5.38440686e-01],
               [6.47399625e-01, 2.27879070e-01, 5.36415698e-01],
               [6.51395980e-01, 2.29594979e-01, 5.34345755e-01],
               [6.55360072e-01, 2.31357610e-01, 5.32233496e-01],
               [6.59292379e-01, 2.33165668e-01, 5.30080588e-01],
               [6.63193252e-01, 2.35017873e-01, 5.27889238e-01],
               [6.67063032e-01, 2.36912913e-01, 5.25661839e-01],
               [6.70902321e-01, 2.38849359e-01, 5.23399926e-01],
               [6.74711638e-01, 2.40825795e-01, 5.21105409e-01],
               [6.78491404e-01, 2.42840817e-01, 5.18780710e-01],
               [6.82242339e-01, 2.44892932e-01, 5.16427087e-01],
               [6.85965065e-01, 2.46980676e-01, 5.14046237e-01],
               [6.89660252e-01, 2.49102581e-01, 5.11639688e-01],
               [6.93328446e-01, 2.51257206e-01, 5.09209581e-01],
               [6.96970454e-01, 2.53443082e-01, 5.06756860e-01],
               [7.00587003e-01, 2.55658775e-01, 5.04282809e-01],
               [7.04178826e-01, 2.57902876e-01, 5.01788669e-01],
               [7.07746662e-01, 2.60174001e-01, 4.99275607e-01],
               [7.11291262e-01, 2.62470795e-01, 4.96744706e-01],
               [7.14813376e-01, 2.64791937e-01, 4.94196990e-01],
               [7.18313760e-01, 2.67136139e-01, 4.91633388e-01],
               [7.21793145e-01, 2.69502149e-01, 4.89054920e-01],
               [7.25252330e-01, 2.71888758e-01, 4.86462094e-01],
               [7.28692070e-01, 2.74294801e-01, 4.83855562e-01],
               [7.32113118e-01, 2.76719152e-01, 4.81235895e-01],
               [7.35516215e-01, 2.79160729e-01, 4.78603618e-01],
               [7.38902095e-01, 2.81618492e-01, 4.75959181e-01],
               [7.42271446e-01, 2.84091430e-01, 4.73303248e-01],
               [7.45625029e-01, 2.86578612e-01, 4.70635740e-01],
               [7.48963548e-01, 2.89079131e-01, 4.67956859e-01],
               [7.52287690e-01, 2.91592128e-01, 4.65266743e-01],
               [7.55598112e-01, 2.94116773e-01, 4.62565655e-01],
               [7.58893927e-01, 2.96654317e-01, 4.59852879e-01],
               [7.62174058e-01, 2.99206395e-01, 4.57126695e-01],
               [7.65442546e-01, 3.01768408e-01, 4.54385305e-01],
               [7.68700680e-01, 3.04337967e-01, 4.51633589e-01],
               [7.71948485e-01, 3.06915496e-01, 4.48869411e-01],
               [7.75185351e-01, 3.09501809e-01, 4.46092659e-01],
               [7.78410621e-01, 3.12097650e-01, 4.43303868e-01],
               [7.81623678e-01, 3.14703773e-01, 4.40503135e-01],
               [7.84823912e-01, 3.17320919e-01, 4.37690522e-01],
               [7.88008788e-01, 3.19951868e-01, 4.34867374e-01],
               [7.91176962e-01, 3.22598051e-01, 4.32034467e-01],
               [7.94330572e-01, 3.25257179e-01, 4.29190312e-01],
               [7.97469019e-01, 3.27929903e-01, 4.26335129e-01],
               [8.00591710e-01, 3.30616862e-01, 4.23469063e-01],
               [8.03698051e-01, 3.33318656e-01, 4.20592429e-01],
               [8.06787459e-01, 3.36035877e-01, 4.17705465e-01],
               [8.09859353e-01, 3.38769086e-01, 4.14808481e-01],
               [8.12913161e-01, 3.41518812e-01, 4.11901895e-01],
               [8.15948320e-01, 3.44285575e-01, 4.08986012e-01],
               [8.18964277e-01, 3.47069869e-01, 4.06061174e-01],
               [8.21958889e-01, 3.49873774e-01, 4.03129024e-01],
               [8.24931131e-01, 3.52698204e-01, 4.00190372e-01],
               [8.27882623e-01, 3.55541411e-01, 3.97243937e-01],
               [8.30812850e-01, 3.58403808e-01, 3.94290050e-01],
               [8.33721307e-01, 3.61285781e-01, 3.91329088e-01],
               [8.36607497e-01, 3.64187675e-01, 3.88361571e-01],
               [8.39470940e-01, 3.67109826e-01, 3.85387908e-01],
               [8.42311169e-01, 3.70052546e-01, 3.82408510e-01],
               [8.45127727e-01, 3.73016125e-01, 3.79423777e-01],
               [8.47920173e-01, 3.76000831e-01, 3.76434127e-01],
               [8.50688080e-01, 3.79006904e-01, 3.73439981e-01],
               [8.53431034e-01, 3.82034564e-01, 3.70441763e-01],
               [8.56148636e-01, 3.85084006e-01, 3.67439879e-01],
               [8.58840503e-01, 3.88155408e-01, 3.64434729e-01],
               [8.61503320e-01, 3.91251692e-01, 3.61429270e-01],
               [8.64139334e-01, 3.94370512e-01, 3.58421688e-01],
               [8.66748539e-01, 3.97511660e-01, 3.55412074e-01],
               [8.69330609e-01, 4.00675231e-01, 3.52400795e-01],
               [8.71885231e-01, 4.03861298e-01, 3.49388209e-01],
               [8.74412109e-01, 4.07069912e-01, 3.46374672e-01],
               [8.76910962e-01, 4.10301105e-01, 3.43360517e-01],
               [8.79381529e-01, 4.13554888e-01, 3.40346072e-01],
               [8.81823556e-01, 4.16831262e-01, 3.37331614e-01],
               [8.84236810e-01, 4.20130203e-01, 3.34317422e-01],
               [8.86621077e-01, 4.23451667e-01, 3.31303783e-01],
               [8.88976163e-01, 4.26795580e-01, 3.28291015e-01],
               [8.91301876e-01, 4.30161877e-01, 3.25279297e-01],
               [8.93597268e-01, 4.33551154e-01, 3.22269523e-01],
               [8.95859897e-01, 4.36965284e-01, 3.19264067e-01],
               [8.98092594e-01, 4.40401529e-01, 3.16260271e-01],
               [9.00295238e-01, 4.43859744e-01, 3.13258346e-01],
               [9.02467704e-01, 4.47339796e-01, 3.10258366e-01],
               [9.04609892e-01, 4.50841525e-01, 3.07260434e-01],
               [9.06721727e-01, 4.54364742e-01, 3.04264712e-01],
               [9.08803114e-01, 4.57909298e-01, 3.01271110e-01],
               [9.10853994e-01, 4.61474997e-01, 2.98279670e-01],
               [9.12874321e-01, 4.65061635e-01, 2.95290394e-01],
               [9.14864044e-01, 4.68669022e-01, 2.92303170e-01],
               [9.16823131e-01, 4.72296950e-01, 2.89317887e-01],
               [9.18746785e-01, 4.75949061e-01, 2.86339756e-01],
               [9.20639589e-01, 4.79621361e-01, 2.83363710e-01],
               [9.22501637e-01, 4.83313538e-01, 2.80389535e-01],
               [9.24332915e-01, 4.87025385e-01, 2.77416907e-01],
               [9.26133448e-01, 4.90756654e-01, 2.74445613e-01],
               [9.27903377e-01, 4.94506973e-01, 2.71475825e-01],
               [9.29642681e-01, 4.98276163e-01, 2.68506966e-01],
               [9.31351386e-01, 5.02063995e-01, 2.65538594e-01],
               [9.33029217e-01, 5.05870473e-01, 2.62570616e-01],
               [9.34670821e-01, 5.09699448e-01, 2.59609309e-01],
               [9.36281905e-01, 5.13546300e-01, 2.56647706e-01],
               [9.37862540e-01, 5.17410771e-01, 2.53685293e-01],
               [9.39412817e-01, 5.21292591e-01, 2.50721562e-01],
               [9.40932639e-01, 5.25191683e-01, 2.47755312e-01],
               [9.42422975e-01, 5.29109306e-01, 2.44744530e-01],
               [9.43913240e-01, 5.33022721e-01, 2.41668390e-01],
               [9.45403771e-01, 5.36931803e-01, 2.38525855e-01],
               [9.46895946e-01, 5.40835429e-01, 2.35319426e-01],
               [9.48387530e-01, 5.44735982e-01, 2.32038695e-01],
               [9.49878456e-01, 5.48633709e-01, 2.28680434e-01],
               [9.51368572e-01, 5.52528937e-01, 2.25240807e-01],
               [9.52857967e-01, 5.56421757e-01, 2.21716508e-01],
               [9.54346579e-01, 5.60312403e-01, 2.18103317e-01],
               [9.55834356e-01, 5.64201096e-01, 2.14396629e-01],
               [9.57321246e-01, 5.68088053e-01, 2.10591358e-01],
               [9.58806738e-01, 5.71973906e-01, 2.06680045e-01],
               [9.60290810e-01, 5.75858832e-01, 2.02656471e-01],
               [9.61773897e-01, 5.79742588e-01, 1.98515635e-01],
               [9.63254678e-01, 5.83626521e-01, 1.94244374e-01],
               [9.64735864e-01, 5.87508344e-01, 1.89845760e-01],
               [9.66216639e-01, 5.91388956e-01, 1.85307072e-01],
               [9.67695721e-01, 5.95269653e-01, 1.80611886e-01],
               [9.69172289e-01, 5.99151289e-01, 1.75743903e-01],
               [9.70645291e-01, 6.03034906e-01, 1.70683443e-01],
               [9.72119076e-01, 6.06916845e-01, 1.65434992e-01],
               [9.73591804e-01, 6.10798860e-01, 1.59971062e-01],
               [9.75059229e-01, 6.14684724e-01, 1.54246876e-01],
               [9.76529072e-01, 6.18567949e-01, 1.48276664e-01],
               [9.77993661e-01, 6.22455205e-01, 1.41986812e-01],
               [9.79458136e-01, 6.26342249e-01, 1.35367066e-01],
               [9.80916910e-01, 6.30233891e-01, 1.28335262e-01],
               [9.82378699e-01, 6.34122965e-01, 1.20885402e-01],
               [9.83835422e-01, 6.38016323e-01, 1.12887213e-01],
               [9.85288808e-01, 6.41912617e-01, 1.04245818e-01],
               [9.86739673e-01, 6.45811276e-01, 9.48222150e-02],
               [9.88186188e-01, 6.49713884e-01, 8.43914185e-02],
               [9.89627307e-01, 6.53621360e-01, 7.26168760e-02],
               [9.91063236e-01, 6.57533600e-01, 5.89478717e-02],
               [9.92495801e-01, 6.61449210e-01, 4.23404286e-02],
               [9.93912662e-01, 6.65378053e-01, 2.25800591e-02],
               [9.95258396e-01, 6.69363693e-01, 1.56053986e-03]]
fruity_cm = ListedColormap(fruity_data, name="fruity")
fruity_r_cm = ListedColormap(fruity_cm.colors[::-1])

rust_data = [
    [0.27502352, 0.11625005, 0.00981122],
    [0.27946460, 0.11653841, 0.01220374],
    [0.28385027, 0.11685591, 0.01466809],
    [0.28823184, 0.11715180, 0.01724063],
    [0.29261665, 0.11741856, 0.01992754],
    [0.29700527, 0.11765542, 0.02273006],
    [0.30140496, 0.11785429, 0.02565498],
    [0.30581134, 0.11801945, 0.02869967],
    [0.31022666, 0.11814799, 0.03186688],
    [0.31465200, 0.11823818, 0.03515843],
    [0.31908741, 0.11828935, 0.03857525],
    [0.32353258, 0.11830121, 0.04207056],
    [0.32799408, 0.11826526, 0.04551434],
    [0.33246586, 0.11818775, 0.04891235],
    [0.33695028, 0.11806498, 0.05227123],
    [0.34144954, 0.11789320, 0.05559665],
    [0.34596276, 0.11767235, 0.05889111],
    [0.35048828, 0.11740341, 0.06215614],
    [0.35503342, 0.11707547, 0.06540000],
    [0.35959129, 0.11669612, 0.06861941],
    [0.36416316, 0.11626222, 0.07181735],
    [0.36875696, 0.11576111, 0.07500145],
    [0.37336627, 0.11519963, 0.07816840],
    [0.37799191, 0.11457469, 0.08132021],
    [0.38263406, 0.11388385, 0.08445831],
    [0.38729459, 0.11312197, 0.08758517],
    [0.39197387, 0.11228577, 0.09070211],
    [0.39667471, 0.11136789, 0.09381196],
    [0.40139351, 0.11037068, 0.09691318],
    [0.40613214, 0.10928763, 0.10000790],
    [0.41089066, 0.10811477, 0.10309691],
    [0.41566927, 0.10684748, 0.10618112],
    [0.42046814, 0.10548074, 0.10926133],
    [0.42526850, 0.10403819, 0.11236689],
    [0.43004052, 0.10255666, 0.11559093],
    [0.43478822, 0.10102603, 0.11894680],
    [0.43950701, 0.09945194, 0.12244295],
    [0.44419291, 0.09783918, 0.12608908],
    [0.44883945, 0.09619830, 0.12989306],
    [0.45344117, 0.09453861, 0.13386416],
    [0.45799101, 0.09287388, 0.13801022],
    [0.46248194, 0.09121887, 0.14234109],
    [0.46688854, 0.08962791, 0.14688046],
    [0.47121802, 0.08809292, 0.15161783],
    [0.47546169, 0.08663876, 0.15655692],
    [0.47961060, 0.08529328, 0.16169929],
    [0.48363281, 0.08413775, 0.16706755],
    [0.48753741, 0.08316682, 0.17263864],
    [0.49131981, 0.08240507, 0.17840159],
    [0.49495642, 0.08192167, 0.18436275],
    [0.49844460, 0.08173814, 0.19050540],
    [0.50179309, 0.08184696, 0.19680096],
    [0.50498912, 0.08228856, 0.20324266],
    [0.50802444, 0.08308964, 0.20981977],
    [0.51091833, 0.08420763, 0.21649628],
    [0.51367294, 0.08563709, 0.22325515],
    [0.51627581, 0.08740311, 0.23009524],
    [0.51874161, 0.08946419, 0.23699171],
    [0.52108204, 0.09178437, 0.24392591],
    [0.52330242, 0.09434225, 0.25088457],
    [0.52540792, 0.09711539, 0.25785929],
    [0.52740388, 0.10008137, 0.26484165],
    [0.52929138, 0.10322730, 0.27182763],
    [0.53107846, 0.10652621, 0.27880812],
    [0.53277405, 0.10995060, 0.28577559],
    [0.53438315, 0.11348288, 0.29272526],
    [0.53591055, 0.11710701, 0.29965303],
    [0.53736095, 0.12080841, 0.30655515],
    [0.53873846, 0.12457440, 0.31342976],
    [0.54004560, 0.12839648, 0.32027499],
    [0.54128060, 0.13227384, 0.32709293],
    [0.54245284, 0.13618726, 0.33387806],
    [0.54356576, 0.14012864, 0.34062957],
    [0.54462302, 0.14409058, 0.34734584],
    [0.54562926, 0.14806539, 0.35402247],
    [0.54658654, 0.15204858, 0.36066204],
    [0.54749666, 0.15603748, 0.36726320],
    [0.54834393, 0.16005363, 0.37383917],
    [0.54915130, 0.16406420, 0.38037318],
    [0.54992007, 0.16806715, 0.38686877],
    [0.55065504, 0.17205750, 0.39332126],
    [0.55133838, 0.17605860, 0.39974536],
    [0.55198148, 0.18005533, 0.40613517],
    [0.55259758, 0.18403214, 0.41248183],
    [0.55318752, 0.18798888, 0.41878778],
    [0.55372136, 0.19196211, 0.42507288],
    [0.55423382, 0.19591060, 0.43131695],
    [0.55472744, 0.19983284, 0.43752020],
    [0.55517483, 0.20376099, 0.44369936],
    [0.55560007, 0.20766827, 0.44984177],
    [0.55601168, 0.21154612, 0.45594608],
    [0.55637887, 0.21542904, 0.46202884],
    [0.55672988, 0.21928697, 0.46807731],
    [0.55707023, 0.22311547, 0.47409018],
    [0.55736529, 0.22695083, 0.48008626],
    [0.55765576, 0.23075205, 0.48604733],
    [0.55792377, 0.23453826, 0.49198303],
    [0.55816596, 0.23831302, 0.49789728],
    [0.55841010, 0.24205082, 0.50377711],
    [0.55861018, 0.24579524, 0.50964845],
    [0.55881208, 0.24950412, 0.51549026],
    [0.55899931, 0.25319522, 0.52130545],
    [0.55917062, 0.25686988, 0.52709770],
    [0.55932705, 0.26052290, 0.53288844],
    [0.55946690, 0.26416733, 0.53863327],
    [0.55959135, 0.26779172, 0.54437903],
    [0.55969970, 0.27140297, 0.55010270],
    [0.55979195, 0.27500221, 0.55580231],
    [0.55986838, 0.27858395, 0.56150323],
    [0.55992753, 0.28215964, 0.56716472],
    [0.55997036, 0.28572112, 0.57282058],
    [0.55999596, 0.28926963, 0.57847143],
    [0.56000350, 0.29281420, 0.58408345],
    [0.55999329, 0.29634562, 0.58969738],
    [0.55996486, 0.29986858, 0.59529655],
    [0.55991660, 0.30338798, 0.60086713],
    [0.55984947, 0.30689659, 0.60643879],
    [0.55976211, 0.31040028, 0.61199212],
    [0.55965304, 0.31390199, 0.61752061],
    [0.55952328, 0.31739551, 0.62304922],
    [0.55937043, 0.32088645, 0.62856252],
    [0.55919402, 0.32437831, 0.63404722],
    [0.55899441, 0.32786479, 0.63953079],
    [0.55877013, 0.33134861, 0.64500676],
    [0.55851925, 0.33483836, 0.65044348],
    [0.55824169, 0.33832591, 0.65587777],
    [0.55793675, 0.34181211, 0.66130828],
    [0.55760235, 0.34530532, 0.66670411],
    [0.55723795, 0.34880206, 0.67208230],
    [0.55684293, 0.35230040, 0.67745336],
    [0.55641594, 0.35580163, 0.68281530],
    [0.55595413, 0.35931613, 0.68812898],
    [0.55545825, 0.36283517, 0.69343109],
    [0.55492652, 0.36636003, 0.69872040],
    [0.55435831, 0.36989148, 0.70399431],
    [0.55374980, 0.37343951, 0.70921705],
    [0.55310209, 0.37699646, 0.71441919],
    [0.55241318, 0.38056332, 0.71960061],
    [0.55168208, 0.38414100, 0.72475850],
    [0.55090711, 0.38773334, 0.72987801],
    [0.55008563, 0.39134361, 0.73494935],
    [0.54921813, 0.39496745, 0.73998951],
    [0.54830298, 0.39860595, 0.74499578],
    [0.54733846, 0.40226023, 0.74996538],
    [0.54632388, 0.40593097, 0.75489460],
    [0.54525614, 0.40962531, 0.75975528],
    [0.54413616, 0.41333787, 0.76456763],
    [0.54296195, 0.41706941, 0.76933058],
    [0.54173217, 0.42082078, 0.77404063],
    [0.54044669, 0.42459230, 0.77869348],
    [0.53910447, 0.42838464, 0.78328546],
    [0.53770349, 0.43219885, 0.78781338],
    [0.53624375, 0.43603855, 0.79225606],
    [0.53472511, 0.43990099, 0.79662370],
    [0.53314704, 0.44378578, 0.80091593],
    [0.53150915, 0.44769319, 0.80512893],
    [0.52981049, 0.45162363, 0.80925915],
    [0.52805193, 0.45557679, 0.81330240],
    [0.52623364, 0.45955258, 0.81725497],
    [0.52435598, 0.46355081, 0.82111328],
    [0.52241945, 0.46757120, 0.82487387],
    [0.52042483, 0.47161332, 0.82853343],
    [0.51837317, 0.47567661, 0.83208883],
    [0.51626576, 0.47976036, 0.83553714],
    [0.51410436, 0.48386467, 0.83887063],
    [0.51189068, 0.48798841, 0.84208788],
    [0.50962634, 0.49212981, 0.84519137],
    [0.50731342, 0.49628781, 0.84817927],
    [0.50495431, 0.50046120, 0.85105003],
    [0.50255149, 0.50464871, 0.85380248],
    [0.50010762, 0.50884902, 0.85643581],
    [0.49762553, 0.51306073, 0.85894959],
    [0.49510814, 0.51728240, 0.86134374],
    [0.49255856, 0.52151255, 0.86361858],
    [0.48997994, 0.52574965, 0.86577480],
    [0.48737551, 0.52999219, 0.86781345],
    [0.48474852, 0.53423865, 0.86973594],
    [0.48210224, 0.53848752, 0.87154405],
    [0.47943991, 0.54273733, 0.87323985],
    [0.47676475, 0.54698663, 0.87482573],
    [0.47406465, 0.55123467, 0.87632962],
    [0.47132845, 0.55547422, 0.87781447],
    [0.46855557, 0.55970594, 0.87927792],
    [0.46574598, 0.56393027, 0.88071757],
    [0.46289982, 0.56814760, 0.88213096],
    [0.46001727, 0.57235833, 0.88351552],
    [0.45709899, 0.57656270, 0.88486863],
    [0.45414567, 0.58076097, 0.88618758],
    [0.45115760, 0.58495354, 0.88746942],
    [0.44813618, 0.58914048, 0.88871131],
    [0.44508363, 0.59332163, 0.88991049],
    [0.44200138, 0.59749713, 0.89106386],
    [0.43889074, 0.60166721, 0.89216815],
    [0.43575585, 0.60583124, 0.89322065],
    [0.43259772, 0.60998963, 0.89421769],
    [0.42942169, 0.61414155, 0.89515663],
    [0.42622972, 0.61828723, 0.89603370],
    [0.42304604, 0.62242305, 0.89683491],
    [0.41985936, 0.62655120, 0.89756646],
    [0.41667557, 0.63067099, 0.89822573],
    [0.41350143, 0.63478163, 0.89880972],
    [0.41034374, 0.63888244, 0.89931526],
    [0.40722495, 0.64297060, 0.89973064],
    [0.40415758, 0.64704455, 0.90005211],
    [0.40113625, 0.65110537, 0.90028562],
    [0.39817119, 0.65515193, 0.90042865],
    [0.39529315, 0.65918033, 0.90046896],
    [0.39252004, 0.66318852, 0.90040219],
    [0.38984321, 0.66717797, 0.90023816],
    [0.38728141, 0.67114648, 0.89997317],
    [0.38489196, 0.67508685, 0.89958606],
    [0.38264519, 0.67900334, 0.89909828],
    [0.38056293, 0.68289343, 0.89850656],
    [0.37870856, 0.68674924, 0.89779051],
    [0.37704632, 0.69057562, 0.89697497],
    [0.37561554, 0.69436782, 0.89605101],
    [0.37445072, 0.69812169, 0.89501286],
    [0.37352418, 0.70184084, 0.89388146],
    [0.37290304, 0.70551695, 0.89263787],
    [0.37256363, 0.70915300, 0.89130089],
    [0.37251449, 0.71274784, 0.88987566],
    [0.37280625, 0.71629499, 0.88835052],
    [0.37338693, 0.71980072, 0.88675365],
    [0.37431281, 0.72325766, 0.88507057],
    [0.37555584, 0.72666889, 0.88331884],
    [0.37710294, 0.73003562, 0.88150898],
    [0.37900389, 0.73335093, 0.87962777],
    [0.38119020, 0.73662287, 0.87770537],
    [0.38368905, 0.73984734, 0.87573502],
    [0.38649260, 0.74302460, 0.87372261],
    [0.38955497, 0.74615988, 0.87168704],
    [0.39290713, 0.74924835, 0.86961875],
    [0.39641713, 0.75231074, 0.86753357],
    [0.39985494, 0.75537967, 0.86549879],
    [0.40321812, 0.75845428, 0.86352907],
    [0.40650841, 0.76153687, 0.86160591],
    [0.40972448, 0.76462732, 0.85973572],
    [0.41286630, 0.76772666, 0.85791296],
    [0.41593326, 0.77083523, 0.85613885],
    [0.41892541, 0.77395463, 0.85440225],
    [0.42184173, 0.77708384, 0.85271667],
    [0.42468231, 0.78022507, 0.85106505],
    [0.42744653, 0.78337862, 0.84944833],
    [0.43013401, 0.78654463, 0.84786811],
    [0.43274448, 0.78972363, 0.84632243],
    [0.43527737, 0.79291677, 0.84480387],
    [0.43773216, 0.79612462, 0.84330994],
    [0.44010930, 0.79934666, 0.84184644],
    [0.44240756, 0.80258464, 0.84040096],
    [0.44462626, 0.80583923, 0.83896980],
    [0.44676530, 0.80911058, 0.83755289],
    [0.44882450, 0.81239903, 0.83614840],
    [0.45080390, 0.81570482, 0.83475497],
    [0.45269987, 0.81903055, 0.83335483],
    [0.45450935, 0.82237796, 0.83193706],
    [0.45620178, 0.82576378, 0.83039318]]
rust_cm = ListedColormap(rust_data, name="rust")
rust_r_cm = ListedColormap(rust_cm.colors[::-1])

lichen_data = [
    [0.18492255, 0.11334167, 0.40075591],
    [0.18380703, 0.11848421, 0.40245599],
    [0.18275906, 0.12341790, 0.40421962],
    [0.18168541, 0.12822398, 0.40602719],
    [0.18058052, 0.13291729, 0.40787738],
    [0.17943020, 0.13751544, 0.40976794],
    [0.17823104, 0.14202749, 0.41169863],
    [0.17699101, 0.14645547, 0.41367053],
    [0.17569119, 0.15081471, 0.41568158],
    [0.17433884, 0.15510586, 0.41773279],
    [0.17292696, 0.15933624, 0.41982364],
    [0.17145159, 0.16351088, 0.42195399],
    [0.16990944, 0.16763394, 0.42412375],
    [0.16829761, 0.17170895, 0.42633283],
    [0.16660494, 0.17574224, 0.42858089],
    [0.16482879, 0.17973613, 0.43086798],
    [0.16297227, 0.18369062, 0.43319411],
    [0.16101392, 0.18761420, 0.43555900],
    [0.15896343, 0.19150393, 0.43796259],
    [0.15679772, 0.19536760, 0.44040487],
    [0.15452892, 0.19920128, 0.44288538],
    [0.15212329, 0.20301479, 0.44540457],
    [0.14959193, 0.20680404, 0.44796176],
    [0.14692095, 0.21057210, 0.45055681],
    [0.14408490, 0.21432434, 0.45319022],
    [0.14108550, 0.21805855, 0.45586113],
    [0.13790692, 0.22177672, 0.45856935],
    [0.13459547, 0.22550125, 0.46115030],
    [0.13114847, 0.22924343, 0.46354398],
    [0.12756194, 0.23299790, 0.46576789],
    [0.12384115, 0.23676139, 0.46782099],
    [0.12000032, 0.24053172, 0.46968966],
    [0.11605332, 0.24430585, 0.47136729],
    [0.11199668, 0.24807812, 0.47287787],
    [0.10783945, 0.25184502, 0.47422488],
    [0.10360223, 0.25560415, 0.47539891],
    [0.09930155, 0.25935238, 0.47640075],
    [0.09493469, 0.26308510, 0.47725618],
    [0.09051299, 0.26679957, 0.47797199],
    [0.08604788, 0.27049339, 0.47855532],
    [0.08158114, 0.27416561, 0.47898787],
    [0.07709792, 0.27781286, 0.47930496],
    [0.07261265, 0.28143334, 0.47951520],
    [0.06813672, 0.28502615, 0.47962590],
    [0.06368466, 0.28859027, 0.47964497],
    [0.05927246, 0.29212488, 0.47958031],
    [0.05493588, 0.29563002, 0.47942716],
    [0.05067728, 0.29910490, 0.47920437],
    [0.04650894, 0.30254970, 0.47892075],
    [0.04245065, 0.30596467, 0.47858255],
    [0.03852243, 0.30934983, 0.47819673],
    [0.03490484, 0.31270596, 0.47776821],
    [0.03165620, 0.31603368, 0.47730219],
    [0.02877096, 0.31933358, 0.47680404],
    [0.02624143, 0.32260642, 0.47627846],
    [0.02405885, 0.32585302, 0.47572980],
    [0.02221298, 0.32907438, 0.47516177],
    [0.02069364, 0.33227143, 0.47457809],
    [0.01949002, 0.33544513, 0.47398213],
    [0.01859254, 0.33859627, 0.47337783],
    [0.01798848, 0.34172598, 0.47276764],
    [0.01766518, 0.34483536, 0.47215386],
    [0.01764585, 0.34792502, 0.47152834],
    [0.01789240, 0.35099622, 0.47090126],
    [0.01838889, 0.35404982, 0.47027713],
    [0.01912144, 0.35708694, 0.46965727],
    [0.02007558, 0.36010880, 0.46904237],
    [0.02124047, 0.36311608, 0.46843516],
    [0.02260512, 0.36610975, 0.46783635],
    [0.02422180, 0.36908993, 0.46722876],
    [0.02601462, 0.37205828, 0.46663175],
    [0.02796944, 0.37501587, 0.46604544],
    [0.03007492, 0.37796341, 0.46547167],
    [0.03233054, 0.38090179, 0.46490616],
    [0.03478620, 0.38383066, 0.46433555],
    [0.03735810, 0.38675195, 0.46377855],
    [0.04003169, 0.38966676, 0.46323384],
    [0.04272689, 0.39257543, 0.46270178],
    [0.04547601, 0.39547729, 0.46216144],
    [0.04818453, 0.39837484, 0.46163377],
    [0.05084693, 0.40126862, 0.46111970],
    [0.05349799, 0.40415837, 0.46060861],
    [0.05614092, 0.40704467, 0.46009565],
    [0.05871990, 0.40992916, 0.45959543],
    [0.06124023, 0.41281236, 0.45910440],
    [0.06376984, 0.41569304, 0.45860125],
    [0.06622572, 0.41857357, 0.45811002],
    [0.06860582, 0.42145465, 0.45762917],
    [0.07099268, 0.42433452, 0.45713180],
    [0.07330075, 0.42721592, 0.45664275],
    [0.07553186, 0.43009914, 0.45616193],
    [0.07776161, 0.43298262, 0.45566135],
    [0.07990874, 0.43586893, 0.45516785],
    [0.08199192, 0.43875789, 0.45467467],
    [0.08405409, 0.44164877, 0.45416346],
    [0.08605422, 0.44454237, 0.45365493],
    [0.08806804, 0.44743496, 0.45313669],
    [0.09010008, 0.45032651, 0.45260641],
    [0.09208149, 0.45322218, 0.45206139],
    [0.09411897, 0.45611441, 0.45150281],
    [0.09615473, 0.45900757, 0.45092787],
    [0.09815508, 0.46190441, 0.45033426],
    [0.10024159, 0.46479589, 0.44972410],
    [0.10231976, 0.46768928, 0.44909359],
    [0.10437746, 0.47058576, 0.44844037],
    [0.10653924, 0.47347561, 0.44776808],
    [0.10869810, 0.47636735, 0.44707137],
    [0.11085159, 0.47926137, 0.44634863],
    [0.11311439, 0.48214836, 0.44560343],
    [0.11539132, 0.48503615, 0.44483032],
    [0.11767763, 0.48792520, 0.44402842],
    [0.12006680, 0.49080764, 0.44320060],
    [0.12249809, 0.49368856, 0.44234298],
    [0.12495234, 0.49656964, 0.44145369],
    [0.12749171, 0.49944545, 0.44053420],
    [0.13011008, 0.50231638, 0.43958360],
    [0.13276375, 0.50518625, 0.43859853],
    [0.13547484, 0.50805305, 0.43757909],
    [0.13830968, 0.51091036, 0.43652915],
    [0.14119054, 0.51376537, 0.43544199],
    [0.14412195, 0.51661753, 0.43431722],
    [0.14716747, 0.51946045, 0.43315907],
    [0.15029832, 0.52229667, 0.43196455],
    [0.15348815, 0.52512862, 0.43073067],
    [0.15674076, 0.52795574, 0.42945707],
    [0.16013893, 0.53076913, 0.42815041],
    [0.16360258, 0.53357673, 0.42680351],
    [0.16713459, 0.53637805, 0.42541535],
    [0.17074947, 0.53917121, 0.42398736],
    [0.17449682, 0.54195025, 0.42252435],
    [0.17831640, 0.54472151, 0.42101929],
    [0.18221003, 0.54748440, 0.41947273],
    [0.18618812, 0.55023736, 0.41788530],
    [0.19029802, 0.55297429, 0.41626218],
    [0.19448328, 0.55570135, 0.41459742],
    [0.19874512, 0.55841805, 0.41289040],
    [0.20308426, 0.56112386, 0.41114153],
    [0.20755213, 0.56381168, 0.40935781],
    [0.21210136, 0.56648696, 0.40753316],
    [0.21672649, 0.56914995, 0.40566731],
    [0.22142803, 0.57180016, 0.40375954],
    [0.22622863, 0.57443388, 0.40181489],
    [0.23113024, 0.57705021, 0.39983357],
    [0.23610505, 0.57965246, 0.39781191],
    [0.24115264, 0.58224022, 0.39575019],
    [0.24627245, 0.58481305, 0.39364873],
    [0.25149986, 0.58736502, 0.39151483],
    [0.25680350, 0.58990021, 0.38934349],
    [0.26217484, 0.59241940, 0.38713398],
    [0.26761316, 0.59492223, 0.38488632],
    [0.27311857, 0.59740815, 0.38260170],
    [0.27872547, 0.59987084, 0.38028841],
    [0.28439405, 0.60231628, 0.37793893],
    [0.29012321, 0.60474419, 0.37555357],
    [0.29591149, 0.60715434, 0.37313307],
    [0.30176249, 0.60954559, 0.37067902],
    [0.30769927, 0.61191314, 0.36819865],
    [0.31368969, 0.61426230, 0.36568478],
    [0.31973236, 0.61659287, 0.36313791],
    [0.32582573, 0.61890473, 0.36055864],
    [0.33197534, 0.62119634, 0.35794938],
    [0.33819702, 0.62346400, 0.35531630],
    [0.34446399, 0.62571257, 0.35265228],
    [0.35077450, 0.62794200, 0.34995812],
    [0.35712746, 0.63015219, 0.34723375],
    [0.36353152, 0.63234087, 0.34448371],
    [0.36999367, 0.63450607, 0.34171102],
    [0.37649262, 0.63665198, 0.33890996],
    [0.38302739, 0.63877855, 0.33608028],
    [0.38959603, 0.64088589, 0.33322296],
    [0.39621529, 0.64296982, 0.33034446],
    [0.40287612, 0.64503202, 0.32744268],
    [0.40956626, 0.64707509, 0.32451388],
    [0.41628468, 0.64909905, 0.32155782],
    [0.42303189, 0.65110356, 0.31857566],
    [0.42983048, 0.65308267, 0.31557721],
    [0.43665247, 0.65504305, 0.31255266],
    [0.44349781, 0.65698463, 0.30950056],
    [0.45036467, 0.65890767, 0.30642162],
    [0.45727156, 0.66080707, 0.30332485],
    [0.46420692, 0.66268575, 0.30020231],
    [0.47115118, 0.66454973, 0.29702704],
    [0.47809700, 0.66640118, 0.29379187],
    [0.48504369, 0.66823982, 0.29050795],
    [0.49199117, 0.67006548, 0.28718121],
    [0.49894666, 0.67187709, 0.28379273],
    [0.50591061, 0.67367443, 0.28034392],
    [0.51288479, 0.67545697, 0.27683441],
    [0.51986815, 0.67722460, 0.27327227],
    [0.52686052, 0.67897695, 0.26966668],
    [0.53386557, 0.68071356, 0.26600254],
    [0.54088576, 0.68243365, 0.26227835],
    [0.54792314, 0.68413653, 0.25849313],
    [0.55497671, 0.68582222, 0.25465015],
    [0.56204752, 0.68749024, 0.25074991],
    [0.56913715, 0.68913997, 0.24679217],
    [0.57624427, 0.69077123, 0.24278823],
    [0.58337118, 0.69238340, 0.23873126],
    [0.59051924, 0.69397596, 0.23461901],
    [0.59768926, 0.69554839, 0.23045269],
    [0.60488196, 0.69710019, 0.22623382],
    [0.61209817, 0.69863083, 0.22196396],
    [0.61933822, 0.70013987, 0.21764573],
    [0.62660303, 0.70162672, 0.21328111],
    [0.63389389, 0.70309063, 0.20887196],
    [0.64121026, 0.70453139, 0.20442335],
    [0.64855221, 0.70594858, 0.19993999],
    [0.65592089, 0.70734147, 0.19542553],
    [0.66331657, 0.70870950, 0.19088723],
    [0.67073395, 0.71005351, 0.18635603],
    [0.67817880, 0.71137163, 0.18181864],
    [0.68564977, 0.71266384, 0.17728703],
    [0.69314681, 0.71392969, 0.17277271],
    [0.70067129, 0.71516823, 0.16828668],
    [0.70822006, 0.71637991, 0.16385444],
    [0.71578412, 0.71756651, 0.15954519],
    [0.72337139, 0.71872573, 0.15533173],
    [0.73098082, 0.71985744, 0.15123935],
    [0.73860245, 0.72096392, 0.14734885],
    [0.74623415, 0.72204558, 0.14369671],
    [0.75388062, 0.72310095, 0.14027898],
    [0.76152307, 0.72413523, 0.13723715],
    [0.76916630, 0.72514728, 0.13456162],
    [0.77680092, 0.72613988, 0.13234018],
    [0.78441665, 0.72711661, 0.13065160],
    [0.79200843, 0.72807969, 0.12953433],
    [0.79956335, 0.72903379, 0.12907880],
    [0.80707234, 0.72998293, 0.12932466],
    [0.81452590, 0.73093156, 0.13029937],
    [0.82190424, 0.73188752, 0.13208889],
    [0.82920747, 0.73285295, 0.13461319],
    [0.83640823, 0.73383873, 0.13797552],
    [0.84350615, 0.73484758, 0.14206992],
    [0.85048964, 0.73588587, 0.14686433],
    [0.85733899, 0.73696272, 0.15237580],
    [0.86406039, 0.73807888, 0.15845150],
    [0.87069462, 0.73921933, 0.16491171],
    [0.87733233, 0.74035433, 0.17119525],
    [0.88397781, 0.74148180, 0.17732307],
    [0.89062641, 0.74260420, 0.18330571],
    [0.89727848, 0.74372148, 0.18915628],
    [0.90393797, 0.74483168, 0.19488913],
    [0.91060458, 0.74593502, 0.20051360],
    [0.91727887, 0.74703129, 0.20603865],
    [0.92396125, 0.74812032, 0.21147210],
    [0.93065357, 0.74920119, 0.21682204],
    [0.93735147, 0.75027630, 0.22209137],
    [0.94405960, 0.75134320, 0.22728891],
    [0.95077885, 0.75240143, 0.23242010],
    [0.95751147, 0.75344979, 0.23749087],
    [0.96425282, 0.75449085, 0.24250217],
    [0.97100634, 0.75552273, 0.24745997],
    [0.97777804, 0.75654207, 0.25237138],
    [0.98457014, 0.75754755, 0.25724066],
    [0.99138744, 0.75853635, 0.26207332],
    [0.99832166, 0.75945554, 0.26692570]]
lichen_cm = ListedColormap(lichen_data, name="lichen")
lichen_r_cm = ListedColormap(lichen_cm.colors[::-1])

jelly_data = [
    [0.14365497, 0.18804359, 0.00191592],
    [0.14307779, 0.19092768, 0.00660700],
    [0.14255729, 0.19377759, 0.01155777],
    [0.14201804, 0.19661218, 0.01687536],
    [0.14146606, 0.19943054, 0.02255816],
    [0.14088914, 0.20223574, 0.02863340],
    [0.14029585, 0.20502628, 0.03509514],
    [0.13968141, 0.20780351, 0.04191799],
    [0.13905024, 0.21056689, 0.04858658],
    [0.13840065, 0.21331709, 0.05503482],
    [0.13773659, 0.21605373, 0.06129934],
    [0.13705705, 0.21877738, 0.06741384],
    [0.13636123, 0.22148855, 0.07340368],
    [0.13565052, 0.22418736, 0.07928539],
    [0.13492615, 0.22687397, 0.08507187],
    [0.13418872, 0.22954869, 0.09077388],
    [0.13344095, 0.23221148, 0.09639711],
    [0.13267724, 0.23486363, 0.10195604],
    [0.13189970, 0.23750520, 0.10745350],
    [0.13111359, 0.24013583, 0.11288753],
    [0.13030604, 0.24275779, 0.11827686],
    [0.12949024, 0.24536960, 0.12360830],
    [0.12865128, 0.24797373, 0.12890053],
    [0.12784463, 0.25055959, 0.13415692],
    [0.12711497, 0.25311723, 0.13941708],
    [0.12645770, 0.25564950, 0.14466673],
    [0.12587688, 0.25815657, 0.14990809],
    [0.12537693, 0.26063842, 0.15514469],
    [0.12495303, 0.26309757, 0.16036576],
    [0.12461006, 0.26553375, 0.16557601],
    [0.12434926, 0.26794758, 0.17077585],
    [0.12416533, 0.27034126, 0.17595811],
    [0.12405767, 0.27271563, 0.18112257],
    [0.12403274, 0.27506970, 0.18627778],
    [0.12408216, 0.27740617, 0.19141432],
    [0.12420347, 0.27972604, 0.19653199],
    [0.12439444, 0.28203021, 0.20163095],
    [0.12465478, 0.28431900, 0.20671390],
    [0.12498335, 0.28659297, 0.21178191],
    [0.12537297, 0.28885395, 0.21683118],
    [0.12581981, 0.29110284, 0.22186296],
    [0.12632117, 0.29334045, 0.22687646],
    [0.12687232, 0.29556766, 0.23187394],
    [0.12747029, 0.29778527, 0.23685466],
    [0.12811033, 0.29999409, 0.24182077],
    [0.12879047, 0.30219454, 0.24677370],
    [0.12950570, 0.30438754, 0.25171415],
    [0.13025044, 0.30657412, 0.25664241],
    [0.13102085, 0.30875499, 0.26155926],
    [0.13181283, 0.31093081, 0.26646605],
    [0.13262223, 0.31310223, 0.27136444],
    [0.13344515, 0.31526985, 0.27625582],
    [0.13427783, 0.31743424, 0.28114162],
    [0.13511656, 0.31959594, 0.28602344],
    [0.13595794, 0.32175545, 0.29090259],
    [0.13679850, 0.32391324, 0.29578081],
    [0.13763489, 0.32606972, 0.30065997],
    [0.13846399, 0.32822529, 0.30554178],
    [0.13928292, 0.33038030, 0.31042789],
    [0.14008968, 0.33253488, 0.31532056],
    [0.14088294, 0.33468905, 0.32022240],
    [0.14165845, 0.33684342, 0.32513400],
    [0.14241385, 0.33899821, 0.33005722],
    [0.14314696, 0.34115359, 0.33499386],
    [0.14385580, 0.34330971, 0.33994564],
    [0.14453885, 0.34546668, 0.34491375],
    [0.14519434, 0.34762459, 0.34990006],
    [0.14582038, 0.34978347, 0.35490673],
    [0.14641552, 0.35194337, 0.35993545],
    [0.14698299, 0.35410334, 0.36499033],
    [0.14751807, 0.35626410, 0.37007096],
    [0.14801861, 0.35842576, 0.37517877],
    [0.14848431, 0.36058827, 0.38031429],
    [0.14891382, 0.36275154, 0.38547963],
    [0.14930639, 0.36491546, 0.39067614],
    [0.14966491, 0.36707903, 0.39590846],
    [0.14998658, 0.36924250, 0.40117741],
    [0.15027010, 0.37140618, 0.40648080],
    [0.15051342, 0.37356992, 0.41182195],
    [0.15071730, 0.37573353, 0.41720043],
    [0.15088332, 0.37789601, 0.42262235],
    [0.15101167, 0.38005723, 0.42808728],
    [0.15109811, 0.38221771, 0.43359495],
    [0.15114330, 0.38437723, 0.43914518],
    [0.15114666, 0.38653550, 0.44473997],
    [0.15111184, 0.38869066, 0.45038949],
    [0.15109860, 0.39083719, 0.45607061],
    [0.15110245, 0.39297413, 0.46179684],
    [0.15112840, 0.39510067, 0.46756939],
    [0.15121272, 0.39721327, 0.47337767],
    [0.15134748, 0.39931245, 0.47922702],
    [0.15152440, 0.40139890, 0.48512131],
    [0.15174999, 0.40347173, 0.49106112],
    [0.15203199, 0.40553008, 0.49704547],
    [0.15239971, 0.40757108, 0.50306726],
    [0.15285686, 0.40959441, 0.50912588],
    [0.15339226, 0.41160064, 0.51522863],
    [0.15401477, 0.41358891, 0.52137353],
    [0.15473284, 0.41555831, 0.52755908],
    [0.15555394, 0.41750778, 0.53378581],
    [0.15648927, 0.41943627, 0.54005051],
    [0.15757211, 0.42134073, 0.54634311],
    [0.15878124, 0.42322260, 0.55267248],
    [0.16012438, 0.42508093, 0.55903715],
    [0.16160907, 0.42691477, 0.56543508],
    [0.16324238, 0.42872318, 0.57186444],
    [0.16503096, 0.43050521, 0.57832324],
    [0.16698097, 0.43225995, 0.58480918],
    [0.16909795, 0.43398647, 0.59132008],
    [0.17138686, 0.43568387, 0.59785359],
    [0.17385197, 0.43735129, 0.60440699],
    [0.17649684, 0.43898795, 0.61097734],
    [0.17932902, 0.44059268, 0.61755957],
    [0.18234934, 0.44216483, 0.62415093],
    [0.18555361, 0.44370415, 0.63075036],
    [0.18894221, 0.44521001, 0.63735446],
    [0.19251477, 0.44668182, 0.64395974],
    [0.19627017, 0.44811904, 0.65056277],
    [0.20020641, 0.44952131, 0.65715943],
    [0.20432078, 0.45088828, 0.66374584],
    [0.20860990, 0.45221969, 0.67031803],
    [0.21306975, 0.45351537, 0.67687200],
    [0.21769567, 0.45477524, 0.68340370],
    [0.22248251, 0.45599933, 0.68990908],
    [0.22742469, 0.45718770, 0.69638423],
    [0.23251607, 0.45834058, 0.70282504],
    [0.23775017, 0.45945831, 0.70922747],
    [0.24312024, 0.46054127, 0.71558771],
    [0.24861932, 0.46158997, 0.72190203],
    [0.25424026, 0.46260497, 0.72816685],
    [0.25997899, 0.46358667, 0.73437660],
    [0.26582523, 0.46453605, 0.74052991],
    [0.27177104, 0.46545398, 0.74662423],
    [0.27780911, 0.46634131, 0.75265688],
    [0.28393210, 0.46719901, 0.75862532],
    [0.29013286, 0.46802808, 0.76452733],
    [0.29640461, 0.46882947, 0.77036112],
    [0.30274066, 0.46960420, 0.77612507],
    [0.30913460, 0.47035332, 0.78181787],
    [0.31558026, 0.47107787, 0.78743845],
    [0.32207174, 0.47177890, 0.79298607],
    [0.32860343, 0.47245745, 0.79846020],
    [0.33516980, 0.47311466, 0.80386046],
    [0.34176608, 0.47375144, 0.80918703],
    [0.34838770, 0.47436873, 0.81444024],
    [0.35503172, 0.47496734, 0.81961929],
    [0.36169655, 0.47554792, 0.82472234],
    [0.36837534, 0.47611160, 0.82975346],
    [0.37506461, 0.47665920, 0.83471373],
    [0.38176103, 0.47719156, 0.83960431],
    [0.38846174, 0.47770939, 0.84442667],
    [0.39516432, 0.47821327, 0.84918247],
    [0.40186663, 0.47870373, 0.85387351],
    [0.40856700, 0.47918113, 0.85850180],
    [0.41526925, 0.47964266, 0.86307628],
    [0.42196465, 0.48009138, 0.86759722],
    [0.42865424, 0.48052807, 0.87206044],
    [0.43533875, 0.48095363, 0.87646164],
    [0.44201889, 0.48136901, 0.88079649],
    [0.44869461, 0.48177595, 0.88505796],
    [0.45536583, 0.48217620, 0.88923929],
    [0.46203253, 0.48256985, 0.89334171],
    [0.46869443, 0.48295832, 0.89736066],
    [0.47535106, 0.48334308, 0.90129156],
    [0.48200206, 0.48372562, 0.90512992],
    [0.48864647, 0.48410767, 0.90887116],
    [0.49528337, 0.48449098, 0.91251084],
    [0.50191142, 0.48487751, 0.91604451],
    [0.50852939, 0.48526915, 0.91946796],
    [0.51513579, 0.48566794, 0.92277707],
    [0.52172929, 0.48607583, 0.92596794],
    [0.52830830, 0.48649491, 0.92903687],
    [0.53487072, 0.48692747, 0.93198034],
    [0.54141419, 0.48737687, 0.93479071],
    [0.54793706, 0.48784505, 0.93746572],
    [0.55443761, 0.48833341, 0.94000583],
    [0.56091356, 0.48884422, 0.94240893],
    [0.56736302, 0.48937950, 0.94467323],
    [0.57378400, 0.48994129, 0.94679738],
    [0.58017425, 0.49053167, 0.94878046],
    [0.58653187, 0.49115250, 0.95062194],
    [0.59285492, 0.49180557, 0.95232176],
    [0.59914149, 0.49249260, 0.95388030],
    [0.60538982, 0.49321511, 0.95529837],
    [0.61159823, 0.49397453, 0.95657724],
    [0.61776527, 0.49477208, 0.95771853],
    [0.62388943, 0.49560889, 0.95872436],
    [0.62996954, 0.49648587, 0.95959718],
    [0.63600459, 0.49740378, 0.96033948],
    [0.64199211, 0.49836597, 0.96094583],
    [0.64793292, 0.49936984, 0.96142929],
    [0.65382666, 0.50041554, 0.96179355],
    [0.65967285, 0.50150313, 0.96204269],
    [0.66547105, 0.50263258, 0.96218112],
    [0.67122161, 0.50380347, 0.96221294],
    [0.67692465, 0.50501536, 0.96214265],
    [0.68258048, 0.50626771, 0.96197483],
    [0.68818923, 0.50755993, 0.96171440],
    [0.69375173, 0.50889115, 0.96136583],
    [0.69926876, 0.51026043, 0.96093375],
    [0.70474107, 0.51166681, 0.96042287],
    [0.71016962, 0.51310924, 0.95983782],
    [0.71555536, 0.51458660, 0.95918322],
    [0.72089943, 0.51609771, 0.95846354],
    [0.72620306, 0.51764130, 0.95768311],
    [0.73146752, 0.51921613, 0.95684619],
    [0.73669411, 0.52082089, 0.95595693],
    [0.74188411, 0.52245431, 0.95501947],
    [0.74703864, 0.52411554, 0.95403615],
    [0.75215755, 0.52580597, 0.95300242],
    [0.75724409, 0.52752135, 0.95193051],
    [0.76229976, 0.52926035, 0.95082381],
    [0.76732560, 0.53102178, 0.94968631],
    [0.77232315, 0.53280433, 0.94852116],
    [0.77729431, 0.53460659, 0.94733070],
    [0.78224066, 0.53642729, 0.94611763],
    [0.78716314, 0.53826533, 0.94488554],
    [0.79206254, 0.54012078, 0.94363296],
    [0.79694908, 0.54199321, 0.94233040],
    [0.80185221, 0.54384592, 0.94106751],
    [0.80677589, 0.54567693, 0.93984224],
    [0.81172021, 0.54748639, 0.93865408],
    [0.81668573, 0.54927431, 0.93750169],
    [0.82167280, 0.55104076, 0.93638405],
    [0.82668223, 0.55278563, 0.93529935],
    [0.83171422, 0.55450901, 0.93424675],
    [0.83676924, 0.55621089, 0.93322496],
    [0.84184790, 0.55789123, 0.93223244],
    [0.84695058, 0.55955001, 0.93126797],
    [0.85207810, 0.56118708, 0.93032966],
    [0.85723064, 0.56280249, 0.92941655],
    [0.86240864, 0.56439621, 0.92852729],
    [0.86761287, 0.56596804, 0.92765994],
    [0.87284489, 0.56751747, 0.92681151],
    [0.87810406, 0.56904485, 0.92598215],
    [0.88339308, 0.57054913, 0.92516719],
    [0.88871170, 0.57203047, 0.92436622],
    [0.89406143, 0.57348828, 0.92357633],
    [0.89943398, 0.57492625, 0.92280805],
    [0.90483823, 0.57634058, 0.92204812],
    [0.91027757, 0.57772977, 0.92129112],
    [0.91574549, 0.57909677, 0.92054491],
    [0.92124235, 0.58044149, 0.91980792],
    [0.92677830, 0.58175921, 0.91906579],
    [0.93233764, 0.58305734, 0.91833807],
    [0.93793609, 0.58432843, 0.91760322],
    [0.94356836, 0.58557496, 0.91686708],
    [0.94922912, 0.58679957, 0.91613538],
    [0.95492699, 0.58799798, 0.91539601],
    [0.96066186, 0.58917019, 0.91464810],
    [0.96643532, 0.59031528, 0.91388859],
    [0.97224110, 0.59143641, 0.91312417],
    [0.97809256, 0.59252655, 0.91233723],
    [0.98398125, 0.59358995, 0.91153712],
    [0.98992846, 0.59461508, 0.91069672],
    [0.99603507, 0.59554682, 0.90969259]]
jelly_cm = ListedColormap(jelly_data, name="jelly")
jelly_r_cm = ListedColormap(jelly_cm.colors[::-1])


_XYZ_CMAPS = {
    'xyz': xyz_cm,
    'xyz_r': xyz_r_cm,
    'neon': neon_cm,
    'neon_r': neon_r_cm,
    'anti': anti_cm,
    'anti_r': anti_r_cm,
    'fruity': fruity_cm,
    'fruity_r': fruity_r_cm,
    'lichen': lichen_cm,
    'lichen_r': lichen_r_cm,
    'rust': rust_cm,
    'rust_r': rust_r_cm,
    'jelly': jelly_cm,
    'jelly_r': jelly_r_cm,
}
