# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['jake', 'jake.command']

package_data = \
{'': ['*']}

install_requires = \
['cyclonedx-bom>=2.0.1,<3.0.0',
 'ossindex-lib>=0.2.1',
 'polling2>=0.5.0',
 'pyfiglet>=0.8.post1',
 'requests',
 'rich>=10.15.2']

entry_points = \
{'console_scripts': ['jake = jake.app:main']}

setup_kwargs = {
    'name': 'jake',
    'version': '1.4.2',
    'description': 'An OSS Index integration to check for vulnerabilities in your Python environments',
    'long_description': '<!--\n\n    Copyright 2019-Present Sonatype Inc.\n\n    Licensed under the Apache License, Version 2.0 (the "License");\n    you may not use this file except in compliance with the License.\n    You may obtain a copy of the License at\n\n        http://www.apache.org/licenses/LICENSE-2.0\n\n    Unless required by applicable law or agreed to in writing, software\n    distributed under the License is distributed on an "AS IS" BASIS,\n    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n    See the License for the specific language governing permissions and\n    limitations under the License.\n\n-->\n\n<p align="center">\n    <img src="https://raw.githubusercontent.com/sonatype-nexus-community/jake/main/docs/images/jake.png" width="350" alt="jake icon"/>\n</p>\n\n# Jake\n\n[![CircleCI](https://circleci.com/gh/sonatype-nexus-community/jake/tree/main.svg?style=svg)](https://circleci.com/gh/sonatype-nexus-community/jake/tree/main)\n![Python Version Support](https://img.shields.io/badge/python-3.6+-blue)\n[![PyPI Version](https://img.shields.io/pypi/v/jake?label=PyPI&logo=pypi)](https://pypi.org/project/jake)\n[![GitHub license](https://img.shields.io/github/license/sonatype-nexus-community/jake)](https://github.com/sonatype-nexus-community/jake/blob/main/LICENSE)\n[![GitHub issues](https://img.shields.io/github/issues/sonatype-nexus-community/jake)](https://github.com/sonatype-nexus-community/jake/issues)\n[![GitHub forks](https://img.shields.io/github/forks/sonatype-nexus-community/jake)](https://github.com/sonatype-nexus-community/jake/network)\n[![GitHub stars](https://img.shields.io/github/stars/sonatype-nexus-community/jake)](https://github.com/sonatype-nexus-community/jake/stargazers)\n\n----\n\n`jake` is a tool to check for your Python environments and applications that can:\n- produce CycloneDX software bill-of-materials\n- report on known vulnerabilities\n\n`jake` is powered by [Sonatype OSS Index](https://ossindex.sonatype.org) and can also be used with \n[Sonatype\'s Nexus IQ Server](https://www.sonatype.com/product-nexus-lifecycle).\n\n## Installation\n\nInstall from pypi.org as you would any other Python module:\n\n```\npip install jake\n```\n\nor \n\n```\npoetry add jake\n```\n\n_Other Python package managers are available._\n\n## Usage\n\n### Getting Started\n\n`jake` can guide you...\n\n```\n> jake --help\nusage: jake [-h] [-v] [-w] [-X]  ...\n\nPut your Python dependencies in a chokehold\n\noptional arguments:\n  -h, --help       show this help message and exit\n  -v, --version    show which version of jake you are running\n  -w, --warn-only  prevents exit with non-zero code when issues have been\n                   detected\n  -X               enable debug output\n\nJake sub-commands:\n  \n    iq             perform a scan backed by Nexus Lifecycle\n    ddt            perform a scan backed by OSS Index\n    sbom           generate a CycloneDX software-bill-of-materials (no\n                   vulnerabilities)\n```\n\n`jake` will exit with code `0` under normal operation and `1` if vulnerabilities are found (OssIndex) or Policy \nViolations are detected (Nexus IQ), unless you pass the `-w` flag in which case `jake` will always exit with code `0`....\n\n### Generating an SBOM\n\n`jake` can take data from various inputs (or just look at your current Python environment) and produce a CycloneDX for \nyou.\n\n```\n> jake sbom --help\n\nusage: jake sbom [-h] [-i FILE_PATH] [-t TYPE] [-o PATH/TO/FILE]\n                   [--output-format {json,xml}]\n                   [--schema-version {1.0,1.1,1.2,1.3}]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -i FILE_PATH, --input FILE_PATH\n                        Where to get input data from. If a path to a file is\n                        not specified directly here,then we will attempt to\n                        read data from STDIN. If there is no data on STDIN, we\n                        will then fall back to looking for standard files in\n                        the current directory that relate to the type of input\n                        indicated by the -t flag.\n  -t TYPE, --type TYPE, -it TYPE, --input-type TYPE\n                        how jake should find the packages from which to\n                        generate your SBOM.ENV = Read from the current Python\n                        Environment; CONDA = Read output from `conda list\n                        --explicit`; CONDA_JSON = Read output from `conda list\n                        --json`; PIP = read from a requirements.txt; PIPENV =\n                        read from Pipfile.lock; POETRY = read from a\n                        poetry.lock. (Default = ENV)\n  -o PATH/TO/FILE, --output-file PATH/TO/FILE\n                        Specify a file to output the SBOM to\n  --output-format {json,xml}\n                        SBOM output format (default = xml)\n  --schema-version {1.0,1.1,1.2,1.3}\n                        CycloneDX schema version to use (default = 1.3)\n```\n\nCheck out these examples using STDIN:\n```\nconda list --explicit --md5 | jake sbom -t CONDA\nconda list --json | jake sbom -t CONDA_JSON\ncat /path/to/Pipfile.lock | python -m jake.app sbom -t PIPENV\n```\n\nCheck out these examples specifying a manifest:\n```\njake sbom -t PIP -i /path/to/requirements.txt\njake sbom -t PIPENV -i /path/to/Pipfile.lock\n```\n\n### Check for vulnerabilities using OSS Index\n\n`jake` will look at the packaged installed in your current Python environment and check these against OSS Index for you.\nOptionally, it can create a CycloneDX software bill-of-materials at the same time in a format that suits you.\n\n```\n> jake ddt --help\n\nusage: jake ddt [-h] [--clear-cache] [-o PATH/TO/FILE] [--output-format {xml,json}] [--schema-version {1.2,1.1,1.0,1.3}]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --clear-cache         Clears any local cached OSS Index data prior to execution\n  -o PATH/TO/FILE, --output-file PATH/TO/FILE\n                        Specify a file to output the SBOM to. If not specified the report will be output to the console. STDOUT is not supported.\n  --output-format {xml,json}\n                        SBOM output format (default = xml)\n  --schema-version {1.2,1.1,1.0,1.3}\n                        CycloneDX schema version to use (default = 1.3)\n```\n\nSo you can quickly get a report by running:\n\n```\n> jake ddt\n\n                   ___           ___           ___     \n       ___        /  /\\         /  /\\         /  /\\    \n      /__/\\      /  /::\\       /  /:/        /  /::\\   \n      \\__\\:\\    /  /:/\\:\\     /  /:/        /  /:/\\:\\  \n  ___ /  /::\\  /  /::\\ \\:\\   /  /::\\____   /  /::\\ \\:\\ \n /__/\\  /:/\\/ /__/:/\\:\\_\\:\\ /__/:/\\:::::\\ /__/:/\\:\\ \\:\\\n \\  \\:\\/:/~~  \\__\\/  \\:\\/:/ \\__\\/~|:|~~~~ \\  \\:\\ \\:\\_\\/\n  \\  \\::/          \\__\\::/     |  |:|      \\  \\:\\ \\:\\  \n   \\__\\/           /  /:/      |  |:|       \\  \\:\\_\\/  \n                  /__/:/       |__|:|        \\  \\:\\    \n                  \\__\\/         \\__\\|         \\__\\/    \n\n                                                  \n            /)                     /)             \n        _/_(/    _     _  __   _  (/_   _         \n o   o  (__/ )__(/_   /_)_/ (_(_(_/(___(/_ o   o  \n                                                  \n                                                  \n\nJake Version: 1.1.0\nPut your Python dependencies in a chokehold.\n\n🐍 Collected 42 packages from your environment (0:00:00.10)\n🐍 Successfully queried OSS Index for package and vulnerability info (0:00:00.59)\n🐍 Sane number of results from OSS Index\n\n\n╔Summary═══════════════╦════╗\n║ Audited Dependencies ║ 42 ║\n╠══════════════════════╬════╣\n║ Vulnerablities Found ║ 0  ║\n╚══════════════════════╩════╝\n```\n\n...and this is what `jake` will output if any bad things are found:\n```\n                   ___           ___           ___     \n       ___        /  /\\         /  /\\         /  /\\    \n      /__/\\      /  /::\\       /  /:/        /  /::\\   \n      \\__\\:\\    /  /:/\\:\\     /  /:/        /  /:/\\:\\  \n  ___ /  /::\\  /  /::\\ \\:\\   /  /::\\____   /  /::\\ \\:\\ \n /__/\\  /:/\\/ /__/:/\\:\\_\\:\\ /__/:/\\:::::\\ /__/:/\\:\\ \\:\\\n \\  \\:\\/:/~~  \\__\\/  \\:\\/:/ \\__\\/~|:|~~~~ \\  \\:\\ \\:\\_\\/\n  \\  \\::/          \\__\\::/     |  |:|      \\  \\:\\ \\:\\  \n   \\__\\/           /  /:/      |  |:|       \\  \\:\\_\\/  \n                  /__/:/       |__|:|        \\  \\:\\    \n                  \\__\\/         \\__\\|         \\__\\/    \n\n                                                  \n            /)                     /)             \n        _/_(/    _     _  __   _  (/_   _         \n o   o  (__/ )__(/_   /_)_/ (_(_(_/(___(/_ o   o  \n                                                  \n                                                  \n\nJake Version: 1.1.5\nPut your Python dependencies in a chokehold\n\n🐍 Collected 69 packages from your environment                       ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% -:--:--\n🐍 Successfully queried OSS Index for package and vulnerability info ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% -:--:--\n🐍 Sane number of results from OSS Index                             ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% -:--:--\n\n[59/69] - pkg:pypi/cryptography@2.2 [VULNERABLE]\nVulnerability Details for pkg:pypi/cryptography@2.2                                                                                                                                                                                                                                                                     \n├── ⚠  ID: 333aca51-7375-4a9d-be64-16d316ab9274                                                                                                                                                                                                                                                                         \n│   └── ╭─ CVE-2020-36242 ─────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│       │                                                                                                                                                                                                                                                                                                              │\n│       │ In the cryptography package before 3.3.2 for Python, certain sequences of update calls to symmetrically encrypt multi-GB values could result in an integer overflow and buffer overflow, as demonstrated by the Fernet class.                                                                                │\n│       │                                                                                                                                                                                                                                                                                                              │\n│       │ Details:                                                                                                                                                                                                                                                                                                     │\n│       │   - CVSS Score: 9.1 - Critical                                                                                                                                                                                                                                                                               │\n│       │   - CVSS Vector: CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:H                                                                                                                                                                                                                                                │\n│       │   - CWE: Unknown                                                                                                                                                                                                                                                                                             │\n│       │                                                                                                                                                                                                                                                                                                              │\n│       │ References:                                                                                                                                                                                                                                                                                                  │\n│       │   - https://ossindex.sonatype.org/vulnerability/333aca51-7375-4a9d-be64-16d316ab9274?component-type=pypi&component-name=cryptography&utm_source=python-oss-index-lib%400.2.1&utm_medium=integration                                                                                                          │\n│       │   - https://nvd.nist.gov/vuln/detail/CVE-2020-36242                                                                                                                                                                                                                                                          │\n│       │                                                                                                                                                                                                                                                                                                              │\n│       ╰──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n└── ⚠  ID: f19ff95c-cec5-4263-8d3b-e3e64698881e                                                                                                                                                                                                                                                                         \n    └── ╭─ CVE-2018-10903 ─────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n        │                                                                                                                                                                                                                                                                                                              │\n        │ A flaw was found in python-cryptography versions between >=1.9.0 and <2.3. The finalize_with_tag API did not enforce a minimum tag length. If a user did not validate the input length prior to passing it to finalize_with_tag an attacker could craft an invalid payload with a shortened tag (e.g. 1      │\n        │ byte) such that they would have a 1 in 256 chance of passing the MAC check. GCM tag forgeries can cause key leakage.                                                                                                                                                                                         │\n        │                                                                                                                                                                                                                                                                                                              │\n        │ Details:                                                                                                                                                                                                                                                                                                     │\n        │   - CVSS Score: 7.5 - High                                                                                                                                                                                                                                                                                   │\n        │   - CVSS Vector: CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N                                                                                                                                                                                                                                                │\n        │   - CWE: Unknown                                                                                                                                                                                                                                                                                             │\n        │                                                                                                                                                                                                                                                                                                              │\n        │ References:                                                                                                                                                                                                                                                                                                  │\n        │   - https://ossindex.sonatype.org/vulnerability/f19ff95c-cec5-4263-8d3b-e3e64698881e?component-type=pypi&component-name=cryptography&utm_source=python-oss-index-lib%400.2.1&utm_medium=integration                                                                                                          │\n        │   - https://bugzilla.redhat.com/show_bug.cgi?id=CVE-2018-10903                                                                                                                                                                                                                                               │\n        │   - https://github.com/pyca/cryptography/pull/4342/commits/688e0f673bfbf43fa898994326c6877f00ab19ef                                                                                                                                                                                                          │\n        │   - https://nvd.nist.gov/vuln/detail/CVE-2018-10903                                                                                                                                                                                                                                                          │\n        │                                                                                                                                                                                                                                                                                                              │\n        ╰──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n\n                    Summary                     \n┏━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━┓\n┃ Audited Dependencies ┃ Vulnerabilities Found ┃\n┡━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━┩\n│ 69                   │ 2                     │\n└──────────────────────┴───────────────────────┘\n```\n\nA pre-commit hook is also available for use\n\n```Yaml\n  - repo: https://github.com/sonatype-nexus-community/jake\n    rev: "v1.3.0"\n    hooks:\n      - id: scan\n```\n\n### Check for vulnerabilities using Sonatype Nexus Lifecycle\n\nAccess Sonatype\'s proprietary vulnerability data using `jake`:\n\n```\n> jake iq --help\n\nusage: jake iq [-h] -s https://localhost:8070 -i APP_ID -u USER_ID -p PASSWORD [-t STAGE]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -s https://localhost:8070, --server-url https://localhost:8070\n                        Full http(s):// URL to your Nexus Lifecycle server\n  -i APP_ID, --application-id APP_ID\n                        Public Application ID in Nexus Lifecycle\n  -u USER_ID, --username USER_ID\n                        Username for authentication to Nexus Lifecycle\n  -p PASSWORD, --password PASSWORD\n                        Password for authentication to Nexus Lifecycle\n  -t STAGE, --stage STAGE\n                        The stage for the report\n```\n\nSo passing parameters that suit your Nexus Lifecycle environment you can get a report:\n\n```\n> jake iq -s https://my-nexus-lifecyle -i APP_ID -u USERNAME -p PASSWORD\n\n                   ___           ___           ___     \n       ___        /  /\\         /  /\\         /  /\\    \n      /__/\\      /  /::\\       /  /:/        /  /::\\   \n      \\__\\:\\    /  /:/\\:\\     /  /:/        /  /:/\\:\\  \n  ___ /  /::\\  /  /::\\ \\:\\   /  /::\\____   /  /::\\ \\:\\ \n /__/\\  /:/\\/ /__/:/\\:\\_\\:\\ /__/:/\\:::::\\ /__/:/\\:\\ \\:\\\n \\  \\:\\/:/~~  \\__\\/  \\:\\/:/ \\__\\/~|:|~~~~ \\  \\:\\ \\:\\_\\/\n  \\  \\::/          \\__\\::/     |  |:|      \\  \\:\\ \\:\\  \n   \\__\\/           /  /:/      |  |:|       \\  \\:\\_\\/  \n                  /__/:/       |__|:|        \\  \\:\\    \n                  \\__\\/         \\__\\|         \\__\\/    \n\n                                                  \n            /)                     /)             \n        _/_(/    _     _  __   _  (/_   _         \n o   o  (__/ )__(/_   /_)_/ (_(_(_/(___(/_ o   o  \n                                                  \n                                                  \n\nJake Version: 1.0.1\nPut your Python dependencies in a chokehold\n\n🐍 IQ Server at https://my-nexus-lifecyle is up and accessible (0:00:00.14)\n🐍 Collected 42 packages from your environment (0:00:00.09)\n🧨 Something slithers around your ankle! There are policy warnings from Sonatype Nexus IQ. (0:00:11.50)\n\nYour Sonatype Nexus IQ Lifecycle Report is available here:\n  HTML: https://my-nexus-lifecyle/ui/links/application/APP_ID/report/4831bcb7fbaa45c3a2481048e446b598\n  PDF:  https://my-nexus-lifecyle/ui/links/application/APP_ID/report/4831bcb7fbaa45c3a2481048e446b598/pdf\n```\n\n## Why Jake?\n\nJake The Snake was scared of Snakes. The finishing move was DDT. He finishes the Snake with DDT.\n\nWho better to wrangle those slippery dependencies in any virtual or real environment.\n\n## Python Support\n\nWe endeavour to support all functionality for all [current actively supported Python versions](https://www.python.org/downloads/).\nHowever, some features may not be possible/present in older Python versions due to their lack of support.\n\n## Changelog\n\nSee our [CHANGELOG](./CHANGELOG.md).\n\n## Releasing\n\nWe perform releases manually by clicking the "On Hold" button in the CircleCI web page.\n\nIf you see a feature in the code that we have not released, please speak up, and we\'ll be sure to click the magic button.\n\nWe use [python-semantic-release](https://python-semantic-release.readthedocs.io/en/latest/) to generate releases\nfrom commits to the `main` branch.\n\nFor example, to perform a "patch" release, add a commit to `main` with a comment like below. The `fix: ` prefix matters.\n\n```\nfix: Resolve vulnerability: CVE-2020-27783 in lxml\n```\n\n## The Fine Print\n\nRemember:\n\nIt is worth noting that this is **NOT SUPPORTED** by Sonatype, and is a contribution of ours to the open source\ncommunity (read: you!)\n\n* Use this contribution at the risk tolerance that you have\n* Do NOT file Sonatype support tickets related to `ossindex-lib`\n* DO file issues here on GitHub, so that the community can pitch in\n\nPhew, that was easier than I thought. Last but not least of all - have fun!\n\n',
    'author': 'Sonatype Community',
    'author_email': 'community-group@sonatype.com',
    'maintainer': 'Sonatype Community',
    'maintainer_email': 'community-group@sonatype.com',
    'url': 'https://github.com/sonatype-nexus-community/jake',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
