"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpdxLicense = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// ~~ Generated by projen. To modify, edit .projenrc.js and run "npx projen".
/**
 * (experimental) Valid SPDX License identifiers.
 *
 * @experimental
 */
class SpdxLicense {
    //#endregion
    constructor(id) {
        this.id = id;
        /* istanbul ignore if (should never happen) */
        if (SpdxLicense._ALL.has(id)) {
            throw new Error(`Duplicated SPDX License ID: ${id}`);
        }
        SpdxLicense._ALL.set(id, this);
    }
    //#endregion
    //#region Bundles of SPDX Licenses
    /**
     * (experimental) All valid SPDX Licenses.
     *
     * @experimental
     */
    static all() {
        return Array.from(SpdxLicense._ALL.values());
    }
    /**
     * (experimental) All OSI-Approved SPDX Licenses.
     *
     * @experimental
     */
    static osiApproved() {
        return [
            SpdxLicense.ZERO_BSD,
            SpdxLicense.AAL,
            SpdxLicense.AFL_1_1,
            SpdxLicense.AFL_1_2,
            SpdxLicense.AFL_2_0,
            SpdxLicense.AFL_2_1,
            SpdxLicense.AFL_3_0,
            SpdxLicense.AGPL_3_0,
            SpdxLicense.AGPL_3_0_ONLY,
            SpdxLicense.AGPL_3_0_OR_LATER,
            SpdxLicense.APL_1_0,
            SpdxLicense.APSL_1_0,
            SpdxLicense.APSL_1_1,
            SpdxLicense.APSL_1_2,
            SpdxLicense.APSL_2_0,
            SpdxLicense.APACHE_1_1,
            SpdxLicense.APACHE_2_0,
            SpdxLicense.ARTISTIC_1_0,
            SpdxLicense.ARTISTIC_1_0_PERL,
            SpdxLicense.ARTISTIC_1_0_CL8,
            SpdxLicense.ARTISTIC_2_0,
            SpdxLicense.BSD_1_CLAUSE,
            SpdxLicense.BSD_2_CLAUSE,
            SpdxLicense.BSD_2_CLAUSE_PATENT,
            SpdxLicense.BSD_3_CLAUSE,
            SpdxLicense.BSD_3_CLAUSE_LBNL,
            SpdxLicense.BSL_1_0,
            SpdxLicense.CAL_1_0,
            SpdxLicense.CAL_1_0_COMBINED_WORK_EXCEPTION,
            SpdxLicense.CATOSL_1_1,
            SpdxLicense.CDDL_1_0,
            SpdxLicense.CECILL_2_1,
            SpdxLicense.CNRI_PYTHON,
            SpdxLicense.CPAL_1_0,
            SpdxLicense.CPL_1_0,
            SpdxLicense.CUA_OPL_1_0,
            SpdxLicense.ECL_1_0,
            SpdxLicense.ECL_2_0,
            SpdxLicense.EFL_1_0,
            SpdxLicense.EFL_2_0,
            SpdxLicense.EPL_1_0,
            SpdxLicense.EPL_2_0,
            SpdxLicense.EUDATAGRID,
            SpdxLicense.EUPL_1_1,
            SpdxLicense.EUPL_1_2,
            SpdxLicense.ENTESSA,
            SpdxLicense.FAIR,
            SpdxLicense.FRAMEWORX_1_0,
            SpdxLicense.GPL_2_0,
            SpdxLicense.GPL_2_0_PLUS,
            SpdxLicense.GPL_2_0_ONLY,
            SpdxLicense.GPL_2_0_OR_LATER,
            SpdxLicense.GPL_3_0,
            SpdxLicense.GPL_3_0_PLUS,
            SpdxLicense.GPL_3_0_ONLY,
            SpdxLicense.GPL_3_0_OR_LATER,
            SpdxLicense.GPL_3_0_WITH_GCC_EXCEPTION,
            SpdxLicense.HPND,
            SpdxLicense.IPA,
            SpdxLicense.IPL_1_0,
            SpdxLicense.ISC,
            SpdxLicense.INTEL,
            SpdxLicense.LGPL_2_0,
            SpdxLicense.LGPL_2_0_PLUS,
            SpdxLicense.LGPL_2_0_ONLY,
            SpdxLicense.LGPL_2_0_OR_LATER,
            SpdxLicense.LGPL_2_1,
            SpdxLicense.LGPL_2_1_PLUS,
            SpdxLicense.LGPL_2_1_ONLY,
            SpdxLicense.LGPL_2_1_OR_LATER,
            SpdxLicense.LGPL_3_0,
            SpdxLicense.LGPL_3_0_PLUS,
            SpdxLicense.LGPL_3_0_ONLY,
            SpdxLicense.LGPL_3_0_OR_LATER,
            SpdxLicense.LPL_1_0,
            SpdxLicense.LPL_1_02,
            SpdxLicense.LPPL_1_3C,
            SpdxLicense.LILIQ_P_1_1,
            SpdxLicense.LILIQ_R_1_1,
            SpdxLicense.LILIQ_RPLUS_1_1,
            SpdxLicense.MIT,
            SpdxLicense.MIT_0,
            SpdxLicense.MPL_1_0,
            SpdxLicense.MPL_1_1,
            SpdxLicense.MPL_2_0,
            SpdxLicense.MPL_2_0_NO_COPYLEFT_EXCEPTION,
            SpdxLicense.MS_PL,
            SpdxLicense.MS_RL,
            SpdxLicense.MIR_O_S,
            SpdxLicense.MOTOSOTO,
            SpdxLicense.MULANPSL_2_0,
            SpdxLicense.MULTICS,
            SpdxLicense.NASA_1_3,
            SpdxLicense.NCSA,
            SpdxLicense.NGPL,
            SpdxLicense.NPOSL_3_0,
            SpdxLicense.NTP,
            SpdxLicense.NAUMEN,
            SpdxLicense.NOKIA,
            SpdxLicense.OCLC_2_0,
            SpdxLicense.OFL_1_1,
            SpdxLicense.OFL_1_1_RFN,
            SpdxLicense.OFL_1_1_NO_RFN,
            SpdxLicense.OGTSL,
            SpdxLicense.OLDAP_2_8,
            SpdxLicense.OSET_PL_2_1,
            SpdxLicense.OSL_1_0,
            SpdxLicense.OSL_2_0,
            SpdxLicense.OSL_2_1,
            SpdxLicense.OSL_3_0,
            SpdxLicense.PHP_3_0,
            SpdxLicense.PHP_3_01,
            SpdxLicense.POSTGRE_SQ_L,
            SpdxLicense.PYTHON_2_0,
            SpdxLicense.QPL_1_0,
            SpdxLicense.RPL_1_1,
            SpdxLicense.RPL_1_5,
            SpdxLicense.RPSL_1_0,
            SpdxLicense.RSCPL,
            SpdxLicense.SISSL,
            SpdxLicense.SPL_1_0,
            SpdxLicense.SIMPL_2_0,
            SpdxLicense.SLEEPYCAT,
            SpdxLicense.UCL_1_0,
            SpdxLicense.UPL_1_0,
            SpdxLicense.UNICODE_DFS_2016,
            SpdxLicense.UNLICENSE,
            SpdxLicense.VSL_1_0,
            SpdxLicense.W3_C,
            SpdxLicense.WATCOM_1_0,
            SpdxLicense.XNET,
            SpdxLicense.ZPL_2_0,
            SpdxLicense.ZLIB,
        ];
    }
    /**
     * (experimental) The Apache family of licenses.
     *
     * @experimental
     */
    static apache() {
        return [
            SpdxLicense.APACHE_1_0,
            SpdxLicense.APACHE_1_1,
            SpdxLicense.APACHE_2_0,
        ];
    }
    /**
     * (experimental) The BSD family of licenses.
     *
     * @experimental
     */
    static bsd() {
        return [
            SpdxLicense.ZERO_BSD,
            SpdxLicense.BSD_1_CLAUSE,
            SpdxLicense.BSD_2_CLAUSE,
            SpdxLicense.BSD_2_CLAUSE_FREEBSD,
            SpdxLicense.BSD_2_CLAUSE_NETBSD,
            SpdxLicense.BSD_2_CLAUSE_PATENT,
            SpdxLicense.BSD_2_CLAUSE_VIEWS,
            SpdxLicense.BSD_3_CLAUSE,
            SpdxLicense.BSD_3_CLAUSE_ATTRIBUTION,
            SpdxLicense.BSD_3_CLAUSE_CLEAR,
            SpdxLicense.BSD_3_CLAUSE_LBNL,
            SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE,
            SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014,
            SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY,
            SpdxLicense.BSD_3_CLAUSE_OPEN_MPI,
            SpdxLicense.BSD_4_CLAUSE,
            SpdxLicense.BSD_4_CLAUSE_UC,
            SpdxLicense.BSD_PROTECTION,
            SpdxLicense.BSD_SOURCE_CODE,
        ];
    }
    /**
     * (experimental) The CDDL family of licenses.
     *
     * @experimental
     */
    static cddl() {
        return [
            SpdxLicense.CDDL_1_0,
            SpdxLicense.CDDL_1_1,
        ];
    }
    /**
     * (experimental) The EPL family of licenses.
     *
     * @experimental
     */
    static epl() {
        return [
            SpdxLicense.EPL_1_0,
            SpdxLicense.EPL_2_0,
        ];
    }
    /**
     * (experimental) The MIT family of licenses.
     *
     * @experimental
     */
    static mit() {
        return [
            SpdxLicense.AML,
            SpdxLicense.MIT,
            SpdxLicense.MIT_0,
            SpdxLicense.MIT_CMU,
            SpdxLicense.MIT_ADVERTISING,
            SpdxLicense.MIT_ENNA,
            SpdxLicense.MIT_FEH,
            SpdxLicense.MIT_OPEN_GROUP,
            SpdxLicense.MITNFA,
        ];
    }
    /**
     * (experimental) The MPL family of licenses.
     *
     * @experimental
     */
    static mpl() {
        return [
            SpdxLicense.MPL_1_0,
            SpdxLicense.MPL_1_1,
            SpdxLicense.MPL_2_0,
            SpdxLicense.MPL_2_0_NO_COPYLEFT_EXCEPTION,
        ];
    }
}
exports.SpdxLicense = SpdxLicense;
_a = JSII_RTTI_SYMBOL_1;
SpdxLicense[_a] = { fqn: "construct-hub.SpdxLicense", version: "0.3.176" };
SpdxLicense._ALL = new Map();
//#region Individual SPDX Licenses
/**
 * (experimental) BSD Zero Clause License.
 *
 * @see http://landley.net/toybox/license.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ZERO_BSD = new SpdxLicense('0BSD');
/**
 * (experimental) Attribution Assurance License.
 *
 * @see https://opensource.org/licenses/attribution
 * @experimental
 * @osiApproved true
 */
SpdxLicense.AAL = new SpdxLicense('AAL');
/**
 * (experimental) Amazon Digital Services License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense
 * @experimental
 */
SpdxLicense.ADSL = new SpdxLicense('ADSL');
/**
 * (experimental) Academic Free License v1.1.
 *
 * @see http://opensource.linux-mirror.org/licenses/afl-1.1.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.AFL_1_1 = new SpdxLicense('AFL-1.1');
/**
 * (experimental) Academic Free License v1.2.
 *
 * @see http://opensource.linux-mirror.org/licenses/afl-1.2.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.AFL_1_2 = new SpdxLicense('AFL-1.2');
/**
 * (experimental) Academic Free License v2.0.
 *
 * @see http://wayback.archive.org/web/20060924134533/http://www.opensource.org/licenses/afl-2.0.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.AFL_2_0 = new SpdxLicense('AFL-2.0');
/**
 * (experimental) Academic Free License v2.1.
 *
 * @see http://opensource.linux-mirror.org/licenses/afl-2.1.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.AFL_2_1 = new SpdxLicense('AFL-2.1');
/**
 * (experimental) Academic Free License v3.0.
 *
 * @see http://www.rosenlaw.com/AFL3.0.htm
 * @experimental
 * @osiApproved true
 */
SpdxLicense.AFL_3_0 = new SpdxLicense('AFL-3.0');
/**
 * (experimental) Affero General Public License v1.0.
 *
 * @see http://www.affero.org/oagpl.html
 * @experimental
 */
SpdxLicense.AGPL_1_0 = new SpdxLicense('AGPL-1.0');
/**
 * (experimental) Affero General Public License v1.0 only.
 *
 * @see http://www.affero.org/oagpl.html
 * @experimental
 */
SpdxLicense.AGPL_1_0_ONLY = new SpdxLicense('AGPL-1.0-only');
/**
 * (experimental) Affero General Public License v1.0 or later.
 *
 * @see http://www.affero.org/oagpl.html
 * @experimental
 */
SpdxLicense.AGPL_1_0_OR_LATER = new SpdxLicense('AGPL-1.0-or-later');
/**
 * (experimental) GNU Affero General Public License v3.0.
 *
 * @see https://www.gnu.org/licenses/agpl.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.AGPL_3_0 = new SpdxLicense('AGPL-3.0');
/**
 * (experimental) GNU Affero General Public License v3.0 only.
 *
 * @see https://www.gnu.org/licenses/agpl.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.AGPL_3_0_ONLY = new SpdxLicense('AGPL-3.0-only');
/**
 * (experimental) GNU Affero General Public License v3.0 or later.
 *
 * @see https://www.gnu.org/licenses/agpl.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.AGPL_3_0_OR_LATER = new SpdxLicense('AGPL-3.0-or-later');
/**
 * (experimental) AMD's plpa_map.c License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License
 * @experimental
 */
SpdxLicense.AMDPLPA = new SpdxLicense('AMDPLPA');
/**
 * (experimental) Apple MIT License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Apple_MIT_License
 * @experimental
 */
SpdxLicense.AML = new SpdxLicense('AML');
/**
 * (experimental) Academy of Motion Picture Arts and Sciences BSD.
 *
 * @see https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD
 * @experimental
 */
SpdxLicense.AMPAS = new SpdxLicense('AMPAS');
/**
 * (experimental) ANTLR Software Rights Notice.
 *
 * @see http://www.antlr2.org/license.html
 * @experimental
 */
SpdxLicense.ANTLR_PD = new SpdxLicense('ANTLR-PD');
/**
 * (experimental) ANTLR Software Rights Notice with license fallback.
 *
 * @see http://www.antlr2.org/license.html
 * @experimental
 */
SpdxLicense.ANTLR_PD_FALLBACK = new SpdxLicense('ANTLR-PD-fallback');
/**
 * (experimental) Adobe Postscript AFM License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM
 * @experimental
 */
SpdxLicense.APAFML = new SpdxLicense('APAFML');
/**
 * (experimental) Adaptive Public License 1.0.
 *
 * @see https://opensource.org/licenses/APL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.APL_1_0 = new SpdxLicense('APL-1.0');
/**
 * (experimental) Apple Public Source License 1.0.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.APSL_1_0 = new SpdxLicense('APSL-1.0');
/**
 * (experimental) Apple Public Source License 1.1.
 *
 * @see http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE
 * @experimental
 * @osiApproved true
 */
SpdxLicense.APSL_1_1 = new SpdxLicense('APSL-1.1');
/**
 * (experimental) Apple Public Source License 1.2.
 *
 * @see http://www.samurajdata.se/opensource/mirror/licenses/apsl.php
 * @experimental
 * @osiApproved true
 */
SpdxLicense.APSL_1_2 = new SpdxLicense('APSL-1.2');
/**
 * (experimental) Apple Public Source License 2.0.
 *
 * @see http://www.opensource.apple.com/license/apsl/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.APSL_2_0 = new SpdxLicense('APSL-2.0');
/**
 * (experimental) Abstyles License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Abstyles
 * @experimental
 */
SpdxLicense.ABSTYLES = new SpdxLicense('Abstyles');
/**
 * (experimental) Adobe Systems Incorporated Source Code License Agreement.
 *
 * @see https://fedoraproject.org/wiki/Licensing/AdobeLicense
 * @experimental
 */
SpdxLicense.ADOBE_2006 = new SpdxLicense('Adobe-2006');
/**
 * (experimental) Adobe Glyph List License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph
 * @experimental
 */
SpdxLicense.ADOBE_GLYPH = new SpdxLicense('Adobe-Glyph');
/**
 * (experimental) Afmparse License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Afmparse
 * @experimental
 */
SpdxLicense.AFMPARSE = new SpdxLicense('Afmparse');
/**
 * (experimental) Aladdin Free Public License.
 *
 * @see http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm
 * @experimental
 */
SpdxLicense.ALADDIN = new SpdxLicense('Aladdin');
/**
 * (experimental) Apache License 1.0.
 *
 * @see http://www.apache.org/licenses/LICENSE-1.0
 * @experimental
 */
SpdxLicense.APACHE_1_0 = new SpdxLicense('Apache-1.0');
/**
 * (experimental) Apache License 1.1.
 *
 * @see http://apache.org/licenses/LICENSE-1.1
 * @experimental
 * @osiApproved true
 */
SpdxLicense.APACHE_1_1 = new SpdxLicense('Apache-1.1');
/**
 * (experimental) Apache License 2.0.
 *
 * @see http://www.apache.org/licenses/LICENSE-2.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.APACHE_2_0 = new SpdxLicense('Apache-2.0');
/**
 * (experimental) Artistic License 1.0.
 *
 * @see https://opensource.org/licenses/Artistic-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ARTISTIC_1_0 = new SpdxLicense('Artistic-1.0');
/**
 * (experimental) Artistic License 1.0 (Perl).
 *
 * @see http://dev.perl.org/licenses/artistic.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ARTISTIC_1_0_PERL = new SpdxLicense('Artistic-1.0-Perl');
/**
 * (experimental) Artistic License 1.0 w/clause 8.
 *
 * @see https://opensource.org/licenses/Artistic-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ARTISTIC_1_0_CL8 = new SpdxLicense('Artistic-1.0-cl8');
/**
 * (experimental) Artistic License 2.0.
 *
 * @see http://www.perlfoundation.org/artistic_license_2_0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ARTISTIC_2_0 = new SpdxLicense('Artistic-2.0');
/**
 * (experimental) BSD 1-Clause License.
 *
 * @see https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823
 * @experimental
 * @osiApproved true
 */
SpdxLicense.BSD_1_CLAUSE = new SpdxLicense('BSD-1-Clause');
/**
 * (experimental) BSD 2-Clause "Simplified" License.
 *
 * @see https://opensource.org/licenses/BSD-2-Clause
 * @experimental
 * @osiApproved true
 */
SpdxLicense.BSD_2_CLAUSE = new SpdxLicense('BSD-2-Clause');
/**
 * (experimental) BSD 2-Clause FreeBSD License.
 *
 * @see http://www.freebsd.org/copyright/freebsd-license.html
 * @experimental
 */
SpdxLicense.BSD_2_CLAUSE_FREEBSD = new SpdxLicense('BSD-2-Clause-FreeBSD');
/**
 * (experimental) BSD 2-Clause NetBSD License.
 *
 * @see http://www.netbsd.org/about/redistribution.html#default
 * @experimental
 */
SpdxLicense.BSD_2_CLAUSE_NETBSD = new SpdxLicense('BSD-2-Clause-NetBSD');
/**
 * (experimental) BSD-2-Clause Plus Patent License.
 *
 * @see https://opensource.org/licenses/BSDplusPatent
 * @experimental
 * @osiApproved true
 */
SpdxLicense.BSD_2_CLAUSE_PATENT = new SpdxLicense('BSD-2-Clause-Patent');
/**
 * (experimental) BSD 2-Clause with views sentence.
 *
 * @see http://www.freebsd.org/copyright/freebsd-license.html
 * @experimental
 */
SpdxLicense.BSD_2_CLAUSE_VIEWS = new SpdxLicense('BSD-2-Clause-Views');
/**
 * (experimental) BSD 3-Clause "New" or "Revised" License.
 *
 * @see https://opensource.org/licenses/BSD-3-Clause
 * @experimental
 * @osiApproved true
 */
SpdxLicense.BSD_3_CLAUSE = new SpdxLicense('BSD-3-Clause');
/**
 * (experimental) BSD with attribution.
 *
 * @see https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution
 * @experimental
 */
SpdxLicense.BSD_3_CLAUSE_ATTRIBUTION = new SpdxLicense('BSD-3-Clause-Attribution');
/**
 * (experimental) BSD 3-Clause Clear License.
 *
 * @see http://labs.metacarta.com/license-explanation.html#license
 * @experimental
 */
SpdxLicense.BSD_3_CLAUSE_CLEAR = new SpdxLicense('BSD-3-Clause-Clear');
/**
 * (experimental) Lawrence Berkeley National Labs BSD variant license.
 *
 * @see https://fedoraproject.org/wiki/Licensing/LBNLBSD
 * @experimental
 * @osiApproved true
 */
SpdxLicense.BSD_3_CLAUSE_LBNL = new SpdxLicense('BSD-3-Clause-LBNL');
/**
 * (experimental) BSD 3-Clause No Nuclear License.
 *
 * @see http://download.oracle.com/otn-pub/java/licenses/bsd.txt?AuthParam=1467140197_43d516ce1776bd08a58235a7785be1cc
 * @experimental
 */
SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE = new SpdxLicense('BSD-3-Clause-No-Nuclear-License');
/**
 * (experimental) BSD 3-Clause No Nuclear License 2014.
 *
 * @see https://java.net/projects/javaeetutorial/pages/BerkeleyLicense
 * @experimental
 */
SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014 = new SpdxLicense('BSD-3-Clause-No-Nuclear-License-2014');
/**
 * (experimental) BSD 3-Clause No Nuclear Warranty.
 *
 * @see https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt
 * @experimental
 */
SpdxLicense.BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY = new SpdxLicense('BSD-3-Clause-No-Nuclear-Warranty');
/**
 * (experimental) BSD 3-Clause Open MPI variant.
 *
 * @see https://www.open-mpi.org/community/license.php
 * @experimental
 */
SpdxLicense.BSD_3_CLAUSE_OPEN_MPI = new SpdxLicense('BSD-3-Clause-Open-MPI');
/**
 * (experimental) BSD 4-Clause "Original" or "Old" License.
 *
 * @see http://directory.fsf.org/wiki/License:BSD_4Clause
 * @experimental
 */
SpdxLicense.BSD_4_CLAUSE = new SpdxLicense('BSD-4-Clause');
/**
 * (experimental) BSD-4-Clause (University of California-Specific).
 *
 * @see http://www.freebsd.org/copyright/license.html
 * @experimental
 */
SpdxLicense.BSD_4_CLAUSE_UC = new SpdxLicense('BSD-4-Clause-UC');
/**
 * (experimental) BSD Protection License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/BSD_Protection_License
 * @experimental
 */
SpdxLicense.BSD_PROTECTION = new SpdxLicense('BSD-Protection');
/**
 * (experimental) BSD Source Code Attribution.
 *
 * @see https://github.com/robbiehanson/CocoaHTTPServer/blob/master/LICENSE.txt
 * @experimental
 */
SpdxLicense.BSD_SOURCE_CODE = new SpdxLicense('BSD-Source-Code');
/**
 * (experimental) Boost Software License 1.0.
 *
 * @see http://www.boost.org/LICENSE_1_0.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.BSL_1_0 = new SpdxLicense('BSL-1.0');
/**
 * (experimental) Business Source License 1.1.
 *
 * @see https://mariadb.com/bsl11/
 * @experimental
 */
SpdxLicense.BUSL_1_1 = new SpdxLicense('BUSL-1.1');
/**
 * (experimental) Bahyph License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Bahyph
 * @experimental
 */
SpdxLicense.BAHYPH = new SpdxLicense('Bahyph');
/**
 * (experimental) Barr License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Barr
 * @experimental
 */
SpdxLicense.BARR = new SpdxLicense('Barr');
/**
 * (experimental) Beerware License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Beerware
 * @experimental
 */
SpdxLicense.BEERWARE = new SpdxLicense('Beerware');
/**
 * (experimental) BitTorrent Open Source License v1.0.
 *
 * @see http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s
 * @experimental
 */
SpdxLicense.BITTORRENT_1_0 = new SpdxLicense('BitTorrent-1.0');
/**
 * (experimental) BitTorrent Open Source License v1.1.
 *
 * @see http://directory.fsf.org/wiki/License:BitTorrentOSL1.1
 * @experimental
 */
SpdxLicense.BITTORRENT_1_1 = new SpdxLicense('BitTorrent-1.1');
/**
 * (experimental) Blue Oak Model License 1.0.0.
 *
 * @see https://blueoakcouncil.org/license/1.0.0
 * @experimental
 */
SpdxLicense.BLUEOAK_1_0_0 = new SpdxLicense('BlueOak-1.0.0');
/**
 * (experimental) Borceux license.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Borceux
 * @experimental
 */
SpdxLicense.BORCEUX = new SpdxLicense('Borceux');
/**
 * (experimental) Cryptographic Autonomy License 1.0.
 *
 * @see http://cryptographicautonomylicense.com/license-text.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.CAL_1_0 = new SpdxLicense('CAL-1.0');
/**
 * (experimental) Cryptographic Autonomy License 1.0 (Combined Work Exception).
 *
 * @see http://cryptographicautonomylicense.com/license-text.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.CAL_1_0_COMBINED_WORK_EXCEPTION = new SpdxLicense('CAL-1.0-Combined-Work-Exception');
/**
 * (experimental) Computer Associates Trusted Open Source License 1.1.
 *
 * @see https://opensource.org/licenses/CATOSL-1.1
 * @experimental
 * @osiApproved true
 */
SpdxLicense.CATOSL_1_1 = new SpdxLicense('CATOSL-1.1');
/**
 * (experimental) Creative Commons Attribution 1.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by/1.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_1_0 = new SpdxLicense('CC-BY-1.0');
/**
 * (experimental) Creative Commons Attribution 2.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by/2.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_2_0 = new SpdxLicense('CC-BY-2.0');
/**
 * (experimental) Creative Commons Attribution 2.5 Generic.
 *
 * @see https://creativecommons.org/licenses/by/2.5/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_2_5 = new SpdxLicense('CC-BY-2.5');
/**
 * (experimental) Creative Commons Attribution 3.0 Unported.
 *
 * @see https://creativecommons.org/licenses/by/3.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_3_0 = new SpdxLicense('CC-BY-3.0');
/**
 * (experimental) Creative Commons Attribution 3.0 Austria.
 *
 * @see https://creativecommons.org/licenses/by/3.0/at/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_3_0_AT = new SpdxLicense('CC-BY-3.0-AT');
/**
 * (experimental) Creative Commons Attribution 3.0 United States.
 *
 * @see https://creativecommons.org/licenses/by/3.0/us/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_3_0_US = new SpdxLicense('CC-BY-3.0-US');
/**
 * (experimental) Creative Commons Attribution 4.0 International.
 *
 * @see https://creativecommons.org/licenses/by/4.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_4_0 = new SpdxLicense('CC-BY-4.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial 1.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nc/1.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_1_0 = new SpdxLicense('CC-BY-NC-1.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial 2.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nc/2.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_2_0 = new SpdxLicense('CC-BY-NC-2.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial 2.5 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nc/2.5/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_2_5 = new SpdxLicense('CC-BY-NC-2.5');
/**
 * (experimental) Creative Commons Attribution Non Commercial 3.0 Unported.
 *
 * @see https://creativecommons.org/licenses/by-nc/3.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_3_0 = new SpdxLicense('CC-BY-NC-3.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial 4.0 International.
 *
 * @see https://creativecommons.org/licenses/by-nc/4.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_4_0 = new SpdxLicense('CC-BY-NC-4.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_ND_1_0 = new SpdxLicense('CC-BY-NC-ND-1.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_ND_2_0 = new SpdxLicense('CC-BY-NC-ND-2.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_ND_2_5 = new SpdxLicense('CC-BY-NC-ND-2.5');
/**
 * (experimental) Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported.
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_ND_3_0 = new SpdxLicense('CC-BY-NC-ND-3.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO.
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/3.0/igo/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_ND_3_0_IGO = new SpdxLicense('CC-BY-NC-ND-3.0-IGO');
/**
 * (experimental) Creative Commons Attribution Non Commercial No Derivatives 4.0 International.
 *
 * @see https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_ND_4_0 = new SpdxLicense('CC-BY-NC-ND-4.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial Share Alike 1.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_SA_1_0 = new SpdxLicense('CC-BY-NC-SA-1.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial Share Alike 2.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_SA_2_0 = new SpdxLicense('CC-BY-NC-SA-2.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial Share Alike 2.5 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_SA_2_5 = new SpdxLicense('CC-BY-NC-SA-2.5');
/**
 * (experimental) Creative Commons Attribution Non Commercial Share Alike 3.0 Unported.
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_SA_3_0 = new SpdxLicense('CC-BY-NC-SA-3.0');
/**
 * (experimental) Creative Commons Attribution Non Commercial Share Alike 4.0 International.
 *
 * @see https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_NC_SA_4_0 = new SpdxLicense('CC-BY-NC-SA-4.0');
/**
 * (experimental) Creative Commons Attribution No Derivatives 1.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nd/1.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_ND_1_0 = new SpdxLicense('CC-BY-ND-1.0');
/**
 * (experimental) Creative Commons Attribution No Derivatives 2.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nd/2.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_ND_2_0 = new SpdxLicense('CC-BY-ND-2.0');
/**
 * (experimental) Creative Commons Attribution No Derivatives 2.5 Generic.
 *
 * @see https://creativecommons.org/licenses/by-nd/2.5/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_ND_2_5 = new SpdxLicense('CC-BY-ND-2.5');
/**
 * (experimental) Creative Commons Attribution No Derivatives 3.0 Unported.
 *
 * @see https://creativecommons.org/licenses/by-nd/3.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_ND_3_0 = new SpdxLicense('CC-BY-ND-3.0');
/**
 * (experimental) Creative Commons Attribution No Derivatives 4.0 International.
 *
 * @see https://creativecommons.org/licenses/by-nd/4.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_ND_4_0 = new SpdxLicense('CC-BY-ND-4.0');
/**
 * (experimental) Creative Commons Attribution Share Alike 1.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-sa/1.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_SA_1_0 = new SpdxLicense('CC-BY-SA-1.0');
/**
 * (experimental) Creative Commons Attribution Share Alike 2.0 Generic.
 *
 * @see https://creativecommons.org/licenses/by-sa/2.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_SA_2_0 = new SpdxLicense('CC-BY-SA-2.0');
/**
 * (experimental) Creative Commons Attribution Share Alike 2.0 England and Wales.
 *
 * @see https://creativecommons.org/licenses/by-sa/2.0/uk/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_SA_2_0_UK = new SpdxLicense('CC-BY-SA-2.0-UK');
/**
 * (experimental) Creative Commons Attribution Share Alike 2.5 Generic.
 *
 * @see https://creativecommons.org/licenses/by-sa/2.5/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_SA_2_5 = new SpdxLicense('CC-BY-SA-2.5');
/**
 * (experimental) Creative Commons Attribution Share Alike 3.0 Unported.
 *
 * @see https://creativecommons.org/licenses/by-sa/3.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_SA_3_0 = new SpdxLicense('CC-BY-SA-3.0');
/**
 * (experimental) Creative Commons Attribution-Share Alike 3.0 Austria.
 *
 * @see https://creativecommons.org/licenses/by-sa/3.0/at/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_SA_3_0_AT = new SpdxLicense('CC-BY-SA-3.0-AT');
/**
 * (experimental) Creative Commons Attribution Share Alike 4.0 International.
 *
 * @see https://creativecommons.org/licenses/by-sa/4.0/legalcode
 * @experimental
 */
SpdxLicense.CC_BY_SA_4_0 = new SpdxLicense('CC-BY-SA-4.0');
/**
 * (experimental) Creative Commons Public Domain Dedication and Certification.
 *
 * @see https://creativecommons.org/licenses/publicdomain/
 * @experimental
 */
SpdxLicense.CC_PDDC = new SpdxLicense('CC-PDDC');
/**
 * (experimental) Creative Commons Zero v1.0 Universal.
 *
 * @see https://creativecommons.org/publicdomain/zero/1.0/legalcode
 * @experimental
 */
SpdxLicense.CC0_1_0 = new SpdxLicense('CC0-1.0');
/**
 * (experimental) Common Development and Distribution License 1.0.
 *
 * @see https://opensource.org/licenses/cddl1
 * @experimental
 * @osiApproved true
 */
SpdxLicense.CDDL_1_0 = new SpdxLicense('CDDL-1.0');
/**
 * (experimental) Common Development and Distribution License 1.1.
 *
 * @see http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * @experimental
 */
SpdxLicense.CDDL_1_1 = new SpdxLicense('CDDL-1.1');
/**
 * (experimental) Community Data License Agreement Permissive 1.0.
 *
 * @see https://cdla.io/permissive-1-0
 * @experimental
 */
SpdxLicense.CDLA_PERMISSIVE_1_0 = new SpdxLicense('CDLA-Permissive-1.0');
/**
 * (experimental) Community Data License Agreement Sharing 1.0.
 *
 * @see https://cdla.io/sharing-1-0
 * @experimental
 */
SpdxLicense.CDLA_SHARING_1_0 = new SpdxLicense('CDLA-Sharing-1.0');
/**
 * (experimental) CeCILL Free Software License Agreement v1.0.
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html
 * @experimental
 */
SpdxLicense.CECILL_1_0 = new SpdxLicense('CECILL-1.0');
/**
 * (experimental) CeCILL Free Software License Agreement v1.1.
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html
 * @experimental
 */
SpdxLicense.CECILL_1_1 = new SpdxLicense('CECILL-1.1');
/**
 * (experimental) CeCILL Free Software License Agreement v2.0.
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
 * @experimental
 */
SpdxLicense.CECILL_2_0 = new SpdxLicense('CECILL-2.0');
/**
 * (experimental) CeCILL Free Software License Agreement v2.1.
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.CECILL_2_1 = new SpdxLicense('CECILL-2.1');
/**
 * (experimental) CeCILL-B Free Software License Agreement.
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * @experimental
 */
SpdxLicense.CECILL_B = new SpdxLicense('CECILL-B');
/**
 * (experimental) CeCILL-C Free Software License Agreement.
 *
 * @see http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html
 * @experimental
 */
SpdxLicense.CECILL_C = new SpdxLicense('CECILL-C');
/**
 * (experimental) CERN Open Hardware Licence v1.1.
 *
 * @see https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.1
 * @experimental
 */
SpdxLicense.CERN_OHL_1_1 = new SpdxLicense('CERN-OHL-1.1');
/**
 * (experimental) CERN Open Hardware Licence v1.2.
 *
 * @see https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.2
 * @experimental
 */
SpdxLicense.CERN_OHL_1_2 = new SpdxLicense('CERN-OHL-1.2');
/**
 * (experimental) CERN Open Hardware Licence Version 2 - Permissive.
 *
 * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
 * @experimental
 */
SpdxLicense.CERN_OHL_P_2_0 = new SpdxLicense('CERN-OHL-P-2.0');
/**
 * (experimental) CERN Open Hardware Licence Version 2 - Strongly Reciprocal.
 *
 * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
 * @experimental
 */
SpdxLicense.CERN_OHL_S_2_0 = new SpdxLicense('CERN-OHL-S-2.0');
/**
 * (experimental) CERN Open Hardware Licence Version 2 - Weakly Reciprocal.
 *
 * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
 * @experimental
 */
SpdxLicense.CERN_OHL_W_2_0 = new SpdxLicense('CERN-OHL-W-2.0');
/**
 * (experimental) CNRI Jython License.
 *
 * @see http://www.jython.org/license.html
 * @experimental
 */
SpdxLicense.CNRI_JYTHON = new SpdxLicense('CNRI-Jython');
/**
 * (experimental) CNRI Python License.
 *
 * @see https://opensource.org/licenses/CNRI-Python
 * @experimental
 * @osiApproved true
 */
SpdxLicense.CNRI_PYTHON = new SpdxLicense('CNRI-Python');
/**
 * (experimental) CNRI Python Open Source GPL Compatible License Agreement.
 *
 * @see http://www.python.org/download/releases/1.6.1/download_win/
 * @experimental
 */
SpdxLicense.CNRI_PYTHON_GPL_COMPATIBLE = new SpdxLicense('CNRI-Python-GPL-Compatible');
/**
 * (experimental) Common Public Attribution License 1.0.
 *
 * @see https://opensource.org/licenses/CPAL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.CPAL_1_0 = new SpdxLicense('CPAL-1.0');
/**
 * (experimental) Common Public License 1.0.
 *
 * @see https://opensource.org/licenses/CPL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.CPL_1_0 = new SpdxLicense('CPL-1.0');
/**
 * (experimental) Code Project Open License 1.02.
 *
 * @see http://www.codeproject.com/info/cpol10.aspx
 * @experimental
 */
SpdxLicense.CPOL_1_02 = new SpdxLicense('CPOL-1.02');
/**
 * (experimental) CUA Office Public License v1.0.
 *
 * @see https://opensource.org/licenses/CUA-OPL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.CUA_OPL_1_0 = new SpdxLicense('CUA-OPL-1.0');
/**
 * (experimental) Caldera License.
 *
 * @see http://www.lemis.com/grog/UNIX/ancient-source-all.pdf
 * @experimental
 */
SpdxLicense.CALDERA = new SpdxLicense('Caldera');
/**
 * (experimental) Clarified Artistic License.
 *
 * @see http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/
 * @experimental
 */
SpdxLicense.CL_ARTISTIC = new SpdxLicense('ClArtistic');
/**
 * (experimental) Condor Public License v1.1.
 *
 * @see http://research.cs.wisc.edu/condor/license.html#condor
 * @experimental
 */
SpdxLicense.CONDOR_1_1 = new SpdxLicense('Condor-1.1');
/**
 * (experimental) Crossword License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Crossword
 * @experimental
 */
SpdxLicense.CROSSWORD = new SpdxLicense('Crossword');
/**
 * (experimental) CrystalStacker License.
 *
 * @see https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker
 * @experimental
 */
SpdxLicense.CRYSTAL_STACKER = new SpdxLicense('CrystalStacker');
/**
 * (experimental) Cube License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Cube
 * @experimental
 */
SpdxLicense.CUBE = new SpdxLicense('Cube');
/**
 * (experimental) Deutsche Freie Software Lizenz.
 *
 * @see http://www.dipp.nrw.de/d-fsl/lizenzen/
 * @experimental
 */
SpdxLicense.D_FSL_1_0 = new SpdxLicense('D-FSL-1.0');
/**
 * (experimental) DOC License.
 *
 * @see http://www.cs.wustl.edu/~schmidt/ACE-copying.html
 * @experimental
 */
SpdxLicense.DOC = new SpdxLicense('DOC');
/**
 * (experimental) DSDP License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/DSDP
 * @experimental
 */
SpdxLicense.DSDP = new SpdxLicense('DSDP');
/**
 * (experimental) Dotseqn License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Dotseqn
 * @experimental
 */
SpdxLicense.DOTSEQN = new SpdxLicense('Dotseqn');
/**
 * (experimental) Educational Community License v1.0.
 *
 * @see https://opensource.org/licenses/ECL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ECL_1_0 = new SpdxLicense('ECL-1.0');
/**
 * (experimental) Educational Community License v2.0.
 *
 * @see https://opensource.org/licenses/ECL-2.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ECL_2_0 = new SpdxLicense('ECL-2.0');
/**
 * (experimental) Eiffel Forum License v1.0.
 *
 * @see http://www.eiffel-nice.org/license/forum.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.EFL_1_0 = new SpdxLicense('EFL-1.0');
/**
 * (experimental) Eiffel Forum License v2.0.
 *
 * @see http://www.eiffel-nice.org/license/eiffel-forum-license-2.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.EFL_2_0 = new SpdxLicense('EFL-2.0');
/**
 * (experimental) EPICS Open License.
 *
 * @see https://epics.anl.gov/license/open.php
 * @experimental
 */
SpdxLicense.EPICS = new SpdxLicense('EPICS');
/**
 * (experimental) Eclipse Public License 1.0.
 *
 * @see http://www.eclipse.org/legal/epl-v10.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.EPL_1_0 = new SpdxLicense('EPL-1.0');
/**
 * (experimental) Eclipse Public License 2.0.
 *
 * @see https://www.eclipse.org/legal/epl-2.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.EPL_2_0 = new SpdxLicense('EPL-2.0');
/**
 * (experimental) EU DataGrid Software License.
 *
 * @see http://eu-datagrid.web.cern.ch/eu-datagrid/license.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.EUDATAGRID = new SpdxLicense('EUDatagrid');
/**
 * (experimental) European Union Public License 1.0.
 *
 * @see http://ec.europa.eu/idabc/en/document/7330.html
 * @experimental
 */
SpdxLicense.EUPL_1_0 = new SpdxLicense('EUPL-1.0');
/**
 * (experimental) European Union Public License 1.1.
 *
 * @see https://joinup.ec.europa.eu/software/page/eupl/licence-eupl
 * @experimental
 * @osiApproved true
 */
SpdxLicense.EUPL_1_1 = new SpdxLicense('EUPL-1.1');
/**
 * (experimental) European Union Public License 1.2.
 *
 * @see https://joinup.ec.europa.eu/page/eupl-text-11-12
 * @experimental
 * @osiApproved true
 */
SpdxLicense.EUPL_1_2 = new SpdxLicense('EUPL-1.2');
/**
 * (experimental) Entessa Public License v1.0.
 *
 * @see https://opensource.org/licenses/Entessa
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ENTESSA = new SpdxLicense('Entessa');
/**
 * (experimental) Erlang Public License v1.1.
 *
 * @see http://www.erlang.org/EPLICENSE
 * @experimental
 */
SpdxLicense.ERLPL_1_1 = new SpdxLicense('ErlPL-1.1');
/**
 * (experimental) Eurosym License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Eurosym
 * @experimental
 */
SpdxLicense.EUROSYM = new SpdxLicense('Eurosym');
/**
 * (experimental) FSF All Permissive License.
 *
 * @see https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html
 * @experimental
 */
SpdxLicense.FSFAP = new SpdxLicense('FSFAP');
/**
 * (experimental) FSF Unlimited License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License
 * @experimental
 */
SpdxLicense.FSFUL = new SpdxLicense('FSFUL');
/**
 * (experimental) FSF Unlimited License (with License Retention).
 *
 * @see https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant
 * @experimental
 */
SpdxLicense.FSFULLR = new SpdxLicense('FSFULLR');
/**
 * (experimental) Freetype Project License.
 *
 * @see http://freetype.fis.uniroma2.it/FTL.TXT
 * @experimental
 */
SpdxLicense.FTL = new SpdxLicense('FTL');
/**
 * (experimental) Fair License.
 *
 * @see http://fairlicense.org/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.FAIR = new SpdxLicense('Fair');
/**
 * (experimental) Frameworx Open License 1.0.
 *
 * @see https://opensource.org/licenses/Frameworx-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.FRAMEWORX_1_0 = new SpdxLicense('Frameworx-1.0');
/**
 * (experimental) FreeImage Public License v1.0.
 *
 * @see http://freeimage.sourceforge.net/freeimage-license.txt
 * @experimental
 */
SpdxLicense.FREE_IMAGE = new SpdxLicense('FreeImage');
/**
 * (experimental) GNU Free Documentation License v1.1.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 * @experimental
 */
SpdxLicense.GFDL_1_1 = new SpdxLicense('GFDL-1.1');
/**
 * (experimental) GNU Free Documentation License v1.1 only - invariants.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 * @experimental
 */
SpdxLicense.GFDL_1_1_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.1-invariants-only');
/**
 * (experimental) GNU Free Documentation License v1.1 or later - invariants.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 * @experimental
 */
SpdxLicense.GFDL_1_1_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.1-invariants-or-later');
/**
 * (experimental) GNU Free Documentation License v1.1 only - no invariants.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 * @experimental
 */
SpdxLicense.GFDL_1_1_NO_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.1-no-invariants-only');
/**
 * (experimental) GNU Free Documentation License v1.1 or later - no invariants.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 * @experimental
 */
SpdxLicense.GFDL_1_1_NO_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.1-no-invariants-or-later');
/**
 * (experimental) GNU Free Documentation License v1.1 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 * @experimental
 */
SpdxLicense.GFDL_1_1_ONLY = new SpdxLicense('GFDL-1.1-only');
/**
 * (experimental) GNU Free Documentation License v1.1 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
 * @experimental
 */
SpdxLicense.GFDL_1_1_OR_LATER = new SpdxLicense('GFDL-1.1-or-later');
/**
 * (experimental) GNU Free Documentation License v1.2.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 * @experimental
 */
SpdxLicense.GFDL_1_2 = new SpdxLicense('GFDL-1.2');
/**
 * (experimental) GNU Free Documentation License v1.2 only - invariants.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 * @experimental
 */
SpdxLicense.GFDL_1_2_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.2-invariants-only');
/**
 * (experimental) GNU Free Documentation License v1.2 or later - invariants.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 * @experimental
 */
SpdxLicense.GFDL_1_2_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.2-invariants-or-later');
/**
 * (experimental) GNU Free Documentation License v1.2 only - no invariants.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 * @experimental
 */
SpdxLicense.GFDL_1_2_NO_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.2-no-invariants-only');
/**
 * (experimental) GNU Free Documentation License v1.2 or later - no invariants.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 * @experimental
 */
SpdxLicense.GFDL_1_2_NO_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.2-no-invariants-or-later');
/**
 * (experimental) GNU Free Documentation License v1.2 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 * @experimental
 */
SpdxLicense.GFDL_1_2_ONLY = new SpdxLicense('GFDL-1.2-only');
/**
 * (experimental) GNU Free Documentation License v1.2 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
 * @experimental
 */
SpdxLicense.GFDL_1_2_OR_LATER = new SpdxLicense('GFDL-1.2-or-later');
/**
 * (experimental) GNU Free Documentation License v1.3.
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 * @experimental
 */
SpdxLicense.GFDL_1_3 = new SpdxLicense('GFDL-1.3');
/**
 * (experimental) GNU Free Documentation License v1.3 only - invariants.
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 * @experimental
 */
SpdxLicense.GFDL_1_3_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.3-invariants-only');
/**
 * (experimental) GNU Free Documentation License v1.3 or later - invariants.
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 * @experimental
 */
SpdxLicense.GFDL_1_3_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.3-invariants-or-later');
/**
 * (experimental) GNU Free Documentation License v1.3 only - no invariants.
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 * @experimental
 */
SpdxLicense.GFDL_1_3_NO_INVARIANTS_ONLY = new SpdxLicense('GFDL-1.3-no-invariants-only');
/**
 * (experimental) GNU Free Documentation License v1.3 or later - no invariants.
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 * @experimental
 */
SpdxLicense.GFDL_1_3_NO_INVARIANTS_OR_LATER = new SpdxLicense('GFDL-1.3-no-invariants-or-later');
/**
 * (experimental) GNU Free Documentation License v1.3 only.
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 * @experimental
 */
SpdxLicense.GFDL_1_3_ONLY = new SpdxLicense('GFDL-1.3-only');
/**
 * (experimental) GNU Free Documentation License v1.3 or later.
 *
 * @see https://www.gnu.org/licenses/fdl-1.3.txt
 * @experimental
 */
SpdxLicense.GFDL_1_3_OR_LATER = new SpdxLicense('GFDL-1.3-or-later');
/**
 * (experimental) GL2PS License.
 *
 * @see http://www.geuz.org/gl2ps/COPYING.GL2PS
 * @experimental
 */
SpdxLicense.GL2_P_S = new SpdxLicense('GL2PS');
/**
 * (experimental) Good Luck With That Public License.
 *
 * @see https://github.com/me-shaon/GLWTPL/commit/da5f6bc734095efbacb442c0b31e33a65b9d6e85
 * @experimental
 */
SpdxLicense.GLWTPL = new SpdxLicense('GLWTPL');
/**
 * (experimental) GNU General Public License v1.0 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
 * @experimental
 */
SpdxLicense.GPL_1_0 = new SpdxLicense('GPL-1.0');
/**
 * (experimental) GNU General Public License v1.0 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
 * @experimental
 */
SpdxLicense.GPL_1_0_PLUS = new SpdxLicense('GPL-1.0+');
/**
 * (experimental) GNU General Public License v1.0 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
 * @experimental
 */
SpdxLicense.GPL_1_0_ONLY = new SpdxLicense('GPL-1.0-only');
/**
 * (experimental) GNU General Public License v1.0 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
 * @experimental
 */
SpdxLicense.GPL_1_0_OR_LATER = new SpdxLicense('GPL-1.0-or-later');
/**
 * (experimental) GNU General Public License v2.0 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.GPL_2_0 = new SpdxLicense('GPL-2.0');
/**
 * (experimental) GNU General Public License v2.0 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.GPL_2_0_PLUS = new SpdxLicense('GPL-2.0+');
/**
 * (experimental) GNU General Public License v2.0 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.GPL_2_0_ONLY = new SpdxLicense('GPL-2.0-only');
/**
 * (experimental) GNU General Public License v2.0 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.GPL_2_0_OR_LATER = new SpdxLicense('GPL-2.0-or-later');
/**
 * (experimental) GNU General Public License v2.0 w/GCC Runtime Library exception.
 *
 * @see https://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10
 * @experimental
 */
SpdxLicense.GPL_2_0_WITH_GCC_EXCEPTION = new SpdxLicense('GPL-2.0-with-GCC-exception');
/**
 * (experimental) GNU General Public License v2.0 w/Autoconf exception.
 *
 * @see http://ac-archive.sourceforge.net/doc/copyright.html
 * @experimental
 */
SpdxLicense.GPL_2_0_WITH_AUTOCONF_EXCEPTION = new SpdxLicense('GPL-2.0-with-autoconf-exception');
/**
 * (experimental) GNU General Public License v2.0 w/Bison exception.
 *
 * @see http://git.savannah.gnu.org/cgit/bison.git/tree/data/yacc.c?id=193d7c7054ba7197b0789e14965b739162319b5e#n141
 * @experimental
 */
SpdxLicense.GPL_2_0_WITH_BISON_EXCEPTION = new SpdxLicense('GPL-2.0-with-bison-exception');
/**
 * (experimental) GNU General Public License v2.0 w/Classpath exception.
 *
 * @see https://www.gnu.org/software/classpath/license.html
 * @experimental
 */
SpdxLicense.GPL_2_0_WITH_CLASSPATH_EXCEPTION = new SpdxLicense('GPL-2.0-with-classpath-exception');
/**
 * (experimental) GNU General Public License v2.0 w/Font exception.
 *
 * @see https://www.gnu.org/licenses/gpl-faq.html#FontException
 * @experimental
 */
SpdxLicense.GPL_2_0_WITH_FONT_EXCEPTION = new SpdxLicense('GPL-2.0-with-font-exception');
/**
 * (experimental) GNU General Public License v3.0 only.
 *
 * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.GPL_3_0 = new SpdxLicense('GPL-3.0');
/**
 * (experimental) GNU General Public License v3.0 or later.
 *
 * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.GPL_3_0_PLUS = new SpdxLicense('GPL-3.0+');
/**
 * (experimental) GNU General Public License v3.0 only.
 *
 * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.GPL_3_0_ONLY = new SpdxLicense('GPL-3.0-only');
/**
 * (experimental) GNU General Public License v3.0 or later.
 *
 * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.GPL_3_0_OR_LATER = new SpdxLicense('GPL-3.0-or-later');
/**
 * (experimental) GNU General Public License v3.0 w/GCC Runtime Library exception.
 *
 * @see https://www.gnu.org/licenses/gcc-exception-3.1.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.GPL_3_0_WITH_GCC_EXCEPTION = new SpdxLicense('GPL-3.0-with-GCC-exception');
/**
 * (experimental) GNU General Public License v3.0 w/Autoconf exception.
 *
 * @see https://www.gnu.org/licenses/autoconf-exception-3.0.html
 * @experimental
 */
SpdxLicense.GPL_3_0_WITH_AUTOCONF_EXCEPTION = new SpdxLicense('GPL-3.0-with-autoconf-exception');
/**
 * (experimental) Giftware License.
 *
 * @see http://liballeg.org/license.html#allegro-4-the-giftware-license
 * @experimental
 */
SpdxLicense.GIFTWARE = new SpdxLicense('Giftware');
/**
 * (experimental) 3dfx Glide License.
 *
 * @see http://www.users.on.net/~triforce/glidexp/COPYING.txt
 * @experimental
 */
SpdxLicense.GLIDE = new SpdxLicense('Glide');
/**
 * (experimental) Glulxe License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Glulxe
 * @experimental
 */
SpdxLicense.GLULXE = new SpdxLicense('Glulxe');
/**
 * (experimental) Historical Permission Notice and Disclaimer.
 *
 * @see https://opensource.org/licenses/HPND
 * @experimental
 * @osiApproved true
 */
SpdxLicense.HPND = new SpdxLicense('HPND');
/**
 * (experimental) Historical Permission Notice and Disclaimer - sell variant.
 *
 * @see https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/net/sunrpc/auth_gss/gss_generic_token.c?h=v4.19
 * @experimental
 */
SpdxLicense.HPND_SELL_VARIANT = new SpdxLicense('HPND-sell-variant');
/**
 * (experimental) HTML Tidy License.
 *
 * @see https://github.com/htacg/tidy-html5/blob/next/README/LICENSE.md
 * @experimental
 */
SpdxLicense.HTMLTIDY = new SpdxLicense('HTMLTIDY');
/**
 * (experimental) Haskell Language Report License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License
 * @experimental
 */
SpdxLicense.HASKELL_REPORT = new SpdxLicense('HaskellReport');
/**
 * (experimental) Hippocratic License 2.1.
 *
 * @see https://firstdonoharm.dev/version/2/1/license.html
 * @experimental
 */
SpdxLicense.HIPPOCRATIC_2_1 = new SpdxLicense('Hippocratic-2.1');
/**
 * (experimental) IBM PowerPC Initialization and Boot Software.
 *
 * @see http://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d
 * @experimental
 */
SpdxLicense.IBM_PIBS = new SpdxLicense('IBM-pibs');
/**
 * (experimental) ICU License.
 *
 * @see http://source.icu-project.org/repos/icu/icu/trunk/license.html
 * @experimental
 */
SpdxLicense.ICU = new SpdxLicense('ICU');
/**
 * (experimental) Independent JPEG Group License.
 *
 * @see http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2
 * @experimental
 */
SpdxLicense.IJG = new SpdxLicense('IJG');
/**
 * (experimental) IPA Font License.
 *
 * @see https://opensource.org/licenses/IPA
 * @experimental
 * @osiApproved true
 */
SpdxLicense.IPA = new SpdxLicense('IPA');
/**
 * (experimental) IBM Public License v1.0.
 *
 * @see https://opensource.org/licenses/IPL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.IPL_1_0 = new SpdxLicense('IPL-1.0');
/**
 * (experimental) ISC License.
 *
 * @see https://www.isc.org/downloads/software-support-policy/isc-license/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ISC = new SpdxLicense('ISC');
/**
 * (experimental) ImageMagick License.
 *
 * @see http://www.imagemagick.org/script/license.php
 * @experimental
 */
SpdxLicense.IMAGE_MAGICK = new SpdxLicense('ImageMagick');
/**
 * (experimental) Imlib2 License.
 *
 * @see http://trac.enlightenment.org/e/browser/trunk/imlib2/COPYING
 * @experimental
 */
SpdxLicense.IMLIB2 = new SpdxLicense('Imlib2');
/**
 * (experimental) Info-ZIP License.
 *
 * @see http://www.info-zip.org/license.html
 * @experimental
 */
SpdxLicense.INFO_ZIP = new SpdxLicense('Info-ZIP');
/**
 * (experimental) Intel Open Source License.
 *
 * @see https://opensource.org/licenses/Intel
 * @experimental
 * @osiApproved true
 */
SpdxLicense.INTEL = new SpdxLicense('Intel');
/**
 * (experimental) Intel ACPI Software License Agreement.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement
 * @experimental
 */
SpdxLicense.INTEL_ACPI = new SpdxLicense('Intel-ACPI');
/**
 * (experimental) Interbase Public License v1.0.
 *
 * @see https://web.archive.org/web/20060319014854/http://info.borland.com/devsupport/interbase/opensource/IPL.html
 * @experimental
 */
SpdxLicense.INTERBASE_1_0 = new SpdxLicense('Interbase-1.0');
/**
 * (experimental) Japan Network Information Center License.
 *
 * @see https://gitlab.isc.org/isc-projects/bind9/blob/master/COPYRIGHT#L366
 * @experimental
 */
SpdxLicense.JPNIC = new SpdxLicense('JPNIC');
/**
 * (experimental) JSON License.
 *
 * @see http://www.json.org/license.html
 * @experimental
 */
SpdxLicense.JSON = new SpdxLicense('JSON');
/**
 * (experimental) JasPer License.
 *
 * @see http://www.ece.uvic.ca/~mdadams/jasper/LICENSE
 * @experimental
 */
SpdxLicense.JASPER_2_0 = new SpdxLicense('JasPer-2.0');
/**
 * (experimental) Licence Art Libre 1.2.
 *
 * @see http://artlibre.org/licence/lal/licence-art-libre-12/
 * @experimental
 */
SpdxLicense.LAL_1_2 = new SpdxLicense('LAL-1.2');
/**
 * (experimental) Licence Art Libre 1.3.
 *
 * @see https://artlibre.org/
 * @experimental
 */
SpdxLicense.LAL_1_3 = new SpdxLicense('LAL-1.3');
/**
 * (experimental) GNU Library General Public License v2 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_2_0 = new SpdxLicense('LGPL-2.0');
/**
 * (experimental) GNU Library General Public License v2 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_2_0_PLUS = new SpdxLicense('LGPL-2.0+');
/**
 * (experimental) GNU Library General Public License v2 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_2_0_ONLY = new SpdxLicense('LGPL-2.0-only');
/**
 * (experimental) GNU Library General Public License v2 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_2_0_OR_LATER = new SpdxLicense('LGPL-2.0-or-later');
/**
 * (experimental) GNU Lesser General Public License v2.1 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_2_1 = new SpdxLicense('LGPL-2.1');
/**
 * (experimental) GNU Library General Public License v2.1 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_2_1_PLUS = new SpdxLicense('LGPL-2.1+');
/**
 * (experimental) GNU Lesser General Public License v2.1 only.
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_2_1_ONLY = new SpdxLicense('LGPL-2.1-only');
/**
 * (experimental) GNU Lesser General Public License v2.1 or later.
 *
 * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_2_1_OR_LATER = new SpdxLicense('LGPL-2.1-or-later');
/**
 * (experimental) GNU Lesser General Public License v3.0 only.
 *
 * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_3_0 = new SpdxLicense('LGPL-3.0');
/**
 * (experimental) GNU Lesser General Public License v3.0 or later.
 *
 * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_3_0_PLUS = new SpdxLicense('LGPL-3.0+');
/**
 * (experimental) GNU Lesser General Public License v3.0 only.
 *
 * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_3_0_ONLY = new SpdxLicense('LGPL-3.0-only');
/**
 * (experimental) GNU Lesser General Public License v3.0 or later.
 *
 * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LGPL_3_0_OR_LATER = new SpdxLicense('LGPL-3.0-or-later');
/**
 * (experimental) Lesser General Public License For Linguistic Resources.
 *
 * @see http://www-igm.univ-mlv.fr/~unitex/lgpllr.html
 * @experimental
 */
SpdxLicense.LGPLLR = new SpdxLicense('LGPLLR');
/**
 * (experimental) Lucent Public License Version 1.0.
 *
 * @see https://opensource.org/licenses/LPL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LPL_1_0 = new SpdxLicense('LPL-1.0');
/**
 * (experimental) Lucent Public License v1.02.
 *
 * @see http://plan9.bell-labs.com/plan9/license.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LPL_1_02 = new SpdxLicense('LPL-1.02');
/**
 * (experimental) LaTeX Project Public License v1.0.
 *
 * @see http://www.latex-project.org/lppl/lppl-1-0.txt
 * @experimental
 */
SpdxLicense.LPPL_1_0 = new SpdxLicense('LPPL-1.0');
/**
 * (experimental) LaTeX Project Public License v1.1.
 *
 * @see http://www.latex-project.org/lppl/lppl-1-1.txt
 * @experimental
 */
SpdxLicense.LPPL_1_1 = new SpdxLicense('LPPL-1.1');
/**
 * (experimental) LaTeX Project Public License v1.2.
 *
 * @see http://www.latex-project.org/lppl/lppl-1-2.txt
 * @experimental
 */
SpdxLicense.LPPL_1_2 = new SpdxLicense('LPPL-1.2');
/**
 * (experimental) LaTeX Project Public License v1.3a.
 *
 * @see http://www.latex-project.org/lppl/lppl-1-3a.txt
 * @experimental
 */
SpdxLicense.LPPL_1_3A = new SpdxLicense('LPPL-1.3a');
/**
 * (experimental) LaTeX Project Public License v1.3c.
 *
 * @see http://www.latex-project.org/lppl/lppl-1-3c.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LPPL_1_3C = new SpdxLicense('LPPL-1.3c');
/**
 * (experimental) Latex2e License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Latex2e
 * @experimental
 */
SpdxLicense.LATEX2_E = new SpdxLicense('Latex2e');
/**
 * (experimental) Leptonica License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Leptonica
 * @experimental
 */
SpdxLicense.LEPTONICA = new SpdxLicense('Leptonica');
/**
 * (experimental) Licence Libre du Québec – Permissive version 1.1.
 *
 * @see https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LILIQ_P_1_1 = new SpdxLicense('LiLiQ-P-1.1');
/**
 * (experimental) Licence Libre du Québec – Réciprocité version 1.1.
 *
 * @see https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LILIQ_R_1_1 = new SpdxLicense('LiLiQ-R-1.1');
/**
 * (experimental) Licence Libre du Québec – Réciprocité forte version 1.1.
 *
 * @see https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.LILIQ_RPLUS_1_1 = new SpdxLicense('LiLiQ-Rplus-1.1');
/**
 * (experimental) libpng License.
 *
 * @see http://www.libpng.org/pub/png/src/libpng-LICENSE.txt
 * @experimental
 */
SpdxLicense.LIBPNG = new SpdxLicense('Libpng');
/**
 * (experimental) Linux Kernel Variant of OpenIB.org license.
 *
 * @see https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/drivers/infiniband/core/sa.h
 * @experimental
 */
SpdxLicense.LINUX_OPENIB = new SpdxLicense('Linux-OpenIB');
/**
 * (experimental) MIT License.
 *
 * @see https://opensource.org/licenses/MIT
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MIT = new SpdxLicense('MIT');
/**
 * (experimental) MIT No Attribution.
 *
 * @see https://github.com/aws/mit-0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MIT_0 = new SpdxLicense('MIT-0');
/**
 * (experimental) CMU License.
 *
 * @see https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style
 * @experimental
 */
SpdxLicense.MIT_CMU = new SpdxLicense('MIT-CMU');
/**
 * (experimental) Enlightenment License (e16).
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising
 * @experimental
 */
SpdxLicense.MIT_ADVERTISING = new SpdxLicense('MIT-advertising');
/**
 * (experimental) enna License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT#enna
 * @experimental
 */
SpdxLicense.MIT_ENNA = new SpdxLicense('MIT-enna');
/**
 * (experimental) feh License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT#feh
 * @experimental
 */
SpdxLicense.MIT_FEH = new SpdxLicense('MIT-feh');
/**
 * (experimental) MIT Open Group variant.
 *
 * @see https://gitlab.freedesktop.org/xorg/app/iceauth/-/blob/master/COPYING
 * @experimental
 */
SpdxLicense.MIT_OPEN_GROUP = new SpdxLicense('MIT-open-group');
/**
 * (experimental) MIT +no-false-attribs license.
 *
 * @see https://fedoraproject.org/wiki/Licensing/MITNFA
 * @experimental
 */
SpdxLicense.MITNFA = new SpdxLicense('MITNFA');
/**
 * (experimental) Mozilla Public License 1.0.
 *
 * @see http://www.mozilla.org/MPL/MPL-1.0.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MPL_1_0 = new SpdxLicense('MPL-1.0');
/**
 * (experimental) Mozilla Public License 1.1.
 *
 * @see http://www.mozilla.org/MPL/MPL-1.1.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MPL_1_1 = new SpdxLicense('MPL-1.1');
/**
 * (experimental) Mozilla Public License 2.0.
 *
 * @see http://www.mozilla.org/MPL/2.0/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MPL_2_0 = new SpdxLicense('MPL-2.0');
/**
 * (experimental) Mozilla Public License 2.0 (no copyleft exception).
 *
 * @see http://www.mozilla.org/MPL/2.0/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MPL_2_0_NO_COPYLEFT_EXCEPTION = new SpdxLicense('MPL-2.0-no-copyleft-exception');
/**
 * (experimental) Microsoft Public License.
 *
 * @see http://www.microsoft.com/opensource/licenses.mspx
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MS_PL = new SpdxLicense('MS-PL');
/**
 * (experimental) Microsoft Reciprocal License.
 *
 * @see http://www.microsoft.com/opensource/licenses.mspx
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MS_RL = new SpdxLicense('MS-RL');
/**
 * (experimental) Matrix Template Library License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License
 * @experimental
 */
SpdxLicense.MTLL = new SpdxLicense('MTLL');
/**
 * (experimental) MakeIndex License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/MakeIndex
 * @experimental
 */
SpdxLicense.MAKE_INDEX = new SpdxLicense('MakeIndex');
/**
 * (experimental) The MirOS Licence.
 *
 * @see https://opensource.org/licenses/MirOS
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MIR_O_S = new SpdxLicense('MirOS');
/**
 * (experimental) Motosoto License.
 *
 * @see https://opensource.org/licenses/Motosoto
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MOTOSOTO = new SpdxLicense('Motosoto');
/**
 * (experimental) Mulan Permissive Software License, Version 1.
 *
 * @see https://license.coscl.org.cn/MulanPSL/
 * @experimental
 */
SpdxLicense.MULANPSL_1_0 = new SpdxLicense('MulanPSL-1.0');
/**
 * (experimental) Mulan Permissive Software License, Version 2.
 *
 * @see https://license.coscl.org.cn/MulanPSL2/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MULANPSL_2_0 = new SpdxLicense('MulanPSL-2.0');
/**
 * (experimental) Multics License.
 *
 * @see https://opensource.org/licenses/Multics
 * @experimental
 * @osiApproved true
 */
SpdxLicense.MULTICS = new SpdxLicense('Multics');
/**
 * (experimental) Mup License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Mup
 * @experimental
 */
SpdxLicense.MUP = new SpdxLicense('Mup');
/**
 * (experimental) NASA Open Source Agreement 1.3.
 *
 * @see http://ti.arc.nasa.gov/opensource/nosa/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.NASA_1_3 = new SpdxLicense('NASA-1.3');
/**
 * (experimental) Net Boolean Public License v1.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894
 * @experimental
 */
SpdxLicense.NBPL_1_0 = new SpdxLicense('NBPL-1.0');
/**
 * (experimental) Non-Commercial Government Licence.
 *
 * @see https://github.com/spdx/license-list-XML/blob/master/src/Apache-2.0.xml
 * @experimental
 */
SpdxLicense.NCGL_UK_2_0 = new SpdxLicense('NCGL-UK-2.0');
/**
 * (experimental) University of Illinois/NCSA Open Source License.
 *
 * @see http://otm.illinois.edu/uiuc_openSource
 * @experimental
 * @osiApproved true
 */
SpdxLicense.NCSA = new SpdxLicense('NCSA');
/**
 * (experimental) Nethack General Public License.
 *
 * @see https://opensource.org/licenses/NGPL
 * @experimental
 * @osiApproved true
 */
SpdxLicense.NGPL = new SpdxLicense('NGPL');
/**
 * (experimental) NIST Public Domain Notice.
 *
 * @see https://github.com/tcheneau/simpleRPL/blob/e645e69e38dd4e3ccfeceb2db8cba05b7c2e0cd3/LICENSE.txt
 * @experimental
 */
SpdxLicense.NIST_PD = new SpdxLicense('NIST-PD');
/**
 * (experimental) NIST Public Domain Notice with license fallback.
 *
 * @see https://github.com/usnistgov/jsip/blob/59700e6926cbe96c5cdae897d9a7d2656b42abe3/LICENSE
 * @experimental
 */
SpdxLicense.NIST_PD_FALLBACK = new SpdxLicense('NIST-PD-fallback');
/**
 * (experimental) Norwegian Licence for Open Government Data.
 *
 * @see http://data.norge.no/nlod/en/1.0
 * @experimental
 */
SpdxLicense.NLOD_1_0 = new SpdxLicense('NLOD-1.0');
/**
 * (experimental) No Limit Public License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/NLPL
 * @experimental
 */
SpdxLicense.NLPL = new SpdxLicense('NLPL');
/**
 * (experimental) Netizen Open Source License.
 *
 * @see http://bits.netizen.com.au/licenses/NOSL/nosl.txt
 * @experimental
 */
SpdxLicense.NOSL = new SpdxLicense('NOSL');
/**
 * (experimental) Netscape Public License v1.0.
 *
 * @see http://www.mozilla.org/MPL/NPL/1.0/
 * @experimental
 */
SpdxLicense.NPL_1_0 = new SpdxLicense('NPL-1.0');
/**
 * (experimental) Netscape Public License v1.1.
 *
 * @see http://www.mozilla.org/MPL/NPL/1.1/
 * @experimental
 */
SpdxLicense.NPL_1_1 = new SpdxLicense('NPL-1.1');
/**
 * (experimental) Non-Profit Open Software License 3.0.
 *
 * @see https://opensource.org/licenses/NOSL3.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.NPOSL_3_0 = new SpdxLicense('NPOSL-3.0');
/**
 * (experimental) NRL License.
 *
 * @see http://web.mit.edu/network/isakmp/nrllicense.html
 * @experimental
 */
SpdxLicense.NRL = new SpdxLicense('NRL');
/**
 * (experimental) NTP License.
 *
 * @see https://opensource.org/licenses/NTP
 * @experimental
 * @osiApproved true
 */
SpdxLicense.NTP = new SpdxLicense('NTP');
/**
 * (experimental) NTP No Attribution.
 *
 * @see https://github.com/tytso/e2fsprogs/blob/master/lib/et/et_name.c
 * @experimental
 */
SpdxLicense.NTP_0 = new SpdxLicense('NTP-0');
/**
 * (experimental) Naumen Public License.
 *
 * @see https://opensource.org/licenses/Naumen
 * @experimental
 * @osiApproved true
 */
SpdxLicense.NAUMEN = new SpdxLicense('Naumen');
/**
 * (experimental) Net-SNMP License.
 *
 * @see http://net-snmp.sourceforge.net/about/license.html
 * @experimental
 */
SpdxLicense.NET_SNMP = new SpdxLicense('Net-SNMP');
/**
 * (experimental) NetCDF license.
 *
 * @see http://www.unidata.ucar.edu/software/netcdf/copyright.html
 * @experimental
 */
SpdxLicense.NET_CD_F = new SpdxLicense('NetCDF');
/**
 * (experimental) Newsletr License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Newsletr
 * @experimental
 */
SpdxLicense.NEWSLETR = new SpdxLicense('Newsletr');
/**
 * (experimental) Nokia Open Source License.
 *
 * @see https://opensource.org/licenses/nokia
 * @experimental
 * @osiApproved true
 */
SpdxLicense.NOKIA = new SpdxLicense('Nokia');
/**
 * (experimental) Noweb License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Noweb
 * @experimental
 */
SpdxLicense.NOWEB = new SpdxLicense('Noweb');
/**
 * (experimental) Nunit License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Nunit
 * @experimental
 */
SpdxLicense.NUNIT = new SpdxLicense('Nunit');
/**
 * (experimental) Open Use of Data Agreement v1.0.
 *
 * @see https://github.com/microsoft/Open-Use-of-Data-Agreement/blob/v1.0/O-UDA-1.0.md
 * @experimental
 */
SpdxLicense.O_UDA_1_0 = new SpdxLicense('O-UDA-1.0');
/**
 * (experimental) Open CASCADE Technology Public License.
 *
 * @see http://www.opencascade.com/content/occt-public-license
 * @experimental
 */
SpdxLicense.OCCT_PL = new SpdxLicense('OCCT-PL');
/**
 * (experimental) OCLC Research Public License 2.0.
 *
 * @see http://www.oclc.org/research/activities/software/license/v2final.htm
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OCLC_2_0 = new SpdxLicense('OCLC-2.0');
/**
 * (experimental) Open Data Commons Attribution License v1.0.
 *
 * @see https://opendatacommons.org/licenses/by/1.0/
 * @experimental
 */
SpdxLicense.ODC_BY_1_0 = new SpdxLicense('ODC-By-1.0');
/**
 * (experimental) ODC Open Database License v1.0.
 *
 * @see http://www.opendatacommons.org/licenses/odbl/1.0/
 * @experimental
 */
SpdxLicense.ODBL_1_0 = new SpdxLicense('ODbL-1.0');
/**
 * (experimental) SIL Open Font License 1.0.
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
 * @experimental
 */
SpdxLicense.OFL_1_0 = new SpdxLicense('OFL-1.0');
/**
 * (experimental) SIL Open Font License 1.0 with Reserved Font Name.
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
 * @experimental
 */
SpdxLicense.OFL_1_0_RFN = new SpdxLicense('OFL-1.0-RFN');
/**
 * (experimental) SIL Open Font License 1.0 with no Reserved Font Name.
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
 * @experimental
 */
SpdxLicense.OFL_1_0_NO_RFN = new SpdxLicense('OFL-1.0-no-RFN');
/**
 * (experimental) SIL Open Font License 1.1.
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OFL_1_1 = new SpdxLicense('OFL-1.1');
/**
 * (experimental) SIL Open Font License 1.1 with Reserved Font Name.
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OFL_1_1_RFN = new SpdxLicense('OFL-1.1-RFN');
/**
 * (experimental) SIL Open Font License 1.1 with no Reserved Font Name.
 *
 * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OFL_1_1_NO_RFN = new SpdxLicense('OFL-1.1-no-RFN');
/**
 * (experimental) OGC Software License, Version 1.0.
 *
 * @see https://www.ogc.org/ogc/software/1.0
 * @experimental
 */
SpdxLicense.OGC_1_0 = new SpdxLicense('OGC-1.0');
/**
 * (experimental) Open Government Licence - Canada.
 *
 * @see https://open.canada.ca/en/open-government-licence-canada
 * @experimental
 */
SpdxLicense.OGL_CANADA_2_0 = new SpdxLicense('OGL-Canada-2.0');
/**
 * (experimental) Open Government Licence v1.0.
 *
 * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/
 * @experimental
 */
SpdxLicense.OGL_UK_1_0 = new SpdxLicense('OGL-UK-1.0');
/**
 * (experimental) Open Government Licence v2.0.
 *
 * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/
 * @experimental
 */
SpdxLicense.OGL_UK_2_0 = new SpdxLicense('OGL-UK-2.0');
/**
 * (experimental) Open Government Licence v3.0.
 *
 * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/
 * @experimental
 */
SpdxLicense.OGL_UK_3_0 = new SpdxLicense('OGL-UK-3.0');
/**
 * (experimental) Open Group Test Suite License.
 *
 * @see http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OGTSL = new SpdxLicense('OGTSL');
/**
 * (experimental) Open LDAP Public License v1.1.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f
 * @experimental
 */
SpdxLicense.OLDAP_1_1 = new SpdxLicense('OLDAP-1.1');
/**
 * (experimental) Open LDAP Public License v1.2.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7
 * @experimental
 */
SpdxLicense.OLDAP_1_2 = new SpdxLicense('OLDAP-1.2');
/**
 * (experimental) Open LDAP Public License v1.3.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1
 * @experimental
 */
SpdxLicense.OLDAP_1_3 = new SpdxLicense('OLDAP-1.3');
/**
 * (experimental) Open LDAP Public License v1.4.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941
 * @experimental
 */
SpdxLicense.OLDAP_1_4 = new SpdxLicense('OLDAP-1.4');
/**
 * (experimental) Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B).
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea
 * @experimental
 */
SpdxLicense.OLDAP_2_0 = new SpdxLicense('OLDAP-2.0');
/**
 * (experimental) Open LDAP Public License v2.0.1.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e
 * @experimental
 */
SpdxLicense.OLDAP_2_0_1 = new SpdxLicense('OLDAP-2.0.1');
/**
 * (experimental) Open LDAP Public License v2.1.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715
 * @experimental
 */
SpdxLicense.OLDAP_2_1 = new SpdxLicense('OLDAP-2.1');
/**
 * (experimental) Open LDAP Public License v2.2.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3
 * @experimental
 */
SpdxLicense.OLDAP_2_2 = new SpdxLicense('OLDAP-2.2');
/**
 * (experimental) Open LDAP Public License v2.2.1.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e
 * @experimental
 */
SpdxLicense.OLDAP_2_2_1 = new SpdxLicense('OLDAP-2.2.1');
/**
 * (experimental) Open LDAP Public License 2.2.2.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188
 * @experimental
 */
SpdxLicense.OLDAP_2_2_2 = new SpdxLicense('OLDAP-2.2.2');
/**
 * (experimental) Open LDAP Public License v2.3.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3
 * @experimental
 */
SpdxLicense.OLDAP_2_3 = new SpdxLicense('OLDAP-2.3');
/**
 * (experimental) Open LDAP Public License v2.4.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386
 * @experimental
 */
SpdxLicense.OLDAP_2_4 = new SpdxLicense('OLDAP-2.4');
/**
 * (experimental) Open LDAP Public License v2.5.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf
 * @experimental
 */
SpdxLicense.OLDAP_2_5 = new SpdxLicense('OLDAP-2.5');
/**
 * (experimental) Open LDAP Public License v2.6.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205
 * @experimental
 */
SpdxLicense.OLDAP_2_6 = new SpdxLicense('OLDAP-2.6');
/**
 * (experimental) Open LDAP Public License v2.7.
 *
 * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2
 * @experimental
 */
SpdxLicense.OLDAP_2_7 = new SpdxLicense('OLDAP-2.7');
/**
 * (experimental) Open LDAP Public License v2.8.
 *
 * @see http://www.openldap.org/software/release/license.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OLDAP_2_8 = new SpdxLicense('OLDAP-2.8');
/**
 * (experimental) Open Market License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Open_Market_License
 * @experimental
 */
SpdxLicense.OML = new SpdxLicense('OML');
/**
 * (experimental) Open Public License v1.0.
 *
 * @see http://old.koalateam.com/jackaroo/OPL_1_0.TXT
 * @experimental
 */
SpdxLicense.OPL_1_0 = new SpdxLicense('OPL-1.0');
/**
 * (experimental) OSET Public License version 2.1.
 *
 * @see http://www.osetfoundation.org/public-license
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OSET_PL_2_1 = new SpdxLicense('OSET-PL-2.1');
/**
 * (experimental) Open Software License 1.0.
 *
 * @see https://opensource.org/licenses/OSL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OSL_1_0 = new SpdxLicense('OSL-1.0');
/**
 * (experimental) Open Software License 1.1.
 *
 * @see https://fedoraproject.org/wiki/Licensing/OSL1.1
 * @experimental
 */
SpdxLicense.OSL_1_1 = new SpdxLicense('OSL-1.1');
/**
 * (experimental) Open Software License 2.0.
 *
 * @see http://web.archive.org/web/20041020171434/http://www.rosenlaw.com/osl2.0.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OSL_2_0 = new SpdxLicense('OSL-2.0');
/**
 * (experimental) Open Software License 2.1.
 *
 * @see http://web.archive.org/web/20050212003940/http://www.rosenlaw.com/osl21.htm
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OSL_2_1 = new SpdxLicense('OSL-2.1');
/**
 * (experimental) Open Software License 3.0.
 *
 * @see https://web.archive.org/web/20120101081418/http://rosenlaw.com:80/OSL3.0.htm
 * @experimental
 * @osiApproved true
 */
SpdxLicense.OSL_3_0 = new SpdxLicense('OSL-3.0');
/**
 * (experimental) OpenSSL License.
 *
 * @see http://www.openssl.org/source/license.html
 * @experimental
 */
SpdxLicense.OPEN_SS_L = new SpdxLicense('OpenSSL');
/**
 * (experimental) ODC Public Domain Dedication & License 1.0.
 *
 * @see http://opendatacommons.org/licenses/pddl/1.0/
 * @experimental
 */
SpdxLicense.PDDL_1_0 = new SpdxLicense('PDDL-1.0');
/**
 * (experimental) PHP License v3.0.
 *
 * @see http://www.php.net/license/3_0.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.PHP_3_0 = new SpdxLicense('PHP-3.0');
/**
 * (experimental) PHP License v3.01.
 *
 * @see http://www.php.net/license/3_01.txt
 * @experimental
 * @osiApproved true
 */
SpdxLicense.PHP_3_01 = new SpdxLicense('PHP-3.01');
/**
 * (experimental) Python Software Foundation License 2.0.
 *
 * @see https://opensource.org/licenses/Python-2.0
 * @experimental
 */
SpdxLicense.PSF_2_0 = new SpdxLicense('PSF-2.0');
/**
 * (experimental) The Parity Public License 6.0.0.
 *
 * @see https://paritylicense.com/versions/6.0.0.html
 * @experimental
 */
SpdxLicense.PARITY_6_0_0 = new SpdxLicense('Parity-6.0.0');
/**
 * (experimental) The Parity Public License 7.0.0.
 *
 * @see https://paritylicense.com/versions/7.0.0.html
 * @experimental
 */
SpdxLicense.PARITY_7_0_0 = new SpdxLicense('Parity-7.0.0');
/**
 * (experimental) Plexus Classworlds License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License
 * @experimental
 */
SpdxLicense.PLEXUS = new SpdxLicense('Plexus');
/**
 * (experimental) PolyForm Noncommercial License 1.0.0.
 *
 * @see https://polyformproject.org/licenses/noncommercial/1.0.0
 * @experimental
 */
SpdxLicense.POLYFORM_NONCOMMERCIAL_1_0_0 = new SpdxLicense('PolyForm-Noncommercial-1.0.0');
/**
 * (experimental) PolyForm Small Business License 1.0.0.
 *
 * @see https://polyformproject.org/licenses/small-business/1.0.0
 * @experimental
 */
SpdxLicense.POLYFORM_SMALL_BUSINESS_1_0_0 = new SpdxLicense('PolyForm-Small-Business-1.0.0');
/**
 * (experimental) PostgreSQL License.
 *
 * @see http://www.postgresql.org/about/licence
 * @experimental
 * @osiApproved true
 */
SpdxLicense.POSTGRE_SQ_L = new SpdxLicense('PostgreSQL');
/**
 * (experimental) Python License 2.0.
 *
 * @see https://opensource.org/licenses/Python-2.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.PYTHON_2_0 = new SpdxLicense('Python-2.0');
/**
 * (experimental) Q Public License 1.0.
 *
 * @see http://doc.qt.nokia.com/3.3/license.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.QPL_1_0 = new SpdxLicense('QPL-1.0');
/**
 * (experimental) Qhull License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Qhull
 * @experimental
 */
SpdxLicense.QHULL = new SpdxLicense('Qhull');
/**
 * (experimental) Red Hat eCos Public License v1.1.
 *
 * @see http://ecos.sourceware.org/old-license.html
 * @experimental
 */
SpdxLicense.RHECOS_1_1 = new SpdxLicense('RHeCos-1.1');
/**
 * (experimental) Reciprocal Public License 1.1.
 *
 * @see https://opensource.org/licenses/RPL-1.1
 * @experimental
 * @osiApproved true
 */
SpdxLicense.RPL_1_1 = new SpdxLicense('RPL-1.1');
/**
 * (experimental) Reciprocal Public License 1.5.
 *
 * @see https://opensource.org/licenses/RPL-1.5
 * @experimental
 * @osiApproved true
 */
SpdxLicense.RPL_1_5 = new SpdxLicense('RPL-1.5');
/**
 * (experimental) RealNetworks Public Source License v1.0.
 *
 * @see https://helixcommunity.org/content/rpsl
 * @experimental
 * @osiApproved true
 */
SpdxLicense.RPSL_1_0 = new SpdxLicense('RPSL-1.0');
/**
 * (experimental) RSA Message-Digest License.
 *
 * @see http://www.faqs.org/rfcs/rfc1321.html
 * @experimental
 */
SpdxLicense.RSA_MD = new SpdxLicense('RSA-MD');
/**
 * (experimental) Ricoh Source Code Public License.
 *
 * @see http://wayback.archive.org/web/20060715140826/http://www.risource.org/RPL/RPL-1.0A.shtml
 * @experimental
 * @osiApproved true
 */
SpdxLicense.RSCPL = new SpdxLicense('RSCPL');
/**
 * (experimental) Rdisc License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Rdisc_License
 * @experimental
 */
SpdxLicense.RDISC = new SpdxLicense('Rdisc');
/**
 * (experimental) Ruby License.
 *
 * @see http://www.ruby-lang.org/en/LICENSE.txt
 * @experimental
 */
SpdxLicense.RUBY = new SpdxLicense('Ruby');
/**
 * (experimental) Sax Public Domain Notice.
 *
 * @see http://www.saxproject.org/copying.html
 * @experimental
 */
SpdxLicense.SAX_PD = new SpdxLicense('SAX-PD');
/**
 * (experimental) SCEA Shared Source License.
 *
 * @see http://research.scea.com/scea_shared_source_license.html
 * @experimental
 */
SpdxLicense.SCEA = new SpdxLicense('SCEA');
/**
 * (experimental) SGI Free Software License B v1.0.
 *
 * @see http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.1.0.html
 * @experimental
 */
SpdxLicense.SGI_B_1_0 = new SpdxLicense('SGI-B-1.0');
/**
 * (experimental) SGI Free Software License B v1.1.
 *
 * @see http://oss.sgi.com/projects/FreeB/
 * @experimental
 */
SpdxLicense.SGI_B_1_1 = new SpdxLicense('SGI-B-1.1');
/**
 * (experimental) SGI Free Software License B v2.0.
 *
 * @see http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.2.0.pdf
 * @experimental
 */
SpdxLicense.SGI_B_2_0 = new SpdxLicense('SGI-B-2.0');
/**
 * (experimental) Solderpad Hardware License v0.5.
 *
 * @see https://solderpad.org/licenses/SHL-0.5/
 * @experimental
 */
SpdxLicense.SHL_0_5 = new SpdxLicense('SHL-0.5');
/**
 * (experimental) Solderpad Hardware License, Version 0.51.
 *
 * @see https://solderpad.org/licenses/SHL-0.51/
 * @experimental
 */
SpdxLicense.SHL_0_51 = new SpdxLicense('SHL-0.51');
/**
 * (experimental) Sun Industry Standards Source License v1.1.
 *
 * @see http://www.openoffice.org/licenses/sissl_license.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.SISSL = new SpdxLicense('SISSL');
/**
 * (experimental) Sun Industry Standards Source License v1.2.
 *
 * @see http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html
 * @experimental
 */
SpdxLicense.SISSL_1_2 = new SpdxLicense('SISSL-1.2');
/**
 * (experimental) Standard ML of New Jersey License.
 *
 * @see https://www.smlnj.org/license.html
 * @experimental
 */
SpdxLicense.SMLNJ = new SpdxLicense('SMLNJ');
/**
 * (experimental) Secure Messaging Protocol Public License.
 *
 * @see https://github.com/dcblake/SMP/blob/master/Documentation/License.txt
 * @experimental
 */
SpdxLicense.SMPPL = new SpdxLicense('SMPPL');
/**
 * (experimental) SNIA Public License 1.1.
 *
 * @see https://fedoraproject.org/wiki/Licensing/SNIA_Public_License
 * @experimental
 */
SpdxLicense.SNIA = new SpdxLicense('SNIA');
/**
 * (experimental) Sun Public License v1.0.
 *
 * @see https://opensource.org/licenses/SPL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.SPL_1_0 = new SpdxLicense('SPL-1.0');
/**
 * (experimental) SSH OpenSSH license.
 *
 * @see https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/LICENCE#L10
 * @experimental
 */
SpdxLicense.SSH_OPENSSH = new SpdxLicense('SSH-OpenSSH');
/**
 * (experimental) SSH short notice.
 *
 * @see https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/pathnames.h
 * @experimental
 */
SpdxLicense.SSH_SHORT = new SpdxLicense('SSH-short');
/**
 * (experimental) Server Side Public License, v 1.
 *
 * @see https://www.mongodb.com/licensing/server-side-public-license
 * @experimental
 */
SpdxLicense.SSPL_1_0 = new SpdxLicense('SSPL-1.0');
/**
 * (experimental) Scheme Widget Library (SWL) Software License Agreement.
 *
 * @see https://fedoraproject.org/wiki/Licensing/SWL
 * @experimental
 */
SpdxLicense.SWL = new SpdxLicense('SWL');
/**
 * (experimental) Saxpath License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Saxpath_License
 * @experimental
 */
SpdxLicense.SAXPATH = new SpdxLicense('Saxpath');
/**
 * (experimental) Sendmail License.
 *
 * @see http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf
 * @experimental
 */
SpdxLicense.SENDMAIL = new SpdxLicense('Sendmail');
/**
 * (experimental) Sendmail License 8.23.
 *
 * @see https://www.proofpoint.com/sites/default/files/sendmail-license.pdf
 * @experimental
 */
SpdxLicense.SENDMAIL_8_23 = new SpdxLicense('Sendmail-8.23');
/**
 * (experimental) Simple Public License 2.0.
 *
 * @see https://opensource.org/licenses/SimPL-2.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.SIMPL_2_0 = new SpdxLicense('SimPL-2.0');
/**
 * (experimental) Sleepycat License.
 *
 * @see https://opensource.org/licenses/Sleepycat
 * @experimental
 * @osiApproved true
 */
SpdxLicense.SLEEPYCAT = new SpdxLicense('Sleepycat');
/**
 * (experimental) Spencer License 86.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License
 * @experimental
 */
SpdxLicense.SPENCER_86 = new SpdxLicense('Spencer-86');
/**
 * (experimental) Spencer License 94.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License
 * @experimental
 */
SpdxLicense.SPENCER_94 = new SpdxLicense('Spencer-94');
/**
 * (experimental) Spencer License 99.
 *
 * @see http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c
 * @experimental
 */
SpdxLicense.SPENCER_99 = new SpdxLicense('Spencer-99');
/**
 * (experimental) Standard ML of New Jersey License.
 *
 * @see http://www.smlnj.org//license.html
 * @experimental
 */
SpdxLicense.STANDARDML_NJ = new SpdxLicense('StandardML-NJ');
/**
 * (experimental) SugarCRM Public License v1.1.3.
 *
 * @see http://www.sugarcrm.com/crm/SPL
 * @experimental
 */
SpdxLicense.SUGARCRM_1_1_3 = new SpdxLicense('SugarCRM-1.1.3');
/**
 * (experimental) TAPR Open Hardware License v1.0.
 *
 * @see https://www.tapr.org/OHL
 * @experimental
 */
SpdxLicense.TAPR_OHL_1_0 = new SpdxLicense('TAPR-OHL-1.0');
/**
 * (experimental) TCL/TK License.
 *
 * @see http://www.tcl.tk/software/tcltk/license.html
 * @experimental
 */
SpdxLicense.TCL = new SpdxLicense('TCL');
/**
 * (experimental) TCP Wrappers License.
 *
 * @see http://rc.quest.com/topics/openssh/license.php#tcpwrappers
 * @experimental
 */
SpdxLicense.TCP_WRAPPERS = new SpdxLicense('TCP-wrappers');
/**
 * (experimental) TMate Open Source License.
 *
 * @see http://svnkit.com/license.html
 * @experimental
 */
SpdxLicense.TMATE = new SpdxLicense('TMate');
/**
 * (experimental) TORQUE v2.5+ Software License v1.1.
 *
 * @see https://fedoraproject.org/wiki/Licensing/TORQUEv1.1
 * @experimental
 */
SpdxLicense.TORQUE_1_1 = new SpdxLicense('TORQUE-1.1');
/**
 * (experimental) Trusster Open Source License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/TOSL
 * @experimental
 */
SpdxLicense.TOSL = new SpdxLicense('TOSL');
/**
 * (experimental) Technische Universitaet Berlin License 1.0.
 *
 * @see https://github.com/swh/ladspa/blob/7bf6f3799fdba70fda297c2d8fd9f526803d9680/gsm/COPYRIGHT
 * @experimental
 */
SpdxLicense.TU_BERLIN_1_0 = new SpdxLicense('TU-Berlin-1.0');
/**
 * (experimental) Technische Universitaet Berlin License 2.0.
 *
 * @see https://github.com/CorsixTH/deps/blob/fd339a9f526d1d9c9f01ccf39e438a015da50035/licences/libgsm.txt
 * @experimental
 */
SpdxLicense.TU_BERLIN_2_0 = new SpdxLicense('TU-Berlin-2.0');
/**
 * (experimental) Upstream Compatibility License v1.0.
 *
 * @see https://opensource.org/licenses/UCL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.UCL_1_0 = new SpdxLicense('UCL-1.0');
/**
 * (experimental) Universal Permissive License v1.0.
 *
 * @see https://opensource.org/licenses/UPL
 * @experimental
 * @osiApproved true
 */
SpdxLicense.UPL_1_0 = new SpdxLicense('UPL-1.0');
/**
 * (experimental) Unicode License Agreement - Data Files and Software (2015).
 *
 * @see https://web.archive.org/web/20151224134844/http://unicode.org/copyright.html
 * @experimental
 */
SpdxLicense.UNICODE_DFS_2015 = new SpdxLicense('Unicode-DFS-2015');
/**
 * (experimental) Unicode License Agreement - Data Files and Software (2016).
 *
 * @see http://www.unicode.org/copyright.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.UNICODE_DFS_2016 = new SpdxLicense('Unicode-DFS-2016');
/**
 * (experimental) Unicode Terms of Use.
 *
 * @see http://www.unicode.org/copyright.html
 * @experimental
 */
SpdxLicense.UNICODE_TOU = new SpdxLicense('Unicode-TOU');
/**
 * (experimental) The Unlicense.
 *
 * @see https://unlicense.org/
 * @experimental
 * @osiApproved true
 */
SpdxLicense.UNLICENSE = new SpdxLicense('Unlicense');
/**
 * (experimental) VOSTROM Public License for Open Source.
 *
 * @see https://fedoraproject.org/wiki/Licensing/VOSTROM
 * @experimental
 */
SpdxLicense.VOSTROM = new SpdxLicense('VOSTROM');
/**
 * (experimental) Vovida Software License v1.0.
 *
 * @see https://opensource.org/licenses/VSL-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.VSL_1_0 = new SpdxLicense('VSL-1.0');
/**
 * (experimental) Vim License.
 *
 * @see http://vimdoc.sourceforge.net/htmldoc/uganda.html
 * @experimental
 */
SpdxLicense.VIM = new SpdxLicense('Vim');
/**
 * (experimental) W3C Software Notice and License (2002-12-31).
 *
 * @see http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.W3_C = new SpdxLicense('W3C');
/**
 * (experimental) W3C Software Notice and License (1998-07-20).
 *
 * @see http://www.w3.org/Consortium/Legal/copyright-software-19980720.html
 * @experimental
 */
SpdxLicense.W3C_19980720 = new SpdxLicense('W3C-19980720');
/**
 * (experimental) W3C Software Notice and Document License (2015-05-13).
 *
 * @see https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document
 * @experimental
 */
SpdxLicense.W3C_20150513 = new SpdxLicense('W3C-20150513');
/**
 * (experimental) Do What The F*ck You Want To Public License.
 *
 * @see http://www.wtfpl.net/about/
 * @experimental
 */
SpdxLicense.WTFPL = new SpdxLicense('WTFPL');
/**
 * (experimental) Sybase Open Watcom Public License 1.0.
 *
 * @see https://opensource.org/licenses/Watcom-1.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.WATCOM_1_0 = new SpdxLicense('Watcom-1.0');
/**
 * (experimental) Wsuipa License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Wsuipa
 * @experimental
 */
SpdxLicense.WSUIPA = new SpdxLicense('Wsuipa');
/**
 * (experimental) X11 License.
 *
 * @see http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3
 * @experimental
 */
SpdxLicense.X11 = new SpdxLicense('X11');
/**
 * (experimental) XFree86 License 1.1.
 *
 * @see http://www.xfree86.org/current/LICENSE4.html
 * @experimental
 */
SpdxLicense.XFREE86_1_1 = new SpdxLicense('XFree86-1.1');
/**
 * (experimental) XSkat License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/XSkat_License
 * @experimental
 */
SpdxLicense.XSKAT = new SpdxLicense('XSkat');
/**
 * (experimental) Xerox License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Xerox
 * @experimental
 */
SpdxLicense.XEROX = new SpdxLicense('Xerox');
/**
 * (experimental) X.Net License.
 *
 * @see https://opensource.org/licenses/Xnet
 * @experimental
 * @osiApproved true
 */
SpdxLicense.XNET = new SpdxLicense('Xnet');
/**
 * (experimental) Yahoo!
 *
 * Public License v1.0
 *
 * @see http://www.zimbra.com/license/yahoo_public_license_1.0.html
 * @experimental
 */
SpdxLicense.YPL_1_0 = new SpdxLicense('YPL-1.0');
/**
 * (experimental) Yahoo!
 *
 * Public License v1.1
 *
 * @see http://www.zimbra.com/license/yahoo_public_license_1.1.html
 * @experimental
 */
SpdxLicense.YPL_1_1 = new SpdxLicense('YPL-1.1');
/**
 * (experimental) Zope Public License 1.1.
 *
 * @see http://old.zope.org/Resources/License/ZPL-1.1
 * @experimental
 */
SpdxLicense.ZPL_1_1 = new SpdxLicense('ZPL-1.1');
/**
 * (experimental) Zope Public License 2.0.
 *
 * @see http://old.zope.org/Resources/License/ZPL-2.0
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ZPL_2_0 = new SpdxLicense('ZPL-2.0');
/**
 * (experimental) Zope Public License 2.1.
 *
 * @see http://old.zope.org/Resources/ZPL/
 * @experimental
 */
SpdxLicense.ZPL_2_1 = new SpdxLicense('ZPL-2.1');
/**
 * (experimental) Zed License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Zed
 * @experimental
 */
SpdxLicense.ZED = new SpdxLicense('Zed');
/**
 * (experimental) Zend License v2.0.
 *
 * @see https://web.archive.org/web/20130517195954/http://www.zend.com/license/2_00.txt
 * @experimental
 */
SpdxLicense.ZEND_2_0 = new SpdxLicense('Zend-2.0');
/**
 * (experimental) Zimbra Public License v1.3.
 *
 * @see http://web.archive.org/web/20100302225219/http://www.zimbra.com/license/zimbra-public-license-1-3.html
 * @experimental
 */
SpdxLicense.ZIMBRA_1_3 = new SpdxLicense('Zimbra-1.3');
/**
 * (experimental) Zimbra Public License v1.4.
 *
 * @see http://www.zimbra.com/legal/zimbra-public-license-1-4
 * @experimental
 */
SpdxLicense.ZIMBRA_1_4 = new SpdxLicense('Zimbra-1.4');
/**
 * (experimental) zlib License.
 *
 * @see http://www.zlib.net/zlib_license.html
 * @experimental
 * @osiApproved true
 */
SpdxLicense.ZLIB = new SpdxLicense('Zlib');
/**
 * (experimental) SQLite Blessing.
 *
 * @see https://www.sqlite.org/src/artifact/e33a4df7e32d742a?ln=4-9
 * @experimental
 */
SpdxLicense.BLESSING = new SpdxLicense('blessing');
/**
 * (experimental) bzip2 and libbzip2 License v1.0.5.
 *
 * @see https://sourceware.org/bzip2/1.0.5/bzip2-manual-1.0.5.html
 * @experimental
 */
SpdxLicense.BZIP2_1_0_5 = new SpdxLicense('bzip2-1.0.5');
/**
 * (experimental) bzip2 and libbzip2 License v1.0.6.
 *
 * @see https://sourceware.org/git/?p=bzip2.git;a=blob;f=LICENSE;hb=bzip2-1.0.6
 * @experimental
 */
SpdxLicense.BZIP2_1_0_6 = new SpdxLicense('bzip2-1.0.6');
/**
 * (experimental) copyleft-next 0.3.0.
 *
 * @see https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.0
 * @experimental
 */
SpdxLicense.COPYLEFT_NEXT_0_3_0 = new SpdxLicense('copyleft-next-0.3.0');
/**
 * (experimental) copyleft-next 0.3.1.
 *
 * @see https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.1
 * @experimental
 */
SpdxLicense.COPYLEFT_NEXT_0_3_1 = new SpdxLicense('copyleft-next-0.3.1');
/**
 * (experimental) curl License.
 *
 * @see https://github.com/bagder/curl/blob/master/COPYING
 * @experimental
 */
SpdxLicense.CURL = new SpdxLicense('curl');
/**
 * (experimental) diffmark license.
 *
 * @see https://fedoraproject.org/wiki/Licensing/diffmark
 * @experimental
 */
SpdxLicense.DIFFMARK = new SpdxLicense('diffmark');
/**
 * (experimental) dvipdfm License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/dvipdfm
 * @experimental
 */
SpdxLicense.DVIPDFM = new SpdxLicense('dvipdfm');
/**
 * (experimental) eCos license version 2.0.
 *
 * @see https://www.gnu.org/licenses/ecos-license.html
 * @experimental
 */
SpdxLicense.ECOS_2_0 = new SpdxLicense('eCos-2.0');
/**
 * (experimental) eGenix.com Public License 1.1.0.
 *
 * @see http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf
 * @experimental
 */
SpdxLicense.E_GENIX = new SpdxLicense('eGenix');
/**
 * (experimental) Etalab Open License 2.0.
 *
 * @see https://github.com/DISIC/politique-de-contribution-open-source/blob/master/LICENSE.pdf
 * @experimental
 */
SpdxLicense.ETALAB_2_0 = new SpdxLicense('etalab-2.0');
/**
 * (experimental) gSOAP Public License v1.3b.
 *
 * @see http://www.cs.fsu.edu/~engelen/license.html
 * @experimental
 */
SpdxLicense.GSOAP_1_3B = new SpdxLicense('gSOAP-1.3b');
/**
 * (experimental) gnuplot License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Gnuplot
 * @experimental
 */
SpdxLicense.GNUPLOT = new SpdxLicense('gnuplot');
/**
 * (experimental) iMatix Standard Function Library Agreement.
 *
 * @see http://legacy.imatix.com/html/sfl/sfl4.htm#license
 * @experimental
 */
SpdxLicense.I_MATIX = new SpdxLicense('iMatix');
/**
 * (experimental) PNG Reference Library version 2.
 *
 * @see http://www.libpng.org/pub/png/src/libpng-LICENSE.txt
 * @experimental
 */
SpdxLicense.LIBPNG_2_0 = new SpdxLicense('libpng-2.0');
/**
 * (experimental) libselinux public domain notice.
 *
 * @see https://github.com/SELinuxProject/selinux/blob/master/libselinux/LICENSE
 * @experimental
 */
SpdxLicense.LIBSELINUX_1_0 = new SpdxLicense('libselinux-1.0');
/**
 * (experimental) libtiff License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/libtiff
 * @experimental
 */
SpdxLicense.LIBTIFF = new SpdxLicense('libtiff');
/**
 * (experimental) mpich2 License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/MIT
 * @experimental
 */
SpdxLicense.MPICH2 = new SpdxLicense('mpich2');
/**
 * (experimental) psfrag License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/psfrag
 * @experimental
 */
SpdxLicense.PSFRAG = new SpdxLicense('psfrag');
/**
 * (experimental) psutils License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/psutils
 * @experimental
 */
SpdxLicense.PSUTILS = new SpdxLicense('psutils');
/**
 * (experimental) wxWindows Library License.
 *
 * @see https://opensource.org/licenses/WXwindows
 * @experimental
 */
SpdxLicense.WX_WINDOWS = new SpdxLicense('wxWindows');
/**
 * (experimental) xinetd License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/Xinetd_License
 * @experimental
 */
SpdxLicense.XINETD = new SpdxLicense('xinetd');
/**
 * (experimental) XPP License.
 *
 * @see https://fedoraproject.org/wiki/Licensing/xpp
 * @experimental
 */
SpdxLicense.XPP = new SpdxLicense('xpp');
/**
 * (experimental) zlib/libpng License with Acknowledgement.
 *
 * @see https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement
 * @experimental
 */
SpdxLicense.ZLIB_ACKNOWLEDGEMENT = new SpdxLicense('zlib-acknowledgement');
/**
 * (experimental) Packages that have not been licensed.
 *
 * @experimental
 */
SpdxLicense.UNLICENSED = new SpdxLicense('UNLICENSED');
//# sourceMappingURL=data:application/json;base64,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