/**
 * (experimental) Valid SPDX License identifiers.
 *
 * @experimental
 */
export declare class SpdxLicense {
    readonly id: string;
    private static readonly _ALL;
    /**
     * (experimental) BSD Zero Clause License.
     *
     * @see http://landley.net/toybox/license.html
     * @experimental
     * @osiApproved true
     */
    static readonly ZERO_BSD: SpdxLicense;
    /**
     * (experimental) Attribution Assurance License.
     *
     * @see https://opensource.org/licenses/attribution
     * @experimental
     * @osiApproved true
     */
    static readonly AAL: SpdxLicense;
    /**
     * (experimental) Amazon Digital Services License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense
     * @experimental
     */
    static readonly ADSL: SpdxLicense;
    /**
     * (experimental) Academic Free License v1.1.
     *
     * @see http://opensource.linux-mirror.org/licenses/afl-1.1.txt
     * @experimental
     * @osiApproved true
     */
    static readonly AFL_1_1: SpdxLicense;
    /**
     * (experimental) Academic Free License v1.2.
     *
     * @see http://opensource.linux-mirror.org/licenses/afl-1.2.txt
     * @experimental
     * @osiApproved true
     */
    static readonly AFL_1_2: SpdxLicense;
    /**
     * (experimental) Academic Free License v2.0.
     *
     * @see http://wayback.archive.org/web/20060924134533/http://www.opensource.org/licenses/afl-2.0.txt
     * @experimental
     * @osiApproved true
     */
    static readonly AFL_2_0: SpdxLicense;
    /**
     * (experimental) Academic Free License v2.1.
     *
     * @see http://opensource.linux-mirror.org/licenses/afl-2.1.txt
     * @experimental
     * @osiApproved true
     */
    static readonly AFL_2_1: SpdxLicense;
    /**
     * (experimental) Academic Free License v3.0.
     *
     * @see http://www.rosenlaw.com/AFL3.0.htm
     * @experimental
     * @osiApproved true
     */
    static readonly AFL_3_0: SpdxLicense;
    /**
     * (experimental) Affero General Public License v1.0.
     *
     * @see http://www.affero.org/oagpl.html
     * @experimental
     */
    static readonly AGPL_1_0: SpdxLicense;
    /**
     * (experimental) Affero General Public License v1.0 only.
     *
     * @see http://www.affero.org/oagpl.html
     * @experimental
     */
    static readonly AGPL_1_0_ONLY: SpdxLicense;
    /**
     * (experimental) Affero General Public License v1.0 or later.
     *
     * @see http://www.affero.org/oagpl.html
     * @experimental
     */
    static readonly AGPL_1_0_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Affero General Public License v3.0.
     *
     * @see https://www.gnu.org/licenses/agpl.txt
     * @experimental
     * @osiApproved true
     */
    static readonly AGPL_3_0: SpdxLicense;
    /**
     * (experimental) GNU Affero General Public License v3.0 only.
     *
     * @see https://www.gnu.org/licenses/agpl.txt
     * @experimental
     * @osiApproved true
     */
    static readonly AGPL_3_0_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Affero General Public License v3.0 or later.
     *
     * @see https://www.gnu.org/licenses/agpl.txt
     * @experimental
     * @osiApproved true
     */
    static readonly AGPL_3_0_OR_LATER: SpdxLicense;
    /**
     * (experimental) AMD's plpa_map.c License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License
     * @experimental
     */
    static readonly AMDPLPA: SpdxLicense;
    /**
     * (experimental) Apple MIT License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Apple_MIT_License
     * @experimental
     */
    static readonly AML: SpdxLicense;
    /**
     * (experimental) Academy of Motion Picture Arts and Sciences BSD.
     *
     * @see https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD
     * @experimental
     */
    static readonly AMPAS: SpdxLicense;
    /**
     * (experimental) ANTLR Software Rights Notice.
     *
     * @see http://www.antlr2.org/license.html
     * @experimental
     */
    static readonly ANTLR_PD: SpdxLicense;
    /**
     * (experimental) ANTLR Software Rights Notice with license fallback.
     *
     * @see http://www.antlr2.org/license.html
     * @experimental
     */
    static readonly ANTLR_PD_FALLBACK: SpdxLicense;
    /**
     * (experimental) Adobe Postscript AFM License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM
     * @experimental
     */
    static readonly APAFML: SpdxLicense;
    /**
     * (experimental) Adaptive Public License 1.0.
     *
     * @see https://opensource.org/licenses/APL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly APL_1_0: SpdxLicense;
    /**
     * (experimental) Apple Public Source License 1.0.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0
     * @experimental
     * @osiApproved true
     */
    static readonly APSL_1_0: SpdxLicense;
    /**
     * (experimental) Apple Public Source License 1.1.
     *
     * @see http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE
     * @experimental
     * @osiApproved true
     */
    static readonly APSL_1_1: SpdxLicense;
    /**
     * (experimental) Apple Public Source License 1.2.
     *
     * @see http://www.samurajdata.se/opensource/mirror/licenses/apsl.php
     * @experimental
     * @osiApproved true
     */
    static readonly APSL_1_2: SpdxLicense;
    /**
     * (experimental) Apple Public Source License 2.0.
     *
     * @see http://www.opensource.apple.com/license/apsl/
     * @experimental
     * @osiApproved true
     */
    static readonly APSL_2_0: SpdxLicense;
    /**
     * (experimental) Abstyles License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Abstyles
     * @experimental
     */
    static readonly ABSTYLES: SpdxLicense;
    /**
     * (experimental) Adobe Systems Incorporated Source Code License Agreement.
     *
     * @see https://fedoraproject.org/wiki/Licensing/AdobeLicense
     * @experimental
     */
    static readonly ADOBE_2006: SpdxLicense;
    /**
     * (experimental) Adobe Glyph List License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph
     * @experimental
     */
    static readonly ADOBE_GLYPH: SpdxLicense;
    /**
     * (experimental) Afmparse License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Afmparse
     * @experimental
     */
    static readonly AFMPARSE: SpdxLicense;
    /**
     * (experimental) Aladdin Free Public License.
     *
     * @see http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm
     * @experimental
     */
    static readonly ALADDIN: SpdxLicense;
    /**
     * (experimental) Apache License 1.0.
     *
     * @see http://www.apache.org/licenses/LICENSE-1.0
     * @experimental
     */
    static readonly APACHE_1_0: SpdxLicense;
    /**
     * (experimental) Apache License 1.1.
     *
     * @see http://apache.org/licenses/LICENSE-1.1
     * @experimental
     * @osiApproved true
     */
    static readonly APACHE_1_1: SpdxLicense;
    /**
     * (experimental) Apache License 2.0.
     *
     * @see http://www.apache.org/licenses/LICENSE-2.0
     * @experimental
     * @osiApproved true
     */
    static readonly APACHE_2_0: SpdxLicense;
    /**
     * (experimental) Artistic License 1.0.
     *
     * @see https://opensource.org/licenses/Artistic-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly ARTISTIC_1_0: SpdxLicense;
    /**
     * (experimental) Artistic License 1.0 (Perl).
     *
     * @see http://dev.perl.org/licenses/artistic.html
     * @experimental
     * @osiApproved true
     */
    static readonly ARTISTIC_1_0_PERL: SpdxLicense;
    /**
     * (experimental) Artistic License 1.0 w/clause 8.
     *
     * @see https://opensource.org/licenses/Artistic-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly ARTISTIC_1_0_CL8: SpdxLicense;
    /**
     * (experimental) Artistic License 2.0.
     *
     * @see http://www.perlfoundation.org/artistic_license_2_0
     * @experimental
     * @osiApproved true
     */
    static readonly ARTISTIC_2_0: SpdxLicense;
    /**
     * (experimental) BSD 1-Clause License.
     *
     * @see https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823
     * @experimental
     * @osiApproved true
     */
    static readonly BSD_1_CLAUSE: SpdxLicense;
    /**
     * (experimental) BSD 2-Clause "Simplified" License.
     *
     * @see https://opensource.org/licenses/BSD-2-Clause
     * @experimental
     * @osiApproved true
     */
    static readonly BSD_2_CLAUSE: SpdxLicense;
    /**
     * (experimental) BSD 2-Clause FreeBSD License.
     *
     * @see http://www.freebsd.org/copyright/freebsd-license.html
     * @experimental
     */
    static readonly BSD_2_CLAUSE_FREEBSD: SpdxLicense;
    /**
     * (experimental) BSD 2-Clause NetBSD License.
     *
     * @see http://www.netbsd.org/about/redistribution.html#default
     * @experimental
     */
    static readonly BSD_2_CLAUSE_NETBSD: SpdxLicense;
    /**
     * (experimental) BSD-2-Clause Plus Patent License.
     *
     * @see https://opensource.org/licenses/BSDplusPatent
     * @experimental
     * @osiApproved true
     */
    static readonly BSD_2_CLAUSE_PATENT: SpdxLicense;
    /**
     * (experimental) BSD 2-Clause with views sentence.
     *
     * @see http://www.freebsd.org/copyright/freebsd-license.html
     * @experimental
     */
    static readonly BSD_2_CLAUSE_VIEWS: SpdxLicense;
    /**
     * (experimental) BSD 3-Clause "New" or "Revised" License.
     *
     * @see https://opensource.org/licenses/BSD-3-Clause
     * @experimental
     * @osiApproved true
     */
    static readonly BSD_3_CLAUSE: SpdxLicense;
    /**
     * (experimental) BSD with attribution.
     *
     * @see https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution
     * @experimental
     */
    static readonly BSD_3_CLAUSE_ATTRIBUTION: SpdxLicense;
    /**
     * (experimental) BSD 3-Clause Clear License.
     *
     * @see http://labs.metacarta.com/license-explanation.html#license
     * @experimental
     */
    static readonly BSD_3_CLAUSE_CLEAR: SpdxLicense;
    /**
     * (experimental) Lawrence Berkeley National Labs BSD variant license.
     *
     * @see https://fedoraproject.org/wiki/Licensing/LBNLBSD
     * @experimental
     * @osiApproved true
     */
    static readonly BSD_3_CLAUSE_LBNL: SpdxLicense;
    /**
     * (experimental) BSD 3-Clause No Nuclear License.
     *
     * @see http://download.oracle.com/otn-pub/java/licenses/bsd.txt?AuthParam=1467140197_43d516ce1776bd08a58235a7785be1cc
     * @experimental
     */
    static readonly BSD_3_CLAUSE_NO_NUCLEAR_LICENSE: SpdxLicense;
    /**
     * (experimental) BSD 3-Clause No Nuclear License 2014.
     *
     * @see https://java.net/projects/javaeetutorial/pages/BerkeleyLicense
     * @experimental
     */
    static readonly BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014: SpdxLicense;
    /**
     * (experimental) BSD 3-Clause No Nuclear Warranty.
     *
     * @see https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt
     * @experimental
     */
    static readonly BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY: SpdxLicense;
    /**
     * (experimental) BSD 3-Clause Open MPI variant.
     *
     * @see https://www.open-mpi.org/community/license.php
     * @experimental
     */
    static readonly BSD_3_CLAUSE_OPEN_MPI: SpdxLicense;
    /**
     * (experimental) BSD 4-Clause "Original" or "Old" License.
     *
     * @see http://directory.fsf.org/wiki/License:BSD_4Clause
     * @experimental
     */
    static readonly BSD_4_CLAUSE: SpdxLicense;
    /**
     * (experimental) BSD-4-Clause (University of California-Specific).
     *
     * @see http://www.freebsd.org/copyright/license.html
     * @experimental
     */
    static readonly BSD_4_CLAUSE_UC: SpdxLicense;
    /**
     * (experimental) BSD Protection License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/BSD_Protection_License
     * @experimental
     */
    static readonly BSD_PROTECTION: SpdxLicense;
    /**
     * (experimental) BSD Source Code Attribution.
     *
     * @see https://github.com/robbiehanson/CocoaHTTPServer/blob/master/LICENSE.txt
     * @experimental
     */
    static readonly BSD_SOURCE_CODE: SpdxLicense;
    /**
     * (experimental) Boost Software License 1.0.
     *
     * @see http://www.boost.org/LICENSE_1_0.txt
     * @experimental
     * @osiApproved true
     */
    static readonly BSL_1_0: SpdxLicense;
    /**
     * (experimental) Business Source License 1.1.
     *
     * @see https://mariadb.com/bsl11/
     * @experimental
     */
    static readonly BUSL_1_1: SpdxLicense;
    /**
     * (experimental) Bahyph License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Bahyph
     * @experimental
     */
    static readonly BAHYPH: SpdxLicense;
    /**
     * (experimental) Barr License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Barr
     * @experimental
     */
    static readonly BARR: SpdxLicense;
    /**
     * (experimental) Beerware License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Beerware
     * @experimental
     */
    static readonly BEERWARE: SpdxLicense;
    /**
     * (experimental) BitTorrent Open Source License v1.0.
     *
     * @see http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s
     * @experimental
     */
    static readonly BITTORRENT_1_0: SpdxLicense;
    /**
     * (experimental) BitTorrent Open Source License v1.1.
     *
     * @see http://directory.fsf.org/wiki/License:BitTorrentOSL1.1
     * @experimental
     */
    static readonly BITTORRENT_1_1: SpdxLicense;
    /**
     * (experimental) Blue Oak Model License 1.0.0.
     *
     * @see https://blueoakcouncil.org/license/1.0.0
     * @experimental
     */
    static readonly BLUEOAK_1_0_0: SpdxLicense;
    /**
     * (experimental) Borceux license.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Borceux
     * @experimental
     */
    static readonly BORCEUX: SpdxLicense;
    /**
     * (experimental) Cryptographic Autonomy License 1.0.
     *
     * @see http://cryptographicautonomylicense.com/license-text.html
     * @experimental
     * @osiApproved true
     */
    static readonly CAL_1_0: SpdxLicense;
    /**
     * (experimental) Cryptographic Autonomy License 1.0 (Combined Work Exception).
     *
     * @see http://cryptographicautonomylicense.com/license-text.html
     * @experimental
     * @osiApproved true
     */
    static readonly CAL_1_0_COMBINED_WORK_EXCEPTION: SpdxLicense;
    /**
     * (experimental) Computer Associates Trusted Open Source License 1.1.
     *
     * @see https://opensource.org/licenses/CATOSL-1.1
     * @experimental
     * @osiApproved true
     */
    static readonly CATOSL_1_1: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution 1.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by/1.0/legalcode
     * @experimental
     */
    static readonly CC_BY_1_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution 2.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by/2.0/legalcode
     * @experimental
     */
    static readonly CC_BY_2_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution 2.5 Generic.
     *
     * @see https://creativecommons.org/licenses/by/2.5/legalcode
     * @experimental
     */
    static readonly CC_BY_2_5: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution 3.0 Unported.
     *
     * @see https://creativecommons.org/licenses/by/3.0/legalcode
     * @experimental
     */
    static readonly CC_BY_3_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution 3.0 Austria.
     *
     * @see https://creativecommons.org/licenses/by/3.0/at/legalcode
     * @experimental
     */
    static readonly CC_BY_3_0_AT: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution 3.0 United States.
     *
     * @see https://creativecommons.org/licenses/by/3.0/us/legalcode
     * @experimental
     */
    static readonly CC_BY_3_0_US: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution 4.0 International.
     *
     * @see https://creativecommons.org/licenses/by/4.0/legalcode
     * @experimental
     */
    static readonly CC_BY_4_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial 1.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nc/1.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_1_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial 2.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nc/2.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_2_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial 2.5 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nc/2.5/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_2_5: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial 3.0 Unported.
     *
     * @see https://creativecommons.org/licenses/by-nc/3.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_3_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial 4.0 International.
     *
     * @see https://creativecommons.org/licenses/by-nc/4.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_4_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_ND_1_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_ND_2_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_ND_2_5: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported.
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_ND_3_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO.
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/3.0/igo/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_ND_3_0_IGO: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial No Derivatives 4.0 International.
     *
     * @see https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_ND_4_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial Share Alike 1.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_SA_1_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial Share Alike 2.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_SA_2_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial Share Alike 2.5 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_SA_2_5: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial Share Alike 3.0 Unported.
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_SA_3_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Non Commercial Share Alike 4.0 International.
     *
     * @see https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode
     * @experimental
     */
    static readonly CC_BY_NC_SA_4_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution No Derivatives 1.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nd/1.0/legalcode
     * @experimental
     */
    static readonly CC_BY_ND_1_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution No Derivatives 2.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nd/2.0/legalcode
     * @experimental
     */
    static readonly CC_BY_ND_2_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution No Derivatives 2.5 Generic.
     *
     * @see https://creativecommons.org/licenses/by-nd/2.5/legalcode
     * @experimental
     */
    static readonly CC_BY_ND_2_5: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution No Derivatives 3.0 Unported.
     *
     * @see https://creativecommons.org/licenses/by-nd/3.0/legalcode
     * @experimental
     */
    static readonly CC_BY_ND_3_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution No Derivatives 4.0 International.
     *
     * @see https://creativecommons.org/licenses/by-nd/4.0/legalcode
     * @experimental
     */
    static readonly CC_BY_ND_4_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Share Alike 1.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-sa/1.0/legalcode
     * @experimental
     */
    static readonly CC_BY_SA_1_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Share Alike 2.0 Generic.
     *
     * @see https://creativecommons.org/licenses/by-sa/2.0/legalcode
     * @experimental
     */
    static readonly CC_BY_SA_2_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Share Alike 2.0 England and Wales.
     *
     * @see https://creativecommons.org/licenses/by-sa/2.0/uk/legalcode
     * @experimental
     */
    static readonly CC_BY_SA_2_0_UK: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Share Alike 2.5 Generic.
     *
     * @see https://creativecommons.org/licenses/by-sa/2.5/legalcode
     * @experimental
     */
    static readonly CC_BY_SA_2_5: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Share Alike 3.0 Unported.
     *
     * @see https://creativecommons.org/licenses/by-sa/3.0/legalcode
     * @experimental
     */
    static readonly CC_BY_SA_3_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution-Share Alike 3.0 Austria.
     *
     * @see https://creativecommons.org/licenses/by-sa/3.0/at/legalcode
     * @experimental
     */
    static readonly CC_BY_SA_3_0_AT: SpdxLicense;
    /**
     * (experimental) Creative Commons Attribution Share Alike 4.0 International.
     *
     * @see https://creativecommons.org/licenses/by-sa/4.0/legalcode
     * @experimental
     */
    static readonly CC_BY_SA_4_0: SpdxLicense;
    /**
     * (experimental) Creative Commons Public Domain Dedication and Certification.
     *
     * @see https://creativecommons.org/licenses/publicdomain/
     * @experimental
     */
    static readonly CC_PDDC: SpdxLicense;
    /**
     * (experimental) Creative Commons Zero v1.0 Universal.
     *
     * @see https://creativecommons.org/publicdomain/zero/1.0/legalcode
     * @experimental
     */
    static readonly CC0_1_0: SpdxLicense;
    /**
     * (experimental) Common Development and Distribution License 1.0.
     *
     * @see https://opensource.org/licenses/cddl1
     * @experimental
     * @osiApproved true
     */
    static readonly CDDL_1_0: SpdxLicense;
    /**
     * (experimental) Common Development and Distribution License 1.1.
     *
     * @see http://glassfish.java.net/public/CDDL+GPL_1_1.html
     * @experimental
     */
    static readonly CDDL_1_1: SpdxLicense;
    /**
     * (experimental) Community Data License Agreement Permissive 1.0.
     *
     * @see https://cdla.io/permissive-1-0
     * @experimental
     */
    static readonly CDLA_PERMISSIVE_1_0: SpdxLicense;
    /**
     * (experimental) Community Data License Agreement Sharing 1.0.
     *
     * @see https://cdla.io/sharing-1-0
     * @experimental
     */
    static readonly CDLA_SHARING_1_0: SpdxLicense;
    /**
     * (experimental) CeCILL Free Software License Agreement v1.0.
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html
     * @experimental
     */
    static readonly CECILL_1_0: SpdxLicense;
    /**
     * (experimental) CeCILL Free Software License Agreement v1.1.
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html
     * @experimental
     */
    static readonly CECILL_1_1: SpdxLicense;
    /**
     * (experimental) CeCILL Free Software License Agreement v2.0.
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
     * @experimental
     */
    static readonly CECILL_2_0: SpdxLicense;
    /**
     * (experimental) CeCILL Free Software License Agreement v2.1.
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html
     * @experimental
     * @osiApproved true
     */
    static readonly CECILL_2_1: SpdxLicense;
    /**
     * (experimental) CeCILL-B Free Software License Agreement.
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
     * @experimental
     */
    static readonly CECILL_B: SpdxLicense;
    /**
     * (experimental) CeCILL-C Free Software License Agreement.
     *
     * @see http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html
     * @experimental
     */
    static readonly CECILL_C: SpdxLicense;
    /**
     * (experimental) CERN Open Hardware Licence v1.1.
     *
     * @see https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.1
     * @experimental
     */
    static readonly CERN_OHL_1_1: SpdxLicense;
    /**
     * (experimental) CERN Open Hardware Licence v1.2.
     *
     * @see https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.2
     * @experimental
     */
    static readonly CERN_OHL_1_2: SpdxLicense;
    /**
     * (experimental) CERN Open Hardware Licence Version 2 - Permissive.
     *
     * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
     * @experimental
     */
    static readonly CERN_OHL_P_2_0: SpdxLicense;
    /**
     * (experimental) CERN Open Hardware Licence Version 2 - Strongly Reciprocal.
     *
     * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
     * @experimental
     */
    static readonly CERN_OHL_S_2_0: SpdxLicense;
    /**
     * (experimental) CERN Open Hardware Licence Version 2 - Weakly Reciprocal.
     *
     * @see https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2
     * @experimental
     */
    static readonly CERN_OHL_W_2_0: SpdxLicense;
    /**
     * (experimental) CNRI Jython License.
     *
     * @see http://www.jython.org/license.html
     * @experimental
     */
    static readonly CNRI_JYTHON: SpdxLicense;
    /**
     * (experimental) CNRI Python License.
     *
     * @see https://opensource.org/licenses/CNRI-Python
     * @experimental
     * @osiApproved true
     */
    static readonly CNRI_PYTHON: SpdxLicense;
    /**
     * (experimental) CNRI Python Open Source GPL Compatible License Agreement.
     *
     * @see http://www.python.org/download/releases/1.6.1/download_win/
     * @experimental
     */
    static readonly CNRI_PYTHON_GPL_COMPATIBLE: SpdxLicense;
    /**
     * (experimental) Common Public Attribution License 1.0.
     *
     * @see https://opensource.org/licenses/CPAL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly CPAL_1_0: SpdxLicense;
    /**
     * (experimental) Common Public License 1.0.
     *
     * @see https://opensource.org/licenses/CPL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly CPL_1_0: SpdxLicense;
    /**
     * (experimental) Code Project Open License 1.02.
     *
     * @see http://www.codeproject.com/info/cpol10.aspx
     * @experimental
     */
    static readonly CPOL_1_02: SpdxLicense;
    /**
     * (experimental) CUA Office Public License v1.0.
     *
     * @see https://opensource.org/licenses/CUA-OPL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly CUA_OPL_1_0: SpdxLicense;
    /**
     * (experimental) Caldera License.
     *
     * @see http://www.lemis.com/grog/UNIX/ancient-source-all.pdf
     * @experimental
     */
    static readonly CALDERA: SpdxLicense;
    /**
     * (experimental) Clarified Artistic License.
     *
     * @see http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/
     * @experimental
     */
    static readonly CL_ARTISTIC: SpdxLicense;
    /**
     * (experimental) Condor Public License v1.1.
     *
     * @see http://research.cs.wisc.edu/condor/license.html#condor
     * @experimental
     */
    static readonly CONDOR_1_1: SpdxLicense;
    /**
     * (experimental) Crossword License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Crossword
     * @experimental
     */
    static readonly CROSSWORD: SpdxLicense;
    /**
     * (experimental) CrystalStacker License.
     *
     * @see https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker
     * @experimental
     */
    static readonly CRYSTAL_STACKER: SpdxLicense;
    /**
     * (experimental) Cube License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Cube
     * @experimental
     */
    static readonly CUBE: SpdxLicense;
    /**
     * (experimental) Deutsche Freie Software Lizenz.
     *
     * @see http://www.dipp.nrw.de/d-fsl/lizenzen/
     * @experimental
     */
    static readonly D_FSL_1_0: SpdxLicense;
    /**
     * (experimental) DOC License.
     *
     * @see http://www.cs.wustl.edu/~schmidt/ACE-copying.html
     * @experimental
     */
    static readonly DOC: SpdxLicense;
    /**
     * (experimental) DSDP License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/DSDP
     * @experimental
     */
    static readonly DSDP: SpdxLicense;
    /**
     * (experimental) Dotseqn License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Dotseqn
     * @experimental
     */
    static readonly DOTSEQN: SpdxLicense;
    /**
     * (experimental) Educational Community License v1.0.
     *
     * @see https://opensource.org/licenses/ECL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly ECL_1_0: SpdxLicense;
    /**
     * (experimental) Educational Community License v2.0.
     *
     * @see https://opensource.org/licenses/ECL-2.0
     * @experimental
     * @osiApproved true
     */
    static readonly ECL_2_0: SpdxLicense;
    /**
     * (experimental) Eiffel Forum License v1.0.
     *
     * @see http://www.eiffel-nice.org/license/forum.txt
     * @experimental
     * @osiApproved true
     */
    static readonly EFL_1_0: SpdxLicense;
    /**
     * (experimental) Eiffel Forum License v2.0.
     *
     * @see http://www.eiffel-nice.org/license/eiffel-forum-license-2.html
     * @experimental
     * @osiApproved true
     */
    static readonly EFL_2_0: SpdxLicense;
    /**
     * (experimental) EPICS Open License.
     *
     * @see https://epics.anl.gov/license/open.php
     * @experimental
     */
    static readonly EPICS: SpdxLicense;
    /**
     * (experimental) Eclipse Public License 1.0.
     *
     * @see http://www.eclipse.org/legal/epl-v10.html
     * @experimental
     * @osiApproved true
     */
    static readonly EPL_1_0: SpdxLicense;
    /**
     * (experimental) Eclipse Public License 2.0.
     *
     * @see https://www.eclipse.org/legal/epl-2.0
     * @experimental
     * @osiApproved true
     */
    static readonly EPL_2_0: SpdxLicense;
    /**
     * (experimental) EU DataGrid Software License.
     *
     * @see http://eu-datagrid.web.cern.ch/eu-datagrid/license.html
     * @experimental
     * @osiApproved true
     */
    static readonly EUDATAGRID: SpdxLicense;
    /**
     * (experimental) European Union Public License 1.0.
     *
     * @see http://ec.europa.eu/idabc/en/document/7330.html
     * @experimental
     */
    static readonly EUPL_1_0: SpdxLicense;
    /**
     * (experimental) European Union Public License 1.1.
     *
     * @see https://joinup.ec.europa.eu/software/page/eupl/licence-eupl
     * @experimental
     * @osiApproved true
     */
    static readonly EUPL_1_1: SpdxLicense;
    /**
     * (experimental) European Union Public License 1.2.
     *
     * @see https://joinup.ec.europa.eu/page/eupl-text-11-12
     * @experimental
     * @osiApproved true
     */
    static readonly EUPL_1_2: SpdxLicense;
    /**
     * (experimental) Entessa Public License v1.0.
     *
     * @see https://opensource.org/licenses/Entessa
     * @experimental
     * @osiApproved true
     */
    static readonly ENTESSA: SpdxLicense;
    /**
     * (experimental) Erlang Public License v1.1.
     *
     * @see http://www.erlang.org/EPLICENSE
     * @experimental
     */
    static readonly ERLPL_1_1: SpdxLicense;
    /**
     * (experimental) Eurosym License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Eurosym
     * @experimental
     */
    static readonly EUROSYM: SpdxLicense;
    /**
     * (experimental) FSF All Permissive License.
     *
     * @see https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html
     * @experimental
     */
    static readonly FSFAP: SpdxLicense;
    /**
     * (experimental) FSF Unlimited License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License
     * @experimental
     */
    static readonly FSFUL: SpdxLicense;
    /**
     * (experimental) FSF Unlimited License (with License Retention).
     *
     * @see https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant
     * @experimental
     */
    static readonly FSFULLR: SpdxLicense;
    /**
     * (experimental) Freetype Project License.
     *
     * @see http://freetype.fis.uniroma2.it/FTL.TXT
     * @experimental
     */
    static readonly FTL: SpdxLicense;
    /**
     * (experimental) Fair License.
     *
     * @see http://fairlicense.org/
     * @experimental
     * @osiApproved true
     */
    static readonly FAIR: SpdxLicense;
    /**
     * (experimental) Frameworx Open License 1.0.
     *
     * @see https://opensource.org/licenses/Frameworx-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly FRAMEWORX_1_0: SpdxLicense;
    /**
     * (experimental) FreeImage Public License v1.0.
     *
     * @see http://freeimage.sourceforge.net/freeimage-license.txt
     * @experimental
     */
    static readonly FREE_IMAGE: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.1.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     * @experimental
     */
    static readonly GFDL_1_1: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.1 only - invariants.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     * @experimental
     */
    static readonly GFDL_1_1_INVARIANTS_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.1 or later - invariants.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     * @experimental
     */
    static readonly GFDL_1_1_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.1 only - no invariants.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     * @experimental
     */
    static readonly GFDL_1_1_NO_INVARIANTS_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.1 or later - no invariants.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     * @experimental
     */
    static readonly GFDL_1_1_NO_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.1 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     * @experimental
     */
    static readonly GFDL_1_1_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.1 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt
     * @experimental
     */
    static readonly GFDL_1_1_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.2.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     * @experimental
     */
    static readonly GFDL_1_2: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.2 only - invariants.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     * @experimental
     */
    static readonly GFDL_1_2_INVARIANTS_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.2 or later - invariants.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     * @experimental
     */
    static readonly GFDL_1_2_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.2 only - no invariants.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     * @experimental
     */
    static readonly GFDL_1_2_NO_INVARIANTS_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.2 or later - no invariants.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     * @experimental
     */
    static readonly GFDL_1_2_NO_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.2 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     * @experimental
     */
    static readonly GFDL_1_2_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.2 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt
     * @experimental
     */
    static readonly GFDL_1_2_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.3.
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     * @experimental
     */
    static readonly GFDL_1_3: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.3 only - invariants.
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     * @experimental
     */
    static readonly GFDL_1_3_INVARIANTS_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.3 or later - invariants.
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     * @experimental
     */
    static readonly GFDL_1_3_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.3 only - no invariants.
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     * @experimental
     */
    static readonly GFDL_1_3_NO_INVARIANTS_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.3 or later - no invariants.
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     * @experimental
     */
    static readonly GFDL_1_3_NO_INVARIANTS_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.3 only.
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     * @experimental
     */
    static readonly GFDL_1_3_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Free Documentation License v1.3 or later.
     *
     * @see https://www.gnu.org/licenses/fdl-1.3.txt
     * @experimental
     */
    static readonly GFDL_1_3_OR_LATER: SpdxLicense;
    /**
     * (experimental) GL2PS License.
     *
     * @see http://www.geuz.org/gl2ps/COPYING.GL2PS
     * @experimental
     */
    static readonly GL2_P_S: SpdxLicense;
    /**
     * (experimental) Good Luck With That Public License.
     *
     * @see https://github.com/me-shaon/GLWTPL/commit/da5f6bc734095efbacb442c0b31e33a65b9d6e85
     * @experimental
     */
    static readonly GLWTPL: SpdxLicense;
    /**
     * (experimental) GNU General Public License v1.0 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
     * @experimental
     */
    static readonly GPL_1_0: SpdxLicense;
    /**
     * (experimental) GNU General Public License v1.0 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
     * @experimental
     */
    static readonly GPL_1_0_PLUS: SpdxLicense;
    /**
     * (experimental) GNU General Public License v1.0 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
     * @experimental
     */
    static readonly GPL_1_0_ONLY: SpdxLicense;
    /**
     * (experimental) GNU General Public License v1.0 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html
     * @experimental
     */
    static readonly GPL_1_0_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU General Public License v2.0 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly GPL_2_0: SpdxLicense;
    /**
     * (experimental) GNU General Public License v2.0 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly GPL_2_0_PLUS: SpdxLicense;
    /**
     * (experimental) GNU General Public License v2.0 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly GPL_2_0_ONLY: SpdxLicense;
    /**
     * (experimental) GNU General Public License v2.0 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly GPL_2_0_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU General Public License v2.0 w/GCC Runtime Library exception.
     *
     * @see https://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10
     * @experimental
     */
    static readonly GPL_2_0_WITH_GCC_EXCEPTION: SpdxLicense;
    /**
     * (experimental) GNU General Public License v2.0 w/Autoconf exception.
     *
     * @see http://ac-archive.sourceforge.net/doc/copyright.html
     * @experimental
     */
    static readonly GPL_2_0_WITH_AUTOCONF_EXCEPTION: SpdxLicense;
    /**
     * (experimental) GNU General Public License v2.0 w/Bison exception.
     *
     * @see http://git.savannah.gnu.org/cgit/bison.git/tree/data/yacc.c?id=193d7c7054ba7197b0789e14965b739162319b5e#n141
     * @experimental
     */
    static readonly GPL_2_0_WITH_BISON_EXCEPTION: SpdxLicense;
    /**
     * (experimental) GNU General Public License v2.0 w/Classpath exception.
     *
     * @see https://www.gnu.org/software/classpath/license.html
     * @experimental
     */
    static readonly GPL_2_0_WITH_CLASSPATH_EXCEPTION: SpdxLicense;
    /**
     * (experimental) GNU General Public License v2.0 w/Font exception.
     *
     * @see https://www.gnu.org/licenses/gpl-faq.html#FontException
     * @experimental
     */
    static readonly GPL_2_0_WITH_FONT_EXCEPTION: SpdxLicense;
    /**
     * (experimental) GNU General Public License v3.0 only.
     *
     * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly GPL_3_0: SpdxLicense;
    /**
     * (experimental) GNU General Public License v3.0 or later.
     *
     * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly GPL_3_0_PLUS: SpdxLicense;
    /**
     * (experimental) GNU General Public License v3.0 only.
     *
     * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly GPL_3_0_ONLY: SpdxLicense;
    /**
     * (experimental) GNU General Public License v3.0 or later.
     *
     * @see https://www.gnu.org/licenses/gpl-3.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly GPL_3_0_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU General Public License v3.0 w/GCC Runtime Library exception.
     *
     * @see https://www.gnu.org/licenses/gcc-exception-3.1.html
     * @experimental
     * @osiApproved true
     */
    static readonly GPL_3_0_WITH_GCC_EXCEPTION: SpdxLicense;
    /**
     * (experimental) GNU General Public License v3.0 w/Autoconf exception.
     *
     * @see https://www.gnu.org/licenses/autoconf-exception-3.0.html
     * @experimental
     */
    static readonly GPL_3_0_WITH_AUTOCONF_EXCEPTION: SpdxLicense;
    /**
     * (experimental) Giftware License.
     *
     * @see http://liballeg.org/license.html#allegro-4-the-giftware-license
     * @experimental
     */
    static readonly GIFTWARE: SpdxLicense;
    /**
     * (experimental) 3dfx Glide License.
     *
     * @see http://www.users.on.net/~triforce/glidexp/COPYING.txt
     * @experimental
     */
    static readonly GLIDE: SpdxLicense;
    /**
     * (experimental) Glulxe License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Glulxe
     * @experimental
     */
    static readonly GLULXE: SpdxLicense;
    /**
     * (experimental) Historical Permission Notice and Disclaimer.
     *
     * @see https://opensource.org/licenses/HPND
     * @experimental
     * @osiApproved true
     */
    static readonly HPND: SpdxLicense;
    /**
     * (experimental) Historical Permission Notice and Disclaimer - sell variant.
     *
     * @see https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/net/sunrpc/auth_gss/gss_generic_token.c?h=v4.19
     * @experimental
     */
    static readonly HPND_SELL_VARIANT: SpdxLicense;
    /**
     * (experimental) HTML Tidy License.
     *
     * @see https://github.com/htacg/tidy-html5/blob/next/README/LICENSE.md
     * @experimental
     */
    static readonly HTMLTIDY: SpdxLicense;
    /**
     * (experimental) Haskell Language Report License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License
     * @experimental
     */
    static readonly HASKELL_REPORT: SpdxLicense;
    /**
     * (experimental) Hippocratic License 2.1.
     *
     * @see https://firstdonoharm.dev/version/2/1/license.html
     * @experimental
     */
    static readonly HIPPOCRATIC_2_1: SpdxLicense;
    /**
     * (experimental) IBM PowerPC Initialization and Boot Software.
     *
     * @see http://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d
     * @experimental
     */
    static readonly IBM_PIBS: SpdxLicense;
    /**
     * (experimental) ICU License.
     *
     * @see http://source.icu-project.org/repos/icu/icu/trunk/license.html
     * @experimental
     */
    static readonly ICU: SpdxLicense;
    /**
     * (experimental) Independent JPEG Group License.
     *
     * @see http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2
     * @experimental
     */
    static readonly IJG: SpdxLicense;
    /**
     * (experimental) IPA Font License.
     *
     * @see https://opensource.org/licenses/IPA
     * @experimental
     * @osiApproved true
     */
    static readonly IPA: SpdxLicense;
    /**
     * (experimental) IBM Public License v1.0.
     *
     * @see https://opensource.org/licenses/IPL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly IPL_1_0: SpdxLicense;
    /**
     * (experimental) ISC License.
     *
     * @see https://www.isc.org/downloads/software-support-policy/isc-license/
     * @experimental
     * @osiApproved true
     */
    static readonly ISC: SpdxLicense;
    /**
     * (experimental) ImageMagick License.
     *
     * @see http://www.imagemagick.org/script/license.php
     * @experimental
     */
    static readonly IMAGE_MAGICK: SpdxLicense;
    /**
     * (experimental) Imlib2 License.
     *
     * @see http://trac.enlightenment.org/e/browser/trunk/imlib2/COPYING
     * @experimental
     */
    static readonly IMLIB2: SpdxLicense;
    /**
     * (experimental) Info-ZIP License.
     *
     * @see http://www.info-zip.org/license.html
     * @experimental
     */
    static readonly INFO_ZIP: SpdxLicense;
    /**
     * (experimental) Intel Open Source License.
     *
     * @see https://opensource.org/licenses/Intel
     * @experimental
     * @osiApproved true
     */
    static readonly INTEL: SpdxLicense;
    /**
     * (experimental) Intel ACPI Software License Agreement.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement
     * @experimental
     */
    static readonly INTEL_ACPI: SpdxLicense;
    /**
     * (experimental) Interbase Public License v1.0.
     *
     * @see https://web.archive.org/web/20060319014854/http://info.borland.com/devsupport/interbase/opensource/IPL.html
     * @experimental
     */
    static readonly INTERBASE_1_0: SpdxLicense;
    /**
     * (experimental) Japan Network Information Center License.
     *
     * @see https://gitlab.isc.org/isc-projects/bind9/blob/master/COPYRIGHT#L366
     * @experimental
     */
    static readonly JPNIC: SpdxLicense;
    /**
     * (experimental) JSON License.
     *
     * @see http://www.json.org/license.html
     * @experimental
     */
    static readonly JSON: SpdxLicense;
    /**
     * (experimental) JasPer License.
     *
     * @see http://www.ece.uvic.ca/~mdadams/jasper/LICENSE
     * @experimental
     */
    static readonly JASPER_2_0: SpdxLicense;
    /**
     * (experimental) Licence Art Libre 1.2.
     *
     * @see http://artlibre.org/licence/lal/licence-art-libre-12/
     * @experimental
     */
    static readonly LAL_1_2: SpdxLicense;
    /**
     * (experimental) Licence Art Libre 1.3.
     *
     * @see https://artlibre.org/
     * @experimental
     */
    static readonly LAL_1_3: SpdxLicense;
    /**
     * (experimental) GNU Library General Public License v2 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_2_0: SpdxLicense;
    /**
     * (experimental) GNU Library General Public License v2 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_2_0_PLUS: SpdxLicense;
    /**
     * (experimental) GNU Library General Public License v2 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_2_0_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Library General Public License v2 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_2_0_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Lesser General Public License v2.1 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_2_1: SpdxLicense;
    /**
     * (experimental) GNU Library General Public License v2.1 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_2_1_PLUS: SpdxLicense;
    /**
     * (experimental) GNU Lesser General Public License v2.1 only.
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_2_1_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Lesser General Public License v2.1 or later.
     *
     * @see https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_2_1_OR_LATER: SpdxLicense;
    /**
     * (experimental) GNU Lesser General Public License v3.0 only.
     *
     * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_3_0: SpdxLicense;
    /**
     * (experimental) GNU Lesser General Public License v3.0 or later.
     *
     * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_3_0_PLUS: SpdxLicense;
    /**
     * (experimental) GNU Lesser General Public License v3.0 only.
     *
     * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_3_0_ONLY: SpdxLicense;
    /**
     * (experimental) GNU Lesser General Public License v3.0 or later.
     *
     * @see https://www.gnu.org/licenses/lgpl-3.0-standalone.html
     * @experimental
     * @osiApproved true
     */
    static readonly LGPL_3_0_OR_LATER: SpdxLicense;
    /**
     * (experimental) Lesser General Public License For Linguistic Resources.
     *
     * @see http://www-igm.univ-mlv.fr/~unitex/lgpllr.html
     * @experimental
     */
    static readonly LGPLLR: SpdxLicense;
    /**
     * (experimental) Lucent Public License Version 1.0.
     *
     * @see https://opensource.org/licenses/LPL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly LPL_1_0: SpdxLicense;
    /**
     * (experimental) Lucent Public License v1.02.
     *
     * @see http://plan9.bell-labs.com/plan9/license.html
     * @experimental
     * @osiApproved true
     */
    static readonly LPL_1_02: SpdxLicense;
    /**
     * (experimental) LaTeX Project Public License v1.0.
     *
     * @see http://www.latex-project.org/lppl/lppl-1-0.txt
     * @experimental
     */
    static readonly LPPL_1_0: SpdxLicense;
    /**
     * (experimental) LaTeX Project Public License v1.1.
     *
     * @see http://www.latex-project.org/lppl/lppl-1-1.txt
     * @experimental
     */
    static readonly LPPL_1_1: SpdxLicense;
    /**
     * (experimental) LaTeX Project Public License v1.2.
     *
     * @see http://www.latex-project.org/lppl/lppl-1-2.txt
     * @experimental
     */
    static readonly LPPL_1_2: SpdxLicense;
    /**
     * (experimental) LaTeX Project Public License v1.3a.
     *
     * @see http://www.latex-project.org/lppl/lppl-1-3a.txt
     * @experimental
     */
    static readonly LPPL_1_3A: SpdxLicense;
    /**
     * (experimental) LaTeX Project Public License v1.3c.
     *
     * @see http://www.latex-project.org/lppl/lppl-1-3c.txt
     * @experimental
     * @osiApproved true
     */
    static readonly LPPL_1_3C: SpdxLicense;
    /**
     * (experimental) Latex2e License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Latex2e
     * @experimental
     */
    static readonly LATEX2_E: SpdxLicense;
    /**
     * (experimental) Leptonica License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Leptonica
     * @experimental
     */
    static readonly LEPTONICA: SpdxLicense;
    /**
     * (experimental) Licence Libre du Québec – Permissive version 1.1.
     *
     * @see https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/
     * @experimental
     * @osiApproved true
     */
    static readonly LILIQ_P_1_1: SpdxLicense;
    /**
     * (experimental) Licence Libre du Québec – Réciprocité version 1.1.
     *
     * @see https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/
     * @experimental
     * @osiApproved true
     */
    static readonly LILIQ_R_1_1: SpdxLicense;
    /**
     * (experimental) Licence Libre du Québec – Réciprocité forte version 1.1.
     *
     * @see https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/
     * @experimental
     * @osiApproved true
     */
    static readonly LILIQ_RPLUS_1_1: SpdxLicense;
    /**
     * (experimental) libpng License.
     *
     * @see http://www.libpng.org/pub/png/src/libpng-LICENSE.txt
     * @experimental
     */
    static readonly LIBPNG: SpdxLicense;
    /**
     * (experimental) Linux Kernel Variant of OpenIB.org license.
     *
     * @see https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/drivers/infiniband/core/sa.h
     * @experimental
     */
    static readonly LINUX_OPENIB: SpdxLicense;
    /**
     * (experimental) MIT License.
     *
     * @see https://opensource.org/licenses/MIT
     * @experimental
     * @osiApproved true
     */
    static readonly MIT: SpdxLicense;
    /**
     * (experimental) MIT No Attribution.
     *
     * @see https://github.com/aws/mit-0
     * @experimental
     * @osiApproved true
     */
    static readonly MIT_0: SpdxLicense;
    /**
     * (experimental) CMU License.
     *
     * @see https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style
     * @experimental
     */
    static readonly MIT_CMU: SpdxLicense;
    /**
     * (experimental) Enlightenment License (e16).
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising
     * @experimental
     */
    static readonly MIT_ADVERTISING: SpdxLicense;
    /**
     * (experimental) enna License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT#enna
     * @experimental
     */
    static readonly MIT_ENNA: SpdxLicense;
    /**
     * (experimental) feh License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT#feh
     * @experimental
     */
    static readonly MIT_FEH: SpdxLicense;
    /**
     * (experimental) MIT Open Group variant.
     *
     * @see https://gitlab.freedesktop.org/xorg/app/iceauth/-/blob/master/COPYING
     * @experimental
     */
    static readonly MIT_OPEN_GROUP: SpdxLicense;
    /**
     * (experimental) MIT +no-false-attribs license.
     *
     * @see https://fedoraproject.org/wiki/Licensing/MITNFA
     * @experimental
     */
    static readonly MITNFA: SpdxLicense;
    /**
     * (experimental) Mozilla Public License 1.0.
     *
     * @see http://www.mozilla.org/MPL/MPL-1.0.html
     * @experimental
     * @osiApproved true
     */
    static readonly MPL_1_0: SpdxLicense;
    /**
     * (experimental) Mozilla Public License 1.1.
     *
     * @see http://www.mozilla.org/MPL/MPL-1.1.html
     * @experimental
     * @osiApproved true
     */
    static readonly MPL_1_1: SpdxLicense;
    /**
     * (experimental) Mozilla Public License 2.0.
     *
     * @see http://www.mozilla.org/MPL/2.0/
     * @experimental
     * @osiApproved true
     */
    static readonly MPL_2_0: SpdxLicense;
    /**
     * (experimental) Mozilla Public License 2.0 (no copyleft exception).
     *
     * @see http://www.mozilla.org/MPL/2.0/
     * @experimental
     * @osiApproved true
     */
    static readonly MPL_2_0_NO_COPYLEFT_EXCEPTION: SpdxLicense;
    /**
     * (experimental) Microsoft Public License.
     *
     * @see http://www.microsoft.com/opensource/licenses.mspx
     * @experimental
     * @osiApproved true
     */
    static readonly MS_PL: SpdxLicense;
    /**
     * (experimental) Microsoft Reciprocal License.
     *
     * @see http://www.microsoft.com/opensource/licenses.mspx
     * @experimental
     * @osiApproved true
     */
    static readonly MS_RL: SpdxLicense;
    /**
     * (experimental) Matrix Template Library License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License
     * @experimental
     */
    static readonly MTLL: SpdxLicense;
    /**
     * (experimental) MakeIndex License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/MakeIndex
     * @experimental
     */
    static readonly MAKE_INDEX: SpdxLicense;
    /**
     * (experimental) The MirOS Licence.
     *
     * @see https://opensource.org/licenses/MirOS
     * @experimental
     * @osiApproved true
     */
    static readonly MIR_O_S: SpdxLicense;
    /**
     * (experimental) Motosoto License.
     *
     * @see https://opensource.org/licenses/Motosoto
     * @experimental
     * @osiApproved true
     */
    static readonly MOTOSOTO: SpdxLicense;
    /**
     * (experimental) Mulan Permissive Software License, Version 1.
     *
     * @see https://license.coscl.org.cn/MulanPSL/
     * @experimental
     */
    static readonly MULANPSL_1_0: SpdxLicense;
    /**
     * (experimental) Mulan Permissive Software License, Version 2.
     *
     * @see https://license.coscl.org.cn/MulanPSL2/
     * @experimental
     * @osiApproved true
     */
    static readonly MULANPSL_2_0: SpdxLicense;
    /**
     * (experimental) Multics License.
     *
     * @see https://opensource.org/licenses/Multics
     * @experimental
     * @osiApproved true
     */
    static readonly MULTICS: SpdxLicense;
    /**
     * (experimental) Mup License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Mup
     * @experimental
     */
    static readonly MUP: SpdxLicense;
    /**
     * (experimental) NASA Open Source Agreement 1.3.
     *
     * @see http://ti.arc.nasa.gov/opensource/nosa/
     * @experimental
     * @osiApproved true
     */
    static readonly NASA_1_3: SpdxLicense;
    /**
     * (experimental) Net Boolean Public License v1.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894
     * @experimental
     */
    static readonly NBPL_1_0: SpdxLicense;
    /**
     * (experimental) Non-Commercial Government Licence.
     *
     * @see https://github.com/spdx/license-list-XML/blob/master/src/Apache-2.0.xml
     * @experimental
     */
    static readonly NCGL_UK_2_0: SpdxLicense;
    /**
     * (experimental) University of Illinois/NCSA Open Source License.
     *
     * @see http://otm.illinois.edu/uiuc_openSource
     * @experimental
     * @osiApproved true
     */
    static readonly NCSA: SpdxLicense;
    /**
     * (experimental) Nethack General Public License.
     *
     * @see https://opensource.org/licenses/NGPL
     * @experimental
     * @osiApproved true
     */
    static readonly NGPL: SpdxLicense;
    /**
     * (experimental) NIST Public Domain Notice.
     *
     * @see https://github.com/tcheneau/simpleRPL/blob/e645e69e38dd4e3ccfeceb2db8cba05b7c2e0cd3/LICENSE.txt
     * @experimental
     */
    static readonly NIST_PD: SpdxLicense;
    /**
     * (experimental) NIST Public Domain Notice with license fallback.
     *
     * @see https://github.com/usnistgov/jsip/blob/59700e6926cbe96c5cdae897d9a7d2656b42abe3/LICENSE
     * @experimental
     */
    static readonly NIST_PD_FALLBACK: SpdxLicense;
    /**
     * (experimental) Norwegian Licence for Open Government Data.
     *
     * @see http://data.norge.no/nlod/en/1.0
     * @experimental
     */
    static readonly NLOD_1_0: SpdxLicense;
    /**
     * (experimental) No Limit Public License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/NLPL
     * @experimental
     */
    static readonly NLPL: SpdxLicense;
    /**
     * (experimental) Netizen Open Source License.
     *
     * @see http://bits.netizen.com.au/licenses/NOSL/nosl.txt
     * @experimental
     */
    static readonly NOSL: SpdxLicense;
    /**
     * (experimental) Netscape Public License v1.0.
     *
     * @see http://www.mozilla.org/MPL/NPL/1.0/
     * @experimental
     */
    static readonly NPL_1_0: SpdxLicense;
    /**
     * (experimental) Netscape Public License v1.1.
     *
     * @see http://www.mozilla.org/MPL/NPL/1.1/
     * @experimental
     */
    static readonly NPL_1_1: SpdxLicense;
    /**
     * (experimental) Non-Profit Open Software License 3.0.
     *
     * @see https://opensource.org/licenses/NOSL3.0
     * @experimental
     * @osiApproved true
     */
    static readonly NPOSL_3_0: SpdxLicense;
    /**
     * (experimental) NRL License.
     *
     * @see http://web.mit.edu/network/isakmp/nrllicense.html
     * @experimental
     */
    static readonly NRL: SpdxLicense;
    /**
     * (experimental) NTP License.
     *
     * @see https://opensource.org/licenses/NTP
     * @experimental
     * @osiApproved true
     */
    static readonly NTP: SpdxLicense;
    /**
     * (experimental) NTP No Attribution.
     *
     * @see https://github.com/tytso/e2fsprogs/blob/master/lib/et/et_name.c
     * @experimental
     */
    static readonly NTP_0: SpdxLicense;
    /**
     * (experimental) Naumen Public License.
     *
     * @see https://opensource.org/licenses/Naumen
     * @experimental
     * @osiApproved true
     */
    static readonly NAUMEN: SpdxLicense;
    /**
     * (experimental) Net-SNMP License.
     *
     * @see http://net-snmp.sourceforge.net/about/license.html
     * @experimental
     */
    static readonly NET_SNMP: SpdxLicense;
    /**
     * (experimental) NetCDF license.
     *
     * @see http://www.unidata.ucar.edu/software/netcdf/copyright.html
     * @experimental
     */
    static readonly NET_CD_F: SpdxLicense;
    /**
     * (experimental) Newsletr License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Newsletr
     * @experimental
     */
    static readonly NEWSLETR: SpdxLicense;
    /**
     * (experimental) Nokia Open Source License.
     *
     * @see https://opensource.org/licenses/nokia
     * @experimental
     * @osiApproved true
     */
    static readonly NOKIA: SpdxLicense;
    /**
     * (experimental) Noweb License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Noweb
     * @experimental
     */
    static readonly NOWEB: SpdxLicense;
    /**
     * (experimental) Nunit License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Nunit
     * @experimental
     */
    static readonly NUNIT: SpdxLicense;
    /**
     * (experimental) Open Use of Data Agreement v1.0.
     *
     * @see https://github.com/microsoft/Open-Use-of-Data-Agreement/blob/v1.0/O-UDA-1.0.md
     * @experimental
     */
    static readonly O_UDA_1_0: SpdxLicense;
    /**
     * (experimental) Open CASCADE Technology Public License.
     *
     * @see http://www.opencascade.com/content/occt-public-license
     * @experimental
     */
    static readonly OCCT_PL: SpdxLicense;
    /**
     * (experimental) OCLC Research Public License 2.0.
     *
     * @see http://www.oclc.org/research/activities/software/license/v2final.htm
     * @experimental
     * @osiApproved true
     */
    static readonly OCLC_2_0: SpdxLicense;
    /**
     * (experimental) Open Data Commons Attribution License v1.0.
     *
     * @see https://opendatacommons.org/licenses/by/1.0/
     * @experimental
     */
    static readonly ODC_BY_1_0: SpdxLicense;
    /**
     * (experimental) ODC Open Database License v1.0.
     *
     * @see http://www.opendatacommons.org/licenses/odbl/1.0/
     * @experimental
     */
    static readonly ODBL_1_0: SpdxLicense;
    /**
     * (experimental) SIL Open Font License 1.0.
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
     * @experimental
     */
    static readonly OFL_1_0: SpdxLicense;
    /**
     * (experimental) SIL Open Font License 1.0 with Reserved Font Name.
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
     * @experimental
     */
    static readonly OFL_1_0_RFN: SpdxLicense;
    /**
     * (experimental) SIL Open Font License 1.0 with no Reserved Font Name.
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web
     * @experimental
     */
    static readonly OFL_1_0_NO_RFN: SpdxLicense;
    /**
     * (experimental) SIL Open Font License 1.1.
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
     * @experimental
     * @osiApproved true
     */
    static readonly OFL_1_1: SpdxLicense;
    /**
     * (experimental) SIL Open Font License 1.1 with Reserved Font Name.
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
     * @experimental
     * @osiApproved true
     */
    static readonly OFL_1_1_RFN: SpdxLicense;
    /**
     * (experimental) SIL Open Font License 1.1 with no Reserved Font Name.
     *
     * @see http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web
     * @experimental
     * @osiApproved true
     */
    static readonly OFL_1_1_NO_RFN: SpdxLicense;
    /**
     * (experimental) OGC Software License, Version 1.0.
     *
     * @see https://www.ogc.org/ogc/software/1.0
     * @experimental
     */
    static readonly OGC_1_0: SpdxLicense;
    /**
     * (experimental) Open Government Licence - Canada.
     *
     * @see https://open.canada.ca/en/open-government-licence-canada
     * @experimental
     */
    static readonly OGL_CANADA_2_0: SpdxLicense;
    /**
     * (experimental) Open Government Licence v1.0.
     *
     * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/
     * @experimental
     */
    static readonly OGL_UK_1_0: SpdxLicense;
    /**
     * (experimental) Open Government Licence v2.0.
     *
     * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/
     * @experimental
     */
    static readonly OGL_UK_2_0: SpdxLicense;
    /**
     * (experimental) Open Government Licence v3.0.
     *
     * @see http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/
     * @experimental
     */
    static readonly OGL_UK_3_0: SpdxLicense;
    /**
     * (experimental) Open Group Test Suite License.
     *
     * @see http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt
     * @experimental
     * @osiApproved true
     */
    static readonly OGTSL: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v1.1.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f
     * @experimental
     */
    static readonly OLDAP_1_1: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v1.2.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7
     * @experimental
     */
    static readonly OLDAP_1_2: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v1.3.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1
     * @experimental
     */
    static readonly OLDAP_1_3: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v1.4.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941
     * @experimental
     */
    static readonly OLDAP_1_4: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B).
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea
     * @experimental
     */
    static readonly OLDAP_2_0: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.0.1.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e
     * @experimental
     */
    static readonly OLDAP_2_0_1: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.1.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715
     * @experimental
     */
    static readonly OLDAP_2_1: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.2.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3
     * @experimental
     */
    static readonly OLDAP_2_2: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.2.1.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e
     * @experimental
     */
    static readonly OLDAP_2_2_1: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License 2.2.2.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188
     * @experimental
     */
    static readonly OLDAP_2_2_2: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.3.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3
     * @experimental
     */
    static readonly OLDAP_2_3: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.4.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386
     * @experimental
     */
    static readonly OLDAP_2_4: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.5.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf
     * @experimental
     */
    static readonly OLDAP_2_5: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.6.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205
     * @experimental
     */
    static readonly OLDAP_2_6: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.7.
     *
     * @see http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2
     * @experimental
     */
    static readonly OLDAP_2_7: SpdxLicense;
    /**
     * (experimental) Open LDAP Public License v2.8.
     *
     * @see http://www.openldap.org/software/release/license.html
     * @experimental
     * @osiApproved true
     */
    static readonly OLDAP_2_8: SpdxLicense;
    /**
     * (experimental) Open Market License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Open_Market_License
     * @experimental
     */
    static readonly OML: SpdxLicense;
    /**
     * (experimental) Open Public License v1.0.
     *
     * @see http://old.koalateam.com/jackaroo/OPL_1_0.TXT
     * @experimental
     */
    static readonly OPL_1_0: SpdxLicense;
    /**
     * (experimental) OSET Public License version 2.1.
     *
     * @see http://www.osetfoundation.org/public-license
     * @experimental
     * @osiApproved true
     */
    static readonly OSET_PL_2_1: SpdxLicense;
    /**
     * (experimental) Open Software License 1.0.
     *
     * @see https://opensource.org/licenses/OSL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly OSL_1_0: SpdxLicense;
    /**
     * (experimental) Open Software License 1.1.
     *
     * @see https://fedoraproject.org/wiki/Licensing/OSL1.1
     * @experimental
     */
    static readonly OSL_1_1: SpdxLicense;
    /**
     * (experimental) Open Software License 2.0.
     *
     * @see http://web.archive.org/web/20041020171434/http://www.rosenlaw.com/osl2.0.html
     * @experimental
     * @osiApproved true
     */
    static readonly OSL_2_0: SpdxLicense;
    /**
     * (experimental) Open Software License 2.1.
     *
     * @see http://web.archive.org/web/20050212003940/http://www.rosenlaw.com/osl21.htm
     * @experimental
     * @osiApproved true
     */
    static readonly OSL_2_1: SpdxLicense;
    /**
     * (experimental) Open Software License 3.0.
     *
     * @see https://web.archive.org/web/20120101081418/http://rosenlaw.com:80/OSL3.0.htm
     * @experimental
     * @osiApproved true
     */
    static readonly OSL_3_0: SpdxLicense;
    /**
     * (experimental) OpenSSL License.
     *
     * @see http://www.openssl.org/source/license.html
     * @experimental
     */
    static readonly OPEN_SS_L: SpdxLicense;
    /**
     * (experimental) ODC Public Domain Dedication & License 1.0.
     *
     * @see http://opendatacommons.org/licenses/pddl/1.0/
     * @experimental
     */
    static readonly PDDL_1_0: SpdxLicense;
    /**
     * (experimental) PHP License v3.0.
     *
     * @see http://www.php.net/license/3_0.txt
     * @experimental
     * @osiApproved true
     */
    static readonly PHP_3_0: SpdxLicense;
    /**
     * (experimental) PHP License v3.01.
     *
     * @see http://www.php.net/license/3_01.txt
     * @experimental
     * @osiApproved true
     */
    static readonly PHP_3_01: SpdxLicense;
    /**
     * (experimental) Python Software Foundation License 2.0.
     *
     * @see https://opensource.org/licenses/Python-2.0
     * @experimental
     */
    static readonly PSF_2_0: SpdxLicense;
    /**
     * (experimental) The Parity Public License 6.0.0.
     *
     * @see https://paritylicense.com/versions/6.0.0.html
     * @experimental
     */
    static readonly PARITY_6_0_0: SpdxLicense;
    /**
     * (experimental) The Parity Public License 7.0.0.
     *
     * @see https://paritylicense.com/versions/7.0.0.html
     * @experimental
     */
    static readonly PARITY_7_0_0: SpdxLicense;
    /**
     * (experimental) Plexus Classworlds License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License
     * @experimental
     */
    static readonly PLEXUS: SpdxLicense;
    /**
     * (experimental) PolyForm Noncommercial License 1.0.0.
     *
     * @see https://polyformproject.org/licenses/noncommercial/1.0.0
     * @experimental
     */
    static readonly POLYFORM_NONCOMMERCIAL_1_0_0: SpdxLicense;
    /**
     * (experimental) PolyForm Small Business License 1.0.0.
     *
     * @see https://polyformproject.org/licenses/small-business/1.0.0
     * @experimental
     */
    static readonly POLYFORM_SMALL_BUSINESS_1_0_0: SpdxLicense;
    /**
     * (experimental) PostgreSQL License.
     *
     * @see http://www.postgresql.org/about/licence
     * @experimental
     * @osiApproved true
     */
    static readonly POSTGRE_SQ_L: SpdxLicense;
    /**
     * (experimental) Python License 2.0.
     *
     * @see https://opensource.org/licenses/Python-2.0
     * @experimental
     * @osiApproved true
     */
    static readonly PYTHON_2_0: SpdxLicense;
    /**
     * (experimental) Q Public License 1.0.
     *
     * @see http://doc.qt.nokia.com/3.3/license.html
     * @experimental
     * @osiApproved true
     */
    static readonly QPL_1_0: SpdxLicense;
    /**
     * (experimental) Qhull License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Qhull
     * @experimental
     */
    static readonly QHULL: SpdxLicense;
    /**
     * (experimental) Red Hat eCos Public License v1.1.
     *
     * @see http://ecos.sourceware.org/old-license.html
     * @experimental
     */
    static readonly RHECOS_1_1: SpdxLicense;
    /**
     * (experimental) Reciprocal Public License 1.1.
     *
     * @see https://opensource.org/licenses/RPL-1.1
     * @experimental
     * @osiApproved true
     */
    static readonly RPL_1_1: SpdxLicense;
    /**
     * (experimental) Reciprocal Public License 1.5.
     *
     * @see https://opensource.org/licenses/RPL-1.5
     * @experimental
     * @osiApproved true
     */
    static readonly RPL_1_5: SpdxLicense;
    /**
     * (experimental) RealNetworks Public Source License v1.0.
     *
     * @see https://helixcommunity.org/content/rpsl
     * @experimental
     * @osiApproved true
     */
    static readonly RPSL_1_0: SpdxLicense;
    /**
     * (experimental) RSA Message-Digest License.
     *
     * @see http://www.faqs.org/rfcs/rfc1321.html
     * @experimental
     */
    static readonly RSA_MD: SpdxLicense;
    /**
     * (experimental) Ricoh Source Code Public License.
     *
     * @see http://wayback.archive.org/web/20060715140826/http://www.risource.org/RPL/RPL-1.0A.shtml
     * @experimental
     * @osiApproved true
     */
    static readonly RSCPL: SpdxLicense;
    /**
     * (experimental) Rdisc License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Rdisc_License
     * @experimental
     */
    static readonly RDISC: SpdxLicense;
    /**
     * (experimental) Ruby License.
     *
     * @see http://www.ruby-lang.org/en/LICENSE.txt
     * @experimental
     */
    static readonly RUBY: SpdxLicense;
    /**
     * (experimental) Sax Public Domain Notice.
     *
     * @see http://www.saxproject.org/copying.html
     * @experimental
     */
    static readonly SAX_PD: SpdxLicense;
    /**
     * (experimental) SCEA Shared Source License.
     *
     * @see http://research.scea.com/scea_shared_source_license.html
     * @experimental
     */
    static readonly SCEA: SpdxLicense;
    /**
     * (experimental) SGI Free Software License B v1.0.
     *
     * @see http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.1.0.html
     * @experimental
     */
    static readonly SGI_B_1_0: SpdxLicense;
    /**
     * (experimental) SGI Free Software License B v1.1.
     *
     * @see http://oss.sgi.com/projects/FreeB/
     * @experimental
     */
    static readonly SGI_B_1_1: SpdxLicense;
    /**
     * (experimental) SGI Free Software License B v2.0.
     *
     * @see http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.2.0.pdf
     * @experimental
     */
    static readonly SGI_B_2_0: SpdxLicense;
    /**
     * (experimental) Solderpad Hardware License v0.5.
     *
     * @see https://solderpad.org/licenses/SHL-0.5/
     * @experimental
     */
    static readonly SHL_0_5: SpdxLicense;
    /**
     * (experimental) Solderpad Hardware License, Version 0.51.
     *
     * @see https://solderpad.org/licenses/SHL-0.51/
     * @experimental
     */
    static readonly SHL_0_51: SpdxLicense;
    /**
     * (experimental) Sun Industry Standards Source License v1.1.
     *
     * @see http://www.openoffice.org/licenses/sissl_license.html
     * @experimental
     * @osiApproved true
     */
    static readonly SISSL: SpdxLicense;
    /**
     * (experimental) Sun Industry Standards Source License v1.2.
     *
     * @see http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html
     * @experimental
     */
    static readonly SISSL_1_2: SpdxLicense;
    /**
     * (experimental) Standard ML of New Jersey License.
     *
     * @see https://www.smlnj.org/license.html
     * @experimental
     */
    static readonly SMLNJ: SpdxLicense;
    /**
     * (experimental) Secure Messaging Protocol Public License.
     *
     * @see https://github.com/dcblake/SMP/blob/master/Documentation/License.txt
     * @experimental
     */
    static readonly SMPPL: SpdxLicense;
    /**
     * (experimental) SNIA Public License 1.1.
     *
     * @see https://fedoraproject.org/wiki/Licensing/SNIA_Public_License
     * @experimental
     */
    static readonly SNIA: SpdxLicense;
    /**
     * (experimental) Sun Public License v1.0.
     *
     * @see https://opensource.org/licenses/SPL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly SPL_1_0: SpdxLicense;
    /**
     * (experimental) SSH OpenSSH license.
     *
     * @see https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/LICENCE#L10
     * @experimental
     */
    static readonly SSH_OPENSSH: SpdxLicense;
    /**
     * (experimental) SSH short notice.
     *
     * @see https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/pathnames.h
     * @experimental
     */
    static readonly SSH_SHORT: SpdxLicense;
    /**
     * (experimental) Server Side Public License, v 1.
     *
     * @see https://www.mongodb.com/licensing/server-side-public-license
     * @experimental
     */
    static readonly SSPL_1_0: SpdxLicense;
    /**
     * (experimental) Scheme Widget Library (SWL) Software License Agreement.
     *
     * @see https://fedoraproject.org/wiki/Licensing/SWL
     * @experimental
     */
    static readonly SWL: SpdxLicense;
    /**
     * (experimental) Saxpath License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Saxpath_License
     * @experimental
     */
    static readonly SAXPATH: SpdxLicense;
    /**
     * (experimental) Sendmail License.
     *
     * @see http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf
     * @experimental
     */
    static readonly SENDMAIL: SpdxLicense;
    /**
     * (experimental) Sendmail License 8.23.
     *
     * @see https://www.proofpoint.com/sites/default/files/sendmail-license.pdf
     * @experimental
     */
    static readonly SENDMAIL_8_23: SpdxLicense;
    /**
     * (experimental) Simple Public License 2.0.
     *
     * @see https://opensource.org/licenses/SimPL-2.0
     * @experimental
     * @osiApproved true
     */
    static readonly SIMPL_2_0: SpdxLicense;
    /**
     * (experimental) Sleepycat License.
     *
     * @see https://opensource.org/licenses/Sleepycat
     * @experimental
     * @osiApproved true
     */
    static readonly SLEEPYCAT: SpdxLicense;
    /**
     * (experimental) Spencer License 86.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License
     * @experimental
     */
    static readonly SPENCER_86: SpdxLicense;
    /**
     * (experimental) Spencer License 94.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License
     * @experimental
     */
    static readonly SPENCER_94: SpdxLicense;
    /**
     * (experimental) Spencer License 99.
     *
     * @see http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c
     * @experimental
     */
    static readonly SPENCER_99: SpdxLicense;
    /**
     * (experimental) Standard ML of New Jersey License.
     *
     * @see http://www.smlnj.org//license.html
     * @experimental
     */
    static readonly STANDARDML_NJ: SpdxLicense;
    /**
     * (experimental) SugarCRM Public License v1.1.3.
     *
     * @see http://www.sugarcrm.com/crm/SPL
     * @experimental
     */
    static readonly SUGARCRM_1_1_3: SpdxLicense;
    /**
     * (experimental) TAPR Open Hardware License v1.0.
     *
     * @see https://www.tapr.org/OHL
     * @experimental
     */
    static readonly TAPR_OHL_1_0: SpdxLicense;
    /**
     * (experimental) TCL/TK License.
     *
     * @see http://www.tcl.tk/software/tcltk/license.html
     * @experimental
     */
    static readonly TCL: SpdxLicense;
    /**
     * (experimental) TCP Wrappers License.
     *
     * @see http://rc.quest.com/topics/openssh/license.php#tcpwrappers
     * @experimental
     */
    static readonly TCP_WRAPPERS: SpdxLicense;
    /**
     * (experimental) TMate Open Source License.
     *
     * @see http://svnkit.com/license.html
     * @experimental
     */
    static readonly TMATE: SpdxLicense;
    /**
     * (experimental) TORQUE v2.5+ Software License v1.1.
     *
     * @see https://fedoraproject.org/wiki/Licensing/TORQUEv1.1
     * @experimental
     */
    static readonly TORQUE_1_1: SpdxLicense;
    /**
     * (experimental) Trusster Open Source License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/TOSL
     * @experimental
     */
    static readonly TOSL: SpdxLicense;
    /**
     * (experimental) Technische Universitaet Berlin License 1.0.
     *
     * @see https://github.com/swh/ladspa/blob/7bf6f3799fdba70fda297c2d8fd9f526803d9680/gsm/COPYRIGHT
     * @experimental
     */
    static readonly TU_BERLIN_1_0: SpdxLicense;
    /**
     * (experimental) Technische Universitaet Berlin License 2.0.
     *
     * @see https://github.com/CorsixTH/deps/blob/fd339a9f526d1d9c9f01ccf39e438a015da50035/licences/libgsm.txt
     * @experimental
     */
    static readonly TU_BERLIN_2_0: SpdxLicense;
    /**
     * (experimental) Upstream Compatibility License v1.0.
     *
     * @see https://opensource.org/licenses/UCL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly UCL_1_0: SpdxLicense;
    /**
     * (experimental) Universal Permissive License v1.0.
     *
     * @see https://opensource.org/licenses/UPL
     * @experimental
     * @osiApproved true
     */
    static readonly UPL_1_0: SpdxLicense;
    /**
     * (experimental) Unicode License Agreement - Data Files and Software (2015).
     *
     * @see https://web.archive.org/web/20151224134844/http://unicode.org/copyright.html
     * @experimental
     */
    static readonly UNICODE_DFS_2015: SpdxLicense;
    /**
     * (experimental) Unicode License Agreement - Data Files and Software (2016).
     *
     * @see http://www.unicode.org/copyright.html
     * @experimental
     * @osiApproved true
     */
    static readonly UNICODE_DFS_2016: SpdxLicense;
    /**
     * (experimental) Unicode Terms of Use.
     *
     * @see http://www.unicode.org/copyright.html
     * @experimental
     */
    static readonly UNICODE_TOU: SpdxLicense;
    /**
     * (experimental) The Unlicense.
     *
     * @see https://unlicense.org/
     * @experimental
     * @osiApproved true
     */
    static readonly UNLICENSE: SpdxLicense;
    /**
     * (experimental) VOSTROM Public License for Open Source.
     *
     * @see https://fedoraproject.org/wiki/Licensing/VOSTROM
     * @experimental
     */
    static readonly VOSTROM: SpdxLicense;
    /**
     * (experimental) Vovida Software License v1.0.
     *
     * @see https://opensource.org/licenses/VSL-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly VSL_1_0: SpdxLicense;
    /**
     * (experimental) Vim License.
     *
     * @see http://vimdoc.sourceforge.net/htmldoc/uganda.html
     * @experimental
     */
    static readonly VIM: SpdxLicense;
    /**
     * (experimental) W3C Software Notice and License (2002-12-31).
     *
     * @see http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html
     * @experimental
     * @osiApproved true
     */
    static readonly W3_C: SpdxLicense;
    /**
     * (experimental) W3C Software Notice and License (1998-07-20).
     *
     * @see http://www.w3.org/Consortium/Legal/copyright-software-19980720.html
     * @experimental
     */
    static readonly W3C_19980720: SpdxLicense;
    /**
     * (experimental) W3C Software Notice and Document License (2015-05-13).
     *
     * @see https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document
     * @experimental
     */
    static readonly W3C_20150513: SpdxLicense;
    /**
     * (experimental) Do What The F*ck You Want To Public License.
     *
     * @see http://www.wtfpl.net/about/
     * @experimental
     */
    static readonly WTFPL: SpdxLicense;
    /**
     * (experimental) Sybase Open Watcom Public License 1.0.
     *
     * @see https://opensource.org/licenses/Watcom-1.0
     * @experimental
     * @osiApproved true
     */
    static readonly WATCOM_1_0: SpdxLicense;
    /**
     * (experimental) Wsuipa License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Wsuipa
     * @experimental
     */
    static readonly WSUIPA: SpdxLicense;
    /**
     * (experimental) X11 License.
     *
     * @see http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3
     * @experimental
     */
    static readonly X11: SpdxLicense;
    /**
     * (experimental) XFree86 License 1.1.
     *
     * @see http://www.xfree86.org/current/LICENSE4.html
     * @experimental
     */
    static readonly XFREE86_1_1: SpdxLicense;
    /**
     * (experimental) XSkat License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/XSkat_License
     * @experimental
     */
    static readonly XSKAT: SpdxLicense;
    /**
     * (experimental) Xerox License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Xerox
     * @experimental
     */
    static readonly XEROX: SpdxLicense;
    /**
     * (experimental) X.Net License.
     *
     * @see https://opensource.org/licenses/Xnet
     * @experimental
     * @osiApproved true
     */
    static readonly XNET: SpdxLicense;
    /**
     * (experimental) Yahoo!
     *
     * Public License v1.0
     *
     * @see http://www.zimbra.com/license/yahoo_public_license_1.0.html
     * @experimental
     */
    static readonly YPL_1_0: SpdxLicense;
    /**
     * (experimental) Yahoo!
     *
     * Public License v1.1
     *
     * @see http://www.zimbra.com/license/yahoo_public_license_1.1.html
     * @experimental
     */
    static readonly YPL_1_1: SpdxLicense;
    /**
     * (experimental) Zope Public License 1.1.
     *
     * @see http://old.zope.org/Resources/License/ZPL-1.1
     * @experimental
     */
    static readonly ZPL_1_1: SpdxLicense;
    /**
     * (experimental) Zope Public License 2.0.
     *
     * @see http://old.zope.org/Resources/License/ZPL-2.0
     * @experimental
     * @osiApproved true
     */
    static readonly ZPL_2_0: SpdxLicense;
    /**
     * (experimental) Zope Public License 2.1.
     *
     * @see http://old.zope.org/Resources/ZPL/
     * @experimental
     */
    static readonly ZPL_2_1: SpdxLicense;
    /**
     * (experimental) Zed License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Zed
     * @experimental
     */
    static readonly ZED: SpdxLicense;
    /**
     * (experimental) Zend License v2.0.
     *
     * @see https://web.archive.org/web/20130517195954/http://www.zend.com/license/2_00.txt
     * @experimental
     */
    static readonly ZEND_2_0: SpdxLicense;
    /**
     * (experimental) Zimbra Public License v1.3.
     *
     * @see http://web.archive.org/web/20100302225219/http://www.zimbra.com/license/zimbra-public-license-1-3.html
     * @experimental
     */
    static readonly ZIMBRA_1_3: SpdxLicense;
    /**
     * (experimental) Zimbra Public License v1.4.
     *
     * @see http://www.zimbra.com/legal/zimbra-public-license-1-4
     * @experimental
     */
    static readonly ZIMBRA_1_4: SpdxLicense;
    /**
     * (experimental) zlib License.
     *
     * @see http://www.zlib.net/zlib_license.html
     * @experimental
     * @osiApproved true
     */
    static readonly ZLIB: SpdxLicense;
    /**
     * (experimental) SQLite Blessing.
     *
     * @see https://www.sqlite.org/src/artifact/e33a4df7e32d742a?ln=4-9
     * @experimental
     */
    static readonly BLESSING: SpdxLicense;
    /**
     * (experimental) bzip2 and libbzip2 License v1.0.5.
     *
     * @see https://sourceware.org/bzip2/1.0.5/bzip2-manual-1.0.5.html
     * @experimental
     */
    static readonly BZIP2_1_0_5: SpdxLicense;
    /**
     * (experimental) bzip2 and libbzip2 License v1.0.6.
     *
     * @see https://sourceware.org/git/?p=bzip2.git;a=blob;f=LICENSE;hb=bzip2-1.0.6
     * @experimental
     */
    static readonly BZIP2_1_0_6: SpdxLicense;
    /**
     * (experimental) copyleft-next 0.3.0.
     *
     * @see https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.0
     * @experimental
     */
    static readonly COPYLEFT_NEXT_0_3_0: SpdxLicense;
    /**
     * (experimental) copyleft-next 0.3.1.
     *
     * @see https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.1
     * @experimental
     */
    static readonly COPYLEFT_NEXT_0_3_1: SpdxLicense;
    /**
     * (experimental) curl License.
     *
     * @see https://github.com/bagder/curl/blob/master/COPYING
     * @experimental
     */
    static readonly CURL: SpdxLicense;
    /**
     * (experimental) diffmark license.
     *
     * @see https://fedoraproject.org/wiki/Licensing/diffmark
     * @experimental
     */
    static readonly DIFFMARK: SpdxLicense;
    /**
     * (experimental) dvipdfm License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/dvipdfm
     * @experimental
     */
    static readonly DVIPDFM: SpdxLicense;
    /**
     * (experimental) eCos license version 2.0.
     *
     * @see https://www.gnu.org/licenses/ecos-license.html
     * @experimental
     */
    static readonly ECOS_2_0: SpdxLicense;
    /**
     * (experimental) eGenix.com Public License 1.1.0.
     *
     * @see http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf
     * @experimental
     */
    static readonly E_GENIX: SpdxLicense;
    /**
     * (experimental) Etalab Open License 2.0.
     *
     * @see https://github.com/DISIC/politique-de-contribution-open-source/blob/master/LICENSE.pdf
     * @experimental
     */
    static readonly ETALAB_2_0: SpdxLicense;
    /**
     * (experimental) gSOAP Public License v1.3b.
     *
     * @see http://www.cs.fsu.edu/~engelen/license.html
     * @experimental
     */
    static readonly GSOAP_1_3B: SpdxLicense;
    /**
     * (experimental) gnuplot License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Gnuplot
     * @experimental
     */
    static readonly GNUPLOT: SpdxLicense;
    /**
     * (experimental) iMatix Standard Function Library Agreement.
     *
     * @see http://legacy.imatix.com/html/sfl/sfl4.htm#license
     * @experimental
     */
    static readonly I_MATIX: SpdxLicense;
    /**
     * (experimental) PNG Reference Library version 2.
     *
     * @see http://www.libpng.org/pub/png/src/libpng-LICENSE.txt
     * @experimental
     */
    static readonly LIBPNG_2_0: SpdxLicense;
    /**
     * (experimental) libselinux public domain notice.
     *
     * @see https://github.com/SELinuxProject/selinux/blob/master/libselinux/LICENSE
     * @experimental
     */
    static readonly LIBSELINUX_1_0: SpdxLicense;
    /**
     * (experimental) libtiff License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/libtiff
     * @experimental
     */
    static readonly LIBTIFF: SpdxLicense;
    /**
     * (experimental) mpich2 License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/MIT
     * @experimental
     */
    static readonly MPICH2: SpdxLicense;
    /**
     * (experimental) psfrag License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/psfrag
     * @experimental
     */
    static readonly PSFRAG: SpdxLicense;
    /**
     * (experimental) psutils License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/psutils
     * @experimental
     */
    static readonly PSUTILS: SpdxLicense;
    /**
     * (experimental) wxWindows Library License.
     *
     * @see https://opensource.org/licenses/WXwindows
     * @experimental
     */
    static readonly WX_WINDOWS: SpdxLicense;
    /**
     * (experimental) xinetd License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/Xinetd_License
     * @experimental
     */
    static readonly XINETD: SpdxLicense;
    /**
     * (experimental) XPP License.
     *
     * @see https://fedoraproject.org/wiki/Licensing/xpp
     * @experimental
     */
    static readonly XPP: SpdxLicense;
    /**
     * (experimental) zlib/libpng License with Acknowledgement.
     *
     * @see https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement
     * @experimental
     */
    static readonly ZLIB_ACKNOWLEDGEMENT: SpdxLicense;
    /**
     * (experimental) Packages that have not been licensed.
     *
     * @experimental
     */
    static readonly UNLICENSED: SpdxLicense;
    /**
     * (experimental) All valid SPDX Licenses.
     *
     * @experimental
     */
    static all(): SpdxLicense[];
    /**
     * (experimental) All OSI-Approved SPDX Licenses.
     *
     * @experimental
     */
    static osiApproved(): SpdxLicense[];
    /**
     * (experimental) The Apache family of licenses.
     *
     * @experimental
     */
    static apache(): SpdxLicense[];
    /**
     * (experimental) The BSD family of licenses.
     *
     * @experimental
     */
    static bsd(): SpdxLicense[];
    /**
     * (experimental) The CDDL family of licenses.
     *
     * @experimental
     */
    static cddl(): SpdxLicense[];
    /**
     * (experimental) The EPL family of licenses.
     *
     * @experimental
     */
    static epl(): SpdxLicense[];
    /**
     * (experimental) The MIT family of licenses.
     *
     * @experimental
     */
    static mit(): SpdxLicense[];
    /**
     * (experimental) The MPL family of licenses.
     *
     * @experimental
     */
    static mpl(): SpdxLicense[];
    private constructor();
}
