"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDenyListMap = void 0;
/**
 * Creates a map from a set of deny list rules and performs some verificatins.
 */
function createDenyListMap(rules) {
    const map = {};
    for (const entry of rules) {
        const versionSuffix = entry.version ? `/v${entry.version}` : '';
        const key = `${entry.packageName}${versionSuffix}`;
        if (key in map) {
            throw new Error(`Duplicate deny list entry: ${key}`);
        }
        map[key] = entry;
    }
    // iterate over all rules that match all versions and check that there
    // are no version-specific rules that are considered duplicates.
    for (const rule of rules.filter(x => !x.version)) {
        // if there are any keys in `map` that match this package name (with a version), report them as duplicates.
        const matches = Object.keys(map).filter(key => key.startsWith(rule.packageName + '/'));
        if (matches.length > 0) {
            throw new Error(`Found rules that match specific versions of "${rule.packageName}" (${matches.map(m => m.split('/v')[1]).join(',')}) but there is also a rule that matches all versions`);
        }
    }
    return map;
}
exports.createDenyListMap = createDenyListMap;
//# sourceMappingURL=data:application/json;base64,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