var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toESM = (module2, isNodeMode) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", !isNodeMode && module2 && module2.__esModule ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};
var __toCommonJS = /* @__PURE__ */ ((cache) => {
  return (module2, temp) => {
    return cache && cache.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache && cache.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);

// node_modules/aws-embedded-metrics/lib/Constants.js
var require_Constants = __commonJS({
  "node_modules/aws-embedded-metrics/lib/Constants.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Constants;
    (function(Constants2) {
      Constants2[Constants2["MAX_DIMENSIONS"] = 9] = "MAX_DIMENSIONS";
      Constants2["DEFAULT_NAMESPACE"] = "aws-embedded-metrics";
      Constants2[Constants2["MAX_METRICS_PER_EVENT"] = 100] = "MAX_METRICS_PER_EVENT";
      Constants2["DEFAULT_AGENT_HOST"] = "0.0.0.0";
      Constants2[Constants2["DEFAULT_AGENT_PORT"] = 25888] = "DEFAULT_AGENT_PORT";
    })(Constants = exports.Constants || (exports.Constants = {}));
  }
});

// node_modules/aws-embedded-metrics/lib/environment/Environments.js
var require_Environments = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/Environments.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Environments;
    (function(Environments2) {
      Environments2["Local"] = "Local";
      Environments2["Lambda"] = "Lambda";
      Environments2["Agent"] = "Agent";
      Environments2["EC2"] = "EC2";
      Environments2["ECS"] = "ECS";
      Environments2["Unknown"] = "";
    })(Environments || (Environments = {}));
    exports.default = Environments;
  }
});

// node_modules/aws-embedded-metrics/lib/config/EnvironmentConfigurationProvider.js
var require_EnvironmentConfigurationProvider = __commonJS({
  "node_modules/aws-embedded-metrics/lib/config/EnvironmentConfigurationProvider.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Constants_1 = require_Constants();
    var Environments_1 = require_Environments();
    var ENV_VAR_PREFIX = "AWS_EMF";
    var ConfigKeys;
    (function(ConfigKeys2) {
      ConfigKeys2["LOG_GROUP_NAME"] = "LOG_GROUP_NAME";
      ConfigKeys2["LOG_STREAM_NAME"] = "LOG_STREAM_NAME";
      ConfigKeys2["ENABLE_DEBUG_LOGGING"] = "ENABLE_DEBUG_LOGGING";
      ConfigKeys2["SERVICE_NAME"] = "SERVICE_NAME";
      ConfigKeys2["SERVICE_TYPE"] = "SERVICE_TYPE";
      ConfigKeys2["AGENT_ENDPOINT"] = "AGENT_ENDPOINT";
      ConfigKeys2["ENVIRONMENT_OVERRIDE"] = "ENVIRONMENT";
      ConfigKeys2["NAMESPACE"] = "NAMESPACE";
    })(ConfigKeys || (ConfigKeys = {}));
    var EnvironmentConfigurationProvider = class {
      getConfiguration() {
        return {
          agentEndpoint: this.getEnvVariable(ConfigKeys.AGENT_ENDPOINT),
          debuggingLoggingEnabled: this.tryGetEnvVariableAsBoolean(ConfigKeys.ENABLE_DEBUG_LOGGING, false),
          logGroupName: this.getEnvVariable(ConfigKeys.LOG_GROUP_NAME),
          logStreamName: this.getEnvVariable(ConfigKeys.LOG_STREAM_NAME),
          serviceName: this.getEnvVariable(ConfigKeys.SERVICE_NAME) || this.getEnvVariableWithoutPrefix(ConfigKeys.SERVICE_NAME),
          serviceType: this.getEnvVariable(ConfigKeys.SERVICE_TYPE) || this.getEnvVariableWithoutPrefix(ConfigKeys.SERVICE_TYPE),
          environmentOverride: this.getEnvironmentOverride(),
          namespace: this.getEnvVariable(ConfigKeys.NAMESPACE) || Constants_1.Constants.DEFAULT_NAMESPACE
        };
      }
      getEnvVariableWithoutPrefix(configKey) {
        return process.env[configKey];
      }
      getEnvVariable(configKey) {
        return process.env[`${ENV_VAR_PREFIX}_${configKey}`];
      }
      tryGetEnvVariableAsBoolean(configKey, fallback) {
        const configValue = this.getEnvVariable(configKey);
        return !configValue ? fallback : configValue.toLowerCase() === "true";
      }
      getEnvironmentOverride() {
        const overrideValue = this.getEnvVariable(ConfigKeys.ENVIRONMENT_OVERRIDE);
        const environment = Environments_1.default[overrideValue];
        if (environment === void 0) {
          return Environments_1.default.Unknown;
        }
        return environment;
      }
    };
    exports.EnvironmentConfigurationProvider = EnvironmentConfigurationProvider;
  }
});

// node_modules/aws-embedded-metrics/lib/config/Configuration.js
var require_Configuration = __commonJS({
  "node_modules/aws-embedded-metrics/lib/config/Configuration.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var EnvironmentConfigurationProvider_1 = require_EnvironmentConfigurationProvider();
    var Configuration2 = new EnvironmentConfigurationProvider_1.EnvironmentConfigurationProvider().getConfiguration();
    exports.default = Configuration2;
  }
});

// node_modules/aws-embedded-metrics/lib/utils/Logger.js
var require_Logger = __commonJS({
  "node_modules/aws-embedded-metrics/lib/utils/Logger.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var LOG = (...args) => {
      if (Configuration_1.default.debuggingLoggingEnabled) {
        console.log(...args);
      }
    };
    exports.LOG = LOG;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricValues.js
var require_MetricValues = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricValues.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MetricValues = class {
      constructor(value, unit) {
        this.values = [value];
        this.unit = unit || "None";
      }
      addValue(value) {
        this.values.push(value);
      }
    };
    exports.MetricValues = MetricValues;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricsContext.js
var require_MetricsContext = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricsContext.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var Logger_1 = require_Logger();
    var MetricValues_1 = require_MetricValues();
    var MetricsContext = class {
      constructor(namespace, properties, dimensions, defaultDimensions, shouldUseDefaultDimensions, timestamp) {
        this.metrics = /* @__PURE__ */ new Map();
        this.meta = {};
        this.shouldUseDefaultDimensions = true;
        this.namespace = namespace || Configuration_1.default.namespace;
        this.properties = properties || {};
        this.dimensions = dimensions || [];
        this.timestamp = timestamp;
        this.meta.Timestamp = MetricsContext.resolveMetaTimestamp(timestamp);
        this.defaultDimensions = defaultDimensions || {};
        if (shouldUseDefaultDimensions != void 0) {
          this.shouldUseDefaultDimensions = shouldUseDefaultDimensions;
        }
      }
      static empty() {
        return new MetricsContext();
      }
      static resolveMetaTimestamp(timestamp) {
        if (timestamp instanceof Date) {
          return timestamp.getTime();
        } else if (timestamp) {
          return timestamp;
        } else {
          return Date.now();
        }
      }
      setNamespace(value) {
        this.namespace = value;
      }
      setProperty(key, value) {
        this.properties[key] = value;
      }
      setTimestamp(timestamp) {
        this.timestamp = timestamp;
        this.meta.Timestamp = MetricsContext.resolveMetaTimestamp(timestamp);
      }
      setDefaultDimensions(dimensions) {
        Logger_1.LOG(`Received default dimensions`, dimensions);
        this.defaultDimensions = dimensions;
      }
      putDimensions(incomingDimensionSet) {
        if (this.dimensions.length === 0) {
          this.dimensions.push(incomingDimensionSet);
          return;
        }
        for (let i = 0; i < this.dimensions.length; i++) {
          const existingDimensionSet = this.dimensions[i];
          const existingDimensionSetKeys = Object.keys(existingDimensionSet);
          const incomingDimensionSetKeys = Object.keys(incomingDimensionSet);
          if (existingDimensionSetKeys.length !== incomingDimensionSetKeys.length) {
            this.dimensions.push(incomingDimensionSet);
            return;
          }
          for (let j = 0; j < existingDimensionSetKeys.length; j++) {
            if (!incomingDimensionSetKeys.includes(existingDimensionSetKeys[j])) {
              this.dimensions.push(incomingDimensionSet);
              return;
            }
          }
        }
      }
      setDimensions(dimensionSets) {
        this.shouldUseDefaultDimensions = false;
        this.dimensions = dimensionSets;
      }
      getDimensions() {
        if (this.shouldUseDefaultDimensions === false) {
          return this.dimensions;
        }
        if (Object.keys(this.defaultDimensions).length === 0) {
          return this.dimensions;
        }
        if (this.dimensions.length === 0) {
          return [this.defaultDimensions];
        }
        return this.dimensions.map((custom) => {
          return Object.assign(Object.assign({}, this.defaultDimensions), custom);
        });
      }
      putMetric(key, value, unit) {
        const currentMetric = this.metrics.get(key);
        if (currentMetric) {
          currentMetric.addValue(value);
        } else {
          this.metrics.set(key, new MetricValues_1.MetricValues(value, unit));
        }
      }
      createCopyWithContext() {
        return new MetricsContext(this.namespace, Object.assign({}, this.properties), Object.assign([], this.dimensions), this.defaultDimensions, this.shouldUseDefaultDimensions, this.timestamp);
      }
    };
    exports.MetricsContext = MetricsContext;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricsLogger.js
var require_MetricsLogger = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricsLogger.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var MetricsContext_1 = require_MetricsContext();
    var MetricsLogger = class {
      constructor(resolveEnvironment, context) {
        this.configureContextForEnvironment = (context2, environment) => {
          const defaultDimensions = {
            LogGroup: environment.getLogGroupName(),
            ServiceName: Configuration_1.default.serviceName || environment.getName(),
            ServiceType: Configuration_1.default.serviceType || environment.getType()
          };
          context2.setDefaultDimensions(defaultDimensions);
          environment.configureContext(context2);
        };
        this.resolveEnvironment = resolveEnvironment;
        this.context = context || MetricsContext_1.MetricsContext.empty();
      }
      flush() {
        return __awaiter(this, void 0, void 0, function* () {
          const environment = yield this.resolveEnvironment();
          this.configureContextForEnvironment(this.context, environment);
          const sink = environment.getSink();
          yield sink.accept(this.context);
          this.context = this.context.createCopyWithContext();
        });
      }
      setProperty(key, value) {
        this.context.setProperty(key, value);
        return this;
      }
      putDimensions(dimensions) {
        this.context.putDimensions(dimensions);
        return this;
      }
      setDimensions(...dimensionSets) {
        this.context.setDimensions(dimensionSets);
        return this;
      }
      putMetric(key, value, unit) {
        this.context.putMetric(key, value, unit);
        return this;
      }
      setNamespace(value) {
        this.context.setNamespace(value);
        return this;
      }
      setTimestamp(timestamp) {
        this.context.setTimestamp(timestamp);
        return this;
      }
      new() {
        return new MetricsLogger(this.resolveEnvironment, this.context.createCopyWithContext());
      }
    };
    exports.MetricsLogger = MetricsLogger;
  }
});

// node_modules/aws-embedded-metrics/lib/serializers/LogSerializer.js
var require_LogSerializer = __commonJS({
  "node_modules/aws-embedded-metrics/lib/serializers/LogSerializer.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Constants_1 = require_Constants();
    var LogSerializer = class {
      serialize(context) {
        const dimensionKeys = [];
        let dimensionProperties = {};
        context.getDimensions().forEach((d) => {
          const keys = Object.keys(d).slice(0, Constants_1.Constants.MAX_DIMENSIONS);
          dimensionKeys.push(keys);
          dimensionProperties = Object.assign(Object.assign({}, dimensionProperties), d);
        });
        const createBody = () => {
          return Object.assign(Object.assign(Object.assign({}, dimensionProperties), context.properties), { _aws: Object.assign(Object.assign({}, context.meta), { CloudWatchMetrics: [
            {
              Dimensions: dimensionKeys,
              Metrics: [],
              Namespace: context.namespace
            }
          ] }) });
        };
        const eventBatches = [];
        let currentBody = createBody();
        const currentMetricsInBody = () => currentBody._aws.CloudWatchMetrics[0].Metrics.length;
        const shouldSerialize = () => currentMetricsInBody() === Constants_1.Constants.MAX_METRICS_PER_EVENT;
        const serializeCurrentBody = () => {
          eventBatches.push(JSON.stringify(currentBody));
          currentBody = createBody();
        };
        for (const [key, metric] of context.metrics) {
          const metricValue = metric.values.length === 1 ? metric.values[0] : metric.values;
          currentBody[key] = metricValue;
          currentBody._aws.CloudWatchMetrics[0].Metrics.push({ Name: key, Unit: metric.unit });
          if (shouldSerialize()) {
            serializeCurrentBody();
          }
        }
        if (eventBatches.length === 0 || currentMetricsInBody() > 0) {
          serializeCurrentBody();
        }
        return eventBatches;
      }
    };
    exports.LogSerializer = LogSerializer;
  }
});

// node_modules/aws-embedded-metrics/lib/sinks/ConsoleSink.js
var require_ConsoleSink = __commonJS({
  "node_modules/aws-embedded-metrics/lib/sinks/ConsoleSink.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var LogSerializer_1 = require_LogSerializer();
    var ConsoleSink = class {
      constructor(serializer) {
        this.name = "ConsoleSink";
        this.serializer = serializer || new LogSerializer_1.LogSerializer();
      }
      accept(context) {
        const events = this.serializer.serialize(context);
        events.forEach((event) => console.log(event));
        return Promise.resolve();
      }
    };
    exports.ConsoleSink = ConsoleSink;
  }
});

// node_modules/aws-embedded-metrics/lib/sinks/connections/TcpClient.js
var require_TcpClient = __commonJS({
  "node_modules/aws-embedded-metrics/lib/sinks/connections/TcpClient.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var net = require("net");
    var Logger_1 = require_Logger();
    var TcpClient = class {
      constructor(endpoint) {
        this.endpoint = endpoint;
        this.socket = new net.Socket({ allowHalfOpen: true, writable: false }).setEncoding("utf8").setKeepAlive(true).setTimeout(5e3).on("timeout", () => this.disconnect("idle timeout")).on("end", () => this.disconnect("end")).on("data", (data) => Logger_1.LOG("TcpClient received data.", data));
      }
      warmup() {
        return __awaiter(this, void 0, void 0, function* () {
          try {
            yield this.establishConnection();
          } catch (err) {
            Logger_1.LOG("Failed to connect", err);
          }
        });
      }
      sendMessage(message) {
        return __awaiter(this, void 0, void 0, function* () {
          yield this.waitForOpenConnection();
          yield new Promise((resolve, reject) => {
            const onSendError = (err) => {
              Logger_1.LOG("Failed to write", err);
              reject(err);
            };
            const wasFlushedToKernel = this.socket.write(message, (err) => {
              if (!err) {
                Logger_1.LOG("Write succeeded");
                resolve();
              } else {
                onSendError(err);
              }
            });
            if (!wasFlushedToKernel) {
              Logger_1.LOG("TcpClient data was not flushed to kernel buffer and was queued in memory.");
            }
          });
        });
      }
      disconnect(eventName) {
        Logger_1.LOG("TcpClient disconnected due to:", eventName);
        this.socket.removeAllListeners();
        this.socket.destroy();
        this.socket.unref();
      }
      waitForOpenConnection() {
        return __awaiter(this, void 0, void 0, function* () {
          if (!this.socket.writeable || this.socket.readyState !== "open") {
            yield this.establishConnection();
          }
        });
      }
      establishConnection() {
        return __awaiter(this, void 0, void 0, function* () {
          yield new Promise((resolve, reject) => {
            const onError = (e) => {
              if (e.message.includes("EISCONN")) {
                resolve();
                return;
              }
              Logger_1.LOG("TCP Client received error", e);
              this.disconnect(e.message);
              reject(e);
            };
            const onConnect = () => {
              this.socket.removeListener("error", onError);
              Logger_1.LOG("TcpClient connected.", this.endpoint);
              resolve();
            };
            switch (this.socket.readyState) {
              case "open":
                resolve();
                break;
              case "opening":
                this.socket.once("connect", onConnect);
                this.socket.once("error", onError);
                break;
              default:
                Logger_1.LOG("opening connection with socket in state: ", this.socket.readyState);
                this.socket.connect(this.endpoint.port, this.endpoint.host, onConnect).once("error", onError);
                break;
            }
          });
        });
      }
    };
    exports.TcpClient = TcpClient;
  }
});

// node_modules/aws-embedded-metrics/lib/sinks/connections/UdpClient.js
var require_UdpClient = __commonJS({
  "node_modules/aws-embedded-metrics/lib/sinks/connections/UdpClient.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var dgram = require("dgram");
    var Logger_1 = require_Logger();
    var UdpClient = class {
      constructor(endpoint) {
        this.endpoint = endpoint;
      }
      warmup() {
        return Promise.resolve();
      }
      sendMessage(message) {
        return __awaiter(this, void 0, void 0, function* () {
          const client = dgram.createSocket("udp4");
          client.send(message, this.endpoint.port, this.endpoint.host, (error) => {
            if (error) {
              Logger_1.LOG(error);
            }
            client.close();
          });
          return Promise.resolve();
        });
      }
    };
    exports.UdpClient = UdpClient;
  }
});

// node_modules/aws-embedded-metrics/lib/sinks/AgentSink.js
var require_AgentSink = __commonJS({
  "node_modules/aws-embedded-metrics/lib/sinks/AgentSink.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var url = require("url");
    var Configuration_1 = require_Configuration();
    var LogSerializer_1 = require_LogSerializer();
    var Logger_1 = require_Logger();
    var TcpClient_1 = require_TcpClient();
    var UdpClient_1 = require_UdpClient();
    var TCP = "tcp:";
    var UDP = "udp:";
    var defaultTcpEndpoint = {
      host: "0.0.0.0",
      port: 25888,
      protocol: TCP
    };
    var parseEndpoint = (endpoint) => {
      try {
        if (!endpoint) {
          return defaultTcpEndpoint;
        }
        const parsedUrl = url.parse(endpoint);
        if (!parsedUrl.hostname || !parsedUrl.port || !parsedUrl.protocol) {
          Logger_1.LOG(`Failed to parse the provided agent endpoint. Falling back to the default TCP endpoint.`, parsedUrl);
          return defaultTcpEndpoint;
        }
        if (parsedUrl.protocol !== TCP && parsedUrl.protocol !== UDP) {
          Logger_1.LOG(`The provided agent endpoint protocol '${parsedUrl.protocol}' is not supported. Please use TCP or UDP. Falling back to the default TCP endpoint.`, parsedUrl);
          return defaultTcpEndpoint;
        }
        return {
          host: parsedUrl.hostname,
          port: Number(parsedUrl.port),
          protocol: parsedUrl.protocol
        };
      } catch (e) {
        Logger_1.LOG("Failed to parse the provided agent endpoint", e);
        return defaultTcpEndpoint;
      }
    };
    var AgentSink = class {
      constructor(logGroupName, logStreamName, serializer) {
        this.name = "AgentSink";
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.serializer = serializer || new LogSerializer_1.LogSerializer();
        this.endpoint = parseEndpoint(Configuration_1.default.agentEndpoint);
        this.socketClient = this.getSocketClient(this.endpoint);
        Logger_1.LOG("Using socket client", this.socketClient.constructor.name);
      }
      accept(context) {
        return __awaiter(this, void 0, void 0, function* () {
          if (this.logGroupName) {
            context.meta.LogGroupName = this.logGroupName;
          }
          if (this.logStreamName) {
            context.meta.LogStreamName = this.logStreamName;
          }
          const events = this.serializer.serialize(context);
          Logger_1.LOG(`Sending {} events to socket.`, events.length);
          for (let index = 0; index < events.length; index++) {
            const event = events[index];
            const message = event + "\n";
            const bytes = Buffer.from(message);
            yield this.socketClient.sendMessage(bytes);
          }
        });
      }
      getSocketClient(endpoint) {
        Logger_1.LOG("Getting socket client for connection.", endpoint);
        const client = endpoint.protocol === TCP ? new TcpClient_1.TcpClient(endpoint) : new UdpClient_1.UdpClient(endpoint);
        client.warmup();
        return client;
      }
    };
    exports.AgentSink = AgentSink;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/DefaultEnvironment.js
var require_DefaultEnvironment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/DefaultEnvironment.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var AgentSink_1 = require_AgentSink();
    var Logger_1 = require_Logger();
    var DefaultEnvironment = class {
      probe() {
        return Promise.resolve(true);
      }
      getName() {
        if (!Configuration_1.default.serviceName) {
          Logger_1.LOG("Unknown ServiceName.");
          return "Unknown";
        }
        return Configuration_1.default.serviceName;
      }
      getType() {
        if (!Configuration_1.default.serviceType) {
          Logger_1.LOG("Unknown ServiceType.");
          return "Unknown";
        }
        return Configuration_1.default.serviceType;
      }
      getLogGroupName() {
        if (Configuration_1.default.logGroupName === "") {
          return "";
        }
        return Configuration_1.default.logGroupName ? Configuration_1.default.logGroupName : `${this.getName()}-metrics`;
      }
      configureContext() {
      }
      getSink() {
        if (!this.sink) {
          this.sink = new AgentSink_1.AgentSink(this.getLogGroupName(), Configuration_1.default.logStreamName);
        }
        return this.sink;
      }
    };
    exports.DefaultEnvironment = DefaultEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/utils/Fetch.js
var require_Fetch = __commonJS({
  "node_modules/aws-embedded-metrics/lib/utils/Fetch.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var http = require("http");
    var SOCKET_TIMEOUT = 1e3;
    var fetch = (url) => {
      return new Promise((resolve, reject) => {
        const request = http.get(url, { timeout: 2e3 }, (response) => {
          if (!response.statusCode) {
            reject(`Received undefined response status code from '${url}'`);
            return;
          }
          if (response.statusCode < 200 || response.statusCode > 299) {
            reject(new Error("Failed to load page, status code: " + response.statusCode));
            return;
          }
          const body = [];
          let bodyBytes = 0;
          response.on("data", (chunk) => {
            bodyBytes += chunk.length;
            body.push(chunk);
          });
          response.on("end", () => {
            let responseString;
            try {
              const buffer = Buffer.concat(body, bodyBytes);
              responseString = buffer.toString();
              const parsedJson = JSON.parse(responseString);
              resolve(parsedJson);
            } catch (e) {
              reject(`Failed to parse response from '${url}' as JSON. Received: ${responseString}`);
            }
          });
        }).on("error", (err) => {
          reject(err);
        });
        request.on("socket", (socket) => {
          socket.on("timeout", () => {
            request.abort();
            reject(`Socket timeout while connecting to '${url}'`);
          });
          socket.setTimeout(SOCKET_TIMEOUT);
        });
      });
    };
    exports.fetch = fetch;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/ECSEnvironment.js
var require_ECSEnvironment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/ECSEnvironment.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var AgentSink_1 = require_AgentSink();
    var Fetch_1 = require_Fetch();
    var Logger_1 = require_Logger();
    var os = require("os");
    var Constants_1 = require_Constants();
    var formatImageName = (imageName) => {
      if (imageName) {
        const splitImageName = imageName.split("/");
        return splitImageName[splitImageName.length - 1];
      }
      return imageName;
    };
    var ECSEnvironment = class {
      probe() {
        return __awaiter(this, void 0, void 0, function* () {
          if (!process.env.ECS_CONTAINER_METADATA_URI) {
            return Promise.resolve(false);
          }
          if (process.env.FLUENT_HOST && !Configuration_1.default.agentEndpoint) {
            this.fluentBitEndpoint = `tcp://${process.env.FLUENT_HOST}:${Constants_1.Constants.DEFAULT_AGENT_PORT}`;
            Configuration_1.default.agentEndpoint = this.fluentBitEndpoint;
            Logger_1.LOG(`Using FluentBit configuration. Endpoint: ${this.fluentBitEndpoint}`);
          }
          try {
            this.metadata = yield Fetch_1.fetch(process.env.ECS_CONTAINER_METADATA_URI);
            if (this.metadata) {
              this.metadata.FormattedImageName = formatImageName(this.metadata.Image);
              Logger_1.LOG(`Successfully collected ECS Container metadata.`);
            }
          } catch (e) {
            Logger_1.LOG("Failed to collect ECS Container Metadata.");
            Logger_1.LOG(e);
          }
          return true;
        });
      }
      getName() {
        var _a;
        if (Configuration_1.default.serviceName) {
          return Configuration_1.default.serviceName;
        }
        return ((_a = this.metadata) === null || _a === void 0 ? void 0 : _a.FormattedImageName) ? this.metadata.FormattedImageName : "Unknown";
      }
      getType() {
        return "AWS::ECS::Container";
      }
      getLogGroupName() {
        if (this.fluentBitEndpoint) {
          return "";
        }
        return Configuration_1.default.logGroupName || this.getName();
      }
      configureContext(context) {
        var _a, _b, _c, _d, _e;
        this.addProperty(context, "containerId", os.hostname());
        this.addProperty(context, "createdAt", (_a = this.metadata) === null || _a === void 0 ? void 0 : _a.CreatedAt);
        this.addProperty(context, "startedAt", (_b = this.metadata) === null || _b === void 0 ? void 0 : _b.StartedAt);
        this.addProperty(context, "image", (_c = this.metadata) === null || _c === void 0 ? void 0 : _c.Image);
        this.addProperty(context, "cluster", (_d = this.metadata) === null || _d === void 0 ? void 0 : _d.Labels["com.amazonaws.ecs.cluster"]);
        this.addProperty(context, "taskArn", (_e = this.metadata) === null || _e === void 0 ? void 0 : _e.Labels["com.amazonaws.ecs.task-arn"]);
        if (this.fluentBitEndpoint) {
          context.setDefaultDimensions({
            ServiceName: Configuration_1.default.serviceName || this.getName(),
            ServiceType: Configuration_1.default.serviceType || this.getType()
          });
        }
      }
      getSink() {
        if (!this.sink) {
          const logGroupName = this.fluentBitEndpoint ? "" : this.getLogGroupName();
          this.sink = new AgentSink_1.AgentSink(logGroupName);
        }
        return this.sink;
      }
      addProperty(context, key, value) {
        if (value) {
          context.setProperty(key, value);
        }
      }
    };
    exports.ECSEnvironment = ECSEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/EC2Environment.js
var require_EC2Environment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/EC2Environment.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var AgentSink_1 = require_AgentSink();
    var Fetch_1 = require_Fetch();
    var Logger_1 = require_Logger();
    var endpoint = "http://169.254.169.254/latest/dynamic/instance-identity/document";
    var EC2Environment = class {
      probe() {
        return __awaiter(this, void 0, void 0, function* () {
          try {
            this.metadata = yield Fetch_1.fetch(endpoint);
            if (this.metadata) {
              return true;
            }
            return false;
          } catch (e) {
            Logger_1.LOG(e);
            return false;
          }
        });
      }
      getName() {
        if (!Configuration_1.default.serviceName) {
          Logger_1.LOG("Unknown ServiceName.");
          return "Unknown";
        }
        return Configuration_1.default.serviceName;
      }
      getType() {
        if (this.metadata) {
          return "AWS::EC2::Instance";
        }
        return "Unknown";
      }
      getLogGroupName() {
        return Configuration_1.default.logGroupName ? Configuration_1.default.logGroupName : `${this.getName()}-metrics`;
      }
      configureContext(context) {
        if (this.metadata) {
          context.setProperty("imageId", this.metadata.imageId);
          context.setProperty("instanceId", this.metadata.instanceId);
          context.setProperty("instanceType", this.metadata.instanceType);
          context.setProperty("privateIP", this.metadata.privateIp);
          context.setProperty("availabilityZone", this.metadata.availabilityZone);
        }
      }
      getSink() {
        if (!this.sink) {
          this.sink = new AgentSink_1.AgentSink(this.getLogGroupName(), Configuration_1.default.logStreamName);
        }
        return this.sink;
      }
    };
    exports.EC2Environment = EC2Environment;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/LambdaEnvironment.js
var require_LambdaEnvironment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/LambdaEnvironment.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ConsoleSink_1 = require_ConsoleSink();
    var LambdaEnvironment = class {
      probe() {
        return Promise.resolve(process.env.AWS_LAMBDA_FUNCTION_NAME ? true : false);
      }
      getName() {
        return process.env.AWS_LAMBDA_FUNCTION_NAME || "Unknown";
      }
      getType() {
        return "AWS::Lambda::Function";
      }
      getLogGroupName() {
        return this.getName();
      }
      configureContext(context) {
        this.addProperty(context, "executionEnvironment", process.env.AWS_EXECUTION_ENV);
        this.addProperty(context, "memorySize", process.env.AWS_LAMBDA_FUNCTION_MEMORY_SIZE);
        this.addProperty(context, "functionVersion", process.env.AWS_LAMBDA_FUNCTION_VERSION);
        this.addProperty(context, "logStreamId", process.env.AWS_LAMBDA_LOG_STREAM_NAME);
        const trace = this.getSampledTrace();
        if (trace) {
          this.addProperty(context, "traceId", trace);
        }
      }
      getSink() {
        if (!this.sink) {
          this.sink = new ConsoleSink_1.ConsoleSink();
        }
        return this.sink;
      }
      addProperty(context, key, value) {
        if (value) {
          context.setProperty(key, value);
        }
      }
      getSampledTrace() {
        if (process.env._X_AMZN_TRACE_ID && process.env._X_AMZN_TRACE_ID.includes("Sampled=1")) {
          return process.env._X_AMZN_TRACE_ID;
        }
      }
    };
    exports.LambdaEnvironment = LambdaEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/LocalEnvironment.js
var require_LocalEnvironment = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/LocalEnvironment.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Configuration_1 = require_Configuration();
    var Logger_1 = require_Logger();
    var ConsoleSink_1 = require_ConsoleSink();
    var LocalEnvironment = class {
      probe() {
        return Promise.resolve(false);
      }
      getName() {
        if (!Configuration_1.default.serviceName) {
          Logger_1.LOG("Unknown ServiceName.");
          return "Unknown";
        }
        return Configuration_1.default.serviceName;
      }
      getType() {
        if (!Configuration_1.default.serviceType) {
          Logger_1.LOG("Unknown ServiceType.");
          return "Unknown";
        }
        return Configuration_1.default.serviceType;
      }
      getLogGroupName() {
        return Configuration_1.default.logGroupName ? Configuration_1.default.logGroupName : `${this.getName()}-metrics`;
      }
      configureContext() {
      }
      getSink() {
        if (!this.sink) {
          this.sink = new ConsoleSink_1.ConsoleSink();
        }
        return this.sink;
      }
    };
    exports.LocalEnvironment = LocalEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/environment/EnvironmentDetector.js
var require_EnvironmentDetector = __commonJS({
  "node_modules/aws-embedded-metrics/lib/environment/EnvironmentDetector.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Logger_1 = require_Logger();
    var DefaultEnvironment_1 = require_DefaultEnvironment();
    var ECSEnvironment_1 = require_ECSEnvironment();
    var EC2Environment_1 = require_EC2Environment();
    var LambdaEnvironment_1 = require_LambdaEnvironment();
    var Configuration_1 = require_Configuration();
    var Environments_1 = require_Environments();
    var LocalEnvironment_1 = require_LocalEnvironment();
    var lambdaEnvironment = new LambdaEnvironment_1.LambdaEnvironment();
    var ecsEnvironment = new ECSEnvironment_1.ECSEnvironment();
    var ec2Environment = new EC2Environment_1.EC2Environment();
    var defaultEnvironment = new DefaultEnvironment_1.DefaultEnvironment();
    var environments = [lambdaEnvironment, ecsEnvironment, ec2Environment];
    var environment = void 0;
    var getEnvironmentFromOverride = () => {
      switch (Configuration_1.default.environmentOverride) {
        case Environments_1.default.Agent:
          return defaultEnvironment;
        case Environments_1.default.EC2:
          return ec2Environment;
        case Environments_1.default.Lambda:
          return lambdaEnvironment;
        case Environments_1.default.ECS:
          return ecsEnvironment;
        case Environments_1.default.Local:
          return new LocalEnvironment_1.LocalEnvironment();
        case Environments_1.default.Unknown:
        default:
          return void 0;
      }
    };
    var discoverEnvironment = () => __awaiter(void 0, void 0, void 0, function* () {
      Logger_1.LOG(`Discovering environment`);
      for (const envUnderTest of environments) {
        Logger_1.LOG(`Testing: ${envUnderTest.constructor.name}`);
        try {
          if (yield envUnderTest.probe()) {
            return envUnderTest;
          }
        } catch (e) {
          Logger_1.LOG(`Failed probe: ${envUnderTest.constructor.name}`);
        }
      }
      return defaultEnvironment;
    });
    var _resolveEnvironment = () => __awaiter(void 0, void 0, void 0, function* () {
      Logger_1.LOG("Resolving environment");
      if (environment) {
        return environment;
      }
      if (Configuration_1.default.environmentOverride) {
        Logger_1.LOG("Environment override supplied", Configuration_1.default.environmentOverride);
        environment = getEnvironmentFromOverride();
        if (environment) {
          return environment;
        } else {
          Logger_1.LOG("Invalid environment provided. Falling back to auto-discovery.", Configuration_1.default.environmentOverride);
        }
      }
      environment = yield discoverEnvironment();
      return environment;
    });
    var environmentPromise = _resolveEnvironment();
    var resolveEnvironment = () => __awaiter(void 0, void 0, void 0, function* () {
      return environmentPromise;
    });
    exports.resolveEnvironment = resolveEnvironment;
    var cleanResolveEnvironment = () => __awaiter(void 0, void 0, void 0, function* () {
      yield environmentPromise;
      environment = void 0;
      return yield _resolveEnvironment();
    });
    exports.cleanResolveEnvironment = cleanResolveEnvironment;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricsLoggerFactory.js
var require_MetricsLoggerFactory = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricsLoggerFactory.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var __1 = require_lib();
    var EnvironmentDetector_1 = require_EnvironmentDetector();
    var MetricsContext_1 = require_MetricsContext();
    var createMetricsLogger = () => {
      const context = MetricsContext_1.MetricsContext.empty();
      const logger = new __1.MetricsLogger(EnvironmentDetector_1.resolveEnvironment, context);
      return logger;
    };
    exports.createMetricsLogger = createMetricsLogger;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/MetricScope.js
var require_MetricScope = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/MetricScope.js"(exports) {
    "use strict";
    var __awaiter = exports && exports.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var Logger_1 = require_Logger();
    var MetricsLoggerFactory_1 = require_MetricsLoggerFactory();
    var metricScope2 = (handler2) => {
      const wrappedHandler = (...args) => __awaiter(void 0, void 0, void 0, function* () {
        const metrics = MetricsLoggerFactory_1.createMetricsLogger();
        try {
          return yield handler2(metrics)(...args);
        } finally {
          try {
            yield metrics.flush();
          } catch (e) {
            Logger_1.LOG("Failed to flush metrics", e);
          }
        }
      });
      return wrappedHandler;
    };
    exports.metricScope = metricScope2;
  }
});

// node_modules/aws-embedded-metrics/lib/logger/Unit.js
var require_Unit = __commonJS({
  "node_modules/aws-embedded-metrics/lib/logger/Unit.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Unit2;
    (function(Unit3) {
      Unit3["Seconds"] = "Seconds";
      Unit3["Microseconds"] = "Microseconds";
      Unit3["Milliseconds"] = "Milliseconds";
      Unit3["Bytes"] = "Bytes";
      Unit3["Kilobytes"] = "Kilobytes";
      Unit3["Megabytes"] = "Megabytes";
      Unit3["Gigabytes"] = "Gigabytes";
      Unit3["Terabytes"] = "Terabytes";
      Unit3["Bits"] = "Bits";
      Unit3["Kilobits"] = "Kilobits";
      Unit3["Megabits"] = "Megabits";
      Unit3["Gigabits"] = "Gigabits";
      Unit3["Terabits"] = "Terabits";
      Unit3["Percent"] = "Percent";
      Unit3["Count"] = "Count";
      Unit3["BytesPerSecond"] = "Bytes/Second";
      Unit3["KilobytesPerSecond"] = "Kilobytes/Second";
      Unit3["MegabytesPerSecond"] = "Megabytes/Second";
      Unit3["GigabytesPerSecond"] = "Gigabytes/Second";
      Unit3["TerabytesPerSecond"] = "Terabytes/Second";
      Unit3["BitsPerSecond"] = "Bits/Second";
      Unit3["KilobitsPerSecond"] = "Kilobits/Second";
      Unit3["MegabitsPerSecond"] = "Megabits/Second";
      Unit3["GigabitsPerSecond"] = "Gigabits/Second";
      Unit3["TerabitsPerSecond"] = "Terabits/Second";
      Unit3["CountPerSecond"] = "Count/Second";
      Unit3["None"] = "None";
    })(Unit2 = exports.Unit || (exports.Unit = {}));
  }
});

// node_modules/aws-embedded-metrics/lib/index.js
var require_lib = __commonJS({
  "node_modules/aws-embedded-metrics/lib/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MetricsLogger_1 = require_MetricsLogger();
    exports.MetricsLogger = MetricsLogger_1.MetricsLogger;
    var ConsoleSink_1 = require_ConsoleSink();
    exports.LocalSink = ConsoleSink_1.ConsoleSink;
    var AgentSink_1 = require_AgentSink();
    exports.AgentSink = AgentSink_1.AgentSink;
    var MetricScope_1 = require_MetricScope();
    exports.metricScope = MetricScope_1.metricScope;
    var MetricsLoggerFactory_1 = require_MetricsLoggerFactory();
    exports.createMetricsLogger = MetricsLoggerFactory_1.createMetricsLogger;
    var Unit_1 = require_Unit();
    exports.Unit = Unit_1.Unit;
    var Configuration_1 = require_Configuration();
    exports.Configuration = Configuration_1.default;
  }
});

// node_modules/semver/internal/constants.js
var require_constants = __commonJS({
  "node_modules/semver/internal/constants.js"(exports, module2) {
    var SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    module2.exports = {
      SEMVER_SPEC_VERSION,
      MAX_LENGTH,
      MAX_SAFE_INTEGER,
      MAX_SAFE_COMPONENT_LENGTH
    };
  }
});

// node_modules/semver/internal/debug.js
var require_debug = __commonJS({
  "node_modules/semver/internal/debug.js"(exports, module2) {
    var debug = typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
    };
    module2.exports = debug;
  }
});

// node_modules/semver/internal/re.js
var require_re = __commonJS({
  "node_modules/semver/internal/re.js"(exports, module2) {
    var { MAX_SAFE_COMPONENT_LENGTH } = require_constants();
    var debug = require_debug();
    exports = module2.exports = {};
    var re = exports.re = [];
    var src = exports.src = [];
    var t = exports.t = {};
    var R = 0;
    var createToken = (name, value, isGlobal) => {
      const index = R++;
      debug(index, value);
      t[name] = index;
      src[index] = value;
      re[index] = new RegExp(value, isGlobal ? "g" : void 0);
    };
    createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
    createToken("NUMERICIDENTIFIERLOOSE", "[0-9]+");
    createToken("NONNUMERICIDENTIFIER", "\\d*[a-zA-Z-][a-zA-Z0-9-]*");
    createToken("MAINVERSION", `(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})`);
    createToken("MAINVERSIONLOOSE", `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASEIDENTIFIER", `(?:${src[t.NUMERICIDENTIFIER]}|${src[t.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t.NUMERICIDENTIFIERLOOSE]}|${src[t.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASE", `(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);
    createToken("PRERELEASELOOSE", `(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);
    createToken("BUILDIDENTIFIER", "[0-9A-Za-z-]+");
    createToken("BUILD", `(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);
    createToken("FULLPLAIN", `v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);
    createToken("FULL", `^${src[t.FULLPLAIN]}$`);
    createToken("LOOSEPLAIN", `[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);
    createToken("LOOSE", `^${src[t.LOOSEPLAIN]}$`);
    createToken("GTLT", "((?:<|>)?=?)");
    createToken("XRANGEIDENTIFIERLOOSE", `${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
    createToken("XRANGEIDENTIFIER", `${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);
    createToken("XRANGEPLAIN", `[v=\\s]*(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);
    createToken("XRANGELOOSE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COERCE", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:$|[^\\d])`);
    createToken("COERCERTL", src[t.COERCE], true);
    createToken("LONETILDE", "(?:~>?)");
    createToken("TILDETRIM", `(\\s*)${src[t.LONETILDE]}\\s+`, true);
    exports.tildeTrimReplace = "$1~";
    createToken("TILDE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);
    createToken("TILDELOOSE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("LONECARET", "(?:\\^)");
    createToken("CARETTRIM", `(\\s*)${src[t.LONECARET]}\\s+`, true);
    exports.caretTrimReplace = "$1^";
    createToken("CARET", `^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);
    createToken("CARETLOOSE", `^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COMPARATORLOOSE", `^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);
    createToken("COMPARATOR", `^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);
    createToken("COMPARATORTRIM", `(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`, true);
    exports.comparatorTrimReplace = "$1$2$3";
    createToken("HYPHENRANGE", `^\\s*(${src[t.XRANGEPLAIN]})\\s+-\\s+(${src[t.XRANGEPLAIN]})\\s*$`);
    createToken("HYPHENRANGELOOSE", `^\\s*(${src[t.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t.XRANGEPLAINLOOSE]})\\s*$`);
    createToken("STAR", "(<|>)?=?\\s*\\*");
    createToken("GTE0", "^\\s*>=\\s*0.0.0\\s*$");
    createToken("GTE0PRE", "^\\s*>=\\s*0.0.0-0\\s*$");
  }
});

// node_modules/semver/internal/parse-options.js
var require_parse_options = __commonJS({
  "node_modules/semver/internal/parse-options.js"(exports, module2) {
    var opts = ["includePrerelease", "loose", "rtl"];
    var parseOptions = (options) => !options ? {} : typeof options !== "object" ? { loose: true } : opts.filter((k) => options[k]).reduce((options2, k) => {
      options2[k] = true;
      return options2;
    }, {});
    module2.exports = parseOptions;
  }
});

// node_modules/semver/internal/identifiers.js
var require_identifiers = __commonJS({
  "node_modules/semver/internal/identifiers.js"(exports, module2) {
    var numeric = /^[0-9]+$/;
    var compareIdentifiers = (a, b) => {
      const anum = numeric.test(a);
      const bnum = numeric.test(b);
      if (anum && bnum) {
        a = +a;
        b = +b;
      }
      return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
    };
    var rcompareIdentifiers = (a, b) => compareIdentifiers(b, a);
    module2.exports = {
      compareIdentifiers,
      rcompareIdentifiers
    };
  }
});

// node_modules/semver/classes/semver.js
var require_semver = __commonJS({
  "node_modules/semver/classes/semver.js"(exports, module2) {
    var debug = require_debug();
    var { MAX_LENGTH, MAX_SAFE_INTEGER } = require_constants();
    var { re, t } = require_re();
    var parseOptions = require_parse_options();
    var { compareIdentifiers } = require_identifiers();
    var SemVer2 = class {
      constructor(version, options) {
        options = parseOptions(options);
        if (version instanceof SemVer2) {
          if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
            return version;
          } else {
            version = version.version;
          }
        } else if (typeof version !== "string") {
          throw new TypeError(`Invalid Version: ${version}`);
        }
        if (version.length > MAX_LENGTH) {
          throw new TypeError(`version is longer than ${MAX_LENGTH} characters`);
        }
        debug("SemVer", version, options);
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        const m = version.trim().match(options.loose ? re[t.LOOSE] : re[t.FULL]);
        if (!m) {
          throw new TypeError(`Invalid Version: ${version}`);
        }
        this.raw = version;
        this.major = +m[1];
        this.minor = +m[2];
        this.patch = +m[3];
        if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
          throw new TypeError("Invalid major version");
        }
        if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
          throw new TypeError("Invalid minor version");
        }
        if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
          throw new TypeError("Invalid patch version");
        }
        if (!m[4]) {
          this.prerelease = [];
        } else {
          this.prerelease = m[4].split(".").map((id) => {
            if (/^[0-9]+$/.test(id)) {
              const num = +id;
              if (num >= 0 && num < MAX_SAFE_INTEGER) {
                return num;
              }
            }
            return id;
          });
        }
        this.build = m[5] ? m[5].split(".") : [];
        this.format();
      }
      format() {
        this.version = `${this.major}.${this.minor}.${this.patch}`;
        if (this.prerelease.length) {
          this.version += `-${this.prerelease.join(".")}`;
        }
        return this.version;
      }
      toString() {
        return this.version;
      }
      compare(other) {
        debug("SemVer.compare", this.version, this.options, other);
        if (!(other instanceof SemVer2)) {
          if (typeof other === "string" && other === this.version) {
            return 0;
          }
          other = new SemVer2(other, this.options);
        }
        if (other.version === this.version) {
          return 0;
        }
        return this.compareMain(other) || this.comparePre(other);
      }
      compareMain(other) {
        if (!(other instanceof SemVer2)) {
          other = new SemVer2(other, this.options);
        }
        return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
      }
      comparePre(other) {
        if (!(other instanceof SemVer2)) {
          other = new SemVer2(other, this.options);
        }
        if (this.prerelease.length && !other.prerelease.length) {
          return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
          return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
          return 0;
        }
        let i = 0;
        do {
          const a = this.prerelease[i];
          const b = other.prerelease[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      compareBuild(other) {
        if (!(other instanceof SemVer2)) {
          other = new SemVer2(other, this.options);
        }
        let i = 0;
        do {
          const a = this.build[i];
          const b = other.build[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      inc(release, identifier) {
        switch (release) {
          case "premajor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor = 0;
            this.major++;
            this.inc("pre", identifier);
            break;
          case "preminor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor++;
            this.inc("pre", identifier);
            break;
          case "prepatch":
            this.prerelease.length = 0;
            this.inc("patch", identifier);
            this.inc("pre", identifier);
            break;
          case "prerelease":
            if (this.prerelease.length === 0) {
              this.inc("patch", identifier);
            }
            this.inc("pre", identifier);
            break;
          case "major":
            if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
              this.major++;
            }
            this.minor = 0;
            this.patch = 0;
            this.prerelease = [];
            break;
          case "minor":
            if (this.patch !== 0 || this.prerelease.length === 0) {
              this.minor++;
            }
            this.patch = 0;
            this.prerelease = [];
            break;
          case "patch":
            if (this.prerelease.length === 0) {
              this.patch++;
            }
            this.prerelease = [];
            break;
          case "pre":
            if (this.prerelease.length === 0) {
              this.prerelease = [0];
            } else {
              let i = this.prerelease.length;
              while (--i >= 0) {
                if (typeof this.prerelease[i] === "number") {
                  this.prerelease[i]++;
                  i = -2;
                }
              }
              if (i === -1) {
                this.prerelease.push(0);
              }
            }
            if (identifier) {
              if (this.prerelease[0] === identifier) {
                if (isNaN(this.prerelease[1])) {
                  this.prerelease = [identifier, 0];
                }
              } else {
                this.prerelease = [identifier, 0];
              }
            }
            break;
          default:
            throw new Error(`invalid increment argument: ${release}`);
        }
        this.format();
        this.raw = this.version;
        return this;
      }
    };
    module2.exports = SemVer2;
  }
});

// node_modules/semver/functions/parse.js
var require_parse = __commonJS({
  "node_modules/semver/functions/parse.js"(exports, module2) {
    var { MAX_LENGTH } = require_constants();
    var { re, t } = require_re();
    var SemVer2 = require_semver();
    var parseOptions = require_parse_options();
    var parse = (version, options) => {
      options = parseOptions(options);
      if (version instanceof SemVer2) {
        return version;
      }
      if (typeof version !== "string") {
        return null;
      }
      if (version.length > MAX_LENGTH) {
        return null;
      }
      const r = options.loose ? re[t.LOOSE] : re[t.FULL];
      if (!r.test(version)) {
        return null;
      }
      try {
        return new SemVer2(version, options);
      } catch (er) {
        return null;
      }
    };
    module2.exports = parse;
  }
});

// node_modules/semver/functions/valid.js
var require_valid = __commonJS({
  "node_modules/semver/functions/valid.js"(exports, module2) {
    var parse = require_parse();
    var valid = (version, options) => {
      const v = parse(version, options);
      return v ? v.version : null;
    };
    module2.exports = valid;
  }
});

// node_modules/semver/functions/clean.js
var require_clean = __commonJS({
  "node_modules/semver/functions/clean.js"(exports, module2) {
    var parse = require_parse();
    var clean = (version, options) => {
      const s = parse(version.trim().replace(/^[=v]+/, ""), options);
      return s ? s.version : null;
    };
    module2.exports = clean;
  }
});

// node_modules/semver/functions/inc.js
var require_inc = __commonJS({
  "node_modules/semver/functions/inc.js"(exports, module2) {
    var SemVer2 = require_semver();
    var inc = (version, release, options, identifier) => {
      if (typeof options === "string") {
        identifier = options;
        options = void 0;
      }
      try {
        return new SemVer2(version, options).inc(release, identifier).version;
      } catch (er) {
        return null;
      }
    };
    module2.exports = inc;
  }
});

// node_modules/semver/functions/compare.js
var require_compare = __commonJS({
  "node_modules/semver/functions/compare.js"(exports, module2) {
    var SemVer2 = require_semver();
    var compare = (a, b, loose) => new SemVer2(a, loose).compare(new SemVer2(b, loose));
    module2.exports = compare;
  }
});

// node_modules/semver/functions/eq.js
var require_eq = __commonJS({
  "node_modules/semver/functions/eq.js"(exports, module2) {
    var compare = require_compare();
    var eq = (a, b, loose) => compare(a, b, loose) === 0;
    module2.exports = eq;
  }
});

// node_modules/semver/functions/diff.js
var require_diff = __commonJS({
  "node_modules/semver/functions/diff.js"(exports, module2) {
    var parse = require_parse();
    var eq = require_eq();
    var diff = (version1, version2) => {
      if (eq(version1, version2)) {
        return null;
      } else {
        const v1 = parse(version1);
        const v2 = parse(version2);
        const hasPre = v1.prerelease.length || v2.prerelease.length;
        const prefix = hasPre ? "pre" : "";
        const defaultResult = hasPre ? "prerelease" : "";
        for (const key in v1) {
          if (key === "major" || key === "minor" || key === "patch") {
            if (v1[key] !== v2[key]) {
              return prefix + key;
            }
          }
        }
        return defaultResult;
      }
    };
    module2.exports = diff;
  }
});

// node_modules/semver/functions/major.js
var require_major = __commonJS({
  "node_modules/semver/functions/major.js"(exports, module2) {
    var SemVer2 = require_semver();
    var major = (a, loose) => new SemVer2(a, loose).major;
    module2.exports = major;
  }
});

// node_modules/semver/functions/minor.js
var require_minor = __commonJS({
  "node_modules/semver/functions/minor.js"(exports, module2) {
    var SemVer2 = require_semver();
    var minor = (a, loose) => new SemVer2(a, loose).minor;
    module2.exports = minor;
  }
});

// node_modules/semver/functions/patch.js
var require_patch = __commonJS({
  "node_modules/semver/functions/patch.js"(exports, module2) {
    var SemVer2 = require_semver();
    var patch = (a, loose) => new SemVer2(a, loose).patch;
    module2.exports = patch;
  }
});

// node_modules/semver/functions/prerelease.js
var require_prerelease = __commonJS({
  "node_modules/semver/functions/prerelease.js"(exports, module2) {
    var parse = require_parse();
    var prerelease = (version, options) => {
      const parsed = parse(version, options);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    };
    module2.exports = prerelease;
  }
});

// node_modules/semver/functions/rcompare.js
var require_rcompare = __commonJS({
  "node_modules/semver/functions/rcompare.js"(exports, module2) {
    var compare = require_compare();
    var rcompare = (a, b, loose) => compare(b, a, loose);
    module2.exports = rcompare;
  }
});

// node_modules/semver/functions/compare-loose.js
var require_compare_loose = __commonJS({
  "node_modules/semver/functions/compare-loose.js"(exports, module2) {
    var compare = require_compare();
    var compareLoose = (a, b) => compare(a, b, true);
    module2.exports = compareLoose;
  }
});

// node_modules/semver/functions/compare-build.js
var require_compare_build = __commonJS({
  "node_modules/semver/functions/compare-build.js"(exports, module2) {
    var SemVer2 = require_semver();
    var compareBuild = (a, b, loose) => {
      const versionA = new SemVer2(a, loose);
      const versionB = new SemVer2(b, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    };
    module2.exports = compareBuild;
  }
});

// node_modules/semver/functions/sort.js
var require_sort = __commonJS({
  "node_modules/semver/functions/sort.js"(exports, module2) {
    var compareBuild = require_compare_build();
    var sort = (list, loose) => list.sort((a, b) => compareBuild(a, b, loose));
    module2.exports = sort;
  }
});

// node_modules/semver/functions/rsort.js
var require_rsort = __commonJS({
  "node_modules/semver/functions/rsort.js"(exports, module2) {
    var compareBuild = require_compare_build();
    var rsort = (list, loose) => list.sort((a, b) => compareBuild(b, a, loose));
    module2.exports = rsort;
  }
});

// node_modules/semver/functions/gt.js
var require_gt = __commonJS({
  "node_modules/semver/functions/gt.js"(exports, module2) {
    var compare = require_compare();
    var gt = (a, b, loose) => compare(a, b, loose) > 0;
    module2.exports = gt;
  }
});

// node_modules/semver/functions/lt.js
var require_lt = __commonJS({
  "node_modules/semver/functions/lt.js"(exports, module2) {
    var compare = require_compare();
    var lt = (a, b, loose) => compare(a, b, loose) < 0;
    module2.exports = lt;
  }
});

// node_modules/semver/functions/neq.js
var require_neq = __commonJS({
  "node_modules/semver/functions/neq.js"(exports, module2) {
    var compare = require_compare();
    var neq = (a, b, loose) => compare(a, b, loose) !== 0;
    module2.exports = neq;
  }
});

// node_modules/semver/functions/gte.js
var require_gte = __commonJS({
  "node_modules/semver/functions/gte.js"(exports, module2) {
    var compare = require_compare();
    var gte = (a, b, loose) => compare(a, b, loose) >= 0;
    module2.exports = gte;
  }
});

// node_modules/semver/functions/lte.js
var require_lte = __commonJS({
  "node_modules/semver/functions/lte.js"(exports, module2) {
    var compare = require_compare();
    var lte = (a, b, loose) => compare(a, b, loose) <= 0;
    module2.exports = lte;
  }
});

// node_modules/semver/functions/cmp.js
var require_cmp = __commonJS({
  "node_modules/semver/functions/cmp.js"(exports, module2) {
    var eq = require_eq();
    var neq = require_neq();
    var gt = require_gt();
    var gte = require_gte();
    var lt = require_lt();
    var lte = require_lte();
    var cmp = (a, op, b, loose) => {
      switch (op) {
        case "===":
          if (typeof a === "object")
            a = a.version;
          if (typeof b === "object")
            b = b.version;
          return a === b;
        case "!==":
          if (typeof a === "object")
            a = a.version;
          if (typeof b === "object")
            b = b.version;
          return a !== b;
        case "":
        case "=":
        case "==":
          return eq(a, b, loose);
        case "!=":
          return neq(a, b, loose);
        case ">":
          return gt(a, b, loose);
        case ">=":
          return gte(a, b, loose);
        case "<":
          return lt(a, b, loose);
        case "<=":
          return lte(a, b, loose);
        default:
          throw new TypeError(`Invalid operator: ${op}`);
      }
    };
    module2.exports = cmp;
  }
});

// node_modules/semver/functions/coerce.js
var require_coerce = __commonJS({
  "node_modules/semver/functions/coerce.js"(exports, module2) {
    var SemVer2 = require_semver();
    var parse = require_parse();
    var { re, t } = require_re();
    var coerce = (version, options) => {
      if (version instanceof SemVer2) {
        return version;
      }
      if (typeof version === "number") {
        version = String(version);
      }
      if (typeof version !== "string") {
        return null;
      }
      options = options || {};
      let match = null;
      if (!options.rtl) {
        match = version.match(re[t.COERCE]);
      } else {
        let next;
        while ((next = re[t.COERCERTL].exec(version)) && (!match || match.index + match[0].length !== version.length)) {
          if (!match || next.index + next[0].length !== match.index + match[0].length) {
            match = next;
          }
          re[t.COERCERTL].lastIndex = next.index + next[1].length + next[2].length;
        }
        re[t.COERCERTL].lastIndex = -1;
      }
      if (match === null)
        return null;
      return parse(`${match[2]}.${match[3] || "0"}.${match[4] || "0"}`, options);
    };
    module2.exports = coerce;
  }
});

// node_modules/yallist/iterator.js
var require_iterator = __commonJS({
  "node_modules/yallist/iterator.js"(exports, module2) {
    "use strict";
    module2.exports = function(Yallist) {
      Yallist.prototype[Symbol.iterator] = function* () {
        for (let walker = this.head; walker; walker = walker.next) {
          yield walker.value;
        }
      };
    };
  }
});

// node_modules/yallist/yallist.js
var require_yallist = __commonJS({
  "node_modules/yallist/yallist.js"(exports, module2) {
    "use strict";
    module2.exports = Yallist;
    Yallist.Node = Node;
    Yallist.create = Yallist;
    function Yallist(list) {
      var self = this;
      if (!(self instanceof Yallist)) {
        self = new Yallist();
      }
      self.tail = null;
      self.head = null;
      self.length = 0;
      if (list && typeof list.forEach === "function") {
        list.forEach(function(item) {
          self.push(item);
        });
      } else if (arguments.length > 0) {
        for (var i = 0, l = arguments.length; i < l; i++) {
          self.push(arguments[i]);
        }
      }
      return self;
    }
    Yallist.prototype.removeNode = function(node) {
      if (node.list !== this) {
        throw new Error("removing node which does not belong to this list");
      }
      var next = node.next;
      var prev = node.prev;
      if (next) {
        next.prev = prev;
      }
      if (prev) {
        prev.next = next;
      }
      if (node === this.head) {
        this.head = next;
      }
      if (node === this.tail) {
        this.tail = prev;
      }
      node.list.length--;
      node.next = null;
      node.prev = null;
      node.list = null;
      return next;
    };
    Yallist.prototype.unshiftNode = function(node) {
      if (node === this.head) {
        return;
      }
      if (node.list) {
        node.list.removeNode(node);
      }
      var head = this.head;
      node.list = this;
      node.next = head;
      if (head) {
        head.prev = node;
      }
      this.head = node;
      if (!this.tail) {
        this.tail = node;
      }
      this.length++;
    };
    Yallist.prototype.pushNode = function(node) {
      if (node === this.tail) {
        return;
      }
      if (node.list) {
        node.list.removeNode(node);
      }
      var tail = this.tail;
      node.list = this;
      node.prev = tail;
      if (tail) {
        tail.next = node;
      }
      this.tail = node;
      if (!this.head) {
        this.head = node;
      }
      this.length++;
    };
    Yallist.prototype.push = function() {
      for (var i = 0, l = arguments.length; i < l; i++) {
        push(this, arguments[i]);
      }
      return this.length;
    };
    Yallist.prototype.unshift = function() {
      for (var i = 0, l = arguments.length; i < l; i++) {
        unshift(this, arguments[i]);
      }
      return this.length;
    };
    Yallist.prototype.pop = function() {
      if (!this.tail) {
        return void 0;
      }
      var res = this.tail.value;
      this.tail = this.tail.prev;
      if (this.tail) {
        this.tail.next = null;
      } else {
        this.head = null;
      }
      this.length--;
      return res;
    };
    Yallist.prototype.shift = function() {
      if (!this.head) {
        return void 0;
      }
      var res = this.head.value;
      this.head = this.head.next;
      if (this.head) {
        this.head.prev = null;
      } else {
        this.tail = null;
      }
      this.length--;
      return res;
    };
    Yallist.prototype.forEach = function(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this.head, i = 0; walker !== null; i++) {
        fn.call(thisp, walker.value, i, this);
        walker = walker.next;
      }
    };
    Yallist.prototype.forEachReverse = function(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this.tail, i = this.length - 1; walker !== null; i--) {
        fn.call(thisp, walker.value, i, this);
        walker = walker.prev;
      }
    };
    Yallist.prototype.get = function(n) {
      for (var i = 0, walker = this.head; walker !== null && i < n; i++) {
        walker = walker.next;
      }
      if (i === n && walker !== null) {
        return walker.value;
      }
    };
    Yallist.prototype.getReverse = function(n) {
      for (var i = 0, walker = this.tail; walker !== null && i < n; i++) {
        walker = walker.prev;
      }
      if (i === n && walker !== null) {
        return walker.value;
      }
    };
    Yallist.prototype.map = function(fn, thisp) {
      thisp = thisp || this;
      var res = new Yallist();
      for (var walker = this.head; walker !== null; ) {
        res.push(fn.call(thisp, walker.value, this));
        walker = walker.next;
      }
      return res;
    };
    Yallist.prototype.mapReverse = function(fn, thisp) {
      thisp = thisp || this;
      var res = new Yallist();
      for (var walker = this.tail; walker !== null; ) {
        res.push(fn.call(thisp, walker.value, this));
        walker = walker.prev;
      }
      return res;
    };
    Yallist.prototype.reduce = function(fn, initial) {
      var acc;
      var walker = this.head;
      if (arguments.length > 1) {
        acc = initial;
      } else if (this.head) {
        walker = this.head.next;
        acc = this.head.value;
      } else {
        throw new TypeError("Reduce of empty list with no initial value");
      }
      for (var i = 0; walker !== null; i++) {
        acc = fn(acc, walker.value, i);
        walker = walker.next;
      }
      return acc;
    };
    Yallist.prototype.reduceReverse = function(fn, initial) {
      var acc;
      var walker = this.tail;
      if (arguments.length > 1) {
        acc = initial;
      } else if (this.tail) {
        walker = this.tail.prev;
        acc = this.tail.value;
      } else {
        throw new TypeError("Reduce of empty list with no initial value");
      }
      for (var i = this.length - 1; walker !== null; i--) {
        acc = fn(acc, walker.value, i);
        walker = walker.prev;
      }
      return acc;
    };
    Yallist.prototype.toArray = function() {
      var arr = new Array(this.length);
      for (var i = 0, walker = this.head; walker !== null; i++) {
        arr[i] = walker.value;
        walker = walker.next;
      }
      return arr;
    };
    Yallist.prototype.toArrayReverse = function() {
      var arr = new Array(this.length);
      for (var i = 0, walker = this.tail; walker !== null; i++) {
        arr[i] = walker.value;
        walker = walker.prev;
      }
      return arr;
    };
    Yallist.prototype.slice = function(from, to) {
      to = to || this.length;
      if (to < 0) {
        to += this.length;
      }
      from = from || 0;
      if (from < 0) {
        from += this.length;
      }
      var ret = new Yallist();
      if (to < from || to < 0) {
        return ret;
      }
      if (from < 0) {
        from = 0;
      }
      if (to > this.length) {
        to = this.length;
      }
      for (var i = 0, walker = this.head; walker !== null && i < from; i++) {
        walker = walker.next;
      }
      for (; walker !== null && i < to; i++, walker = walker.next) {
        ret.push(walker.value);
      }
      return ret;
    };
    Yallist.prototype.sliceReverse = function(from, to) {
      to = to || this.length;
      if (to < 0) {
        to += this.length;
      }
      from = from || 0;
      if (from < 0) {
        from += this.length;
      }
      var ret = new Yallist();
      if (to < from || to < 0) {
        return ret;
      }
      if (from < 0) {
        from = 0;
      }
      if (to > this.length) {
        to = this.length;
      }
      for (var i = this.length, walker = this.tail; walker !== null && i > to; i--) {
        walker = walker.prev;
      }
      for (; walker !== null && i > from; i--, walker = walker.prev) {
        ret.push(walker.value);
      }
      return ret;
    };
    Yallist.prototype.splice = function(start, deleteCount, ...nodes) {
      if (start > this.length) {
        start = this.length - 1;
      }
      if (start < 0) {
        start = this.length + start;
      }
      for (var i = 0, walker = this.head; walker !== null && i < start; i++) {
        walker = walker.next;
      }
      var ret = [];
      for (var i = 0; walker && i < deleteCount; i++) {
        ret.push(walker.value);
        walker = this.removeNode(walker);
      }
      if (walker === null) {
        walker = this.tail;
      }
      if (walker !== this.head && walker !== this.tail) {
        walker = walker.prev;
      }
      for (var i = 0; i < nodes.length; i++) {
        walker = insert(this, walker, nodes[i]);
      }
      return ret;
    };
    Yallist.prototype.reverse = function() {
      var head = this.head;
      var tail = this.tail;
      for (var walker = head; walker !== null; walker = walker.prev) {
        var p = walker.prev;
        walker.prev = walker.next;
        walker.next = p;
      }
      this.head = tail;
      this.tail = head;
      return this;
    };
    function insert(self, node, value) {
      var inserted = node === self.head ? new Node(value, null, node, self) : new Node(value, node, node.next, self);
      if (inserted.next === null) {
        self.tail = inserted;
      }
      if (inserted.prev === null) {
        self.head = inserted;
      }
      self.length++;
      return inserted;
    }
    function push(self, item) {
      self.tail = new Node(item, self.tail, null, self);
      if (!self.head) {
        self.head = self.tail;
      }
      self.length++;
    }
    function unshift(self, item) {
      self.head = new Node(item, null, self.head, self);
      if (!self.tail) {
        self.tail = self.head;
      }
      self.length++;
    }
    function Node(value, prev, next, list) {
      if (!(this instanceof Node)) {
        return new Node(value, prev, next, list);
      }
      this.list = list;
      this.value = value;
      if (prev) {
        prev.next = this;
        this.prev = prev;
      } else {
        this.prev = null;
      }
      if (next) {
        next.prev = this;
        this.next = next;
      } else {
        this.next = null;
      }
    }
    try {
      require_iterator()(Yallist);
    } catch (er) {
    }
  }
});

// node_modules/lru-cache/index.js
var require_lru_cache = __commonJS({
  "node_modules/lru-cache/index.js"(exports, module2) {
    "use strict";
    var Yallist = require_yallist();
    var MAX = Symbol("max");
    var LENGTH = Symbol("length");
    var LENGTH_CALCULATOR = Symbol("lengthCalculator");
    var ALLOW_STALE = Symbol("allowStale");
    var MAX_AGE = Symbol("maxAge");
    var DISPOSE = Symbol("dispose");
    var NO_DISPOSE_ON_SET = Symbol("noDisposeOnSet");
    var LRU_LIST = Symbol("lruList");
    var CACHE = Symbol("cache");
    var UPDATE_AGE_ON_GET = Symbol("updateAgeOnGet");
    var naiveLength = () => 1;
    var LRUCache = class {
      constructor(options) {
        if (typeof options === "number")
          options = { max: options };
        if (!options)
          options = {};
        if (options.max && (typeof options.max !== "number" || options.max < 0))
          throw new TypeError("max must be a non-negative number");
        const max = this[MAX] = options.max || Infinity;
        const lc = options.length || naiveLength;
        this[LENGTH_CALCULATOR] = typeof lc !== "function" ? naiveLength : lc;
        this[ALLOW_STALE] = options.stale || false;
        if (options.maxAge && typeof options.maxAge !== "number")
          throw new TypeError("maxAge must be a number");
        this[MAX_AGE] = options.maxAge || 0;
        this[DISPOSE] = options.dispose;
        this[NO_DISPOSE_ON_SET] = options.noDisposeOnSet || false;
        this[UPDATE_AGE_ON_GET] = options.updateAgeOnGet || false;
        this.reset();
      }
      set max(mL) {
        if (typeof mL !== "number" || mL < 0)
          throw new TypeError("max must be a non-negative number");
        this[MAX] = mL || Infinity;
        trim(this);
      }
      get max() {
        return this[MAX];
      }
      set allowStale(allowStale) {
        this[ALLOW_STALE] = !!allowStale;
      }
      get allowStale() {
        return this[ALLOW_STALE];
      }
      set maxAge(mA) {
        if (typeof mA !== "number")
          throw new TypeError("maxAge must be a non-negative number");
        this[MAX_AGE] = mA;
        trim(this);
      }
      get maxAge() {
        return this[MAX_AGE];
      }
      set lengthCalculator(lC) {
        if (typeof lC !== "function")
          lC = naiveLength;
        if (lC !== this[LENGTH_CALCULATOR]) {
          this[LENGTH_CALCULATOR] = lC;
          this[LENGTH] = 0;
          this[LRU_LIST].forEach((hit) => {
            hit.length = this[LENGTH_CALCULATOR](hit.value, hit.key);
            this[LENGTH] += hit.length;
          });
        }
        trim(this);
      }
      get lengthCalculator() {
        return this[LENGTH_CALCULATOR];
      }
      get length() {
        return this[LENGTH];
      }
      get itemCount() {
        return this[LRU_LIST].length;
      }
      rforEach(fn, thisp) {
        thisp = thisp || this;
        for (let walker = this[LRU_LIST].tail; walker !== null; ) {
          const prev = walker.prev;
          forEachStep(this, fn, walker, thisp);
          walker = prev;
        }
      }
      forEach(fn, thisp) {
        thisp = thisp || this;
        for (let walker = this[LRU_LIST].head; walker !== null; ) {
          const next = walker.next;
          forEachStep(this, fn, walker, thisp);
          walker = next;
        }
      }
      keys() {
        return this[LRU_LIST].toArray().map((k) => k.key);
      }
      values() {
        return this[LRU_LIST].toArray().map((k) => k.value);
      }
      reset() {
        if (this[DISPOSE] && this[LRU_LIST] && this[LRU_LIST].length) {
          this[LRU_LIST].forEach((hit) => this[DISPOSE](hit.key, hit.value));
        }
        this[CACHE] = /* @__PURE__ */ new Map();
        this[LRU_LIST] = new Yallist();
        this[LENGTH] = 0;
      }
      dump() {
        return this[LRU_LIST].map((hit) => isStale(this, hit) ? false : {
          k: hit.key,
          v: hit.value,
          e: hit.now + (hit.maxAge || 0)
        }).toArray().filter((h) => h);
      }
      dumpLru() {
        return this[LRU_LIST];
      }
      set(key, value, maxAge) {
        maxAge = maxAge || this[MAX_AGE];
        if (maxAge && typeof maxAge !== "number")
          throw new TypeError("maxAge must be a number");
        const now = maxAge ? Date.now() : 0;
        const len = this[LENGTH_CALCULATOR](value, key);
        if (this[CACHE].has(key)) {
          if (len > this[MAX]) {
            del(this, this[CACHE].get(key));
            return false;
          }
          const node = this[CACHE].get(key);
          const item = node.value;
          if (this[DISPOSE]) {
            if (!this[NO_DISPOSE_ON_SET])
              this[DISPOSE](key, item.value);
          }
          item.now = now;
          item.maxAge = maxAge;
          item.value = value;
          this[LENGTH] += len - item.length;
          item.length = len;
          this.get(key);
          trim(this);
          return true;
        }
        const hit = new Entry(key, value, len, now, maxAge);
        if (hit.length > this[MAX]) {
          if (this[DISPOSE])
            this[DISPOSE](key, value);
          return false;
        }
        this[LENGTH] += hit.length;
        this[LRU_LIST].unshift(hit);
        this[CACHE].set(key, this[LRU_LIST].head);
        trim(this);
        return true;
      }
      has(key) {
        if (!this[CACHE].has(key))
          return false;
        const hit = this[CACHE].get(key).value;
        return !isStale(this, hit);
      }
      get(key) {
        return get(this, key, true);
      }
      peek(key) {
        return get(this, key, false);
      }
      pop() {
        const node = this[LRU_LIST].tail;
        if (!node)
          return null;
        del(this, node);
        return node.value;
      }
      del(key) {
        del(this, this[CACHE].get(key));
      }
      load(arr) {
        this.reset();
        const now = Date.now();
        for (let l = arr.length - 1; l >= 0; l--) {
          const hit = arr[l];
          const expiresAt = hit.e || 0;
          if (expiresAt === 0)
            this.set(hit.k, hit.v);
          else {
            const maxAge = expiresAt - now;
            if (maxAge > 0) {
              this.set(hit.k, hit.v, maxAge);
            }
          }
        }
      }
      prune() {
        this[CACHE].forEach((value, key) => get(this, key, false));
      }
    };
    var get = (self, key, doUse) => {
      const node = self[CACHE].get(key);
      if (node) {
        const hit = node.value;
        if (isStale(self, hit)) {
          del(self, node);
          if (!self[ALLOW_STALE])
            return void 0;
        } else {
          if (doUse) {
            if (self[UPDATE_AGE_ON_GET])
              node.value.now = Date.now();
            self[LRU_LIST].unshiftNode(node);
          }
        }
        return hit.value;
      }
    };
    var isStale = (self, hit) => {
      if (!hit || !hit.maxAge && !self[MAX_AGE])
        return false;
      const diff = Date.now() - hit.now;
      return hit.maxAge ? diff > hit.maxAge : self[MAX_AGE] && diff > self[MAX_AGE];
    };
    var trim = (self) => {
      if (self[LENGTH] > self[MAX]) {
        for (let walker = self[LRU_LIST].tail; self[LENGTH] > self[MAX] && walker !== null; ) {
          const prev = walker.prev;
          del(self, walker);
          walker = prev;
        }
      }
    };
    var del = (self, node) => {
      if (node) {
        const hit = node.value;
        if (self[DISPOSE])
          self[DISPOSE](hit.key, hit.value);
        self[LENGTH] -= hit.length;
        self[CACHE].delete(hit.key);
        self[LRU_LIST].removeNode(node);
      }
    };
    var Entry = class {
      constructor(key, value, length, now, maxAge) {
        this.key = key;
        this.value = value;
        this.length = length;
        this.now = now;
        this.maxAge = maxAge || 0;
      }
    };
    var forEachStep = (self, fn, node, thisp) => {
      let hit = node.value;
      if (isStale(self, hit)) {
        del(self, node);
        if (!self[ALLOW_STALE])
          hit = void 0;
      }
      if (hit)
        fn.call(thisp, hit.value, hit.key, self);
    };
    module2.exports = LRUCache;
  }
});

// node_modules/semver/classes/range.js
var require_range = __commonJS({
  "node_modules/semver/classes/range.js"(exports, module2) {
    var Range = class {
      constructor(range, options) {
        options = parseOptions(options);
        if (range instanceof Range) {
          if (range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease) {
            return range;
          } else {
            return new Range(range.raw, options);
          }
        }
        if (range instanceof Comparator) {
          this.raw = range.value;
          this.set = [[range]];
          this.format();
          return this;
        }
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        this.raw = range;
        this.set = range.split(/\s*\|\|\s*/).map((range2) => this.parseRange(range2.trim())).filter((c) => c.length);
        if (!this.set.length) {
          throw new TypeError(`Invalid SemVer Range: ${range}`);
        }
        if (this.set.length > 1) {
          const first = this.set[0];
          this.set = this.set.filter((c) => !isNullSet(c[0]));
          if (this.set.length === 0)
            this.set = [first];
          else if (this.set.length > 1) {
            for (const c of this.set) {
              if (c.length === 1 && isAny(c[0])) {
                this.set = [c];
                break;
              }
            }
          }
        }
        this.format();
      }
      format() {
        this.range = this.set.map((comps) => {
          return comps.join(" ").trim();
        }).join("||").trim();
        return this.range;
      }
      toString() {
        return this.range;
      }
      parseRange(range) {
        range = range.trim();
        const memoOpts = Object.keys(this.options).join(",");
        const memoKey = `parseRange:${memoOpts}:${range}`;
        const cached = cache.get(memoKey);
        if (cached)
          return cached;
        const loose = this.options.loose;
        const hr = loose ? re[t.HYPHENRANGELOOSE] : re[t.HYPHENRANGE];
        range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug("hyphen replace", range);
        range = range.replace(re[t.COMPARATORTRIM], comparatorTrimReplace);
        debug("comparator trim", range, re[t.COMPARATORTRIM]);
        range = range.replace(re[t.TILDETRIM], tildeTrimReplace);
        range = range.replace(re[t.CARETTRIM], caretTrimReplace);
        range = range.split(/\s+/).join(" ");
        const compRe = loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
        const rangeList = range.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options)).filter(this.options.loose ? (comp) => !!comp.match(compRe) : () => true).map((comp) => new Comparator(comp, this.options));
        const l = rangeList.length;
        const rangeMap = /* @__PURE__ */ new Map();
        for (const comp of rangeList) {
          if (isNullSet(comp))
            return [comp];
          rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has(""))
          rangeMap.delete("");
        const result = [...rangeMap.values()];
        cache.set(memoKey, result);
        return result;
      }
      intersects(range, options) {
        if (!(range instanceof Range)) {
          throw new TypeError("a Range is required");
        }
        return this.set.some((thisComparators) => {
          return isSatisfiable(thisComparators, options) && range.set.some((rangeComparators) => {
            return isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator) => {
              return rangeComparators.every((rangeComparator) => {
                return thisComparator.intersects(rangeComparator, options);
              });
            });
          });
        });
      }
      test(version) {
        if (!version) {
          return false;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer2(version, this.options);
          } catch (er) {
            return false;
          }
        }
        for (let i = 0; i < this.set.length; i++) {
          if (testSet(this.set[i], version, this.options)) {
            return true;
          }
        }
        return false;
      }
    };
    module2.exports = Range;
    var LRU = require_lru_cache();
    var cache = new LRU({ max: 1e3 });
    var parseOptions = require_parse_options();
    var Comparator = require_comparator();
    var debug = require_debug();
    var SemVer2 = require_semver();
    var {
      re,
      t,
      comparatorTrimReplace,
      tildeTrimReplace,
      caretTrimReplace
    } = require_re();
    var isNullSet = (c) => c.value === "<0.0.0-0";
    var isAny = (c) => c.value === "";
    var isSatisfiable = (comparators, options) => {
      let result = true;
      const remainingComparators = comparators.slice();
      let testComparator = remainingComparators.pop();
      while (result && remainingComparators.length) {
        result = remainingComparators.every((otherComparator) => {
          return testComparator.intersects(otherComparator, options);
        });
        testComparator = remainingComparators.pop();
      }
      return result;
    };
    var parseComparator = (comp, options) => {
      debug("comp", comp, options);
      comp = replaceCarets(comp, options);
      debug("caret", comp);
      comp = replaceTildes(comp, options);
      debug("tildes", comp);
      comp = replaceXRanges(comp, options);
      debug("xrange", comp);
      comp = replaceStars(comp, options);
      debug("stars", comp);
      return comp;
    };
    var isX = (id) => !id || id.toLowerCase() === "x" || id === "*";
    var replaceTildes = (comp, options) => comp.trim().split(/\s+/).map((comp2) => {
      return replaceTilde(comp2, options);
    }).join(" ");
    var replaceTilde = (comp, options) => {
      const r = options.loose ? re[t.TILDELOOSE] : re[t.TILDE];
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("tilde", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0 <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          ret = `>=${M}.${m}.0 <${M}.${+m + 1}.0-0`;
        } else if (pr) {
          debug("replaceTilde pr", pr);
          ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
        } else {
          ret = `>=${M}.${m}.${p} <${M}.${+m + 1}.0-0`;
        }
        debug("tilde return", ret);
        return ret;
      });
    };
    var replaceCarets = (comp, options) => comp.trim().split(/\s+/).map((comp2) => {
      return replaceCaret(comp2, options);
    }).join(" ");
    var replaceCaret = (comp, options) => {
      debug("caret", comp, options);
      const r = options.loose ? re[t.CARETLOOSE] : re[t.CARET];
      const z = options.includePrerelease ? "-0" : "";
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("caret", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0${z} <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          if (M === "0") {
            ret = `>=${M}.${m}.0${z} <${M}.${+m + 1}.0-0`;
          } else {
            ret = `>=${M}.${m}.0${z} <${+M + 1}.0.0-0`;
          }
        } else if (pr) {
          debug("replaceCaret pr", pr);
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p}-${pr} <${+M + 1}.0.0-0`;
          }
        } else {
          debug("no pr");
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}${z} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}${z} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p} <${+M + 1}.0.0-0`;
          }
        }
        debug("caret return", ret);
        return ret;
      });
    };
    var replaceXRanges = (comp, options) => {
      debug("replaceXRanges", comp, options);
      return comp.split(/\s+/).map((comp2) => {
        return replaceXRange(comp2, options);
      }).join(" ");
    };
    var replaceXRange = (comp, options) => {
      comp = comp.trim();
      const r = options.loose ? re[t.XRANGELOOSE] : re[t.XRANGE];
      return comp.replace(r, (ret, gtlt, M, m, p, pr) => {
        debug("xRange", comp, ret, gtlt, M, m, p, pr);
        const xM = isX(M);
        const xm = xM || isX(m);
        const xp = xm || isX(p);
        const anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m = 0;
          }
          p = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m = 0;
              p = 0;
            } else {
              m = +m + 1;
              p = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m = +m + 1;
            }
          }
          if (gtlt === "<")
            pr = "-0";
          ret = `${gtlt + M}.${m}.${p}${pr}`;
        } else if (xm) {
          ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0`;
        } else if (xp) {
          ret = `>=${M}.${m}.0${pr} <${M}.${+m + 1}.0-0`;
        }
        debug("xRange return", ret);
        return ret;
      });
    };
    var replaceStars = (comp, options) => {
      debug("replaceStars", comp, options);
      return comp.trim().replace(re[t.STAR], "");
    };
    var replaceGTE0 = (comp, options) => {
      debug("replaceGTE0", comp, options);
      return comp.trim().replace(re[options.includePrerelease ? t.GTE0PRE : t.GTE0], "");
    };
    var hyphenReplace = (incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) => {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = `>=${fM}.0.0${incPr ? "-0" : ""}`;
      } else if (isX(fp)) {
        from = `>=${fM}.${fm}.0${incPr ? "-0" : ""}`;
      } else if (fpr) {
        from = `>=${from}`;
      } else {
        from = `>=${from}${incPr ? "-0" : ""}`;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = `<${+tM + 1}.0.0-0`;
      } else if (isX(tp)) {
        to = `<${tM}.${+tm + 1}.0-0`;
      } else if (tpr) {
        to = `<=${tM}.${tm}.${tp}-${tpr}`;
      } else if (incPr) {
        to = `<${tM}.${tm}.${+tp + 1}-0`;
      } else {
        to = `<=${to}`;
      }
      return `${from} ${to}`.trim();
    };
    var testSet = (set, version, options) => {
      for (let i = 0; i < set.length; i++) {
        if (!set[i].test(version)) {
          return false;
        }
      }
      if (version.prerelease.length && !options.includePrerelease) {
        for (let i = 0; i < set.length; i++) {
          debug(set[i].semver);
          if (set[i].semver === Comparator.ANY) {
            continue;
          }
          if (set[i].semver.prerelease.length > 0) {
            const allowed = set[i].semver;
            if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    };
  }
});

// node_modules/semver/classes/comparator.js
var require_comparator = __commonJS({
  "node_modules/semver/classes/comparator.js"(exports, module2) {
    var ANY = Symbol("SemVer ANY");
    var Comparator = class {
      static get ANY() {
        return ANY;
      }
      constructor(comp, options) {
        options = parseOptions(options);
        if (comp instanceof Comparator) {
          if (comp.loose === !!options.loose) {
            return comp;
          } else {
            comp = comp.value;
          }
        }
        debug("comparator", comp, options);
        this.options = options;
        this.loose = !!options.loose;
        this.parse(comp);
        if (this.semver === ANY) {
          this.value = "";
        } else {
          this.value = this.operator + this.semver.version;
        }
        debug("comp", this);
      }
      parse(comp) {
        const r = this.options.loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
        const m = comp.match(r);
        if (!m) {
          throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m[1] !== void 0 ? m[1] : "";
        if (this.operator === "=") {
          this.operator = "";
        }
        if (!m[2]) {
          this.semver = ANY;
        } else {
          this.semver = new SemVer2(m[2], this.options.loose);
        }
      }
      toString() {
        return this.value;
      }
      test(version) {
        debug("Comparator.test", version, this.options.loose);
        if (this.semver === ANY || version === ANY) {
          return true;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer2(version, this.options);
          } catch (er) {
            return false;
          }
        }
        return cmp(version, this.operator, this.semver, this.options);
      }
      intersects(comp, options) {
        if (!(comp instanceof Comparator)) {
          throw new TypeError("a Comparator is required");
        }
        if (!options || typeof options !== "object") {
          options = {
            loose: !!options,
            includePrerelease: false
          };
        }
        if (this.operator === "") {
          if (this.value === "") {
            return true;
          }
          return new Range(comp.value, options).test(this.value);
        } else if (comp.operator === "") {
          if (comp.value === "") {
            return true;
          }
          return new Range(this.value, options).test(comp.semver);
        }
        const sameDirectionIncreasing = (this.operator === ">=" || this.operator === ">") && (comp.operator === ">=" || comp.operator === ">");
        const sameDirectionDecreasing = (this.operator === "<=" || this.operator === "<") && (comp.operator === "<=" || comp.operator === "<");
        const sameSemVer = this.semver.version === comp.semver.version;
        const differentDirectionsInclusive = (this.operator === ">=" || this.operator === "<=") && (comp.operator === ">=" || comp.operator === "<=");
        const oppositeDirectionsLessThan = cmp(this.semver, "<", comp.semver, options) && (this.operator === ">=" || this.operator === ">") && (comp.operator === "<=" || comp.operator === "<");
        const oppositeDirectionsGreaterThan = cmp(this.semver, ">", comp.semver, options) && (this.operator === "<=" || this.operator === "<") && (comp.operator === ">=" || comp.operator === ">");
        return sameDirectionIncreasing || sameDirectionDecreasing || sameSemVer && differentDirectionsInclusive || oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
      }
    };
    module2.exports = Comparator;
    var parseOptions = require_parse_options();
    var { re, t } = require_re();
    var cmp = require_cmp();
    var debug = require_debug();
    var SemVer2 = require_semver();
    var Range = require_range();
  }
});

// node_modules/semver/functions/satisfies.js
var require_satisfies = __commonJS({
  "node_modules/semver/functions/satisfies.js"(exports, module2) {
    var Range = require_range();
    var satisfies = (version, range, options) => {
      try {
        range = new Range(range, options);
      } catch (er) {
        return false;
      }
      return range.test(version);
    };
    module2.exports = satisfies;
  }
});

// node_modules/semver/ranges/to-comparators.js
var require_to_comparators = __commonJS({
  "node_modules/semver/ranges/to-comparators.js"(exports, module2) {
    var Range = require_range();
    var toComparators = (range, options) => new Range(range, options).set.map((comp) => comp.map((c) => c.value).join(" ").trim().split(" "));
    module2.exports = toComparators;
  }
});

// node_modules/semver/ranges/max-satisfying.js
var require_max_satisfying = __commonJS({
  "node_modules/semver/ranges/max-satisfying.js"(exports, module2) {
    var SemVer2 = require_semver();
    var Range = require_range();
    var maxSatisfying = (versions, range, options) => {
      let max = null;
      let maxSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!max || maxSV.compare(v) === -1) {
            max = v;
            maxSV = new SemVer2(max, options);
          }
        }
      });
      return max;
    };
    module2.exports = maxSatisfying;
  }
});

// node_modules/semver/ranges/min-satisfying.js
var require_min_satisfying = __commonJS({
  "node_modules/semver/ranges/min-satisfying.js"(exports, module2) {
    var SemVer2 = require_semver();
    var Range = require_range();
    var minSatisfying = (versions, range, options) => {
      let min = null;
      let minSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!min || minSV.compare(v) === 1) {
            min = v;
            minSV = new SemVer2(min, options);
          }
        }
      });
      return min;
    };
    module2.exports = minSatisfying;
  }
});

// node_modules/semver/ranges/min-version.js
var require_min_version = __commonJS({
  "node_modules/semver/ranges/min-version.js"(exports, module2) {
    var SemVer2 = require_semver();
    var Range = require_range();
    var gt = require_gt();
    var minVersion = (range, loose) => {
      range = new Range(range, loose);
      let minver = new SemVer2("0.0.0");
      if (range.test(minver)) {
        return minver;
      }
      minver = new SemVer2("0.0.0-0");
      if (range.test(minver)) {
        return minver;
      }
      minver = null;
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let setMin = null;
        comparators.forEach((comparator) => {
          const compver = new SemVer2(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            case "":
            case ">=":
              if (!setMin || gt(compver, setMin)) {
                setMin = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            default:
              throw new Error(`Unexpected operation: ${comparator.operator}`);
          }
        });
        if (setMin && (!minver || gt(minver, setMin)))
          minver = setMin;
      }
      if (minver && range.test(minver)) {
        return minver;
      }
      return null;
    };
    module2.exports = minVersion;
  }
});

// node_modules/semver/ranges/valid.js
var require_valid2 = __commonJS({
  "node_modules/semver/ranges/valid.js"(exports, module2) {
    var Range = require_range();
    var validRange = (range, options) => {
      try {
        return new Range(range, options).range || "*";
      } catch (er) {
        return null;
      }
    };
    module2.exports = validRange;
  }
});

// node_modules/semver/ranges/outside.js
var require_outside = __commonJS({
  "node_modules/semver/ranges/outside.js"(exports, module2) {
    var SemVer2 = require_semver();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var Range = require_range();
    var satisfies = require_satisfies();
    var gt = require_gt();
    var lt = require_lt();
    var lte = require_lte();
    var gte = require_gte();
    var outside = (version, range, hilo, options) => {
      version = new SemVer2(version, options);
      range = new Range(range, options);
      let gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version, range, options)) {
        return false;
      }
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let high = null;
        let low = null;
        comparators.forEach((comparator) => {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version, low.semver)) {
          return false;
        }
      }
      return true;
    };
    module2.exports = outside;
  }
});

// node_modules/semver/ranges/gtr.js
var require_gtr = __commonJS({
  "node_modules/semver/ranges/gtr.js"(exports, module2) {
    var outside = require_outside();
    var gtr = (version, range, options) => outside(version, range, ">", options);
    module2.exports = gtr;
  }
});

// node_modules/semver/ranges/ltr.js
var require_ltr = __commonJS({
  "node_modules/semver/ranges/ltr.js"(exports, module2) {
    var outside = require_outside();
    var ltr = (version, range, options) => outside(version, range, "<", options);
    module2.exports = ltr;
  }
});

// node_modules/semver/ranges/intersects.js
var require_intersects = __commonJS({
  "node_modules/semver/ranges/intersects.js"(exports, module2) {
    var Range = require_range();
    var intersects = (r1, r2, options) => {
      r1 = new Range(r1, options);
      r2 = new Range(r2, options);
      return r1.intersects(r2);
    };
    module2.exports = intersects;
  }
});

// node_modules/semver/ranges/simplify.js
var require_simplify = __commonJS({
  "node_modules/semver/ranges/simplify.js"(exports, module2) {
    var satisfies = require_satisfies();
    var compare = require_compare();
    module2.exports = (versions, range, options) => {
      const set = [];
      let min = null;
      let prev = null;
      const v = versions.sort((a, b) => compare(a, b, options));
      for (const version of v) {
        const included = satisfies(version, range, options);
        if (included) {
          prev = version;
          if (!min)
            min = version;
        } else {
          if (prev) {
            set.push([min, prev]);
          }
          prev = null;
          min = null;
        }
      }
      if (min)
        set.push([min, null]);
      const ranges = [];
      for (const [min2, max] of set) {
        if (min2 === max)
          ranges.push(min2);
        else if (!max && min2 === v[0])
          ranges.push("*");
        else if (!max)
          ranges.push(`>=${min2}`);
        else if (min2 === v[0])
          ranges.push(`<=${max}`);
        else
          ranges.push(`${min2} - ${max}`);
      }
      const simplified = ranges.join(" || ");
      const original = typeof range.raw === "string" ? range.raw : String(range);
      return simplified.length < original.length ? simplified : range;
    };
  }
});

// node_modules/semver/ranges/subset.js
var require_subset = __commonJS({
  "node_modules/semver/ranges/subset.js"(exports, module2) {
    var Range = require_range();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var satisfies = require_satisfies();
    var compare = require_compare();
    var subset = (sub, dom, options = {}) => {
      if (sub === dom)
        return true;
      sub = new Range(sub, options);
      dom = new Range(dom, options);
      let sawNonNull = false;
      OUTER:
        for (const simpleSub of sub.set) {
          for (const simpleDom of dom.set) {
            const isSub = simpleSubset(simpleSub, simpleDom, options);
            sawNonNull = sawNonNull || isSub !== null;
            if (isSub)
              continue OUTER;
          }
          if (sawNonNull)
            return false;
        }
      return true;
    };
    var simpleSubset = (sub, dom, options) => {
      if (sub === dom)
        return true;
      if (sub.length === 1 && sub[0].semver === ANY) {
        if (dom.length === 1 && dom[0].semver === ANY)
          return true;
        else if (options.includePrerelease)
          sub = [new Comparator(">=0.0.0-0")];
        else
          sub = [new Comparator(">=0.0.0")];
      }
      if (dom.length === 1 && dom[0].semver === ANY) {
        if (options.includePrerelease)
          return true;
        else
          dom = [new Comparator(">=0.0.0")];
      }
      const eqSet = /* @__PURE__ */ new Set();
      let gt, lt;
      for (const c of sub) {
        if (c.operator === ">" || c.operator === ">=")
          gt = higherGT(gt, c, options);
        else if (c.operator === "<" || c.operator === "<=")
          lt = lowerLT(lt, c, options);
        else
          eqSet.add(c.semver);
      }
      if (eqSet.size > 1)
        return null;
      let gtltComp;
      if (gt && lt) {
        gtltComp = compare(gt.semver, lt.semver, options);
        if (gtltComp > 0)
          return null;
        else if (gtltComp === 0 && (gt.operator !== ">=" || lt.operator !== "<="))
          return null;
      }
      for (const eq of eqSet) {
        if (gt && !satisfies(eq, String(gt), options))
          return null;
        if (lt && !satisfies(eq, String(lt), options))
          return null;
        for (const c of dom) {
          if (!satisfies(eq, String(c), options))
            return false;
        }
        return true;
      }
      let higher, lower;
      let hasDomLT, hasDomGT;
      let needDomLTPre = lt && !options.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
      let needDomGTPre = gt && !options.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
      if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === "<" && needDomLTPre.prerelease[0] === 0) {
        needDomLTPre = false;
      }
      for (const c of dom) {
        hasDomGT = hasDomGT || c.operator === ">" || c.operator === ">=";
        hasDomLT = hasDomLT || c.operator === "<" || c.operator === "<=";
        if (gt) {
          if (needDomGTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomGTPre.major && c.semver.minor === needDomGTPre.minor && c.semver.patch === needDomGTPre.patch) {
              needDomGTPre = false;
            }
          }
          if (c.operator === ">" || c.operator === ">=") {
            higher = higherGT(gt, c, options);
            if (higher === c && higher !== gt)
              return false;
          } else if (gt.operator === ">=" && !satisfies(gt.semver, String(c), options))
            return false;
        }
        if (lt) {
          if (needDomLTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomLTPre.major && c.semver.minor === needDomLTPre.minor && c.semver.patch === needDomLTPre.patch) {
              needDomLTPre = false;
            }
          }
          if (c.operator === "<" || c.operator === "<=") {
            lower = lowerLT(lt, c, options);
            if (lower === c && lower !== lt)
              return false;
          } else if (lt.operator === "<=" && !satisfies(lt.semver, String(c), options))
            return false;
        }
        if (!c.operator && (lt || gt) && gtltComp !== 0)
          return false;
      }
      if (gt && hasDomLT && !lt && gtltComp !== 0)
        return false;
      if (lt && hasDomGT && !gt && gtltComp !== 0)
        return false;
      if (needDomGTPre || needDomLTPre)
        return false;
      return true;
    };
    var higherGT = (a, b, options) => {
      if (!a)
        return b;
      const comp = compare(a.semver, b.semver, options);
      return comp > 0 ? a : comp < 0 ? b : b.operator === ">" && a.operator === ">=" ? b : a;
    };
    var lowerLT = (a, b, options) => {
      if (!a)
        return b;
      const comp = compare(a.semver, b.semver, options);
      return comp < 0 ? a : comp > 0 ? b : b.operator === "<" && a.operator === "<=" ? b : a;
    };
    module2.exports = subset;
  }
});

// node_modules/semver/index.js
var require_semver2 = __commonJS({
  "node_modules/semver/index.js"(exports, module2) {
    var internalRe = require_re();
    module2.exports = {
      re: internalRe.re,
      src: internalRe.src,
      tokens: internalRe.t,
      SEMVER_SPEC_VERSION: require_constants().SEMVER_SPEC_VERSION,
      SemVer: require_semver(),
      compareIdentifiers: require_identifiers().compareIdentifiers,
      rcompareIdentifiers: require_identifiers().rcompareIdentifiers,
      parse: require_parse(),
      valid: require_valid(),
      clean: require_clean(),
      inc: require_inc(),
      diff: require_diff(),
      major: require_major(),
      minor: require_minor(),
      patch: require_patch(),
      prerelease: require_prerelease(),
      compare: require_compare(),
      rcompare: require_rcompare(),
      compareLoose: require_compare_loose(),
      compareBuild: require_compare_build(),
      sort: require_sort(),
      rsort: require_rsort(),
      gt: require_gt(),
      lt: require_lt(),
      eq: require_eq(),
      neq: require_neq(),
      gte: require_gte(),
      lte: require_lte(),
      cmp: require_cmp(),
      coerce: require_coerce(),
      Comparator: require_comparator(),
      Range: require_range(),
      satisfies: require_satisfies(),
      toComparators: require_to_comparators(),
      maxSatisfying: require_max_satisfying(),
      minSatisfying: require_min_satisfying(),
      minVersion: require_min_version(),
      validRange: require_valid2(),
      outside: require_outside(),
      gtr: require_gtr(),
      ltr: require_ltr(),
      intersects: require_intersects(),
      simplifyRange: require_simplify(),
      subset: require_subset()
    };
  }
});

// node_modules/readable-stream/lib/internal/streams/stream.js
var require_stream = __commonJS({
  "node_modules/readable-stream/lib/internal/streams/stream.js"(exports, module2) {
    module2.exports = require("stream");
  }
});

// node_modules/readable-stream/lib/internal/streams/buffer_list.js
var require_buffer_list = __commonJS({
  "node_modules/readable-stream/lib/internal/streams/buffer_list.js"(exports, module2) {
    "use strict";
    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);
      if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly)
          symbols = symbols.filter(function(sym) {
            return Object.getOwnPropertyDescriptor(object, sym).enumerable;
          });
        keys.push.apply(keys, symbols);
      }
      return keys;
    }
    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};
        if (i % 2) {
          ownKeys(Object(source), true).forEach(function(key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function(key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }
      return target;
    }
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps)
        _defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        _defineProperties(Constructor, staticProps);
      return Constructor;
    }
    var _require = require("buffer");
    var Buffer2 = _require.Buffer;
    var _require2 = require("util");
    var inspect = _require2.inspect;
    var custom = inspect && inspect.custom || "inspect";
    function copyBuffer(src, target, offset) {
      Buffer2.prototype.copy.call(src, target, offset);
    }
    module2.exports = /* @__PURE__ */ function() {
      function BufferList() {
        _classCallCheck(this, BufferList);
        this.head = null;
        this.tail = null;
        this.length = 0;
      }
      _createClass(BufferList, [{
        key: "push",
        value: function push(v) {
          var entry = {
            data: v,
            next: null
          };
          if (this.length > 0)
            this.tail.next = entry;
          else
            this.head = entry;
          this.tail = entry;
          ++this.length;
        }
      }, {
        key: "unshift",
        value: function unshift(v) {
          var entry = {
            data: v,
            next: this.head
          };
          if (this.length === 0)
            this.tail = entry;
          this.head = entry;
          ++this.length;
        }
      }, {
        key: "shift",
        value: function shift() {
          if (this.length === 0)
            return;
          var ret = this.head.data;
          if (this.length === 1)
            this.head = this.tail = null;
          else
            this.head = this.head.next;
          --this.length;
          return ret;
        }
      }, {
        key: "clear",
        value: function clear() {
          this.head = this.tail = null;
          this.length = 0;
        }
      }, {
        key: "join",
        value: function join(s) {
          if (this.length === 0)
            return "";
          var p = this.head;
          var ret = "" + p.data;
          while (p = p.next) {
            ret += s + p.data;
          }
          return ret;
        }
      }, {
        key: "concat",
        value: function concat(n) {
          if (this.length === 0)
            return Buffer2.alloc(0);
          var ret = Buffer2.allocUnsafe(n >>> 0);
          var p = this.head;
          var i = 0;
          while (p) {
            copyBuffer(p.data, ret, i);
            i += p.data.length;
            p = p.next;
          }
          return ret;
        }
      }, {
        key: "consume",
        value: function consume(n, hasStrings) {
          var ret;
          if (n < this.head.data.length) {
            ret = this.head.data.slice(0, n);
            this.head.data = this.head.data.slice(n);
          } else if (n === this.head.data.length) {
            ret = this.shift();
          } else {
            ret = hasStrings ? this._getString(n) : this._getBuffer(n);
          }
          return ret;
        }
      }, {
        key: "first",
        value: function first() {
          return this.head.data;
        }
      }, {
        key: "_getString",
        value: function _getString(n) {
          var p = this.head;
          var c = 1;
          var ret = p.data;
          n -= ret.length;
          while (p = p.next) {
            var str = p.data;
            var nb = n > str.length ? str.length : n;
            if (nb === str.length)
              ret += str;
            else
              ret += str.slice(0, n);
            n -= nb;
            if (n === 0) {
              if (nb === str.length) {
                ++c;
                if (p.next)
                  this.head = p.next;
                else
                  this.head = this.tail = null;
              } else {
                this.head = p;
                p.data = str.slice(nb);
              }
              break;
            }
            ++c;
          }
          this.length -= c;
          return ret;
        }
      }, {
        key: "_getBuffer",
        value: function _getBuffer(n) {
          var ret = Buffer2.allocUnsafe(n);
          var p = this.head;
          var c = 1;
          p.data.copy(ret);
          n -= p.data.length;
          while (p = p.next) {
            var buf = p.data;
            var nb = n > buf.length ? buf.length : n;
            buf.copy(ret, ret.length - n, 0, nb);
            n -= nb;
            if (n === 0) {
              if (nb === buf.length) {
                ++c;
                if (p.next)
                  this.head = p.next;
                else
                  this.head = this.tail = null;
              } else {
                this.head = p;
                p.data = buf.slice(nb);
              }
              break;
            }
            ++c;
          }
          this.length -= c;
          return ret;
        }
      }, {
        key: custom,
        value: function value(_, options) {
          return inspect(this, _objectSpread({}, options, {
            depth: 0,
            customInspect: false
          }));
        }
      }]);
      return BufferList;
    }();
  }
});

// node_modules/readable-stream/lib/internal/streams/destroy.js
var require_destroy = __commonJS({
  "node_modules/readable-stream/lib/internal/streams/destroy.js"(exports, module2) {
    "use strict";
    function destroy(err, cb) {
      var _this = this;
      var readableDestroyed = this._readableState && this._readableState.destroyed;
      var writableDestroyed = this._writableState && this._writableState.destroyed;
      if (readableDestroyed || writableDestroyed) {
        if (cb) {
          cb(err);
        } else if (err) {
          if (!this._writableState) {
            process.nextTick(emitErrorNT, this, err);
          } else if (!this._writableState.errorEmitted) {
            this._writableState.errorEmitted = true;
            process.nextTick(emitErrorNT, this, err);
          }
        }
        return this;
      }
      if (this._readableState) {
        this._readableState.destroyed = true;
      }
      if (this._writableState) {
        this._writableState.destroyed = true;
      }
      this._destroy(err || null, function(err2) {
        if (!cb && err2) {
          if (!_this._writableState) {
            process.nextTick(emitErrorAndCloseNT, _this, err2);
          } else if (!_this._writableState.errorEmitted) {
            _this._writableState.errorEmitted = true;
            process.nextTick(emitErrorAndCloseNT, _this, err2);
          } else {
            process.nextTick(emitCloseNT, _this);
          }
        } else if (cb) {
          process.nextTick(emitCloseNT, _this);
          cb(err2);
        } else {
          process.nextTick(emitCloseNT, _this);
        }
      });
      return this;
    }
    function emitErrorAndCloseNT(self, err) {
      emitErrorNT(self, err);
      emitCloseNT(self);
    }
    function emitCloseNT(self) {
      if (self._writableState && !self._writableState.emitClose)
        return;
      if (self._readableState && !self._readableState.emitClose)
        return;
      self.emit("close");
    }
    function undestroy() {
      if (this._readableState) {
        this._readableState.destroyed = false;
        this._readableState.reading = false;
        this._readableState.ended = false;
        this._readableState.endEmitted = false;
      }
      if (this._writableState) {
        this._writableState.destroyed = false;
        this._writableState.ended = false;
        this._writableState.ending = false;
        this._writableState.finalCalled = false;
        this._writableState.prefinished = false;
        this._writableState.finished = false;
        this._writableState.errorEmitted = false;
      }
    }
    function emitErrorNT(self, err) {
      self.emit("error", err);
    }
    function errorOrDestroy(stream, err) {
      var rState = stream._readableState;
      var wState = stream._writableState;
      if (rState && rState.autoDestroy || wState && wState.autoDestroy)
        stream.destroy(err);
      else
        stream.emit("error", err);
    }
    module2.exports = {
      destroy,
      undestroy,
      errorOrDestroy
    };
  }
});

// node_modules/readable-stream/errors.js
var require_errors = __commonJS({
  "node_modules/readable-stream/errors.js"(exports, module2) {
    "use strict";
    var codes = {};
    function createErrorType(code, message, Base) {
      if (!Base) {
        Base = Error;
      }
      function getMessage(arg1, arg2, arg3) {
        if (typeof message === "string") {
          return message;
        } else {
          return message(arg1, arg2, arg3);
        }
      }
      class NodeError extends Base {
        constructor(arg1, arg2, arg3) {
          super(getMessage(arg1, arg2, arg3));
        }
      }
      NodeError.prototype.name = Base.name;
      NodeError.prototype.code = code;
      codes[code] = NodeError;
    }
    function oneOf(expected, thing) {
      if (Array.isArray(expected)) {
        const len = expected.length;
        expected = expected.map((i) => String(i));
        if (len > 2) {
          return `one of ${thing} ${expected.slice(0, len - 1).join(", ")}, or ` + expected[len - 1];
        } else if (len === 2) {
          return `one of ${thing} ${expected[0]} or ${expected[1]}`;
        } else {
          return `of ${thing} ${expected[0]}`;
        }
      } else {
        return `of ${thing} ${String(expected)}`;
      }
    }
    function startsWith(str, search, pos) {
      return str.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;
    }
    function endsWith(str, search, this_len) {
      if (this_len === void 0 || this_len > str.length) {
        this_len = str.length;
      }
      return str.substring(this_len - search.length, this_len) === search;
    }
    function includes(str, search, start) {
      if (typeof start !== "number") {
        start = 0;
      }
      if (start + search.length > str.length) {
        return false;
      } else {
        return str.indexOf(search, start) !== -1;
      }
    }
    createErrorType("ERR_INVALID_OPT_VALUE", function(name, value) {
      return 'The value "' + value + '" is invalid for option "' + name + '"';
    }, TypeError);
    createErrorType("ERR_INVALID_ARG_TYPE", function(name, expected, actual) {
      let determiner;
      if (typeof expected === "string" && startsWith(expected, "not ")) {
        determiner = "must not be";
        expected = expected.replace(/^not /, "");
      } else {
        determiner = "must be";
      }
      let msg;
      if (endsWith(name, " argument")) {
        msg = `The ${name} ${determiner} ${oneOf(expected, "type")}`;
      } else {
        const type = includes(name, ".") ? "property" : "argument";
        msg = `The "${name}" ${type} ${determiner} ${oneOf(expected, "type")}`;
      }
      msg += `. Received type ${typeof actual}`;
      return msg;
    }, TypeError);
    createErrorType("ERR_STREAM_PUSH_AFTER_EOF", "stream.push() after EOF");
    createErrorType("ERR_METHOD_NOT_IMPLEMENTED", function(name) {
      return "The " + name + " method is not implemented";
    });
    createErrorType("ERR_STREAM_PREMATURE_CLOSE", "Premature close");
    createErrorType("ERR_STREAM_DESTROYED", function(name) {
      return "Cannot call " + name + " after a stream was destroyed";
    });
    createErrorType("ERR_MULTIPLE_CALLBACK", "Callback called multiple times");
    createErrorType("ERR_STREAM_CANNOT_PIPE", "Cannot pipe, not readable");
    createErrorType("ERR_STREAM_WRITE_AFTER_END", "write after end");
    createErrorType("ERR_STREAM_NULL_VALUES", "May not write null values to stream", TypeError);
    createErrorType("ERR_UNKNOWN_ENCODING", function(arg) {
      return "Unknown encoding: " + arg;
    }, TypeError);
    createErrorType("ERR_STREAM_UNSHIFT_AFTER_END_EVENT", "stream.unshift() after end event");
    module2.exports.codes = codes;
  }
});

// node_modules/readable-stream/lib/internal/streams/state.js
var require_state = __commonJS({
  "node_modules/readable-stream/lib/internal/streams/state.js"(exports, module2) {
    "use strict";
    var ERR_INVALID_OPT_VALUE = require_errors().codes.ERR_INVALID_OPT_VALUE;
    function highWaterMarkFrom(options, isDuplex, duplexKey) {
      return options.highWaterMark != null ? options.highWaterMark : isDuplex ? options[duplexKey] : null;
    }
    function getHighWaterMark(state, options, duplexKey, isDuplex) {
      var hwm = highWaterMarkFrom(options, isDuplex, duplexKey);
      if (hwm != null) {
        if (!(isFinite(hwm) && Math.floor(hwm) === hwm) || hwm < 0) {
          var name = isDuplex ? duplexKey : "highWaterMark";
          throw new ERR_INVALID_OPT_VALUE(name, hwm);
        }
        return Math.floor(hwm);
      }
      return state.objectMode ? 16 : 16 * 1024;
    }
    module2.exports = {
      getHighWaterMark
    };
  }
});

// node_modules/inherits/inherits_browser.js
var require_inherits_browser = __commonJS({
  "node_modules/inherits/inherits_browser.js"(exports, module2) {
    if (typeof Object.create === "function") {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        }
      };
    } else {
      module2.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = function() {
          };
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        }
      };
    }
  }
});

// node_modules/inherits/inherits.js
var require_inherits = __commonJS({
  "node_modules/inherits/inherits.js"(exports, module2) {
    try {
      util = require("util");
      if (typeof util.inherits !== "function")
        throw "";
      module2.exports = util.inherits;
    } catch (e) {
      module2.exports = require_inherits_browser();
    }
    var util;
  }
});

// node_modules/util-deprecate/node.js
var require_node = __commonJS({
  "node_modules/util-deprecate/node.js"(exports, module2) {
    module2.exports = require("util").deprecate;
  }
});

// node_modules/readable-stream/lib/_stream_writable.js
var require_stream_writable = __commonJS({
  "node_modules/readable-stream/lib/_stream_writable.js"(exports, module2) {
    "use strict";
    module2.exports = Writable;
    function CorkedRequest(state) {
      var _this = this;
      this.next = null;
      this.entry = null;
      this.finish = function() {
        onCorkedFinish(_this, state);
      };
    }
    var Duplex;
    Writable.WritableState = WritableState;
    var internalUtil = {
      deprecate: require_node()
    };
    var Stream = require_stream();
    var Buffer2 = require("buffer").Buffer;
    var OurUint8Array = global.Uint8Array || function() {
    };
    function _uint8ArrayToBuffer(chunk) {
      return Buffer2.from(chunk);
    }
    function _isUint8Array(obj) {
      return Buffer2.isBuffer(obj) || obj instanceof OurUint8Array;
    }
    var destroyImpl = require_destroy();
    var _require = require_state();
    var getHighWaterMark = _require.getHighWaterMark;
    var _require$codes = require_errors().codes;
    var ERR_INVALID_ARG_TYPE = _require$codes.ERR_INVALID_ARG_TYPE;
    var ERR_METHOD_NOT_IMPLEMENTED = _require$codes.ERR_METHOD_NOT_IMPLEMENTED;
    var ERR_MULTIPLE_CALLBACK = _require$codes.ERR_MULTIPLE_CALLBACK;
    var ERR_STREAM_CANNOT_PIPE = _require$codes.ERR_STREAM_CANNOT_PIPE;
    var ERR_STREAM_DESTROYED = _require$codes.ERR_STREAM_DESTROYED;
    var ERR_STREAM_NULL_VALUES = _require$codes.ERR_STREAM_NULL_VALUES;
    var ERR_STREAM_WRITE_AFTER_END = _require$codes.ERR_STREAM_WRITE_AFTER_END;
    var ERR_UNKNOWN_ENCODING = _require$codes.ERR_UNKNOWN_ENCODING;
    var errorOrDestroy = destroyImpl.errorOrDestroy;
    require_inherits()(Writable, Stream);
    function nop() {
    }
    function WritableState(options, stream, isDuplex) {
      Duplex = Duplex || require_stream_duplex();
      options = options || {};
      if (typeof isDuplex !== "boolean")
        isDuplex = stream instanceof Duplex;
      this.objectMode = !!options.objectMode;
      if (isDuplex)
        this.objectMode = this.objectMode || !!options.writableObjectMode;
      this.highWaterMark = getHighWaterMark(this, options, "writableHighWaterMark", isDuplex);
      this.finalCalled = false;
      this.needDrain = false;
      this.ending = false;
      this.ended = false;
      this.finished = false;
      this.destroyed = false;
      var noDecode = options.decodeStrings === false;
      this.decodeStrings = !noDecode;
      this.defaultEncoding = options.defaultEncoding || "utf8";
      this.length = 0;
      this.writing = false;
      this.corked = 0;
      this.sync = true;
      this.bufferProcessing = false;
      this.onwrite = function(er) {
        onwrite(stream, er);
      };
      this.writecb = null;
      this.writelen = 0;
      this.bufferedRequest = null;
      this.lastBufferedRequest = null;
      this.pendingcb = 0;
      this.prefinished = false;
      this.errorEmitted = false;
      this.emitClose = options.emitClose !== false;
      this.autoDestroy = !!options.autoDestroy;
      this.bufferedRequestCount = 0;
      this.corkedRequestsFree = new CorkedRequest(this);
    }
    WritableState.prototype.getBuffer = function getBuffer() {
      var current = this.bufferedRequest;
      var out = [];
      while (current) {
        out.push(current);
        current = current.next;
      }
      return out;
    };
    (function() {
      try {
        Object.defineProperty(WritableState.prototype, "buffer", {
          get: internalUtil.deprecate(function writableStateBufferGetter() {
            return this.getBuffer();
          }, "_writableState.buffer is deprecated. Use _writableState.getBuffer instead.", "DEP0003")
        });
      } catch (_) {
      }
    })();
    var realHasInstance;
    if (typeof Symbol === "function" && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === "function") {
      realHasInstance = Function.prototype[Symbol.hasInstance];
      Object.defineProperty(Writable, Symbol.hasInstance, {
        value: function value(object) {
          if (realHasInstance.call(this, object))
            return true;
          if (this !== Writable)
            return false;
          return object && object._writableState instanceof WritableState;
        }
      });
    } else {
      realHasInstance = function realHasInstance2(object) {
        return object instanceof this;
      };
    }
    function Writable(options) {
      Duplex = Duplex || require_stream_duplex();
      var isDuplex = this instanceof Duplex;
      if (!isDuplex && !realHasInstance.call(Writable, this))
        return new Writable(options);
      this._writableState = new WritableState(options, this, isDuplex);
      this.writable = true;
      if (options) {
        if (typeof options.write === "function")
          this._write = options.write;
        if (typeof options.writev === "function")
          this._writev = options.writev;
        if (typeof options.destroy === "function")
          this._destroy = options.destroy;
        if (typeof options.final === "function")
          this._final = options.final;
      }
      Stream.call(this);
    }
    Writable.prototype.pipe = function() {
      errorOrDestroy(this, new ERR_STREAM_CANNOT_PIPE());
    };
    function writeAfterEnd(stream, cb) {
      var er = new ERR_STREAM_WRITE_AFTER_END();
      errorOrDestroy(stream, er);
      process.nextTick(cb, er);
    }
    function validChunk(stream, state, chunk, cb) {
      var er;
      if (chunk === null) {
        er = new ERR_STREAM_NULL_VALUES();
      } else if (typeof chunk !== "string" && !state.objectMode) {
        er = new ERR_INVALID_ARG_TYPE("chunk", ["string", "Buffer"], chunk);
      }
      if (er) {
        errorOrDestroy(stream, er);
        process.nextTick(cb, er);
        return false;
      }
      return true;
    }
    Writable.prototype.write = function(chunk, encoding, cb) {
      var state = this._writableState;
      var ret = false;
      var isBuf = !state.objectMode && _isUint8Array(chunk);
      if (isBuf && !Buffer2.isBuffer(chunk)) {
        chunk = _uint8ArrayToBuffer(chunk);
      }
      if (typeof encoding === "function") {
        cb = encoding;
        encoding = null;
      }
      if (isBuf)
        encoding = "buffer";
      else if (!encoding)
        encoding = state.defaultEncoding;
      if (typeof cb !== "function")
        cb = nop;
      if (state.ending)
        writeAfterEnd(this, cb);
      else if (isBuf || validChunk(this, state, chunk, cb)) {
        state.pendingcb++;
        ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
      }
      return ret;
    };
    Writable.prototype.cork = function() {
      this._writableState.corked++;
    };
    Writable.prototype.uncork = function() {
      var state = this._writableState;
      if (state.corked) {
        state.corked--;
        if (!state.writing && !state.corked && !state.bufferProcessing && state.bufferedRequest)
          clearBuffer(this, state);
      }
    };
    Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
      if (typeof encoding === "string")
        encoding = encoding.toLowerCase();
      if (!(["hex", "utf8", "utf-8", "ascii", "binary", "base64", "ucs2", "ucs-2", "utf16le", "utf-16le", "raw"].indexOf((encoding + "").toLowerCase()) > -1))
        throw new ERR_UNKNOWN_ENCODING(encoding);
      this._writableState.defaultEncoding = encoding;
      return this;
    };
    Object.defineProperty(Writable.prototype, "writableBuffer", {
      enumerable: false,
      get: function get() {
        return this._writableState && this._writableState.getBuffer();
      }
    });
    function decodeChunk(state, chunk, encoding) {
      if (!state.objectMode && state.decodeStrings !== false && typeof chunk === "string") {
        chunk = Buffer2.from(chunk, encoding);
      }
      return chunk;
    }
    Object.defineProperty(Writable.prototype, "writableHighWaterMark", {
      enumerable: false,
      get: function get() {
        return this._writableState.highWaterMark;
      }
    });
    function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
      if (!isBuf) {
        var newChunk = decodeChunk(state, chunk, encoding);
        if (chunk !== newChunk) {
          isBuf = true;
          encoding = "buffer";
          chunk = newChunk;
        }
      }
      var len = state.objectMode ? 1 : chunk.length;
      state.length += len;
      var ret = state.length < state.highWaterMark;
      if (!ret)
        state.needDrain = true;
      if (state.writing || state.corked) {
        var last = state.lastBufferedRequest;
        state.lastBufferedRequest = {
          chunk,
          encoding,
          isBuf,
          callback: cb,
          next: null
        };
        if (last) {
          last.next = state.lastBufferedRequest;
        } else {
          state.bufferedRequest = state.lastBufferedRequest;
        }
        state.bufferedRequestCount += 1;
      } else {
        doWrite(stream, state, false, len, chunk, encoding, cb);
      }
      return ret;
    }
    function doWrite(stream, state, writev, len, chunk, encoding, cb) {
      state.writelen = len;
      state.writecb = cb;
      state.writing = true;
      state.sync = true;
      if (state.destroyed)
        state.onwrite(new ERR_STREAM_DESTROYED("write"));
      else if (writev)
        stream._writev(chunk, state.onwrite);
      else
        stream._write(chunk, encoding, state.onwrite);
      state.sync = false;
    }
    function onwriteError(stream, state, sync, er, cb) {
      --state.pendingcb;
      if (sync) {
        process.nextTick(cb, er);
        process.nextTick(finishMaybe, stream, state);
        stream._writableState.errorEmitted = true;
        errorOrDestroy(stream, er);
      } else {
        cb(er);
        stream._writableState.errorEmitted = true;
        errorOrDestroy(stream, er);
        finishMaybe(stream, state);
      }
    }
    function onwriteStateUpdate(state) {
      state.writing = false;
      state.writecb = null;
      state.length -= state.writelen;
      state.writelen = 0;
    }
    function onwrite(stream, er) {
      var state = stream._writableState;
      var sync = state.sync;
      var cb = state.writecb;
      if (typeof cb !== "function")
        throw new ERR_MULTIPLE_CALLBACK();
      onwriteStateUpdate(state);
      if (er)
        onwriteError(stream, state, sync, er, cb);
      else {
        var finished = needFinish(state) || stream.destroyed;
        if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
          clearBuffer(stream, state);
        }
        if (sync) {
          process.nextTick(afterWrite, stream, state, finished, cb);
        } else {
          afterWrite(stream, state, finished, cb);
        }
      }
    }
    function afterWrite(stream, state, finished, cb) {
      if (!finished)
        onwriteDrain(stream, state);
      state.pendingcb--;
      cb();
      finishMaybe(stream, state);
    }
    function onwriteDrain(stream, state) {
      if (state.length === 0 && state.needDrain) {
        state.needDrain = false;
        stream.emit("drain");
      }
    }
    function clearBuffer(stream, state) {
      state.bufferProcessing = true;
      var entry = state.bufferedRequest;
      if (stream._writev && entry && entry.next) {
        var l = state.bufferedRequestCount;
        var buffer = new Array(l);
        var holder = state.corkedRequestsFree;
        holder.entry = entry;
        var count = 0;
        var allBuffers = true;
        while (entry) {
          buffer[count] = entry;
          if (!entry.isBuf)
            allBuffers = false;
          entry = entry.next;
          count += 1;
        }
        buffer.allBuffers = allBuffers;
        doWrite(stream, state, true, state.length, buffer, "", holder.finish);
        state.pendingcb++;
        state.lastBufferedRequest = null;
        if (holder.next) {
          state.corkedRequestsFree = holder.next;
          holder.next = null;
        } else {
          state.corkedRequestsFree = new CorkedRequest(state);
        }
        state.bufferedRequestCount = 0;
      } else {
        while (entry) {
          var chunk = entry.chunk;
          var encoding = entry.encoding;
          var cb = entry.callback;
          var len = state.objectMode ? 1 : chunk.length;
          doWrite(stream, state, false, len, chunk, encoding, cb);
          entry = entry.next;
          state.bufferedRequestCount--;
          if (state.writing) {
            break;
          }
        }
        if (entry === null)
          state.lastBufferedRequest = null;
      }
      state.bufferedRequest = entry;
      state.bufferProcessing = false;
    }
    Writable.prototype._write = function(chunk, encoding, cb) {
      cb(new ERR_METHOD_NOT_IMPLEMENTED("_write()"));
    };
    Writable.prototype._writev = null;
    Writable.prototype.end = function(chunk, encoding, cb) {
      var state = this._writableState;
      if (typeof chunk === "function") {
        cb = chunk;
        chunk = null;
        encoding = null;
      } else if (typeof encoding === "function") {
        cb = encoding;
        encoding = null;
      }
      if (chunk !== null && chunk !== void 0)
        this.write(chunk, encoding);
      if (state.corked) {
        state.corked = 1;
        this.uncork();
      }
      if (!state.ending)
        endWritable(this, state, cb);
      return this;
    };
    Object.defineProperty(Writable.prototype, "writableLength", {
      enumerable: false,
      get: function get() {
        return this._writableState.length;
      }
    });
    function needFinish(state) {
      return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
    }
    function callFinal(stream, state) {
      stream._final(function(err) {
        state.pendingcb--;
        if (err) {
          errorOrDestroy(stream, err);
        }
        state.prefinished = true;
        stream.emit("prefinish");
        finishMaybe(stream, state);
      });
    }
    function prefinish(stream, state) {
      if (!state.prefinished && !state.finalCalled) {
        if (typeof stream._final === "function" && !state.destroyed) {
          state.pendingcb++;
          state.finalCalled = true;
          process.nextTick(callFinal, stream, state);
        } else {
          state.prefinished = true;
          stream.emit("prefinish");
        }
      }
    }
    function finishMaybe(stream, state) {
      var need = needFinish(state);
      if (need) {
        prefinish(stream, state);
        if (state.pendingcb === 0) {
          state.finished = true;
          stream.emit("finish");
          if (state.autoDestroy) {
            var rState = stream._readableState;
            if (!rState || rState.autoDestroy && rState.endEmitted) {
              stream.destroy();
            }
          }
        }
      }
      return need;
    }
    function endWritable(stream, state, cb) {
      state.ending = true;
      finishMaybe(stream, state);
      if (cb) {
        if (state.finished)
          process.nextTick(cb);
        else
          stream.once("finish", cb);
      }
      state.ended = true;
      stream.writable = false;
    }
    function onCorkedFinish(corkReq, state, err) {
      var entry = corkReq.entry;
      corkReq.entry = null;
      while (entry) {
        var cb = entry.callback;
        state.pendingcb--;
        cb(err);
        entry = entry.next;
      }
      state.corkedRequestsFree.next = corkReq;
    }
    Object.defineProperty(Writable.prototype, "destroyed", {
      enumerable: false,
      get: function get() {
        if (this._writableState === void 0) {
          return false;
        }
        return this._writableState.destroyed;
      },
      set: function set(value) {
        if (!this._writableState) {
          return;
        }
        this._writableState.destroyed = value;
      }
    });
    Writable.prototype.destroy = destroyImpl.destroy;
    Writable.prototype._undestroy = destroyImpl.undestroy;
    Writable.prototype._destroy = function(err, cb) {
      cb(err);
    };
  }
});

// node_modules/readable-stream/lib/_stream_duplex.js
var require_stream_duplex = __commonJS({
  "node_modules/readable-stream/lib/_stream_duplex.js"(exports, module2) {
    "use strict";
    var objectKeys = Object.keys || function(obj) {
      var keys2 = [];
      for (var key in obj) {
        keys2.push(key);
      }
      return keys2;
    };
    module2.exports = Duplex;
    var Readable = require_stream_readable();
    var Writable = require_stream_writable();
    require_inherits()(Duplex, Readable);
    {
      keys = objectKeys(Writable.prototype);
      for (v = 0; v < keys.length; v++) {
        method = keys[v];
        if (!Duplex.prototype[method])
          Duplex.prototype[method] = Writable.prototype[method];
      }
    }
    var keys;
    var method;
    var v;
    function Duplex(options) {
      if (!(this instanceof Duplex))
        return new Duplex(options);
      Readable.call(this, options);
      Writable.call(this, options);
      this.allowHalfOpen = true;
      if (options) {
        if (options.readable === false)
          this.readable = false;
        if (options.writable === false)
          this.writable = false;
        if (options.allowHalfOpen === false) {
          this.allowHalfOpen = false;
          this.once("end", onend);
        }
      }
    }
    Object.defineProperty(Duplex.prototype, "writableHighWaterMark", {
      enumerable: false,
      get: function get() {
        return this._writableState.highWaterMark;
      }
    });
    Object.defineProperty(Duplex.prototype, "writableBuffer", {
      enumerable: false,
      get: function get() {
        return this._writableState && this._writableState.getBuffer();
      }
    });
    Object.defineProperty(Duplex.prototype, "writableLength", {
      enumerable: false,
      get: function get() {
        return this._writableState.length;
      }
    });
    function onend() {
      if (this._writableState.ended)
        return;
      process.nextTick(onEndNT, this);
    }
    function onEndNT(self) {
      self.end();
    }
    Object.defineProperty(Duplex.prototype, "destroyed", {
      enumerable: false,
      get: function get() {
        if (this._readableState === void 0 || this._writableState === void 0) {
          return false;
        }
        return this._readableState.destroyed && this._writableState.destroyed;
      },
      set: function set(value) {
        if (this._readableState === void 0 || this._writableState === void 0) {
          return;
        }
        this._readableState.destroyed = value;
        this._writableState.destroyed = value;
      }
    });
  }
});

// node_modules/safe-buffer/index.js
var require_safe_buffer = __commonJS({
  "node_modules/safe-buffer/index.js"(exports, module2) {
    var buffer = require("buffer");
    var Buffer2 = buffer.Buffer;
    function copyProps(src, dst) {
      for (var key in src) {
        dst[key] = src[key];
      }
    }
    if (Buffer2.from && Buffer2.alloc && Buffer2.allocUnsafe && Buffer2.allocUnsafeSlow) {
      module2.exports = buffer;
    } else {
      copyProps(buffer, exports);
      exports.Buffer = SafeBuffer;
    }
    function SafeBuffer(arg, encodingOrOffset, length) {
      return Buffer2(arg, encodingOrOffset, length);
    }
    SafeBuffer.prototype = Object.create(Buffer2.prototype);
    copyProps(Buffer2, SafeBuffer);
    SafeBuffer.from = function(arg, encodingOrOffset, length) {
      if (typeof arg === "number") {
        throw new TypeError("Argument must not be a number");
      }
      return Buffer2(arg, encodingOrOffset, length);
    };
    SafeBuffer.alloc = function(size, fill, encoding) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      var buf = Buffer2(size);
      if (fill !== void 0) {
        if (typeof encoding === "string") {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf;
    };
    SafeBuffer.allocUnsafe = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return Buffer2(size);
    };
    SafeBuffer.allocUnsafeSlow = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return buffer.SlowBuffer(size);
    };
  }
});

// node_modules/string_decoder/lib/string_decoder.js
var require_string_decoder = __commonJS({
  "node_modules/string_decoder/lib/string_decoder.js"(exports) {
    "use strict";
    var Buffer2 = require_safe_buffer().Buffer;
    var isEncoding = Buffer2.isEncoding || function(encoding) {
      encoding = "" + encoding;
      switch (encoding && encoding.toLowerCase()) {
        case "hex":
        case "utf8":
        case "utf-8":
        case "ascii":
        case "binary":
        case "base64":
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
        case "raw":
          return true;
        default:
          return false;
      }
    };
    function _normalizeEncoding(enc) {
      if (!enc)
        return "utf8";
      var retried;
      while (true) {
        switch (enc) {
          case "utf8":
          case "utf-8":
            return "utf8";
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return "utf16le";
          case "latin1":
          case "binary":
            return "latin1";
          case "base64":
          case "ascii":
          case "hex":
            return enc;
          default:
            if (retried)
              return;
            enc = ("" + enc).toLowerCase();
            retried = true;
        }
      }
    }
    function normalizeEncoding(enc) {
      var nenc = _normalizeEncoding(enc);
      if (typeof nenc !== "string" && (Buffer2.isEncoding === isEncoding || !isEncoding(enc)))
        throw new Error("Unknown encoding: " + enc);
      return nenc || enc;
    }
    exports.StringDecoder = StringDecoder;
    function StringDecoder(encoding) {
      this.encoding = normalizeEncoding(encoding);
      var nb;
      switch (this.encoding) {
        case "utf16le":
          this.text = utf16Text;
          this.end = utf16End;
          nb = 4;
          break;
        case "utf8":
          this.fillLast = utf8FillLast;
          nb = 4;
          break;
        case "base64":
          this.text = base64Text;
          this.end = base64End;
          nb = 3;
          break;
        default:
          this.write = simpleWrite;
          this.end = simpleEnd;
          return;
      }
      this.lastNeed = 0;
      this.lastTotal = 0;
      this.lastChar = Buffer2.allocUnsafe(nb);
    }
    StringDecoder.prototype.write = function(buf) {
      if (buf.length === 0)
        return "";
      var r;
      var i;
      if (this.lastNeed) {
        r = this.fillLast(buf);
        if (r === void 0)
          return "";
        i = this.lastNeed;
        this.lastNeed = 0;
      } else {
        i = 0;
      }
      if (i < buf.length)
        return r ? r + this.text(buf, i) : this.text(buf, i);
      return r || "";
    };
    StringDecoder.prototype.end = utf8End;
    StringDecoder.prototype.text = utf8Text;
    StringDecoder.prototype.fillLast = function(buf) {
      if (this.lastNeed <= buf.length) {
        buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
        return this.lastChar.toString(this.encoding, 0, this.lastTotal);
      }
      buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
      this.lastNeed -= buf.length;
    };
    function utf8CheckByte(byte) {
      if (byte <= 127)
        return 0;
      else if (byte >> 5 === 6)
        return 2;
      else if (byte >> 4 === 14)
        return 3;
      else if (byte >> 3 === 30)
        return 4;
      return byte >> 6 === 2 ? -1 : -2;
    }
    function utf8CheckIncomplete(self, buf, i) {
      var j = buf.length - 1;
      if (j < i)
        return 0;
      var nb = utf8CheckByte(buf[j]);
      if (nb >= 0) {
        if (nb > 0)
          self.lastNeed = nb - 1;
        return nb;
      }
      if (--j < i || nb === -2)
        return 0;
      nb = utf8CheckByte(buf[j]);
      if (nb >= 0) {
        if (nb > 0)
          self.lastNeed = nb - 2;
        return nb;
      }
      if (--j < i || nb === -2)
        return 0;
      nb = utf8CheckByte(buf[j]);
      if (nb >= 0) {
        if (nb > 0) {
          if (nb === 2)
            nb = 0;
          else
            self.lastNeed = nb - 3;
        }
        return nb;
      }
      return 0;
    }
    function utf8CheckExtraBytes(self, buf, p) {
      if ((buf[0] & 192) !== 128) {
        self.lastNeed = 0;
        return "\uFFFD";
      }
      if (self.lastNeed > 1 && buf.length > 1) {
        if ((buf[1] & 192) !== 128) {
          self.lastNeed = 1;
          return "\uFFFD";
        }
        if (self.lastNeed > 2 && buf.length > 2) {
          if ((buf[2] & 192) !== 128) {
            self.lastNeed = 2;
            return "\uFFFD";
          }
        }
      }
    }
    function utf8FillLast(buf) {
      var p = this.lastTotal - this.lastNeed;
      var r = utf8CheckExtraBytes(this, buf, p);
      if (r !== void 0)
        return r;
      if (this.lastNeed <= buf.length) {
        buf.copy(this.lastChar, p, 0, this.lastNeed);
        return this.lastChar.toString(this.encoding, 0, this.lastTotal);
      }
      buf.copy(this.lastChar, p, 0, buf.length);
      this.lastNeed -= buf.length;
    }
    function utf8Text(buf, i) {
      var total = utf8CheckIncomplete(this, buf, i);
      if (!this.lastNeed)
        return buf.toString("utf8", i);
      this.lastTotal = total;
      var end = buf.length - (total - this.lastNeed);
      buf.copy(this.lastChar, 0, end);
      return buf.toString("utf8", i, end);
    }
    function utf8End(buf) {
      var r = buf && buf.length ? this.write(buf) : "";
      if (this.lastNeed)
        return r + "\uFFFD";
      return r;
    }
    function utf16Text(buf, i) {
      if ((buf.length - i) % 2 === 0) {
        var r = buf.toString("utf16le", i);
        if (r) {
          var c = r.charCodeAt(r.length - 1);
          if (c >= 55296 && c <= 56319) {
            this.lastNeed = 2;
            this.lastTotal = 4;
            this.lastChar[0] = buf[buf.length - 2];
            this.lastChar[1] = buf[buf.length - 1];
            return r.slice(0, -1);
          }
        }
        return r;
      }
      this.lastNeed = 1;
      this.lastTotal = 2;
      this.lastChar[0] = buf[buf.length - 1];
      return buf.toString("utf16le", i, buf.length - 1);
    }
    function utf16End(buf) {
      var r = buf && buf.length ? this.write(buf) : "";
      if (this.lastNeed) {
        var end = this.lastTotal - this.lastNeed;
        return r + this.lastChar.toString("utf16le", 0, end);
      }
      return r;
    }
    function base64Text(buf, i) {
      var n = (buf.length - i) % 3;
      if (n === 0)
        return buf.toString("base64", i);
      this.lastNeed = 3 - n;
      this.lastTotal = 3;
      if (n === 1) {
        this.lastChar[0] = buf[buf.length - 1];
      } else {
        this.lastChar[0] = buf[buf.length - 2];
        this.lastChar[1] = buf[buf.length - 1];
      }
      return buf.toString("base64", i, buf.length - n);
    }
    function base64End(buf) {
      var r = buf && buf.length ? this.write(buf) : "";
      if (this.lastNeed)
        return r + this.lastChar.toString("base64", 0, 3 - this.lastNeed);
      return r;
    }
    function simpleWrite(buf) {
      return buf.toString(this.encoding);
    }
    function simpleEnd(buf) {
      return buf && buf.length ? this.write(buf) : "";
    }
  }
});

// node_modules/readable-stream/lib/internal/streams/end-of-stream.js
var require_end_of_stream = __commonJS({
  "node_modules/readable-stream/lib/internal/streams/end-of-stream.js"(exports, module2) {
    "use strict";
    var ERR_STREAM_PREMATURE_CLOSE = require_errors().codes.ERR_STREAM_PREMATURE_CLOSE;
    function once(callback) {
      var called = false;
      return function() {
        if (called)
          return;
        called = true;
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        callback.apply(this, args);
      };
    }
    function noop() {
    }
    function isRequest(stream) {
      return stream.setHeader && typeof stream.abort === "function";
    }
    function eos(stream, opts, callback) {
      if (typeof opts === "function")
        return eos(stream, null, opts);
      if (!opts)
        opts = {};
      callback = once(callback || noop);
      var readable = opts.readable || opts.readable !== false && stream.readable;
      var writable = opts.writable || opts.writable !== false && stream.writable;
      var onlegacyfinish = function onlegacyfinish2() {
        if (!stream.writable)
          onfinish();
      };
      var writableEnded = stream._writableState && stream._writableState.finished;
      var onfinish = function onfinish2() {
        writable = false;
        writableEnded = true;
        if (!readable)
          callback.call(stream);
      };
      var readableEnded = stream._readableState && stream._readableState.endEmitted;
      var onend = function onend2() {
        readable = false;
        readableEnded = true;
        if (!writable)
          callback.call(stream);
      };
      var onerror = function onerror2(err) {
        callback.call(stream, err);
      };
      var onclose = function onclose2() {
        var err;
        if (readable && !readableEnded) {
          if (!stream._readableState || !stream._readableState.ended)
            err = new ERR_STREAM_PREMATURE_CLOSE();
          return callback.call(stream, err);
        }
        if (writable && !writableEnded) {
          if (!stream._writableState || !stream._writableState.ended)
            err = new ERR_STREAM_PREMATURE_CLOSE();
          return callback.call(stream, err);
        }
      };
      var onrequest = function onrequest2() {
        stream.req.on("finish", onfinish);
      };
      if (isRequest(stream)) {
        stream.on("complete", onfinish);
        stream.on("abort", onclose);
        if (stream.req)
          onrequest();
        else
          stream.on("request", onrequest);
      } else if (writable && !stream._writableState) {
        stream.on("end", onlegacyfinish);
        stream.on("close", onlegacyfinish);
      }
      stream.on("end", onend);
      stream.on("finish", onfinish);
      if (opts.error !== false)
        stream.on("error", onerror);
      stream.on("close", onclose);
      return function() {
        stream.removeListener("complete", onfinish);
        stream.removeListener("abort", onclose);
        stream.removeListener("request", onrequest);
        if (stream.req)
          stream.req.removeListener("finish", onfinish);
        stream.removeListener("end", onlegacyfinish);
        stream.removeListener("close", onlegacyfinish);
        stream.removeListener("finish", onfinish);
        stream.removeListener("end", onend);
        stream.removeListener("error", onerror);
        stream.removeListener("close", onclose);
      };
    }
    module2.exports = eos;
  }
});

// node_modules/readable-stream/lib/internal/streams/async_iterator.js
var require_async_iterator = __commonJS({
  "node_modules/readable-stream/lib/internal/streams/async_iterator.js"(exports, module2) {
    "use strict";
    var _Object$setPrototypeO;
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    var finished = require_end_of_stream();
    var kLastResolve = Symbol("lastResolve");
    var kLastReject = Symbol("lastReject");
    var kError = Symbol("error");
    var kEnded = Symbol("ended");
    var kLastPromise = Symbol("lastPromise");
    var kHandlePromise = Symbol("handlePromise");
    var kStream = Symbol("stream");
    function createIterResult(value, done) {
      return {
        value,
        done
      };
    }
    function readAndResolve(iter) {
      var resolve = iter[kLastResolve];
      if (resolve !== null) {
        var data = iter[kStream].read();
        if (data !== null) {
          iter[kLastPromise] = null;
          iter[kLastResolve] = null;
          iter[kLastReject] = null;
          resolve(createIterResult(data, false));
        }
      }
    }
    function onReadable(iter) {
      process.nextTick(readAndResolve, iter);
    }
    function wrapForNext(lastPromise, iter) {
      return function(resolve, reject) {
        lastPromise.then(function() {
          if (iter[kEnded]) {
            resolve(createIterResult(void 0, true));
            return;
          }
          iter[kHandlePromise](resolve, reject);
        }, reject);
      };
    }
    var AsyncIteratorPrototype = Object.getPrototypeOf(function() {
    });
    var ReadableStreamAsyncIteratorPrototype = Object.setPrototypeOf((_Object$setPrototypeO = {
      get stream() {
        return this[kStream];
      },
      next: function next() {
        var _this = this;
        var error = this[kError];
        if (error !== null) {
          return Promise.reject(error);
        }
        if (this[kEnded]) {
          return Promise.resolve(createIterResult(void 0, true));
        }
        if (this[kStream].destroyed) {
          return new Promise(function(resolve, reject) {
            process.nextTick(function() {
              if (_this[kError]) {
                reject(_this[kError]);
              } else {
                resolve(createIterResult(void 0, true));
              }
            });
          });
        }
        var lastPromise = this[kLastPromise];
        var promise;
        if (lastPromise) {
          promise = new Promise(wrapForNext(lastPromise, this));
        } else {
          var data = this[kStream].read();
          if (data !== null) {
            return Promise.resolve(createIterResult(data, false));
          }
          promise = new Promise(this[kHandlePromise]);
        }
        this[kLastPromise] = promise;
        return promise;
      }
    }, _defineProperty(_Object$setPrototypeO, Symbol.asyncIterator, function() {
      return this;
    }), _defineProperty(_Object$setPrototypeO, "return", function _return() {
      var _this2 = this;
      return new Promise(function(resolve, reject) {
        _this2[kStream].destroy(null, function(err) {
          if (err) {
            reject(err);
            return;
          }
          resolve(createIterResult(void 0, true));
        });
      });
    }), _Object$setPrototypeO), AsyncIteratorPrototype);
    var createReadableStreamAsyncIterator = function createReadableStreamAsyncIterator2(stream) {
      var _Object$create;
      var iterator = Object.create(ReadableStreamAsyncIteratorPrototype, (_Object$create = {}, _defineProperty(_Object$create, kStream, {
        value: stream,
        writable: true
      }), _defineProperty(_Object$create, kLastResolve, {
        value: null,
        writable: true
      }), _defineProperty(_Object$create, kLastReject, {
        value: null,
        writable: true
      }), _defineProperty(_Object$create, kError, {
        value: null,
        writable: true
      }), _defineProperty(_Object$create, kEnded, {
        value: stream._readableState.endEmitted,
        writable: true
      }), _defineProperty(_Object$create, kHandlePromise, {
        value: function value(resolve, reject) {
          var data = iterator[kStream].read();
          if (data) {
            iterator[kLastPromise] = null;
            iterator[kLastResolve] = null;
            iterator[kLastReject] = null;
            resolve(createIterResult(data, false));
          } else {
            iterator[kLastResolve] = resolve;
            iterator[kLastReject] = reject;
          }
        },
        writable: true
      }), _Object$create));
      iterator[kLastPromise] = null;
      finished(stream, function(err) {
        if (err && err.code !== "ERR_STREAM_PREMATURE_CLOSE") {
          var reject = iterator[kLastReject];
          if (reject !== null) {
            iterator[kLastPromise] = null;
            iterator[kLastResolve] = null;
            iterator[kLastReject] = null;
            reject(err);
          }
          iterator[kError] = err;
          return;
        }
        var resolve = iterator[kLastResolve];
        if (resolve !== null) {
          iterator[kLastPromise] = null;
          iterator[kLastResolve] = null;
          iterator[kLastReject] = null;
          resolve(createIterResult(void 0, true));
        }
        iterator[kEnded] = true;
      });
      stream.on("readable", onReadable.bind(null, iterator));
      return iterator;
    };
    module2.exports = createReadableStreamAsyncIterator;
  }
});

// node_modules/readable-stream/lib/internal/streams/from.js
var require_from = __commonJS({
  "node_modules/readable-stream/lib/internal/streams/from.js"(exports, module2) {
    "use strict";
    function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
      try {
        var info = gen[key](arg);
        var value = info.value;
      } catch (error) {
        reject(error);
        return;
      }
      if (info.done) {
        resolve(value);
      } else {
        Promise.resolve(value).then(_next, _throw);
      }
    }
    function _asyncToGenerator(fn) {
      return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
          var gen = fn.apply(self, args);
          function _next(value) {
            asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
          }
          function _throw(err) {
            asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
          }
          _next(void 0);
        });
      };
    }
    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);
      if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly)
          symbols = symbols.filter(function(sym) {
            return Object.getOwnPropertyDescriptor(object, sym).enumerable;
          });
        keys.push.apply(keys, symbols);
      }
      return keys;
    }
    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};
        if (i % 2) {
          ownKeys(Object(source), true).forEach(function(key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function(key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }
      return target;
    }
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    var ERR_INVALID_ARG_TYPE = require_errors().codes.ERR_INVALID_ARG_TYPE;
    function from(Readable, iterable, opts) {
      var iterator;
      if (iterable && typeof iterable.next === "function") {
        iterator = iterable;
      } else if (iterable && iterable[Symbol.asyncIterator])
        iterator = iterable[Symbol.asyncIterator]();
      else if (iterable && iterable[Symbol.iterator])
        iterator = iterable[Symbol.iterator]();
      else
        throw new ERR_INVALID_ARG_TYPE("iterable", ["Iterable"], iterable);
      var readable = new Readable(_objectSpread({
        objectMode: true
      }, opts));
      var reading = false;
      readable._read = function() {
        if (!reading) {
          reading = true;
          next();
        }
      };
      function next() {
        return _next2.apply(this, arguments);
      }
      function _next2() {
        _next2 = _asyncToGenerator(function* () {
          try {
            var _ref = yield iterator.next(), value = _ref.value, done = _ref.done;
            if (done) {
              readable.push(null);
            } else if (readable.push(yield value)) {
              next();
            } else {
              reading = false;
            }
          } catch (err) {
            readable.destroy(err);
          }
        });
        return _next2.apply(this, arguments);
      }
      return readable;
    }
    module2.exports = from;
  }
});

// node_modules/readable-stream/lib/_stream_readable.js
var require_stream_readable = __commonJS({
  "node_modules/readable-stream/lib/_stream_readable.js"(exports, module2) {
    "use strict";
    module2.exports = Readable;
    var Duplex;
    Readable.ReadableState = ReadableState;
    var EE = require("events").EventEmitter;
    var EElistenerCount = function EElistenerCount2(emitter, type) {
      return emitter.listeners(type).length;
    };
    var Stream = require_stream();
    var Buffer2 = require("buffer").Buffer;
    var OurUint8Array = global.Uint8Array || function() {
    };
    function _uint8ArrayToBuffer(chunk) {
      return Buffer2.from(chunk);
    }
    function _isUint8Array(obj) {
      return Buffer2.isBuffer(obj) || obj instanceof OurUint8Array;
    }
    var debugUtil = require("util");
    var debug;
    if (debugUtil && debugUtil.debuglog) {
      debug = debugUtil.debuglog("stream");
    } else {
      debug = function debug2() {
      };
    }
    var BufferList = require_buffer_list();
    var destroyImpl = require_destroy();
    var _require = require_state();
    var getHighWaterMark = _require.getHighWaterMark;
    var _require$codes = require_errors().codes;
    var ERR_INVALID_ARG_TYPE = _require$codes.ERR_INVALID_ARG_TYPE;
    var ERR_STREAM_PUSH_AFTER_EOF = _require$codes.ERR_STREAM_PUSH_AFTER_EOF;
    var ERR_METHOD_NOT_IMPLEMENTED = _require$codes.ERR_METHOD_NOT_IMPLEMENTED;
    var ERR_STREAM_UNSHIFT_AFTER_END_EVENT = _require$codes.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;
    var StringDecoder;
    var createReadableStreamAsyncIterator;
    var from;
    require_inherits()(Readable, Stream);
    var errorOrDestroy = destroyImpl.errorOrDestroy;
    var kProxyEvents = ["error", "close", "destroy", "pause", "resume"];
    function prependListener(emitter, event, fn) {
      if (typeof emitter.prependListener === "function")
        return emitter.prependListener(event, fn);
      if (!emitter._events || !emitter._events[event])
        emitter.on(event, fn);
      else if (Array.isArray(emitter._events[event]))
        emitter._events[event].unshift(fn);
      else
        emitter._events[event] = [fn, emitter._events[event]];
    }
    function ReadableState(options, stream, isDuplex) {
      Duplex = Duplex || require_stream_duplex();
      options = options || {};
      if (typeof isDuplex !== "boolean")
        isDuplex = stream instanceof Duplex;
      this.objectMode = !!options.objectMode;
      if (isDuplex)
        this.objectMode = this.objectMode || !!options.readableObjectMode;
      this.highWaterMark = getHighWaterMark(this, options, "readableHighWaterMark", isDuplex);
      this.buffer = new BufferList();
      this.length = 0;
      this.pipes = null;
      this.pipesCount = 0;
      this.flowing = null;
      this.ended = false;
      this.endEmitted = false;
      this.reading = false;
      this.sync = true;
      this.needReadable = false;
      this.emittedReadable = false;
      this.readableListening = false;
      this.resumeScheduled = false;
      this.paused = true;
      this.emitClose = options.emitClose !== false;
      this.autoDestroy = !!options.autoDestroy;
      this.destroyed = false;
      this.defaultEncoding = options.defaultEncoding || "utf8";
      this.awaitDrain = 0;
      this.readingMore = false;
      this.decoder = null;
      this.encoding = null;
      if (options.encoding) {
        if (!StringDecoder)
          StringDecoder = require_string_decoder().StringDecoder;
        this.decoder = new StringDecoder(options.encoding);
        this.encoding = options.encoding;
      }
    }
    function Readable(options) {
      Duplex = Duplex || require_stream_duplex();
      if (!(this instanceof Readable))
        return new Readable(options);
      var isDuplex = this instanceof Duplex;
      this._readableState = new ReadableState(options, this, isDuplex);
      this.readable = true;
      if (options) {
        if (typeof options.read === "function")
          this._read = options.read;
        if (typeof options.destroy === "function")
          this._destroy = options.destroy;
      }
      Stream.call(this);
    }
    Object.defineProperty(Readable.prototype, "destroyed", {
      enumerable: false,
      get: function get() {
        if (this._readableState === void 0) {
          return false;
        }
        return this._readableState.destroyed;
      },
      set: function set(value) {
        if (!this._readableState) {
          return;
        }
        this._readableState.destroyed = value;
      }
    });
    Readable.prototype.destroy = destroyImpl.destroy;
    Readable.prototype._undestroy = destroyImpl.undestroy;
    Readable.prototype._destroy = function(err, cb) {
      cb(err);
    };
    Readable.prototype.push = function(chunk, encoding) {
      var state = this._readableState;
      var skipChunkCheck;
      if (!state.objectMode) {
        if (typeof chunk === "string") {
          encoding = encoding || state.defaultEncoding;
          if (encoding !== state.encoding) {
            chunk = Buffer2.from(chunk, encoding);
            encoding = "";
          }
          skipChunkCheck = true;
        }
      } else {
        skipChunkCheck = true;
      }
      return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
    };
    Readable.prototype.unshift = function(chunk) {
      return readableAddChunk(this, chunk, null, true, false);
    };
    function readableAddChunk(stream, chunk, encoding, addToFront, skipChunkCheck) {
      debug("readableAddChunk", chunk);
      var state = stream._readableState;
      if (chunk === null) {
        state.reading = false;
        onEofChunk(stream, state);
      } else {
        var er;
        if (!skipChunkCheck)
          er = chunkInvalid(state, chunk);
        if (er) {
          errorOrDestroy(stream, er);
        } else if (state.objectMode || chunk && chunk.length > 0) {
          if (typeof chunk !== "string" && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer2.prototype) {
            chunk = _uint8ArrayToBuffer(chunk);
          }
          if (addToFront) {
            if (state.endEmitted)
              errorOrDestroy(stream, new ERR_STREAM_UNSHIFT_AFTER_END_EVENT());
            else
              addChunk(stream, state, chunk, true);
          } else if (state.ended) {
            errorOrDestroy(stream, new ERR_STREAM_PUSH_AFTER_EOF());
          } else if (state.destroyed) {
            return false;
          } else {
            state.reading = false;
            if (state.decoder && !encoding) {
              chunk = state.decoder.write(chunk);
              if (state.objectMode || chunk.length !== 0)
                addChunk(stream, state, chunk, false);
              else
                maybeReadMore(stream, state);
            } else {
              addChunk(stream, state, chunk, false);
            }
          }
        } else if (!addToFront) {
          state.reading = false;
          maybeReadMore(stream, state);
        }
      }
      return !state.ended && (state.length < state.highWaterMark || state.length === 0);
    }
    function addChunk(stream, state, chunk, addToFront) {
      if (state.flowing && state.length === 0 && !state.sync) {
        state.awaitDrain = 0;
        stream.emit("data", chunk);
      } else {
        state.length += state.objectMode ? 1 : chunk.length;
        if (addToFront)
          state.buffer.unshift(chunk);
        else
          state.buffer.push(chunk);
        if (state.needReadable)
          emitReadable(stream);
      }
      maybeReadMore(stream, state);
    }
    function chunkInvalid(state, chunk) {
      var er;
      if (!_isUint8Array(chunk) && typeof chunk !== "string" && chunk !== void 0 && !state.objectMode) {
        er = new ERR_INVALID_ARG_TYPE("chunk", ["string", "Buffer", "Uint8Array"], chunk);
      }
      return er;
    }
    Readable.prototype.isPaused = function() {
      return this._readableState.flowing === false;
    };
    Readable.prototype.setEncoding = function(enc) {
      if (!StringDecoder)
        StringDecoder = require_string_decoder().StringDecoder;
      var decoder = new StringDecoder(enc);
      this._readableState.decoder = decoder;
      this._readableState.encoding = this._readableState.decoder.encoding;
      var p = this._readableState.buffer.head;
      var content = "";
      while (p !== null) {
        content += decoder.write(p.data);
        p = p.next;
      }
      this._readableState.buffer.clear();
      if (content !== "")
        this._readableState.buffer.push(content);
      this._readableState.length = content.length;
      return this;
    };
    var MAX_HWM = 1073741824;
    function computeNewHighWaterMark(n) {
      if (n >= MAX_HWM) {
        n = MAX_HWM;
      } else {
        n--;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n++;
      }
      return n;
    }
    function howMuchToRead(n, state) {
      if (n <= 0 || state.length === 0 && state.ended)
        return 0;
      if (state.objectMode)
        return 1;
      if (n !== n) {
        if (state.flowing && state.length)
          return state.buffer.head.data.length;
        else
          return state.length;
      }
      if (n > state.highWaterMark)
        state.highWaterMark = computeNewHighWaterMark(n);
      if (n <= state.length)
        return n;
      if (!state.ended) {
        state.needReadable = true;
        return 0;
      }
      return state.length;
    }
    Readable.prototype.read = function(n) {
      debug("read", n);
      n = parseInt(n, 10);
      var state = this._readableState;
      var nOrig = n;
      if (n !== 0)
        state.emittedReadable = false;
      if (n === 0 && state.needReadable && ((state.highWaterMark !== 0 ? state.length >= state.highWaterMark : state.length > 0) || state.ended)) {
        debug("read: emitReadable", state.length, state.ended);
        if (state.length === 0 && state.ended)
          endReadable(this);
        else
          emitReadable(this);
        return null;
      }
      n = howMuchToRead(n, state);
      if (n === 0 && state.ended) {
        if (state.length === 0)
          endReadable(this);
        return null;
      }
      var doRead = state.needReadable;
      debug("need readable", doRead);
      if (state.length === 0 || state.length - n < state.highWaterMark) {
        doRead = true;
        debug("length less than watermark", doRead);
      }
      if (state.ended || state.reading) {
        doRead = false;
        debug("reading or ended", doRead);
      } else if (doRead) {
        debug("do read");
        state.reading = true;
        state.sync = true;
        if (state.length === 0)
          state.needReadable = true;
        this._read(state.highWaterMark);
        state.sync = false;
        if (!state.reading)
          n = howMuchToRead(nOrig, state);
      }
      var ret;
      if (n > 0)
        ret = fromList(n, state);
      else
        ret = null;
      if (ret === null) {
        state.needReadable = state.length <= state.highWaterMark;
        n = 0;
      } else {
        state.length -= n;
        state.awaitDrain = 0;
      }
      if (state.length === 0) {
        if (!state.ended)
          state.needReadable = true;
        if (nOrig !== n && state.ended)
          endReadable(this);
      }
      if (ret !== null)
        this.emit("data", ret);
      return ret;
    };
    function onEofChunk(stream, state) {
      debug("onEofChunk");
      if (state.ended)
        return;
      if (state.decoder) {
        var chunk = state.decoder.end();
        if (chunk && chunk.length) {
          state.buffer.push(chunk);
          state.length += state.objectMode ? 1 : chunk.length;
        }
      }
      state.ended = true;
      if (state.sync) {
        emitReadable(stream);
      } else {
        state.needReadable = false;
        if (!state.emittedReadable) {
          state.emittedReadable = true;
          emitReadable_(stream);
        }
      }
    }
    function emitReadable(stream) {
      var state = stream._readableState;
      debug("emitReadable", state.needReadable, state.emittedReadable);
      state.needReadable = false;
      if (!state.emittedReadable) {
        debug("emitReadable", state.flowing);
        state.emittedReadable = true;
        process.nextTick(emitReadable_, stream);
      }
    }
    function emitReadable_(stream) {
      var state = stream._readableState;
      debug("emitReadable_", state.destroyed, state.length, state.ended);
      if (!state.destroyed && (state.length || state.ended)) {
        stream.emit("readable");
        state.emittedReadable = false;
      }
      state.needReadable = !state.flowing && !state.ended && state.length <= state.highWaterMark;
      flow(stream);
    }
    function maybeReadMore(stream, state) {
      if (!state.readingMore) {
        state.readingMore = true;
        process.nextTick(maybeReadMore_, stream, state);
      }
    }
    function maybeReadMore_(stream, state) {
      while (!state.reading && !state.ended && (state.length < state.highWaterMark || state.flowing && state.length === 0)) {
        var len = state.length;
        debug("maybeReadMore read 0");
        stream.read(0);
        if (len === state.length)
          break;
      }
      state.readingMore = false;
    }
    Readable.prototype._read = function(n) {
      errorOrDestroy(this, new ERR_METHOD_NOT_IMPLEMENTED("_read()"));
    };
    Readable.prototype.pipe = function(dest, pipeOpts) {
      var src = this;
      var state = this._readableState;
      switch (state.pipesCount) {
        case 0:
          state.pipes = dest;
          break;
        case 1:
          state.pipes = [state.pipes, dest];
          break;
        default:
          state.pipes.push(dest);
          break;
      }
      state.pipesCount += 1;
      debug("pipe count=%d opts=%j", state.pipesCount, pipeOpts);
      var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;
      var endFn = doEnd ? onend : unpipe;
      if (state.endEmitted)
        process.nextTick(endFn);
      else
        src.once("end", endFn);
      dest.on("unpipe", onunpipe);
      function onunpipe(readable, unpipeInfo) {
        debug("onunpipe");
        if (readable === src) {
          if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
            unpipeInfo.hasUnpiped = true;
            cleanup();
          }
        }
      }
      function onend() {
        debug("onend");
        dest.end();
      }
      var ondrain = pipeOnDrain(src);
      dest.on("drain", ondrain);
      var cleanedUp = false;
      function cleanup() {
        debug("cleanup");
        dest.removeListener("close", onclose);
        dest.removeListener("finish", onfinish);
        dest.removeListener("drain", ondrain);
        dest.removeListener("error", onerror);
        dest.removeListener("unpipe", onunpipe);
        src.removeListener("end", onend);
        src.removeListener("end", unpipe);
        src.removeListener("data", ondata);
        cleanedUp = true;
        if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain))
          ondrain();
      }
      src.on("data", ondata);
      function ondata(chunk) {
        debug("ondata");
        var ret = dest.write(chunk);
        debug("dest.write", ret);
        if (ret === false) {
          if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
            debug("false write response, pause", state.awaitDrain);
            state.awaitDrain++;
          }
          src.pause();
        }
      }
      function onerror(er) {
        debug("onerror", er);
        unpipe();
        dest.removeListener("error", onerror);
        if (EElistenerCount(dest, "error") === 0)
          errorOrDestroy(dest, er);
      }
      prependListener(dest, "error", onerror);
      function onclose() {
        dest.removeListener("finish", onfinish);
        unpipe();
      }
      dest.once("close", onclose);
      function onfinish() {
        debug("onfinish");
        dest.removeListener("close", onclose);
        unpipe();
      }
      dest.once("finish", onfinish);
      function unpipe() {
        debug("unpipe");
        src.unpipe(dest);
      }
      dest.emit("pipe", src);
      if (!state.flowing) {
        debug("pipe resume");
        src.resume();
      }
      return dest;
    };
    function pipeOnDrain(src) {
      return function pipeOnDrainFunctionResult() {
        var state = src._readableState;
        debug("pipeOnDrain", state.awaitDrain);
        if (state.awaitDrain)
          state.awaitDrain--;
        if (state.awaitDrain === 0 && EElistenerCount(src, "data")) {
          state.flowing = true;
          flow(src);
        }
      };
    }
    Readable.prototype.unpipe = function(dest) {
      var state = this._readableState;
      var unpipeInfo = {
        hasUnpiped: false
      };
      if (state.pipesCount === 0)
        return this;
      if (state.pipesCount === 1) {
        if (dest && dest !== state.pipes)
          return this;
        if (!dest)
          dest = state.pipes;
        state.pipes = null;
        state.pipesCount = 0;
        state.flowing = false;
        if (dest)
          dest.emit("unpipe", this, unpipeInfo);
        return this;
      }
      if (!dest) {
        var dests = state.pipes;
        var len = state.pipesCount;
        state.pipes = null;
        state.pipesCount = 0;
        state.flowing = false;
        for (var i = 0; i < len; i++) {
          dests[i].emit("unpipe", this, {
            hasUnpiped: false
          });
        }
        return this;
      }
      var index = indexOf(state.pipes, dest);
      if (index === -1)
        return this;
      state.pipes.splice(index, 1);
      state.pipesCount -= 1;
      if (state.pipesCount === 1)
        state.pipes = state.pipes[0];
      dest.emit("unpipe", this, unpipeInfo);
      return this;
    };
    Readable.prototype.on = function(ev, fn) {
      var res = Stream.prototype.on.call(this, ev, fn);
      var state = this._readableState;
      if (ev === "data") {
        state.readableListening = this.listenerCount("readable") > 0;
        if (state.flowing !== false)
          this.resume();
      } else if (ev === "readable") {
        if (!state.endEmitted && !state.readableListening) {
          state.readableListening = state.needReadable = true;
          state.flowing = false;
          state.emittedReadable = false;
          debug("on readable", state.length, state.reading);
          if (state.length) {
            emitReadable(this);
          } else if (!state.reading) {
            process.nextTick(nReadingNextTick, this);
          }
        }
      }
      return res;
    };
    Readable.prototype.addListener = Readable.prototype.on;
    Readable.prototype.removeListener = function(ev, fn) {
      var res = Stream.prototype.removeListener.call(this, ev, fn);
      if (ev === "readable") {
        process.nextTick(updateReadableListening, this);
      }
      return res;
    };
    Readable.prototype.removeAllListeners = function(ev) {
      var res = Stream.prototype.removeAllListeners.apply(this, arguments);
      if (ev === "readable" || ev === void 0) {
        process.nextTick(updateReadableListening, this);
      }
      return res;
    };
    function updateReadableListening(self) {
      var state = self._readableState;
      state.readableListening = self.listenerCount("readable") > 0;
      if (state.resumeScheduled && !state.paused) {
        state.flowing = true;
      } else if (self.listenerCount("data") > 0) {
        self.resume();
      }
    }
    function nReadingNextTick(self) {
      debug("readable nexttick read 0");
      self.read(0);
    }
    Readable.prototype.resume = function() {
      var state = this._readableState;
      if (!state.flowing) {
        debug("resume");
        state.flowing = !state.readableListening;
        resume(this, state);
      }
      state.paused = false;
      return this;
    };
    function resume(stream, state) {
      if (!state.resumeScheduled) {
        state.resumeScheduled = true;
        process.nextTick(resume_, stream, state);
      }
    }
    function resume_(stream, state) {
      debug("resume", state.reading);
      if (!state.reading) {
        stream.read(0);
      }
      state.resumeScheduled = false;
      stream.emit("resume");
      flow(stream);
      if (state.flowing && !state.reading)
        stream.read(0);
    }
    Readable.prototype.pause = function() {
      debug("call pause flowing=%j", this._readableState.flowing);
      if (this._readableState.flowing !== false) {
        debug("pause");
        this._readableState.flowing = false;
        this.emit("pause");
      }
      this._readableState.paused = true;
      return this;
    };
    function flow(stream) {
      var state = stream._readableState;
      debug("flow", state.flowing);
      while (state.flowing && stream.read() !== null) {
        ;
      }
    }
    Readable.prototype.wrap = function(stream) {
      var _this = this;
      var state = this._readableState;
      var paused = false;
      stream.on("end", function() {
        debug("wrapped end");
        if (state.decoder && !state.ended) {
          var chunk = state.decoder.end();
          if (chunk && chunk.length)
            _this.push(chunk);
        }
        _this.push(null);
      });
      stream.on("data", function(chunk) {
        debug("wrapped data");
        if (state.decoder)
          chunk = state.decoder.write(chunk);
        if (state.objectMode && (chunk === null || chunk === void 0))
          return;
        else if (!state.objectMode && (!chunk || !chunk.length))
          return;
        var ret = _this.push(chunk);
        if (!ret) {
          paused = true;
          stream.pause();
        }
      });
      for (var i in stream) {
        if (this[i] === void 0 && typeof stream[i] === "function") {
          this[i] = function methodWrap(method) {
            return function methodWrapReturnFunction() {
              return stream[method].apply(stream, arguments);
            };
          }(i);
        }
      }
      for (var n = 0; n < kProxyEvents.length; n++) {
        stream.on(kProxyEvents[n], this.emit.bind(this, kProxyEvents[n]));
      }
      this._read = function(n2) {
        debug("wrapped _read", n2);
        if (paused) {
          paused = false;
          stream.resume();
        }
      };
      return this;
    };
    if (typeof Symbol === "function") {
      Readable.prototype[Symbol.asyncIterator] = function() {
        if (createReadableStreamAsyncIterator === void 0) {
          createReadableStreamAsyncIterator = require_async_iterator();
        }
        return createReadableStreamAsyncIterator(this);
      };
    }
    Object.defineProperty(Readable.prototype, "readableHighWaterMark", {
      enumerable: false,
      get: function get() {
        return this._readableState.highWaterMark;
      }
    });
    Object.defineProperty(Readable.prototype, "readableBuffer", {
      enumerable: false,
      get: function get() {
        return this._readableState && this._readableState.buffer;
      }
    });
    Object.defineProperty(Readable.prototype, "readableFlowing", {
      enumerable: false,
      get: function get() {
        return this._readableState.flowing;
      },
      set: function set(state) {
        if (this._readableState) {
          this._readableState.flowing = state;
        }
      }
    });
    Readable._fromList = fromList;
    Object.defineProperty(Readable.prototype, "readableLength", {
      enumerable: false,
      get: function get() {
        return this._readableState.length;
      }
    });
    function fromList(n, state) {
      if (state.length === 0)
        return null;
      var ret;
      if (state.objectMode)
        ret = state.buffer.shift();
      else if (!n || n >= state.length) {
        if (state.decoder)
          ret = state.buffer.join("");
        else if (state.buffer.length === 1)
          ret = state.buffer.first();
        else
          ret = state.buffer.concat(state.length);
        state.buffer.clear();
      } else {
        ret = state.buffer.consume(n, state.decoder);
      }
      return ret;
    }
    function endReadable(stream) {
      var state = stream._readableState;
      debug("endReadable", state.endEmitted);
      if (!state.endEmitted) {
        state.ended = true;
        process.nextTick(endReadableNT, state, stream);
      }
    }
    function endReadableNT(state, stream) {
      debug("endReadableNT", state.endEmitted, state.length);
      if (!state.endEmitted && state.length === 0) {
        state.endEmitted = true;
        stream.readable = false;
        stream.emit("end");
        if (state.autoDestroy) {
          var wState = stream._writableState;
          if (!wState || wState.autoDestroy && wState.finished) {
            stream.destroy();
          }
        }
      }
    }
    if (typeof Symbol === "function") {
      Readable.from = function(iterable, opts) {
        if (from === void 0) {
          from = require_from();
        }
        return from(Readable, iterable, opts);
      };
    }
    function indexOf(xs, x) {
      for (var i = 0, l = xs.length; i < l; i++) {
        if (xs[i] === x)
          return i;
      }
      return -1;
    }
  }
});

// node_modules/readable-stream/lib/_stream_transform.js
var require_stream_transform = __commonJS({
  "node_modules/readable-stream/lib/_stream_transform.js"(exports, module2) {
    "use strict";
    module2.exports = Transform;
    var _require$codes = require_errors().codes;
    var ERR_METHOD_NOT_IMPLEMENTED = _require$codes.ERR_METHOD_NOT_IMPLEMENTED;
    var ERR_MULTIPLE_CALLBACK = _require$codes.ERR_MULTIPLE_CALLBACK;
    var ERR_TRANSFORM_ALREADY_TRANSFORMING = _require$codes.ERR_TRANSFORM_ALREADY_TRANSFORMING;
    var ERR_TRANSFORM_WITH_LENGTH_0 = _require$codes.ERR_TRANSFORM_WITH_LENGTH_0;
    var Duplex = require_stream_duplex();
    require_inherits()(Transform, Duplex);
    function afterTransform(er, data) {
      var ts = this._transformState;
      ts.transforming = false;
      var cb = ts.writecb;
      if (cb === null) {
        return this.emit("error", new ERR_MULTIPLE_CALLBACK());
      }
      ts.writechunk = null;
      ts.writecb = null;
      if (data != null)
        this.push(data);
      cb(er);
      var rs = this._readableState;
      rs.reading = false;
      if (rs.needReadable || rs.length < rs.highWaterMark) {
        this._read(rs.highWaterMark);
      }
    }
    function Transform(options) {
      if (!(this instanceof Transform))
        return new Transform(options);
      Duplex.call(this, options);
      this._transformState = {
        afterTransform: afterTransform.bind(this),
        needTransform: false,
        transforming: false,
        writecb: null,
        writechunk: null,
        writeencoding: null
      };
      this._readableState.needReadable = true;
      this._readableState.sync = false;
      if (options) {
        if (typeof options.transform === "function")
          this._transform = options.transform;
        if (typeof options.flush === "function")
          this._flush = options.flush;
      }
      this.on("prefinish", prefinish);
    }
    function prefinish() {
      var _this = this;
      if (typeof this._flush === "function" && !this._readableState.destroyed) {
        this._flush(function(er, data) {
          done(_this, er, data);
        });
      } else {
        done(this, null, null);
      }
    }
    Transform.prototype.push = function(chunk, encoding) {
      this._transformState.needTransform = false;
      return Duplex.prototype.push.call(this, chunk, encoding);
    };
    Transform.prototype._transform = function(chunk, encoding, cb) {
      cb(new ERR_METHOD_NOT_IMPLEMENTED("_transform()"));
    };
    Transform.prototype._write = function(chunk, encoding, cb) {
      var ts = this._transformState;
      ts.writecb = cb;
      ts.writechunk = chunk;
      ts.writeencoding = encoding;
      if (!ts.transforming) {
        var rs = this._readableState;
        if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark)
          this._read(rs.highWaterMark);
      }
    };
    Transform.prototype._read = function(n) {
      var ts = this._transformState;
      if (ts.writechunk !== null && !ts.transforming) {
        ts.transforming = true;
        this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
      } else {
        ts.needTransform = true;
      }
    };
    Transform.prototype._destroy = function(err, cb) {
      Duplex.prototype._destroy.call(this, err, function(err2) {
        cb(err2);
      });
    };
    function done(stream, er, data) {
      if (er)
        return stream.emit("error", er);
      if (data != null)
        stream.push(data);
      if (stream._writableState.length)
        throw new ERR_TRANSFORM_WITH_LENGTH_0();
      if (stream._transformState.transforming)
        throw new ERR_TRANSFORM_ALREADY_TRANSFORMING();
      return stream.push(null);
    }
  }
});

// node_modules/readable-stream/lib/_stream_passthrough.js
var require_stream_passthrough = __commonJS({
  "node_modules/readable-stream/lib/_stream_passthrough.js"(exports, module2) {
    "use strict";
    module2.exports = PassThrough;
    var Transform = require_stream_transform();
    require_inherits()(PassThrough, Transform);
    function PassThrough(options) {
      if (!(this instanceof PassThrough))
        return new PassThrough(options);
      Transform.call(this, options);
    }
    PassThrough.prototype._transform = function(chunk, encoding, cb) {
      cb(null, chunk);
    };
  }
});

// node_modules/readable-stream/lib/internal/streams/pipeline.js
var require_pipeline = __commonJS({
  "node_modules/readable-stream/lib/internal/streams/pipeline.js"(exports, module2) {
    "use strict";
    var eos;
    function once(callback) {
      var called = false;
      return function() {
        if (called)
          return;
        called = true;
        callback.apply(void 0, arguments);
      };
    }
    var _require$codes = require_errors().codes;
    var ERR_MISSING_ARGS = _require$codes.ERR_MISSING_ARGS;
    var ERR_STREAM_DESTROYED = _require$codes.ERR_STREAM_DESTROYED;
    function noop(err) {
      if (err)
        throw err;
    }
    function isRequest(stream) {
      return stream.setHeader && typeof stream.abort === "function";
    }
    function destroyer(stream, reading, writing, callback) {
      callback = once(callback);
      var closed = false;
      stream.on("close", function() {
        closed = true;
      });
      if (eos === void 0)
        eos = require_end_of_stream();
      eos(stream, {
        readable: reading,
        writable: writing
      }, function(err) {
        if (err)
          return callback(err);
        closed = true;
        callback();
      });
      var destroyed = false;
      return function(err) {
        if (closed)
          return;
        if (destroyed)
          return;
        destroyed = true;
        if (isRequest(stream))
          return stream.abort();
        if (typeof stream.destroy === "function")
          return stream.destroy();
        callback(err || new ERR_STREAM_DESTROYED("pipe"));
      };
    }
    function call(fn) {
      fn();
    }
    function pipe(from, to) {
      return from.pipe(to);
    }
    function popCallback(streams) {
      if (!streams.length)
        return noop;
      if (typeof streams[streams.length - 1] !== "function")
        return noop;
      return streams.pop();
    }
    function pipeline() {
      for (var _len = arguments.length, streams = new Array(_len), _key = 0; _key < _len; _key++) {
        streams[_key] = arguments[_key];
      }
      var callback = popCallback(streams);
      if (Array.isArray(streams[0]))
        streams = streams[0];
      if (streams.length < 2) {
        throw new ERR_MISSING_ARGS("streams");
      }
      var error;
      var destroys = streams.map(function(stream, i) {
        var reading = i < streams.length - 1;
        var writing = i > 0;
        return destroyer(stream, reading, writing, function(err) {
          if (!error)
            error = err;
          if (err)
            destroys.forEach(call);
          if (reading)
            return;
          destroys.forEach(call);
          callback(error);
        });
      });
      return streams.reduce(pipe);
    }
    module2.exports = pipeline;
  }
});

// node_modules/readable-stream/readable.js
var require_readable = __commonJS({
  "node_modules/readable-stream/readable.js"(exports, module2) {
    var Stream = require("stream");
    if (process.env.READABLE_STREAM === "disable" && Stream) {
      module2.exports = Stream.Readable;
      Object.assign(module2.exports, Stream);
      module2.exports.Stream = Stream;
    } else {
      exports = module2.exports = require_stream_readable();
      exports.Stream = Stream || exports;
      exports.Readable = exports;
      exports.Writable = require_stream_writable();
      exports.Duplex = require_stream_duplex();
      exports.Transform = require_stream_transform();
      exports.PassThrough = require_stream_passthrough();
      exports.finished = require_end_of_stream();
      exports.pipeline = require_pipeline();
    }
  }
});

// node_modules/bl/BufferList.js
var require_BufferList = __commonJS({
  "node_modules/bl/BufferList.js"(exports, module2) {
    "use strict";
    var { Buffer: Buffer2 } = require("buffer");
    var symbol = Symbol.for("BufferList");
    function BufferList(buf) {
      if (!(this instanceof BufferList)) {
        return new BufferList(buf);
      }
      BufferList._init.call(this, buf);
    }
    BufferList._init = function _init(buf) {
      Object.defineProperty(this, symbol, { value: true });
      this._bufs = [];
      this.length = 0;
      if (buf) {
        this.append(buf);
      }
    };
    BufferList.prototype._new = function _new(buf) {
      return new BufferList(buf);
    };
    BufferList.prototype._offset = function _offset(offset) {
      if (offset === 0) {
        return [0, 0];
      }
      let tot = 0;
      for (let i = 0; i < this._bufs.length; i++) {
        const _t = tot + this._bufs[i].length;
        if (offset < _t || i === this._bufs.length - 1) {
          return [i, offset - tot];
        }
        tot = _t;
      }
    };
    BufferList.prototype._reverseOffset = function(blOffset) {
      const bufferId = blOffset[0];
      let offset = blOffset[1];
      for (let i = 0; i < bufferId; i++) {
        offset += this._bufs[i].length;
      }
      return offset;
    };
    BufferList.prototype.get = function get(index) {
      if (index > this.length || index < 0) {
        return void 0;
      }
      const offset = this._offset(index);
      return this._bufs[offset[0]][offset[1]];
    };
    BufferList.prototype.slice = function slice(start, end) {
      if (typeof start === "number" && start < 0) {
        start += this.length;
      }
      if (typeof end === "number" && end < 0) {
        end += this.length;
      }
      return this.copy(null, 0, start, end);
    };
    BufferList.prototype.copy = function copy(dst, dstStart, srcStart, srcEnd) {
      if (typeof srcStart !== "number" || srcStart < 0) {
        srcStart = 0;
      }
      if (typeof srcEnd !== "number" || srcEnd > this.length) {
        srcEnd = this.length;
      }
      if (srcStart >= this.length) {
        return dst || Buffer2.alloc(0);
      }
      if (srcEnd <= 0) {
        return dst || Buffer2.alloc(0);
      }
      const copy2 = !!dst;
      const off = this._offset(srcStart);
      const len = srcEnd - srcStart;
      let bytes = len;
      let bufoff = copy2 && dstStart || 0;
      let start = off[1];
      if (srcStart === 0 && srcEnd === this.length) {
        if (!copy2) {
          return this._bufs.length === 1 ? this._bufs[0] : Buffer2.concat(this._bufs, this.length);
        }
        for (let i = 0; i < this._bufs.length; i++) {
          this._bufs[i].copy(dst, bufoff);
          bufoff += this._bufs[i].length;
        }
        return dst;
      }
      if (bytes <= this._bufs[off[0]].length - start) {
        return copy2 ? this._bufs[off[0]].copy(dst, dstStart, start, start + bytes) : this._bufs[off[0]].slice(start, start + bytes);
      }
      if (!copy2) {
        dst = Buffer2.allocUnsafe(len);
      }
      for (let i = off[0]; i < this._bufs.length; i++) {
        const l = this._bufs[i].length - start;
        if (bytes > l) {
          this._bufs[i].copy(dst, bufoff, start);
          bufoff += l;
        } else {
          this._bufs[i].copy(dst, bufoff, start, start + bytes);
          bufoff += l;
          break;
        }
        bytes -= l;
        if (start) {
          start = 0;
        }
      }
      if (dst.length > bufoff)
        return dst.slice(0, bufoff);
      return dst;
    };
    BufferList.prototype.shallowSlice = function shallowSlice(start, end) {
      start = start || 0;
      end = typeof end !== "number" ? this.length : end;
      if (start < 0) {
        start += this.length;
      }
      if (end < 0) {
        end += this.length;
      }
      if (start === end) {
        return this._new();
      }
      const startOffset = this._offset(start);
      const endOffset = this._offset(end);
      const buffers = this._bufs.slice(startOffset[0], endOffset[0] + 1);
      if (endOffset[1] === 0) {
        buffers.pop();
      } else {
        buffers[buffers.length - 1] = buffers[buffers.length - 1].slice(0, endOffset[1]);
      }
      if (startOffset[1] !== 0) {
        buffers[0] = buffers[0].slice(startOffset[1]);
      }
      return this._new(buffers);
    };
    BufferList.prototype.toString = function toString(encoding, start, end) {
      return this.slice(start, end).toString(encoding);
    };
    BufferList.prototype.consume = function consume(bytes) {
      bytes = Math.trunc(bytes);
      if (Number.isNaN(bytes) || bytes <= 0)
        return this;
      while (this._bufs.length) {
        if (bytes >= this._bufs[0].length) {
          bytes -= this._bufs[0].length;
          this.length -= this._bufs[0].length;
          this._bufs.shift();
        } else {
          this._bufs[0] = this._bufs[0].slice(bytes);
          this.length -= bytes;
          break;
        }
      }
      return this;
    };
    BufferList.prototype.duplicate = function duplicate() {
      const copy = this._new();
      for (let i = 0; i < this._bufs.length; i++) {
        copy.append(this._bufs[i]);
      }
      return copy;
    };
    BufferList.prototype.append = function append(buf) {
      if (buf == null) {
        return this;
      }
      if (buf.buffer) {
        this._appendBuffer(Buffer2.from(buf.buffer, buf.byteOffset, buf.byteLength));
      } else if (Array.isArray(buf)) {
        for (let i = 0; i < buf.length; i++) {
          this.append(buf[i]);
        }
      } else if (this._isBufferList(buf)) {
        for (let i = 0; i < buf._bufs.length; i++) {
          this.append(buf._bufs[i]);
        }
      } else {
        if (typeof buf === "number") {
          buf = buf.toString();
        }
        this._appendBuffer(Buffer2.from(buf));
      }
      return this;
    };
    BufferList.prototype._appendBuffer = function appendBuffer(buf) {
      this._bufs.push(buf);
      this.length += buf.length;
    };
    BufferList.prototype.indexOf = function(search, offset, encoding) {
      if (encoding === void 0 && typeof offset === "string") {
        encoding = offset;
        offset = void 0;
      }
      if (typeof search === "function" || Array.isArray(search)) {
        throw new TypeError('The "value" argument must be one of type string, Buffer, BufferList, or Uint8Array.');
      } else if (typeof search === "number") {
        search = Buffer2.from([search]);
      } else if (typeof search === "string") {
        search = Buffer2.from(search, encoding);
      } else if (this._isBufferList(search)) {
        search = search.slice();
      } else if (Array.isArray(search.buffer)) {
        search = Buffer2.from(search.buffer, search.byteOffset, search.byteLength);
      } else if (!Buffer2.isBuffer(search)) {
        search = Buffer2.from(search);
      }
      offset = Number(offset || 0);
      if (isNaN(offset)) {
        offset = 0;
      }
      if (offset < 0) {
        offset = this.length + offset;
      }
      if (offset < 0) {
        offset = 0;
      }
      if (search.length === 0) {
        return offset > this.length ? this.length : offset;
      }
      const blOffset = this._offset(offset);
      let blIndex = blOffset[0];
      let buffOffset = blOffset[1];
      for (; blIndex < this._bufs.length; blIndex++) {
        const buff = this._bufs[blIndex];
        while (buffOffset < buff.length) {
          const availableWindow = buff.length - buffOffset;
          if (availableWindow >= search.length) {
            const nativeSearchResult = buff.indexOf(search, buffOffset);
            if (nativeSearchResult !== -1) {
              return this._reverseOffset([blIndex, nativeSearchResult]);
            }
            buffOffset = buff.length - search.length + 1;
          } else {
            const revOffset = this._reverseOffset([blIndex, buffOffset]);
            if (this._match(revOffset, search)) {
              return revOffset;
            }
            buffOffset++;
          }
        }
        buffOffset = 0;
      }
      return -1;
    };
    BufferList.prototype._match = function(offset, search) {
      if (this.length - offset < search.length) {
        return false;
      }
      for (let searchOffset = 0; searchOffset < search.length; searchOffset++) {
        if (this.get(offset + searchOffset) !== search[searchOffset]) {
          return false;
        }
      }
      return true;
    };
    (function() {
      const methods = {
        readDoubleBE: 8,
        readDoubleLE: 8,
        readFloatBE: 4,
        readFloatLE: 4,
        readInt32BE: 4,
        readInt32LE: 4,
        readUInt32BE: 4,
        readUInt32LE: 4,
        readInt16BE: 2,
        readInt16LE: 2,
        readUInt16BE: 2,
        readUInt16LE: 2,
        readInt8: 1,
        readUInt8: 1,
        readIntBE: null,
        readIntLE: null,
        readUIntBE: null,
        readUIntLE: null
      };
      for (const m in methods) {
        (function(m2) {
          if (methods[m2] === null) {
            BufferList.prototype[m2] = function(offset, byteLength) {
              return this.slice(offset, offset + byteLength)[m2](0, byteLength);
            };
          } else {
            BufferList.prototype[m2] = function(offset = 0) {
              return this.slice(offset, offset + methods[m2])[m2](0);
            };
          }
        })(m);
      }
    })();
    BufferList.prototype._isBufferList = function _isBufferList(b) {
      return b instanceof BufferList || BufferList.isBufferList(b);
    };
    BufferList.isBufferList = function isBufferList(b) {
      return b != null && b[symbol];
    };
    module2.exports = BufferList;
  }
});

// node_modules/bl/bl.js
var require_bl = __commonJS({
  "node_modules/bl/bl.js"(exports, module2) {
    "use strict";
    var DuplexStream = require_readable().Duplex;
    var inherits = require_inherits();
    var BufferList = require_BufferList();
    function BufferListStream(callback) {
      if (!(this instanceof BufferListStream)) {
        return new BufferListStream(callback);
      }
      if (typeof callback === "function") {
        this._callback = callback;
        const piper = function piper2(err) {
          if (this._callback) {
            this._callback(err);
            this._callback = null;
          }
        }.bind(this);
        this.on("pipe", function onPipe(src) {
          src.on("error", piper);
        });
        this.on("unpipe", function onUnpipe(src) {
          src.removeListener("error", piper);
        });
        callback = null;
      }
      BufferList._init.call(this, callback);
      DuplexStream.call(this);
    }
    inherits(BufferListStream, DuplexStream);
    Object.assign(BufferListStream.prototype, BufferList.prototype);
    BufferListStream.prototype._new = function _new(callback) {
      return new BufferListStream(callback);
    };
    BufferListStream.prototype._write = function _write(buf, encoding, callback) {
      this._appendBuffer(buf);
      if (typeof callback === "function") {
        callback();
      }
    };
    BufferListStream.prototype._read = function _read(size) {
      if (!this.length) {
        return this.push(null);
      }
      size = Math.min(size, this.length);
      this.push(this.slice(0, size));
      this.consume(size);
    };
    BufferListStream.prototype.end = function end(chunk) {
      DuplexStream.prototype.end.call(this, chunk);
      if (this._callback) {
        this._callback(null, this.slice());
        this._callback = null;
      }
    };
    BufferListStream.prototype._destroy = function _destroy(err, cb) {
      this._bufs.length = 0;
      this.length = 0;
      cb(err);
    };
    BufferListStream.prototype._isBufferList = function _isBufferList(b) {
      return b instanceof BufferListStream || b instanceof BufferList || BufferListStream.isBufferList(b);
    };
    BufferListStream.isBufferList = BufferList.isBufferList;
    module2.exports = BufferListStream;
    module2.exports.BufferListStream = BufferListStream;
    module2.exports.BufferList = BufferList;
  }
});

// node_modules/tar-stream/headers.js
var require_headers = __commonJS({
  "node_modules/tar-stream/headers.js"(exports) {
    var alloc = Buffer.alloc;
    var ZEROS = "0000000000000000000";
    var SEVENS = "7777777777777777777";
    var ZERO_OFFSET = "0".charCodeAt(0);
    var USTAR_MAGIC = Buffer.from("ustar\0", "binary");
    var USTAR_VER = Buffer.from("00", "binary");
    var GNU_MAGIC = Buffer.from("ustar ", "binary");
    var GNU_VER = Buffer.from(" \0", "binary");
    var MASK = parseInt("7777", 8);
    var MAGIC_OFFSET = 257;
    var VERSION_OFFSET = 263;
    var clamp = function(index, len, defaultValue) {
      if (typeof index !== "number")
        return defaultValue;
      index = ~~index;
      if (index >= len)
        return len;
      if (index >= 0)
        return index;
      index += len;
      if (index >= 0)
        return index;
      return 0;
    };
    var toType = function(flag) {
      switch (flag) {
        case 0:
          return "file";
        case 1:
          return "link";
        case 2:
          return "symlink";
        case 3:
          return "character-device";
        case 4:
          return "block-device";
        case 5:
          return "directory";
        case 6:
          return "fifo";
        case 7:
          return "contiguous-file";
        case 72:
          return "pax-header";
        case 55:
          return "pax-global-header";
        case 27:
          return "gnu-long-link-path";
        case 28:
        case 30:
          return "gnu-long-path";
      }
      return null;
    };
    var toTypeflag = function(flag) {
      switch (flag) {
        case "file":
          return 0;
        case "link":
          return 1;
        case "symlink":
          return 2;
        case "character-device":
          return 3;
        case "block-device":
          return 4;
        case "directory":
          return 5;
        case "fifo":
          return 6;
        case "contiguous-file":
          return 7;
        case "pax-header":
          return 72;
      }
      return 0;
    };
    var indexOf = function(block, num, offset, end) {
      for (; offset < end; offset++) {
        if (block[offset] === num)
          return offset;
      }
      return end;
    };
    var cksum = function(block) {
      var sum = 8 * 32;
      for (var i = 0; i < 148; i++)
        sum += block[i];
      for (var j = 156; j < 512; j++)
        sum += block[j];
      return sum;
    };
    var encodeOct = function(val, n) {
      val = val.toString(8);
      if (val.length > n)
        return SEVENS.slice(0, n) + " ";
      else
        return ZEROS.slice(0, n - val.length) + val + " ";
    };
    function parse256(buf) {
      var positive;
      if (buf[0] === 128)
        positive = true;
      else if (buf[0] === 255)
        positive = false;
      else
        return null;
      var tuple = [];
      for (var i = buf.length - 1; i > 0; i--) {
        var byte = buf[i];
        if (positive)
          tuple.push(byte);
        else
          tuple.push(255 - byte);
      }
      var sum = 0;
      var l = tuple.length;
      for (i = 0; i < l; i++) {
        sum += tuple[i] * Math.pow(256, i);
      }
      return positive ? sum : -1 * sum;
    }
    var decodeOct = function(val, offset, length) {
      val = val.slice(offset, offset + length);
      offset = 0;
      if (val[offset] & 128) {
        return parse256(val);
      } else {
        while (offset < val.length && val[offset] === 32)
          offset++;
        var end = clamp(indexOf(val, 32, offset, val.length), val.length, val.length);
        while (offset < end && val[offset] === 0)
          offset++;
        if (end === offset)
          return 0;
        return parseInt(val.slice(offset, end).toString(), 8);
      }
    };
    var decodeStr = function(val, offset, length, encoding) {
      return val.slice(offset, indexOf(val, 0, offset, offset + length)).toString(encoding);
    };
    var addLength = function(str) {
      var len = Buffer.byteLength(str);
      var digits = Math.floor(Math.log(len) / Math.log(10)) + 1;
      if (len + digits >= Math.pow(10, digits))
        digits++;
      return len + digits + str;
    };
    exports.decodeLongPath = function(buf, encoding) {
      return decodeStr(buf, 0, buf.length, encoding);
    };
    exports.encodePax = function(opts) {
      var result = "";
      if (opts.name)
        result += addLength(" path=" + opts.name + "\n");
      if (opts.linkname)
        result += addLength(" linkpath=" + opts.linkname + "\n");
      var pax = opts.pax;
      if (pax) {
        for (var key in pax) {
          result += addLength(" " + key + "=" + pax[key] + "\n");
        }
      }
      return Buffer.from(result);
    };
    exports.decodePax = function(buf) {
      var result = {};
      while (buf.length) {
        var i = 0;
        while (i < buf.length && buf[i] !== 32)
          i++;
        var len = parseInt(buf.slice(0, i).toString(), 10);
        if (!len)
          return result;
        var b = buf.slice(i + 1, len - 1).toString();
        var keyIndex = b.indexOf("=");
        if (keyIndex === -1)
          return result;
        result[b.slice(0, keyIndex)] = b.slice(keyIndex + 1);
        buf = buf.slice(len);
      }
      return result;
    };
    exports.encode = function(opts) {
      var buf = alloc(512);
      var name = opts.name;
      var prefix = "";
      if (opts.typeflag === 5 && name[name.length - 1] !== "/")
        name += "/";
      if (Buffer.byteLength(name) !== name.length)
        return null;
      while (Buffer.byteLength(name) > 100) {
        var i = name.indexOf("/");
        if (i === -1)
          return null;
        prefix += prefix ? "/" + name.slice(0, i) : name.slice(0, i);
        name = name.slice(i + 1);
      }
      if (Buffer.byteLength(name) > 100 || Buffer.byteLength(prefix) > 155)
        return null;
      if (opts.linkname && Buffer.byteLength(opts.linkname) > 100)
        return null;
      buf.write(name);
      buf.write(encodeOct(opts.mode & MASK, 6), 100);
      buf.write(encodeOct(opts.uid, 6), 108);
      buf.write(encodeOct(opts.gid, 6), 116);
      buf.write(encodeOct(opts.size, 11), 124);
      buf.write(encodeOct(opts.mtime.getTime() / 1e3 | 0, 11), 136);
      buf[156] = ZERO_OFFSET + toTypeflag(opts.type);
      if (opts.linkname)
        buf.write(opts.linkname, 157);
      USTAR_MAGIC.copy(buf, MAGIC_OFFSET);
      USTAR_VER.copy(buf, VERSION_OFFSET);
      if (opts.uname)
        buf.write(opts.uname, 265);
      if (opts.gname)
        buf.write(opts.gname, 297);
      buf.write(encodeOct(opts.devmajor || 0, 6), 329);
      buf.write(encodeOct(opts.devminor || 0, 6), 337);
      if (prefix)
        buf.write(prefix, 345);
      buf.write(encodeOct(cksum(buf), 6), 148);
      return buf;
    };
    exports.decode = function(buf, filenameEncoding, allowUnknownFormat) {
      var typeflag = buf[156] === 0 ? 0 : buf[156] - ZERO_OFFSET;
      var name = decodeStr(buf, 0, 100, filenameEncoding);
      var mode = decodeOct(buf, 100, 8);
      var uid = decodeOct(buf, 108, 8);
      var gid = decodeOct(buf, 116, 8);
      var size = decodeOct(buf, 124, 12);
      var mtime = decodeOct(buf, 136, 12);
      var type = toType(typeflag);
      var linkname = buf[157] === 0 ? null : decodeStr(buf, 157, 100, filenameEncoding);
      var uname = decodeStr(buf, 265, 32);
      var gname = decodeStr(buf, 297, 32);
      var devmajor = decodeOct(buf, 329, 8);
      var devminor = decodeOct(buf, 337, 8);
      var c = cksum(buf);
      if (c === 8 * 32)
        return null;
      if (c !== decodeOct(buf, 148, 8))
        throw new Error("Invalid tar header. Maybe the tar is corrupted or it needs to be gunzipped?");
      if (USTAR_MAGIC.compare(buf, MAGIC_OFFSET, MAGIC_OFFSET + 6) === 0) {
        if (buf[345])
          name = decodeStr(buf, 345, 155, filenameEncoding) + "/" + name;
      } else if (GNU_MAGIC.compare(buf, MAGIC_OFFSET, MAGIC_OFFSET + 6) === 0 && GNU_VER.compare(buf, VERSION_OFFSET, VERSION_OFFSET + 2) === 0) {
      } else {
        if (!allowUnknownFormat) {
          throw new Error("Invalid tar header: unknown format.");
        }
      }
      if (typeflag === 0 && name && name[name.length - 1] === "/")
        typeflag = 5;
      return {
        name,
        mode,
        uid,
        gid,
        size,
        mtime: new Date(1e3 * mtime),
        type,
        linkname,
        uname,
        gname,
        devmajor,
        devminor
      };
    };
  }
});

// node_modules/tar-stream/extract.js
var require_extract = __commonJS({
  "node_modules/tar-stream/extract.js"(exports, module2) {
    var util = require("util");
    var bl = require_bl();
    var headers = require_headers();
    var Writable = require_readable().Writable;
    var PassThrough = require_readable().PassThrough;
    var noop = function() {
    };
    var overflow = function(size) {
      size &= 511;
      return size && 512 - size;
    };
    var emptyStream = function(self, offset) {
      var s = new Source(self, offset);
      s.end();
      return s;
    };
    var mixinPax = function(header, pax) {
      if (pax.path)
        header.name = pax.path;
      if (pax.linkpath)
        header.linkname = pax.linkpath;
      if (pax.size)
        header.size = parseInt(pax.size, 10);
      header.pax = pax;
      return header;
    };
    var Source = function(self, offset) {
      this._parent = self;
      this.offset = offset;
      PassThrough.call(this, { autoDestroy: false });
    };
    util.inherits(Source, PassThrough);
    Source.prototype.destroy = function(err) {
      this._parent.destroy(err);
    };
    var Extract = function(opts) {
      if (!(this instanceof Extract))
        return new Extract(opts);
      Writable.call(this, opts);
      opts = opts || {};
      this._offset = 0;
      this._buffer = bl();
      this._missing = 0;
      this._partial = false;
      this._onparse = noop;
      this._header = null;
      this._stream = null;
      this._overflow = null;
      this._cb = null;
      this._locked = false;
      this._destroyed = false;
      this._pax = null;
      this._paxGlobal = null;
      this._gnuLongPath = null;
      this._gnuLongLinkPath = null;
      var self = this;
      var b = self._buffer;
      var oncontinue = function() {
        self._continue();
      };
      var onunlock = function(err) {
        self._locked = false;
        if (err)
          return self.destroy(err);
        if (!self._stream)
          oncontinue();
      };
      var onstreamend = function() {
        self._stream = null;
        var drain = overflow(self._header.size);
        if (drain)
          self._parse(drain, ondrain);
        else
          self._parse(512, onheader);
        if (!self._locked)
          oncontinue();
      };
      var ondrain = function() {
        self._buffer.consume(overflow(self._header.size));
        self._parse(512, onheader);
        oncontinue();
      };
      var onpaxglobalheader = function() {
        var size = self._header.size;
        self._paxGlobal = headers.decodePax(b.slice(0, size));
        b.consume(size);
        onstreamend();
      };
      var onpaxheader = function() {
        var size = self._header.size;
        self._pax = headers.decodePax(b.slice(0, size));
        if (self._paxGlobal)
          self._pax = Object.assign({}, self._paxGlobal, self._pax);
        b.consume(size);
        onstreamend();
      };
      var ongnulongpath = function() {
        var size = self._header.size;
        this._gnuLongPath = headers.decodeLongPath(b.slice(0, size), opts.filenameEncoding);
        b.consume(size);
        onstreamend();
      };
      var ongnulonglinkpath = function() {
        var size = self._header.size;
        this._gnuLongLinkPath = headers.decodeLongPath(b.slice(0, size), opts.filenameEncoding);
        b.consume(size);
        onstreamend();
      };
      var onheader = function() {
        var offset = self._offset;
        var header;
        try {
          header = self._header = headers.decode(b.slice(0, 512), opts.filenameEncoding, opts.allowUnknownFormat);
        } catch (err) {
          self.emit("error", err);
        }
        b.consume(512);
        if (!header) {
          self._parse(512, onheader);
          oncontinue();
          return;
        }
        if (header.type === "gnu-long-path") {
          self._parse(header.size, ongnulongpath);
          oncontinue();
          return;
        }
        if (header.type === "gnu-long-link-path") {
          self._parse(header.size, ongnulonglinkpath);
          oncontinue();
          return;
        }
        if (header.type === "pax-global-header") {
          self._parse(header.size, onpaxglobalheader);
          oncontinue();
          return;
        }
        if (header.type === "pax-header") {
          self._parse(header.size, onpaxheader);
          oncontinue();
          return;
        }
        if (self._gnuLongPath) {
          header.name = self._gnuLongPath;
          self._gnuLongPath = null;
        }
        if (self._gnuLongLinkPath) {
          header.linkname = self._gnuLongLinkPath;
          self._gnuLongLinkPath = null;
        }
        if (self._pax) {
          self._header = header = mixinPax(header, self._pax);
          self._pax = null;
        }
        self._locked = true;
        if (!header.size || header.type === "directory") {
          self._parse(512, onheader);
          self.emit("entry", header, emptyStream(self, offset), onunlock);
          return;
        }
        self._stream = new Source(self, offset);
        self.emit("entry", header, self._stream, onunlock);
        self._parse(header.size, onstreamend);
        oncontinue();
      };
      this._onheader = onheader;
      this._parse(512, onheader);
    };
    util.inherits(Extract, Writable);
    Extract.prototype.destroy = function(err) {
      if (this._destroyed)
        return;
      this._destroyed = true;
      if (err)
        this.emit("error", err);
      this.emit("close");
      if (this._stream)
        this._stream.emit("close");
    };
    Extract.prototype._parse = function(size, onparse) {
      if (this._destroyed)
        return;
      this._offset += size;
      this._missing = size;
      if (onparse === this._onheader)
        this._partial = false;
      this._onparse = onparse;
    };
    Extract.prototype._continue = function() {
      if (this._destroyed)
        return;
      var cb = this._cb;
      this._cb = noop;
      if (this._overflow)
        this._write(this._overflow, void 0, cb);
      else
        cb();
    };
    Extract.prototype._write = function(data, enc, cb) {
      if (this._destroyed)
        return;
      var s = this._stream;
      var b = this._buffer;
      var missing = this._missing;
      if (data.length)
        this._partial = true;
      if (data.length < missing) {
        this._missing -= data.length;
        this._overflow = null;
        if (s)
          return s.write(data, cb);
        b.append(data);
        return cb();
      }
      this._cb = cb;
      this._missing = 0;
      var overflow2 = null;
      if (data.length > missing) {
        overflow2 = data.slice(missing);
        data = data.slice(0, missing);
      }
      if (s)
        s.end(data);
      else
        b.append(data);
      this._overflow = overflow2;
      this._onparse();
    };
    Extract.prototype._final = function(cb) {
      if (this._partial)
        return this.destroy(new Error("Unexpected end of data"));
      cb();
    };
    module2.exports = Extract;
  }
});

// node_modules/fs-constants/index.js
var require_fs_constants = __commonJS({
  "node_modules/fs-constants/index.js"(exports, module2) {
    module2.exports = require("fs").constants || require("constants");
  }
});

// node_modules/wrappy/wrappy.js
var require_wrappy = __commonJS({
  "node_modules/wrappy/wrappy.js"(exports, module2) {
    module2.exports = wrappy;
    function wrappy(fn, cb) {
      if (fn && cb)
        return wrappy(fn)(cb);
      if (typeof fn !== "function")
        throw new TypeError("need wrapper function");
      Object.keys(fn).forEach(function(k) {
        wrapper[k] = fn[k];
      });
      return wrapper;
      function wrapper() {
        var args = new Array(arguments.length);
        for (var i = 0; i < args.length; i++) {
          args[i] = arguments[i];
        }
        var ret = fn.apply(this, args);
        var cb2 = args[args.length - 1];
        if (typeof ret === "function" && ret !== cb2) {
          Object.keys(cb2).forEach(function(k) {
            ret[k] = cb2[k];
          });
        }
        return ret;
      }
    }
  }
});

// node_modules/once/once.js
var require_once = __commonJS({
  "node_modules/once/once.js"(exports, module2) {
    var wrappy = require_wrappy();
    module2.exports = wrappy(once);
    module2.exports.strict = wrappy(onceStrict);
    once.proto = once(function() {
      Object.defineProperty(Function.prototype, "once", {
        value: function() {
          return once(this);
        },
        configurable: true
      });
      Object.defineProperty(Function.prototype, "onceStrict", {
        value: function() {
          return onceStrict(this);
        },
        configurable: true
      });
    });
    function once(fn) {
      var f = function() {
        if (f.called)
          return f.value;
        f.called = true;
        return f.value = fn.apply(this, arguments);
      };
      f.called = false;
      return f;
    }
    function onceStrict(fn) {
      var f = function() {
        if (f.called)
          throw new Error(f.onceError);
        f.called = true;
        return f.value = fn.apply(this, arguments);
      };
      var name = fn.name || "Function wrapped with `once`";
      f.onceError = name + " shouldn't be called more than once";
      f.called = false;
      return f;
    }
  }
});

// node_modules/end-of-stream/index.js
var require_end_of_stream2 = __commonJS({
  "node_modules/end-of-stream/index.js"(exports, module2) {
    var once = require_once();
    var noop = function() {
    };
    var isRequest = function(stream) {
      return stream.setHeader && typeof stream.abort === "function";
    };
    var isChildProcess = function(stream) {
      return stream.stdio && Array.isArray(stream.stdio) && stream.stdio.length === 3;
    };
    var eos = function(stream, opts, callback) {
      if (typeof opts === "function")
        return eos(stream, null, opts);
      if (!opts)
        opts = {};
      callback = once(callback || noop);
      var ws = stream._writableState;
      var rs = stream._readableState;
      var readable = opts.readable || opts.readable !== false && stream.readable;
      var writable = opts.writable || opts.writable !== false && stream.writable;
      var cancelled = false;
      var onlegacyfinish = function() {
        if (!stream.writable)
          onfinish();
      };
      var onfinish = function() {
        writable = false;
        if (!readable)
          callback.call(stream);
      };
      var onend = function() {
        readable = false;
        if (!writable)
          callback.call(stream);
      };
      var onexit = function(exitCode) {
        callback.call(stream, exitCode ? new Error("exited with error code: " + exitCode) : null);
      };
      var onerror = function(err) {
        callback.call(stream, err);
      };
      var onclose = function() {
        process.nextTick(onclosenexttick);
      };
      var onclosenexttick = function() {
        if (cancelled)
          return;
        if (readable && !(rs && (rs.ended && !rs.destroyed)))
          return callback.call(stream, new Error("premature close"));
        if (writable && !(ws && (ws.ended && !ws.destroyed)))
          return callback.call(stream, new Error("premature close"));
      };
      var onrequest = function() {
        stream.req.on("finish", onfinish);
      };
      if (isRequest(stream)) {
        stream.on("complete", onfinish);
        stream.on("abort", onclose);
        if (stream.req)
          onrequest();
        else
          stream.on("request", onrequest);
      } else if (writable && !ws) {
        stream.on("end", onlegacyfinish);
        stream.on("close", onlegacyfinish);
      }
      if (isChildProcess(stream))
        stream.on("exit", onexit);
      stream.on("end", onend);
      stream.on("finish", onfinish);
      if (opts.error !== false)
        stream.on("error", onerror);
      stream.on("close", onclose);
      return function() {
        cancelled = true;
        stream.removeListener("complete", onfinish);
        stream.removeListener("abort", onclose);
        stream.removeListener("request", onrequest);
        if (stream.req)
          stream.req.removeListener("finish", onfinish);
        stream.removeListener("end", onlegacyfinish);
        stream.removeListener("close", onlegacyfinish);
        stream.removeListener("finish", onfinish);
        stream.removeListener("exit", onexit);
        stream.removeListener("end", onend);
        stream.removeListener("error", onerror);
        stream.removeListener("close", onclose);
      };
    };
    module2.exports = eos;
  }
});

// node_modules/tar-stream/pack.js
var require_pack = __commonJS({
  "node_modules/tar-stream/pack.js"(exports, module2) {
    var constants = require_fs_constants();
    var eos = require_end_of_stream2();
    var inherits = require_inherits();
    var alloc = Buffer.alloc;
    var Readable = require_readable().Readable;
    var Writable = require_readable().Writable;
    var StringDecoder = require("string_decoder").StringDecoder;
    var headers = require_headers();
    var DMODE = parseInt("755", 8);
    var FMODE = parseInt("644", 8);
    var END_OF_TAR = alloc(1024);
    var noop = function() {
    };
    var overflow = function(self, size) {
      size &= 511;
      if (size)
        self.push(END_OF_TAR.slice(0, 512 - size));
    };
    function modeToType(mode) {
      switch (mode & constants.S_IFMT) {
        case constants.S_IFBLK:
          return "block-device";
        case constants.S_IFCHR:
          return "character-device";
        case constants.S_IFDIR:
          return "directory";
        case constants.S_IFIFO:
          return "fifo";
        case constants.S_IFLNK:
          return "symlink";
      }
      return "file";
    }
    var Sink = function(to) {
      Writable.call(this);
      this.written = 0;
      this._to = to;
      this._destroyed = false;
    };
    inherits(Sink, Writable);
    Sink.prototype._write = function(data, enc, cb) {
      this.written += data.length;
      if (this._to.push(data))
        return cb();
      this._to._drain = cb;
    };
    Sink.prototype.destroy = function() {
      if (this._destroyed)
        return;
      this._destroyed = true;
      this.emit("close");
    };
    var LinkSink = function() {
      Writable.call(this);
      this.linkname = "";
      this._decoder = new StringDecoder("utf-8");
      this._destroyed = false;
    };
    inherits(LinkSink, Writable);
    LinkSink.prototype._write = function(data, enc, cb) {
      this.linkname += this._decoder.write(data);
      cb();
    };
    LinkSink.prototype.destroy = function() {
      if (this._destroyed)
        return;
      this._destroyed = true;
      this.emit("close");
    };
    var Void = function() {
      Writable.call(this);
      this._destroyed = false;
    };
    inherits(Void, Writable);
    Void.prototype._write = function(data, enc, cb) {
      cb(new Error("No body allowed for this entry"));
    };
    Void.prototype.destroy = function() {
      if (this._destroyed)
        return;
      this._destroyed = true;
      this.emit("close");
    };
    var Pack = function(opts) {
      if (!(this instanceof Pack))
        return new Pack(opts);
      Readable.call(this, opts);
      this._drain = noop;
      this._finalized = false;
      this._finalizing = false;
      this._destroyed = false;
      this._stream = null;
    };
    inherits(Pack, Readable);
    Pack.prototype.entry = function(header, buffer, callback) {
      if (this._stream)
        throw new Error("already piping an entry");
      if (this._finalized || this._destroyed)
        return;
      if (typeof buffer === "function") {
        callback = buffer;
        buffer = null;
      }
      if (!callback)
        callback = noop;
      var self = this;
      if (!header.size || header.type === "symlink")
        header.size = 0;
      if (!header.type)
        header.type = modeToType(header.mode);
      if (!header.mode)
        header.mode = header.type === "directory" ? DMODE : FMODE;
      if (!header.uid)
        header.uid = 0;
      if (!header.gid)
        header.gid = 0;
      if (!header.mtime)
        header.mtime = new Date();
      if (typeof buffer === "string")
        buffer = Buffer.from(buffer);
      if (Buffer.isBuffer(buffer)) {
        header.size = buffer.length;
        this._encode(header);
        var ok = this.push(buffer);
        overflow(self, header.size);
        if (ok)
          process.nextTick(callback);
        else
          this._drain = callback;
        return new Void();
      }
      if (header.type === "symlink" && !header.linkname) {
        var linkSink = new LinkSink();
        eos(linkSink, function(err) {
          if (err) {
            self.destroy();
            return callback(err);
          }
          header.linkname = linkSink.linkname;
          self._encode(header);
          callback();
        });
        return linkSink;
      }
      this._encode(header);
      if (header.type !== "file" && header.type !== "contiguous-file") {
        process.nextTick(callback);
        return new Void();
      }
      var sink = new Sink(this);
      this._stream = sink;
      eos(sink, function(err) {
        self._stream = null;
        if (err) {
          self.destroy();
          return callback(err);
        }
        if (sink.written !== header.size) {
          self.destroy();
          return callback(new Error("size mismatch"));
        }
        overflow(self, header.size);
        if (self._finalizing)
          self.finalize();
        callback();
      });
      return sink;
    };
    Pack.prototype.finalize = function() {
      if (this._stream) {
        this._finalizing = true;
        return;
      }
      if (this._finalized)
        return;
      this._finalized = true;
      this.push(END_OF_TAR);
      this.push(null);
    };
    Pack.prototype.destroy = function(err) {
      if (this._destroyed)
        return;
      this._destroyed = true;
      if (err)
        this.emit("error", err);
      this.emit("close");
      if (this._stream && this._stream.destroy)
        this._stream.destroy();
    };
    Pack.prototype._encode = function(header) {
      if (!header.pax) {
        var buf = headers.encode(header);
        if (buf) {
          this.push(buf);
          return;
        }
      }
      this._encodePax(header);
    };
    Pack.prototype._encodePax = function(header) {
      var paxHeader = headers.encodePax({
        name: header.name,
        linkname: header.linkname,
        pax: header.pax
      });
      var newHeader = {
        name: "PaxHeader",
        mode: header.mode,
        uid: header.uid,
        gid: header.gid,
        size: paxHeader.length,
        mtime: header.mtime,
        type: "pax-header",
        linkname: header.linkname && "PaxHeader",
        uname: header.uname,
        gname: header.gname,
        devmajor: header.devmajor,
        devminor: header.devminor
      };
      this.push(headers.encode(newHeader));
      this.push(paxHeader);
      overflow(this, paxHeader.length);
      newHeader.size = header.size;
      newHeader.type = header.type;
      this.push(headers.encode(newHeader));
    };
    Pack.prototype._read = function(n) {
      var drain = this._drain;
      this._drain = noop;
      drain();
    };
    module2.exports = Pack;
  }
});

// node_modules/tar-stream/index.js
var require_tar_stream = __commonJS({
  "node_modules/tar-stream/index.js"(exports) {
    exports.extract = require_extract();
    exports.pack = require_pack();
  }
});

// node_modules/@aws-cdk/core/lib/aspect.js
var require_aspect = __commonJS({
  "node_modules/@aws-cdk/core/lib/aspect.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Aspects = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var ASPECTS_SYMBOL = Symbol("cdk-aspects");
    var Aspects = class {
      constructor(scope) {
        this.scope = scope;
      }
      static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
          aspects = new Aspects(scope);
          Object.defineProperty(scope, ASPECTS_SYMBOL, {
            value: aspects,
            configurable: false,
            enumerable: false
          });
        }
        return aspects;
      }
      add(aspect) {
        this.scope.node._actualNode.applyAspect(aspect);
      }
      get aspects() {
        return [...this.scope.node._actualNode._aspects];
      }
    };
    exports.Aspects = Aspects;
    _a = JSII_RTTI_SYMBOL_1;
    Aspects[_a] = { fqn: "@aws-cdk/core.Aspects", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/schema.js
var require_schema = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/schema.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ArtifactType = void 0;
    var ArtifactType;
    (function(ArtifactType2) {
      ArtifactType2["NONE"] = "none";
      ArtifactType2["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
      ArtifactType2["CDK_TREE"] = "cdk:tree";
      ArtifactType2["ASSET_MANIFEST"] = "cdk:asset-manifest";
      ArtifactType2["NESTED_CLOUD_ASSEMBLY"] = "cdk:cloud-assembly";
    })(ArtifactType = exports.ArtifactType || (exports.ArtifactType = {}));
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/metadata-schema.js
var require_metadata_schema = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/metadata-schema.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ArtifactMetadataEntryType = void 0;
    var ArtifactMetadataEntryType;
    (function(ArtifactMetadataEntryType2) {
      ArtifactMetadataEntryType2["ASSET"] = "aws:cdk:asset";
      ArtifactMetadataEntryType2["INFO"] = "aws:cdk:info";
      ArtifactMetadataEntryType2["WARN"] = "aws:cdk:warning";
      ArtifactMetadataEntryType2["ERROR"] = "aws:cdk:error";
      ArtifactMetadataEntryType2["LOGICAL_ID"] = "aws:cdk:logicalId";
      ArtifactMetadataEntryType2["STACK_TAGS"] = "aws:cdk:stack-tags";
    })(ArtifactMetadataEntryType = exports.ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = {}));
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/artifact-schema.js
var require_artifact_schema = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/artifact-schema.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/context-queries.js
var require_context_queries = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/context-queries.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.LoadBalancerListenerProtocol = exports.LoadBalancerType = exports.ContextProvider = void 0;
    var ContextProvider;
    (function(ContextProvider2) {
      ContextProvider2["AMI_PROVIDER"] = "ami";
      ContextProvider2["AVAILABILITY_ZONE_PROVIDER"] = "availability-zones";
      ContextProvider2["HOSTED_ZONE_PROVIDER"] = "hosted-zone";
      ContextProvider2["SSM_PARAMETER_PROVIDER"] = "ssm";
      ContextProvider2["VPC_PROVIDER"] = "vpc-provider";
      ContextProvider2["ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER"] = "endpoint-service-availability-zones";
      ContextProvider2["LOAD_BALANCER_PROVIDER"] = "load-balancer";
      ContextProvider2["LOAD_BALANCER_LISTENER_PROVIDER"] = "load-balancer-listener";
      ContextProvider2["SECURITY_GROUP_PROVIDER"] = "security-group";
      ContextProvider2["KEY_PROVIDER"] = "key-provider";
    })(ContextProvider = exports.ContextProvider || (exports.ContextProvider = {}));
    var LoadBalancerType;
    (function(LoadBalancerType2) {
      LoadBalancerType2["NETWORK"] = "network";
      LoadBalancerType2["APPLICATION"] = "application";
    })(LoadBalancerType = exports.LoadBalancerType || (exports.LoadBalancerType = {}));
    var LoadBalancerListenerProtocol;
    (function(LoadBalancerListenerProtocol2) {
      LoadBalancerListenerProtocol2["HTTP"] = "HTTP";
      LoadBalancerListenerProtocol2["HTTPS"] = "HTTPS";
      LoadBalancerListenerProtocol2["TCP"] = "TCP";
      LoadBalancerListenerProtocol2["TLS"] = "TLS";
      LoadBalancerListenerProtocol2["UDP"] = "UDP";
      LoadBalancerListenerProtocol2["TCP_UDP"] = "TCP_UDP";
    })(LoadBalancerListenerProtocol = exports.LoadBalancerListenerProtocol || (exports.LoadBalancerListenerProtocol = {}));
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/index.js
var require_cloud_assembly = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/cloud-assembly/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_schema(), exports);
    __exportStar(require_metadata_schema(), exports);
    __exportStar(require_artifact_schema(), exports);
    __exportStar(require_context_queries(), exports);
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/schema.js
var require_schema2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/schema.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/docker-image-asset.js
var require_docker_image_asset = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/docker-image-asset.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/file-asset.js
var require_file_asset = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/file-asset.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.FileAssetPackaging = void 0;
    var FileAssetPackaging;
    (function(FileAssetPackaging2) {
      FileAssetPackaging2["FILE"] = "file";
      FileAssetPackaging2["ZIP_DIRECTORY"] = "zip";
    })(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/aws-destination.js
var require_aws_destination = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/aws-destination.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/index.js
var require_assets = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/assets/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_schema2(), exports);
    __exportStar(require_docker_image_asset(), exports);
    __exportStar(require_file_asset(), exports);
    __exportStar(require_aws_destination(), exports);
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/helpers.js
var require_helpers = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/helpers.js"(exports, module2) {
    "use strict";
    var uri = require("url");
    var ValidationError = exports.ValidationError = function ValidationError2(message, instance, schema, path, name, argument) {
      if (Array.isArray(path)) {
        this.path = path;
        this.property = path.reduce(function(sum, item) {
          return sum + makeSuffix(item);
        }, "instance");
      } else if (path !== void 0) {
        this.property = path;
      }
      if (message) {
        this.message = message;
      }
      if (schema) {
        var id = schema.$id || schema.id;
        this.schema = id || schema;
      }
      if (instance !== void 0) {
        this.instance = instance;
      }
      this.name = name;
      this.argument = argument;
      this.stack = this.toString();
    };
    ValidationError.prototype.toString = function toString() {
      return this.property + " " + this.message;
    };
    var ValidatorResult = exports.ValidatorResult = function ValidatorResult2(instance, schema, options, ctx) {
      this.instance = instance;
      this.schema = schema;
      this.options = options;
      this.path = ctx.path;
      this.propertyPath = ctx.propertyPath;
      this.errors = [];
      this.throwError = options && options.throwError;
      this.throwFirst = options && options.throwFirst;
      this.throwAll = options && options.throwAll;
      this.disableFormat = options && options.disableFormat === true;
    };
    ValidatorResult.prototype.addError = function addError(detail) {
      var err;
      if (typeof detail == "string") {
        err = new ValidationError(detail, this.instance, this.schema, this.path);
      } else {
        if (!detail)
          throw new Error("Missing error detail");
        if (!detail.message)
          throw new Error("Missing error message");
        if (!detail.name)
          throw new Error("Missing validator type");
        err = new ValidationError(detail.message, this.instance, this.schema, this.path, detail.name, detail.argument);
      }
      this.errors.push(err);
      if (this.throwFirst) {
        throw new ValidatorResultError(this);
      } else if (this.throwError) {
        throw err;
      }
      return err;
    };
    ValidatorResult.prototype.importErrors = function importErrors(res) {
      if (typeof res == "string" || res && res.validatorType) {
        this.addError(res);
      } else if (res && res.errors) {
        Array.prototype.push.apply(this.errors, res.errors);
      }
    };
    function stringizer(v, i) {
      return i + ": " + v.toString() + "\n";
    }
    ValidatorResult.prototype.toString = function toString(res) {
      return this.errors.map(stringizer).join("");
    };
    Object.defineProperty(ValidatorResult.prototype, "valid", { get: function() {
      return !this.errors.length;
    } });
    module2.exports.ValidatorResultError = ValidatorResultError;
    function ValidatorResultError(result) {
      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, ValidatorResultError);
      }
      this.instance = result.instance;
      this.schema = result.schema;
      this.options = result.options;
      this.errors = result.errors;
    }
    ValidatorResultError.prototype = new Error();
    ValidatorResultError.prototype.constructor = ValidatorResultError;
    ValidatorResultError.prototype.name = "Validation Error";
    var SchemaError = exports.SchemaError = function SchemaError2(msg, schema) {
      this.message = msg;
      this.schema = schema;
      Error.call(this, msg);
      Error.captureStackTrace(this, SchemaError2);
    };
    SchemaError.prototype = Object.create(Error.prototype, {
      constructor: { value: SchemaError, enumerable: false },
      name: { value: "SchemaError", enumerable: false }
    });
    var SchemaContext = exports.SchemaContext = function SchemaContext2(schema, options, path, base, schemas) {
      this.schema = schema;
      this.options = options;
      if (Array.isArray(path)) {
        this.path = path;
        this.propertyPath = path.reduce(function(sum, item) {
          return sum + makeSuffix(item);
        }, "instance");
      } else {
        this.propertyPath = path;
      }
      this.base = base;
      this.schemas = schemas;
    };
    SchemaContext.prototype.resolve = function resolve(target) {
      return uri.resolve(this.base, target);
    };
    SchemaContext.prototype.makeChild = function makeChild(schema, propertyName) {
      var path = propertyName === void 0 ? this.path : this.path.concat([propertyName]);
      var id = schema.$id || schema.id;
      var base = uri.resolve(this.base, id || "");
      var ctx = new SchemaContext(schema, this.options, path, base, Object.create(this.schemas));
      if (id && !ctx.schemas[base]) {
        ctx.schemas[base] = schema;
      }
      return ctx;
    };
    var FORMAT_REGEXPS = exports.FORMAT_REGEXPS = {
      "date-time": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])[tT ](2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])(\.\d+)?([zZ]|[+-]([0-5][0-9]):(60|[0-5][0-9]))$/,
      "date": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])$/,
      "time": /^(2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])$/,
      "email": /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/,
      "ip-address": /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,
      "ipv6": /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,
      "uri": /^[a-zA-Z][a-zA-Z0-9+-.]*:[^\s]*$/,
      "uri-reference": /^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/,
      "color": /^(#?([0-9A-Fa-f]{3}){1,2}\b|aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow|(rgb\(\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*\))|(rgb\(\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*\)))$/,
      "hostname": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "host-name": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "alpha": /^[a-zA-Z]+$/,
      "alphanumeric": /^[a-zA-Z0-9]+$/,
      "utc-millisec": function(input) {
        return typeof input === "string" && parseFloat(input) === parseInt(input, 10) && !isNaN(input);
      },
      "regex": function(input) {
        var result = true;
        try {
          new RegExp(input);
        } catch (e) {
          result = false;
        }
        return result;
      },
      "style": /\s*(.+?):\s*([^;]+);?/,
      "phone": /^\+(?:[0-9] ?){6,14}[0-9]$/
    };
    FORMAT_REGEXPS.regexp = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.pattern = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.ipv4 = FORMAT_REGEXPS["ip-address"];
    exports.isFormat = function isFormat(input, format, validator) {
      if (typeof input === "string" && FORMAT_REGEXPS[format] !== void 0) {
        if (FORMAT_REGEXPS[format] instanceof RegExp) {
          return FORMAT_REGEXPS[format].test(input);
        }
        if (typeof FORMAT_REGEXPS[format] === "function") {
          return FORMAT_REGEXPS[format](input);
        }
      } else if (validator && validator.customFormats && typeof validator.customFormats[format] === "function") {
        return validator.customFormats[format](input);
      }
      return true;
    };
    var makeSuffix = exports.makeSuffix = function makeSuffix2(key) {
      key = key.toString();
      if (!key.match(/[.\s\[\]]/) && !key.match(/^[\d]/)) {
        return "." + key;
      }
      if (key.match(/^\d+$/)) {
        return "[" + key + "]";
      }
      return "[" + JSON.stringify(key) + "]";
    };
    exports.deepCompareStrict = function deepCompareStrict(a, b) {
      if (typeof a !== typeof b) {
        return false;
      }
      if (Array.isArray(a)) {
        if (!Array.isArray(b)) {
          return false;
        }
        if (a.length !== b.length) {
          return false;
        }
        return a.every(function(v, i) {
          return deepCompareStrict(a[i], b[i]);
        });
      }
      if (typeof a === "object") {
        if (!a || !b) {
          return a === b;
        }
        var aKeys = Object.keys(a);
        var bKeys = Object.keys(b);
        if (aKeys.length !== bKeys.length) {
          return false;
        }
        return aKeys.every(function(v) {
          return deepCompareStrict(a[v], b[v]);
        });
      }
      return a === b;
    };
    function deepMerger(target, dst, e, i) {
      if (typeof e === "object") {
        dst[i] = deepMerge(target[i], e);
      } else {
        if (target.indexOf(e) === -1) {
          dst.push(e);
        }
      }
    }
    function copyist(src, dst, key) {
      dst[key] = src[key];
    }
    function copyistWithDeepMerge(target, src, dst, key) {
      if (typeof src[key] !== "object" || !src[key]) {
        dst[key] = src[key];
      } else {
        if (!target[key]) {
          dst[key] = src[key];
        } else {
          dst[key] = deepMerge(target[key], src[key]);
        }
      }
    }
    function deepMerge(target, src) {
      var array = Array.isArray(src);
      var dst = array && [] || {};
      if (array) {
        target = target || [];
        dst = dst.concat(target);
        src.forEach(deepMerger.bind(null, target, dst));
      } else {
        if (target && typeof target === "object") {
          Object.keys(target).forEach(copyist.bind(null, target, dst));
        }
        Object.keys(src).forEach(copyistWithDeepMerge.bind(null, target, src, dst));
      }
      return dst;
    }
    module2.exports.deepMerge = deepMerge;
    exports.objectGetPath = function objectGetPath(o, s) {
      var parts = s.split("/").slice(1);
      var k;
      while (typeof (k = parts.shift()) == "string") {
        var n = decodeURIComponent(k.replace(/~0/, "~").replace(/~1/g, "/"));
        if (!(n in o))
          return;
        o = o[n];
      }
      return o;
    };
    function pathEncoder(v) {
      return "/" + encodeURIComponent(v).replace(/~/g, "%7E");
    }
    exports.encodePath = function encodePointer(a) {
      return a.map(pathEncoder).join("");
    };
    exports.getDecimalPlaces = function getDecimalPlaces(number) {
      var decimalPlaces = 0;
      if (isNaN(number))
        return decimalPlaces;
      if (typeof number !== "number") {
        number = Number(number);
      }
      var parts = number.toString().split("e");
      if (parts.length === 2) {
        if (parts[1][0] !== "-") {
          return decimalPlaces;
        } else {
          decimalPlaces = Number(parts[1].slice(1));
        }
      }
      var decimalParts = parts[0].split(".");
      if (decimalParts.length === 2) {
        decimalPlaces += decimalParts[1].length;
      }
      return decimalPlaces;
    };
    exports.isSchema = function isSchema(val) {
      return typeof val === "object" && val || typeof val === "boolean";
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/attribute.js
var require_attribute = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/attribute.js"(exports, module2) {
    "use strict";
    var helpers = require_helpers();
    var ValidatorResult = helpers.ValidatorResult;
    var SchemaError = helpers.SchemaError;
    var attribute = {};
    attribute.ignoreProperties = {
      "id": true,
      "default": true,
      "description": true,
      "title": true,
      "additionalItems": true,
      "then": true,
      "else": true,
      "$schema": true,
      "$ref": true,
      "extends": true
    };
    var validators = attribute.validators = {};
    validators.type = function validateType(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var types = Array.isArray(schema.type) ? schema.type : [schema.type];
      if (!types.some(this.testType.bind(this, instance, schema, options, ctx))) {
        var list = types.map(function(v) {
          if (!v)
            return;
          var id = v.$id || v.id;
          return id ? "<" + id + ">" : v + "";
        });
        result.addError({
          name: "type",
          argument: list,
          message: "is not of a type(s) " + list
        });
      }
      return result;
    };
    function testSchemaNoThrow(instance, options, ctx, callback, schema) {
      var throwError = options.throwError;
      var throwAll = options.throwAll;
      options.throwError = false;
      options.throwAll = false;
      var res = this.validateSchema(instance, schema, options, ctx);
      options.throwError = throwError;
      options.throwAll = throwAll;
      if (!res.valid && callback instanceof Function) {
        callback(res);
      }
      return res.valid;
    }
    validators.anyOf = function validateAnyOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      if (!Array.isArray(schema.anyOf)) {
        throw new SchemaError("anyOf must be an array");
      }
      if (!schema.anyOf.some(testSchemaNoThrow.bind(this, instance, options, ctx, function(res) {
        inner.importErrors(res);
      }))) {
        var list = schema.anyOf.map(function(v, i) {
          var id = v.$id || v.id;
          if (id)
            return "<" + id + ">";
          return v.title && JSON.stringify(v.title) || v["$ref"] && "<" + v["$ref"] + ">" || "[subschema " + i + "]";
        });
        if (options.nestedErrors) {
          result.importErrors(inner);
        }
        result.addError({
          name: "anyOf",
          argument: list,
          message: "is not any of " + list.join(",")
        });
      }
      return result;
    };
    validators.allOf = function validateAllOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.allOf)) {
        throw new SchemaError("allOf must be an array");
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var self = this;
      schema.allOf.forEach(function(v, i) {
        var valid = self.validateSchema(instance, v, options, ctx);
        if (!valid.valid) {
          var id = v.$id || v.id;
          var msg = id || v.title && JSON.stringify(v.title) || v["$ref"] && "<" + v["$ref"] + ">" || "[subschema " + i + "]";
          result.addError({
            name: "allOf",
            argument: { id: msg, length: valid.errors.length, valid },
            message: "does not match allOf schema " + msg + " with " + valid.errors.length + " error[s]:"
          });
          result.importErrors(valid);
        }
      });
      return result;
    };
    validators.oneOf = function validateOneOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.oneOf)) {
        throw new SchemaError("oneOf must be an array");
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      var count = schema.oneOf.filter(testSchemaNoThrow.bind(this, instance, options, ctx, function(res) {
        inner.importErrors(res);
      })).length;
      var list = schema.oneOf.map(function(v, i) {
        var id = v.$id || v.id;
        return id || v.title && JSON.stringify(v.title) || v["$ref"] && "<" + v["$ref"] + ">" || "[subschema " + i + "]";
      });
      if (count !== 1) {
        if (options.nestedErrors) {
          result.importErrors(inner);
        }
        result.addError({
          name: "oneOf",
          argument: list,
          message: "is not exactly one from " + list.join(",")
        });
      }
      return result;
    };
    validators.if = function validateIf(instance, schema, options, ctx) {
      if (instance === void 0)
        return null;
      if (!helpers.isSchema(schema.if))
        throw new Error('Expected "if" keyword to be a schema');
      var ifValid = testSchemaNoThrow.call(this, instance, options, ctx, null, schema.if);
      var result = new ValidatorResult(instance, schema, options, ctx);
      var res;
      if (ifValid) {
        if (schema.then === void 0)
          return;
        if (!helpers.isSchema(schema.then))
          throw new Error('Expected "then" keyword to be a schema');
        res = this.validateSchema(instance, schema.then, options, ctx.makeChild(schema.then));
        result.importErrors(res);
      } else {
        if (schema.else === void 0)
          return;
        if (!helpers.isSchema(schema.else))
          throw new Error('Expected "else" keyword to be a schema');
        res = this.validateSchema(instance, schema.else, options, ctx.makeChild(schema.else));
        result.importErrors(res);
      }
      return result;
    };
    function getEnumerableProperty(object, key) {
      if (Object.hasOwnProperty.call(object, key))
        return object[key];
      if (!(key in object))
        return;
      while (object = Object.getPrototypeOf(object)) {
        if (Object.propertyIsEnumerable.call(object, key))
          return object[key];
      }
    }
    validators.propertyNames = function validatePropertyNames(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var subschema = schema.propertyNames !== void 0 ? schema.propertyNames : {};
      if (!helpers.isSchema(subschema))
        throw new SchemaError('Expected "propertyNames" to be a schema (object or boolean)');
      for (var property in instance) {
        if (getEnumerableProperty(instance, property) !== void 0) {
          var res = this.validateSchema(property, subschema, options, ctx.makeChild(subschema));
          result.importErrors(res);
        }
      }
      return result;
    };
    validators.properties = function validateProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var properties = schema.properties || {};
      for (var property in properties) {
        var subschema = properties[property];
        if (subschema === void 0) {
          continue;
        } else if (subschema === null) {
          throw new SchemaError('Unexpected null, expected schema in "properties"');
        }
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, subschema, options, ctx);
        }
        var prop = getEnumerableProperty(instance, property);
        var res = this.validateSchema(prop, subschema, options, ctx.makeChild(subschema, property));
        if (res.instance !== result.instance[property])
          result.instance[property] = res.instance;
        result.importErrors(res);
      }
      return result;
    };
    function testAdditionalProperty(instance, schema, options, ctx, property, result) {
      if (!this.types.object(instance))
        return;
      if (schema.properties && schema.properties[property] !== void 0) {
        return;
      }
      if (schema.additionalProperties === false) {
        result.addError({
          name: "additionalProperties",
          argument: property,
          message: "is not allowed to have the additional property " + JSON.stringify(property)
        });
      } else {
        var additionalProperties = schema.additionalProperties || {};
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, additionalProperties, options, ctx);
        }
        var res = this.validateSchema(instance[property], additionalProperties, options, ctx.makeChild(additionalProperties, property));
        if (res.instance !== result.instance[property])
          result.instance[property] = res.instance;
        result.importErrors(res);
      }
    }
    validators.patternProperties = function validatePatternProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var patternProperties = schema.patternProperties || {};
      for (var property in instance) {
        var test = true;
        for (var pattern in patternProperties) {
          var subschema = patternProperties[pattern];
          if (subschema === void 0) {
            continue;
          } else if (subschema === null) {
            throw new SchemaError('Unexpected null, expected schema in "patternProperties"');
          }
          try {
            var regexp = new RegExp(pattern, "u");
          } catch (_e) {
            regexp = new RegExp(pattern);
          }
          if (!regexp.test(property)) {
            continue;
          }
          test = false;
          if (typeof options.preValidateProperty == "function") {
            options.preValidateProperty(instance, property, subschema, options, ctx);
          }
          var res = this.validateSchema(instance[property], subschema, options, ctx.makeChild(subschema, property));
          if (res.instance !== result.instance[property])
            result.instance[property] = res.instance;
          result.importErrors(res);
        }
        if (test) {
          testAdditionalProperty.call(this, instance, schema, options, ctx, property, result);
        }
      }
      return result;
    };
    validators.additionalProperties = function validateAdditionalProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      if (schema.patternProperties) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      for (var property in instance) {
        testAdditionalProperty.call(this, instance, schema, options, ctx, property, result);
      }
      return result;
    };
    validators.minProperties = function validateMinProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length >= schema.minProperties)) {
        result.addError({
          name: "minProperties",
          argument: schema.minProperties,
          message: "does not meet minimum property length of " + schema.minProperties
        });
      }
      return result;
    };
    validators.maxProperties = function validateMaxProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length <= schema.maxProperties)) {
        result.addError({
          name: "maxProperties",
          argument: schema.maxProperties,
          message: "does not meet maximum property length of " + schema.maxProperties
        });
      }
      return result;
    };
    validators.items = function validateItems(instance, schema, options, ctx) {
      var self = this;
      if (!this.types.array(instance))
        return;
      if (!schema.items)
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      instance.every(function(value, i) {
        var items = Array.isArray(schema.items) ? schema.items[i] || schema.additionalItems : schema.items;
        if (items === void 0) {
          return true;
        }
        if (items === false) {
          result.addError({
            name: "items",
            message: "additionalItems not permitted"
          });
          return false;
        }
        var res = self.validateSchema(value, items, options, ctx.makeChild(items, i));
        if (res.instance !== result.instance[i])
          result.instance[i] = res.instance;
        result.importErrors(res);
        return true;
      });
      return result;
    };
    validators.minimum = function validateMinimum(instance, schema, options, ctx) {
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMinimum && schema.exclusiveMinimum === true) {
        if (!(instance > schema.minimum)) {
          result.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than " + schema.minimum
          });
        }
      } else {
        if (!(instance >= schema.minimum)) {
          result.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than or equal to " + schema.minimum
          });
        }
      }
      return result;
    };
    validators.maximum = function validateMaximum(instance, schema, options, ctx) {
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMaximum && schema.exclusiveMaximum === true) {
        if (!(instance < schema.maximum)) {
          result.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than " + schema.maximum
          });
        }
      } else {
        if (!(instance <= schema.maximum)) {
          result.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than or equal to " + schema.maximum
          });
        }
      }
      return result;
    };
    validators.exclusiveMinimum = function validateExclusiveMinimum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMaximum === "boolean")
        return;
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var valid = instance > schema.exclusiveMinimum;
      if (!valid) {
        result.addError({
          name: "exclusiveMinimum",
          argument: schema.exclusiveMinimum,
          message: "must be strictly greater than " + schema.exclusiveMinimum
        });
      }
      return result;
    };
    validators.exclusiveMaximum = function validateExclusiveMaximum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMaximum === "boolean")
        return;
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var valid = instance < schema.exclusiveMaximum;
      if (!valid) {
        result.addError({
          name: "exclusiveMaximum",
          argument: schema.exclusiveMaximum,
          message: "must be strictly less than " + schema.exclusiveMaximum
        });
      }
      return result;
    };
    var validateMultipleOfOrDivisbleBy = function validateMultipleOfOrDivisbleBy2(instance, schema, options, ctx, validationType, errorMessage) {
      if (!this.types.number(instance))
        return;
      var validationArgument = schema[validationType];
      if (validationArgument == 0) {
        throw new SchemaError(validationType + " cannot be zero");
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var instanceDecimals = helpers.getDecimalPlaces(instance);
      var divisorDecimals = helpers.getDecimalPlaces(validationArgument);
      var maxDecimals = Math.max(instanceDecimals, divisorDecimals);
      var multiplier = Math.pow(10, maxDecimals);
      if (Math.round(instance * multiplier) % Math.round(validationArgument * multiplier) !== 0) {
        result.addError({
          name: validationType,
          argument: validationArgument,
          message: errorMessage + JSON.stringify(validationArgument)
        });
      }
      return result;
    };
    validators.multipleOf = function validateMultipleOf(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "multipleOf", "is not a multiple of (divisible by) ");
    };
    validators.divisibleBy = function validateDivisibleBy(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "divisibleBy", "is not divisible by (multiple of) ");
    };
    validators.required = function validateRequired(instance, schema, options, ctx) {
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (instance === void 0 && schema.required === true) {
        result.addError({
          name: "required",
          message: "is required"
        });
      } else if (this.types.object(instance) && Array.isArray(schema.required)) {
        schema.required.forEach(function(n) {
          if (getEnumerableProperty(instance, n) === void 0) {
            result.addError({
              name: "required",
              argument: n,
              message: "requires property " + JSON.stringify(n)
            });
          }
        });
      }
      return result;
    };
    validators.pattern = function validatePattern(instance, schema, options, ctx) {
      if (!this.types.string(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var pattern = schema.pattern;
      try {
        var regexp = new RegExp(pattern, "u");
      } catch (_e) {
        regexp = new RegExp(pattern);
      }
      if (!instance.match(regexp)) {
        result.addError({
          name: "pattern",
          argument: schema.pattern,
          message: "does not match pattern " + JSON.stringify(schema.pattern.toString())
        });
      }
      return result;
    };
    validators.format = function validateFormat(instance, schema, options, ctx) {
      if (instance === void 0)
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!result.disableFormat && !helpers.isFormat(instance, schema.format, this)) {
        result.addError({
          name: "format",
          argument: schema.format,
          message: "does not conform to the " + JSON.stringify(schema.format) + " format"
        });
      }
      return result;
    };
    validators.minLength = function validateMinLength(instance, schema, options, ctx) {
      if (!this.types.string(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length >= schema.minLength)) {
        result.addError({
          name: "minLength",
          argument: schema.minLength,
          message: "does not meet minimum length of " + schema.minLength
        });
      }
      return result;
    };
    validators.maxLength = function validateMaxLength(instance, schema, options, ctx) {
      if (!this.types.string(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length <= schema.maxLength)) {
        result.addError({
          name: "maxLength",
          argument: schema.maxLength,
          message: "does not meet maximum length of " + schema.maxLength
        });
      }
      return result;
    };
    validators.minItems = function validateMinItems(instance, schema, options, ctx) {
      if (!this.types.array(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length >= schema.minItems)) {
        result.addError({
          name: "minItems",
          argument: schema.minItems,
          message: "does not meet minimum length of " + schema.minItems
        });
      }
      return result;
    };
    validators.maxItems = function validateMaxItems(instance, schema, options, ctx) {
      if (!this.types.array(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length <= schema.maxItems)) {
        result.addError({
          name: "maxItems",
          argument: schema.maxItems,
          message: "does not meet maximum length of " + schema.maxItems
        });
      }
      return result;
    };
    function testArrays(v, i, a) {
      var j, len = a.length;
      for (j = i + 1, len; j < len; j++) {
        if (helpers.deepCompareStrict(v, a[j])) {
          return false;
        }
      }
      return true;
    }
    validators.uniqueItems = function validateUniqueItems(instance, schema, options, ctx) {
      if (schema.uniqueItems !== true)
        return;
      if (!this.types.array(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!instance.every(testArrays)) {
        result.addError({
          name: "uniqueItems",
          message: "contains duplicate item"
        });
      }
      return result;
    };
    validators.dependencies = function validateDependencies(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      for (var property in schema.dependencies) {
        if (instance[property] === void 0) {
          continue;
        }
        var dep = schema.dependencies[property];
        var childContext = ctx.makeChild(dep, property);
        if (typeof dep == "string") {
          dep = [dep];
        }
        if (Array.isArray(dep)) {
          dep.forEach(function(prop) {
            if (instance[prop] === void 0) {
              result.addError({
                name: "dependencies",
                argument: childContext.propertyPath,
                message: "property " + prop + " not found, required by " + childContext.propertyPath
              });
            }
          });
        } else {
          var res = this.validateSchema(instance, dep, options, childContext);
          if (result.instance !== res.instance)
            result.instance = res.instance;
          if (res && res.errors.length) {
            result.addError({
              name: "dependencies",
              argument: childContext.propertyPath,
              message: "does not meet dependency required by " + childContext.propertyPath
            });
            result.importErrors(res);
          }
        }
      }
      return result;
    };
    validators["enum"] = function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema["enum"])) {
        throw new SchemaError("enum expects an array", schema);
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!schema["enum"].some(helpers.deepCompareStrict.bind(null, instance))) {
        result.addError({
          name: "enum",
          argument: schema["enum"],
          message: "is not one of enum values: " + schema["enum"].map(String).join(",")
        });
      }
      return result;
    };
    validators["const"] = function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!helpers.deepCompareStrict(schema["const"], instance)) {
        result.addError({
          name: "const",
          argument: schema["const"],
          message: "does not exactly match expected constant: " + schema["const"]
        });
      }
      return result;
    };
    validators.not = validators.disallow = function validateNot(instance, schema, options, ctx) {
      var self = this;
      if (instance === void 0)
        return null;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var notTypes = schema.not || schema.disallow;
      if (!notTypes)
        return null;
      if (!Array.isArray(notTypes))
        notTypes = [notTypes];
      notTypes.forEach(function(type) {
        if (self.testType(instance, schema, options, ctx, type)) {
          var id = type && (type.$id || type.id);
          var schemaId = id || type;
          result.addError({
            name: "not",
            argument: schemaId,
            message: "is of prohibited type " + schemaId
          });
        }
      });
      return result;
    };
    module2.exports = attribute;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/scan.js
var require_scan = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/scan.js"(exports, module2) {
    "use strict";
    var urilib = require("url");
    var helpers = require_helpers();
    module2.exports.SchemaScanResult = SchemaScanResult;
    function SchemaScanResult(found, ref) {
      this.id = found;
      this.ref = ref;
    }
    module2.exports.scan = function scan(base, schema) {
      function scanSchema(baseuri, schema2) {
        if (!schema2 || typeof schema2 != "object")
          return;
        if (schema2.$ref) {
          var resolvedUri = urilib.resolve(baseuri, schema2.$ref);
          ref[resolvedUri] = ref[resolvedUri] ? ref[resolvedUri] + 1 : 0;
          return;
        }
        var id = schema2.$id || schema2.id;
        var ourBase = id ? urilib.resolve(baseuri, id) : baseuri;
        if (ourBase) {
          if (ourBase.indexOf("#") < 0)
            ourBase += "#";
          if (found[ourBase]) {
            if (!helpers.deepCompareStrict(found[ourBase], schema2)) {
              throw new Error("Schema <" + ourBase + "> already exists with different definition");
            }
            return found[ourBase];
          }
          found[ourBase] = schema2;
          if (ourBase[ourBase.length - 1] == "#") {
            found[ourBase.substring(0, ourBase.length - 1)] = schema2;
          }
        }
        scanArray(ourBase + "/items", Array.isArray(schema2.items) ? schema2.items : [schema2.items]);
        scanArray(ourBase + "/extends", Array.isArray(schema2.extends) ? schema2.extends : [schema2.extends]);
        scanSchema(ourBase + "/additionalItems", schema2.additionalItems);
        scanObject(ourBase + "/properties", schema2.properties);
        scanSchema(ourBase + "/additionalProperties", schema2.additionalProperties);
        scanObject(ourBase + "/definitions", schema2.definitions);
        scanObject(ourBase + "/patternProperties", schema2.patternProperties);
        scanObject(ourBase + "/dependencies", schema2.dependencies);
        scanArray(ourBase + "/disallow", schema2.disallow);
        scanArray(ourBase + "/allOf", schema2.allOf);
        scanArray(ourBase + "/anyOf", schema2.anyOf);
        scanArray(ourBase + "/oneOf", schema2.oneOf);
        scanSchema(ourBase + "/not", schema2.not);
      }
      function scanArray(baseuri, schemas) {
        if (!Array.isArray(schemas))
          return;
        for (var i = 0; i < schemas.length; i++) {
          scanSchema(baseuri + "/" + i, schemas[i]);
        }
      }
      function scanObject(baseuri, schemas) {
        if (!schemas || typeof schemas != "object")
          return;
        for (var p in schemas) {
          scanSchema(baseuri + "/" + p, schemas[p]);
        }
      }
      var found = {};
      var ref = {};
      scanSchema(base, schema);
      return new SchemaScanResult(found, ref);
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/validator.js
var require_validator = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/validator.js"(exports, module2) {
    "use strict";
    var urilib = require("url");
    var attribute = require_attribute();
    var helpers = require_helpers();
    var scanSchema = require_scan().scan;
    var ValidatorResult = helpers.ValidatorResult;
    var ValidatorResultError = helpers.ValidatorResultError;
    var SchemaError = helpers.SchemaError;
    var SchemaContext = helpers.SchemaContext;
    var anonymousBase = "/";
    var Validator = function Validator2() {
      this.customFormats = Object.create(Validator2.prototype.customFormats);
      this.schemas = {};
      this.unresolvedRefs = [];
      this.types = Object.create(types);
      this.attributes = Object.create(attribute.validators);
    };
    Validator.prototype.customFormats = {};
    Validator.prototype.schemas = null;
    Validator.prototype.types = null;
    Validator.prototype.attributes = null;
    Validator.prototype.unresolvedRefs = null;
    Validator.prototype.addSchema = function addSchema(schema, base) {
      var self = this;
      if (!schema) {
        return null;
      }
      var scan = scanSchema(base || anonymousBase, schema);
      var ourUri = base || schema.$id || schema.id;
      for (var uri in scan.id) {
        this.schemas[uri] = scan.id[uri];
      }
      for (var uri in scan.ref) {
        this.unresolvedRefs.push(uri);
      }
      this.unresolvedRefs = this.unresolvedRefs.filter(function(uri2) {
        return typeof self.schemas[uri2] === "undefined";
      });
      return this.schemas[ourUri];
    };
    Validator.prototype.addSubSchemaArray = function addSubSchemaArray(baseuri, schemas) {
      if (!Array.isArray(schemas))
        return;
      for (var i = 0; i < schemas.length; i++) {
        this.addSubSchema(baseuri, schemas[i]);
      }
    };
    Validator.prototype.addSubSchemaObject = function addSubSchemaArray(baseuri, schemas) {
      if (!schemas || typeof schemas != "object")
        return;
      for (var p in schemas) {
        this.addSubSchema(baseuri, schemas[p]);
      }
    };
    Validator.prototype.setSchemas = function setSchemas(schemas) {
      this.schemas = schemas;
    };
    Validator.prototype.getSchema = function getSchema(urn) {
      return this.schemas[urn];
    };
    Validator.prototype.validate = function validate(instance, schema, options, ctx) {
      if (typeof schema !== "boolean" && typeof schema !== "object" || schema === null) {
        throw new SchemaError("Expected `schema` to be an object or boolean");
      }
      if (!options) {
        options = {};
      }
      var id = schema.$id || schema.id;
      var base = urilib.resolve(options.base || anonymousBase, id || "");
      if (!ctx) {
        ctx = new SchemaContext(schema, options, [], base, Object.create(this.schemas));
        if (!ctx.schemas[base]) {
          ctx.schemas[base] = schema;
        }
        var found = scanSchema(base, schema);
        for (var n in found.id) {
          var sch = found.id[n];
          ctx.schemas[n] = sch;
        }
      }
      if (options.required && instance === void 0) {
        var result = new ValidatorResult(instance, schema, options, ctx);
        result.addError("is required, but is undefined");
        return result;
      }
      var result = this.validateSchema(instance, schema, options, ctx);
      if (!result) {
        throw new Error("Result undefined");
      } else if (options.throwAll && result.errors.length) {
        throw new ValidatorResultError(result);
      }
      return result;
    };
    function shouldResolve(schema) {
      var ref = typeof schema === "string" ? schema : schema.$ref;
      if (typeof ref == "string")
        return ref;
      return false;
    }
    Validator.prototype.validateSchema = function validateSchema(instance, schema, options, ctx) {
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (typeof schema === "boolean") {
        if (schema === true) {
          schema = {};
        } else if (schema === false) {
          schema = { type: [] };
        }
      } else if (!schema) {
        throw new Error("schema is undefined");
      }
      if (schema["extends"]) {
        if (Array.isArray(schema["extends"])) {
          var schemaobj = { schema, ctx };
          schema["extends"].forEach(this.schemaTraverser.bind(this, schemaobj));
          schema = schemaobj.schema;
          schemaobj.schema = null;
          schemaobj.ctx = null;
          schemaobj = null;
        } else {
          schema = helpers.deepMerge(schema, this.superResolve(schema["extends"], ctx));
        }
      }
      var switchSchema = shouldResolve(schema);
      if (switchSchema) {
        var resolved = this.resolve(schema, switchSchema, ctx);
        var subctx = new SchemaContext(resolved.subschema, options, ctx.path, resolved.switchSchema, ctx.schemas);
        return this.validateSchema(instance, resolved.subschema, options, subctx);
      }
      var skipAttributes = options && options.skipAttributes || [];
      for (var key in schema) {
        if (!attribute.ignoreProperties[key] && skipAttributes.indexOf(key) < 0) {
          var validatorErr = null;
          var validator = this.attributes[key];
          if (validator) {
            validatorErr = validator.call(this, instance, schema, options, ctx);
          } else if (options.allowUnknownAttributes === false) {
            throw new SchemaError("Unsupported attribute: " + key, schema);
          }
          if (validatorErr) {
            result.importErrors(validatorErr);
          }
        }
      }
      if (typeof options.rewrite == "function") {
        var value = options.rewrite.call(this, instance, schema, options, ctx);
        result.instance = value;
      }
      return result;
    };
    Validator.prototype.schemaTraverser = function schemaTraverser(schemaobj, s) {
      schemaobj.schema = helpers.deepMerge(schemaobj.schema, this.superResolve(s, schemaobj.ctx));
    };
    Validator.prototype.superResolve = function superResolve(schema, ctx) {
      var ref = shouldResolve(schema);
      if (ref) {
        return this.resolve(schema, ref, ctx).subschema;
      }
      return schema;
    };
    Validator.prototype.resolve = function resolve(schema, switchSchema, ctx) {
      switchSchema = ctx.resolve(switchSchema);
      if (ctx.schemas[switchSchema]) {
        return { subschema: ctx.schemas[switchSchema], switchSchema };
      }
      var parsed = urilib.parse(switchSchema);
      var fragment = parsed && parsed.hash;
      var document = fragment && fragment.length && switchSchema.substr(0, switchSchema.length - fragment.length);
      if (!document || !ctx.schemas[document]) {
        throw new SchemaError("no such schema <" + switchSchema + ">", schema);
      }
      var subschema = helpers.objectGetPath(ctx.schemas[document], fragment.substr(1));
      if (subschema === void 0) {
        throw new SchemaError("no such schema " + fragment + " located in <" + document + ">", schema);
      }
      return { subschema, switchSchema };
    };
    Validator.prototype.testType = function validateType(instance, schema, options, ctx, type) {
      if (type === void 0) {
        return;
      } else if (type === null) {
        throw new SchemaError('Unexpected null in "type" keyword');
      }
      if (typeof this.types[type] == "function") {
        return this.types[type].call(this, instance);
      }
      if (type && typeof type == "object") {
        var res = this.validateSchema(instance, type, options, ctx);
        return res === void 0 || !(res && res.errors.length);
      }
      return true;
    };
    var types = Validator.prototype.types = {};
    types.string = function testString(instance) {
      return typeof instance == "string";
    };
    types.number = function testNumber(instance) {
      return typeof instance == "number" && isFinite(instance);
    };
    types.integer = function testInteger(instance) {
      return typeof instance == "number" && instance % 1 === 0;
    };
    types.boolean = function testBoolean(instance) {
      return typeof instance == "boolean";
    };
    types.array = function testArray(instance) {
      return Array.isArray(instance);
    };
    types["null"] = function testNull(instance) {
      return instance === null;
    };
    types.date = function testDate(instance) {
      return instance instanceof Date;
    };
    types.any = function testAny(instance) {
      return true;
    };
    types.object = function testObject(instance) {
      return instance && typeof instance === "object" && !Array.isArray(instance) && !(instance instanceof Date);
    };
    module2.exports = Validator;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/index.js
var require_lib2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/jsonschema/lib/index.js"(exports, module2) {
    "use strict";
    var Validator = module2.exports.Validator = require_validator();
    module2.exports.ValidatorResult = require_helpers().ValidatorResult;
    module2.exports.ValidatorResultError = require_helpers().ValidatorResultError;
    module2.exports.ValidationError = require_helpers().ValidationError;
    module2.exports.SchemaError = require_helpers().SchemaError;
    module2.exports.SchemaScanResult = require_scan().SchemaScanResult;
    module2.exports.scan = require_scan().scan;
    module2.exports.validate = function(instance, schema, options) {
      var v = new Validator();
      return v.validate(instance, schema, options);
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/constants.js
var require_constants2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/constants.js"(exports, module2) {
    var SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    module2.exports = {
      SEMVER_SPEC_VERSION,
      MAX_LENGTH,
      MAX_SAFE_INTEGER,
      MAX_SAFE_COMPONENT_LENGTH
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/debug.js
var require_debug2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/debug.js"(exports, module2) {
    var debug = typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
    };
    module2.exports = debug;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/re.js
var require_re2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/re.js"(exports, module2) {
    var { MAX_SAFE_COMPONENT_LENGTH } = require_constants2();
    var debug = require_debug2();
    exports = module2.exports = {};
    var re = exports.re = [];
    var src = exports.src = [];
    var t = exports.t = {};
    var R = 0;
    var createToken = (name, value, isGlobal) => {
      const index = R++;
      debug(index, value);
      t[name] = index;
      src[index] = value;
      re[index] = new RegExp(value, isGlobal ? "g" : void 0);
    };
    createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
    createToken("NUMERICIDENTIFIERLOOSE", "[0-9]+");
    createToken("NONNUMERICIDENTIFIER", "\\d*[a-zA-Z-][a-zA-Z0-9-]*");
    createToken("MAINVERSION", `(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})`);
    createToken("MAINVERSIONLOOSE", `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASEIDENTIFIER", `(?:${src[t.NUMERICIDENTIFIER]}|${src[t.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t.NUMERICIDENTIFIERLOOSE]}|${src[t.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASE", `(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);
    createToken("PRERELEASELOOSE", `(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);
    createToken("BUILDIDENTIFIER", "[0-9A-Za-z-]+");
    createToken("BUILD", `(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);
    createToken("FULLPLAIN", `v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);
    createToken("FULL", `^${src[t.FULLPLAIN]}$`);
    createToken("LOOSEPLAIN", `[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);
    createToken("LOOSE", `^${src[t.LOOSEPLAIN]}$`);
    createToken("GTLT", "((?:<|>)?=?)");
    createToken("XRANGEIDENTIFIERLOOSE", `${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
    createToken("XRANGEIDENTIFIER", `${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);
    createToken("XRANGEPLAIN", `[v=\\s]*(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);
    createToken("XRANGELOOSE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COERCE", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:$|[^\\d])`);
    createToken("COERCERTL", src[t.COERCE], true);
    createToken("LONETILDE", "(?:~>?)");
    createToken("TILDETRIM", `(\\s*)${src[t.LONETILDE]}\\s+`, true);
    exports.tildeTrimReplace = "$1~";
    createToken("TILDE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);
    createToken("TILDELOOSE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("LONECARET", "(?:\\^)");
    createToken("CARETTRIM", `(\\s*)${src[t.LONECARET]}\\s+`, true);
    exports.caretTrimReplace = "$1^";
    createToken("CARET", `^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);
    createToken("CARETLOOSE", `^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COMPARATORLOOSE", `^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);
    createToken("COMPARATOR", `^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);
    createToken("COMPARATORTRIM", `(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`, true);
    exports.comparatorTrimReplace = "$1$2$3";
    createToken("HYPHENRANGE", `^\\s*(${src[t.XRANGEPLAIN]})\\s+-\\s+(${src[t.XRANGEPLAIN]})\\s*$`);
    createToken("HYPHENRANGELOOSE", `^\\s*(${src[t.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t.XRANGEPLAINLOOSE]})\\s*$`);
    createToken("STAR", "(<|>)?=?\\s*\\*");
    createToken("GTE0", "^\\s*>=\\s*0.0.0\\s*$");
    createToken("GTE0PRE", "^\\s*>=\\s*0.0.0-0\\s*$");
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/parse-options.js
var require_parse_options2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/parse-options.js"(exports, module2) {
    var opts = ["includePrerelease", "loose", "rtl"];
    var parseOptions = (options) => !options ? {} : typeof options !== "object" ? { loose: true } : opts.filter((k) => options[k]).reduce((options2, k) => {
      options2[k] = true;
      return options2;
    }, {});
    module2.exports = parseOptions;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/identifiers.js
var require_identifiers2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/internal/identifiers.js"(exports, module2) {
    var numeric = /^[0-9]+$/;
    var compareIdentifiers = (a, b) => {
      const anum = numeric.test(a);
      const bnum = numeric.test(b);
      if (anum && bnum) {
        a = +a;
        b = +b;
      }
      return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
    };
    var rcompareIdentifiers = (a, b) => compareIdentifiers(b, a);
    module2.exports = {
      compareIdentifiers,
      rcompareIdentifiers
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/semver.js
var require_semver3 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/semver.js"(exports, module2) {
    var debug = require_debug2();
    var { MAX_LENGTH, MAX_SAFE_INTEGER } = require_constants2();
    var { re, t } = require_re2();
    var parseOptions = require_parse_options2();
    var { compareIdentifiers } = require_identifiers2();
    var SemVer2 = class {
      constructor(version, options) {
        options = parseOptions(options);
        if (version instanceof SemVer2) {
          if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
            return version;
          } else {
            version = version.version;
          }
        } else if (typeof version !== "string") {
          throw new TypeError(`Invalid Version: ${version}`);
        }
        if (version.length > MAX_LENGTH) {
          throw new TypeError(`version is longer than ${MAX_LENGTH} characters`);
        }
        debug("SemVer", version, options);
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        const m = version.trim().match(options.loose ? re[t.LOOSE] : re[t.FULL]);
        if (!m) {
          throw new TypeError(`Invalid Version: ${version}`);
        }
        this.raw = version;
        this.major = +m[1];
        this.minor = +m[2];
        this.patch = +m[3];
        if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
          throw new TypeError("Invalid major version");
        }
        if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
          throw new TypeError("Invalid minor version");
        }
        if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
          throw new TypeError("Invalid patch version");
        }
        if (!m[4]) {
          this.prerelease = [];
        } else {
          this.prerelease = m[4].split(".").map((id) => {
            if (/^[0-9]+$/.test(id)) {
              const num = +id;
              if (num >= 0 && num < MAX_SAFE_INTEGER) {
                return num;
              }
            }
            return id;
          });
        }
        this.build = m[5] ? m[5].split(".") : [];
        this.format();
      }
      format() {
        this.version = `${this.major}.${this.minor}.${this.patch}`;
        if (this.prerelease.length) {
          this.version += `-${this.prerelease.join(".")}`;
        }
        return this.version;
      }
      toString() {
        return this.version;
      }
      compare(other) {
        debug("SemVer.compare", this.version, this.options, other);
        if (!(other instanceof SemVer2)) {
          if (typeof other === "string" && other === this.version) {
            return 0;
          }
          other = new SemVer2(other, this.options);
        }
        if (other.version === this.version) {
          return 0;
        }
        return this.compareMain(other) || this.comparePre(other);
      }
      compareMain(other) {
        if (!(other instanceof SemVer2)) {
          other = new SemVer2(other, this.options);
        }
        return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
      }
      comparePre(other) {
        if (!(other instanceof SemVer2)) {
          other = new SemVer2(other, this.options);
        }
        if (this.prerelease.length && !other.prerelease.length) {
          return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
          return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
          return 0;
        }
        let i = 0;
        do {
          const a = this.prerelease[i];
          const b = other.prerelease[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      compareBuild(other) {
        if (!(other instanceof SemVer2)) {
          other = new SemVer2(other, this.options);
        }
        let i = 0;
        do {
          const a = this.build[i];
          const b = other.build[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      inc(release, identifier) {
        switch (release) {
          case "premajor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor = 0;
            this.major++;
            this.inc("pre", identifier);
            break;
          case "preminor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor++;
            this.inc("pre", identifier);
            break;
          case "prepatch":
            this.prerelease.length = 0;
            this.inc("patch", identifier);
            this.inc("pre", identifier);
            break;
          case "prerelease":
            if (this.prerelease.length === 0) {
              this.inc("patch", identifier);
            }
            this.inc("pre", identifier);
            break;
          case "major":
            if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
              this.major++;
            }
            this.minor = 0;
            this.patch = 0;
            this.prerelease = [];
            break;
          case "minor":
            if (this.patch !== 0 || this.prerelease.length === 0) {
              this.minor++;
            }
            this.patch = 0;
            this.prerelease = [];
            break;
          case "patch":
            if (this.prerelease.length === 0) {
              this.patch++;
            }
            this.prerelease = [];
            break;
          case "pre":
            if (this.prerelease.length === 0) {
              this.prerelease = [0];
            } else {
              let i = this.prerelease.length;
              while (--i >= 0) {
                if (typeof this.prerelease[i] === "number") {
                  this.prerelease[i]++;
                  i = -2;
                }
              }
              if (i === -1) {
                this.prerelease.push(0);
              }
            }
            if (identifier) {
              if (this.prerelease[0] === identifier) {
                if (isNaN(this.prerelease[1])) {
                  this.prerelease = [identifier, 0];
                }
              } else {
                this.prerelease = [identifier, 0];
              }
            }
            break;
          default:
            throw new Error(`invalid increment argument: ${release}`);
        }
        this.format();
        this.raw = this.version;
        return this;
      }
    };
    module2.exports = SemVer2;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/parse.js
var require_parse2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/parse.js"(exports, module2) {
    var { MAX_LENGTH } = require_constants2();
    var { re, t } = require_re2();
    var SemVer2 = require_semver3();
    var parseOptions = require_parse_options2();
    var parse = (version, options) => {
      options = parseOptions(options);
      if (version instanceof SemVer2) {
        return version;
      }
      if (typeof version !== "string") {
        return null;
      }
      if (version.length > MAX_LENGTH) {
        return null;
      }
      const r = options.loose ? re[t.LOOSE] : re[t.FULL];
      if (!r.test(version)) {
        return null;
      }
      try {
        return new SemVer2(version, options);
      } catch (er) {
        return null;
      }
    };
    module2.exports = parse;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/valid.js
var require_valid3 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/valid.js"(exports, module2) {
    var parse = require_parse2();
    var valid = (version, options) => {
      const v = parse(version, options);
      return v ? v.version : null;
    };
    module2.exports = valid;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/clean.js
var require_clean2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/clean.js"(exports, module2) {
    var parse = require_parse2();
    var clean = (version, options) => {
      const s = parse(version.trim().replace(/^[=v]+/, ""), options);
      return s ? s.version : null;
    };
    module2.exports = clean;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/inc.js
var require_inc2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/inc.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var inc = (version, release, options, identifier) => {
      if (typeof options === "string") {
        identifier = options;
        options = void 0;
      }
      try {
        return new SemVer2(version, options).inc(release, identifier).version;
      } catch (er) {
        return null;
      }
    };
    module2.exports = inc;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare.js
var require_compare2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var compare = (a, b, loose) => new SemVer2(a, loose).compare(new SemVer2(b, loose));
    module2.exports = compare;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/eq.js
var require_eq2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/eq.js"(exports, module2) {
    var compare = require_compare2();
    var eq = (a, b, loose) => compare(a, b, loose) === 0;
    module2.exports = eq;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/diff.js
var require_diff2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/diff.js"(exports, module2) {
    var parse = require_parse2();
    var eq = require_eq2();
    var diff = (version1, version2) => {
      if (eq(version1, version2)) {
        return null;
      } else {
        const v1 = parse(version1);
        const v2 = parse(version2);
        const hasPre = v1.prerelease.length || v2.prerelease.length;
        const prefix = hasPre ? "pre" : "";
        const defaultResult = hasPre ? "prerelease" : "";
        for (const key in v1) {
          if (key === "major" || key === "minor" || key === "patch") {
            if (v1[key] !== v2[key]) {
              return prefix + key;
            }
          }
        }
        return defaultResult;
      }
    };
    module2.exports = diff;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/major.js
var require_major2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/major.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var major = (a, loose) => new SemVer2(a, loose).major;
    module2.exports = major;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/minor.js
var require_minor2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/minor.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var minor = (a, loose) => new SemVer2(a, loose).minor;
    module2.exports = minor;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/patch.js
var require_patch2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/patch.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var patch = (a, loose) => new SemVer2(a, loose).patch;
    module2.exports = patch;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/prerelease.js
var require_prerelease2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/prerelease.js"(exports, module2) {
    var parse = require_parse2();
    var prerelease = (version, options) => {
      const parsed = parse(version, options);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    };
    module2.exports = prerelease;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rcompare.js
var require_rcompare2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rcompare.js"(exports, module2) {
    var compare = require_compare2();
    var rcompare = (a, b, loose) => compare(b, a, loose);
    module2.exports = rcompare;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-loose.js
var require_compare_loose2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-loose.js"(exports, module2) {
    var compare = require_compare2();
    var compareLoose = (a, b) => compare(a, b, true);
    module2.exports = compareLoose;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-build.js
var require_compare_build2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/compare-build.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var compareBuild = (a, b, loose) => {
      const versionA = new SemVer2(a, loose);
      const versionB = new SemVer2(b, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    };
    module2.exports = compareBuild;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/sort.js
var require_sort2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/sort.js"(exports, module2) {
    var compareBuild = require_compare_build2();
    var sort = (list, loose) => list.sort((a, b) => compareBuild(a, b, loose));
    module2.exports = sort;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rsort.js
var require_rsort2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/rsort.js"(exports, module2) {
    var compareBuild = require_compare_build2();
    var rsort = (list, loose) => list.sort((a, b) => compareBuild(b, a, loose));
    module2.exports = rsort;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gt.js
var require_gt2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gt.js"(exports, module2) {
    var compare = require_compare2();
    var gt = (a, b, loose) => compare(a, b, loose) > 0;
    module2.exports = gt;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lt.js
var require_lt2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lt.js"(exports, module2) {
    var compare = require_compare2();
    var lt = (a, b, loose) => compare(a, b, loose) < 0;
    module2.exports = lt;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/neq.js
var require_neq2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/neq.js"(exports, module2) {
    var compare = require_compare2();
    var neq = (a, b, loose) => compare(a, b, loose) !== 0;
    module2.exports = neq;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gte.js
var require_gte2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/gte.js"(exports, module2) {
    var compare = require_compare2();
    var gte = (a, b, loose) => compare(a, b, loose) >= 0;
    module2.exports = gte;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lte.js
var require_lte2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/lte.js"(exports, module2) {
    var compare = require_compare2();
    var lte = (a, b, loose) => compare(a, b, loose) <= 0;
    module2.exports = lte;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/cmp.js
var require_cmp2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/cmp.js"(exports, module2) {
    var eq = require_eq2();
    var neq = require_neq2();
    var gt = require_gt2();
    var gte = require_gte2();
    var lt = require_lt2();
    var lte = require_lte2();
    var cmp = (a, op, b, loose) => {
      switch (op) {
        case "===":
          if (typeof a === "object")
            a = a.version;
          if (typeof b === "object")
            b = b.version;
          return a === b;
        case "!==":
          if (typeof a === "object")
            a = a.version;
          if (typeof b === "object")
            b = b.version;
          return a !== b;
        case "":
        case "=":
        case "==":
          return eq(a, b, loose);
        case "!=":
          return neq(a, b, loose);
        case ">":
          return gt(a, b, loose);
        case ">=":
          return gte(a, b, loose);
        case "<":
          return lt(a, b, loose);
        case "<=":
          return lte(a, b, loose);
        default:
          throw new TypeError(`Invalid operator: ${op}`);
      }
    };
    module2.exports = cmp;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/coerce.js
var require_coerce2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/coerce.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var parse = require_parse2();
    var { re, t } = require_re2();
    var coerce = (version, options) => {
      if (version instanceof SemVer2) {
        return version;
      }
      if (typeof version === "number") {
        version = String(version);
      }
      if (typeof version !== "string") {
        return null;
      }
      options = options || {};
      let match = null;
      if (!options.rtl) {
        match = version.match(re[t.COERCE]);
      } else {
        let next;
        while ((next = re[t.COERCERTL].exec(version)) && (!match || match.index + match[0].length !== version.length)) {
          if (!match || next.index + next[0].length !== match.index + match[0].length) {
            match = next;
          }
          re[t.COERCERTL].lastIndex = next.index + next[1].length + next[2].length;
        }
        re[t.COERCERTL].lastIndex = -1;
      }
      if (match === null)
        return null;
      return parse(`${match[2]}.${match[3] || "0"}.${match[4] || "0"}`, options);
    };
    module2.exports = coerce;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/yallist/iterator.js
var require_iterator2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/yallist/iterator.js"(exports, module2) {
    "use strict";
    module2.exports = function(Yallist) {
      Yallist.prototype[Symbol.iterator] = function* () {
        for (let walker = this.head; walker; walker = walker.next) {
          yield walker.value;
        }
      };
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/yallist/yallist.js
var require_yallist2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/yallist/yallist.js"(exports, module2) {
    "use strict";
    module2.exports = Yallist;
    Yallist.Node = Node;
    Yallist.create = Yallist;
    function Yallist(list) {
      var self = this;
      if (!(self instanceof Yallist)) {
        self = new Yallist();
      }
      self.tail = null;
      self.head = null;
      self.length = 0;
      if (list && typeof list.forEach === "function") {
        list.forEach(function(item) {
          self.push(item);
        });
      } else if (arguments.length > 0) {
        for (var i = 0, l = arguments.length; i < l; i++) {
          self.push(arguments[i]);
        }
      }
      return self;
    }
    Yallist.prototype.removeNode = function(node) {
      if (node.list !== this) {
        throw new Error("removing node which does not belong to this list");
      }
      var next = node.next;
      var prev = node.prev;
      if (next) {
        next.prev = prev;
      }
      if (prev) {
        prev.next = next;
      }
      if (node === this.head) {
        this.head = next;
      }
      if (node === this.tail) {
        this.tail = prev;
      }
      node.list.length--;
      node.next = null;
      node.prev = null;
      node.list = null;
      return next;
    };
    Yallist.prototype.unshiftNode = function(node) {
      if (node === this.head) {
        return;
      }
      if (node.list) {
        node.list.removeNode(node);
      }
      var head = this.head;
      node.list = this;
      node.next = head;
      if (head) {
        head.prev = node;
      }
      this.head = node;
      if (!this.tail) {
        this.tail = node;
      }
      this.length++;
    };
    Yallist.prototype.pushNode = function(node) {
      if (node === this.tail) {
        return;
      }
      if (node.list) {
        node.list.removeNode(node);
      }
      var tail = this.tail;
      node.list = this;
      node.prev = tail;
      if (tail) {
        tail.next = node;
      }
      this.tail = node;
      if (!this.head) {
        this.head = node;
      }
      this.length++;
    };
    Yallist.prototype.push = function() {
      for (var i = 0, l = arguments.length; i < l; i++) {
        push(this, arguments[i]);
      }
      return this.length;
    };
    Yallist.prototype.unshift = function() {
      for (var i = 0, l = arguments.length; i < l; i++) {
        unshift(this, arguments[i]);
      }
      return this.length;
    };
    Yallist.prototype.pop = function() {
      if (!this.tail) {
        return void 0;
      }
      var res = this.tail.value;
      this.tail = this.tail.prev;
      if (this.tail) {
        this.tail.next = null;
      } else {
        this.head = null;
      }
      this.length--;
      return res;
    };
    Yallist.prototype.shift = function() {
      if (!this.head) {
        return void 0;
      }
      var res = this.head.value;
      this.head = this.head.next;
      if (this.head) {
        this.head.prev = null;
      } else {
        this.tail = null;
      }
      this.length--;
      return res;
    };
    Yallist.prototype.forEach = function(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this.head, i = 0; walker !== null; i++) {
        fn.call(thisp, walker.value, i, this);
        walker = walker.next;
      }
    };
    Yallist.prototype.forEachReverse = function(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this.tail, i = this.length - 1; walker !== null; i--) {
        fn.call(thisp, walker.value, i, this);
        walker = walker.prev;
      }
    };
    Yallist.prototype.get = function(n) {
      for (var i = 0, walker = this.head; walker !== null && i < n; i++) {
        walker = walker.next;
      }
      if (i === n && walker !== null) {
        return walker.value;
      }
    };
    Yallist.prototype.getReverse = function(n) {
      for (var i = 0, walker = this.tail; walker !== null && i < n; i++) {
        walker = walker.prev;
      }
      if (i === n && walker !== null) {
        return walker.value;
      }
    };
    Yallist.prototype.map = function(fn, thisp) {
      thisp = thisp || this;
      var res = new Yallist();
      for (var walker = this.head; walker !== null; ) {
        res.push(fn.call(thisp, walker.value, this));
        walker = walker.next;
      }
      return res;
    };
    Yallist.prototype.mapReverse = function(fn, thisp) {
      thisp = thisp || this;
      var res = new Yallist();
      for (var walker = this.tail; walker !== null; ) {
        res.push(fn.call(thisp, walker.value, this));
        walker = walker.prev;
      }
      return res;
    };
    Yallist.prototype.reduce = function(fn, initial) {
      var acc;
      var walker = this.head;
      if (arguments.length > 1) {
        acc = initial;
      } else if (this.head) {
        walker = this.head.next;
        acc = this.head.value;
      } else {
        throw new TypeError("Reduce of empty list with no initial value");
      }
      for (var i = 0; walker !== null; i++) {
        acc = fn(acc, walker.value, i);
        walker = walker.next;
      }
      return acc;
    };
    Yallist.prototype.reduceReverse = function(fn, initial) {
      var acc;
      var walker = this.tail;
      if (arguments.length > 1) {
        acc = initial;
      } else if (this.tail) {
        walker = this.tail.prev;
        acc = this.tail.value;
      } else {
        throw new TypeError("Reduce of empty list with no initial value");
      }
      for (var i = this.length - 1; walker !== null; i--) {
        acc = fn(acc, walker.value, i);
        walker = walker.prev;
      }
      return acc;
    };
    Yallist.prototype.toArray = function() {
      var arr = new Array(this.length);
      for (var i = 0, walker = this.head; walker !== null; i++) {
        arr[i] = walker.value;
        walker = walker.next;
      }
      return arr;
    };
    Yallist.prototype.toArrayReverse = function() {
      var arr = new Array(this.length);
      for (var i = 0, walker = this.tail; walker !== null; i++) {
        arr[i] = walker.value;
        walker = walker.prev;
      }
      return arr;
    };
    Yallist.prototype.slice = function(from, to) {
      to = to || this.length;
      if (to < 0) {
        to += this.length;
      }
      from = from || 0;
      if (from < 0) {
        from += this.length;
      }
      var ret = new Yallist();
      if (to < from || to < 0) {
        return ret;
      }
      if (from < 0) {
        from = 0;
      }
      if (to > this.length) {
        to = this.length;
      }
      for (var i = 0, walker = this.head; walker !== null && i < from; i++) {
        walker = walker.next;
      }
      for (; walker !== null && i < to; i++, walker = walker.next) {
        ret.push(walker.value);
      }
      return ret;
    };
    Yallist.prototype.sliceReverse = function(from, to) {
      to = to || this.length;
      if (to < 0) {
        to += this.length;
      }
      from = from || 0;
      if (from < 0) {
        from += this.length;
      }
      var ret = new Yallist();
      if (to < from || to < 0) {
        return ret;
      }
      if (from < 0) {
        from = 0;
      }
      if (to > this.length) {
        to = this.length;
      }
      for (var i = this.length, walker = this.tail; walker !== null && i > to; i--) {
        walker = walker.prev;
      }
      for (; walker !== null && i > from; i--, walker = walker.prev) {
        ret.push(walker.value);
      }
      return ret;
    };
    Yallist.prototype.splice = function(start, deleteCount, ...nodes) {
      if (start > this.length) {
        start = this.length - 1;
      }
      if (start < 0) {
        start = this.length + start;
      }
      for (var i = 0, walker = this.head; walker !== null && i < start; i++) {
        walker = walker.next;
      }
      var ret = [];
      for (var i = 0; walker && i < deleteCount; i++) {
        ret.push(walker.value);
        walker = this.removeNode(walker);
      }
      if (walker === null) {
        walker = this.tail;
      }
      if (walker !== this.head && walker !== this.tail) {
        walker = walker.prev;
      }
      for (var i = 0; i < nodes.length; i++) {
        walker = insert(this, walker, nodes[i]);
      }
      return ret;
    };
    Yallist.prototype.reverse = function() {
      var head = this.head;
      var tail = this.tail;
      for (var walker = head; walker !== null; walker = walker.prev) {
        var p = walker.prev;
        walker.prev = walker.next;
        walker.next = p;
      }
      this.head = tail;
      this.tail = head;
      return this;
    };
    function insert(self, node, value) {
      var inserted = node === self.head ? new Node(value, null, node, self) : new Node(value, node, node.next, self);
      if (inserted.next === null) {
        self.tail = inserted;
      }
      if (inserted.prev === null) {
        self.head = inserted;
      }
      self.length++;
      return inserted;
    }
    function push(self, item) {
      self.tail = new Node(item, self.tail, null, self);
      if (!self.head) {
        self.head = self.tail;
      }
      self.length++;
    }
    function unshift(self, item) {
      self.head = new Node(item, null, self.head, self);
      if (!self.tail) {
        self.tail = self.head;
      }
      self.length++;
    }
    function Node(value, prev, next, list) {
      if (!(this instanceof Node)) {
        return new Node(value, prev, next, list);
      }
      this.list = list;
      this.value = value;
      if (prev) {
        prev.next = this;
        this.prev = prev;
      } else {
        this.prev = null;
      }
      if (next) {
        next.prev = this;
        this.next = next;
      } else {
        this.next = null;
      }
    }
    try {
      require_iterator2()(Yallist);
    } catch (er) {
    }
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/lru-cache/index.js
var require_lru_cache2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/lru-cache/index.js"(exports, module2) {
    "use strict";
    var Yallist = require_yallist2();
    var MAX = Symbol("max");
    var LENGTH = Symbol("length");
    var LENGTH_CALCULATOR = Symbol("lengthCalculator");
    var ALLOW_STALE = Symbol("allowStale");
    var MAX_AGE = Symbol("maxAge");
    var DISPOSE = Symbol("dispose");
    var NO_DISPOSE_ON_SET = Symbol("noDisposeOnSet");
    var LRU_LIST = Symbol("lruList");
    var CACHE = Symbol("cache");
    var UPDATE_AGE_ON_GET = Symbol("updateAgeOnGet");
    var naiveLength = () => 1;
    var LRUCache = class {
      constructor(options) {
        if (typeof options === "number")
          options = { max: options };
        if (!options)
          options = {};
        if (options.max && (typeof options.max !== "number" || options.max < 0))
          throw new TypeError("max must be a non-negative number");
        const max = this[MAX] = options.max || Infinity;
        const lc = options.length || naiveLength;
        this[LENGTH_CALCULATOR] = typeof lc !== "function" ? naiveLength : lc;
        this[ALLOW_STALE] = options.stale || false;
        if (options.maxAge && typeof options.maxAge !== "number")
          throw new TypeError("maxAge must be a number");
        this[MAX_AGE] = options.maxAge || 0;
        this[DISPOSE] = options.dispose;
        this[NO_DISPOSE_ON_SET] = options.noDisposeOnSet || false;
        this[UPDATE_AGE_ON_GET] = options.updateAgeOnGet || false;
        this.reset();
      }
      set max(mL) {
        if (typeof mL !== "number" || mL < 0)
          throw new TypeError("max must be a non-negative number");
        this[MAX] = mL || Infinity;
        trim(this);
      }
      get max() {
        return this[MAX];
      }
      set allowStale(allowStale) {
        this[ALLOW_STALE] = !!allowStale;
      }
      get allowStale() {
        return this[ALLOW_STALE];
      }
      set maxAge(mA) {
        if (typeof mA !== "number")
          throw new TypeError("maxAge must be a non-negative number");
        this[MAX_AGE] = mA;
        trim(this);
      }
      get maxAge() {
        return this[MAX_AGE];
      }
      set lengthCalculator(lC) {
        if (typeof lC !== "function")
          lC = naiveLength;
        if (lC !== this[LENGTH_CALCULATOR]) {
          this[LENGTH_CALCULATOR] = lC;
          this[LENGTH] = 0;
          this[LRU_LIST].forEach((hit) => {
            hit.length = this[LENGTH_CALCULATOR](hit.value, hit.key);
            this[LENGTH] += hit.length;
          });
        }
        trim(this);
      }
      get lengthCalculator() {
        return this[LENGTH_CALCULATOR];
      }
      get length() {
        return this[LENGTH];
      }
      get itemCount() {
        return this[LRU_LIST].length;
      }
      rforEach(fn, thisp) {
        thisp = thisp || this;
        for (let walker = this[LRU_LIST].tail; walker !== null; ) {
          const prev = walker.prev;
          forEachStep(this, fn, walker, thisp);
          walker = prev;
        }
      }
      forEach(fn, thisp) {
        thisp = thisp || this;
        for (let walker = this[LRU_LIST].head; walker !== null; ) {
          const next = walker.next;
          forEachStep(this, fn, walker, thisp);
          walker = next;
        }
      }
      keys() {
        return this[LRU_LIST].toArray().map((k) => k.key);
      }
      values() {
        return this[LRU_LIST].toArray().map((k) => k.value);
      }
      reset() {
        if (this[DISPOSE] && this[LRU_LIST] && this[LRU_LIST].length) {
          this[LRU_LIST].forEach((hit) => this[DISPOSE](hit.key, hit.value));
        }
        this[CACHE] = /* @__PURE__ */ new Map();
        this[LRU_LIST] = new Yallist();
        this[LENGTH] = 0;
      }
      dump() {
        return this[LRU_LIST].map((hit) => isStale(this, hit) ? false : {
          k: hit.key,
          v: hit.value,
          e: hit.now + (hit.maxAge || 0)
        }).toArray().filter((h) => h);
      }
      dumpLru() {
        return this[LRU_LIST];
      }
      set(key, value, maxAge) {
        maxAge = maxAge || this[MAX_AGE];
        if (maxAge && typeof maxAge !== "number")
          throw new TypeError("maxAge must be a number");
        const now = maxAge ? Date.now() : 0;
        const len = this[LENGTH_CALCULATOR](value, key);
        if (this[CACHE].has(key)) {
          if (len > this[MAX]) {
            del(this, this[CACHE].get(key));
            return false;
          }
          const node = this[CACHE].get(key);
          const item = node.value;
          if (this[DISPOSE]) {
            if (!this[NO_DISPOSE_ON_SET])
              this[DISPOSE](key, item.value);
          }
          item.now = now;
          item.maxAge = maxAge;
          item.value = value;
          this[LENGTH] += len - item.length;
          item.length = len;
          this.get(key);
          trim(this);
          return true;
        }
        const hit = new Entry(key, value, len, now, maxAge);
        if (hit.length > this[MAX]) {
          if (this[DISPOSE])
            this[DISPOSE](key, value);
          return false;
        }
        this[LENGTH] += hit.length;
        this[LRU_LIST].unshift(hit);
        this[CACHE].set(key, this[LRU_LIST].head);
        trim(this);
        return true;
      }
      has(key) {
        if (!this[CACHE].has(key))
          return false;
        const hit = this[CACHE].get(key).value;
        return !isStale(this, hit);
      }
      get(key) {
        return get(this, key, true);
      }
      peek(key) {
        return get(this, key, false);
      }
      pop() {
        const node = this[LRU_LIST].tail;
        if (!node)
          return null;
        del(this, node);
        return node.value;
      }
      del(key) {
        del(this, this[CACHE].get(key));
      }
      load(arr) {
        this.reset();
        const now = Date.now();
        for (let l = arr.length - 1; l >= 0; l--) {
          const hit = arr[l];
          const expiresAt = hit.e || 0;
          if (expiresAt === 0)
            this.set(hit.k, hit.v);
          else {
            const maxAge = expiresAt - now;
            if (maxAge > 0) {
              this.set(hit.k, hit.v, maxAge);
            }
          }
        }
      }
      prune() {
        this[CACHE].forEach((value, key) => get(this, key, false));
      }
    };
    var get = (self, key, doUse) => {
      const node = self[CACHE].get(key);
      if (node) {
        const hit = node.value;
        if (isStale(self, hit)) {
          del(self, node);
          if (!self[ALLOW_STALE])
            return void 0;
        } else {
          if (doUse) {
            if (self[UPDATE_AGE_ON_GET])
              node.value.now = Date.now();
            self[LRU_LIST].unshiftNode(node);
          }
        }
        return hit.value;
      }
    };
    var isStale = (self, hit) => {
      if (!hit || !hit.maxAge && !self[MAX_AGE])
        return false;
      const diff = Date.now() - hit.now;
      return hit.maxAge ? diff > hit.maxAge : self[MAX_AGE] && diff > self[MAX_AGE];
    };
    var trim = (self) => {
      if (self[LENGTH] > self[MAX]) {
        for (let walker = self[LRU_LIST].tail; self[LENGTH] > self[MAX] && walker !== null; ) {
          const prev = walker.prev;
          del(self, walker);
          walker = prev;
        }
      }
    };
    var del = (self, node) => {
      if (node) {
        const hit = node.value;
        if (self[DISPOSE])
          self[DISPOSE](hit.key, hit.value);
        self[LENGTH] -= hit.length;
        self[CACHE].delete(hit.key);
        self[LRU_LIST].removeNode(node);
      }
    };
    var Entry = class {
      constructor(key, value, length, now, maxAge) {
        this.key = key;
        this.value = value;
        this.length = length;
        this.now = now;
        this.maxAge = maxAge || 0;
      }
    };
    var forEachStep = (self, fn, node, thisp) => {
      let hit = node.value;
      if (isStale(self, hit)) {
        del(self, node);
        if (!self[ALLOW_STALE])
          hit = void 0;
      }
      if (hit)
        fn.call(thisp, hit.value, hit.key, self);
    };
    module2.exports = LRUCache;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/range.js
var require_range2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/range.js"(exports, module2) {
    var Range = class {
      constructor(range, options) {
        options = parseOptions(options);
        if (range instanceof Range) {
          if (range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease) {
            return range;
          } else {
            return new Range(range.raw, options);
          }
        }
        if (range instanceof Comparator) {
          this.raw = range.value;
          this.set = [[range]];
          this.format();
          return this;
        }
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        this.raw = range;
        this.set = range.split(/\s*\|\|\s*/).map((range2) => this.parseRange(range2.trim())).filter((c) => c.length);
        if (!this.set.length) {
          throw new TypeError(`Invalid SemVer Range: ${range}`);
        }
        if (this.set.length > 1) {
          const first = this.set[0];
          this.set = this.set.filter((c) => !isNullSet(c[0]));
          if (this.set.length === 0)
            this.set = [first];
          else if (this.set.length > 1) {
            for (const c of this.set) {
              if (c.length === 1 && isAny(c[0])) {
                this.set = [c];
                break;
              }
            }
          }
        }
        this.format();
      }
      format() {
        this.range = this.set.map((comps) => {
          return comps.join(" ").trim();
        }).join("||").trim();
        return this.range;
      }
      toString() {
        return this.range;
      }
      parseRange(range) {
        range = range.trim();
        const memoOpts = Object.keys(this.options).join(",");
        const memoKey = `parseRange:${memoOpts}:${range}`;
        const cached = cache.get(memoKey);
        if (cached)
          return cached;
        const loose = this.options.loose;
        const hr = loose ? re[t.HYPHENRANGELOOSE] : re[t.HYPHENRANGE];
        range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug("hyphen replace", range);
        range = range.replace(re[t.COMPARATORTRIM], comparatorTrimReplace);
        debug("comparator trim", range, re[t.COMPARATORTRIM]);
        range = range.replace(re[t.TILDETRIM], tildeTrimReplace);
        range = range.replace(re[t.CARETTRIM], caretTrimReplace);
        range = range.split(/\s+/).join(" ");
        const compRe = loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
        const rangeList = range.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options)).filter(this.options.loose ? (comp) => !!comp.match(compRe) : () => true).map((comp) => new Comparator(comp, this.options));
        const l = rangeList.length;
        const rangeMap = /* @__PURE__ */ new Map();
        for (const comp of rangeList) {
          if (isNullSet(comp))
            return [comp];
          rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has(""))
          rangeMap.delete("");
        const result = [...rangeMap.values()];
        cache.set(memoKey, result);
        return result;
      }
      intersects(range, options) {
        if (!(range instanceof Range)) {
          throw new TypeError("a Range is required");
        }
        return this.set.some((thisComparators) => {
          return isSatisfiable(thisComparators, options) && range.set.some((rangeComparators) => {
            return isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator) => {
              return rangeComparators.every((rangeComparator) => {
                return thisComparator.intersects(rangeComparator, options);
              });
            });
          });
        });
      }
      test(version) {
        if (!version) {
          return false;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer2(version, this.options);
          } catch (er) {
            return false;
          }
        }
        for (let i = 0; i < this.set.length; i++) {
          if (testSet(this.set[i], version, this.options)) {
            return true;
          }
        }
        return false;
      }
    };
    module2.exports = Range;
    var LRU = require_lru_cache2();
    var cache = new LRU({ max: 1e3 });
    var parseOptions = require_parse_options2();
    var Comparator = require_comparator2();
    var debug = require_debug2();
    var SemVer2 = require_semver3();
    var {
      re,
      t,
      comparatorTrimReplace,
      tildeTrimReplace,
      caretTrimReplace
    } = require_re2();
    var isNullSet = (c) => c.value === "<0.0.0-0";
    var isAny = (c) => c.value === "";
    var isSatisfiable = (comparators, options) => {
      let result = true;
      const remainingComparators = comparators.slice();
      let testComparator = remainingComparators.pop();
      while (result && remainingComparators.length) {
        result = remainingComparators.every((otherComparator) => {
          return testComparator.intersects(otherComparator, options);
        });
        testComparator = remainingComparators.pop();
      }
      return result;
    };
    var parseComparator = (comp, options) => {
      debug("comp", comp, options);
      comp = replaceCarets(comp, options);
      debug("caret", comp);
      comp = replaceTildes(comp, options);
      debug("tildes", comp);
      comp = replaceXRanges(comp, options);
      debug("xrange", comp);
      comp = replaceStars(comp, options);
      debug("stars", comp);
      return comp;
    };
    var isX = (id) => !id || id.toLowerCase() === "x" || id === "*";
    var replaceTildes = (comp, options) => comp.trim().split(/\s+/).map((comp2) => {
      return replaceTilde(comp2, options);
    }).join(" ");
    var replaceTilde = (comp, options) => {
      const r = options.loose ? re[t.TILDELOOSE] : re[t.TILDE];
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("tilde", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0 <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          ret = `>=${M}.${m}.0 <${M}.${+m + 1}.0-0`;
        } else if (pr) {
          debug("replaceTilde pr", pr);
          ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
        } else {
          ret = `>=${M}.${m}.${p} <${M}.${+m + 1}.0-0`;
        }
        debug("tilde return", ret);
        return ret;
      });
    };
    var replaceCarets = (comp, options) => comp.trim().split(/\s+/).map((comp2) => {
      return replaceCaret(comp2, options);
    }).join(" ");
    var replaceCaret = (comp, options) => {
      debug("caret", comp, options);
      const r = options.loose ? re[t.CARETLOOSE] : re[t.CARET];
      const z = options.includePrerelease ? "-0" : "";
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("caret", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0${z} <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          if (M === "0") {
            ret = `>=${M}.${m}.0${z} <${M}.${+m + 1}.0-0`;
          } else {
            ret = `>=${M}.${m}.0${z} <${+M + 1}.0.0-0`;
          }
        } else if (pr) {
          debug("replaceCaret pr", pr);
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p}-${pr} <${+M + 1}.0.0-0`;
          }
        } else {
          debug("no pr");
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}${z} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}${z} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p} <${+M + 1}.0.0-0`;
          }
        }
        debug("caret return", ret);
        return ret;
      });
    };
    var replaceXRanges = (comp, options) => {
      debug("replaceXRanges", comp, options);
      return comp.split(/\s+/).map((comp2) => {
        return replaceXRange(comp2, options);
      }).join(" ");
    };
    var replaceXRange = (comp, options) => {
      comp = comp.trim();
      const r = options.loose ? re[t.XRANGELOOSE] : re[t.XRANGE];
      return comp.replace(r, (ret, gtlt, M, m, p, pr) => {
        debug("xRange", comp, ret, gtlt, M, m, p, pr);
        const xM = isX(M);
        const xm = xM || isX(m);
        const xp = xm || isX(p);
        const anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m = 0;
          }
          p = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m = 0;
              p = 0;
            } else {
              m = +m + 1;
              p = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m = +m + 1;
            }
          }
          if (gtlt === "<")
            pr = "-0";
          ret = `${gtlt + M}.${m}.${p}${pr}`;
        } else if (xm) {
          ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0`;
        } else if (xp) {
          ret = `>=${M}.${m}.0${pr} <${M}.${+m + 1}.0-0`;
        }
        debug("xRange return", ret);
        return ret;
      });
    };
    var replaceStars = (comp, options) => {
      debug("replaceStars", comp, options);
      return comp.trim().replace(re[t.STAR], "");
    };
    var replaceGTE0 = (comp, options) => {
      debug("replaceGTE0", comp, options);
      return comp.trim().replace(re[options.includePrerelease ? t.GTE0PRE : t.GTE0], "");
    };
    var hyphenReplace = (incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) => {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = `>=${fM}.0.0${incPr ? "-0" : ""}`;
      } else if (isX(fp)) {
        from = `>=${fM}.${fm}.0${incPr ? "-0" : ""}`;
      } else if (fpr) {
        from = `>=${from}`;
      } else {
        from = `>=${from}${incPr ? "-0" : ""}`;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = `<${+tM + 1}.0.0-0`;
      } else if (isX(tp)) {
        to = `<${tM}.${+tm + 1}.0-0`;
      } else if (tpr) {
        to = `<=${tM}.${tm}.${tp}-${tpr}`;
      } else if (incPr) {
        to = `<${tM}.${tm}.${+tp + 1}-0`;
      } else {
        to = `<=${to}`;
      }
      return `${from} ${to}`.trim();
    };
    var testSet = (set, version, options) => {
      for (let i = 0; i < set.length; i++) {
        if (!set[i].test(version)) {
          return false;
        }
      }
      if (version.prerelease.length && !options.includePrerelease) {
        for (let i = 0; i < set.length; i++) {
          debug(set[i].semver);
          if (set[i].semver === Comparator.ANY) {
            continue;
          }
          if (set[i].semver.prerelease.length > 0) {
            const allowed = set[i].semver;
            if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/comparator.js
var require_comparator2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/classes/comparator.js"(exports, module2) {
    var ANY = Symbol("SemVer ANY");
    var Comparator = class {
      static get ANY() {
        return ANY;
      }
      constructor(comp, options) {
        options = parseOptions(options);
        if (comp instanceof Comparator) {
          if (comp.loose === !!options.loose) {
            return comp;
          } else {
            comp = comp.value;
          }
        }
        debug("comparator", comp, options);
        this.options = options;
        this.loose = !!options.loose;
        this.parse(comp);
        if (this.semver === ANY) {
          this.value = "";
        } else {
          this.value = this.operator + this.semver.version;
        }
        debug("comp", this);
      }
      parse(comp) {
        const r = this.options.loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
        const m = comp.match(r);
        if (!m) {
          throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m[1] !== void 0 ? m[1] : "";
        if (this.operator === "=") {
          this.operator = "";
        }
        if (!m[2]) {
          this.semver = ANY;
        } else {
          this.semver = new SemVer2(m[2], this.options.loose);
        }
      }
      toString() {
        return this.value;
      }
      test(version) {
        debug("Comparator.test", version, this.options.loose);
        if (this.semver === ANY || version === ANY) {
          return true;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer2(version, this.options);
          } catch (er) {
            return false;
          }
        }
        return cmp(version, this.operator, this.semver, this.options);
      }
      intersects(comp, options) {
        if (!(comp instanceof Comparator)) {
          throw new TypeError("a Comparator is required");
        }
        if (!options || typeof options !== "object") {
          options = {
            loose: !!options,
            includePrerelease: false
          };
        }
        if (this.operator === "") {
          if (this.value === "") {
            return true;
          }
          return new Range(comp.value, options).test(this.value);
        } else if (comp.operator === "") {
          if (comp.value === "") {
            return true;
          }
          return new Range(this.value, options).test(comp.semver);
        }
        const sameDirectionIncreasing = (this.operator === ">=" || this.operator === ">") && (comp.operator === ">=" || comp.operator === ">");
        const sameDirectionDecreasing = (this.operator === "<=" || this.operator === "<") && (comp.operator === "<=" || comp.operator === "<");
        const sameSemVer = this.semver.version === comp.semver.version;
        const differentDirectionsInclusive = (this.operator === ">=" || this.operator === "<=") && (comp.operator === ">=" || comp.operator === "<=");
        const oppositeDirectionsLessThan = cmp(this.semver, "<", comp.semver, options) && (this.operator === ">=" || this.operator === ">") && (comp.operator === "<=" || comp.operator === "<");
        const oppositeDirectionsGreaterThan = cmp(this.semver, ">", comp.semver, options) && (this.operator === "<=" || this.operator === "<") && (comp.operator === ">=" || comp.operator === ">");
        return sameDirectionIncreasing || sameDirectionDecreasing || sameSemVer && differentDirectionsInclusive || oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
      }
    };
    module2.exports = Comparator;
    var parseOptions = require_parse_options2();
    var { re, t } = require_re2();
    var cmp = require_cmp2();
    var debug = require_debug2();
    var SemVer2 = require_semver3();
    var Range = require_range2();
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/satisfies.js
var require_satisfies2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/functions/satisfies.js"(exports, module2) {
    var Range = require_range2();
    var satisfies = (version, range, options) => {
      try {
        range = new Range(range, options);
      } catch (er) {
        return false;
      }
      return range.test(version);
    };
    module2.exports = satisfies;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/to-comparators.js
var require_to_comparators2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/to-comparators.js"(exports, module2) {
    var Range = require_range2();
    var toComparators = (range, options) => new Range(range, options).set.map((comp) => comp.map((c) => c.value).join(" ").trim().split(" "));
    module2.exports = toComparators;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/max-satisfying.js
var require_max_satisfying2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/max-satisfying.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var Range = require_range2();
    var maxSatisfying = (versions, range, options) => {
      let max = null;
      let maxSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!max || maxSV.compare(v) === -1) {
            max = v;
            maxSV = new SemVer2(max, options);
          }
        }
      });
      return max;
    };
    module2.exports = maxSatisfying;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-satisfying.js
var require_min_satisfying2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-satisfying.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var Range = require_range2();
    var minSatisfying = (versions, range, options) => {
      let min = null;
      let minSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!min || minSV.compare(v) === 1) {
            min = v;
            minSV = new SemVer2(min, options);
          }
        }
      });
      return min;
    };
    module2.exports = minSatisfying;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-version.js
var require_min_version2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/min-version.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var Range = require_range2();
    var gt = require_gt2();
    var minVersion = (range, loose) => {
      range = new Range(range, loose);
      let minver = new SemVer2("0.0.0");
      if (range.test(minver)) {
        return minver;
      }
      minver = new SemVer2("0.0.0-0");
      if (range.test(minver)) {
        return minver;
      }
      minver = null;
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let setMin = null;
        comparators.forEach((comparator) => {
          const compver = new SemVer2(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            case "":
            case ">=":
              if (!setMin || gt(compver, setMin)) {
                setMin = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            default:
              throw new Error(`Unexpected operation: ${comparator.operator}`);
          }
        });
        if (setMin && (!minver || gt(minver, setMin)))
          minver = setMin;
      }
      if (minver && range.test(minver)) {
        return minver;
      }
      return null;
    };
    module2.exports = minVersion;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/valid.js
var require_valid4 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/valid.js"(exports, module2) {
    var Range = require_range2();
    var validRange = (range, options) => {
      try {
        return new Range(range, options).range || "*";
      } catch (er) {
        return null;
      }
    };
    module2.exports = validRange;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/outside.js
var require_outside2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/outside.js"(exports, module2) {
    var SemVer2 = require_semver3();
    var Comparator = require_comparator2();
    var { ANY } = Comparator;
    var Range = require_range2();
    var satisfies = require_satisfies2();
    var gt = require_gt2();
    var lt = require_lt2();
    var lte = require_lte2();
    var gte = require_gte2();
    var outside = (version, range, hilo, options) => {
      version = new SemVer2(version, options);
      range = new Range(range, options);
      let gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version, range, options)) {
        return false;
      }
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let high = null;
        let low = null;
        comparators.forEach((comparator) => {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version, low.semver)) {
          return false;
        }
      }
      return true;
    };
    module2.exports = outside;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/gtr.js
var require_gtr2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/gtr.js"(exports, module2) {
    var outside = require_outside2();
    var gtr = (version, range, options) => outside(version, range, ">", options);
    module2.exports = gtr;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/ltr.js
var require_ltr2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/ltr.js"(exports, module2) {
    var outside = require_outside2();
    var ltr = (version, range, options) => outside(version, range, "<", options);
    module2.exports = ltr;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/intersects.js
var require_intersects2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/intersects.js"(exports, module2) {
    var Range = require_range2();
    var intersects = (r1, r2, options) => {
      r1 = new Range(r1, options);
      r2 = new Range(r2, options);
      return r1.intersects(r2);
    };
    module2.exports = intersects;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/simplify.js
var require_simplify2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/simplify.js"(exports, module2) {
    var satisfies = require_satisfies2();
    var compare = require_compare2();
    module2.exports = (versions, range, options) => {
      const set = [];
      let min = null;
      let prev = null;
      const v = versions.sort((a, b) => compare(a, b, options));
      for (const version of v) {
        const included = satisfies(version, range, options);
        if (included) {
          prev = version;
          if (!min)
            min = version;
        } else {
          if (prev) {
            set.push([min, prev]);
          }
          prev = null;
          min = null;
        }
      }
      if (min)
        set.push([min, null]);
      const ranges = [];
      for (const [min2, max] of set) {
        if (min2 === max)
          ranges.push(min2);
        else if (!max && min2 === v[0])
          ranges.push("*");
        else if (!max)
          ranges.push(`>=${min2}`);
        else if (min2 === v[0])
          ranges.push(`<=${max}`);
        else
          ranges.push(`${min2} - ${max}`);
      }
      const simplified = ranges.join(" || ");
      const original = typeof range.raw === "string" ? range.raw : String(range);
      return simplified.length < original.length ? simplified : range;
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/subset.js
var require_subset2 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/ranges/subset.js"(exports, module2) {
    var Range = require_range2();
    var Comparator = require_comparator2();
    var { ANY } = Comparator;
    var satisfies = require_satisfies2();
    var compare = require_compare2();
    var subset = (sub, dom, options = {}) => {
      if (sub === dom)
        return true;
      sub = new Range(sub, options);
      dom = new Range(dom, options);
      let sawNonNull = false;
      OUTER:
        for (const simpleSub of sub.set) {
          for (const simpleDom of dom.set) {
            const isSub = simpleSubset(simpleSub, simpleDom, options);
            sawNonNull = sawNonNull || isSub !== null;
            if (isSub)
              continue OUTER;
          }
          if (sawNonNull)
            return false;
        }
      return true;
    };
    var simpleSubset = (sub, dom, options) => {
      if (sub === dom)
        return true;
      if (sub.length === 1 && sub[0].semver === ANY) {
        if (dom.length === 1 && dom[0].semver === ANY)
          return true;
        else if (options.includePrerelease)
          sub = [new Comparator(">=0.0.0-0")];
        else
          sub = [new Comparator(">=0.0.0")];
      }
      if (dom.length === 1 && dom[0].semver === ANY) {
        if (options.includePrerelease)
          return true;
        else
          dom = [new Comparator(">=0.0.0")];
      }
      const eqSet = /* @__PURE__ */ new Set();
      let gt, lt;
      for (const c of sub) {
        if (c.operator === ">" || c.operator === ">=")
          gt = higherGT(gt, c, options);
        else if (c.operator === "<" || c.operator === "<=")
          lt = lowerLT(lt, c, options);
        else
          eqSet.add(c.semver);
      }
      if (eqSet.size > 1)
        return null;
      let gtltComp;
      if (gt && lt) {
        gtltComp = compare(gt.semver, lt.semver, options);
        if (gtltComp > 0)
          return null;
        else if (gtltComp === 0 && (gt.operator !== ">=" || lt.operator !== "<="))
          return null;
      }
      for (const eq of eqSet) {
        if (gt && !satisfies(eq, String(gt), options))
          return null;
        if (lt && !satisfies(eq, String(lt), options))
          return null;
        for (const c of dom) {
          if (!satisfies(eq, String(c), options))
            return false;
        }
        return true;
      }
      let higher, lower;
      let hasDomLT, hasDomGT;
      let needDomLTPre = lt && !options.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
      let needDomGTPre = gt && !options.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
      if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === "<" && needDomLTPre.prerelease[0] === 0) {
        needDomLTPre = false;
      }
      for (const c of dom) {
        hasDomGT = hasDomGT || c.operator === ">" || c.operator === ">=";
        hasDomLT = hasDomLT || c.operator === "<" || c.operator === "<=";
        if (gt) {
          if (needDomGTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomGTPre.major && c.semver.minor === needDomGTPre.minor && c.semver.patch === needDomGTPre.patch) {
              needDomGTPre = false;
            }
          }
          if (c.operator === ">" || c.operator === ">=") {
            higher = higherGT(gt, c, options);
            if (higher === c && higher !== gt)
              return false;
          } else if (gt.operator === ">=" && !satisfies(gt.semver, String(c), options))
            return false;
        }
        if (lt) {
          if (needDomLTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomLTPre.major && c.semver.minor === needDomLTPre.minor && c.semver.patch === needDomLTPre.patch) {
              needDomLTPre = false;
            }
          }
          if (c.operator === "<" || c.operator === "<=") {
            lower = lowerLT(lt, c, options);
            if (lower === c && lower !== lt)
              return false;
          } else if (lt.operator === "<=" && !satisfies(lt.semver, String(c), options))
            return false;
        }
        if (!c.operator && (lt || gt) && gtltComp !== 0)
          return false;
      }
      if (gt && hasDomLT && !lt && gtltComp !== 0)
        return false;
      if (lt && hasDomGT && !gt && gtltComp !== 0)
        return false;
      if (needDomGTPre || needDomLTPre)
        return false;
      return true;
    };
    var higherGT = (a, b, options) => {
      if (!a)
        return b;
      const comp = compare(a.semver, b.semver, options);
      return comp > 0 ? a : comp < 0 ? b : b.operator === ">" && a.operator === ">=" ? b : a;
    };
    var lowerLT = (a, b, options) => {
      if (!a)
        return b;
      const comp = compare(a.semver, b.semver, options);
      return comp < 0 ? a : comp > 0 ? b : b.operator === "<" && a.operator === "<=" ? b : a;
    };
    module2.exports = subset;
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/index.js
var require_semver4 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/node_modules/semver/index.js"(exports, module2) {
    var internalRe = require_re2();
    module2.exports = {
      re: internalRe.re,
      src: internalRe.src,
      tokens: internalRe.t,
      SEMVER_SPEC_VERSION: require_constants2().SEMVER_SPEC_VERSION,
      SemVer: require_semver3(),
      compareIdentifiers: require_identifiers2().compareIdentifiers,
      rcompareIdentifiers: require_identifiers2().rcompareIdentifiers,
      parse: require_parse2(),
      valid: require_valid3(),
      clean: require_clean2(),
      inc: require_inc2(),
      diff: require_diff2(),
      major: require_major2(),
      minor: require_minor2(),
      patch: require_patch2(),
      prerelease: require_prerelease2(),
      compare: require_compare2(),
      rcompare: require_rcompare2(),
      compareLoose: require_compare_loose2(),
      compareBuild: require_compare_build2(),
      sort: require_sort2(),
      rsort: require_rsort2(),
      gt: require_gt2(),
      lt: require_lt2(),
      eq: require_eq2(),
      neq: require_neq2(),
      gte: require_gte2(),
      lte: require_lte2(),
      cmp: require_cmp2(),
      coerce: require_coerce2(),
      Comparator: require_comparator2(),
      Range: require_range2(),
      satisfies: require_satisfies2(),
      toComparators: require_to_comparators2(),
      maxSatisfying: require_max_satisfying2(),
      minSatisfying: require_min_satisfying2(),
      minVersion: require_min_version2(),
      validRange: require_valid4(),
      outside: require_outside2(),
      gtr: require_gtr2(),
      ltr: require_ltr2(),
      intersects: require_intersects2(),
      simplifyRange: require_simplify2(),
      subset: require_subset2()
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/schema/assets.schema.json
var require_assets_schema = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/schema/assets.schema.json"(exports, module2) {
    module2.exports = {
      $ref: "#/definitions/AssetManifest",
      definitions: {
        AssetManifest: {
          description: "Definitions for the asset manifest",
          type: "object",
          properties: {
            version: {
              description: "Version of the manifest",
              type: "string"
            },
            files: {
              description: "The file assets in this manifest (Default - No files)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/FileAsset"
              }
            },
            dockerImages: {
              description: "The Docker image assets in this manifest (Default - No Docker images)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/DockerImageAsset"
              }
            }
          },
          required: [
            "version"
          ]
        },
        FileAsset: {
          description: "A file asset",
          type: "object",
          properties: {
            source: {
              $ref: "#/definitions/FileSource",
              description: "Source description for file assets"
            },
            destinations: {
              description: "Destinations for this file asset",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/FileDestination"
              }
            }
          },
          required: [
            "destinations",
            "source"
          ]
        },
        FileSource: {
          description: "Describe the source of a file asset",
          type: "object",
          properties: {
            executable: {
              description: "External command which will produce the file asset to upload. (Default - Exactly one of `executable` and `path` is required.)",
              type: "array",
              items: {
                type: "string"
              }
            },
            path: {
              description: "The filesystem object to upload\n\nThis path is relative to the asset manifest location. (Default - Exactly one of `executable` and `path` is required.)",
              type: "string"
            },
            packaging: {
              description: "Packaging method\n\nOnly allowed when `path` is specified. (Default FILE)",
              enum: [
                "file",
                "zip"
              ],
              type: "string"
            }
          }
        },
        FileDestination: {
          description: "Where in S3 a file asset needs to be published",
          type: "object",
          properties: {
            bucketName: {
              description: "The name of the bucket",
              type: "string"
            },
            objectKey: {
              description: "The destination object key",
              type: "string"
            },
            region: {
              description: "The region where this asset will need to be published (Default - Current region)",
              type: "string"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed while publishing this asset (Default - No role will be assumed)",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            }
          },
          required: [
            "bucketName",
            "objectKey"
          ]
        },
        DockerImageAsset: {
          description: "A file asset",
          type: "object",
          properties: {
            source: {
              $ref: "#/definitions/DockerImageSource",
              description: "Source description for file assets"
            },
            destinations: {
              description: "Destinations for this file asset",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/DockerImageDestination"
              }
            }
          },
          required: [
            "destinations",
            "source"
          ]
        },
        DockerImageSource: {
          description: "Properties for how to produce a Docker image from a source",
          type: "object",
          properties: {
            directory: {
              description: "The directory containing the Docker image build instructions.\n\nThis path is relative to the asset manifest location. (Default - Exactly one of `directory` and `executable` is required)",
              type: "string"
            },
            executable: {
              description: "A command-line executable that returns the name of a local\nDocker image on stdout after being run. (Default - Exactly one of `directory` and `executable` is required)",
              type: "array",
              items: {
                type: "string"
              }
            },
            dockerFile: {
              description: "The name of the file with build instructions\n\nOnly allowed when `directory` is set. (Default Dockerfile)",
              type: "string"
            },
            dockerBuildTarget: {
              description: "Target build stage in a Dockerfile with multiple build stages\n\nOnly allowed when `directory` is set. (Default - The last stage in the Dockerfile)",
              type: "string"
            },
            dockerBuildArgs: {
              description: "Additional build arguments\n\nOnly allowed when `directory` is set. (Default - No additional build arguments)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            }
          }
        },
        DockerImageDestination: {
          description: "Where to publish docker images",
          type: "object",
          properties: {
            repositoryName: {
              description: "Name of the ECR repository to publish to",
              type: "string"
            },
            imageTag: {
              description: "Tag of the image to publish",
              type: "string"
            },
            region: {
              description: "The region where this asset will need to be published (Default - Current region)",
              type: "string"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed while publishing this asset (Default - No role will be assumed)",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            }
          },
          required: [
            "imageTag",
            "repositoryName"
          ]
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/schema/cloud-assembly.schema.json
var require_cloud_assembly_schema = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/schema/cloud-assembly.schema.json"(exports, module2) {
    module2.exports = {
      $ref: "#/definitions/AssemblyManifest",
      definitions: {
        AssemblyManifest: {
          description: "A manifest which describes the cloud assembly.",
          type: "object",
          properties: {
            version: {
              description: "Protocol version",
              type: "string"
            },
            artifacts: {
              description: "The set of artifacts in this assembly. (Default - no artifacts.)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/ArtifactManifest"
              }
            },
            missing: {
              description: "Missing context information. If this field has values, it means that the\ncloud assembly is not complete and should not be deployed. (Default - no missing context.)",
              type: "array",
              items: {
                $ref: "#/definitions/MissingContext"
              }
            },
            runtime: {
              description: "Runtime information. (Default - no info.)",
              $ref: "#/definitions/RuntimeInfo"
            }
          },
          required: [
            "version"
          ]
        },
        ArtifactManifest: {
          description: "A manifest for a single artifact within the cloud assembly.",
          type: "object",
          properties: {
            type: {
              $ref: "#/definitions/ArtifactType",
              description: "The type of artifact."
            },
            environment: {
              description: "The environment into which this artifact is deployed. (Default - no envrionment.)",
              type: "string"
            },
            metadata: {
              description: "Associated metadata. (Default - no metadata.)",
              type: "object",
              additionalProperties: {
                type: "array",
                items: {
                  $ref: "#/definitions/MetadataEntry"
                }
              }
            },
            dependencies: {
              description: "IDs of artifacts that must be deployed before this artifact. (Default - no dependencies.)",
              type: "array",
              items: {
                type: "string"
              }
            },
            properties: {
              description: "The set of properties for this artifact (depends on type) (Default - no properties.)",
              anyOf: [
                {
                  $ref: "#/definitions/AwsCloudFormationStackProperties"
                },
                {
                  $ref: "#/definitions/AssetManifestProperties"
                },
                {
                  $ref: "#/definitions/TreeArtifactProperties"
                },
                {
                  $ref: "#/definitions/NestedCloudAssemblyProperties"
                }
              ]
            },
            displayName: {
              description: "A string that represents this artifact. Should only be used in user interfaces. (Default - no display name)",
              type: "string"
            }
          },
          required: [
            "type"
          ]
        },
        ArtifactType: {
          description: "Type of cloud artifact.",
          enum: [
            "aws:cloudformation:stack",
            "cdk:asset-manifest",
            "cdk:cloud-assembly",
            "cdk:tree",
            "none"
          ],
          type: "string"
        },
        MetadataEntry: {
          description: "A metadata entry in a cloud assembly artifact.",
          type: "object",
          properties: {
            type: {
              description: "The type of the metadata entry.",
              type: "string"
            },
            data: {
              description: "The data. (Default - no data.)",
              anyOf: [
                {
                  $ref: "#/definitions/FileAssetMetadataEntry"
                },
                {
                  $ref: "#/definitions/ContainerImageAssetMetadataEntry"
                },
                {
                  type: "array",
                  items: {
                    $ref: "#/definitions/Tag"
                  }
                },
                {
                  type: "string"
                },
                {
                  description: "Free form data."
                }
              ]
            },
            trace: {
              description: "A stack trace for when the entry was created. (Default - no trace.)",
              type: "array",
              items: {
                type: "string"
              }
            }
          },
          required: [
            "type"
          ]
        },
        FileAssetMetadataEntry: {
          description: "Metadata Entry spec for files.",
          type: "object",
          properties: {
            packaging: {
              description: "Requested packaging style",
              enum: [
                "file",
                "zip"
              ],
              type: "string"
            },
            s3BucketParameter: {
              description: "Name of parameter where S3 bucket should be passed in",
              type: "string"
            },
            s3KeyParameter: {
              description: "Name of parameter where S3 key should be passed in",
              type: "string"
            },
            artifactHashParameter: {
              description: "The name of the parameter where the hash of the bundled asset should be passed in.",
              type: "string"
            },
            id: {
              description: "Logical identifier for the asset",
              type: "string"
            },
            sourceHash: {
              description: "The hash of the asset source.",
              type: "string"
            },
            path: {
              description: "Path on disk to the asset",
              type: "string"
            }
          },
          required: [
            "artifactHashParameter",
            "id",
            "packaging",
            "path",
            "s3BucketParameter",
            "s3KeyParameter",
            "sourceHash"
          ]
        },
        ContainerImageAssetMetadataEntry: {
          description: "Metadata Entry spec for container images.",
          type: "object",
          properties: {
            packaging: {
              description: "Type of asset",
              type: "string",
              enum: [
                "container-image"
              ]
            },
            imageNameParameter: {
              description: 'ECR Repository name and repo digest (separated by "@sha256:") where this\nimage is stored. (Default undefined If not specified, `repositoryName` and `imageTag` are\nrequired because otherwise how will the stack know where to find the asset,\nha?)',
              type: "string"
            },
            repositoryName: {
              description: "ECR repository name, if omitted a default name based on the asset's ID is\nused instead. Specify this property if you need to statically address the\nimage, e.g. from a Kubernetes Pod. Note, this is only the repository name,\nwithout the registry and the tag parts. (Default - this parameter is REQUIRED after 1.21.0)",
              type: "string"
            },
            imageTag: {
              description: "The docker image tag to use for tagging pushed images. This field is\nrequired if `imageParameterName` is ommited (otherwise, the app won't be\nable to find the image). (Default - this parameter is REQUIRED after 1.21.0)",
              type: "string"
            },
            buildArgs: {
              description: "Build args to pass to the `docker build` command (Default no build args are passed)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            target: {
              description: "Docker target to build to (Default no build target)",
              type: "string"
            },
            file: {
              description: "Path to the Dockerfile (relative to the directory). (Default - no file is passed)",
              type: "string"
            },
            id: {
              description: "Logical identifier for the asset",
              type: "string"
            },
            sourceHash: {
              description: "The hash of the asset source.",
              type: "string"
            },
            path: {
              description: "Path on disk to the asset",
              type: "string"
            }
          },
          required: [
            "id",
            "packaging",
            "path",
            "sourceHash"
          ]
        },
        Tag: {
          description: "Metadata Entry spec for stack tag.",
          type: "object",
          properties: {
            key: {
              description: 'Tag key.\n\n(In the actual file on disk this will be cased as "Key", and the structure is\npatched to match this structure upon loading:\nhttps://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)',
              type: "string"
            },
            value: {
              description: 'Tag value.\n\n(In the actual file on disk this will be cased as "Value", and the structure is\npatched to match this structure upon loading:\nhttps://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)',
              type: "string"
            }
          },
          required: [
            "key",
            "value"
          ]
        },
        AwsCloudFormationStackProperties: {
          description: "Artifact properties for CloudFormation stacks.",
          type: "object",
          properties: {
            templateFile: {
              description: "A file relative to the assembly root which contains the CloudFormation template for this stack.",
              type: "string"
            },
            parameters: {
              description: "Values for CloudFormation stack parameters that should be passed when the stack is deployed. (Default - No parameters)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            tags: {
              description: "Values for CloudFormation stack tags that should be passed when the stack is deployed. (Default - No tags)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            stackName: {
              description: "The name to use for the CloudFormation stack. (Default - name derived from artifact ID)",
              type: "string"
            },
            terminationProtection: {
              description: "Whether to enable termination protection for this stack.",
              default: false,
              type: "boolean"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed to deploy the stack (Default - No role is assumed (current credentials are used))",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "External ID to use when assuming role for cloudformation deployments (Default - No external ID)",
              type: "string"
            },
            cloudFormationExecutionRoleArn: {
              description: "The role that is passed to CloudFormation to execute the change set (Default - No role is passed (currently assumed role/credentials are used))",
              type: "string"
            },
            stackTemplateAssetObjectUrl: {
              description: "If the stack template has already been included in the asset manifest, its asset URL (Default - Not uploaded yet, upload just before deploying)",
              type: "string"
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to deploy this stack (Default - No bootstrap stack required)",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "SSM parameter where the bootstrap stack version number can be found\n\nOnly used if `requiresBootstrapStackVersion` is set.\n\n- If this value is not set, the bootstrap stack name must be known at\n  deployment time so the stack version can be looked up from the stack\n  outputs.\n- If this value is set, the bootstrap stack can have any name because\n  we won't need to look it up. (Default - Bootstrap stack version number looked up)",
              type: "string"
            },
            validateOnSynth: {
              description: "Whether this stack should be validated by the CLI after synthesis (Default - false)",
              type: "boolean"
            }
          },
          required: [
            "templateFile"
          ]
        },
        AssetManifestProperties: {
          description: "Artifact properties for the Asset Manifest",
          type: "object",
          properties: {
            file: {
              description: "Filename of the asset manifest",
              type: "string"
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to deploy this stack (Default - Version 1 (basic modern bootstrap stack))",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "SSM parameter where the bootstrap stack version number can be found\n\n- If this value is not set, the bootstrap stack name must be known at\n  deployment time so the stack version can be looked up from the stack\n  outputs.\n- If this value is set, the bootstrap stack can have any name because\n  we won't need to look it up. (Default - Bootstrap stack version number looked up)",
              type: "string"
            }
          },
          required: [
            "file"
          ]
        },
        TreeArtifactProperties: {
          description: "Artifact properties for the Construct Tree Artifact",
          type: "object",
          properties: {
            file: {
              description: "Filename of the tree artifact",
              type: "string"
            }
          },
          required: [
            "file"
          ]
        },
        NestedCloudAssemblyProperties: {
          description: "Artifact properties for nested cloud assemblies",
          type: "object",
          properties: {
            directoryName: {
              description: "Relative path to the nested cloud assembly",
              type: "string"
            },
            displayName: {
              description: "Display name for the cloud assembly (Default - The artifact ID)",
              type: "string"
            }
          },
          required: [
            "directoryName"
          ]
        },
        MissingContext: {
          description: "Represents a missing piece of context.",
          type: "object",
          properties: {
            key: {
              description: "The missing context key.",
              type: "string"
            },
            provider: {
              $ref: "#/definitions/ContextProvider",
              description: "The provider from which we expect this context key to be obtained."
            },
            props: {
              description: "A set of provider-specific options.",
              anyOf: [
                {
                  $ref: "#/definitions/AmiContextQuery"
                },
                {
                  $ref: "#/definitions/AvailabilityZonesContextQuery"
                },
                {
                  $ref: "#/definitions/HostedZoneContextQuery"
                },
                {
                  $ref: "#/definitions/SSMParameterContextQuery"
                },
                {
                  $ref: "#/definitions/VpcContextQuery"
                },
                {
                  $ref: "#/definitions/EndpointServiceAvailabilityZonesContextQuery"
                },
                {
                  $ref: "#/definitions/LoadBalancerContextQuery"
                },
                {
                  $ref: "#/definitions/LoadBalancerListenerContextQuery"
                },
                {
                  $ref: "#/definitions/SecurityGroupContextQuery"
                },
                {
                  $ref: "#/definitions/KeyContextQuery"
                }
              ]
            }
          },
          required: [
            "key",
            "props",
            "provider"
          ]
        },
        ContextProvider: {
          description: "Identifier for the context provider",
          enum: [
            "ami",
            "availability-zones",
            "endpoint-service-availability-zones",
            "hosted-zone",
            "key-provider",
            "load-balancer",
            "load-balancer-listener",
            "security-group",
            "ssm",
            "vpc-provider"
          ],
          type: "string"
        },
        AmiContextQuery: {
          description: "Query to AMI context provider",
          type: "object",
          properties: {
            account: {
              description: "Account to query",
              type: "string"
            },
            region: {
              description: "Region to query",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            owners: {
              description: "Owners to DescribeImages call (Default - All owners)",
              type: "array",
              items: {
                type: "string"
              }
            },
            filters: {
              description: "Filters to DescribeImages call",
              type: "object",
              additionalProperties: {
                type: "array",
                items: {
                  type: "string"
                }
              }
            }
          },
          required: [
            "account",
            "filters",
            "region"
          ]
        },
        AvailabilityZonesContextQuery: {
          description: "Query to availability zone context provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            }
          },
          required: [
            "account",
            "region"
          ]
        },
        HostedZoneContextQuery: {
          description: "Query to hosted zone context provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            domainName: {
              description: "The domain name e.g. example.com to lookup",
              type: "string"
            },
            privateZone: {
              description: "True if the zone you want to find is a private hosted zone",
              default: false,
              type: "boolean"
            },
            vpcId: {
              description: "The VPC ID to that the private zone must be associated with\n\nIf you provide VPC ID and privateZone is false, this will return no results\nand raise an error. (Default - Required if privateZone=true)",
              type: "string"
            }
          },
          required: [
            "account",
            "domainName",
            "region"
          ]
        },
        SSMParameterContextQuery: {
          description: "Query to SSM Parameter Context Provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            parameterName: {
              description: "Parameter name to query",
              type: "string"
            }
          },
          required: [
            "account",
            "parameterName",
            "region"
          ]
        },
        VpcContextQuery: {
          description: "Query input for looking up a VPC",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            filter: {
              description: "Filters to apply to the VPC\n\nFilter parameters are the same as passed to DescribeVpcs.",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            returnAsymmetricSubnets: {
              description: "Whether to populate the subnetGroups field of the {@link VpcContextResponse},\nwhich contains potentially asymmetric subnet groups.",
              default: false,
              type: "boolean"
            },
            subnetGroupNameTag: {
              description: "Optional tag for subnet group name.\nIf not provided, we'll look at the aws-cdk:subnet-name tag.\nIf the subnet does not have the specified tag,\nwe'll use its type as the name. (Default 'aws-cdk:subnet-name')",
              type: "string"
            }
          },
          required: [
            "account",
            "filter",
            "region"
          ]
        },
        EndpointServiceAvailabilityZonesContextQuery: {
          description: "Query to endpoint service context provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            serviceName: {
              description: "Query service name",
              type: "string"
            }
          },
          required: [
            "account",
            "region",
            "serviceName"
          ]
        },
        LoadBalancerContextQuery: {
          description: "Query input for looking up a load balancer",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            loadBalancerType: {
              $ref: "#/definitions/LoadBalancerType",
              description: "Filter load balancers by their type"
            },
            loadBalancerArn: {
              description: "Find by load balancer's ARN (Default - does not search by load balancer arn)",
              type: "string"
            },
            loadBalancerTags: {
              description: "Match load balancer tags (Default - does not match load balancers by tags)",
              type: "array",
              items: {
                $ref: "#/definitions/Tag"
              }
            }
          },
          required: [
            "account",
            "loadBalancerType",
            "region"
          ]
        },
        LoadBalancerType: {
          description: "Type of load balancer",
          enum: [
            "application",
            "network"
          ],
          type: "string"
        },
        LoadBalancerListenerContextQuery: {
          description: "Query input for looking up a load balancer listener",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            listenerArn: {
              description: "Find by listener's arn (Default - does not find by listener arn)",
              type: "string"
            },
            listenerProtocol: {
              description: "Filter by listener protocol (Default - does not filter by listener protocol)",
              enum: [
                "HTTP",
                "HTTPS",
                "TCP",
                "TCP_UDP",
                "TLS",
                "UDP"
              ],
              type: "string"
            },
            listenerPort: {
              description: "Filter listeners by listener port (Default - does not filter by a listener port)",
              type: "number"
            },
            loadBalancerType: {
              $ref: "#/definitions/LoadBalancerType",
              description: "Filter load balancers by their type"
            },
            loadBalancerArn: {
              description: "Find by load balancer's ARN (Default - does not search by load balancer arn)",
              type: "string"
            },
            loadBalancerTags: {
              description: "Match load balancer tags (Default - does not match load balancers by tags)",
              type: "array",
              items: {
                $ref: "#/definitions/Tag"
              }
            }
          },
          required: [
            "account",
            "loadBalancerType",
            "region"
          ]
        },
        SecurityGroupContextQuery: {
          description: "Query input for looking up a security group",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            securityGroupId: {
              description: "Security group id",
              type: "string"
            }
          },
          required: [
            "account",
            "region",
            "securityGroupId"
          ]
        },
        KeyContextQuery: {
          description: "Query input for looking up a KMS Key",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            aliasName: {
              description: "Alias name used to search the Key",
              type: "string"
            }
          },
          required: [
            "account",
            "aliasName",
            "region"
          ]
        },
        RuntimeInfo: {
          description: "Information about the application's runtime components.",
          type: "object",
          properties: {
            libraries: {
              description: "The list of libraries loaded in the application, associated with their versions.",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            }
          },
          required: [
            "libraries"
          ]
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/schema/cloud-assembly.version.json
var require_cloud_assembly_version = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/schema/cloud-assembly.version.json"(exports, module2) {
    module2.exports = { version: "14.0.0" };
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/manifest.js
var require_manifest = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/manifest.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Manifest = exports.VERSION_MISMATCH = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var jsonschema = require_lib2();
    var semver = require_semver4();
    var assembly = require_cloud_assembly();
    exports.VERSION_MISMATCH = "Cloud assembly schema version mismatch";
    var ASSETS_SCHEMA = require_assets_schema();
    var ASSEMBLY_SCHEMA = require_cloud_assembly_schema();
    var SCHEMA_VERSION = require_cloud_assembly_version().version;
    var Manifest = class {
      constructor() {
      }
      static saveAssemblyManifest(manifest, filePath) {
        Manifest.saveManifest(manifest, filePath, ASSEMBLY_SCHEMA, Manifest.patchStackTagsOnWrite);
      }
      static loadAssemblyManifest(filePath) {
        return Manifest.loadManifest(filePath, ASSEMBLY_SCHEMA, Manifest.patchStackTagsOnRead);
      }
      static saveAssetManifest(manifest, filePath) {
        Manifest.saveManifest(manifest, filePath, ASSETS_SCHEMA, Manifest.patchStackTagsOnRead);
      }
      static loadAssetManifest(filePath) {
        return this.loadManifest(filePath, ASSETS_SCHEMA);
      }
      static version() {
        return SCHEMA_VERSION;
      }
      static save(manifest, filePath) {
        return this.saveAssemblyManifest(manifest, filePath);
      }
      static load(filePath) {
        return this.loadAssemblyManifest(filePath);
      }
      static validate(manifest, schema) {
        function parseVersion(version) {
          const ver = semver.valid(version);
          if (!ver) {
            throw new Error(`Invalid semver string: "${version}"`);
          }
          return ver;
        }
        const maxSupported = parseVersion(Manifest.version());
        const actual = parseVersion(manifest.version);
        if (semver.gt(actual, maxSupported)) {
          throw new Error(`${exports.VERSION_MISMATCH}: Maximum schema version supported is ${maxSupported}, but found ${actual}`);
        }
        const validator = new jsonschema.Validator();
        const result = validator.validate(manifest, schema, {
          nestedErrors: true,
          allowUnknownAttributes: false
        });
        if (!result.valid) {
          throw new Error(`Invalid assembly manifest:
${result}`);
        }
      }
      static saveManifest(manifest, filePath, schema, preprocess) {
        let withVersion = __spreadProps(__spreadValues({}, manifest), { version: Manifest.version() });
        Manifest.validate(withVersion, schema);
        if (preprocess) {
          withVersion = preprocess(withVersion);
        }
        fs.writeFileSync(filePath, JSON.stringify(withVersion, void 0, 2));
      }
      static loadManifest(filePath, schema, preprocess) {
        let obj = JSON.parse(fs.readFileSync(filePath, { encoding: "utf-8" }));
        if (preprocess) {
          obj = preprocess(obj);
        }
        Manifest.validate(obj, schema);
        return obj;
      }
      static patchStackTagsOnRead(manifest) {
        return Manifest.replaceStackTags(manifest, (tags) => tags.map((diskTag) => ({
          key: diskTag.Key,
          value: diskTag.Value
        })));
      }
      static patchStackTagsOnWrite(manifest) {
        return Manifest.replaceStackTags(manifest, (tags) => tags.map((memTag) => "Key" in memTag ? memTag : { Key: memTag.key, Value: memTag.value }));
      }
      static replaceStackTags(manifest, fn) {
        return noUndefined(__spreadProps(__spreadValues({}, manifest), {
          artifacts: mapValues(manifest.artifacts, (artifact) => {
            if (artifact.type !== assembly.ArtifactType.AWS_CLOUDFORMATION_STACK) {
              return artifact;
            }
            return noUndefined(__spreadProps(__spreadValues({}, artifact), {
              metadata: mapValues(artifact.metadata, (metadataEntries) => metadataEntries.map((metadataEntry) => {
                if (metadataEntry.type !== assembly.ArtifactMetadataEntryType.STACK_TAGS || !metadataEntry.data) {
                  return metadataEntry;
                }
                return __spreadProps(__spreadValues({}, metadataEntry), {
                  data: fn(metadataEntry.data)
                });
              }))
            }));
          })
        }));
      }
    };
    exports.Manifest = Manifest;
    _a = JSII_RTTI_SYMBOL_1;
    Manifest[_a] = { fqn: "@aws-cdk/cloud-assembly-schema.Manifest", version: "1.128.0" };
    function mapValues(xs, fn) {
      if (!xs) {
        return void 0;
      }
      const ret = {};
      for (const [k, v] of Object.entries(xs)) {
        ret[k] = fn(v);
      }
      return ret;
    }
    function noUndefined(xs) {
      const ret = {};
      for (const [k, v] of Object.entries(xs)) {
        if (v !== void 0) {
          ret[k] = v;
        }
      }
      return ret;
    }
  }
});

// node_modules/@aws-cdk/cloud-assembly-schema/lib/index.js
var require_lib3 = __commonJS({
  "node_modules/@aws-cdk/cloud-assembly-schema/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_cloud_assembly(), exports);
    __exportStar(require_assets(), exports);
    __exportStar(require_manifest(), exports);
  }
});

// node_modules/constructs/lib/aspect.js
var require_aspect2 = __commonJS({
  "node_modules/constructs/lib/aspect.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/constructs/lib/metadata.js
var require_metadata = __commonJS({
  "node_modules/constructs/lib/metadata.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ConstructMetadata = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var ConstructMetadata = class {
      constructor() {
      }
    };
    exports.ConstructMetadata = ConstructMetadata;
    _a = JSII_RTTI_SYMBOL_1;
    ConstructMetadata[_a] = { fqn: "constructs.ConstructMetadata", version: "3.3.161" };
    ConstructMetadata.DISABLE_STACK_TRACE_IN_METADATA = "disable-stack-trace";
    ConstructMetadata.INFO_METADATA_KEY = "info";
    ConstructMetadata.WARNING_METADATA_KEY = "warning";
    ConstructMetadata.ERROR_METADATA_KEY = "error";
  }
});

// node_modules/constructs/lib/private/dependency.js
var require_dependency = __commonJS({
  "node_modules/constructs/lib/private/dependency.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DependableTrait = exports.ConcreteDependable = void 0;
    var ConcreteDependable = class {
      constructor() {
        this._dependencyRoots = new Array();
        const self = this;
        DependableTrait.implement(this, {
          get dependencyRoots() {
            return self._dependencyRoots;
          }
        });
      }
      add(construct) {
        this._dependencyRoots.push(construct);
      }
    };
    exports.ConcreteDependable = ConcreteDependable;
    var DEPENDABLE_SYMBOL = Symbol.for("@aws-cdk/core.DependableTrait");
    var DependableTrait = class {
      static implement(instance, trait) {
        instance[DEPENDABLE_SYMBOL] = trait;
      }
      static get(instance) {
        const ret = instance[DEPENDABLE_SYMBOL];
        if (!ret) {
          throw new Error(`${instance} does not implement DependableTrait`);
        }
        return ret;
      }
    };
    exports.DependableTrait = DependableTrait;
  }
});

// node_modules/constructs/lib/private/stack-trace.js
var require_stack_trace = __commonJS({
  "node_modules/constructs/lib/private/stack-trace.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.captureStackTrace = void 0;
    function captureStackTrace(below) {
      below = below || captureStackTrace;
      const object = { stack: "" };
      const previousLimit = Error.stackTraceLimit;
      try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
      } finally {
        Error.stackTraceLimit = previousLimit;
      }
      if (!object.stack) {
        return [];
      }
      return object.stack.split("\n").slice(1).map((s) => s.replace(/^\s*at\s+/, ""));
    }
    exports.captureStackTrace = captureStackTrace;
  }
});

// node_modules/constructs/lib/private/uniqueid.js
var require_uniqueid = __commonJS({
  "node_modules/constructs/lib/private/uniqueid.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.makeLegacyUniqueId = exports.addressOf = void 0;
    var crypto = require("crypto");
    var HIDDEN_FROM_HUMAN_ID = "Resource";
    var HIDDEN_ID = "Default";
    var PATH_SEP = "/";
    var HASH_LEN = 8;
    var MAX_HUMAN_LEN = 240;
    var MAX_ID_LEN = 255;
    function addressOf(components) {
      const hash = crypto.createHash("sha1");
      for (const c of components) {
        if (c === HIDDEN_ID) {
          continue;
        }
        hash.update(c);
        hash.update("\n");
      }
      return "c8" + hash.digest("hex");
    }
    exports.addressOf = addressOf;
    function makeLegacyUniqueId(components) {
      components = components.filter((x) => x !== HIDDEN_ID);
      if (components.length === 0) {
        throw new Error("Unable to calculate a unique id for an empty set of components");
      }
      if (components.length === 1) {
        const candidate = removeNonAlphanumeric(components[0]);
        if (candidate.length <= MAX_ID_LEN) {
          return candidate;
        }
      }
      const hash = legacyPathHash(components);
      const human = removeDupes(components).filter((x) => x !== HIDDEN_FROM_HUMAN_ID).map(removeNonAlphanumeric).join("").slice(0, MAX_HUMAN_LEN);
      return human + hash;
    }
    exports.makeLegacyUniqueId = makeLegacyUniqueId;
    function legacyPathHash(path) {
      const md5 = crypto.createHash("md5").update(path.join(PATH_SEP)).digest("hex");
      return md5.slice(0, HASH_LEN).toUpperCase();
    }
    function removeNonAlphanumeric(s) {
      return s.replace(/[^A-Za-z0-9]/g, "");
    }
    function removeDupes(path) {
      const ret = new Array();
      for (const component of path) {
        if (ret.length === 0 || !ret[ret.length - 1].endsWith(component)) {
          ret.push(component);
        }
      }
      return ret;
    }
  }
});

// node_modules/constructs/lib/construct.js
var require_construct = __commonJS({
  "node_modules/constructs/lib/construct.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ConstructOrder = exports.Construct = exports.Node = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var metadata_1 = require_metadata();
    var dependency_1 = require_dependency();
    var stack_trace_1 = require_stack_trace();
    var uniqueid_1 = require_uniqueid();
    var CONSTRUCT_NODE_PROPERTY_SYMBOL = Symbol.for("constructs.Construct.node");
    var Node = class {
      constructor(host, scope, id) {
        this.host = host;
        this._locked = false;
        this._aspects = [];
        this._children = {};
        this._context = {};
        this._metadata = new Array();
        this._dependencies = /* @__PURE__ */ new Set();
        this.invokedAspects = [];
        this._validations = new Array();
        id = id || "";
        this.id = sanitizeId(id);
        this.scope = scope;
        if (scope != null) {
          if (id === "") {
            throw new Error("Only root constructs may have an empty name");
          }
          Node.of(scope).addChild(host, this.id);
        } else {
          this.id = id;
        }
      }
      static of(construct) {
        const node = construct[CONSTRUCT_NODE_PROPERTY_SYMBOL];
        if (!node) {
          throw new Error('construct does not have an associated node. All constructs must extend the "Construct" base class');
        }
        return node;
      }
      get path() {
        const components = this.scopes.slice(1).map((c) => Node.of(c).id);
        return components.join(Node.PATH_SEP);
      }
      get addr() {
        if (!this._addr) {
          this._addr = uniqueid_1.addressOf(this.scopes.map((c) => Node.of(c).id));
        }
        return this._addr;
      }
      get uniqueId() {
        const components = this.scopes.slice(1).map((c) => Node.of(c).id);
        return components.length > 0 ? uniqueid_1.makeLegacyUniqueId(components) : "";
      }
      tryFindChild(id) {
        return this._children[sanitizeId(id)];
      }
      findChild(id) {
        const ret = this.tryFindChild(id);
        if (!ret) {
          throw new Error(`No child with id: '${id}'`);
        }
        return ret;
      }
      get defaultChild() {
        if (this._defaultChild !== void 0) {
          return this._defaultChild;
        }
        const resourceChild = this.tryFindChild("Resource");
        const defaultChild = this.tryFindChild("Default");
        if (resourceChild && defaultChild) {
          throw new Error(`Cannot determine default child for ${this.path}. There is both a child with id "Resource" and id "Default"`);
        }
        return defaultChild || resourceChild;
      }
      set defaultChild(value) {
        this._defaultChild = value;
      }
      get children() {
        return Object.values(this._children);
      }
      findAll(order = ConstructOrder.PREORDER) {
        const ret = new Array();
        visit(this.host);
        return ret;
        function visit(c) {
          if (order === ConstructOrder.PREORDER) {
            ret.push(c);
          }
          for (const child of Node.of(c).children) {
            visit(child);
          }
          if (order === ConstructOrder.POSTORDER) {
            ret.push(c);
          }
        }
      }
      setContext(key, value) {
        if (this.children.length > 0) {
          const names = this.children.map((c) => Node.of(c).id);
          throw new Error("Cannot set context after children have been added: " + names.join(","));
        }
        this._context[key] = value;
      }
      tryGetContext(key) {
        const value = this._context[key];
        if (value !== void 0) {
          return value;
        }
        return this.scope && Node.of(this.scope).tryGetContext(key);
      }
      get metadata() {
        return [...this._metadata];
      }
      addMetadata(type, data, fromFunction) {
        if (data == null) {
          return;
        }
        const trace = this.tryGetContext(metadata_1.ConstructMetadata.DISABLE_STACK_TRACE_IN_METADATA) ? void 0 : stack_trace_1.captureStackTrace(fromFunction || this.addMetadata);
        this._metadata.push({ type, data, trace });
      }
      addInfo(message) {
        this.addMetadata(metadata_1.ConstructMetadata.INFO_METADATA_KEY, message);
      }
      addWarning(message) {
        this.addMetadata(metadata_1.ConstructMetadata.WARNING_METADATA_KEY, message);
      }
      addError(message) {
        this.addMetadata(metadata_1.ConstructMetadata.ERROR_METADATA_KEY, message);
      }
      applyAspect(aspect) {
        this._aspects.push(aspect);
        return;
      }
      get scopes() {
        const ret = new Array();
        let curr = this.host;
        while (curr) {
          ret.unshift(curr);
          curr = Node.of(curr).scope;
        }
        return ret;
      }
      get root() {
        return this.scopes[0];
      }
      get locked() {
        if (this._locked) {
          return true;
        }
        if (this.scope && Node.of(this.scope).locked) {
          return true;
        }
        return false;
      }
      addDependency(...dependencies) {
        for (const dependency of dependencies) {
          this._dependencies.add(dependency);
        }
      }
      get dependencies() {
        const found = /* @__PURE__ */ new Map();
        const ret = new Array();
        for (const source of this.findAll()) {
          for (const dependable of Node.of(source)._dependencies) {
            for (const target of dependency_1.DependableTrait.get(dependable).dependencyRoots) {
              let foundTargets = found.get(source);
              if (!foundTargets) {
                found.set(source, foundTargets = /* @__PURE__ */ new Set());
              }
              if (!foundTargets.has(target)) {
                ret.push({ source, target });
                foundTargets.add(target);
              }
            }
          }
        }
        return ret;
      }
      tryRemoveChild(childName) {
        if (!(childName in this._children)) {
          return false;
        }
        delete this._children[childName];
        return true;
      }
      addValidation(validation) {
        this._validations.push(validation);
      }
      synthesize(options) {
        this.prepare();
        const validate = options.skipValidation === void 0 ? true : !options.skipValidation;
        if (validate) {
          const errors = this.validate();
          if (errors.length > 0) {
            const errorList = errors.map((e) => `[${Node.of(e.source).path}] ${e.message}`).join("\n  ");
            throw new Error(`Validation failed with the following errors:
  ${errorList}`);
          }
        }
        for (const construct of this.findAll(ConstructOrder.POSTORDER)) {
          const node = Node.of(construct);
          try {
            node._lock();
            const ctx = __spreadProps(__spreadValues({}, options.sessionContext), {
              outdir: options.outdir
            });
            construct.onSynthesize(ctx);
          } finally {
            node._unlock();
          }
        }
      }
      prepare() {
        for (const construct of this.findAll(ConstructOrder.PREORDER)) {
          Node.of(construct).invokeAspects();
        }
        for (const construct of this.findAll(ConstructOrder.PREORDER).reverse()) {
          const cn = construct;
          if ("onPrepare" in cn) {
            if (typeof cn.onPrepare !== "function") {
              throw new Error('expecting "onPrepare" to be a function');
            }
            cn.onPrepare();
          }
        }
      }
      validate() {
        let errors = new Array();
        for (const child of this.children) {
          errors = errors.concat(Node.of(child).validate());
        }
        const localErrors = this.host.onValidate();
        for (const v of this._validations) {
          localErrors.push(...v.validate());
        }
        return errors.concat(localErrors.map((msg) => ({ source: this.host, message: msg })));
      }
      _lock() {
        this._locked = true;
      }
      _unlock() {
        this._locked = false;
      }
      addChild(child, childName) {
        if (this.locked) {
          if (!this.path) {
            throw new Error("Cannot add children during synthesis");
          }
          throw new Error(`Cannot add children to "${this.path}" during synthesis`);
        }
        if (childName in this._children) {
          const name = this.id || "";
          const typeName = this.host.constructor.name;
          throw new Error(`There is already a Construct with name '${childName}' in ${typeName}${name.length > 0 ? " [" + name + "]" : ""}`);
        }
        this._children[childName] = child;
      }
      invokeAspects() {
        const descendants = this.findAll();
        for (const aspect of this._aspects) {
          if (this.invokedAspects.includes(aspect)) {
            continue;
          }
          descendants.forEach((member) => aspect.visit(member));
          this.invokedAspects.push(aspect);
        }
      }
    };
    exports.Node = Node;
    _a = JSII_RTTI_SYMBOL_1;
    Node[_a] = { fqn: "constructs.Node", version: "3.3.161" };
    Node.PATH_SEP = "/";
    var Construct = class {
      constructor(scope, id, options = {}) {
        var _c;
        const nodeFactory = (_c = options.nodeFactory) !== null && _c !== void 0 ? _c : { createNode: (host, nodeScope, nodeId) => new Node(host, nodeScope, nodeId) };
        Object.defineProperty(this, CONSTRUCT_NODE_PROPERTY_SYMBOL, {
          value: nodeFactory.createNode(this, scope, id),
          enumerable: false,
          configurable: false
        });
        dependency_1.DependableTrait.implement(this, {
          dependencyRoots: [this]
        });
      }
      toString() {
        return Node.of(this).path || "<root>";
      }
      onValidate() {
        return [];
      }
      onPrepare() {
        return;
      }
      onSynthesize(session) {
        ignore(session);
      }
    };
    exports.Construct = Construct;
    _b = JSII_RTTI_SYMBOL_1;
    Construct[_b] = { fqn: "constructs.Construct", version: "3.3.161" };
    var ConstructOrder;
    (function(ConstructOrder2) {
      ConstructOrder2[ConstructOrder2["PREORDER"] = 0] = "PREORDER";
      ConstructOrder2[ConstructOrder2["POSTORDER"] = 1] = "POSTORDER";
    })(ConstructOrder = exports.ConstructOrder || (exports.ConstructOrder = {}));
    function ignore(_x) {
      return;
    }
    var PATH_SEP_REGEX = new RegExp(`${Node.PATH_SEP}`, "g");
    function sanitizeId(id) {
      return id.replace(PATH_SEP_REGEX, "--");
    }
  }
});

// node_modules/constructs/lib/index.js
var require_lib4 = __commonJS({
  "node_modules/constructs/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_aspect2(), exports);
    __exportStar(require_construct(), exports);
    __exportStar(require_metadata(), exports);
  }
});

// node_modules/@aws-cdk/core/lib/annotations.js
var require_annotations = __commonJS({
  "node_modules/@aws-cdk/core/lib/annotations.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Annotations = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxschema = require_lib3();
    var constructs_1 = require_lib4();
    var DEPRECATIONS_SYMBOL = Symbol.for("@aws-cdk/core.deprecations");
    var Annotations = class {
      constructor(scope) {
        this.scope = scope;
      }
      static of(scope) {
        return new Annotations(scope);
      }
      addWarning(message) {
        this.addMessage(cxschema.ArtifactMetadataEntryType.WARN, message);
      }
      addInfo(message) {
        this.addMessage(cxschema.ArtifactMetadataEntryType.INFO, message);
      }
      addError(message) {
        this.addMessage(cxschema.ArtifactMetadataEntryType.ERROR, message);
      }
      addDeprecation(api, message) {
        const text = `The API ${api} is deprecated: ${message}. This API will be removed in the next major release`;
        if (process.env.CDK_BLOCK_DEPRECATIONS) {
          throw new Error(`${constructs_1.Node.of(this.scope).path}: ${text}`);
        }
        const set = this.deprecationsReported;
        if (set.has(api)) {
          return;
        }
        this.addWarning(text);
        set.add(api);
      }
      addMessage(level, message) {
        constructs_1.Node.of(this.scope).addMetadata(level, message);
      }
      get deprecationsReported() {
        let set = this.scope[DEPRECATIONS_SYMBOL];
        if (!set) {
          set = /* @__PURE__ */ new Set();
          Object.defineProperty(this.scope, DEPRECATIONS_SYMBOL, { value: set });
        }
        return set;
      }
    };
    exports.Annotations = Annotations;
    _a = JSII_RTTI_SYMBOL_1;
    Annotations[_a] = { fqn: "@aws-cdk/core.Annotations", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/cx-api/lib/cxapi.js
var require_cxapi = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/cxapi.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.PROVIDER_ERROR_KEY = exports.CLI_VERSION_ENV = exports.CLI_ASM_VERSION_ENV = exports.DEFAULT_REGION_ENV = exports.DEFAULT_ACCOUNT_ENV = exports.CONTEXT_ENV = exports.OUTDIR_ENV = void 0;
    exports.OUTDIR_ENV = "CDK_OUTDIR";
    exports.CONTEXT_ENV = "CDK_CONTEXT_JSON";
    exports.DEFAULT_ACCOUNT_ENV = "CDK_DEFAULT_ACCOUNT";
    exports.DEFAULT_REGION_ENV = "CDK_DEFAULT_REGION";
    exports.CLI_ASM_VERSION_ENV = "CDK_CLI_ASM_VERSION";
    exports.CLI_VERSION_ENV = "CDK_CLI_VERSION";
    exports.PROVIDER_ERROR_KEY = "$providerError";
  }
});

// node_modules/@aws-cdk/cx-api/lib/context/vpc.js
var require_vpc = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/context/vpc.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.VpcSubnetGroupType = void 0;
    var VpcSubnetGroupType;
    (function(VpcSubnetGroupType2) {
      VpcSubnetGroupType2["PUBLIC"] = "Public";
      VpcSubnetGroupType2["PRIVATE"] = "Private";
      VpcSubnetGroupType2["ISOLATED"] = "Isolated";
    })(VpcSubnetGroupType = exports.VpcSubnetGroupType || (exports.VpcSubnetGroupType = {}));
  }
});

// node_modules/@aws-cdk/cx-api/lib/context/ami.js
var require_ami = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/context/ami.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/@aws-cdk/cx-api/lib/context/load-balancer.js
var require_load_balancer = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/context/load-balancer.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.LoadBalancerIpAddressType = void 0;
    var LoadBalancerIpAddressType;
    (function(LoadBalancerIpAddressType2) {
      LoadBalancerIpAddressType2["IPV4"] = "ipv4";
      LoadBalancerIpAddressType2["DUAL_STACK"] = "dualstack";
    })(LoadBalancerIpAddressType = exports.LoadBalancerIpAddressType || (exports.LoadBalancerIpAddressType = {}));
  }
});

// node_modules/@aws-cdk/cx-api/lib/context/availability-zones.js
var require_availability_zones = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/context/availability-zones.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY = void 0;
    exports.AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY = "aws:cdk:availability-zones:fallback";
  }
});

// node_modules/@aws-cdk/cx-api/lib/context/endpoint-service-availability-zones.js
var require_endpoint_service_availability_zones = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/context/endpoint-service-availability-zones.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = void 0;
    exports.ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = "endpoint-service-availability-zones";
  }
});

// node_modules/@aws-cdk/cx-api/lib/context/security-group.js
var require_security_group = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/context/security-group.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/@aws-cdk/cx-api/lib/context/key.js
var require_key = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/context/key.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/@aws-cdk/cx-api/lib/metadata.js
var require_metadata2 = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/metadata.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.SynthesisMessageLevel = exports.PATH_METADATA_KEY = void 0;
    exports.PATH_METADATA_KEY = "aws:cdk:path";
    var SynthesisMessageLevel;
    (function(SynthesisMessageLevel2) {
      SynthesisMessageLevel2["INFO"] = "info";
      SynthesisMessageLevel2["WARNING"] = "warning";
      SynthesisMessageLevel2["ERROR"] = "error";
    })(SynthesisMessageLevel = exports.SynthesisMessageLevel || (exports.SynthesisMessageLevel = {}));
  }
});

// node_modules/@aws-cdk/cx-api/lib/artifacts/asset-manifest-artifact.js
var require_asset_manifest_artifact = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/artifacts/asset-manifest-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.AssetManifestArtifact = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var path = require("path");
    var cloud_artifact_1 = require_cloud_artifact();
    var AssetManifestArtifact = class extends cloud_artifact_1.CloudArtifact {
      constructor(assembly, name, artifact) {
        var _b;
        super(assembly, name, artifact);
        const properties = this.manifest.properties || {};
        if (!properties.file) {
          throw new Error('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = (_b = properties.requiresBootstrapStackVersion) !== null && _b !== void 0 ? _b : 1;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
      }
    };
    exports.AssetManifestArtifact = AssetManifestArtifact;
    _a = JSII_RTTI_SYMBOL_1;
    AssetManifestArtifact[_a] = { fqn: "@aws-cdk/cx-api.AssetManifestArtifact", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/cx-api/lib/environment.js
var require_environment = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/environment.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.EnvironmentUtils = exports.UNKNOWN_REGION = exports.UNKNOWN_ACCOUNT = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
    exports.UNKNOWN_ACCOUNT = "unknown-account";
    exports.UNKNOWN_REGION = "unknown-region";
    var EnvironmentUtils = class {
      static parse(environment) {
        const env2 = AWS_ENV_REGEX.exec(environment);
        if (!env2) {
          throw new Error(`Unable to parse environment specification "${environment}". Expected format: aws://account/region`);
        }
        const [, account, region] = env2;
        if (!account || !region) {
          throw new Error(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
      }
      static make(account, region) {
        return { account, region, name: this.format(account, region) };
      }
      static format(account, region) {
        return `aws://${account}/${region}`;
      }
    };
    exports.EnvironmentUtils = EnvironmentUtils;
    _a = JSII_RTTI_SYMBOL_1;
    EnvironmentUtils[_a] = { fqn: "@aws-cdk/cx-api.EnvironmentUtils", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/cx-api/lib/artifacts/cloudformation-artifact.js
var require_cloudformation_artifact = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/artifacts/cloudformation-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CloudFormationStackArtifact = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var cxschema = require_lib3();
    var cloud_artifact_1 = require_cloud_artifact();
    var environment_1 = require_environment();
    var CloudFormationStackArtifact = class extends cloud_artifact_1.CloudArtifact {
      constructor(assembly, artifactId, artifact) {
        var _b, _c;
        super(assembly, artifactId, artifact);
        const properties = this.manifest.properties || {};
        if (!properties.templateFile) {
          throw new Error('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        if (!artifact.environment) {
          throw new Error("Invalid CloudFormation stack artifact. Missing environment");
        }
        this.environment = environment_1.EnvironmentUtils.parse(artifact.environment);
        this.templateFile = properties.templateFile;
        this.parameters = (_b = properties.parameters) !== null && _b !== void 0 ? _b : {};
        this.tags = (_c = properties.tags) !== null && _c !== void 0 ? _c : this.tagsFromMetadata();
        this.assumeRoleArn = properties.assumeRoleArn;
        this.assumeRoleExternalId = properties.assumeRoleExternalId;
        this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn;
        this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl;
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
        this.terminationProtection = properties.terminationProtection;
        this.validateOnSynth = properties.validateOnSynth;
        this.stackName = properties.stackName || artifactId;
        this.assets = this.findMetadataByType(cxschema.ArtifactMetadataEntryType.ASSET).map((e) => e.data);
        this.displayName = this.stackName === artifactId ? this.stackName : `${artifactId} (${this.stackName})`;
        this.name = this.stackName;
        this.originalName = this.stackName;
      }
      get templateFullPath() {
        return path.join(this.assembly.directory, this.templateFile);
      }
      get template() {
        if (this._template === void 0) {
          this._template = JSON.parse(fs.readFileSync(this.templateFullPath, "utf-8"));
        }
        return this._template;
      }
      tagsFromMetadata() {
        var _b;
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS)) {
          for (const tag of (_b = metadataEntry.data) !== null && _b !== void 0 ? _b : []) {
            ret[tag.key] = tag.value;
          }
        }
        return ret;
      }
    };
    exports.CloudFormationStackArtifact = CloudFormationStackArtifact;
    _a = JSII_RTTI_SYMBOL_1;
    CloudFormationStackArtifact[_a] = { fqn: "@aws-cdk/cx-api.CloudFormationStackArtifact", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/cx-api/lib/artifacts/tree-cloud-artifact.js
var require_tree_cloud_artifact = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/artifacts/tree-cloud-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TreeCloudArtifact = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cloud_artifact_1 = require_cloud_artifact();
    var TreeCloudArtifact = class extends cloud_artifact_1.CloudArtifact {
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        const properties = this.manifest.properties || {};
        if (!properties.file) {
          throw new Error('Invalid TreeCloudArtifact. Missing "file" property');
        }
        this.file = properties.file;
      }
    };
    exports.TreeCloudArtifact = TreeCloudArtifact;
    _a = JSII_RTTI_SYMBOL_1;
    TreeCloudArtifact[_a] = { fqn: "@aws-cdk/cx-api.TreeCloudArtifact", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/cx-api/lib/toposort.js
var require_toposort = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/toposort.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.topologicalSort = void 0;
    function topologicalSort(xs, keyFn, depFn) {
      const remaining = /* @__PURE__ */ new Map();
      for (const element of xs) {
        const key = keyFn(element);
        remaining.set(key, { key, element, dependencies: depFn(element) });
      }
      const ret = new Array();
      while (remaining.size > 0) {
        const selectable = Array.from(remaining.values()).filter((e) => e.dependencies.every((d) => !remaining.has(d)));
        selectable.sort((a, b) => a.key < b.key ? -1 : b.key < a.key ? 1 : 0);
        for (const selected of selectable) {
          ret.push(selected.element);
          remaining.delete(selected.key);
        }
        if (selectable.length === 0) {
          throw new Error(`Could not determine ordering between: ${Array.from(remaining.keys()).join(", ")}`);
        }
      }
      return ret;
    }
    exports.topologicalSort = topologicalSort;
  }
});

// node_modules/@aws-cdk/cx-api/lib/cloud-assembly.js
var require_cloud_assembly2 = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/cloud-assembly.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CloudAssemblyBuilder = exports.CloudAssembly = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var os = require("os");
    var path = require("path");
    var cxschema = require_lib3();
    var cloudformation_artifact_1 = require_cloudformation_artifact();
    var nested_cloud_assembly_artifact_1 = require_nested_cloud_assembly_artifact();
    var tree_cloud_artifact_1 = require_tree_cloud_artifact();
    var cloud_artifact_1 = require_cloud_artifact();
    var toposort_1 = require_toposort();
    var MANIFEST_FILE = "manifest.json";
    var CloudAssembly = class {
      constructor(directory) {
        this.directory = directory;
        this.manifest = cxschema.Manifest.loadAssemblyManifest(path.join(directory, MANIFEST_FILE));
        this.version = this.manifest.version;
        this.artifacts = this.renderArtifacts();
        this.runtime = this.manifest.runtime || { libraries: {} };
        this.validateDeps();
      }
      tryGetArtifact(id) {
        return this.artifacts.find((a) => a.id === id);
      }
      getStackByName(stackName) {
        const artifacts = this.artifacts.filter((a) => a instanceof cloudformation_artifact_1.CloudFormationStackArtifact && a.stackName === stackName);
        if (!artifacts || artifacts.length === 0) {
          throw new Error(`Unable to find stack with stack name "${stackName}"`);
        }
        if (artifacts.length > 1) {
          throw new Error(`There are multiple stacks with the stack name "${stackName}" (${artifacts.map((a) => a.id).join(",")}). Use "getStackArtifact(id)" instead`);
        }
        return artifacts[0];
      }
      getStack(stackName) {
        return this.getStackByName(stackName);
      }
      getStackArtifact(artifactId) {
        const artifact = this.tryGetArtifactRecursively(artifactId);
        if (!artifact) {
          throw new Error(`Unable to find artifact with id "${artifactId}"`);
        }
        if (!(artifact instanceof cloudformation_artifact_1.CloudFormationStackArtifact)) {
          throw new Error(`Artifact ${artifactId} is not a CloudFormation stack`);
        }
        return artifact;
      }
      tryGetArtifactRecursively(artifactId) {
        return this.stacksRecursively.find((a) => a.id === artifactId);
      }
      get stacksRecursively() {
        function search(stackArtifacts, assemblies) {
          if (assemblies.length === 0) {
            return stackArtifacts;
          }
          const [head, ...tail] = assemblies;
          const nestedAssemblies = head.nestedAssemblies.map((asm) => asm.nestedAssembly);
          return search(stackArtifacts.concat(head.stacks), tail.concat(nestedAssemblies));
        }
        ;
        return search([], [this]);
      }
      getNestedAssemblyArtifact(artifactId) {
        const artifact = this.tryGetArtifact(artifactId);
        if (!artifact) {
          throw new Error(`Unable to find artifact with id "${artifactId}"`);
        }
        if (!(artifact instanceof nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact)) {
          throw new Error(`Found artifact '${artifactId}' but it's not a nested cloud assembly`);
        }
        return artifact;
      }
      getNestedAssembly(artifactId) {
        return this.getNestedAssemblyArtifact(artifactId).nestedAssembly;
      }
      tree() {
        const trees = this.artifacts.filter((a) => a.manifest.type === cxschema.ArtifactType.CDK_TREE);
        if (trees.length === 0) {
          return void 0;
        } else if (trees.length > 1) {
          throw new Error(`Multiple artifacts of type ${cxschema.ArtifactType.CDK_TREE} found in manifest`);
        }
        const tree = trees[0];
        if (!(tree instanceof tree_cloud_artifact_1.TreeCloudArtifact)) {
          throw new Error('"Tree" artifact is not of expected type');
        }
        return tree;
      }
      get stacks() {
        return this.artifacts.filter(isCloudFormationStackArtifact);
        function isCloudFormationStackArtifact(x) {
          return x instanceof cloudformation_artifact_1.CloudFormationStackArtifact;
        }
      }
      get nestedAssemblies() {
        return this.artifacts.filter(isNestedCloudAssemblyArtifact);
        function isNestedCloudAssemblyArtifact(x) {
          return x instanceof nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact;
        }
      }
      validateDeps() {
        for (const artifact of this.artifacts) {
          ignore(artifact.dependencies);
        }
      }
      renderArtifacts() {
        const result = new Array();
        for (const [name, artifact] of Object.entries(this.manifest.artifacts || {})) {
          const cloudartifact = cloud_artifact_1.CloudArtifact.fromManifest(this, name, artifact);
          if (cloudartifact) {
            result.push(cloudartifact);
          }
        }
        return toposort_1.topologicalSort(result, (x) => x.id, (x) => x._dependencyIDs);
      }
    };
    exports.CloudAssembly = CloudAssembly;
    _a = JSII_RTTI_SYMBOL_1;
    CloudAssembly[_a] = { fqn: "@aws-cdk/cx-api.CloudAssembly", version: "1.128.0" };
    var CloudAssemblyBuilder = class {
      constructor(outdir, props = {}) {
        var _c;
        this.artifacts = {};
        this.missing = new Array();
        this.outdir = determineOutputDirectory(outdir);
        this.assetOutdir = (_c = props.assetOutdir) !== null && _c !== void 0 ? _c : this.outdir;
        this.parentBuilder = props.parentBuilder;
        ensureDirSync(this.outdir);
      }
      addArtifact(id, manifest) {
        this.artifacts[id] = filterUndefined(manifest);
      }
      addMissing(missing) {
        var _c;
        if (this.missing.every((m) => m.key !== missing.key)) {
          this.missing.push(missing);
        }
        (_c = this.parentBuilder) === null || _c === void 0 ? void 0 : _c.addMissing(missing);
      }
      buildAssembly(options = {}) {
        let manifest = {
          version: cxschema.Manifest.version(),
          artifacts: this.artifacts,
          runtime: options.runtimeInfo,
          missing: this.missing.length > 0 ? this.missing : void 0
        };
        manifest = filterUndefined(manifest);
        const manifestFilePath = path.join(this.outdir, MANIFEST_FILE);
        cxschema.Manifest.saveAssemblyManifest(manifest, manifestFilePath);
        fs.writeFileSync(path.join(this.outdir, "cdk.out"), JSON.stringify({ version: manifest.version }));
        return new CloudAssembly(this.outdir);
      }
      createNestedAssembly(artifactId, displayName) {
        const directoryName = artifactId;
        const innerAsmDir = path.join(this.outdir, directoryName);
        this.addArtifact(artifactId, {
          type: cxschema.ArtifactType.NESTED_CLOUD_ASSEMBLY,
          properties: {
            directoryName,
            displayName
          }
        });
        return new CloudAssemblyBuilder(innerAsmDir, {
          assetOutdir: this.assetOutdir,
          parentBuilder: this
        });
      }
    };
    exports.CloudAssemblyBuilder = CloudAssemblyBuilder;
    _b = JSII_RTTI_SYMBOL_1;
    CloudAssemblyBuilder[_b] = { fqn: "@aws-cdk/cx-api.CloudAssemblyBuilder", version: "1.128.0" };
    function filterUndefined(obj) {
      if (Array.isArray(obj)) {
        return obj.filter((x) => x !== void 0).map((x) => filterUndefined(x));
      }
      if (typeof obj === "object") {
        const ret = {};
        for (const [key, value] of Object.entries(obj)) {
          if (value === void 0) {
            continue;
          }
          ret[key] = filterUndefined(value);
        }
        return ret;
      }
      return obj;
    }
    function ignore(_x) {
      return;
    }
    function determineOutputDirectory(outdir) {
      return outdir !== null && outdir !== void 0 ? outdir : fs.mkdtempSync(path.join(fs.realpathSync(os.tmpdir()), "cdk.out"));
    }
    function ensureDirSync(dir) {
      if (fs.existsSync(dir)) {
        if (!fs.statSync(dir).isDirectory()) {
          throw new Error(`${dir} must be a directory`);
        }
      } else {
        fs.mkdirSync(dir, { recursive: true });
      }
    }
  }
});

// node_modules/@aws-cdk/cx-api/lib/artifacts/nested-cloud-assembly-artifact.js
var require_nested_cloud_assembly_artifact = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/artifacts/nested-cloud-assembly-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.NestedCloudAssemblyArtifact = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var path = require("path");
    var cloud_artifact_1 = require_cloud_artifact();
    var cloud_assembly_1 = require_cloud_assembly2();
    var NestedCloudAssemblyArtifact = class extends cloud_artifact_1.CloudArtifact {
      constructor(assembly, name, artifact) {
        var _b;
        super(assembly, name, artifact);
        const properties = this.manifest.properties || {};
        this.directoryName = properties.directoryName;
        this.displayName = (_b = properties.displayName) !== null && _b !== void 0 ? _b : name;
      }
      get fullPath() {
        return path.join(this.assembly.directory, this.directoryName);
      }
      get nestedAssembly() {
        if (!this._nestedAssembly) {
          this._nestedAssembly = new cloud_assembly_1.CloudAssembly(this.fullPath);
        }
        return this._nestedAssembly;
      }
    };
    exports.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact;
    _a = JSII_RTTI_SYMBOL_1;
    NestedCloudAssemblyArtifact[_a] = { fqn: "@aws-cdk/cx-api.NestedCloudAssemblyArtifact", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/cx-api/lib/cloud-artifact.js
var require_cloud_artifact = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/cloud-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CloudArtifact = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxschema = require_lib3();
    var metadata_1 = require_metadata2();
    var CloudArtifact = class {
      constructor(assembly, id, manifest) {
        this.assembly = assembly;
        this.id = id;
        this.manifest = manifest;
        this.messages = this.renderMessages();
        this._dependencyIDs = manifest.dependencies || [];
      }
      static fromManifest(assembly, id, artifact) {
        switch (artifact.type) {
          case cxschema.ArtifactType.AWS_CLOUDFORMATION_STACK:
            return new cloudformation_artifact_1.CloudFormationStackArtifact(assembly, id, artifact);
          case cxschema.ArtifactType.CDK_TREE:
            return new tree_cloud_artifact_1.TreeCloudArtifact(assembly, id, artifact);
          case cxschema.ArtifactType.ASSET_MANIFEST:
            return new asset_manifest_artifact_1.AssetManifestArtifact(assembly, id, artifact);
          case cxschema.ArtifactType.NESTED_CLOUD_ASSEMBLY:
            return new nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact(assembly, id, artifact);
          default:
            return void 0;
        }
      }
      get dependencies() {
        if (this._deps) {
          return this._deps;
        }
        this._deps = this._dependencyIDs.map((id) => {
          const dep = this.assembly.tryGetArtifact(id);
          if (!dep) {
            throw new Error(`Artifact ${this.id} depends on non-existing artifact ${id}`);
          }
          return dep;
        });
        return this._deps;
      }
      findMetadataByType(type) {
        const result = new Array();
        for (const path of Object.keys(this.manifest.metadata || {})) {
          for (const entry of (this.manifest.metadata || {})[path]) {
            if (entry.type === type) {
              result.push(__spreadValues({ path }, entry));
            }
          }
        }
        return result;
      }
      renderMessages() {
        const messages = new Array();
        for (const [id, metadata] of Object.entries(this.manifest.metadata || {})) {
          for (const entry of metadata) {
            let level;
            switch (entry.type) {
              case cxschema.ArtifactMetadataEntryType.WARN:
                level = metadata_1.SynthesisMessageLevel.WARNING;
                break;
              case cxschema.ArtifactMetadataEntryType.ERROR:
                level = metadata_1.SynthesisMessageLevel.ERROR;
                break;
              case cxschema.ArtifactMetadataEntryType.INFO:
                level = metadata_1.SynthesisMessageLevel.INFO;
                break;
              default:
                continue;
            }
            messages.push({ level, entry, id });
          }
        }
        return messages;
      }
      get hierarchicalId() {
        var _b;
        return (_b = this.manifest.displayName) !== null && _b !== void 0 ? _b : this.id;
      }
    };
    exports.CloudArtifact = CloudArtifact;
    _a = JSII_RTTI_SYMBOL_1;
    CloudArtifact[_a] = { fqn: "@aws-cdk/cx-api.CloudArtifact", version: "1.128.0" };
    var asset_manifest_artifact_1 = require_asset_manifest_artifact();
    var cloudformation_artifact_1 = require_cloudformation_artifact();
    var nested_cloud_assembly_artifact_1 = require_nested_cloud_assembly_artifact();
    var tree_cloud_artifact_1 = require_tree_cloud_artifact();
  }
});

// node_modules/@aws-cdk/cx-api/lib/assets.js
var require_assets2 = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/assets.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ASSET_PREFIX_SEPARATOR = exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = exports.ASSET_RESOURCE_METADATA_PATH_KEY = exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = void 0;
    exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = "aws:cdk:enable-asset-metadata";
    exports.ASSET_RESOURCE_METADATA_PATH_KEY = "aws:asset:path";
    exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = "aws:asset:property";
    exports.ASSET_PREFIX_SEPARATOR = "||";
  }
});

// node_modules/@aws-cdk/cx-api/lib/features.js
var require_features = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/features.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.futureFlagDefault = exports.FUTURE_FLAGS_EXPIRED = exports.FUTURE_FLAGS = exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = exports.LAMBDA_RECOGNIZE_VERSION_PROPS = exports.EFS_DEFAULT_ENCRYPTION_AT_REST = exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = exports.RDS_LOWERCASE_DB_IDENTIFIER = exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = exports.S3_GRANT_WRITE_WITHOUT_ACL = exports.KMS_DEFAULT_KEY_POLICIES = exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = exports.DOCKER_IGNORE_SUPPORT = exports.STACK_RELATIVE_EXPORTS_CONTEXT = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
    exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = "@aws-cdk/core:enableStackNameDuplicates";
    exports.ENABLE_DIFF_NO_FAIL_CONTEXT = "aws-cdk:enableDiffNoFail";
    exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
    exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = "@aws-cdk/core:newStyleStackSynthesis";
    exports.STACK_RELATIVE_EXPORTS_CONTEXT = "@aws-cdk/core:stackRelativeExports";
    exports.DOCKER_IGNORE_SUPPORT = "@aws-cdk/aws-ecr-assets:dockerIgnoreSupport";
    exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = "@aws-cdk/aws-secretsmanager:parseOwnedSecretName";
    exports.KMS_DEFAULT_KEY_POLICIES = "@aws-cdk/aws-kms:defaultKeyPolicies";
    exports.S3_GRANT_WRITE_WITHOUT_ACL = "@aws-cdk/aws-s3:grantWriteWithoutAcl";
    exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = "@aws-cdk/aws-ecs-patterns:removeDefaultDesiredCount";
    exports.RDS_LOWERCASE_DB_IDENTIFIER = "@aws-cdk/aws-rds:lowercaseDbIdentifier";
    exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = "@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId";
    exports.EFS_DEFAULT_ENCRYPTION_AT_REST = "@aws-cdk/aws-efs:defaultEncryptionAtRest";
    exports.LAMBDA_RECOGNIZE_VERSION_PROPS = "@aws-cdk/aws-lambda:recognizeVersionProps";
    exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = "@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021";
    exports.FUTURE_FLAGS = {
      [exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: true,
      [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: "true",
      [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: "true",
      [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: "true",
      [exports.DOCKER_IGNORE_SUPPORT]: true,
      [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: true,
      [exports.KMS_DEFAULT_KEY_POLICIES]: true,
      [exports.S3_GRANT_WRITE_WITHOUT_ACL]: true,
      [exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: true,
      [exports.RDS_LOWERCASE_DB_IDENTIFIER]: true,
      [exports.EFS_DEFAULT_ENCRYPTION_AT_REST]: true,
      [exports.LAMBDA_RECOGNIZE_VERSION_PROPS]: true,
      [exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021]: true
    };
    exports.FUTURE_FLAGS_EXPIRED = [];
    var FUTURE_FLAGS_DEFAULTS = {
      [exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: false,
      [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: false,
      [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: false,
      [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: false,
      [exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT]: false,
      [exports.DOCKER_IGNORE_SUPPORT]: false,
      [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: false,
      [exports.KMS_DEFAULT_KEY_POLICIES]: false,
      [exports.S3_GRANT_WRITE_WITHOUT_ACL]: false,
      [exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: false,
      [exports.RDS_LOWERCASE_DB_IDENTIFIER]: false,
      [exports.EFS_DEFAULT_ENCRYPTION_AT_REST]: false,
      [exports.LAMBDA_RECOGNIZE_VERSION_PROPS]: false,
      [exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021]: false
    };
    function futureFlagDefault(flag) {
      return FUTURE_FLAGS_DEFAULTS[flag];
    }
    exports.futureFlagDefault = futureFlagDefault;
  }
});

// node_modules/@aws-cdk/cx-api/lib/placeholders.js
var require_placeholders = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/placeholders.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.EnvironmentPlaceholders = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var EnvironmentPlaceholders = class {
      static replace(object, values) {
        return this.recurse(object, (value) => {
          value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, values.region);
          value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, values.accountId);
          value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, values.partition);
          return value;
        });
      }
      static async replaceAsync(object, provider) {
        let needRegion = false;
        let needAccountId = false;
        let needPartition = false;
        this.recurse(object, (value) => {
          if (value.indexOf(EnvironmentPlaceholders.CURRENT_REGION) > 1) {
            needRegion = true;
          }
          if (value.indexOf(EnvironmentPlaceholders.CURRENT_ACCOUNT) > 1) {
            needAccountId = true;
          }
          if (value.indexOf(EnvironmentPlaceholders.CURRENT_PARTITION) > 1) {
            needPartition = true;
          }
          return value;
        });
        const region = needRegion ? await provider.region() : void 0;
        const accountId = needAccountId ? await provider.accountId() : void 0;
        const partition = needPartition ? await provider.partition() : void 0;
        return this.recurse(object, (value) => {
          value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, region !== null && region !== void 0 ? region : "WONTHAPPEN");
          value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, accountId !== null && accountId !== void 0 ? accountId : "WONTHAPPEN");
          value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, partition !== null && partition !== void 0 ? partition : "WONTHAPPEN");
          return value;
        });
      }
      static recurse(value, cb) {
        if (typeof value === "string") {
          return cb(value);
        }
        if (typeof value !== "object" || value === null) {
          return value;
        }
        if (Array.isArray(value)) {
          return value.map((x) => this.recurse(x, cb));
        }
        const ret = {};
        for (const [key, inner] of Object.entries(value)) {
          ret[key] = this.recurse(inner, cb);
        }
        return ret;
      }
    };
    exports.EnvironmentPlaceholders = EnvironmentPlaceholders;
    _a = JSII_RTTI_SYMBOL_1;
    EnvironmentPlaceholders[_a] = { fqn: "@aws-cdk/cx-api.EnvironmentPlaceholders", version: "1.128.0" };
    EnvironmentPlaceholders.CURRENT_REGION = "${AWS::Region}";
    EnvironmentPlaceholders.CURRENT_ACCOUNT = "${AWS::AccountId}";
    EnvironmentPlaceholders.CURRENT_PARTITION = "${AWS::Partition}";
    function replaceAll(s, search, replace) {
      return s.split(search).join(replace);
    }
  }
});

// node_modules/@aws-cdk/cx-api/lib/app.js
var require_app = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/app.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.BUNDLING_STACKS = exports.DISABLE_METADATA_STACK_TRACE = exports.DISABLE_ASSET_STAGING_CONTEXT = exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = exports.PATH_METADATA_ENABLE_CONTEXT = void 0;
    exports.PATH_METADATA_ENABLE_CONTEXT = "aws:cdk:enable-path-metadata";
    exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = "aws:cdk:version-reporting";
    exports.DISABLE_ASSET_STAGING_CONTEXT = "aws:cdk:disable-asset-staging";
    exports.DISABLE_METADATA_STACK_TRACE = "aws:cdk:disable-stack-trace";
    exports.BUNDLING_STACKS = "aws:cdk:bundling-stacks";
  }
});

// node_modules/@aws-cdk/cx-api/lib/index.js
var require_lib5 = __commonJS({
  "node_modules/@aws-cdk/cx-api/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_cxapi(), exports);
    __exportStar(require_vpc(), exports);
    __exportStar(require_ami(), exports);
    __exportStar(require_load_balancer(), exports);
    __exportStar(require_availability_zones(), exports);
    __exportStar(require_endpoint_service_availability_zones(), exports);
    __exportStar(require_security_group(), exports);
    __exportStar(require_key(), exports);
    __exportStar(require_cloud_artifact(), exports);
    __exportStar(require_asset_manifest_artifact(), exports);
    __exportStar(require_cloudformation_artifact(), exports);
    __exportStar(require_tree_cloud_artifact(), exports);
    __exportStar(require_nested_cloud_assembly_artifact(), exports);
    __exportStar(require_cloud_assembly2(), exports);
    __exportStar(require_assets2(), exports);
    __exportStar(require_environment(), exports);
    __exportStar(require_metadata2(), exports);
    __exportStar(require_features(), exports);
    __exportStar(require_placeholders(), exports);
    __exportStar(require_app(), exports);
  }
});

// node_modules/@aws-cdk/core/lib/debug.js
var require_debug3 = __commonJS({
  "node_modules/@aws-cdk/core/lib/debug.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.debugModeEnabled = exports.CDK_DEBUG = void 0;
    var process_1 = require("process");
    exports.CDK_DEBUG = "CDK_DEBUG";
    function debugModeEnabled() {
      return isTruthy(process_1.env[exports.CDK_DEBUG]);
    }
    exports.debugModeEnabled = debugModeEnabled;
    var TRUTHY_VALUES = /* @__PURE__ */ new Set(["1", "on", "true"]);
    function isTruthy(value) {
      if (!value) {
        return false;
      }
      return TRUTHY_VALUES.has(value.toLowerCase());
    }
  }
});

// node_modules/@aws-cdk/core/lib/stack-trace.js
var require_stack_trace2 = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack-trace.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.captureStackTrace = void 0;
    var debug_1 = require_debug3();
    function captureStackTrace(below = captureStackTrace, limit = Number.MAX_SAFE_INTEGER) {
      if (!debug_1.debugModeEnabled()) {
        return ["stack traces disabled"];
      }
      const object = {};
      const previousLimit = Error.stackTraceLimit;
      try {
        Error.stackTraceLimit = limit;
        Error.captureStackTrace(object, below);
      } finally {
        Error.stackTraceLimit = previousLimit;
      }
      if (!object.stack) {
        return [];
      }
      return object.stack.split("\n").slice(1).map((s) => s.replace(/^\s*at\s+/, ""));
    }
    exports.captureStackTrace = captureStackTrace;
  }
});

// node_modules/@aws-cdk/core/lib/lazy.js
var require_lazy = __commonJS({
  "node_modules/@aws-cdk/core/lib/lazy.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Lazy = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var debug_1 = require_debug3();
    var stack_trace_1 = require_stack_trace2();
    var token_1 = require_token();
    var Lazy = class {
      constructor() {
      }
      static stringValue(producer, options = {}) {
        return token_1.Token.asString(new LazyString(producer, false), options);
      }
      static string(producer, options = {}) {
        return token_1.Token.asString(new LazyString(producer, true), options);
      }
      static uncachedString(producer, options = {}) {
        return token_1.Token.asString(new LazyString(producer, false), options);
      }
      static numberValue(producer) {
        return token_1.Token.asNumber(new LazyNumber(producer, false));
      }
      static number(producer) {
        return token_1.Token.asNumber(new LazyNumber(producer, true));
      }
      static uncachedNumber(producer) {
        return token_1.Token.asNumber(new LazyNumber(producer, false));
      }
      static listValue(producer, options = {}) {
        return token_1.Token.asList(new LazyList(producer, false, options), options);
      }
      static uncachedList(producer, options = {}) {
        return token_1.Token.asList(new LazyList(producer, false, options), options);
      }
      static list(producer, options = {}) {
        return token_1.Token.asList(new LazyList(producer, true, options), options);
      }
      static anyValue(producer, options = {}) {
        return new LazyAny(producer, false, options);
      }
      static any(producer, options = {}) {
        return new LazyAny(producer, true, options);
      }
      static uncachedAny(producer, options = {}) {
        return new LazyAny(producer, false, options);
      }
    };
    exports.Lazy = Lazy;
    _a = JSII_RTTI_SYMBOL_1;
    Lazy[_a] = { fqn: "@aws-cdk/core.Lazy", version: "1.128.0" };
    var LazyBase = class {
      constructor(producer, cache) {
        this.producer = producer;
        this.cache = cache;
        this.creationStack = debug_1.debugModeEnabled() ? stack_trace_1.captureStackTrace(this.constructor) : [`Execute again with ${debug_1.CDK_DEBUG}=true to capture stack traces`];
      }
      resolve(context) {
        var _b;
        if (this.cache) {
          return (_b = this._cached) !== null && _b !== void 0 ? _b : this._cached = this.producer.produce(context);
        } else {
          return this.producer.produce(context);
        }
      }
      toString() {
        return token_1.Token.asString(this);
      }
      toJSON() {
        return "<unresolved-lazy>";
      }
    };
    var LazyString = class extends LazyBase {
    };
    var LazyNumber = class extends LazyBase {
    };
    var LazyList = class extends LazyBase {
      constructor(producer, cache, options = {}) {
        super(producer, cache);
        this.options = options;
      }
      resolve(context) {
        const resolved = super.resolve(context);
        if ((resolved === null || resolved === void 0 ? void 0 : resolved.length) === 0 && this.options.omitEmpty) {
          return void 0;
        }
        return resolved;
      }
    };
    var LazyAny = class extends LazyBase {
      constructor(producer, cache, options = {}) {
        super(producer, cache);
        this.options = options;
      }
      resolve(context) {
        const resolved = super.resolve(context);
        if (Array.isArray(resolved) && resolved.length === 0 && this.options.omitEmptyArray) {
          return void 0;
        }
        return resolved;
      }
    };
  }
});

// node_modules/@aws-cdk/core/lib/string-fragments.js
var require_string_fragments = __commonJS({
  "node_modules/@aws-cdk/core/lib/string-fragments.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TokenizedStringFragments = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var token_1 = require_token();
    var TokenizedStringFragments = class {
      constructor() {
        this.fragments = new Array();
      }
      get firstToken() {
        const first = this.fragments[0];
        if (first.type === "token") {
          return first.token;
        }
        return void 0;
      }
      get firstValue() {
        return fragmentValue(this.fragments[0]);
      }
      get length() {
        return this.fragments.length;
      }
      addLiteral(lit) {
        this.fragments.push({ type: "literal", lit });
      }
      addToken(token) {
        this.fragments.push({ type: "token", token });
      }
      addIntrinsic(value) {
        this.fragments.push({ type: "intrinsic", value });
      }
      get tokens() {
        const ret = new Array();
        for (const f of this.fragments) {
          if (f.type === "token") {
            ret.push(f.token);
          }
        }
        return ret;
      }
      mapTokens(mapper) {
        const ret = new TokenizedStringFragments();
        for (const f of this.fragments) {
          switch (f.type) {
            case "literal":
              ret.addLiteral(f.lit);
              break;
            case "token":
              const mapped = mapper.mapToken(f.token);
              if (token_1.isResolvableObject(mapped)) {
                ret.addToken(mapped);
              } else {
                ret.addIntrinsic(mapped);
              }
              break;
            case "intrinsic":
              ret.addIntrinsic(f.value);
              break;
          }
        }
        return ret;
      }
      join(concat) {
        if (this.fragments.length === 0) {
          return concat.join(void 0, void 0);
        }
        if (this.fragments.length === 1) {
          return this.firstValue;
        }
        const values = this.fragments.map(fragmentValue);
        while (values.length > 1) {
          const prefix = values.splice(0, 2);
          values.splice(0, 0, concat.join(prefix[0], prefix[1]));
        }
        return values[0];
      }
    };
    exports.TokenizedStringFragments = TokenizedStringFragments;
    _a = JSII_RTTI_SYMBOL_1;
    TokenizedStringFragments[_a] = { fqn: "@aws-cdk/core.TokenizedStringFragments", version: "1.128.0" };
    function fragmentValue(fragment) {
      switch (fragment.type) {
        case "literal":
          return fragment.lit;
        case "token":
          return fragment.token.toString();
        case "intrinsic":
          return fragment.value;
      }
    }
  }
});

// node_modules/@aws-cdk/core/lib/private/encoding.js
var require_encoding = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/encoding.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.extractTokenDouble = exports.createTokenDouble = exports.unresolved = exports.containsListTokenElement = exports.NullConcat = exports.regexQuote = exports.TokenString = exports.VALID_KEY_CHARS = exports.END_TOKEN_MARKER = exports.BEGIN_LIST_TOKEN_MARKER = exports.BEGIN_STRING_TOKEN_MARKER = void 0;
    var string_fragments_1 = require_string_fragments();
    var token_1 = require_token();
    exports.BEGIN_STRING_TOKEN_MARKER = "${Token[";
    exports.BEGIN_LIST_TOKEN_MARKER = "#{Token[";
    exports.END_TOKEN_MARKER = "]}";
    exports.VALID_KEY_CHARS = "a-zA-Z0-9:._-";
    var QUOTED_BEGIN_STRING_TOKEN_MARKER = regexQuote(exports.BEGIN_STRING_TOKEN_MARKER);
    var QUOTED_BEGIN_LIST_TOKEN_MARKER = regexQuote(exports.BEGIN_LIST_TOKEN_MARKER);
    var QUOTED_END_TOKEN_MARKER = regexQuote(exports.END_TOKEN_MARKER);
    var STRING_TOKEN_REGEX = new RegExp(`${QUOTED_BEGIN_STRING_TOKEN_MARKER}([${exports.VALID_KEY_CHARS}]+)${QUOTED_END_TOKEN_MARKER}`, "g");
    var LIST_TOKEN_REGEX = new RegExp(`${QUOTED_BEGIN_LIST_TOKEN_MARKER}([${exports.VALID_KEY_CHARS}]+)${QUOTED_END_TOKEN_MARKER}`, "g");
    var TokenString = class {
      constructor(str, re) {
        this.str = str;
        this.re = re;
      }
      static forString(s) {
        return new TokenString(s, STRING_TOKEN_REGEX);
      }
      static forListToken(s) {
        return new TokenString(s, LIST_TOKEN_REGEX);
      }
      split(lookup) {
        const ret = new string_fragments_1.TokenizedStringFragments();
        let rest = 0;
        this.re.lastIndex = 0;
        let m = this.re.exec(this.str);
        while (m) {
          if (m.index > rest) {
            ret.addLiteral(this.str.substring(rest, m.index));
          }
          ret.addToken(lookup(m[1]));
          rest = this.re.lastIndex;
          m = this.re.exec(this.str);
        }
        if (rest < this.str.length) {
          ret.addLiteral(this.str.substring(rest));
        }
        return ret;
      }
      test() {
        this.re.lastIndex = 0;
        return this.re.test(this.str);
      }
    };
    exports.TokenString = TokenString;
    function regexQuote(s) {
      return s.replace(/[.?*+^$[\]\\(){}|-]/g, "\\$&");
    }
    exports.regexQuote = regexQuote;
    var NullConcat = class {
      join(_left, _right) {
        return void 0;
      }
    };
    exports.NullConcat = NullConcat;
    function containsListTokenElement(xs) {
      return xs.some((x) => typeof x === "string" && TokenString.forListToken(x).test());
    }
    exports.containsListTokenElement = containsListTokenElement;
    function unresolved(obj) {
      if (typeof obj === "string") {
        return TokenString.forString(obj).test();
      } else if (typeof obj === "number") {
        return extractTokenDouble(obj) !== void 0;
      } else if (Array.isArray(obj) && obj.length === 1) {
        return typeof obj[0] === "string" && TokenString.forListToken(obj[0]).test();
      } else {
        return token_1.isResolvableObject(obj);
      }
    }
    exports.unresolved = unresolved;
    var DOUBLE_TOKEN_MARKER_BITS = 64511 << 16;
    var MAX_ENCODABLE_INTEGER = Math.pow(2, 48) - 1;
    var BITS32 = Math.pow(2, 32);
    function createTokenDouble(x) {
      if (Math.floor(x) !== x || x < 0) {
        throw new Error("Can only encode positive integers");
      }
      if (x > MAX_ENCODABLE_INTEGER) {
        throw new Error(`Got an index too large to encode: ${x}`);
      }
      const buf = new ArrayBuffer(8);
      const ints = new Uint32Array(buf);
      ints[0] = x & 4294967295;
      ints[1] = shr32(x) & 65535 | DOUBLE_TOKEN_MARKER_BITS;
      return new Float64Array(buf)[0];
    }
    exports.createTokenDouble = createTokenDouble;
    function shr32(x) {
      return Math.floor(x / BITS32);
    }
    function shl32(x) {
      return x * BITS32;
    }
    function extractTokenDouble(encoded) {
      const buf = new ArrayBuffer(8);
      new Float64Array(buf)[0] = encoded;
      const ints = new Uint32Array(buf);
      if ((ints[1] & 4294901760) !== DOUBLE_TOKEN_MARKER_BITS) {
        return void 0;
      }
      return ints[0] + shl32(ints[1] & 65535);
    }
    exports.extractTokenDouble = extractTokenDouble;
  }
});

// node_modules/@aws-cdk/core/lib/private/intrinsic.js
var require_intrinsic = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/intrinsic.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Intrinsic = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var stack_trace_1 = require_stack_trace2();
    var token_1 = require_token();
    var Intrinsic = class {
      constructor(value, options = {}) {
        var _b;
        if (isFunction(value)) {
          throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = ((_b = options.stackTrace) !== null && _b !== void 0 ? _b : true) ? stack_trace_1.captureStackTrace() : [];
        this.value = value;
      }
      resolve(_context) {
        return this.value;
      }
      toString() {
        return token_1.Token.asString(this);
      }
      toJSON() {
        return "<unresolved-token>";
      }
      newError(message) {
        return new Error(`${message}
Token created:
    at ${this.creationStack.join("\n    at ")}
Error thrown:`);
      }
    };
    exports.Intrinsic = Intrinsic;
    _a = JSII_RTTI_SYMBOL_1;
    Intrinsic[_a] = { fqn: "@aws-cdk/core.Intrinsic", version: "1.128.0" };
    function isFunction(x) {
      return typeof x === "function";
    }
  }
});

// node_modules/@aws-cdk/core/lib/private/token-map.js
var require_token_map = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/token-map.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TokenMap = void 0;
    var token_1 = require_token();
    var encoding_1 = require_encoding();
    var glob = global;
    var STRING_SYMBOL = Symbol.for("@aws-cdk/core.TokenMap.STRING");
    var LIST_SYMBOL = Symbol.for("@aws-cdk/core.TokenMap.LIST");
    var NUMBER_SYMBOL = Symbol.for("@aws-cdk/core.TokenMap.NUMBER");
    var TokenMap = class {
      constructor() {
        this.stringTokenMap = /* @__PURE__ */ new Map();
        this.numberTokenMap = /* @__PURE__ */ new Map();
        this.tokenCounter = Math.floor(Math.random() * 10);
      }
      static instance() {
        if (!glob.__cdkTokenMap) {
          glob.__cdkTokenMap = new TokenMap();
        }
        return glob.__cdkTokenMap;
      }
      registerString(token, displayHint) {
        return cachedValue(token, STRING_SYMBOL, () => {
          const key = this.registerStringKey(token, displayHint);
          return `${encoding_1.BEGIN_STRING_TOKEN_MARKER}${key}${encoding_1.END_TOKEN_MARKER}`;
        });
      }
      registerList(token, displayHint) {
        return cachedValue(token, LIST_SYMBOL, () => {
          const key = this.registerStringKey(token, displayHint);
          return [`${encoding_1.BEGIN_LIST_TOKEN_MARKER}${key}${encoding_1.END_TOKEN_MARKER}`];
        });
      }
      registerNumber(token) {
        return cachedValue(token, NUMBER_SYMBOL, () => {
          return this.registerNumberKey(token);
        });
      }
      tokenFromEncoding(x) {
        if (token_1.isResolvableObject(x)) {
          return x;
        }
        if (typeof x === "string") {
          return this.lookupString(x);
        }
        if (Array.isArray(x)) {
          return this.lookupList(x);
        }
        if (token_1.Token.isUnresolved(x)) {
          return x;
        }
        return void 0;
      }
      lookupString(s) {
        const fragments = this.splitString(s);
        if (fragments.tokens.length > 0 && fragments.length === 1) {
          return fragments.firstToken;
        }
        return void 0;
      }
      lookupList(xs) {
        if (xs.length !== 1) {
          return void 0;
        }
        const str = encoding_1.TokenString.forListToken(xs[0]);
        const fragments = str.split(this.lookupToken.bind(this));
        if (fragments.length === 1) {
          return fragments.firstToken;
        }
        return void 0;
      }
      splitString(s) {
        const str = encoding_1.TokenString.forString(s);
        return str.split(this.lookupToken.bind(this));
      }
      lookupNumberToken(x) {
        const tokenIndex = encoding_1.extractTokenDouble(x);
        if (tokenIndex === void 0) {
          return void 0;
        }
        const t = this.numberTokenMap.get(tokenIndex);
        if (t === void 0) {
          throw new Error("Encoded representation of unknown number Token found");
        }
        return t;
      }
      lookupToken(key) {
        const token = this.stringTokenMap.get(key);
        if (!token) {
          throw new Error(`Unrecognized token key: ${key}`);
        }
        return token;
      }
      registerStringKey(token, displayHint) {
        const counter = this.tokenCounter++;
        const representation = (displayHint || "TOKEN").replace(new RegExp(`[^${encoding_1.VALID_KEY_CHARS}]`, "g"), ".");
        const key = `${representation}.${counter}`;
        this.stringTokenMap.set(key, token);
        return key;
      }
      registerNumberKey(token) {
        const counter = this.tokenCounter++;
        this.numberTokenMap.set(counter, token);
        return encoding_1.createTokenDouble(counter);
      }
    };
    exports.TokenMap = TokenMap;
    function cachedValue(x, sym, prod) {
      let cached = x[sym];
      if (cached === void 0) {
        cached = prod();
        Object.defineProperty(x, sym, { value: cached });
      }
      return cached;
    }
  }
});

// node_modules/@aws-cdk/core/lib/resolvable.js
var require_resolvable = __commonJS({
  "node_modules/@aws-cdk/core/lib/resolvable.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DefaultTokenResolver = exports.StringConcat = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var encoding_1 = require_encoding();
    var token_map_1 = require_token_map();
    var StringConcat = class {
      join(left, right) {
        if (left === void 0) {
          return right !== void 0 ? `${right}` : void 0;
        }
        if (right === void 0) {
          return `${left}`;
        }
        return `${left}${right}`;
      }
    };
    exports.StringConcat = StringConcat;
    _a = JSII_RTTI_SYMBOL_1;
    StringConcat[_a] = { fqn: "@aws-cdk/core.StringConcat", version: "1.128.0" };
    var DefaultTokenResolver = class {
      constructor(concat) {
        this.concat = concat;
      }
      resolveToken(t, context, postProcessor) {
        try {
          let resolved = t.resolve(context);
          resolved = context.resolve(resolved);
          resolved = postProcessor.postProcess(resolved, context);
          return resolved;
        } catch (e) {
          let message = `Resolution error: ${e.message}.`;
          if (t.creationStack && t.creationStack.length > 0) {
            message += `
Object creation stack:
  at ${t.creationStack.join("\n  at ")}`;
          }
          e.message = message;
          throw e;
        }
      }
      resolveString(fragments, context) {
        return fragments.mapTokens({ mapToken: context.resolve }).join(this.concat);
      }
      resolveList(xs, context) {
        if (xs.length !== 1) {
          throw new Error(`Cannot add elements to list token, got: ${xs}`);
        }
        const str = encoding_1.TokenString.forListToken(xs[0]);
        const tokenMap = token_map_1.TokenMap.instance();
        const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
        if (fragments.length !== 1) {
          throw new Error(`Cannot concatenate strings in a tokenized string array, got: ${xs[0]}`);
        }
        return fragments.mapTokens({ mapToken: context.resolve }).firstValue;
      }
    };
    exports.DefaultTokenResolver = DefaultTokenResolver;
    _b = JSII_RTTI_SYMBOL_1;
    DefaultTokenResolver[_b] = { fqn: "@aws-cdk/core.DefaultTokenResolver", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/private/resolve.js
var require_resolve = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/resolve.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.resolvedTypeHint = exports.RememberingTokenResolver = exports.findTokens = exports.resolve = exports.ResolutionTypeHint = exports.INTRINSIC_KEY_PREFIX = void 0;
    var resolvable_1 = require_resolvable();
    var encoding_1 = require_encoding();
    var token_map_1 = require_token_map();
    var tokenMap = token_map_1.TokenMap.instance();
    var RESOLUTION_TYPEHINT_SYM = Symbol.for("@aws-cdk/core.resolvedTypeHint");
    exports.INTRINSIC_KEY_PREFIX = "$IntrinsicKey$";
    var ResolutionTypeHint;
    (function(ResolutionTypeHint2) {
      ResolutionTypeHint2["STRING"] = "string";
      ResolutionTypeHint2["NUMBER"] = "number";
      ResolutionTypeHint2["LIST"] = "list";
    })(ResolutionTypeHint = exports.ResolutionTypeHint || (exports.ResolutionTypeHint = {}));
    function resolve(obj, options) {
      const prefix = options.prefix || [];
      const pathName = "/" + prefix.join("/");
      function makeContext(appendPath) {
        const newPrefix = appendPath !== void 0 ? prefix.concat([appendPath]) : options.prefix;
        let postProcessor;
        const context = {
          preparing: options.preparing,
          scope: options.scope,
          registerPostProcessor(pp) {
            postProcessor = pp;
          },
          resolve(x, changeOptions) {
            return resolve(x, __spreadProps(__spreadValues(__spreadValues({}, options), changeOptions), { prefix: newPrefix }));
          }
        };
        return [context, { postProcess(x) {
          return postProcessor ? postProcessor.postProcess(x, context) : x;
        } }];
      }
      if (prefix.length > 200) {
        throw new Error("Unable to resolve object tree with circular reference. Path: " + pathName);
      }
      const leaveEmpty = options.removeEmpty === false;
      if (typeof obj === "undefined") {
        return void 0;
      }
      if (obj === null) {
        return null;
      }
      if (typeof obj === "function") {
        throw new Error(`Trying to resolve a non-data object. Only token are supported for lazy evaluation. Path: ${pathName}. Object: ${obj}`);
      }
      if (typeof obj === "string") {
        if (encoding_1.TokenString.forListToken(obj).test()) {
          throw new Error("Found an encoded list token string in a scalar string context. Use 'Fn.select(0, list)' (not 'list[0]') to extract elements from token lists.");
        }
        const str = encoding_1.TokenString.forString(obj);
        if (str.test()) {
          const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
          return tagResolvedValue(options.resolver.resolveString(fragments, makeContext()[0]), ResolutionTypeHint.STRING);
        }
        return obj;
      }
      if (typeof obj === "number") {
        return tagResolvedValue(resolveNumberToken(obj, makeContext()[0]), ResolutionTypeHint.NUMBER);
      }
      if (typeof obj !== "object" || obj instanceof Date) {
        return obj;
      }
      if (Array.isArray(obj)) {
        if (encoding_1.containsListTokenElement(obj)) {
          return tagResolvedValue(options.resolver.resolveList(obj, makeContext()[0]), ResolutionTypeHint.LIST);
        }
        const arr = obj.map((x, i) => makeContext(`${i}`)[0].resolve(x)).filter((x) => leaveEmpty || typeof x !== "undefined");
        return arr;
      }
      if (encoding_1.unresolved(obj)) {
        const [context, postProcessor] = makeContext();
        const ret = tagResolvedValue(options.resolver.resolveToken(obj, context, postProcessor), ResolutionTypeHint.STRING);
        return ret;
      }
      if (isConstruct(obj)) {
        throw new Error("Trying to resolve() a Construct at " + pathName);
      }
      const result = {};
      let intrinsicKeyCtr = 0;
      for (const key of Object.keys(obj)) {
        const value = makeContext(String(key))[0].resolve(obj[key]);
        if (typeof value === "undefined") {
          if (leaveEmpty) {
            result[key] = void 0;
          }
          continue;
        }
        if (!encoding_1.unresolved(key)) {
          result[key] = value;
          continue;
        }
        const resolvedKey = makeContext()[0].resolve(key);
        if (typeof resolvedKey === "string") {
          result[resolvedKey] = value;
        } else {
          if (!options.allowIntrinsicKeys) {
            throw new Error(`"${String(key)}" is used as the key in a map so must resolve to a string, but it resolves to: ${JSON.stringify(resolvedKey)}. Consider using "CfnJson" to delay resolution to deployment-time`);
          }
          result[`${exports.INTRINSIC_KEY_PREFIX}${intrinsicKeyCtr++}`] = [resolvedKey, value];
        }
      }
      const previousTypeHint = resolvedTypeHint(obj);
      return previousTypeHint ? tagResolvedValue(result, previousTypeHint) : result;
    }
    exports.resolve = resolve;
    function findTokens(scope, fn) {
      const resolver = new RememberingTokenResolver(new resolvable_1.StringConcat());
      resolve(fn(), { scope, prefix: [], resolver, preparing: true });
      return resolver.tokens;
    }
    exports.findTokens = findTokens;
    var RememberingTokenResolver = class extends resolvable_1.DefaultTokenResolver {
      constructor() {
        super(...arguments);
        this.tokensSeen = /* @__PURE__ */ new Set();
      }
      resolveToken(t, context, postProcessor) {
        this.tokensSeen.add(t);
        return super.resolveToken(t, context, postProcessor);
      }
      resolveString(s, context) {
        const ret = super.resolveString(s, context);
        return ret;
      }
      get tokens() {
        return Array.from(this.tokensSeen);
      }
    };
    exports.RememberingTokenResolver = RememberingTokenResolver;
    function isConstruct(x) {
      return x._children !== void 0 && x._metadata !== void 0;
    }
    function resolveNumberToken(x, context) {
      const token = token_map_1.TokenMap.instance().lookupNumberToken(x);
      if (token === void 0) {
        return x;
      }
      return context.resolve(token);
    }
    function tagResolvedValue(value, typeHint) {
      if (typeof value !== "object" || value == null) {
        return value;
      }
      Object.defineProperty(value, RESOLUTION_TYPEHINT_SYM, {
        value: typeHint,
        configurable: true
      });
      return value;
    }
    function resolvedTypeHint(value) {
      if (typeof value !== "object" || value == null) {
        return void 0;
      }
      return value[RESOLUTION_TYPEHINT_SYM];
    }
    exports.resolvedTypeHint = resolvedTypeHint;
  }
});

// node_modules/@aws-cdk/core/lib/token.js
var require_token = __commonJS({
  "node_modules/@aws-cdk/core/lib/token.js"(exports) {
    "use strict";
    var _a;
    var _b;
    var _c;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.withResolved = exports.isResolvableObject = exports.Tokenization = exports.Token = exports.TokenComparison = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var lazy_1 = require_lazy();
    var encoding_1 = require_encoding();
    var intrinsic_1 = require_intrinsic();
    var resolve_1 = require_resolve();
    var token_map_1 = require_token_map();
    var TokenComparison = class {
      constructor() {
      }
    };
    exports.TokenComparison = TokenComparison;
    _a = JSII_RTTI_SYMBOL_1;
    TokenComparison[_a] = { fqn: "@aws-cdk/core.TokenComparison", version: "1.128.0" };
    TokenComparison.SAME = new TokenComparison();
    TokenComparison.DIFFERENT = new TokenComparison();
    TokenComparison.ONE_UNRESOLVED = new TokenComparison();
    TokenComparison.BOTH_UNRESOLVED = new TokenComparison();
    var Token = class {
      constructor() {
      }
      static isUnresolved(obj) {
        return encoding_1.unresolved(obj);
      }
      static asString(value, options = {}) {
        if (typeof value === "string") {
          return value;
        }
        return token_map_1.TokenMap.instance().registerString(Token.asAny(value), options.displayHint);
      }
      static asNumber(value) {
        if (typeof value === "number") {
          return value;
        }
        return token_map_1.TokenMap.instance().registerNumber(Token.asAny(value));
      }
      static asList(value, options = {}) {
        if (Array.isArray(value) && value.every((x) => typeof x === "string")) {
          return value;
        }
        return token_map_1.TokenMap.instance().registerList(Token.asAny(value), options.displayHint);
      }
      static asAny(value) {
        return isResolvableObject(value) ? value : new intrinsic_1.Intrinsic(value);
      }
      static compareStrings(possibleToken1, possibleToken2) {
        const firstIsUnresolved = Token.isUnresolved(possibleToken1);
        const secondIsUnresolved = Token.isUnresolved(possibleToken2);
        if (firstIsUnresolved && secondIsUnresolved) {
          return TokenComparison.BOTH_UNRESOLVED;
        }
        if (firstIsUnresolved || secondIsUnresolved) {
          return TokenComparison.ONE_UNRESOLVED;
        }
        return possibleToken1 === possibleToken2 ? TokenComparison.SAME : TokenComparison.DIFFERENT;
      }
    };
    exports.Token = Token;
    _b = JSII_RTTI_SYMBOL_1;
    Token[_b] = { fqn: "@aws-cdk/core.Token", version: "1.128.0" };
    var Tokenization = class {
      constructor() {
      }
      static reverseString(s) {
        return token_map_1.TokenMap.instance().splitString(s);
      }
      static reverseCompleteString(s) {
        const fragments = Tokenization.reverseString(s);
        if (fragments.length !== 1) {
          throw new Error(`Tokenzation.reverseCompleteString: argument must not be a concatentation, got '${s}'`);
        }
        return fragments.firstToken;
      }
      static reverseNumber(n) {
        return token_map_1.TokenMap.instance().lookupNumberToken(n);
      }
      static reverseList(l) {
        return token_map_1.TokenMap.instance().lookupList(l);
      }
      static reverse(x, options = {}) {
        if (Tokenization.isResolvable(x)) {
          return x;
        }
        if (typeof x === "string") {
          if (options.failConcat === false) {
            const fragments = Tokenization.reverseString(x);
            return fragments.length === 1 ? fragments.firstToken : void 0;
          }
          return Tokenization.reverseCompleteString(x);
        }
        if (Array.isArray(x)) {
          return Tokenization.reverseList(x);
        }
        if (typeof x === "number") {
          return Tokenization.reverseNumber(x);
        }
        return void 0;
      }
      static resolve(obj, options) {
        var _d;
        return resolve_1.resolve(obj, {
          scope: options.scope,
          resolver: options.resolver,
          preparing: (_d = options.preparing) !== null && _d !== void 0 ? _d : false,
          removeEmpty: options.removeEmpty
        });
      }
      static isResolvable(obj) {
        return isResolvableObject(obj);
      }
      static stringifyNumber(x) {
        if (Token.isUnresolved(x)) {
          return lazy_1.Lazy.uncachedString({
            produce: (context) => {
              const resolved = context.resolve(x);
              return typeof resolved !== "number" ? resolved : `${resolved}`;
            }
          });
        } else {
          return typeof x !== "number" ? x : `${x}`;
        }
      }
    };
    exports.Tokenization = Tokenization;
    _c = JSII_RTTI_SYMBOL_1;
    Tokenization[_c] = { fqn: "@aws-cdk/core.Tokenization", version: "1.128.0" };
    function isResolvableObject(x) {
      return typeof x === "object" && x !== null && typeof x.resolve === "function";
    }
    exports.isResolvableObject = isResolvableObject;
    function withResolved(...args) {
      if (args.length < 2) {
        return;
      }
      const argArray = args.slice(0, args.length - 1);
      if (argArray.some(Token.isUnresolved)) {
        return;
      }
      args[args.length - 1].apply(arguments, argArray);
    }
    exports.withResolved = withResolved;
  }
});

// node_modules/@aws-cdk/core/lib/tree.js
var require_tree = __commonJS({
  "node_modules/@aws-cdk/core/lib/tree.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TreeInspector = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var TreeInspector = class {
      constructor() {
        this.attributes = {};
      }
      addAttribute(key, value) {
        this.attributes[key] = value;
      }
    };
    exports.TreeInspector = TreeInspector;
    _a = JSII_RTTI_SYMBOL_1;
    TreeInspector[_a] = { fqn: "@aws-cdk/core.TreeInspector", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/stage.js
var require_stage = __commonJS({
  "node_modules/@aws-cdk/core/lib/stage.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Stage = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_lib5();
    var constructs_1 = require_lib4();
    var synthesis_1 = require_synthesis();
    var construct_compat_1 = require_construct_compat();
    var STAGE_SYMBOL = Symbol.for("@aws-cdk/core.Stage");
    var Stage = class extends construct_compat_1.Construct {
      constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(scope, id);
        if (id !== "" && !/^[a-z][a-z0-9\-\_\.]+$/i.test(id)) {
          throw new Error(`invalid stage name "${id}". Stage name must start with a letter and contain only alphanumeric characters, hypens ('-'), underscores ('_') and periods ('.')`);
        }
        Object.defineProperty(this, STAGE_SYMBOL, { value: true });
        this.parentStage = Stage.of(this);
        this.region = (_c = (_b = props.env) === null || _b === void 0 ? void 0 : _b.region) !== null && _c !== void 0 ? _c : (_d = this.parentStage) === null || _d === void 0 ? void 0 : _d.region;
        this.account = (_f = (_e = props.env) === null || _e === void 0 ? void 0 : _e.account) !== null && _f !== void 0 ? _f : (_g = this.parentStage) === null || _g === void 0 ? void 0 : _g.account;
        this._assemblyBuilder = this.createBuilder(props.outdir);
        this.stageName = [(_h = this.parentStage) === null || _h === void 0 ? void 0 : _h.stageName, id].filter((x) => x).join("-");
      }
      static of(construct) {
        return constructs_1.Node.of(construct).scopes.reverse().slice(1).find(Stage.isStage);
      }
      static isStage(x) {
        return x !== null && typeof x === "object" && STAGE_SYMBOL in x;
      }
      get outdir() {
        return this._assemblyBuilder.outdir;
      }
      get assetOutdir() {
        return this._assemblyBuilder.assetOutdir;
      }
      get artifactId() {
        if (!this.node.path) {
          return "";
        }
        return `assembly-${this.node.path.replace(/\//g, "-").replace(/^-+|-+$/g, "")}`;
      }
      synth(options = {}) {
        if (!this.assembly || options.force) {
          this.assembly = synthesis_1.synthesize(this, {
            skipValidation: options.skipValidation,
            validateOnSynthesis: options.validateOnSynthesis
          });
        }
        return this.assembly;
      }
      createBuilder(outdir) {
        if (this.parentStage && outdir) {
          throw new Error('"outdir" cannot be specified for nested stages');
        }
        return this.parentStage ? this.parentStage._assemblyBuilder.createNestedAssembly(this.artifactId, this.node.path) : new cxapi.CloudAssemblyBuilder(outdir);
      }
    };
    exports.Stage = Stage;
    _a = JSII_RTTI_SYMBOL_1;
    Stage[_a] = { fqn: "@aws-cdk/core.Stage", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/private/runtime-info.js
var require_runtime_info = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/runtime-info.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.constructInfoFromStack = exports.constructInfoFromConstruct = void 0;
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var ALLOWED_FQN_PREFIXES = [
      "@aws-cdk/",
      "@aws-cdk-containers/",
      "@aws-solutions-konstruk/",
      "@aws-solutions-constructs/",
      "@amzn/",
      "aws-rfdk.",
      "aws-cdk-lib.",
      "monocdk."
    ];
    var JSII_RUNTIME_SYMBOL = Symbol.for("jsii.rtti");
    function constructInfoFromConstruct(construct) {
      const jsiiRuntimeInfo = Object.getPrototypeOf(construct).constructor[JSII_RUNTIME_SYMBOL];
      if (typeof jsiiRuntimeInfo === "object" && jsiiRuntimeInfo !== null && typeof jsiiRuntimeInfo.fqn === "string" && typeof jsiiRuntimeInfo.version === "string") {
        return { fqn: jsiiRuntimeInfo.fqn, version: jsiiRuntimeInfo.version };
      } else if (jsiiRuntimeInfo) {
        throw new Error(`malformed jsii runtime info for construct: '${construct.node.path}'`);
      }
      return void 0;
    }
    exports.constructInfoFromConstruct = constructInfoFromConstruct;
    function constructInfoFromStack(stack) {
      const isDefined = (value) => value !== void 0;
      const allConstructInfos = constructsInStack(stack).map((construct) => constructInfoFromConstruct(construct)).filter(isDefined).filter((info) => ALLOWED_FQN_PREFIXES.find((prefix) => info.fqn.startsWith(prefix)));
      allConstructInfos.push({
        fqn: "jsii-runtime.Runtime",
        version: getJsiiAgentVersion()
      });
      const uniqKeys = /* @__PURE__ */ new Set();
      return allConstructInfos.filter((construct) => {
        const constructKey = `${construct.fqn}@${construct.version}`;
        const isDuplicate = uniqKeys.has(constructKey);
        uniqKeys.add(constructKey);
        return !isDuplicate;
      });
    }
    exports.constructInfoFromStack = constructInfoFromStack;
    function constructsInStack(construct) {
      const constructs = [construct];
      construct.node.children.filter((child) => !stage_1.Stage.isStage(child) && !stack_1.Stack.isStack(child)).forEach((child) => constructs.push(...constructsInStack(child)));
      return constructs;
    }
    function getJsiiAgentVersion() {
      let jsiiAgent = process.env.JSII_AGENT;
      if (!jsiiAgent) {
        jsiiAgent = `node.js/${process.version}`;
      }
      jsiiAgent = jsiiAgent.replace(/[^a-z0-9.-/=_]/gi, "-");
      return jsiiAgent;
    }
  }
});

// node_modules/@aws-cdk/core/lib/private/tree-metadata.js
var require_tree_metadata = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/tree-metadata.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TreeMetadata = void 0;
    var fs = require("fs");
    var path = require("path");
    var cloud_assembly_schema_1 = require_lib3();
    var annotations_1 = require_annotations();
    var construct_compat_1 = require_construct_compat();
    var stack_1 = require_stack();
    var tree_1 = require_tree();
    var runtime_info_1 = require_runtime_info();
    var FILE_PATH = "tree.json";
    var TreeMetadata = class extends construct_compat_1.Construct {
      constructor(scope) {
        super(scope, "Tree");
      }
      _synthesizeTree(session) {
        const lookup = {};
        const visit = (construct) => {
          const children = construct.node.children.map((c) => {
            try {
              return visit(c);
            } catch (e) {
              annotations_1.Annotations.of(this).addWarning(`Failed to render tree metadata for node [${c.node.id}]. Reason: ${e}`);
              return void 0;
            }
          });
          const childrenMap = children.filter((child) => child !== void 0).reduce((map, child) => Object.assign(map, { [child.id]: child }), {});
          const node = {
            id: construct.node.id || "App",
            path: construct.node.path,
            children: Object.keys(childrenMap).length === 0 ? void 0 : childrenMap,
            attributes: this.synthAttributes(construct),
            constructInfo: runtime_info_1.constructInfoFromConstruct(construct)
          };
          lookup[node.path] = node;
          return node;
        };
        const tree = {
          version: "tree-0.1",
          tree: visit(this.node.root)
        };
        const builder = session.assembly;
        fs.writeFileSync(path.join(builder.outdir, FILE_PATH), JSON.stringify(tree, void 0, 2), { encoding: "utf-8" });
        builder.addArtifact("Tree", {
          type: cloud_assembly_schema_1.ArtifactType.CDK_TREE,
          properties: {
            file: FILE_PATH
          }
        });
      }
      synthAttributes(construct) {
        function canInspect(inspectable) {
          return inspectable.inspect !== void 0;
        }
        const inspector = new tree_1.TreeInspector();
        if (canInspect(construct)) {
          construct.inspect(inspector);
          return stack_1.Stack.of(construct).resolve(inspector.attributes);
        }
        return void 0;
      }
    };
    exports.TreeMetadata = TreeMetadata;
  }
});

// node_modules/@aws-cdk/core/lib/app.js
var require_app2 = __commonJS({
  "node_modules/@aws-cdk/core/lib/app.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.attachCustomSynthesis = exports.App = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_lib5();
    var synthesis_1 = require_synthesis();
    var tree_metadata_1 = require_tree_metadata();
    var stage_1 = require_stage();
    var APP_SYMBOL = Symbol.for("@aws-cdk/core.App");
    var App = class extends stage_1.Stage {
      constructor(props = {}) {
        var _b, _c, _d;
        super(void 0, "", {
          outdir: (_b = props.outdir) !== null && _b !== void 0 ? _b : process.env[cxapi.OUTDIR_ENV]
        });
        Object.defineProperty(this, APP_SYMBOL, { value: true });
        this.loadContext(props.context);
        if (props.stackTraces === false) {
          this.node.setContext(cxapi.DISABLE_METADATA_STACK_TRACE, true);
        }
        const analyticsReporting = (_c = props.analyticsReporting) !== null && _c !== void 0 ? _c : props.runtimeInfo;
        if (analyticsReporting !== void 0) {
          this.node.setContext(cxapi.ANALYTICS_REPORTING_ENABLED_CONTEXT, analyticsReporting);
        }
        const autoSynth = (_d = props.autoSynth) !== null && _d !== void 0 ? _d : cxapi.OUTDIR_ENV in process.env;
        if (autoSynth) {
          process.once("beforeExit", () => this.synth());
        }
        if (props.treeMetadata === void 0 || props.treeMetadata) {
          new tree_metadata_1.TreeMetadata(this);
        }
      }
      static isApp(obj) {
        return APP_SYMBOL in obj;
      }
      loadContext(defaults = {}) {
        for (const [k, v] of Object.entries(defaults)) {
          this.node.setContext(k, v);
        }
        const contextJson = process.env[cxapi.CONTEXT_ENV];
        const contextFromEnvironment = contextJson ? JSON.parse(contextJson) : {};
        for (const [k, v] of Object.entries(contextFromEnvironment)) {
          this.node.setContext(k, v);
        }
      }
    };
    exports.App = App;
    _a = JSII_RTTI_SYMBOL_1;
    App[_a] = { fqn: "@aws-cdk/core.App", version: "1.128.0" };
    function attachCustomSynthesis(construct, synthesis) {
      synthesis_1.addCustomSynthesis(construct, synthesis);
    }
    exports.attachCustomSynthesis = attachCustomSynthesis;
  }
});

// node_modules/@aws-cdk/core/lib/removal-policy.js
var require_removal_policy = __commonJS({
  "node_modules/@aws-cdk/core/lib/removal-policy.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.RemovalPolicy = void 0;
    var RemovalPolicy;
    (function(RemovalPolicy2) {
      RemovalPolicy2["DESTROY"] = "destroy";
      RemovalPolicy2["RETAIN"] = "retain";
      RemovalPolicy2["SNAPSHOT"] = "snapshot";
    })(RemovalPolicy = exports.RemovalPolicy || (exports.RemovalPolicy = {}));
  }
});

// node_modules/@aws-cdk/core/lib/private/uniqueid.js
var require_uniqueid2 = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/uniqueid.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.makeUniqueId = void 0;
    var crypto = require("crypto");
    var encoding_1 = require_encoding();
    var HIDDEN_FROM_HUMAN_ID = "Resource";
    var HIDDEN_ID = "Default";
    var PATH_SEP = "/";
    var HASH_LEN = 8;
    var MAX_HUMAN_LEN = 240;
    var MAX_ID_LEN = 255;
    function makeUniqueId(components) {
      components = components.filter((x) => x !== HIDDEN_ID);
      if (components.length === 0) {
        throw new Error("Unable to calculate a unique id for an empty set of components");
      }
      const unresolvedTokens = components.filter((c) => encoding_1.unresolved(c));
      if (unresolvedTokens.length > 0) {
        throw new Error(`ID components may not include unresolved tokens: ${unresolvedTokens.join(",")}`);
      }
      if (components.length === 1) {
        const candidate = removeNonAlphanumeric(components[0]);
        if (candidate.length <= MAX_ID_LEN) {
          return candidate;
        }
      }
      const hash = pathHash(components);
      const human = removeDupes(components).filter((x) => x !== HIDDEN_FROM_HUMAN_ID).map(removeNonAlphanumeric).join("").slice(0, MAX_HUMAN_LEN);
      return human + hash;
    }
    exports.makeUniqueId = makeUniqueId;
    function pathHash(path) {
      const md5 = crypto.createHash("md5").update(path.join(PATH_SEP)).digest("hex");
      return md5.slice(0, HASH_LEN).toUpperCase();
    }
    function removeNonAlphanumeric(s) {
      return s.replace(/[^A-Za-z0-9]/g, "");
    }
    function removeDupes(path) {
      const ret = new Array();
      for (const component of path) {
        if (ret.length === 0 || !ret[ret.length - 1].endsWith(component)) {
          ret.push(component);
        }
      }
      return ret;
    }
  }
});

// node_modules/@aws-cdk/core/lib/names.js
var require_names = __commonJS({
  "node_modules/@aws-cdk/core/lib/names.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Names = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var constructs_1 = require_lib4();
    var uniqueid_1 = require_uniqueid2();
    var Names = class {
      constructor() {
      }
      static uniqueId(construct) {
        const node = constructs_1.Node.of(construct);
        const components = node.scopes.slice(1).map((c) => constructs_1.Node.of(c).id);
        return components.length > 0 ? uniqueid_1.makeUniqueId(components) : "";
      }
      static nodeUniqueId(node) {
        const components = node.scopes.slice(1).map((c) => c.node.id);
        return components.length > 0 ? uniqueid_1.makeUniqueId(components) : "";
      }
    };
    exports.Names = Names;
    _a = JSII_RTTI_SYMBOL_1;
    Names[_a] = { fqn: "@aws-cdk/core.Names", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/private/physical-name-generator.js
var require_physical_name_generator = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/physical-name-generator.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isGeneratedWhenNeededMarker = exports.GeneratedWhenNeededMarker = exports.generatePhysicalName = void 0;
    var crypto = require("crypto");
    var constructs_1 = require_lib4();
    var names_1 = require_names();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var token_map_1 = require_token_map();
    function generatePhysicalName(resource) {
      const stack = stack_1.Stack.of(resource);
      const stackPart = new PrefixNamePart(stack.stackName, 25);
      const idPart = new SuffixNamePart(names_1.Names.nodeUniqueId(resource.node), 24);
      const region = stack.region;
      if (token_1.Token.isUnresolved(region) || !region) {
        throw new Error(`Cannot generate a physical name for ${constructs_1.Node.of(resource).path}, because the region is un-resolved or missing`);
      }
      const account = stack.account;
      if (token_1.Token.isUnresolved(account) || !account) {
        throw new Error(`Cannot generate a physical name for ${constructs_1.Node.of(resource).path}, because the account is un-resolved or missing`);
      }
      const parts = [stackPart, idPart].map((part) => part.generate());
      const hashLength = 12;
      const sha256 = crypto.createHash("sha256").update(stackPart.bareStr).update(idPart.bareStr).update(region).update(account);
      const hash = sha256.digest("hex").slice(0, hashLength);
      const ret = [...parts, hash].join("");
      return ret.toLowerCase();
    }
    exports.generatePhysicalName = generatePhysicalName;
    var NamePart = class {
      constructor(bareStr) {
        this.bareStr = bareStr;
      }
    };
    var PrefixNamePart = class extends NamePart {
      constructor(bareStr, prefixLength) {
        super(bareStr);
        this.prefixLength = prefixLength;
      }
      generate() {
        return this.bareStr.slice(0, this.prefixLength);
      }
    };
    var SuffixNamePart = class extends NamePart {
      constructor(str, suffixLength) {
        super(str);
        this.suffixLength = suffixLength;
      }
      generate() {
        const strLen = this.bareStr.length;
        const startIndex = Math.max(strLen - this.suffixLength, 0);
        return this.bareStr.slice(startIndex, strLen);
      }
    };
    var GENERATE_IF_NEEDED_SYMBOL = Symbol.for("@aws-cdk/core.<private>.GenerateIfNeeded");
    var GeneratedWhenNeededMarker = class {
      constructor() {
        this.creationStack = [];
        Object.defineProperty(this, GENERATE_IF_NEEDED_SYMBOL, { value: true });
      }
      resolve(_ctx) {
        throw new Error('Invalid physical name passed to CloudFormation. Use "this.physicalName" instead');
      }
      toString() {
        return "PhysicalName.GENERATE_IF_NEEDED";
      }
    };
    exports.GeneratedWhenNeededMarker = GeneratedWhenNeededMarker;
    function isGeneratedWhenNeededMarker(val) {
      const token = token_map_1.TokenMap.instance().lookupString(val);
      return !!token && GENERATE_IF_NEEDED_SYMBOL in token;
    }
    exports.isGeneratedWhenNeededMarker = isGeneratedWhenNeededMarker;
  }
});

// node_modules/@aws-cdk/core/lib/reference.js
var require_reference = __commonJS({
  "node_modules/@aws-cdk/core/lib/reference.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Reference = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var intrinsic_1 = require_intrinsic();
    var REFERENCE_SYMBOL = Symbol.for("@aws-cdk/core.Reference");
    var Reference = class extends intrinsic_1.Intrinsic {
      constructor(value, target, displayName) {
        super(value);
        Object.defineProperty(this, REFERENCE_SYMBOL, { value: true });
        this.target = target;
        this.displayName = displayName || "Reference";
      }
      static isReference(x) {
        return typeof x === "object" && x !== null && REFERENCE_SYMBOL in x;
      }
    };
    exports.Reference = Reference;
    _a = JSII_RTTI_SYMBOL_1;
    Reference[_a] = { fqn: "@aws-cdk/core.Reference", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/resource.js
var require_resource = __commonJS({
  "node_modules/@aws-cdk/core/lib/resource.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Resource = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_resource_1 = require_cfn_resource();
    var construct_compat_1 = require_construct_compat();
    var lazy_1 = require_lazy();
    var physical_name_generator_1 = require_physical_name_generator();
    var reference_1 = require_reference();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var RESOURCE_SYMBOL = Symbol.for("@aws-cdk/core.Resource");
    var Resource = class extends construct_compat_1.Construct {
      constructor(scope, id, props = {}) {
        var _b, _c, _d, _e;
        super(scope, id);
        if ((props.account !== void 0 || props.region !== void 0) && props.environmentFromArn !== void 0) {
          throw new Error(`Supply at most one of 'account'/'region' (${props.account}/${props.region}) and 'environmentFromArn' (${props.environmentFromArn})`);
        }
        Object.defineProperty(this, RESOURCE_SYMBOL, { value: true });
        this.stack = stack_1.Stack.of(this);
        const parsedArn = props.environmentFromArn ? this.stack.parseArn(props.environmentFromArn) : void 0;
        this.env = {
          account: (_c = (_b = props.account) !== null && _b !== void 0 ? _b : parsedArn === null || parsedArn === void 0 ? void 0 : parsedArn.account) !== null && _c !== void 0 ? _c : this.stack.account,
          region: (_e = (_d = props.region) !== null && _d !== void 0 ? _d : parsedArn === null || parsedArn === void 0 ? void 0 : parsedArn.region) !== null && _e !== void 0 ? _e : this.stack.region
        };
        let physicalName = props.physicalName;
        if (props.physicalName && physical_name_generator_1.isGeneratedWhenNeededMarker(props.physicalName)) {
          this._physicalName = void 0;
          this._allowCrossEnvironment = true;
          physicalName = lazy_1.Lazy.string({ produce: () => this._physicalName });
        } else if (props.physicalName && !token_1.Token.isUnresolved(props.physicalName)) {
          this._physicalName = props.physicalName;
          this._allowCrossEnvironment = true;
        } else {
          this._physicalName = props.physicalName;
          this._allowCrossEnvironment = false;
        }
        if (physicalName === void 0) {
          physicalName = token_1.Token.asString(void 0);
        }
        this.physicalName = physicalName;
      }
      static isResource(construct) {
        return construct !== null && typeof construct === "object" && RESOURCE_SYMBOL in construct;
      }
      _enableCrossEnvironment() {
        if (!this._allowCrossEnvironment) {
          throw new Error(`Cannot use resource '${this.node.path}' in a cross-environment fashion, the resource's physical name must be explicit set or use \`PhysicalName.GENERATE_IF_NEEDED\``);
        }
        if (!this._physicalName) {
          this._physicalName = this.generatePhysicalName();
        }
      }
      applyRemovalPolicy(policy) {
        const child = this.node.defaultChild;
        if (!child || !cfn_resource_1.CfnResource.isCfnResource(child)) {
          throw new Error("Cannot apply RemovalPolicy: no child or not a CfnResource. Apply the removal policy on the CfnResource directly.");
        }
        child.applyRemovalPolicy(policy);
      }
      generatePhysicalName() {
        return physical_name_generator_1.generatePhysicalName(this);
      }
      getResourceNameAttribute(nameAttr) {
        return mimicReference(nameAttr, {
          produce: (context) => {
            const consumingStack = stack_1.Stack.of(context.scope);
            if (this.stack.environment !== consumingStack.environment) {
              this._enableCrossEnvironment();
              return this.physicalName;
            } else {
              return nameAttr;
            }
          }
        });
      }
      getResourceArnAttribute(arnAttr, arnComponents) {
        return mimicReference(arnAttr, {
          produce: (context) => {
            const consumingStack = stack_1.Stack.of(context.scope);
            if (this.stack.environment !== consumingStack.environment) {
              this._enableCrossEnvironment();
              return this.stack.formatArn(arnComponents);
            } else {
              return arnAttr;
            }
          }
        });
      }
    };
    exports.Resource = Resource;
    _a = JSII_RTTI_SYMBOL_1;
    Resource[_a] = { fqn: "@aws-cdk/core.Resource", version: "1.128.0" };
    function mimicReference(refSource, producer) {
      const reference = token_1.Tokenization.reverse(refSource, {
        failConcat: false
      });
      if (!reference_1.Reference.isReference(reference)) {
        return lazy_1.Lazy.uncachedString(producer);
      }
      return token_1.Token.asString(new class extends reference_1.Reference {
        resolve(context) {
          return producer.produce(context);
        }
      }(reference, reference.target, reference.displayName));
    }
  }
});

// node_modules/@aws-cdk/core/lib/custom-resource.js
var require_custom_resource = __commonJS({
  "node_modules/@aws-cdk/core/lib/custom-resource.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CustomResource = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_resource_1 = require_cfn_resource();
    var removal_policy_1 = require_removal_policy();
    var resource_1 = require_resource();
    var token_1 = require_token();
    var CustomResource = class extends resource_1.Resource {
      constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const type = renderResourceType(props.resourceType);
        const pascalCaseProperties = (_b = props.pascalCaseProperties) !== null && _b !== void 0 ? _b : false;
        const properties = pascalCaseProperties ? uppercaseProperties(props.properties || {}) : props.properties || {};
        this.resource = new cfn_resource_1.CfnResource(this, "Default", {
          type,
          properties: __spreadValues({
            ServiceToken: props.serviceToken
          }, properties)
        });
        this.resource.applyRemovalPolicy(props.removalPolicy, {
          default: removal_policy_1.RemovalPolicy.DESTROY
        });
      }
      get ref() {
        return this.resource.ref;
      }
      getAtt(attributeName) {
        return this.resource.getAtt(attributeName);
      }
      getAttString(attributeName) {
        return token_1.Token.asString(this.getAtt(attributeName));
      }
    };
    exports.CustomResource = CustomResource;
    _a = JSII_RTTI_SYMBOL_1;
    CustomResource[_a] = { fqn: "@aws-cdk/core.CustomResource", version: "1.128.0" };
    function uppercaseProperties(props) {
      const ret = {};
      Object.keys(props).forEach((key) => {
        const upper = key.substr(0, 1).toUpperCase() + key.substr(1);
        ret[upper] = props[key];
      });
      return ret;
    }
    function renderResourceType(resourceType) {
      if (!resourceType) {
        return "AWS::CloudFormation::CustomResource";
      }
      if (!resourceType.startsWith("Custom::")) {
        throw new Error(`Custom resource type must begin with "Custom::" (${resourceType})`);
      }
      const typeName = resourceType.substr(resourceType.indexOf("::") + 2);
      if (typeName.length > 60) {
        throw new Error(`Custom resource type length > 60 (${resourceType})`);
      }
      if (!/^[a-z0-9_@-]+$/i.test(typeName)) {
        throw new Error(`Custom resource type name can only include alphanumeric characters and _@- (${typeName})`);
      }
      return resourceType;
    }
  }
});

// node_modules/@aws-cdk/core/node_modules/universalify/index.js
var require_universalify = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/universalify/index.js"(exports) {
    "use strict";
    exports.fromCallback = function(fn) {
      return Object.defineProperty(function(...args) {
        if (typeof args[args.length - 1] === "function")
          fn.apply(this, args);
        else {
          return new Promise((resolve, reject) => {
            fn.call(this, ...args, (err, res) => err != null ? reject(err) : resolve(res));
          });
        }
      }, "name", { value: fn.name });
    };
    exports.fromPromise = function(fn) {
      return Object.defineProperty(function(...args) {
        const cb = args[args.length - 1];
        if (typeof cb !== "function")
          return fn.apply(this, args);
        else
          fn.apply(this, args.slice(0, -1)).then((r) => cb(null, r), cb);
      }, "name", { value: fn.name });
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/graceful-fs/polyfills.js
var require_polyfills = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/graceful-fs/polyfills.js"(exports, module2) {
    var constants = require("constants");
    var origCwd = process.cwd;
    var cwd = null;
    var platform = process.env.GRACEFUL_FS_PLATFORM || process.platform;
    process.cwd = function() {
      if (!cwd)
        cwd = origCwd.call(process);
      return cwd;
    };
    try {
      process.cwd();
    } catch (er) {
    }
    if (typeof process.chdir === "function") {
      chdir = process.chdir;
      process.chdir = function(d) {
        cwd = null;
        chdir.call(process, d);
      };
      if (Object.setPrototypeOf)
        Object.setPrototypeOf(process.chdir, chdir);
    }
    var chdir;
    module2.exports = patch;
    function patch(fs) {
      if (constants.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)) {
        patchLchmod(fs);
      }
      if (!fs.lutimes) {
        patchLutimes(fs);
      }
      fs.chown = chownFix(fs.chown);
      fs.fchown = chownFix(fs.fchown);
      fs.lchown = chownFix(fs.lchown);
      fs.chmod = chmodFix(fs.chmod);
      fs.fchmod = chmodFix(fs.fchmod);
      fs.lchmod = chmodFix(fs.lchmod);
      fs.chownSync = chownFixSync(fs.chownSync);
      fs.fchownSync = chownFixSync(fs.fchownSync);
      fs.lchownSync = chownFixSync(fs.lchownSync);
      fs.chmodSync = chmodFixSync(fs.chmodSync);
      fs.fchmodSync = chmodFixSync(fs.fchmodSync);
      fs.lchmodSync = chmodFixSync(fs.lchmodSync);
      fs.stat = statFix(fs.stat);
      fs.fstat = statFix(fs.fstat);
      fs.lstat = statFix(fs.lstat);
      fs.statSync = statFixSync(fs.statSync);
      fs.fstatSync = statFixSync(fs.fstatSync);
      fs.lstatSync = statFixSync(fs.lstatSync);
      if (!fs.lchmod) {
        fs.lchmod = function(path, mode, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs.lchmodSync = function() {
        };
      }
      if (!fs.lchown) {
        fs.lchown = function(path, uid, gid, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs.lchownSync = function() {
        };
      }
      if (platform === "win32") {
        fs.rename = function(fs$rename) {
          return function(from, to, cb) {
            var start = Date.now();
            var backoff = 0;
            fs$rename(from, to, function CB(er) {
              if (er && (er.code === "EACCES" || er.code === "EPERM") && Date.now() - start < 6e4) {
                setTimeout(function() {
                  fs.stat(to, function(stater, st) {
                    if (stater && stater.code === "ENOENT")
                      fs$rename(from, to, CB);
                    else
                      cb(er);
                  });
                }, backoff);
                if (backoff < 100)
                  backoff += 10;
                return;
              }
              if (cb)
                cb(er);
            });
          };
        }(fs.rename);
      }
      fs.read = function(fs$read) {
        function read(fd, buffer, offset, length, position, callback_) {
          var callback;
          if (callback_ && typeof callback_ === "function") {
            var eagCounter = 0;
            callback = function(er, _, __) {
              if (er && er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                return fs$read.call(fs, fd, buffer, offset, length, position, callback);
              }
              callback_.apply(this, arguments);
            };
          }
          return fs$read.call(fs, fd, buffer, offset, length, position, callback);
        }
        if (Object.setPrototypeOf)
          Object.setPrototypeOf(read, fs$read);
        return read;
      }(fs.read);
      fs.readSync = function(fs$readSync) {
        return function(fd, buffer, offset, length, position) {
          var eagCounter = 0;
          while (true) {
            try {
              return fs$readSync.call(fs, fd, buffer, offset, length, position);
            } catch (er) {
              if (er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                continue;
              }
              throw er;
            }
          }
        };
      }(fs.readSync);
      function patchLchmod(fs2) {
        fs2.lchmod = function(path, mode, callback) {
          fs2.open(path, constants.O_WRONLY | constants.O_SYMLINK, mode, function(err, fd) {
            if (err) {
              if (callback)
                callback(err);
              return;
            }
            fs2.fchmod(fd, mode, function(err2) {
              fs2.close(fd, function(err22) {
                if (callback)
                  callback(err2 || err22);
              });
            });
          });
        };
        fs2.lchmodSync = function(path, mode) {
          var fd = fs2.openSync(path, constants.O_WRONLY | constants.O_SYMLINK, mode);
          var threw = true;
          var ret;
          try {
            ret = fs2.fchmodSync(fd, mode);
            threw = false;
          } finally {
            if (threw) {
              try {
                fs2.closeSync(fd);
              } catch (er) {
              }
            } else {
              fs2.closeSync(fd);
            }
          }
          return ret;
        };
      }
      function patchLutimes(fs2) {
        if (constants.hasOwnProperty("O_SYMLINK")) {
          fs2.lutimes = function(path, at, mt, cb) {
            fs2.open(path, constants.O_SYMLINK, function(er, fd) {
              if (er) {
                if (cb)
                  cb(er);
                return;
              }
              fs2.futimes(fd, at, mt, function(er2) {
                fs2.close(fd, function(er22) {
                  if (cb)
                    cb(er2 || er22);
                });
              });
            });
          };
          fs2.lutimesSync = function(path, at, mt) {
            var fd = fs2.openSync(path, constants.O_SYMLINK);
            var ret;
            var threw = true;
            try {
              ret = fs2.futimesSync(fd, at, mt);
              threw = false;
            } finally {
              if (threw) {
                try {
                  fs2.closeSync(fd);
                } catch (er) {
                }
              } else {
                fs2.closeSync(fd);
              }
            }
            return ret;
          };
        } else {
          fs2.lutimes = function(_a, _b, _c, cb) {
            if (cb)
              process.nextTick(cb);
          };
          fs2.lutimesSync = function() {
          };
        }
      }
      function chmodFix(orig) {
        if (!orig)
          return orig;
        return function(target, mode, cb) {
          return orig.call(fs, target, mode, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      function chmodFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, mode) {
          try {
            return orig.call(fs, target, mode);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      function chownFix(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid, cb) {
          return orig.call(fs, target, uid, gid, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      function chownFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid) {
          try {
            return orig.call(fs, target, uid, gid);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      function statFix(orig) {
        if (!orig)
          return orig;
        return function(target, options, cb) {
          if (typeof options === "function") {
            cb = options;
            options = null;
          }
          function callback(er, stats) {
            if (stats) {
              if (stats.uid < 0)
                stats.uid += 4294967296;
              if (stats.gid < 0)
                stats.gid += 4294967296;
            }
            if (cb)
              cb.apply(this, arguments);
          }
          return options ? orig.call(fs, target, options, callback) : orig.call(fs, target, callback);
        };
      }
      function statFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, options) {
          var stats = options ? orig.call(fs, target, options) : orig.call(fs, target);
          if (stats.uid < 0)
            stats.uid += 4294967296;
          if (stats.gid < 0)
            stats.gid += 4294967296;
          return stats;
        };
      }
      function chownErOk(er) {
        if (!er)
          return true;
        if (er.code === "ENOSYS")
          return true;
        var nonroot = !process.getuid || process.getuid() !== 0;
        if (nonroot) {
          if (er.code === "EINVAL" || er.code === "EPERM")
            return true;
        }
        return false;
      }
    }
  }
});

// node_modules/@aws-cdk/core/node_modules/graceful-fs/legacy-streams.js
var require_legacy_streams = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/graceful-fs/legacy-streams.js"(exports, module2) {
    var Stream = require("stream").Stream;
    module2.exports = legacy;
    function legacy(fs) {
      return {
        ReadStream,
        WriteStream
      };
      function ReadStream(path, options) {
        if (!(this instanceof ReadStream))
          return new ReadStream(path, options);
        Stream.call(this);
        var self = this;
        this.path = path;
        this.fd = null;
        this.readable = true;
        this.paused = false;
        this.flags = "r";
        this.mode = 438;
        this.bufferSize = 64 * 1024;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.encoding)
          this.setEncoding(this.encoding);
        if (this.start !== void 0) {
          if (typeof this.start !== "number") {
            throw TypeError("start must be a Number");
          }
          if (this.end === void 0) {
            this.end = Infinity;
          } else if (typeof this.end !== "number") {
            throw TypeError("end must be a Number");
          }
          if (this.start > this.end) {
            throw new Error("start must be <= end");
          }
          this.pos = this.start;
        }
        if (this.fd !== null) {
          process.nextTick(function() {
            self._read();
          });
          return;
        }
        fs.open(this.path, this.flags, this.mode, function(err, fd) {
          if (err) {
            self.emit("error", err);
            self.readable = false;
            return;
          }
          self.fd = fd;
          self.emit("open", fd);
          self._read();
        });
      }
      function WriteStream(path, options) {
        if (!(this instanceof WriteStream))
          return new WriteStream(path, options);
        Stream.call(this);
        this.path = path;
        this.fd = null;
        this.writable = true;
        this.flags = "w";
        this.encoding = "binary";
        this.mode = 438;
        this.bytesWritten = 0;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.start !== void 0) {
          if (typeof this.start !== "number") {
            throw TypeError("start must be a Number");
          }
          if (this.start < 0) {
            throw new Error("start must be >= zero");
          }
          this.pos = this.start;
        }
        this.busy = false;
        this._queue = [];
        if (this.fd === null) {
          this._open = fs.open;
          this._queue.push([this._open, this.path, this.flags, this.mode, void 0]);
          this.flush();
        }
      }
    }
  }
});

// node_modules/@aws-cdk/core/node_modules/graceful-fs/clone.js
var require_clone = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/graceful-fs/clone.js"(exports, module2) {
    "use strict";
    module2.exports = clone;
    var getPrototypeOf = Object.getPrototypeOf || function(obj) {
      return obj.__proto__;
    };
    function clone(obj) {
      if (obj === null || typeof obj !== "object")
        return obj;
      if (obj instanceof Object)
        var copy = { __proto__: getPrototypeOf(obj) };
      else
        var copy = Object.create(null);
      Object.getOwnPropertyNames(obj).forEach(function(key) {
        Object.defineProperty(copy, key, Object.getOwnPropertyDescriptor(obj, key));
      });
      return copy;
    }
  }
});

// node_modules/@aws-cdk/core/node_modules/graceful-fs/graceful-fs.js
var require_graceful_fs = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/graceful-fs/graceful-fs.js"(exports, module2) {
    var fs = require("fs");
    var polyfills = require_polyfills();
    var legacy = require_legacy_streams();
    var clone = require_clone();
    var util = require("util");
    var gracefulQueue;
    var previousSymbol;
    if (typeof Symbol === "function" && typeof Symbol.for === "function") {
      gracefulQueue = Symbol.for("graceful-fs.queue");
      previousSymbol = Symbol.for("graceful-fs.previous");
    } else {
      gracefulQueue = "___graceful-fs.queue";
      previousSymbol = "___graceful-fs.previous";
    }
    function noop() {
    }
    function publishQueue(context, queue2) {
      Object.defineProperty(context, gracefulQueue, {
        get: function() {
          return queue2;
        }
      });
    }
    var debug = noop;
    if (util.debuglog)
      debug = util.debuglog("gfs4");
    else if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || ""))
      debug = function() {
        var m = util.format.apply(util, arguments);
        m = "GFS4: " + m.split(/\n/).join("\nGFS4: ");
        console.error(m);
      };
    if (!fs[gracefulQueue]) {
      queue = global[gracefulQueue] || [];
      publishQueue(fs, queue);
      fs.close = function(fs$close) {
        function close(fd, cb) {
          return fs$close.call(fs, fd, function(err) {
            if (!err) {
              resetQueue();
            }
            if (typeof cb === "function")
              cb.apply(this, arguments);
          });
        }
        Object.defineProperty(close, previousSymbol, {
          value: fs$close
        });
        return close;
      }(fs.close);
      fs.closeSync = function(fs$closeSync) {
        function closeSync(fd) {
          fs$closeSync.apply(fs, arguments);
          resetQueue();
        }
        Object.defineProperty(closeSync, previousSymbol, {
          value: fs$closeSync
        });
        return closeSync;
      }(fs.closeSync);
      if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || "")) {
        process.on("exit", function() {
          debug(fs[gracefulQueue]);
          require("assert").equal(fs[gracefulQueue].length, 0);
        });
      }
    }
    var queue;
    if (!global[gracefulQueue]) {
      publishQueue(global, fs[gracefulQueue]);
    }
    module2.exports = patch(clone(fs));
    if (process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs.__patched) {
      module2.exports = patch(fs);
      fs.__patched = true;
    }
    function patch(fs2) {
      polyfills(fs2);
      fs2.gracefulify = patch;
      fs2.createReadStream = createReadStream;
      fs2.createWriteStream = createWriteStream;
      var fs$readFile = fs2.readFile;
      fs2.readFile = readFile;
      function readFile(path, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$readFile(path, options, cb);
        function go$readFile(path2, options2, cb2, startTime) {
          return fs$readFile(path2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readFile, [path2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$writeFile = fs2.writeFile;
      fs2.writeFile = writeFile;
      function writeFile(path, data, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$writeFile(path, data, options, cb);
        function go$writeFile(path2, data2, options2, cb2, startTime) {
          return fs$writeFile(path2, data2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$writeFile, [path2, data2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$appendFile = fs2.appendFile;
      if (fs$appendFile)
        fs2.appendFile = appendFile;
      function appendFile(path, data, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$appendFile(path, data, options, cb);
        function go$appendFile(path2, data2, options2, cb2, startTime) {
          return fs$appendFile(path2, data2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$appendFile, [path2, data2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$copyFile = fs2.copyFile;
      if (fs$copyFile)
        fs2.copyFile = copyFile;
      function copyFile(src, dest, flags, cb) {
        if (typeof flags === "function") {
          cb = flags;
          flags = 0;
        }
        return go$copyFile(src, dest, flags, cb);
        function go$copyFile(src2, dest2, flags2, cb2, startTime) {
          return fs$copyFile(src2, dest2, flags2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$copyFile, [src2, dest2, flags2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$readdir = fs2.readdir;
      fs2.readdir = readdir;
      function readdir(path, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$readdir(path, options, cb);
        function go$readdir(path2, options2, cb2, startTime) {
          return fs$readdir(path2, options2, function(err, files) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readdir, [path2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (files && files.sort)
                files.sort();
              if (typeof cb2 === "function")
                cb2.call(this, err, files);
            }
          });
        }
      }
      if (process.version.substr(0, 4) === "v0.8") {
        var legStreams = legacy(fs2);
        ReadStream = legStreams.ReadStream;
        WriteStream = legStreams.WriteStream;
      }
      var fs$ReadStream = fs2.ReadStream;
      if (fs$ReadStream) {
        ReadStream.prototype = Object.create(fs$ReadStream.prototype);
        ReadStream.prototype.open = ReadStream$open;
      }
      var fs$WriteStream = fs2.WriteStream;
      if (fs$WriteStream) {
        WriteStream.prototype = Object.create(fs$WriteStream.prototype);
        WriteStream.prototype.open = WriteStream$open;
      }
      Object.defineProperty(fs2, "ReadStream", {
        get: function() {
          return ReadStream;
        },
        set: function(val) {
          ReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(fs2, "WriteStream", {
        get: function() {
          return WriteStream;
        },
        set: function(val) {
          WriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileReadStream = ReadStream;
      Object.defineProperty(fs2, "FileReadStream", {
        get: function() {
          return FileReadStream;
        },
        set: function(val) {
          FileReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileWriteStream = WriteStream;
      Object.defineProperty(fs2, "FileWriteStream", {
        get: function() {
          return FileWriteStream;
        },
        set: function(val) {
          FileWriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      function ReadStream(path, options) {
        if (this instanceof ReadStream)
          return fs$ReadStream.apply(this, arguments), this;
        else
          return ReadStream.apply(Object.create(ReadStream.prototype), arguments);
      }
      function ReadStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            if (that.autoClose)
              that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
            that.read();
          }
        });
      }
      function WriteStream(path, options) {
        if (this instanceof WriteStream)
          return fs$WriteStream.apply(this, arguments), this;
        else
          return WriteStream.apply(Object.create(WriteStream.prototype), arguments);
      }
      function WriteStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
          }
        });
      }
      function createReadStream(path, options) {
        return new fs2.ReadStream(path, options);
      }
      function createWriteStream(path, options) {
        return new fs2.WriteStream(path, options);
      }
      var fs$open = fs2.open;
      fs2.open = open;
      function open(path, flags, mode, cb) {
        if (typeof mode === "function")
          cb = mode, mode = null;
        return go$open(path, flags, mode, cb);
        function go$open(path2, flags2, mode2, cb2, startTime) {
          return fs$open(path2, flags2, mode2, function(err, fd) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$open, [path2, flags2, mode2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      return fs2;
    }
    function enqueue(elem) {
      debug("ENQUEUE", elem[0].name, elem[1]);
      fs[gracefulQueue].push(elem);
      retry();
    }
    var retryTimer;
    function resetQueue() {
      var now = Date.now();
      for (var i = 0; i < fs[gracefulQueue].length; ++i) {
        if (fs[gracefulQueue][i].length > 2) {
          fs[gracefulQueue][i][3] = now;
          fs[gracefulQueue][i][4] = now;
        }
      }
      retry();
    }
    function retry() {
      clearTimeout(retryTimer);
      retryTimer = void 0;
      if (fs[gracefulQueue].length === 0)
        return;
      var elem = fs[gracefulQueue].shift();
      var fn = elem[0];
      var args = elem[1];
      var err = elem[2];
      var startTime = elem[3];
      var lastTime = elem[4];
      if (startTime === void 0) {
        debug("RETRY", fn.name, args);
        fn.apply(null, args);
      } else if (Date.now() - startTime >= 6e4) {
        debug("TIMEOUT", fn.name, args);
        var cb = args.pop();
        if (typeof cb === "function")
          cb.call(null, err);
      } else {
        var sinceAttempt = Date.now() - lastTime;
        var sinceStart = Math.max(lastTime - startTime, 1);
        var desiredDelay = Math.min(sinceStart * 1.2, 100);
        if (sinceAttempt >= desiredDelay) {
          debug("RETRY", fn.name, args);
          fn.apply(null, args.concat([startTime]));
        } else {
          fs[gracefulQueue].push(elem);
        }
      }
      if (retryTimer === void 0) {
        retryTimer = setTimeout(retry, 0);
      }
    }
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/fs/index.js
var require_fs = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/fs/index.js"(exports) {
    "use strict";
    var u = require_universalify().fromCallback;
    var fs = require_graceful_fs();
    var api = [
      "access",
      "appendFile",
      "chmod",
      "chown",
      "close",
      "copyFile",
      "fchmod",
      "fchown",
      "fdatasync",
      "fstat",
      "fsync",
      "ftruncate",
      "futimes",
      "lchmod",
      "lchown",
      "link",
      "lstat",
      "mkdir",
      "mkdtemp",
      "open",
      "opendir",
      "readdir",
      "readFile",
      "readlink",
      "realpath",
      "rename",
      "rm",
      "rmdir",
      "stat",
      "symlink",
      "truncate",
      "unlink",
      "utimes",
      "writeFile"
    ].filter((key) => {
      return typeof fs[key] === "function";
    });
    Object.keys(fs).forEach((key) => {
      if (key === "promises") {
        return;
      }
      exports[key] = fs[key];
    });
    api.forEach((method) => {
      exports[method] = u(fs[method]);
    });
    exports.exists = function(filename, callback) {
      if (typeof callback === "function") {
        return fs.exists(filename, callback);
      }
      return new Promise((resolve) => {
        return fs.exists(filename, resolve);
      });
    };
    exports.read = function(fd, buffer, offset, length, position, callback) {
      if (typeof callback === "function") {
        return fs.read(fd, buffer, offset, length, position, callback);
      }
      return new Promise((resolve, reject) => {
        fs.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesRead, buffer: buffer2 });
        });
      });
    };
    exports.write = function(fd, buffer, ...args) {
      if (typeof args[args.length - 1] === "function") {
        return fs.write(fd, buffer, ...args);
      }
      return new Promise((resolve, reject) => {
        fs.write(fd, buffer, ...args, (err, bytesWritten, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesWritten, buffer: buffer2 });
        });
      });
    };
    if (typeof fs.writev === "function") {
      exports.writev = function(fd, buffers, ...args) {
        if (typeof args[args.length - 1] === "function") {
          return fs.writev(fd, buffers, ...args);
        }
        return new Promise((resolve, reject) => {
          fs.writev(fd, buffers, ...args, (err, bytesWritten, buffers2) => {
            if (err)
              return reject(err);
            resolve({ bytesWritten, buffers: buffers2 });
          });
        });
      };
    }
    if (typeof fs.realpath.native === "function") {
      exports.realpath.native = u(fs.realpath.native);
    }
  }
});

// node_modules/@aws-cdk/core/node_modules/at-least-node/index.js
var require_at_least_node = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/at-least-node/index.js"(exports, module2) {
    module2.exports = (r) => {
      const n = process.versions.node.split(".").map((x) => parseInt(x, 10));
      r = r.split(".").map((x) => parseInt(x, 10));
      return n[0] > r[0] || n[0] === r[0] && (n[1] > r[1] || n[1] === r[1] && n[2] >= r[2]);
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/mkdirs/make-dir.js
var require_make_dir = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports, module2) {
    "use strict";
    var fs = require_fs();
    var path = require("path");
    var atLeastNode = require_at_least_node();
    var useNativeRecursiveOption = atLeastNode("10.12.0");
    var checkPath = (pth) => {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error = new Error(`Path contains invalid characters: ${pth}`);
          error.code = "EINVAL";
          throw error;
        }
      }
    };
    var processOptions = (options) => {
      const defaults = { mode: 511 };
      if (typeof options === "number")
        options = { mode: options };
      return __spreadValues(__spreadValues({}, defaults), options);
    };
    var permissionError = (pth) => {
      const error = new Error(`operation not permitted, mkdir '${pth}'`);
      error.code = "EPERM";
      error.errno = -4048;
      error.path = pth;
      error.syscall = "mkdir";
      return error;
    };
    module2.exports.makeDir = async (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path.resolve(input);
        return fs.mkdir(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = async (pth) => {
        try {
          await fs.mkdir(pth, options.mode);
        } catch (error) {
          if (error.code === "EPERM") {
            throw error;
          }
          if (error.code === "ENOENT") {
            if (path.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error.message.includes("null bytes")) {
              throw error;
            }
            await make(path.dirname(pth));
            return make(pth);
          }
          try {
            const stats = await fs.stat(pth);
            if (!stats.isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error;
          }
        }
      };
      return make(path.resolve(input));
    };
    module2.exports.makeDirSync = (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path.resolve(input);
        return fs.mkdirSync(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = (pth) => {
        try {
          fs.mkdirSync(pth, options.mode);
        } catch (error) {
          if (error.code === "EPERM") {
            throw error;
          }
          if (error.code === "ENOENT") {
            if (path.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error.message.includes("null bytes")) {
              throw error;
            }
            make(path.dirname(pth));
            return make(pth);
          }
          try {
            if (!fs.statSync(pth).isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error;
          }
        }
      };
      return make(path.resolve(input));
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/mkdirs/index.js
var require_mkdirs = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/mkdirs/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var { makeDir: _makeDir, makeDirSync } = require_make_dir();
    var makeDir = u(_makeDir);
    module2.exports = {
      mkdirs: makeDir,
      mkdirsSync: makeDirSync,
      mkdirp: makeDir,
      mkdirpSync: makeDirSync,
      ensureDir: makeDir,
      ensureDirSync: makeDirSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/util/utimes.js
var require_utimes = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/util/utimes.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    function utimesMillis(path, atime, mtime, callback) {
      fs.open(path, "r+", (err, fd) => {
        if (err)
          return callback(err);
        fs.futimes(fd, atime, mtime, (futimesErr) => {
          fs.close(fd, (closeErr) => {
            if (callback)
              callback(futimesErr || closeErr);
          });
        });
      });
    }
    function utimesMillisSync(path, atime, mtime) {
      const fd = fs.openSync(path, "r+");
      fs.futimesSync(fd, atime, mtime);
      return fs.closeSync(fd);
    }
    module2.exports = {
      utimesMillis,
      utimesMillisSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/util/stat.js
var require_stat = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/util/stat.js"(exports, module2) {
    "use strict";
    var fs = require_fs();
    var path = require("path");
    var util = require("util");
    var atLeastNode = require_at_least_node();
    var nodeSupportsBigInt = atLeastNode("10.5.0");
    var stat = (file) => nodeSupportsBigInt ? fs.stat(file, { bigint: true }) : fs.stat(file);
    var statSync = (file) => nodeSupportsBigInt ? fs.statSync(file, { bigint: true }) : fs.statSync(file);
    function getStats(src, dest) {
      return Promise.all([
        stat(src),
        stat(dest).catch((err) => {
          if (err.code === "ENOENT")
            return null;
          throw err;
        })
      ]).then(([srcStat, destStat]) => ({ srcStat, destStat }));
    }
    function getStatsSync(src, dest) {
      let destStat;
      const srcStat = statSync(src);
      try {
        destStat = statSync(dest);
      } catch (err) {
        if (err.code === "ENOENT")
          return { srcStat, destStat: null };
        throw err;
      }
      return { srcStat, destStat };
    }
    function checkPaths(src, dest, funcName, cb) {
      util.callbackify(getStats)(src, dest, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        if (destStat && areIdentical(srcStat, destStat)) {
          return cb(new Error("Source and destination must not be the same."));
        }
        if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return cb(null, { srcStat, destStat });
      });
    }
    function checkPathsSync(src, dest, funcName) {
      const { srcStat, destStat } = getStatsSync(src, dest);
      if (destStat && areIdentical(srcStat, destStat)) {
        throw new Error("Source and destination must not be the same.");
      }
      if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return { srcStat, destStat };
    }
    function checkParentPaths(src, srcStat, dest, funcName, cb) {
      const srcParent = path.resolve(path.dirname(src));
      const destParent = path.resolve(path.dirname(dest));
      if (destParent === srcParent || destParent === path.parse(destParent).root)
        return cb();
      const callback = (err, destStat) => {
        if (err) {
          if (err.code === "ENOENT")
            return cb();
          return cb(err);
        }
        if (areIdentical(srcStat, destStat)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return checkParentPaths(src, srcStat, destParent, funcName, cb);
      };
      if (nodeSupportsBigInt)
        fs.stat(destParent, { bigint: true }, callback);
      else
        fs.stat(destParent, callback);
    }
    function checkParentPathsSync(src, srcStat, dest, funcName) {
      const srcParent = path.resolve(path.dirname(src));
      const destParent = path.resolve(path.dirname(dest));
      if (destParent === srcParent || destParent === path.parse(destParent).root)
        return;
      let destStat;
      try {
        destStat = statSync(destParent);
      } catch (err) {
        if (err.code === "ENOENT")
          return;
        throw err;
      }
      if (areIdentical(srcStat, destStat)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return checkParentPathsSync(src, srcStat, destParent, funcName);
    }
    function areIdentical(srcStat, destStat) {
      if (destStat.ino && destStat.dev && destStat.ino === srcStat.ino && destStat.dev === srcStat.dev) {
        if (nodeSupportsBigInt || destStat.ino < Number.MAX_SAFE_INTEGER) {
          return true;
        }
        if (destStat.size === srcStat.size && destStat.mode === srcStat.mode && destStat.nlink === srcStat.nlink && destStat.atimeMs === srcStat.atimeMs && destStat.mtimeMs === srcStat.mtimeMs && destStat.ctimeMs === srcStat.ctimeMs && destStat.birthtimeMs === srcStat.birthtimeMs) {
          return true;
        }
      }
      return false;
    }
    function isSrcSubdir(src, dest) {
      const srcArr = path.resolve(src).split(path.sep).filter((i) => i);
      const destArr = path.resolve(dest).split(path.sep).filter((i) => i);
      return srcArr.reduce((acc, cur, i) => acc && destArr[i] === cur, true);
    }
    function errMsg(src, dest, funcName) {
      return `Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`;
    }
    module2.exports = {
      checkPaths,
      checkPathsSync,
      checkParentPaths,
      checkParentPathsSync,
      isSrcSubdir
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/copy-sync/copy-sync.js
var require_copy_sync = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/copy-sync/copy-sync.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var mkdirsSync = require_mkdirs().mkdirsSync;
    var utimesMillisSync = require_utimes().utimesMillisSync;
    var stat = require_stat();
    function copySync(src, dest, opts) {
      if (typeof opts === "function") {
        opts = { filter: opts };
      }
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      const { srcStat, destStat } = stat.checkPathsSync(src, dest, "copy");
      stat.checkParentPathsSync(src, srcStat, dest, "copy");
      return handleFilterAndCopy(destStat, src, dest, opts);
    }
    function handleFilterAndCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest))
        return;
      const destParent = path.dirname(dest);
      if (!fs.existsSync(destParent))
        mkdirsSync(destParent);
      return startCopy(destStat, src, dest, opts);
    }
    function startCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest))
        return;
      return getStats(destStat, src, dest, opts);
    }
    function getStats(destStat, src, dest, opts) {
      const statSync = opts.dereference ? fs.statSync : fs.lstatSync;
      const srcStat = statSync(src);
      if (srcStat.isDirectory())
        return onDir(srcStat, destStat, src, dest, opts);
      else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
        return onFile(srcStat, destStat, src, dest, opts);
      else if (srcStat.isSymbolicLink())
        return onLink(destStat, src, dest, opts);
    }
    function onFile(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts);
      return mayCopyFile(srcStat, src, dest, opts);
    }
    function mayCopyFile(srcStat, src, dest, opts) {
      if (opts.overwrite) {
        fs.unlinkSync(dest);
        return copyFile(srcStat, src, dest, opts);
      } else if (opts.errorOnExist) {
        throw new Error(`'${dest}' already exists`);
      }
    }
    function copyFile(srcStat, src, dest, opts) {
      fs.copyFileSync(src, dest);
      if (opts.preserveTimestamps)
        handleTimestamps(srcStat.mode, src, dest);
      return setDestMode(dest, srcStat.mode);
    }
    function handleTimestamps(srcMode, src, dest) {
      if (fileIsNotWritable(srcMode))
        makeFileWritable(dest, srcMode);
      return setDestTimestamps(src, dest);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode) {
      return setDestMode(dest, srcMode | 128);
    }
    function setDestMode(dest, srcMode) {
      return fs.chmodSync(dest, srcMode);
    }
    function setDestTimestamps(src, dest) {
      const updatedSrcStat = fs.statSync(src);
      return utimesMillisSync(dest, updatedSrcStat.atime, updatedSrcStat.mtime);
    }
    function onDir(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts);
      if (destStat && !destStat.isDirectory()) {
        throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
      }
      return copyDir(src, dest, opts);
    }
    function mkDirAndCopy(srcMode, src, dest, opts) {
      fs.mkdirSync(dest);
      copyDir(src, dest, opts);
      return setDestMode(dest, srcMode);
    }
    function copyDir(src, dest, opts) {
      fs.readdirSync(src).forEach((item) => copyDirItem(item, src, dest, opts));
    }
    function copyDirItem(item, src, dest, opts) {
      const srcItem = path.join(src, item);
      const destItem = path.join(dest, item);
      const { destStat } = stat.checkPathsSync(srcItem, destItem, "copy");
      return startCopy(destStat, srcItem, destItem, opts);
    }
    function onLink(destStat, src, dest, opts) {
      let resolvedSrc = fs.readlinkSync(src);
      if (opts.dereference) {
        resolvedSrc = path.resolve(process.cwd(), resolvedSrc);
      }
      if (!destStat) {
        return fs.symlinkSync(resolvedSrc, dest);
      } else {
        let resolvedDest;
        try {
          resolvedDest = fs.readlinkSync(dest);
        } catch (err) {
          if (err.code === "EINVAL" || err.code === "UNKNOWN")
            return fs.symlinkSync(resolvedSrc, dest);
          throw err;
        }
        if (opts.dereference) {
          resolvedDest = path.resolve(process.cwd(), resolvedDest);
        }
        if (stat.isSrcSubdir(resolvedSrc, resolvedDest)) {
          throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`);
        }
        if (fs.statSync(dest).isDirectory() && stat.isSrcSubdir(resolvedDest, resolvedSrc)) {
          throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`);
        }
        return copyLink(resolvedSrc, dest);
      }
    }
    function copyLink(resolvedSrc, dest) {
      fs.unlinkSync(dest);
      return fs.symlinkSync(resolvedSrc, dest);
    }
    module2.exports = copySync;
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/copy-sync/index.js
var require_copy_sync2 = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/copy-sync/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      copySync: require_copy_sync()
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/path-exists/index.js
var require_path_exists = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/path-exists/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var fs = require_fs();
    function pathExists(path) {
      return fs.access(path).then(() => true).catch(() => false);
    }
    module2.exports = {
      pathExists: u(pathExists),
      pathExistsSync: fs.existsSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/copy/copy.js
var require_copy = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/copy/copy.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var mkdirs = require_mkdirs().mkdirs;
    var pathExists = require_path_exists().pathExists;
    var utimesMillis = require_utimes().utimesMillis;
    var stat = require_stat();
    function copy(src, dest, opts, cb) {
      if (typeof opts === "function" && !cb) {
        cb = opts;
        opts = {};
      } else if (typeof opts === "function") {
        opts = { filter: opts };
      }
      cb = cb || function() {
      };
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      stat.checkPaths(src, dest, "copy", (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        stat.checkParentPaths(src, srcStat, dest, "copy", (err2) => {
          if (err2)
            return cb(err2);
          if (opts.filter)
            return handleFilter(checkParentDir, destStat, src, dest, opts, cb);
          return checkParentDir(destStat, src, dest, opts, cb);
        });
      });
    }
    function checkParentDir(destStat, src, dest, opts, cb) {
      const destParent = path.dirname(dest);
      pathExists(destParent, (err, dirExists) => {
        if (err)
          return cb(err);
        if (dirExists)
          return startCopy(destStat, src, dest, opts, cb);
        mkdirs(destParent, (err2) => {
          if (err2)
            return cb(err2);
          return startCopy(destStat, src, dest, opts, cb);
        });
      });
    }
    function handleFilter(onInclude, destStat, src, dest, opts, cb) {
      Promise.resolve(opts.filter(src, dest)).then((include) => {
        if (include)
          return onInclude(destStat, src, dest, opts, cb);
        return cb();
      }, (error) => cb(error));
    }
    function startCopy(destStat, src, dest, opts, cb) {
      if (opts.filter)
        return handleFilter(getStats, destStat, src, dest, opts, cb);
      return getStats(destStat, src, dest, opts, cb);
    }
    function getStats(destStat, src, dest, opts, cb) {
      const stat2 = opts.dereference ? fs.stat : fs.lstat;
      stat2(src, (err, srcStat) => {
        if (err)
          return cb(err);
        if (srcStat.isDirectory())
          return onDir(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
          return onFile(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isSymbolicLink())
          return onLink(destStat, src, dest, opts, cb);
      });
    }
    function onFile(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts, cb);
      return mayCopyFile(srcStat, src, dest, opts, cb);
    }
    function mayCopyFile(srcStat, src, dest, opts, cb) {
      if (opts.overwrite) {
        fs.unlink(dest, (err) => {
          if (err)
            return cb(err);
          return copyFile(srcStat, src, dest, opts, cb);
        });
      } else if (opts.errorOnExist) {
        return cb(new Error(`'${dest}' already exists`));
      } else
        return cb();
    }
    function copyFile(srcStat, src, dest, opts, cb) {
      fs.copyFile(src, dest, (err) => {
        if (err)
          return cb(err);
        if (opts.preserveTimestamps)
          return handleTimestampsAndMode(srcStat.mode, src, dest, cb);
        return setDestMode(dest, srcStat.mode, cb);
      });
    }
    function handleTimestampsAndMode(srcMode, src, dest, cb) {
      if (fileIsNotWritable(srcMode)) {
        return makeFileWritable(dest, srcMode, (err) => {
          if (err)
            return cb(err);
          return setDestTimestampsAndMode(srcMode, src, dest, cb);
        });
      }
      return setDestTimestampsAndMode(srcMode, src, dest, cb);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode, cb) {
      return setDestMode(dest, srcMode | 128, cb);
    }
    function setDestTimestampsAndMode(srcMode, src, dest, cb) {
      setDestTimestamps(src, dest, (err) => {
        if (err)
          return cb(err);
        return setDestMode(dest, srcMode, cb);
      });
    }
    function setDestMode(dest, srcMode, cb) {
      return fs.chmod(dest, srcMode, cb);
    }
    function setDestTimestamps(src, dest, cb) {
      fs.stat(src, (err, updatedSrcStat) => {
        if (err)
          return cb(err);
        return utimesMillis(dest, updatedSrcStat.atime, updatedSrcStat.mtime, cb);
      });
    }
    function onDir(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts, cb);
      if (destStat && !destStat.isDirectory()) {
        return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`));
      }
      return copyDir(src, dest, opts, cb);
    }
    function mkDirAndCopy(srcMode, src, dest, opts, cb) {
      fs.mkdir(dest, (err) => {
        if (err)
          return cb(err);
        copyDir(src, dest, opts, (err2) => {
          if (err2)
            return cb(err2);
          return setDestMode(dest, srcMode, cb);
        });
      });
    }
    function copyDir(src, dest, opts, cb) {
      fs.readdir(src, (err, items) => {
        if (err)
          return cb(err);
        return copyDirItems(items, src, dest, opts, cb);
      });
    }
    function copyDirItems(items, src, dest, opts, cb) {
      const item = items.pop();
      if (!item)
        return cb();
      return copyDirItem(items, item, src, dest, opts, cb);
    }
    function copyDirItem(items, item, src, dest, opts, cb) {
      const srcItem = path.join(src, item);
      const destItem = path.join(dest, item);
      stat.checkPaths(srcItem, destItem, "copy", (err, stats) => {
        if (err)
          return cb(err);
        const { destStat } = stats;
        startCopy(destStat, srcItem, destItem, opts, (err2) => {
          if (err2)
            return cb(err2);
          return copyDirItems(items, src, dest, opts, cb);
        });
      });
    }
    function onLink(destStat, src, dest, opts, cb) {
      fs.readlink(src, (err, resolvedSrc) => {
        if (err)
          return cb(err);
        if (opts.dereference) {
          resolvedSrc = path.resolve(process.cwd(), resolvedSrc);
        }
        if (!destStat) {
          return fs.symlink(resolvedSrc, dest, cb);
        } else {
          fs.readlink(dest, (err2, resolvedDest) => {
            if (err2) {
              if (err2.code === "EINVAL" || err2.code === "UNKNOWN")
                return fs.symlink(resolvedSrc, dest, cb);
              return cb(err2);
            }
            if (opts.dereference) {
              resolvedDest = path.resolve(process.cwd(), resolvedDest);
            }
            if (stat.isSrcSubdir(resolvedSrc, resolvedDest)) {
              return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`));
            }
            if (destStat.isDirectory() && stat.isSrcSubdir(resolvedDest, resolvedSrc)) {
              return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`));
            }
            return copyLink(resolvedSrc, dest, cb);
          });
        }
      });
    }
    function copyLink(resolvedSrc, dest, cb) {
      fs.unlink(dest, (err) => {
        if (err)
          return cb(err);
        return fs.symlink(resolvedSrc, dest, cb);
      });
    }
    module2.exports = copy;
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/copy/index.js
var require_copy2 = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/copy/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    module2.exports = {
      copy: u(require_copy())
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/remove/rimraf.js
var require_rimraf = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/remove/rimraf.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var assert = require("assert");
    var isWindows = process.platform === "win32";
    function defaults(options) {
      const methods = [
        "unlink",
        "chmod",
        "stat",
        "lstat",
        "rmdir",
        "readdir"
      ];
      methods.forEach((m) => {
        options[m] = options[m] || fs[m];
        m = m + "Sync";
        options[m] = options[m] || fs[m];
      });
      options.maxBusyTries = options.maxBusyTries || 3;
    }
    function rimraf(p, options, cb) {
      let busyTries = 0;
      if (typeof options === "function") {
        cb = options;
        options = {};
      }
      assert(p, "rimraf: missing path");
      assert.strictEqual(typeof p, "string", "rimraf: path should be a string");
      assert.strictEqual(typeof cb, "function", "rimraf: callback function required");
      assert(options, "rimraf: invalid options argument provided");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      defaults(options);
      rimraf_(p, options, function CB(er) {
        if (er) {
          if ((er.code === "EBUSY" || er.code === "ENOTEMPTY" || er.code === "EPERM") && busyTries < options.maxBusyTries) {
            busyTries++;
            const time = busyTries * 100;
            return setTimeout(() => rimraf_(p, options, CB), time);
          }
          if (er.code === "ENOENT")
            er = null;
        }
        cb(er);
      });
    }
    function rimraf_(p, options, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.lstat(p, (er, st) => {
        if (er && er.code === "ENOENT") {
          return cb(null);
        }
        if (er && er.code === "EPERM" && isWindows) {
          return fixWinEPERM(p, options, er, cb);
        }
        if (st && st.isDirectory()) {
          return rmdir(p, options, er, cb);
        }
        options.unlink(p, (er2) => {
          if (er2) {
            if (er2.code === "ENOENT") {
              return cb(null);
            }
            if (er2.code === "EPERM") {
              return isWindows ? fixWinEPERM(p, options, er2, cb) : rmdir(p, options, er2, cb);
            }
            if (er2.code === "EISDIR") {
              return rmdir(p, options, er2, cb);
            }
          }
          return cb(er2);
        });
      });
    }
    function fixWinEPERM(p, options, er, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.chmod(p, 438, (er2) => {
        if (er2) {
          cb(er2.code === "ENOENT" ? null : er);
        } else {
          options.stat(p, (er3, stats) => {
            if (er3) {
              cb(er3.code === "ENOENT" ? null : er);
            } else if (stats.isDirectory()) {
              rmdir(p, options, er, cb);
            } else {
              options.unlink(p, cb);
            }
          });
        }
      });
    }
    function fixWinEPERMSync(p, options, er) {
      let stats;
      assert(p);
      assert(options);
      try {
        options.chmodSync(p, 438);
      } catch (er2) {
        if (er2.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      try {
        stats = options.statSync(p);
      } catch (er3) {
        if (er3.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      if (stats.isDirectory()) {
        rmdirSync(p, options, er);
      } else {
        options.unlinkSync(p);
      }
    }
    function rmdir(p, options, originalEr, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.rmdir(p, (er) => {
        if (er && (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM")) {
          rmkids(p, options, cb);
        } else if (er && er.code === "ENOTDIR") {
          cb(originalEr);
        } else {
          cb(er);
        }
      });
    }
    function rmkids(p, options, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.readdir(p, (er, files) => {
        if (er)
          return cb(er);
        let n = files.length;
        let errState;
        if (n === 0)
          return options.rmdir(p, cb);
        files.forEach((f) => {
          rimraf(path.join(p, f), options, (er2) => {
            if (errState) {
              return;
            }
            if (er2)
              return cb(errState = er2);
            if (--n === 0) {
              options.rmdir(p, cb);
            }
          });
        });
      });
    }
    function rimrafSync(p, options) {
      let st;
      options = options || {};
      defaults(options);
      assert(p, "rimraf: missing path");
      assert.strictEqual(typeof p, "string", "rimraf: path should be a string");
      assert(options, "rimraf: missing options");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      try {
        st = options.lstatSync(p);
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        }
        if (er.code === "EPERM" && isWindows) {
          fixWinEPERMSync(p, options, er);
        }
      }
      try {
        if (st && st.isDirectory()) {
          rmdirSync(p, options, null);
        } else {
          options.unlinkSync(p);
        }
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        } else if (er.code === "EPERM") {
          return isWindows ? fixWinEPERMSync(p, options, er) : rmdirSync(p, options, er);
        } else if (er.code !== "EISDIR") {
          throw er;
        }
        rmdirSync(p, options, er);
      }
    }
    function rmdirSync(p, options, originalEr) {
      assert(p);
      assert(options);
      try {
        options.rmdirSync(p);
      } catch (er) {
        if (er.code === "ENOTDIR") {
          throw originalEr;
        } else if (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM") {
          rmkidsSync(p, options);
        } else if (er.code !== "ENOENT") {
          throw er;
        }
      }
    }
    function rmkidsSync(p, options) {
      assert(p);
      assert(options);
      options.readdirSync(p).forEach((f) => rimrafSync(path.join(p, f), options));
      if (isWindows) {
        const startTime = Date.now();
        do {
          try {
            const ret = options.rmdirSync(p, options);
            return ret;
          } catch {
          }
        } while (Date.now() - startTime < 500);
      } else {
        const ret = options.rmdirSync(p, options);
        return ret;
      }
    }
    module2.exports = rimraf;
    rimraf.sync = rimrafSync;
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/remove/index.js
var require_remove = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/remove/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var rimraf = require_rimraf();
    module2.exports = {
      remove: u(rimraf),
      removeSync: rimraf.sync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/empty/index.js
var require_empty = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/empty/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var fs = require_graceful_fs();
    var path = require("path");
    var mkdir = require_mkdirs();
    var remove = require_remove();
    var emptyDir = u(function emptyDir2(dir, callback) {
      callback = callback || function() {
      };
      fs.readdir(dir, (err, items) => {
        if (err)
          return mkdir.mkdirs(dir, callback);
        items = items.map((item) => path.join(dir, item));
        deleteItem();
        function deleteItem() {
          const item = items.pop();
          if (!item)
            return callback();
          remove.remove(item, (err2) => {
            if (err2)
              return callback(err2);
            deleteItem();
          });
        }
      });
    });
    function emptyDirSync(dir) {
      let items;
      try {
        items = fs.readdirSync(dir);
      } catch {
        return mkdir.mkdirsSync(dir);
      }
      items.forEach((item) => {
        item = path.join(dir, item);
        remove.removeSync(item);
      });
    }
    module2.exports = {
      emptyDirSync,
      emptydirSync: emptyDirSync,
      emptyDir,
      emptydir: emptyDir
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/file.js
var require_file = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/file.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var path = require("path");
    var fs = require_graceful_fs();
    var mkdir = require_mkdirs();
    function createFile(file, callback) {
      function makeFile() {
        fs.writeFile(file, "", (err) => {
          if (err)
            return callback(err);
          callback();
        });
      }
      fs.stat(file, (err, stats) => {
        if (!err && stats.isFile())
          return callback();
        const dir = path.dirname(file);
        fs.stat(dir, (err2, stats2) => {
          if (err2) {
            if (err2.code === "ENOENT") {
              return mkdir.mkdirs(dir, (err3) => {
                if (err3)
                  return callback(err3);
                makeFile();
              });
            }
            return callback(err2);
          }
          if (stats2.isDirectory())
            makeFile();
          else {
            fs.readdir(dir, (err3) => {
              if (err3)
                return callback(err3);
            });
          }
        });
      });
    }
    function createFileSync(file) {
      let stats;
      try {
        stats = fs.statSync(file);
      } catch {
      }
      if (stats && stats.isFile())
        return;
      const dir = path.dirname(file);
      try {
        if (!fs.statSync(dir).isDirectory()) {
          fs.readdirSync(dir);
        }
      } catch (err) {
        if (err && err.code === "ENOENT")
          mkdir.mkdirsSync(dir);
        else
          throw err;
      }
      fs.writeFileSync(file, "");
    }
    module2.exports = {
      createFile: u(createFile),
      createFileSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/link.js
var require_link = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/link.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var path = require("path");
    var fs = require_graceful_fs();
    var mkdir = require_mkdirs();
    var pathExists = require_path_exists().pathExists;
    function createLink(srcpath, dstpath, callback) {
      function makeLink(srcpath2, dstpath2) {
        fs.link(srcpath2, dstpath2, (err) => {
          if (err)
            return callback(err);
          callback(null);
        });
      }
      pathExists(dstpath, (err, destinationExists) => {
        if (err)
          return callback(err);
        if (destinationExists)
          return callback(null);
        fs.lstat(srcpath, (err2) => {
          if (err2) {
            err2.message = err2.message.replace("lstat", "ensureLink");
            return callback(err2);
          }
          const dir = path.dirname(dstpath);
          pathExists(dir, (err3, dirExists) => {
            if (err3)
              return callback(err3);
            if (dirExists)
              return makeLink(srcpath, dstpath);
            mkdir.mkdirs(dir, (err4) => {
              if (err4)
                return callback(err4);
              makeLink(srcpath, dstpath);
            });
          });
        });
      });
    }
    function createLinkSync(srcpath, dstpath) {
      const destinationExists = fs.existsSync(dstpath);
      if (destinationExists)
        return void 0;
      try {
        fs.lstatSync(srcpath);
      } catch (err) {
        err.message = err.message.replace("lstat", "ensureLink");
        throw err;
      }
      const dir = path.dirname(dstpath);
      const dirExists = fs.existsSync(dir);
      if (dirExists)
        return fs.linkSync(srcpath, dstpath);
      mkdir.mkdirsSync(dir);
      return fs.linkSync(srcpath, dstpath);
    }
    module2.exports = {
      createLink: u(createLink),
      createLinkSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/symlink-paths.js
var require_symlink_paths = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports, module2) {
    "use strict";
    var path = require("path");
    var fs = require_graceful_fs();
    var pathExists = require_path_exists().pathExists;
    function symlinkPaths(srcpath, dstpath, callback) {
      if (path.isAbsolute(srcpath)) {
        return fs.lstat(srcpath, (err) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureSymlink");
            return callback(err);
          }
          return callback(null, {
            toCwd: srcpath,
            toDst: srcpath
          });
        });
      } else {
        const dstdir = path.dirname(dstpath);
        const relativeToDst = path.join(dstdir, srcpath);
        return pathExists(relativeToDst, (err, exists) => {
          if (err)
            return callback(err);
          if (exists) {
            return callback(null, {
              toCwd: relativeToDst,
              toDst: srcpath
            });
          } else {
            return fs.lstat(srcpath, (err2) => {
              if (err2) {
                err2.message = err2.message.replace("lstat", "ensureSymlink");
                return callback(err2);
              }
              return callback(null, {
                toCwd: srcpath,
                toDst: path.relative(dstdir, srcpath)
              });
            });
          }
        });
      }
    }
    function symlinkPathsSync(srcpath, dstpath) {
      let exists;
      if (path.isAbsolute(srcpath)) {
        exists = fs.existsSync(srcpath);
        if (!exists)
          throw new Error("absolute srcpath does not exist");
        return {
          toCwd: srcpath,
          toDst: srcpath
        };
      } else {
        const dstdir = path.dirname(dstpath);
        const relativeToDst = path.join(dstdir, srcpath);
        exists = fs.existsSync(relativeToDst);
        if (exists) {
          return {
            toCwd: relativeToDst,
            toDst: srcpath
          };
        } else {
          exists = fs.existsSync(srcpath);
          if (!exists)
            throw new Error("relative srcpath does not exist");
          return {
            toCwd: srcpath,
            toDst: path.relative(dstdir, srcpath)
          };
        }
      }
    }
    module2.exports = {
      symlinkPaths,
      symlinkPathsSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/symlink-type.js
var require_symlink_type = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/symlink-type.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    function symlinkType(srcpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      if (type)
        return callback(null, type);
      fs.lstat(srcpath, (err, stats) => {
        if (err)
          return callback(null, "file");
        type = stats && stats.isDirectory() ? "dir" : "file";
        callback(null, type);
      });
    }
    function symlinkTypeSync(srcpath, type) {
      let stats;
      if (type)
        return type;
      try {
        stats = fs.lstatSync(srcpath);
      } catch {
        return "file";
      }
      return stats && stats.isDirectory() ? "dir" : "file";
    }
    module2.exports = {
      symlinkType,
      symlinkTypeSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/symlink.js
var require_symlink = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/symlink.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var path = require("path");
    var fs = require_graceful_fs();
    var _mkdirs = require_mkdirs();
    var mkdirs = _mkdirs.mkdirs;
    var mkdirsSync = _mkdirs.mkdirsSync;
    var _symlinkPaths = require_symlink_paths();
    var symlinkPaths = _symlinkPaths.symlinkPaths;
    var symlinkPathsSync = _symlinkPaths.symlinkPathsSync;
    var _symlinkType = require_symlink_type();
    var symlinkType = _symlinkType.symlinkType;
    var symlinkTypeSync = _symlinkType.symlinkTypeSync;
    var pathExists = require_path_exists().pathExists;
    function createSymlink(srcpath, dstpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      pathExists(dstpath, (err, destinationExists) => {
        if (err)
          return callback(err);
        if (destinationExists)
          return callback(null);
        symlinkPaths(srcpath, dstpath, (err2, relative) => {
          if (err2)
            return callback(err2);
          srcpath = relative.toDst;
          symlinkType(relative.toCwd, type, (err3, type2) => {
            if (err3)
              return callback(err3);
            const dir = path.dirname(dstpath);
            pathExists(dir, (err4, dirExists) => {
              if (err4)
                return callback(err4);
              if (dirExists)
                return fs.symlink(srcpath, dstpath, type2, callback);
              mkdirs(dir, (err5) => {
                if (err5)
                  return callback(err5);
                fs.symlink(srcpath, dstpath, type2, callback);
              });
            });
          });
        });
      });
    }
    function createSymlinkSync(srcpath, dstpath, type) {
      const destinationExists = fs.existsSync(dstpath);
      if (destinationExists)
        return void 0;
      const relative = symlinkPathsSync(srcpath, dstpath);
      srcpath = relative.toDst;
      type = symlinkTypeSync(relative.toCwd, type);
      const dir = path.dirname(dstpath);
      const exists = fs.existsSync(dir);
      if (exists)
        return fs.symlinkSync(srcpath, dstpath, type);
      mkdirsSync(dir);
      return fs.symlinkSync(srcpath, dstpath, type);
    }
    module2.exports = {
      createSymlink: u(createSymlink),
      createSymlinkSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/index.js
var require_ensure = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/ensure/index.js"(exports, module2) {
    "use strict";
    var file = require_file();
    var link = require_link();
    var symlink = require_symlink();
    module2.exports = {
      createFile: file.createFile,
      createFileSync: file.createFileSync,
      ensureFile: file.createFile,
      ensureFileSync: file.createFileSync,
      createLink: link.createLink,
      createLinkSync: link.createLinkSync,
      ensureLink: link.createLink,
      ensureLinkSync: link.createLinkSync,
      createSymlink: symlink.createSymlink,
      createSymlinkSync: symlink.createSymlinkSync,
      ensureSymlink: symlink.createSymlink,
      ensureSymlinkSync: symlink.createSymlinkSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/jsonfile/utils.js
var require_utils = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/jsonfile/utils.js"(exports, module2) {
    function stringify(obj, { EOL = "\n", finalEOL = true, replacer = null, spaces } = {}) {
      const EOF = finalEOL ? EOL : "";
      const str = JSON.stringify(obj, replacer, spaces);
      return str.replace(/\n/g, EOL) + EOF;
    }
    function stripBom(content) {
      if (Buffer.isBuffer(content))
        content = content.toString("utf8");
      return content.replace(/^\uFEFF/, "");
    }
    module2.exports = { stringify, stripBom };
  }
});

// node_modules/@aws-cdk/core/node_modules/jsonfile/index.js
var require_jsonfile = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/jsonfile/index.js"(exports, module2) {
    var _fs;
    try {
      _fs = require_graceful_fs();
    } catch (_) {
      _fs = require("fs");
    }
    var universalify = require_universalify();
    var { stringify, stripBom } = require_utils();
    async function _readFile(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      let data = await universalify.fromCallback(fs.readFile)(file, options);
      data = stripBom(data);
      let obj;
      try {
        obj = JSON.parse(data, options ? options.reviver : null);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
      return obj;
    }
    var readFile = universalify.fromPromise(_readFile);
    function readFileSync(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      try {
        let content = fs.readFileSync(file, options);
        content = stripBom(content);
        return JSON.parse(content, options.reviver);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
    }
    async function _writeFile(file, obj, options = {}) {
      const fs = options.fs || _fs;
      const str = stringify(obj, options);
      await universalify.fromCallback(fs.writeFile)(file, str, options);
    }
    var writeFile = universalify.fromPromise(_writeFile);
    function writeFileSync(file, obj, options = {}) {
      const fs = options.fs || _fs;
      const str = stringify(obj, options);
      return fs.writeFileSync(file, str, options);
    }
    var jsonfile = {
      readFile,
      readFileSync,
      writeFile,
      writeFileSync
    };
    module2.exports = jsonfile;
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/json/jsonfile.js
var require_jsonfile2 = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/json/jsonfile.js"(exports, module2) {
    "use strict";
    var jsonFile = require_jsonfile();
    module2.exports = {
      readJson: jsonFile.readFile,
      readJsonSync: jsonFile.readFileSync,
      writeJson: jsonFile.writeFile,
      writeJsonSync: jsonFile.writeFileSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/output/index.js
var require_output = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/output/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var fs = require_graceful_fs();
    var path = require("path");
    var mkdir = require_mkdirs();
    var pathExists = require_path_exists().pathExists;
    function outputFile(file, data, encoding, callback) {
      if (typeof encoding === "function") {
        callback = encoding;
        encoding = "utf8";
      }
      const dir = path.dirname(file);
      pathExists(dir, (err, itDoes) => {
        if (err)
          return callback(err);
        if (itDoes)
          return fs.writeFile(file, data, encoding, callback);
        mkdir.mkdirs(dir, (err2) => {
          if (err2)
            return callback(err2);
          fs.writeFile(file, data, encoding, callback);
        });
      });
    }
    function outputFileSync(file, ...args) {
      const dir = path.dirname(file);
      if (fs.existsSync(dir)) {
        return fs.writeFileSync(file, ...args);
      }
      mkdir.mkdirsSync(dir);
      fs.writeFileSync(file, ...args);
    }
    module2.exports = {
      outputFile: u(outputFile),
      outputFileSync
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/json/output-json.js
var require_output_json = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/json/output-json.js"(exports, module2) {
    "use strict";
    var { stringify } = require_utils();
    var { outputFile } = require_output();
    async function outputJson(file, data, options = {}) {
      const str = stringify(data, options);
      await outputFile(file, str, options);
    }
    module2.exports = outputJson;
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/json/output-json-sync.js
var require_output_json_sync = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/json/output-json-sync.js"(exports, module2) {
    "use strict";
    var { stringify } = require_utils();
    var { outputFileSync } = require_output();
    function outputJsonSync(file, data, options) {
      const str = stringify(data, options);
      outputFileSync(file, str, options);
    }
    module2.exports = outputJsonSync;
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/json/index.js
var require_json = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/json/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var jsonFile = require_jsonfile2();
    jsonFile.outputJson = u(require_output_json());
    jsonFile.outputJsonSync = require_output_json_sync();
    jsonFile.outputJSON = jsonFile.outputJson;
    jsonFile.outputJSONSync = jsonFile.outputJsonSync;
    jsonFile.writeJSON = jsonFile.writeJson;
    jsonFile.writeJSONSync = jsonFile.writeJsonSync;
    jsonFile.readJSON = jsonFile.readJson;
    jsonFile.readJSONSync = jsonFile.readJsonSync;
    module2.exports = jsonFile;
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/move-sync/move-sync.js
var require_move_sync = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/move-sync/move-sync.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var copySync = require_copy_sync2().copySync;
    var removeSync = require_remove().removeSync;
    var mkdirpSync = require_mkdirs().mkdirpSync;
    var stat = require_stat();
    function moveSync(src, dest, opts) {
      opts = opts || {};
      const overwrite = opts.overwrite || opts.clobber || false;
      const { srcStat } = stat.checkPathsSync(src, dest, "move");
      stat.checkParentPathsSync(src, srcStat, dest, "move");
      mkdirpSync(path.dirname(dest));
      return doRename(src, dest, overwrite);
    }
    function doRename(src, dest, overwrite) {
      if (overwrite) {
        removeSync(dest);
        return rename(src, dest, overwrite);
      }
      if (fs.existsSync(dest))
        throw new Error("dest already exists.");
      return rename(src, dest, overwrite);
    }
    function rename(src, dest, overwrite) {
      try {
        fs.renameSync(src, dest);
      } catch (err) {
        if (err.code !== "EXDEV")
          throw err;
        return moveAcrossDevice(src, dest, overwrite);
      }
    }
    function moveAcrossDevice(src, dest, overwrite) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copySync(src, dest, opts);
      return removeSync(src);
    }
    module2.exports = moveSync;
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/move-sync/index.js
var require_move_sync2 = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/move-sync/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      moveSync: require_move_sync()
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/move/move.js
var require_move = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/move/move.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var copy = require_copy2().copy;
    var remove = require_remove().remove;
    var mkdirp = require_mkdirs().mkdirp;
    var pathExists = require_path_exists().pathExists;
    var stat = require_stat();
    function move(src, dest, opts, cb) {
      if (typeof opts === "function") {
        cb = opts;
        opts = {};
      }
      const overwrite = opts.overwrite || opts.clobber || false;
      stat.checkPaths(src, dest, "move", (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat } = stats;
        stat.checkParentPaths(src, srcStat, dest, "move", (err2) => {
          if (err2)
            return cb(err2);
          mkdirp(path.dirname(dest), (err3) => {
            if (err3)
              return cb(err3);
            return doRename(src, dest, overwrite, cb);
          });
        });
      });
    }
    function doRename(src, dest, overwrite, cb) {
      if (overwrite) {
        return remove(dest, (err) => {
          if (err)
            return cb(err);
          return rename(src, dest, overwrite, cb);
        });
      }
      pathExists(dest, (err, destExists) => {
        if (err)
          return cb(err);
        if (destExists)
          return cb(new Error("dest already exists."));
        return rename(src, dest, overwrite, cb);
      });
    }
    function rename(src, dest, overwrite, cb) {
      fs.rename(src, dest, (err) => {
        if (!err)
          return cb();
        if (err.code !== "EXDEV")
          return cb(err);
        return moveAcrossDevice(src, dest, overwrite, cb);
      });
    }
    function moveAcrossDevice(src, dest, overwrite, cb) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copy(src, dest, opts, (err) => {
        if (err)
          return cb(err);
        return remove(src, cb);
      });
    }
    module2.exports = move;
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/move/index.js
var require_move2 = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/move/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    module2.exports = {
      move: u(require_move())
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/fs-extra/lib/index.js
var require_lib6 = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/fs-extra/lib/index.js"(exports, module2) {
    "use strict";
    module2.exports = __spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues({}, require_fs()), require_copy_sync2()), require_copy2()), require_empty()), require_ensure()), require_json()), require_mkdirs()), require_move_sync2()), require_move2()), require_output()), require_path_exists()), require_remove());
    var fs = require("fs");
    if (Object.getOwnPropertyDescriptor(fs, "promises")) {
      Object.defineProperty(module2.exports, "promises", {
        get() {
          return fs.promises;
        }
      });
    }
  }
});

// node_modules/@aws-cdk/core/node_modules/concat-map/index.js
var require_concat_map = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/concat-map/index.js"(exports, module2) {
    module2.exports = function(xs, fn) {
      var res = [];
      for (var i = 0; i < xs.length; i++) {
        var x = fn(xs[i], i);
        if (isArray(x))
          res.push.apply(res, x);
        else
          res.push(x);
      }
      return res;
    };
    var isArray = Array.isArray || function(xs) {
      return Object.prototype.toString.call(xs) === "[object Array]";
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/balanced-match/index.js"(exports, module2) {
    "use strict";
    module2.exports = balanced;
    function balanced(a, b, str) {
      if (a instanceof RegExp)
        a = maybeMatch(a, str);
      if (b instanceof RegExp)
        b = maybeMatch(b, str);
      var r = range(a, b, str);
      return r && {
        start: r[0],
        end: r[1],
        pre: str.slice(0, r[0]),
        body: str.slice(r[0] + a.length, r[1]),
        post: str.slice(r[1] + b.length)
      };
    }
    function maybeMatch(reg, str) {
      var m = str.match(reg);
      return m ? m[0] : null;
    }
    balanced.range = range;
    function range(a, b, str) {
      var begs, beg, left, right, result;
      var ai = str.indexOf(a);
      var bi = str.indexOf(b, ai + 1);
      var i = ai;
      if (ai >= 0 && bi > 0) {
        if (a === b) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i >= 0 && !result) {
          if (i == ai) {
            begs.push(i);
            ai = str.indexOf(a, i + 1);
          } else if (begs.length == 1) {
            result = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b, i + 1);
          }
          i = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result = [left, right];
        }
      }
      return result;
    }
  }
});

// node_modules/@aws-cdk/core/node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/brace-expansion/index.js"(exports, module2) {
    var concatMap = require_concat_map();
    var balanced = require_balanced_match();
    module2.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts = [];
      var m = balanced("{", "}", str);
      if (!m)
        return str.split(",");
      var pre = m.pre;
      var body = m.body;
      var post = m.post;
      var p = pre.split(",");
      p[p.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p[p.length - 1] += postParts.shift();
        p.push.apply(p, postParts);
      }
      parts.push.apply(parts, p);
      return parts;
    }
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte(i, y) {
      return i <= y;
    }
    function gte(i, y) {
      return i >= y;
    }
    function expand(str, isTop) {
      var expansions = [];
      var m = balanced("{", "}", str);
      if (!m || /\$$/.test(m.pre))
        return [str];
      var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
      var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
      var isSequence = isNumericSequence || isAlphaSequence;
      var isOptions = m.body.indexOf(",") >= 0;
      if (!isSequence && !isOptions) {
        if (m.post.match(/,.*\}/)) {
          str = m.pre + "{" + m.body + escClose + m.post;
          return expand(str);
        }
        return [str];
      }
      var n;
      if (isSequence) {
        n = m.body.split(/\.\./);
      } else {
        n = parseCommaParts(m.body);
        if (n.length === 1) {
          n = expand(n[0], false).map(embrace);
          if (n.length === 1) {
            var post = m.post.length ? expand(m.post, false) : [""];
            return post.map(function(p) {
              return m.pre + n[0] + p;
            });
          }
        }
      }
      var pre = m.pre;
      var post = m.post.length ? expand(m.post, false) : [""];
      var N;
      if (isSequence) {
        var x = numeric(n[0]);
        var y = numeric(n[1]);
        var width = Math.max(n[0].length, n[1].length);
        var incr = n.length == 3 ? Math.abs(numeric(n[2])) : 1;
        var test = lte;
        var reverse = y < x;
        if (reverse) {
          incr *= -1;
          test = gte;
        }
        var pad = n.some(isPadded);
        N = [];
        for (var i = x; test(i, y); i += incr) {
          var c;
          if (isAlphaSequence) {
            c = String.fromCharCode(i);
            if (c === "\\")
              c = "";
          } else {
            c = String(i);
            if (pad) {
              var need = width - c.length;
              if (need > 0) {
                var z = new Array(need + 1).join("0");
                if (i < 0)
                  c = "-" + z + c.slice(1);
                else
                  c = z + c;
              }
            }
          }
          N.push(c);
        }
      } else {
        N = concatMap(n, function(el) {
          return expand(el, false);
        });
      }
      for (var j = 0; j < N.length; j++) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + N[j] + post[k];
          if (!isTop || isSequence || expansion)
            expansions.push(expansion);
        }
      }
      return expansions;
    }
  }
});

// node_modules/@aws-cdk/core/node_modules/minimatch/minimatch.js
var require_minimatch = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/minimatch/minimatch.js"(exports, module2) {
    module2.exports = minimatch;
    minimatch.Minimatch = Minimatch;
    var path = { sep: "/" };
    try {
      path = require("path");
    } catch (er) {
    }
    var GLOBSTAR = minimatch.GLOBSTAR = Minimatch.GLOBSTAR = {};
    var expand = require_brace_expansion();
    var plTypes = {
      "!": { open: "(?:(?!(?:", close: "))[^/]*?)" },
      "?": { open: "(?:", close: ")?" },
      "+": { open: "(?:", close: ")+" },
      "*": { open: "(?:", close: ")*" },
      "@": { open: "(?:", close: ")" }
    };
    var qmark = "[^/]";
    var star = qmark + "*?";
    var twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    var twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
    var reSpecials = charSet("().*{}+?[]^$\\!");
    function charSet(s) {
      return s.split("").reduce(function(set, c) {
        set[c] = true;
        return set;
      }, {});
    }
    var slashSplit = /\/+/;
    minimatch.filter = filter;
    function filter(pattern, options) {
      options = options || {};
      return function(p, i, list) {
        return minimatch(p, pattern, options);
      };
    }
    function ext(a, b) {
      a = a || {};
      b = b || {};
      var t = {};
      Object.keys(b).forEach(function(k) {
        t[k] = b[k];
      });
      Object.keys(a).forEach(function(k) {
        t[k] = a[k];
      });
      return t;
    }
    minimatch.defaults = function(def) {
      if (!def || !Object.keys(def).length)
        return minimatch;
      var orig = minimatch;
      var m = function minimatch2(p, pattern, options) {
        return orig.minimatch(p, pattern, ext(def, options));
      };
      m.Minimatch = function Minimatch2(pattern, options) {
        return new orig.Minimatch(pattern, ext(def, options));
      };
      return m;
    };
    Minimatch.defaults = function(def) {
      if (!def || !Object.keys(def).length)
        return Minimatch;
      return minimatch.defaults(def).Minimatch;
    };
    function minimatch(p, pattern, options) {
      if (typeof pattern !== "string") {
        throw new TypeError("glob pattern string required");
      }
      if (!options)
        options = {};
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      if (pattern.trim() === "")
        return p === "";
      return new Minimatch(pattern, options).match(p);
    }
    function Minimatch(pattern, options) {
      if (!(this instanceof Minimatch)) {
        return new Minimatch(pattern, options);
      }
      if (typeof pattern !== "string") {
        throw new TypeError("glob pattern string required");
      }
      if (!options)
        options = {};
      pattern = pattern.trim();
      if (path.sep !== "/") {
        pattern = pattern.split(path.sep).join("/");
      }
      this.options = options;
      this.set = [];
      this.pattern = pattern;
      this.regexp = null;
      this.negate = false;
      this.comment = false;
      this.empty = false;
      this.make();
    }
    Minimatch.prototype.debug = function() {
    };
    Minimatch.prototype.make = make;
    function make() {
      if (this._made)
        return;
      var pattern = this.pattern;
      var options = this.options;
      if (!options.nocomment && pattern.charAt(0) === "#") {
        this.comment = true;
        return;
      }
      if (!pattern) {
        this.empty = true;
        return;
      }
      this.parseNegate();
      var set = this.globSet = this.braceExpand();
      if (options.debug)
        this.debug = console.error;
      this.debug(this.pattern, set);
      set = this.globParts = set.map(function(s) {
        return s.split(slashSplit);
      });
      this.debug(this.pattern, set);
      set = set.map(function(s, si, set2) {
        return s.map(this.parse, this);
      }, this);
      this.debug(this.pattern, set);
      set = set.filter(function(s) {
        return s.indexOf(false) === -1;
      });
      this.debug(this.pattern, set);
      this.set = set;
    }
    Minimatch.prototype.parseNegate = parseNegate;
    function parseNegate() {
      var pattern = this.pattern;
      var negate = false;
      var options = this.options;
      var negateOffset = 0;
      if (options.nonegate)
        return;
      for (var i = 0, l = pattern.length; i < l && pattern.charAt(i) === "!"; i++) {
        negate = !negate;
        negateOffset++;
      }
      if (negateOffset)
        this.pattern = pattern.substr(negateOffset);
      this.negate = negate;
    }
    minimatch.braceExpand = function(pattern, options) {
      return braceExpand(pattern, options);
    };
    Minimatch.prototype.braceExpand = braceExpand;
    function braceExpand(pattern, options) {
      if (!options) {
        if (this instanceof Minimatch) {
          options = this.options;
        } else {
          options = {};
        }
      }
      pattern = typeof pattern === "undefined" ? this.pattern : pattern;
      if (typeof pattern === "undefined") {
        throw new TypeError("undefined pattern");
      }
      if (options.nobrace || !pattern.match(/\{.*\}/)) {
        return [pattern];
      }
      return expand(pattern);
    }
    Minimatch.prototype.parse = parse;
    var SUBPARSE = {};
    function parse(pattern, isSub) {
      if (pattern.length > 1024 * 64) {
        throw new TypeError("pattern is too long");
      }
      var options = this.options;
      if (!options.noglobstar && pattern === "**")
        return GLOBSTAR;
      if (pattern === "")
        return "";
      var re = "";
      var hasMagic = !!options.nocase;
      var escaping = false;
      var patternListStack = [];
      var negativeLists = [];
      var stateChar;
      var inClass = false;
      var reClassStart = -1;
      var classStart = -1;
      var patternStart = pattern.charAt(0) === "." ? "" : options.dot ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)";
      var self = this;
      function clearStateChar() {
        if (stateChar) {
          switch (stateChar) {
            case "*":
              re += star;
              hasMagic = true;
              break;
            case "?":
              re += qmark;
              hasMagic = true;
              break;
            default:
              re += "\\" + stateChar;
              break;
          }
          self.debug("clearStateChar %j %j", stateChar, re);
          stateChar = false;
        }
      }
      for (var i = 0, len = pattern.length, c; i < len && (c = pattern.charAt(i)); i++) {
        this.debug("%s	%s %s %j", pattern, i, re, c);
        if (escaping && reSpecials[c]) {
          re += "\\" + c;
          escaping = false;
          continue;
        }
        switch (c) {
          case "/":
            return false;
          case "\\":
            clearStateChar();
            escaping = true;
            continue;
          case "?":
          case "*":
          case "+":
          case "@":
          case "!":
            this.debug("%s	%s %s %j <-- stateChar", pattern, i, re, c);
            if (inClass) {
              this.debug("  in class");
              if (c === "!" && i === classStart + 1)
                c = "^";
              re += c;
              continue;
            }
            self.debug("call clearStateChar %j", stateChar);
            clearStateChar();
            stateChar = c;
            if (options.noext)
              clearStateChar();
            continue;
          case "(":
            if (inClass) {
              re += "(";
              continue;
            }
            if (!stateChar) {
              re += "\\(";
              continue;
            }
            patternListStack.push({
              type: stateChar,
              start: i - 1,
              reStart: re.length,
              open: plTypes[stateChar].open,
              close: plTypes[stateChar].close
            });
            re += stateChar === "!" ? "(?:(?!(?:" : "(?:";
            this.debug("plType %j %j", stateChar, re);
            stateChar = false;
            continue;
          case ")":
            if (inClass || !patternListStack.length) {
              re += "\\)";
              continue;
            }
            clearStateChar();
            hasMagic = true;
            var pl = patternListStack.pop();
            re += pl.close;
            if (pl.type === "!") {
              negativeLists.push(pl);
            }
            pl.reEnd = re.length;
            continue;
          case "|":
            if (inClass || !patternListStack.length || escaping) {
              re += "\\|";
              escaping = false;
              continue;
            }
            clearStateChar();
            re += "|";
            continue;
          case "[":
            clearStateChar();
            if (inClass) {
              re += "\\" + c;
              continue;
            }
            inClass = true;
            classStart = i;
            reClassStart = re.length;
            re += c;
            continue;
          case "]":
            if (i === classStart + 1 || !inClass) {
              re += "\\" + c;
              escaping = false;
              continue;
            }
            if (inClass) {
              var cs = pattern.substring(classStart + 1, i);
              try {
                RegExp("[" + cs + "]");
              } catch (er) {
                var sp = this.parse(cs, SUBPARSE);
                re = re.substr(0, reClassStart) + "\\[" + sp[0] + "\\]";
                hasMagic = hasMagic || sp[1];
                inClass = false;
                continue;
              }
            }
            hasMagic = true;
            inClass = false;
            re += c;
            continue;
          default:
            clearStateChar();
            if (escaping) {
              escaping = false;
            } else if (reSpecials[c] && !(c === "^" && inClass)) {
              re += "\\";
            }
            re += c;
        }
      }
      if (inClass) {
        cs = pattern.substr(classStart + 1);
        sp = this.parse(cs, SUBPARSE);
        re = re.substr(0, reClassStart) + "\\[" + sp[0];
        hasMagic = hasMagic || sp[1];
      }
      for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
        var tail = re.slice(pl.reStart + pl.open.length);
        this.debug("setting tail", re, pl);
        tail = tail.replace(/((?:\\{2}){0,64})(\\?)\|/g, function(_, $1, $2) {
          if (!$2) {
            $2 = "\\";
          }
          return $1 + $1 + $2 + "|";
        });
        this.debug("tail=%j\n   %s", tail, tail, pl, re);
        var t = pl.type === "*" ? star : pl.type === "?" ? qmark : "\\" + pl.type;
        hasMagic = true;
        re = re.slice(0, pl.reStart) + t + "\\(" + tail;
      }
      clearStateChar();
      if (escaping) {
        re += "\\\\";
      }
      var addPatternStart = false;
      switch (re.charAt(0)) {
        case ".":
        case "[":
        case "(":
          addPatternStart = true;
      }
      for (var n = negativeLists.length - 1; n > -1; n--) {
        var nl = negativeLists[n];
        var nlBefore = re.slice(0, nl.reStart);
        var nlFirst = re.slice(nl.reStart, nl.reEnd - 8);
        var nlLast = re.slice(nl.reEnd - 8, nl.reEnd);
        var nlAfter = re.slice(nl.reEnd);
        nlLast += nlAfter;
        var openParensBefore = nlBefore.split("(").length - 1;
        var cleanAfter = nlAfter;
        for (i = 0; i < openParensBefore; i++) {
          cleanAfter = cleanAfter.replace(/\)[+*?]?/, "");
        }
        nlAfter = cleanAfter;
        var dollar = "";
        if (nlAfter === "" && isSub !== SUBPARSE) {
          dollar = "$";
        }
        var newRe = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        re = newRe;
      }
      if (re !== "" && hasMagic) {
        re = "(?=.)" + re;
      }
      if (addPatternStart) {
        re = patternStart + re;
      }
      if (isSub === SUBPARSE) {
        return [re, hasMagic];
      }
      if (!hasMagic) {
        return globUnescape(pattern);
      }
      var flags = options.nocase ? "i" : "";
      try {
        var regExp = new RegExp("^" + re + "$", flags);
      } catch (er) {
        return new RegExp("$.");
      }
      regExp._glob = pattern;
      regExp._src = re;
      return regExp;
    }
    minimatch.makeRe = function(pattern, options) {
      return new Minimatch(pattern, options || {}).makeRe();
    };
    Minimatch.prototype.makeRe = makeRe;
    function makeRe() {
      if (this.regexp || this.regexp === false)
        return this.regexp;
      var set = this.set;
      if (!set.length) {
        this.regexp = false;
        return this.regexp;
      }
      var options = this.options;
      var twoStar = options.noglobstar ? star : options.dot ? twoStarDot : twoStarNoDot;
      var flags = options.nocase ? "i" : "";
      var re = set.map(function(pattern) {
        return pattern.map(function(p) {
          return p === GLOBSTAR ? twoStar : typeof p === "string" ? regExpEscape(p) : p._src;
        }).join("\\/");
      }).join("|");
      re = "^(?:" + re + ")$";
      if (this.negate)
        re = "^(?!" + re + ").*$";
      try {
        this.regexp = new RegExp(re, flags);
      } catch (ex) {
        this.regexp = false;
      }
      return this.regexp;
    }
    minimatch.match = function(list, pattern, options) {
      options = options || {};
      var mm = new Minimatch(pattern, options);
      list = list.filter(function(f) {
        return mm.match(f);
      });
      if (mm.options.nonull && !list.length) {
        list.push(pattern);
      }
      return list;
    };
    Minimatch.prototype.match = match;
    function match(f, partial) {
      this.debug("match", f, this.pattern);
      if (this.comment)
        return false;
      if (this.empty)
        return f === "";
      if (f === "/" && partial)
        return true;
      var options = this.options;
      if (path.sep !== "/") {
        f = f.split(path.sep).join("/");
      }
      f = f.split(slashSplit);
      this.debug(this.pattern, "split", f);
      var set = this.set;
      this.debug(this.pattern, "set", set);
      var filename;
      var i;
      for (i = f.length - 1; i >= 0; i--) {
        filename = f[i];
        if (filename)
          break;
      }
      for (i = 0; i < set.length; i++) {
        var pattern = set[i];
        var file = f;
        if (options.matchBase && pattern.length === 1) {
          file = [filename];
        }
        var hit = this.matchOne(file, pattern, partial);
        if (hit) {
          if (options.flipNegate)
            return true;
          return !this.negate;
        }
      }
      if (options.flipNegate)
        return false;
      return this.negate;
    }
    Minimatch.prototype.matchOne = function(file, pattern, partial) {
      var options = this.options;
      this.debug("matchOne", { "this": this, file, pattern });
      this.debug("matchOne", file.length, pattern.length);
      for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
        this.debug("matchOne loop");
        var p = pattern[pi];
        var f = file[fi];
        this.debug(pattern, p, f);
        if (p === false)
          return false;
        if (p === GLOBSTAR) {
          this.debug("GLOBSTAR", [pattern, p, f]);
          var fr = fi;
          var pr = pi + 1;
          if (pr === pl) {
            this.debug("** at the end");
            for (; fi < fl; fi++) {
              if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".")
                return false;
            }
            return true;
          }
          while (fr < fl) {
            var swallowee = file[fr];
            this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
            if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
              this.debug("globstar found match!", fr, fl, swallowee);
              return true;
            } else {
              if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                this.debug("dot detected!", file, fr, pattern, pr);
                break;
              }
              this.debug("globstar swallow a segment, and continue");
              fr++;
            }
          }
          if (partial) {
            this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
            if (fr === fl)
              return true;
          }
          return false;
        }
        var hit;
        if (typeof p === "string") {
          if (options.nocase) {
            hit = f.toLowerCase() === p.toLowerCase();
          } else {
            hit = f === p;
          }
          this.debug("string match", p, f, hit);
        } else {
          hit = f.match(p);
          this.debug("pattern match", p, f, hit);
        }
        if (!hit)
          return false;
      }
      if (fi === fl && pi === pl) {
        return true;
      } else if (fi === fl) {
        return partial;
      } else if (pi === pl) {
        var emptyFileEnd = fi === fl - 1 && file[fi] === "";
        return emptyFileEnd;
      }
      throw new Error("wtf?");
    };
    function globUnescape(s) {
      return s.replace(/\\(.)/g, "$1");
    }
    function regExpEscape(s) {
      return s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    }
  }
});

// node_modules/@aws-cdk/core/lib/assets.js
var require_assets3 = __commonJS({
  "node_modules/@aws-cdk/core/lib/assets.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.FileAssetPackaging = exports.AssetHashType = void 0;
    var AssetHashType;
    (function(AssetHashType2) {
      AssetHashType2["SOURCE"] = "source";
      AssetHashType2["BUNDLE"] = "bundle";
      AssetHashType2["OUTPUT"] = "output";
      AssetHashType2["CUSTOM"] = "custom";
    })(AssetHashType = exports.AssetHashType || (exports.AssetHashType = {}));
    var FileAssetPackaging;
    (function(FileAssetPackaging2) {
      FileAssetPackaging2["ZIP_DIRECTORY"] = "zip";
      FileAssetPackaging2["FILE"] = "file";
    })(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
  }
});

// node_modules/@aws-cdk/core/node_modules/@balena/dockerignore/ignore.js
var require_ignore = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/@balena/dockerignore/ignore.js"(exports, module2) {
    "use strict";
    var path = require("path");
    var factory = (options) => new IgnoreBase(options);
    factory.default = factory;
    module2.exports = factory;
    function make_array(subject) {
      return Array.isArray(subject) ? subject : [subject];
    }
    var REGEX_TRAILING_SLASH = /(?<=.)\/$/;
    var REGEX_TRAILING_BACKSLASH = /(?<=.)\\$/;
    var REGEX_TRAILING_PATH_SEP = path.sep === "\\" ? REGEX_TRAILING_BACKSLASH : REGEX_TRAILING_SLASH;
    var KEY_IGNORE = typeof Symbol !== "undefined" ? Symbol.for("dockerignore") : "dockerignore";
    function cleanPath(file) {
      return path.normalize(file).replace(REGEX_TRAILING_PATH_SEP, "");
    }
    function toSlash(file) {
      if (path.sep === "/") {
        return file;
      }
      return file.replace(/\\/g, "/");
    }
    function fromSlash(file) {
      if (path.sep === "/") {
        return file;
      }
      return file.replace(/\//g, path.sep);
    }
    var IgnoreBase = class {
      constructor({
        ignorecase = true
      } = {}) {
        this._rules = [];
        this._ignorecase = ignorecase;
        this[KEY_IGNORE] = true;
        this._initCache();
      }
      _initCache() {
        this._cache = {};
      }
      add(pattern) {
        this._added = false;
        if (typeof pattern === "string") {
          pattern = pattern.split(/\r?\n/g);
        }
        make_array(pattern).forEach(this._addPattern, this);
        if (this._added) {
          this._initCache();
        }
        return this;
      }
      addPattern(pattern) {
        return this.add(pattern);
      }
      _addPattern(pattern) {
        if (pattern && pattern[KEY_IGNORE]) {
          this._rules = this._rules.concat(pattern._rules);
          this._added = true;
          return;
        }
        if (this._checkPattern(pattern)) {
          const rule = this._createRule(pattern.trim());
          if (rule !== null) {
            this._added = true;
            this._rules.push(rule);
          }
        }
      }
      _checkPattern(pattern) {
        return pattern && typeof pattern === "string" && pattern.indexOf("#") !== 0 && pattern.trim() !== "";
      }
      filter(paths) {
        return make_array(paths).filter((path2) => this._filter(path2));
      }
      createFilter() {
        return (path2) => this._filter(path2);
      }
      ignores(path2) {
        return !this._filter(path2);
      }
      _createRule(pattern) {
        const origin = pattern;
        let negative = false;
        if (pattern[0] === "!") {
          negative = true;
          pattern = pattern.substring(1).trim();
        }
        if (pattern.length > 0) {
          pattern = cleanPath(pattern);
          pattern = toSlash(pattern);
          if (pattern.length > 1 && pattern[0] === "/") {
            pattern = pattern.slice(1);
          }
        }
        if (negative) {
          pattern = "!" + pattern;
        }
        pattern = pattern.trim();
        if (pattern === "") {
          return null;
        }
        pattern = cleanPath(pattern);
        if (pattern[0] === "!") {
          if (pattern.length === 1) {
            return null;
          }
          negative = true;
          pattern = pattern.substring(1);
        } else {
          negative = false;
        }
        return {
          origin,
          pattern,
          dirs: pattern.split(path.sep),
          negative
        };
      }
      _filter(path2) {
        if (!path2) {
          return false;
        }
        if (path2 in this._cache) {
          return this._cache[path2];
        }
        return this._cache[path2] = this._test(path2);
      }
      _test(file) {
        file = fromSlash(file);
        const parentPath = cleanPath(path.dirname(file));
        const parentPathDirs = parentPath.split(path.sep);
        let matched = false;
        this._rules.forEach((rule) => {
          let match = this._match(file, rule);
          if (!match && parentPath !== ".") {
            if (rule.dirs.includes("**")) {
              for (let i = rule.dirs.filter((x) => x !== "**").length; i <= parentPathDirs.length; i++) {
                match = match || this._match(parentPathDirs.slice(0, i).join(path.sep), rule);
              }
            } else if (rule.dirs.length <= parentPathDirs.length) {
              match = this._match(parentPathDirs.slice(0, rule.dirs.length).join(path.sep), rule);
            }
          }
          if (match) {
            matched = !rule.negative;
          }
        });
        return !matched;
      }
      _match(file, rule) {
        return this._compile(rule).regexp.test(file);
      }
      _compile(rule) {
        if (rule.regexp) {
          return rule;
        }
        let regStr = "^";
        let escapedSlash = path.sep === "\\" ? "\\\\" : path.sep;
        for (let i = 0; i < rule.pattern.length; i++) {
          const ch = rule.pattern[i];
          if (ch === "*") {
            if (rule.pattern[i + 1] === "*") {
              i++;
              if (rule.pattern[i + 1] === path.sep) {
                i++;
              }
              if (rule.pattern[i + 1] === void 0) {
                regStr += ".*";
              } else {
                regStr += `(.*${escapedSlash})?`;
              }
            } else {
              regStr += `[^${escapedSlash}]*`;
            }
          } else if (ch === "?") {
            regStr += `[^${escapedSlash}]`;
          } else if (ch === "." || ch === "$") {
            regStr += `\\${ch}`;
          } else if (ch === "\\") {
            if (path.sep === "\\") {
              regStr += escapedSlash;
              continue;
            }
            if (rule.pattern[i + 1] !== void 0) {
              regStr += "\\" + rule.pattern[i + 1];
              i++;
            } else {
              regStr += "\\";
            }
          } else {
            regStr += ch;
          }
        }
        regStr += "$";
        rule.regexp = new RegExp(regStr, this._ignorecase ? "i" : "");
        return rule;
      }
    };
  }
});

// node_modules/@aws-cdk/core/node_modules/ignore/index.js
var require_ignore2 = __commonJS({
  "node_modules/@aws-cdk/core/node_modules/ignore/index.js"(exports, module2) {
    function makeArray(subject) {
      return Array.isArray(subject) ? subject : [subject];
    }
    var EMPTY = "";
    var SPACE = " ";
    var ESCAPE = "\\";
    var REGEX_TEST_BLANK_LINE = /^\s+$/;
    var REGEX_REPLACE_LEADING_EXCAPED_EXCLAMATION = /^\\!/;
    var REGEX_REPLACE_LEADING_EXCAPED_HASH = /^\\#/;
    var REGEX_SPLITALL_CRLF = /\r?\n/g;
    var REGEX_TEST_INVALID_PATH = /^\.*\/|^\.+$/;
    var SLASH = "/";
    var KEY_IGNORE = typeof Symbol !== "undefined" ? Symbol.for("node-ignore") : "node-ignore";
    var define = (object, key, value) => Object.defineProperty(object, key, { value });
    var REGEX_REGEXP_RANGE = /([0-z])-([0-z])/g;
    var sanitizeRange = (range) => range.replace(REGEX_REGEXP_RANGE, (match, from, to) => from.charCodeAt(0) <= to.charCodeAt(0) ? match : EMPTY);
    var cleanRangeBackSlash = (slashes) => {
      const { length } = slashes;
      return slashes.slice(0, length - length % 2);
    };
    var REPLACERS = [
      [
        /\\?\s+$/,
        (match) => match.indexOf("\\") === 0 ? SPACE : EMPTY
      ],
      [
        /\\\s/g,
        () => SPACE
      ],
      [
        /[\\$.|*+(){^]/g,
        (match) => `\\${match}`
      ],
      [
        /(?!\\)\?/g,
        () => "[^/]"
      ],
      [
        /^\//,
        () => "^"
      ],
      [
        /\//g,
        () => "\\/"
      ],
      [
        /^\^*\\\*\\\*\\\//,
        () => "^(?:.*\\/)?"
      ],
      [
        /^(?=[^^])/,
        function startingReplacer() {
          return !/\/(?!$)/.test(this) ? "(?:^|\\/)" : "^";
        }
      ],
      [
        /\\\/\\\*\\\*(?=\\\/|$)/g,
        (_, index, str) => index + 6 < str.length ? "(?:\\/[^\\/]+)*" : "\\/.+"
      ],
      [
        /(^|[^\\]+)\\\*(?=.+)/g,
        (_, p1) => `${p1}[^\\/]*`
      ],
      [
        /\\\\\\(?=[$.|*+(){^])/g,
        () => ESCAPE
      ],
      [
        /\\\\/g,
        () => ESCAPE
      ],
      [
        /(\\)?\[([^\]/]*?)(\\*)($|\])/g,
        (match, leadEscape, range, endEscape, close) => leadEscape === ESCAPE ? `\\[${range}${cleanRangeBackSlash(endEscape)}${close}` : close === "]" ? endEscape.length % 2 === 0 ? `[${sanitizeRange(range)}${endEscape}]` : "[]" : "[]"
      ],
      [
        /(?:[^*])$/,
        (match) => /\/$/.test(match) ? `${match}$` : `${match}(?=$|\\/$)`
      ],
      [
        /(\^|\\\/)?\\\*$/,
        (_, p1) => {
          const prefix = p1 ? `${p1}[^/]+` : "[^/]*";
          return `${prefix}(?=$|\\/$)`;
        }
      ]
    ];
    var regexCache = Object.create(null);
    var makeRegex = (pattern, negative, ignorecase) => {
      const r = regexCache[pattern];
      if (r) {
        return r;
      }
      const source = REPLACERS.reduce((prev, current) => prev.replace(current[0], current[1].bind(pattern)), pattern);
      return regexCache[pattern] = ignorecase ? new RegExp(source, "i") : new RegExp(source);
    };
    var isString = (subject) => typeof subject === "string";
    var checkPattern = (pattern) => pattern && isString(pattern) && !REGEX_TEST_BLANK_LINE.test(pattern) && pattern.indexOf("#") !== 0;
    var splitPattern = (pattern) => pattern.split(REGEX_SPLITALL_CRLF);
    var IgnoreRule = class {
      constructor(origin, pattern, negative, regex) {
        this.origin = origin;
        this.pattern = pattern;
        this.negative = negative;
        this.regex = regex;
      }
    };
    var createRule = (pattern, ignorecase) => {
      const origin = pattern;
      let negative = false;
      if (pattern.indexOf("!") === 0) {
        negative = true;
        pattern = pattern.substr(1);
      }
      pattern = pattern.replace(REGEX_REPLACE_LEADING_EXCAPED_EXCLAMATION, "!").replace(REGEX_REPLACE_LEADING_EXCAPED_HASH, "#");
      const regex = makeRegex(pattern, negative, ignorecase);
      return new IgnoreRule(origin, pattern, negative, regex);
    };
    var throwError = (message, Ctor) => {
      throw new Ctor(message);
    };
    var checkPath = (path, originalPath, doThrow) => {
      if (!isString(path)) {
        return doThrow(`path must be a string, but got \`${originalPath}\``, TypeError);
      }
      if (!path) {
        return doThrow(`path must not be empty`, TypeError);
      }
      if (checkPath.isNotRelative(path)) {
        const r = "`path.relative()`d";
        return doThrow(`path should be a ${r} string, but got "${originalPath}"`, RangeError);
      }
      return true;
    };
    var isNotRelative = (path) => REGEX_TEST_INVALID_PATH.test(path);
    checkPath.isNotRelative = isNotRelative;
    checkPath.convert = (p) => p;
    var Ignore = class {
      constructor({
        ignorecase = true
      } = {}) {
        this._rules = [];
        this._ignorecase = ignorecase;
        define(this, KEY_IGNORE, true);
        this._initCache();
      }
      _initCache() {
        this._ignoreCache = Object.create(null);
        this._testCache = Object.create(null);
      }
      _addPattern(pattern) {
        if (pattern && pattern[KEY_IGNORE]) {
          this._rules = this._rules.concat(pattern._rules);
          this._added = true;
          return;
        }
        if (checkPattern(pattern)) {
          const rule = createRule(pattern, this._ignorecase);
          this._added = true;
          this._rules.push(rule);
        }
      }
      add(pattern) {
        this._added = false;
        makeArray(isString(pattern) ? splitPattern(pattern) : pattern).forEach(this._addPattern, this);
        if (this._added) {
          this._initCache();
        }
        return this;
      }
      addPattern(pattern) {
        return this.add(pattern);
      }
      _testOne(path, checkUnignored) {
        let ignored = false;
        let unignored = false;
        this._rules.forEach((rule) => {
          const { negative } = rule;
          if (unignored === negative && ignored !== unignored || negative && !ignored && !unignored && !checkUnignored) {
            return;
          }
          const matched = rule.regex.test(path);
          if (matched) {
            ignored = !negative;
            unignored = negative;
          }
        });
        return {
          ignored,
          unignored
        };
      }
      _test(originalPath, cache, checkUnignored, slices) {
        const path = originalPath && checkPath.convert(originalPath);
        checkPath(path, originalPath, throwError);
        return this._t(path, cache, checkUnignored, slices);
      }
      _t(path, cache, checkUnignored, slices) {
        if (path in cache) {
          return cache[path];
        }
        if (!slices) {
          slices = path.split(SLASH);
        }
        slices.pop();
        if (!slices.length) {
          return cache[path] = this._testOne(path, checkUnignored);
        }
        const parent = this._t(slices.join(SLASH) + SLASH, cache, checkUnignored, slices);
        return cache[path] = parent.ignored ? parent : this._testOne(path, checkUnignored);
      }
      ignores(path) {
        return this._test(path, this._ignoreCache, false).ignored;
      }
      createFilter() {
        return (path) => !this.ignores(path);
      }
      filter(paths) {
        return makeArray(paths).filter(this.createFilter());
      }
      test(path) {
        return this._test(path, this._testCache, true);
      }
    };
    var factory = (options) => new Ignore(options);
    var returnFalse = () => false;
    var isPathValid = (path) => checkPath(path && checkPath.convert(path), path, returnFalse);
    factory.isPathValid = isPathValid;
    factory.default = factory;
    module2.exports = factory;
    if (typeof process !== "undefined" && (process.env && process.env.IGNORE_TEST_WIN32 || process.platform === "win32")) {
      const makePosix = (str) => /^\\\\\?\\/.test(str) || /["<>|\u0000-\u001F]+/u.test(str) ? str : str.replace(/\\/g, "/");
      checkPath.convert = makePosix;
      const REGIX_IS_WINDOWS_PATH_ABSOLUTE = /^[a-z]:\//i;
      checkPath.isNotRelative = (path) => REGIX_IS_WINDOWS_PATH_ABSOLUTE.test(path) || isNotRelative(path);
    }
  }
});

// node_modules/@aws-cdk/core/lib/fs/options.js
var require_options = __commonJS({
  "node_modules/@aws-cdk/core/lib/fs/options.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.IgnoreMode = exports.SymlinkFollowMode = void 0;
    var SymlinkFollowMode;
    (function(SymlinkFollowMode2) {
      SymlinkFollowMode2["NEVER"] = "never";
      SymlinkFollowMode2["ALWAYS"] = "always";
      SymlinkFollowMode2["EXTERNAL"] = "external";
      SymlinkFollowMode2["BLOCK_EXTERNAL"] = "internal-only";
    })(SymlinkFollowMode = exports.SymlinkFollowMode || (exports.SymlinkFollowMode = {}));
    var IgnoreMode;
    (function(IgnoreMode2) {
      IgnoreMode2["GLOB"] = "glob";
      IgnoreMode2["GIT"] = "git";
      IgnoreMode2["DOCKER"] = "docker";
    })(IgnoreMode = exports.IgnoreMode || (exports.IgnoreMode = {}));
  }
});

// node_modules/@aws-cdk/core/lib/fs/ignore.js
var require_ignore3 = __commonJS({
  "node_modules/@aws-cdk/core/lib/fs/ignore.js"(exports) {
    "use strict";
    var _a;
    var _b;
    var _c;
    var _d;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DockerIgnoreStrategy = exports.GitIgnoreStrategy = exports.GlobIgnoreStrategy = exports.IgnoreStrategy = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var path = require("path");
    var dockerignore_1 = require_ignore();
    var ignore_1 = require_ignore2();
    var minimatch = require_minimatch();
    var options_1 = require_options();
    var IgnoreStrategy = class {
      static glob(absoluteRootPath, patterns) {
        return new GlobIgnoreStrategy(absoluteRootPath, patterns);
      }
      static git(absoluteRootPath, patterns) {
        return new GitIgnoreStrategy(absoluteRootPath, patterns);
      }
      static docker(absoluteRootPath, patterns) {
        return new DockerIgnoreStrategy(absoluteRootPath, patterns);
      }
      static fromCopyOptions(options, absoluteRootPath) {
        const ignoreMode = options.ignoreMode || options_1.IgnoreMode.GLOB;
        const exclude = options.exclude || [];
        switch (ignoreMode) {
          case options_1.IgnoreMode.GLOB:
            return this.glob(absoluteRootPath, exclude);
          case options_1.IgnoreMode.GIT:
            return this.git(absoluteRootPath, exclude);
          case options_1.IgnoreMode.DOCKER:
            return this.docker(absoluteRootPath, exclude);
        }
      }
    };
    exports.IgnoreStrategy = IgnoreStrategy;
    _a = JSII_RTTI_SYMBOL_1;
    IgnoreStrategy[_a] = { fqn: "@aws-cdk/core.IgnoreStrategy", version: "1.128.0" };
    var GlobIgnoreStrategy = class extends IgnoreStrategy {
      constructor(absoluteRootPath, patterns) {
        super();
        if (!path.isAbsolute(absoluteRootPath)) {
          throw new Error("GlobIgnoreStrategy expects an absolute file path");
        }
        this.absoluteRootPath = absoluteRootPath;
        this.patterns = patterns;
      }
      add(pattern) {
        this.patterns.push(pattern);
      }
      ignores(absoluteFilePath) {
        if (!path.isAbsolute(absoluteFilePath)) {
          throw new Error("GlobIgnoreStrategy.ignores() expects an absolute path");
        }
        let relativePath = path.relative(this.absoluteRootPath, absoluteFilePath);
        let excludeOutput = false;
        for (const pattern of this.patterns) {
          const negate = pattern.startsWith("!");
          const match = minimatch(relativePath, pattern, { matchBase: true, flipNegate: true });
          if (!negate && match) {
            excludeOutput = true;
          }
          if (negate && match) {
            excludeOutput = false;
          }
        }
        return excludeOutput;
      }
    };
    exports.GlobIgnoreStrategy = GlobIgnoreStrategy;
    _b = JSII_RTTI_SYMBOL_1;
    GlobIgnoreStrategy[_b] = { fqn: "@aws-cdk/core.GlobIgnoreStrategy", version: "1.128.0" };
    var GitIgnoreStrategy = class extends IgnoreStrategy {
      constructor(absoluteRootPath, patterns) {
        super();
        if (!path.isAbsolute(absoluteRootPath)) {
          throw new Error("GitIgnoreStrategy expects an absolute file path");
        }
        this.absoluteRootPath = absoluteRootPath;
        this.ignore = ignore_1.default().add(patterns);
      }
      add(pattern) {
        this.ignore.add(pattern);
      }
      ignores(absoluteFilePath) {
        if (!path.isAbsolute(absoluteFilePath)) {
          throw new Error("GitIgnoreStrategy.ignores() expects an absolute path");
        }
        let relativePath = path.relative(this.absoluteRootPath, absoluteFilePath);
        return this.ignore.ignores(relativePath);
      }
    };
    exports.GitIgnoreStrategy = GitIgnoreStrategy;
    _c = JSII_RTTI_SYMBOL_1;
    GitIgnoreStrategy[_c] = { fqn: "@aws-cdk/core.GitIgnoreStrategy", version: "1.128.0" };
    var DockerIgnoreStrategy = class extends IgnoreStrategy {
      constructor(absoluteRootPath, patterns) {
        super();
        if (!path.isAbsolute(absoluteRootPath)) {
          throw new Error("DockerIgnoreStrategy expects an absolute file path");
        }
        this.absoluteRootPath = absoluteRootPath;
        this.ignore = dockerignore_1.default().add(patterns);
      }
      add(pattern) {
        this.ignore.add(pattern);
      }
      ignores(absoluteFilePath) {
        if (!path.isAbsolute(absoluteFilePath)) {
          throw new Error("DockerIgnoreStrategy.ignores() expects an absolute path");
        }
        let relativePath = path.relative(this.absoluteRootPath, absoluteFilePath);
        return this.ignore.ignores(relativePath);
      }
    };
    exports.DockerIgnoreStrategy = DockerIgnoreStrategy;
    _d = JSII_RTTI_SYMBOL_1;
    DockerIgnoreStrategy[_d] = { fqn: "@aws-cdk/core.DockerIgnoreStrategy", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/fs/utils.js
var require_utils2 = __commonJS({
  "node_modules/@aws-cdk/core/lib/fs/utils.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.shouldFollow = void 0;
    var fs = require("fs");
    var path = require("path");
    var options_1 = require_options();
    function shouldFollow(mode, sourceRoot, realPath) {
      switch (mode) {
        case options_1.SymlinkFollowMode.ALWAYS:
          return fs.existsSync(realPath);
        case options_1.SymlinkFollowMode.EXTERNAL:
          return !_isInternal() && fs.existsSync(realPath);
        case options_1.SymlinkFollowMode.BLOCK_EXTERNAL:
          return _isInternal() && fs.existsSync(realPath);
        case options_1.SymlinkFollowMode.NEVER:
          return false;
        default:
          throw new Error(`Unsupported FollowMode: ${mode}`);
      }
      function _isInternal() {
        return path.resolve(realPath).startsWith(path.resolve(sourceRoot));
      }
    }
    exports.shouldFollow = shouldFollow;
  }
});

// node_modules/@aws-cdk/core/lib/fs/copy.js
var require_copy3 = __commonJS({
  "node_modules/@aws-cdk/core/lib/fs/copy.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.copyDirectory = void 0;
    var fs = require("fs");
    var path = require("path");
    var ignore_1 = require_ignore3();
    var options_1 = require_options();
    var utils_1 = require_utils2();
    function copyDirectory(srcDir, destDir, options = {}, rootDir) {
      var _a;
      const follow = (_a = options.follow) !== null && _a !== void 0 ? _a : options_1.SymlinkFollowMode.EXTERNAL;
      rootDir = rootDir || srcDir;
      const ignoreStrategy = ignore_1.IgnoreStrategy.fromCopyOptions(options, rootDir);
      if (!fs.statSync(srcDir).isDirectory()) {
        throw new Error(`${srcDir} is not a directory`);
      }
      const files = fs.readdirSync(srcDir);
      for (const file of files) {
        const sourceFilePath = path.join(srcDir, file);
        if (ignoreStrategy.ignores(sourceFilePath)) {
          continue;
        }
        const destFilePath = path.join(destDir, file);
        let stat = follow === options_1.SymlinkFollowMode.ALWAYS ? fs.statSync(sourceFilePath) : fs.lstatSync(sourceFilePath);
        if (stat && stat.isSymbolicLink()) {
          const target = fs.readlinkSync(sourceFilePath);
          const targetPath = path.normalize(path.resolve(srcDir, target));
          if (utils_1.shouldFollow(follow, rootDir, targetPath)) {
            stat = fs.statSync(sourceFilePath);
          } else {
            fs.symlinkSync(target, destFilePath);
            stat = void 0;
          }
        }
        if (stat && stat.isDirectory()) {
          fs.mkdirSync(destFilePath);
          copyDirectory(sourceFilePath, destFilePath, options, rootDir);
          stat = void 0;
        }
        if (stat && stat.isFile()) {
          fs.copyFileSync(sourceFilePath, destFilePath);
          stat = void 0;
        }
      }
    }
    exports.copyDirectory = copyDirectory;
  }
});

// node_modules/@aws-cdk/core/lib/fs/fingerprint.js
var require_fingerprint = __commonJS({
  "node_modules/@aws-cdk/core/lib/fs/fingerprint.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.contentFingerprint = exports.fingerprint = void 0;
    var crypto = require("crypto");
    var fs = require("fs");
    var path = require("path");
    var ignore_1 = require_ignore3();
    var options_1 = require_options();
    var utils_1 = require_utils2();
    var BUFFER_SIZE = 8 * 1024;
    var CTRL_SOH = "";
    var CTRL_SOT = "";
    var CTRL_ETX = "";
    var CR = "\r";
    var LF = "\n";
    var CRLF = `${CR}${LF}`;
    function fingerprint(fileOrDirectory, options = {}) {
      const hash = crypto.createHash("sha256");
      _hashField(hash, "options.extra", options.extraHash || "");
      const follow = options.follow || options_1.SymlinkFollowMode.EXTERNAL;
      _hashField(hash, "options.follow", follow);
      fileOrDirectory = fs.realpathSync(fileOrDirectory);
      const isDir = fs.statSync(fileOrDirectory).isDirectory();
      const rootDirectory = isDir ? fileOrDirectory : path.dirname(fileOrDirectory);
      const ignoreMode = options.ignoreMode || options_1.IgnoreMode.GLOB;
      if (ignoreMode != options_1.IgnoreMode.GLOB) {
        _hashField(hash, "options.ignoreMode", ignoreMode);
      }
      const ignoreStrategy = ignore_1.IgnoreStrategy.fromCopyOptions(options, fileOrDirectory);
      _processFileOrDirectory(fileOrDirectory, isDir);
      return hash.digest("hex");
      function _processFileOrDirectory(symbolicPath, isRootDir = false, realPath = symbolicPath) {
        if (!isRootDir && ignoreStrategy.ignores(symbolicPath)) {
          return;
        }
        const stat = fs.lstatSync(realPath);
        const hashComponent = path.relative(fileOrDirectory, symbolicPath).replace(/\\/g, "/");
        if (stat.isSymbolicLink()) {
          const linkTarget = fs.readlinkSync(realPath);
          const resolvedLinkTarget = path.resolve(path.dirname(realPath), linkTarget);
          if (utils_1.shouldFollow(follow, rootDirectory, resolvedLinkTarget)) {
            _processFileOrDirectory(symbolicPath, false, resolvedLinkTarget);
          } else {
            _hashField(hash, `link:${hashComponent}`, linkTarget);
          }
        } else if (stat.isFile()) {
          _hashField(hash, `file:${hashComponent}`, contentFingerprint(realPath));
        } else if (stat.isDirectory()) {
          for (const item of fs.readdirSync(realPath).sort()) {
            _processFileOrDirectory(path.join(symbolicPath, item), false, path.join(realPath, item));
          }
        } else {
          throw new Error(`Unable to hash ${symbolicPath}: it is neither a file nor a directory`);
        }
      }
    }
    exports.fingerprint = fingerprint;
    function contentFingerprint(file) {
      const hash = crypto.createHash("sha256");
      const buffer = Buffer.alloc(BUFFER_SIZE);
      const fd = fs.openSync(file, fs.constants.O_DSYNC | fs.constants.O_RDONLY | fs.constants.O_SYNC);
      let size = 0;
      let isBinary = false;
      let lastStr = "";
      let read = 0;
      try {
        while ((read = fs.readSync(fd, buffer, 0, BUFFER_SIZE, null)) !== 0) {
          const slicedBuffer = buffer.slice(0, read);
          if (size === 0) {
            isBinary = slicedBuffer.indexOf(0) !== -1;
          }
          let dataBuffer = slicedBuffer;
          if (!isBinary) {
            const str = buffer.slice(0, read).toString();
            if (new RegExp(`${CR}$`).test(str)) {
              lastStr += str;
              continue;
            }
            const data = lastStr + str;
            const normalizedData = data.replace(new RegExp(CRLF, "g"), LF);
            dataBuffer = Buffer.from(normalizedData);
            lastStr = "";
          }
          size += dataBuffer.length;
          hash.update(dataBuffer);
        }
        if (lastStr) {
          hash.update(Buffer.from(lastStr));
        }
      } finally {
        fs.closeSync(fd);
      }
      return `${size}:${hash.digest("hex")}`;
    }
    exports.contentFingerprint = contentFingerprint;
    function _hashField(hash, header, value) {
      hash.update(CTRL_SOH).update(header).update(CTRL_SOT).update(value).update(CTRL_ETX);
    }
  }
});

// node_modules/@aws-cdk/core/lib/fs/index.js
var require_fs2 = __commonJS({
  "node_modules/@aws-cdk/core/lib/fs/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.FileSystem = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var os = require("os");
    var path = require("path");
    var copy_1 = require_copy3();
    var fingerprint_1 = require_fingerprint();
    __exportStar(require_ignore3(), exports);
    __exportStar(require_options(), exports);
    var FileSystem = class {
      static copyDirectory(srcDir, destDir, options = {}, rootDir) {
        return copy_1.copyDirectory(srcDir, destDir, options, rootDir);
      }
      static fingerprint(fileOrDirectory, options = {}) {
        return fingerprint_1.fingerprint(fileOrDirectory, options);
      }
      static isEmpty(dir) {
        return fs.readdirSync(dir).length === 0;
      }
      static get tmpdir() {
        if (FileSystem._tmpdir) {
          return FileSystem._tmpdir;
        }
        FileSystem._tmpdir = fs.realpathSync(os.tmpdir());
        return FileSystem._tmpdir;
      }
      static mkdtemp(prefix) {
        return fs.mkdtempSync(path.join(FileSystem.tmpdir, prefix));
      }
    };
    exports.FileSystem = FileSystem;
    _a = JSII_RTTI_SYMBOL_1;
    FileSystem[_a] = { fqn: "@aws-cdk/core.FileSystem", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/bundling.js
var require_bundling = __commonJS({
  "node_modules/@aws-cdk/core/lib/bundling.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DockerVolumeConsistency = exports.DockerImage = exports.BundlingDockerImage = exports.BundlingOutput = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var child_process_1 = require("child_process");
    var crypto = require("crypto");
    var path_1 = require("path");
    var fs_1 = require_fs2();
    var BundlingOutput;
    (function(BundlingOutput2) {
      BundlingOutput2["ARCHIVED"] = "archived";
      BundlingOutput2["NOT_ARCHIVED"] = "not-archived";
      BundlingOutput2["AUTO_DISCOVER"] = "auto-discover";
    })(BundlingOutput = exports.BundlingOutput || (exports.BundlingOutput = {}));
    var BundlingDockerImage = class {
      constructor(image, _imageHash) {
        this.image = image;
        this._imageHash = _imageHash;
      }
      static fromRegistry(image) {
        return new DockerImage(image);
      }
      static fromAsset(path, options = {}) {
        return DockerImage.fromBuild(path, options);
      }
      toJSON() {
        var _c;
        return (_c = this._imageHash) !== null && _c !== void 0 ? _c : this.image;
      }
      run(options = {}) {
        var _c, _d;
        const volumes = options.volumes || [];
        const environment = options.environment || {};
        const entrypoint = ((_c = options.entrypoint) === null || _c === void 0 ? void 0 : _c[0]) || null;
        const command = [
          ...((_d = options.entrypoint) === null || _d === void 0 ? void 0 : _d[1]) ? [...options.entrypoint.slice(1)] : [],
          ...options.command ? [...options.command] : []
        ];
        const dockerArgs = [
          "run",
          "--rm",
          ...options.securityOpt ? ["--security-opt", options.securityOpt] : [],
          ...options.user ? ["-u", options.user] : [],
          ...flatten(volumes.map((v) => {
            var _c2;
            return ["-v", `${v.hostPath}:${v.containerPath}:${isSeLinux() ? "z," : ""}${(_c2 = v.consistency) !== null && _c2 !== void 0 ? _c2 : DockerVolumeConsistency.DELEGATED}`];
          })),
          ...flatten(Object.entries(environment).map(([k, v]) => ["--env", `${k}=${v}`])),
          ...options.workingDirectory ? ["-w", options.workingDirectory] : [],
          ...entrypoint ? ["--entrypoint", entrypoint] : [],
          this.image,
          ...command
        ];
        dockerExec(dockerArgs);
      }
      cp(imagePath, outputPath) {
        const { stdout } = dockerExec(["create", this.image], {});
        const match = stdout.toString().match(/([0-9a-f]{16,})/);
        if (!match) {
          throw new Error("Failed to extract container ID from Docker create output");
        }
        const containerId = match[1];
        const containerPath = `${containerId}:${imagePath}`;
        const destPath = outputPath !== null && outputPath !== void 0 ? outputPath : fs_1.FileSystem.mkdtemp("cdk-docker-cp-");
        try {
          dockerExec(["cp", containerPath, destPath]);
          return destPath;
        } catch (err) {
          throw new Error(`Failed to copy files from ${containerPath} to ${destPath}: ${err}`);
        } finally {
          dockerExec(["rm", "-v", containerId]);
        }
      }
    };
    exports.BundlingDockerImage = BundlingDockerImage;
    _a = JSII_RTTI_SYMBOL_1;
    BundlingDockerImage[_a] = { fqn: "@aws-cdk/core.BundlingDockerImage", version: "1.128.0" };
    var DockerImage = class extends BundlingDockerImage {
      constructor(image, _imageHash) {
        super(image, _imageHash);
        this.image = image;
      }
      static fromBuild(path, options = {}) {
        const buildArgs = options.buildArgs || {};
        if (options.file && path_1.isAbsolute(options.file)) {
          throw new Error(`"file" must be relative to the docker build directory. Got ${options.file}`);
        }
        const input = JSON.stringify(__spreadValues({ path }, options));
        const tagHash = crypto.createHash("sha256").update(input).digest("hex");
        const tag = `cdk-${tagHash}`;
        const dockerArgs = [
          "build",
          "-t",
          tag,
          ...options.file ? ["-f", path_1.join(path, options.file)] : [],
          ...options.platform ? ["--platform", options.platform] : [],
          ...flatten(Object.entries(buildArgs).map(([k, v]) => ["--build-arg", `${k}=${v}`])),
          path
        ];
        dockerExec(dockerArgs);
        const hash = fs_1.FileSystem.fingerprint(path, { extraHash: JSON.stringify(options) });
        return new DockerImage(tag, hash);
      }
      static fromRegistry(image) {
        return new DockerImage(image);
      }
      toJSON() {
        return super.toJSON();
      }
      run(options = {}) {
        return super.run(options);
      }
      cp(imagePath, outputPath) {
        return super.cp(imagePath, outputPath);
      }
    };
    exports.DockerImage = DockerImage;
    _b = JSII_RTTI_SYMBOL_1;
    DockerImage[_b] = { fqn: "@aws-cdk/core.DockerImage", version: "1.128.0" };
    var DockerVolumeConsistency;
    (function(DockerVolumeConsistency2) {
      DockerVolumeConsistency2["CONSISTENT"] = "consistent";
      DockerVolumeConsistency2["DELEGATED"] = "delegated";
      DockerVolumeConsistency2["CACHED"] = "cached";
    })(DockerVolumeConsistency = exports.DockerVolumeConsistency || (exports.DockerVolumeConsistency = {}));
    function flatten(x) {
      return Array.prototype.concat([], ...x);
    }
    function dockerExec(args, options) {
      var _c, _d, _e;
      const prog = (_c = process.env.CDK_DOCKER) !== null && _c !== void 0 ? _c : "docker";
      const proc = child_process_1.spawnSync(prog, args, options !== null && options !== void 0 ? options : {
        stdio: [
          "ignore",
          process.stderr,
          "inherit"
        ]
      });
      if (proc.error) {
        throw proc.error;
      }
      if (proc.status !== 0) {
        if (proc.stdout || proc.stderr) {
          throw new Error(`[Status ${proc.status}] stdout: ${(_d = proc.stdout) === null || _d === void 0 ? void 0 : _d.toString().trim()}


stderr: ${(_e = proc.stderr) === null || _e === void 0 ? void 0 : _e.toString().trim()}`);
        }
        throw new Error(`${prog} exited with status ${proc.status}`);
      }
      return proc;
    }
    function isSeLinux() {
      if (process.platform != "linux") {
        return false;
      }
      const prog = "selinuxenabled";
      const proc = child_process_1.spawnSync(prog, [], {
        stdio: [
          "pipe",
          process.stderr,
          "inherit"
        ]
      });
      if (proc.error) {
        return false;
      }
      if (proc.status == 0) {
        return true;
      } else {
        return false;
      }
    }
  }
});

// node_modules/@aws-cdk/core/lib/private/cache.js
var require_cache = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/cache.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Cache = void 0;
    var Cache = class {
      constructor() {
        this.cache = /* @__PURE__ */ new Map();
      }
      clear() {
        this.cache.clear();
      }
      obtain(cacheKey, calcFn) {
        let value = this.cache.get(cacheKey);
        if (value) {
          return value;
        }
        value = calcFn();
        this.cache.set(cacheKey, value);
        return value;
      }
    };
    exports.Cache = Cache;
  }
});

// node_modules/@aws-cdk/core/lib/asset-staging.js
var require_asset_staging = __commonJS({
  "node_modules/@aws-cdk/core/lib/asset-staging.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.AssetStaging = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var crypto = require("crypto");
    var os = require("os");
    var path = require("path");
    var cxapi = require_lib5();
    var fs = require_lib6();
    var minimatch = require_minimatch();
    var assets_1 = require_assets3();
    var bundling_1 = require_bundling();
    var fs_1 = require_fs2();
    var names_1 = require_names();
    var cache_1 = require_cache();
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var construct_compat_1 = require_construct_compat();
    var ARCHIVE_EXTENSIONS = [".zip", ".jar"];
    var AssetStaging = class extends construct_compat_1.Construct {
      constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.sourcePath = path.resolve(props.sourcePath);
        this.fingerprintOptions = props;
        if (!fs.existsSync(this.sourcePath)) {
          throw new Error(`Cannot find asset at ${this.sourcePath}`);
        }
        this.sourceStats = fs.statSync(this.sourcePath);
        const outdir = (_b = stage_1.Stage.of(this)) === null || _b === void 0 ? void 0 : _b.assetOutdir;
        if (!outdir) {
          throw new Error('unable to determine cloud assembly asset output directory. Assets must be defined indirectly within a "Stage" or an "App" scope');
        }
        this.assetOutdir = outdir;
        this.customSourceFingerprint = props.assetHash;
        this.hashType = determineHashType(props.assetHashType, this.customSourceFingerprint);
        let stageThisAsset;
        let skip = false;
        if (props.bundling) {
          const bundlingStacks = (_c = this.node.tryGetContext(cxapi.BUNDLING_STACKS)) !== null && _c !== void 0 ? _c : ["*"];
          skip = !bundlingStacks.find((pattern) => minimatch(stack_1.Stack.of(this).stackName, pattern));
          const bundling = props.bundling;
          stageThisAsset = () => this.stageByBundling(bundling, skip);
        } else {
          stageThisAsset = () => this.stageByCopying();
        }
        this.cacheKey = calculateCacheKey({
          outdir: this.assetOutdir,
          sourcePath: path.resolve(props.sourcePath),
          bundling: props.bundling,
          assetHashType: this.hashType,
          customFingerprint: this.customSourceFingerprint,
          extraHash: props.extraHash,
          exclude: props.exclude,
          ignoreMode: props.ignoreMode,
          skip
        });
        const staged = AssetStaging.assetCache.obtain(this.cacheKey, stageThisAsset);
        this.stagedPath = staged.stagedPath;
        this.absoluteStagedPath = staged.stagedPath;
        this.assetHash = staged.assetHash;
        this.packaging = staged.packaging;
        this.isArchive = staged.isArchive;
      }
      static clearAssetHashCache() {
        this.assetCache.clear();
      }
      get sourceHash() {
        return this.assetHash;
      }
      relativeStagedPath(stack) {
        var _b;
        const asmManifestDir = (_b = stage_1.Stage.of(stack)) === null || _b === void 0 ? void 0 : _b.outdir;
        if (!asmManifestDir) {
          return this.stagedPath;
        }
        const isOutsideAssetDir = path.relative(this.assetOutdir, this.stagedPath).startsWith("..");
        if (isOutsideAssetDir || this.stagingDisabled) {
          return this.stagedPath;
        }
        return path.relative(asmManifestDir, this.stagedPath);
      }
      stageByCopying() {
        const assetHash = this.calculateHash(this.hashType);
        const stagedPath = this.stagingDisabled ? this.sourcePath : path.resolve(this.assetOutdir, renderAssetFilename(assetHash, path.extname(this.sourcePath)));
        if (!this.sourceStats.isDirectory() && !this.sourceStats.isFile()) {
          throw new Error(`Asset ${this.sourcePath} is expected to be either a directory or a regular file`);
        }
        this.stageAsset(this.sourcePath, stagedPath, "copy");
        return {
          assetHash,
          stagedPath,
          packaging: this.sourceStats.isDirectory() ? assets_1.FileAssetPackaging.ZIP_DIRECTORY : assets_1.FileAssetPackaging.FILE,
          isArchive: this.sourceStats.isDirectory() || ARCHIVE_EXTENSIONS.includes(path.extname(this.sourcePath).toLowerCase())
        };
      }
      stageByBundling(bundling, skip) {
        var _b;
        if (!this.sourceStats.isDirectory()) {
          throw new Error(`Asset ${this.sourcePath} is expected to be a directory when bundling`);
        }
        if (skip) {
          let hashType = this.hashType;
          if (hashType === assets_1.AssetHashType.OUTPUT || hashType === assets_1.AssetHashType.BUNDLE) {
            this.customSourceFingerprint = names_1.Names.uniqueId(this);
            hashType = assets_1.AssetHashType.CUSTOM;
          }
          return {
            assetHash: this.calculateHash(hashType, bundling),
            stagedPath: this.sourcePath,
            packaging: assets_1.FileAssetPackaging.ZIP_DIRECTORY,
            isArchive: true
          };
        }
        let assetHash = this.hashType === assets_1.AssetHashType.SOURCE || this.hashType === assets_1.AssetHashType.CUSTOM ? this.calculateHash(this.hashType, bundling) : void 0;
        const bundleDir = this.determineBundleDir(this.assetOutdir, assetHash);
        this.bundle(bundling, bundleDir);
        const bundlingOutputType = (_b = bundling.outputType) !== null && _b !== void 0 ? _b : bundling_1.BundlingOutput.AUTO_DISCOVER;
        const bundledAsset = determineBundledAsset(bundleDir, bundlingOutputType);
        assetHash = assetHash !== null && assetHash !== void 0 ? assetHash : this.calculateHash(this.hashType, bundling, bundledAsset.path);
        const stagedPath = path.resolve(this.assetOutdir, renderAssetFilename(assetHash, bundledAsset.extension));
        this.stageAsset(bundledAsset.path, stagedPath, "move");
        if (bundledAsset.packaging === assets_1.FileAssetPackaging.FILE) {
          fs.closeSync(fs.openSync(bundledAsset.path, "w"));
        }
        return {
          assetHash,
          stagedPath,
          packaging: bundledAsset.packaging,
          isArchive: true
        };
      }
      get stagingDisabled() {
        return !!this.node.tryGetContext(cxapi.DISABLE_ASSET_STAGING_CONTEXT);
      }
      stageAsset(sourcePath, targetPath, style) {
        const isAlreadyStaged = fs.existsSync(targetPath);
        if (isAlreadyStaged) {
          if (style === "move" && sourcePath !== targetPath) {
            fs.removeSync(sourcePath);
          }
          return;
        }
        if (style == "move") {
          fs.renameSync(sourcePath, targetPath);
          return;
        }
        if (this.sourceStats.isFile()) {
          fs.copyFileSync(sourcePath, targetPath);
        } else if (this.sourceStats.isDirectory()) {
          fs.mkdirSync(targetPath);
          fs_1.FileSystem.copyDirectory(sourcePath, targetPath, this.fingerprintOptions);
        } else {
          throw new Error(`Unknown file type: ${sourcePath}`);
        }
      }
      determineBundleDir(outdir, sourceHash) {
        if (sourceHash) {
          return path.resolve(outdir, renderAssetFilename(sourceHash));
        }
        return path.resolve(outdir, `bundling-temp-${this.cacheKey}`);
      }
      bundle(options, bundleDir) {
        var _b, _c, _d, _e;
        if (fs.existsSync(bundleDir)) {
          return;
        }
        fs.ensureDirSync(bundleDir);
        fs.chmodSync(bundleDir, 511);
        const volumes = [
          {
            hostPath: this.sourcePath,
            containerPath: AssetStaging.BUNDLING_INPUT_DIR
          },
          {
            hostPath: bundleDir,
            containerPath: AssetStaging.BUNDLING_OUTPUT_DIR
          },
          ...(_b = options.volumes) !== null && _b !== void 0 ? _b : []
        ];
        let localBundling;
        try {
          process.stderr.write(`Bundling asset ${this.node.path}...
`);
          localBundling = (_c = options.local) === null || _c === void 0 ? void 0 : _c.tryBundle(bundleDir, options);
          if (!localBundling) {
            let user;
            if (options.user) {
              user = options.user;
            } else {
              const userInfo = os.userInfo();
              user = userInfo.uid !== -1 ? `${userInfo.uid}:${userInfo.gid}` : "1000:1000";
            }
            options.image.run({
              command: options.command,
              user,
              volumes,
              environment: options.environment,
              workingDirectory: (_d = options.workingDirectory) !== null && _d !== void 0 ? _d : AssetStaging.BUNDLING_INPUT_DIR,
              securityOpt: (_e = options.securityOpt) !== null && _e !== void 0 ? _e : ""
            });
          }
        } catch (err) {
          const bundleErrorDir = bundleDir + "-error";
          if (fs.existsSync(bundleErrorDir)) {
            fs.removeSync(bundleErrorDir);
          }
          fs.renameSync(bundleDir, bundleErrorDir);
          throw new Error(`Failed to bundle asset ${this.node.path}, bundle output is located at ${bundleErrorDir}: ${err}`);
        }
        if (fs_1.FileSystem.isEmpty(bundleDir)) {
          const outputDir = localBundling ? bundleDir : AssetStaging.BUNDLING_OUTPUT_DIR;
          throw new Error(`Bundling did not produce any output. Check that content is written to ${outputDir}.`);
        }
      }
      calculateHash(hashType, bundling, outputDir) {
        var _b;
        if (hashType == assets_1.AssetHashType.CUSTOM || hashType == assets_1.AssetHashType.SOURCE && bundling) {
          const hash = crypto.createHash("sha256");
          hash.update((_b = this.customSourceFingerprint) !== null && _b !== void 0 ? _b : fs_1.FileSystem.fingerprint(this.sourcePath, this.fingerprintOptions));
          if (bundling) {
            hash.update(JSON.stringify(bundling));
          }
          return hash.digest("hex");
        }
        switch (hashType) {
          case assets_1.AssetHashType.SOURCE:
            return fs_1.FileSystem.fingerprint(this.sourcePath, this.fingerprintOptions);
          case assets_1.AssetHashType.BUNDLE:
          case assets_1.AssetHashType.OUTPUT:
            if (!outputDir) {
              throw new Error(`Cannot use \`${hashType}\` hash type when \`bundling\` is not specified.`);
            }
            return fs_1.FileSystem.fingerprint(outputDir, this.fingerprintOptions);
          default:
            throw new Error("Unknown asset hash type.");
        }
      }
    };
    exports.AssetStaging = AssetStaging;
    _a = JSII_RTTI_SYMBOL_1;
    AssetStaging[_a] = { fqn: "@aws-cdk/core.AssetStaging", version: "1.128.0" };
    AssetStaging.BUNDLING_INPUT_DIR = "/asset-input";
    AssetStaging.BUNDLING_OUTPUT_DIR = "/asset-output";
    AssetStaging.assetCache = new cache_1.Cache();
    function renderAssetFilename(assetHash, extension = "") {
      return `asset.${assetHash}${extension}`;
    }
    function determineHashType(assetHashType, customSourceFingerprint) {
      const hashType = customSourceFingerprint ? assetHashType !== null && assetHashType !== void 0 ? assetHashType : assets_1.AssetHashType.CUSTOM : assetHashType !== null && assetHashType !== void 0 ? assetHashType : assets_1.AssetHashType.SOURCE;
      if (customSourceFingerprint && hashType !== assets_1.AssetHashType.CUSTOM) {
        throw new Error(`Cannot specify \`${assetHashType}\` for \`assetHashType\` when \`assetHash\` is specified. Use \`CUSTOM\` or leave \`undefined\`.`);
      }
      if (hashType === assets_1.AssetHashType.CUSTOM && !customSourceFingerprint) {
        throw new Error("`assetHash` must be specified when `assetHashType` is set to `AssetHashType.CUSTOM`.");
      }
      return hashType;
    }
    function calculateCacheKey(props) {
      return crypto.createHash("sha256").update(JSON.stringify(sortObject(props))).digest("hex");
    }
    function sortObject(object) {
      if (typeof object !== "object" || object instanceof Array) {
        return object;
      }
      const ret = {};
      for (const key of Object.keys(object).sort()) {
        ret[key] = sortObject(object[key]);
      }
      return ret;
    }
    function singleArchiveFile(directory) {
      if (!fs.existsSync(directory)) {
        throw new Error(`Directory ${directory} does not exist.`);
      }
      if (!fs.statSync(directory).isDirectory()) {
        throw new Error(`${directory} is not a directory.`);
      }
      const content = fs.readdirSync(directory);
      if (content.length === 1) {
        const file = path.join(directory, content[0]);
        const extension = path.extname(content[0]).toLowerCase();
        if (fs.statSync(file).isFile() && ARCHIVE_EXTENSIONS.includes(extension)) {
          return file;
        }
      }
      return void 0;
    }
    function determineBundledAsset(bundleDir, outputType) {
      const archiveFile = singleArchiveFile(bundleDir);
      if (outputType === bundling_1.BundlingOutput.AUTO_DISCOVER) {
        outputType = archiveFile ? bundling_1.BundlingOutput.ARCHIVED : bundling_1.BundlingOutput.NOT_ARCHIVED;
      }
      switch (outputType) {
        case bundling_1.BundlingOutput.NOT_ARCHIVED:
          return { path: bundleDir, packaging: assets_1.FileAssetPackaging.ZIP_DIRECTORY };
        case bundling_1.BundlingOutput.ARCHIVED:
          if (!archiveFile) {
            throw new Error("Bundling output directory is expected to include only a single .zip or .jar file when `output` is set to `ARCHIVED`");
          }
          return { path: archiveFile, packaging: assets_1.FileAssetPackaging.FILE, extension: path.extname(archiveFile) };
      }
    }
  }
});

// node_modules/@aws-cdk/core/lib/duration.js
var require_duration = __commonJS({
  "node_modules/@aws-cdk/core/lib/duration.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Duration = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var token_1 = require_token();
    var Duration2 = class {
      constructor(amount, unit) {
        if (!token_1.Token.isUnresolved(amount) && amount < 0) {
          throw new Error(`Duration amounts cannot be negative. Received: ${amount}`);
        }
        this.amount = amount;
        this.unit = unit;
      }
      static millis(amount) {
        return new Duration2(amount, TimeUnit.Milliseconds);
      }
      static seconds(amount) {
        return new Duration2(amount, TimeUnit.Seconds);
      }
      static minutes(amount) {
        return new Duration2(amount, TimeUnit.Minutes);
      }
      static hours(amount) {
        return new Duration2(amount, TimeUnit.Hours);
      }
      static days(amount) {
        return new Duration2(amount, TimeUnit.Days);
      }
      static parse(duration) {
        const matches = duration.match(/^P(?:(\d+)D)?(?:T(?:(\d+)H)?(?:(\d+)M)?(?:(\d+)S)?)?$/);
        if (!matches) {
          throw new Error(`Not a valid ISO duration: ${duration}`);
        }
        const [, days, hours, minutes, seconds] = matches;
        if (!days && !hours && !minutes && !seconds) {
          throw new Error(`Not a valid ISO duration: ${duration}`);
        }
        return Duration2.millis(_toInt(seconds) * TimeUnit.Seconds.inMillis + _toInt(minutes) * TimeUnit.Minutes.inMillis + _toInt(hours) * TimeUnit.Hours.inMillis + _toInt(days) * TimeUnit.Days.inMillis);
        function _toInt(str) {
          if (!str) {
            return 0;
          }
          return Number(str);
        }
      }
      plus(rhs) {
        const targetUnit = finestUnit(this.unit, rhs.unit);
        const total = convert(this.amount, this.unit, targetUnit, {}) + convert(rhs.amount, rhs.unit, targetUnit, {});
        return new Duration2(total, targetUnit);
      }
      toMilliseconds(opts = {}) {
        return convert(this.amount, this.unit, TimeUnit.Milliseconds, opts);
      }
      toSeconds(opts = {}) {
        return convert(this.amount, this.unit, TimeUnit.Seconds, opts);
      }
      toMinutes(opts = {}) {
        return convert(this.amount, this.unit, TimeUnit.Minutes, opts);
      }
      toHours(opts = {}) {
        return convert(this.amount, this.unit, TimeUnit.Hours, opts);
      }
      toDays(opts = {}) {
        return convert(this.amount, this.unit, TimeUnit.Days, opts);
      }
      toIsoString() {
        if (this.amount === 0) {
          return "PT0S";
        }
        const ret = ["P"];
        let tee = false;
        for (const [amount, unit] of this.components(true)) {
          if ([TimeUnit.Seconds, TimeUnit.Minutes, TimeUnit.Hours].includes(unit) && !tee) {
            ret.push("T");
            tee = true;
          }
          ret.push(`${amount}${unit.isoLabel}`);
        }
        return ret.join("");
      }
      toISOString() {
        return this.toIsoString();
      }
      toHumanString() {
        if (this.amount === 0) {
          return fmtUnit(0, this.unit);
        }
        if (token_1.Token.isUnresolved(this.amount)) {
          return `<token> ${this.unit.label}`;
        }
        return this.components(false).slice(0, 2).map(([amount, unit]) => fmtUnit(amount, unit)).join(" ");
        function fmtUnit(amount, unit) {
          if (amount === 1) {
            return `${amount} ${unit.label.substring(0, unit.label.length - 1)}`;
          }
          return `${amount} ${unit.label}`;
        }
      }
      toString() {
        return token_1.Token.asString(() => {
          throw new Error("Duration.toString() was used, but .toSeconds, .toMinutes or .toDays should have been called instead");
        }, { displayHint: `${this.amount} ${this.unit.label}` });
      }
      components(combineMillisWithSeconds) {
        const ret = new Array();
        let millis = convert(this.amount, this.unit, TimeUnit.Milliseconds, { integral: false });
        for (const unit of [TimeUnit.Days, TimeUnit.Hours, TimeUnit.Minutes, TimeUnit.Seconds]) {
          const count = convert(millis, TimeUnit.Milliseconds, unit, { integral: false });
          const wholeCount = unit === TimeUnit.Seconds && combineMillisWithSeconds ? count : Math.floor(count);
          if (wholeCount > 0) {
            ret.push([wholeCount, unit]);
            millis -= wholeCount * unit.inMillis;
          }
        }
        if (millis > 0) {
          ret.push([millis, TimeUnit.Milliseconds]);
        }
        return ret;
      }
      isUnresolved() {
        return token_1.Token.isUnresolved(this.amount);
      }
      unitLabel() {
        return this.unit.label;
      }
      formatTokenToNumber() {
        const number = token_1.Tokenization.stringifyNumber(this.amount);
        return `${number} ${this.unit.label}`;
      }
    };
    exports.Duration = Duration2;
    _a = JSII_RTTI_SYMBOL_1;
    Duration2[_a] = { fqn: "@aws-cdk/core.Duration", version: "1.128.0" };
    var TimeUnit = class {
      constructor(label, isoLabel, inMillis) {
        this.label = label;
        this.isoLabel = isoLabel;
        this.inMillis = inMillis;
      }
      toString() {
        return this.label;
      }
    };
    TimeUnit.Milliseconds = new TimeUnit("millis", "", 1);
    TimeUnit.Seconds = new TimeUnit("seconds", "S", 1e3);
    TimeUnit.Minutes = new TimeUnit("minutes", "M", 6e4);
    TimeUnit.Hours = new TimeUnit("hours", "H", 36e5);
    TimeUnit.Days = new TimeUnit("days", "D", 864e5);
    function convert(amount, fromUnit, toUnit, { integral = true }) {
      if (fromUnit.inMillis === toUnit.inMillis) {
        return amount;
      }
      if (token_1.Token.isUnresolved(amount)) {
        throw new Error(`Unable to perform time unit conversion on un-resolved token ${amount}.`);
      }
      const value = amount * fromUnit.inMillis / toUnit.inMillis;
      if (!Number.isInteger(value) && integral) {
        throw new Error(`'${amount} ${fromUnit}' cannot be converted into a whole number of ${toUnit}.`);
      }
      return value;
    }
    function finestUnit(a, b) {
      return a.inMillis < b.inMillis ? a : b;
    }
  }
});

// node_modules/@aws-cdk/core/lib/size.js
var require_size = __commonJS({
  "node_modules/@aws-cdk/core/lib/size.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.SizeRoundingBehavior = exports.Size = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var token_1 = require_token();
    var Size = class {
      constructor(amount, unit) {
        if (!token_1.Token.isUnresolved(amount) && amount < 0) {
          throw new Error(`Storage amounts cannot be negative. Received: ${amount}`);
        }
        this.amount = amount;
        this.unit = unit;
      }
      static kibibytes(amount) {
        return new Size(amount, StorageUnit.Kibibytes);
      }
      static mebibytes(amount) {
        return new Size(amount, StorageUnit.Mebibytes);
      }
      static gibibytes(amount) {
        return new Size(amount, StorageUnit.Gibibytes);
      }
      static tebibytes(amount) {
        return new Size(amount, StorageUnit.Tebibytes);
      }
      static pebibyte(amount) {
        return Size.pebibytes(amount);
      }
      static pebibytes(amount) {
        return new Size(amount, StorageUnit.Pebibytes);
      }
      toKibibytes(opts = {}) {
        return convert(this.amount, this.unit, StorageUnit.Kibibytes, opts);
      }
      toMebibytes(opts = {}) {
        return convert(this.amount, this.unit, StorageUnit.Mebibytes, opts);
      }
      toGibibytes(opts = {}) {
        return convert(this.amount, this.unit, StorageUnit.Gibibytes, opts);
      }
      toTebibytes(opts = {}) {
        return convert(this.amount, this.unit, StorageUnit.Tebibytes, opts);
      }
      toPebibytes(opts = {}) {
        return convert(this.amount, this.unit, StorageUnit.Pebibytes, opts);
      }
    };
    exports.Size = Size;
    _a = JSII_RTTI_SYMBOL_1;
    Size[_a] = { fqn: "@aws-cdk/core.Size", version: "1.128.0" };
    var SizeRoundingBehavior;
    (function(SizeRoundingBehavior2) {
      SizeRoundingBehavior2[SizeRoundingBehavior2["FAIL"] = 0] = "FAIL";
      SizeRoundingBehavior2[SizeRoundingBehavior2["FLOOR"] = 1] = "FLOOR";
      SizeRoundingBehavior2[SizeRoundingBehavior2["NONE"] = 2] = "NONE";
    })(SizeRoundingBehavior = exports.SizeRoundingBehavior || (exports.SizeRoundingBehavior = {}));
    var StorageUnit = class {
      constructor(label, inKibiBytes) {
        this.label = label;
        this.inKibiBytes = inKibiBytes;
      }
      toString() {
        return this.label;
      }
    };
    StorageUnit.Kibibytes = new StorageUnit("kibibytes", 1);
    StorageUnit.Mebibytes = new StorageUnit("mebibytes", 1024);
    StorageUnit.Gibibytes = new StorageUnit("gibibytes", 1024 * 1024);
    StorageUnit.Tebibytes = new StorageUnit("tebibytes", 1024 * 1024 * 1024);
    StorageUnit.Pebibytes = new StorageUnit("pebibytes", 1024 * 1024 * 1024 * 1024);
    function convert(amount, fromUnit, toUnit, options = {}) {
      var _b;
      const rounding = (_b = options.rounding) !== null && _b !== void 0 ? _b : SizeRoundingBehavior.FAIL;
      if (fromUnit.inKibiBytes === toUnit.inKibiBytes) {
        return amount;
      }
      if (token_1.Token.isUnresolved(amount)) {
        throw new Error(`Unable to perform time unit conversion on un-resolved token ${amount}.`);
      }
      const multiplier = fromUnit.inKibiBytes / toUnit.inKibiBytes;
      const value = amount * multiplier;
      switch (rounding) {
        case SizeRoundingBehavior.NONE:
          return value;
        case SizeRoundingBehavior.FLOOR:
          return Math.floor(value);
        default:
        case SizeRoundingBehavior.FAIL:
          if (!Number.isInteger(value)) {
            throw new Error(`'${amount} ${fromUnit}' cannot be converted into a whole number of ${toUnit}.`);
          }
          return value;
      }
    }
  }
});

// node_modules/@aws-cdk/core/lib/custom-resource-provider/custom-resource-provider.js
var require_custom_resource_provider = __commonJS({
  "node_modules/@aws-cdk/core/lib/custom-resource-provider/custom-resource-provider.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CustomResourceProvider = exports.CustomResourceProviderRuntime = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var asset_staging_1 = require_asset_staging();
    var assets_1 = require_assets3();
    var cfn_resource_1 = require_cfn_resource();
    var duration_1 = require_duration();
    var size_1 = require_size();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var ENTRYPOINT_FILENAME = "__entrypoint__";
    var ENTRYPOINT_NODEJS_SOURCE = path.join(__dirname, "nodejs-entrypoint.js");
    var construct_compat_1 = require_construct_compat();
    var CustomResourceProviderRuntime;
    (function(CustomResourceProviderRuntime2) {
      CustomResourceProviderRuntime2["NODEJS_12"] = "nodejs12.x";
      CustomResourceProviderRuntime2["NODEJS_12_X"] = "nodejs12.x";
      CustomResourceProviderRuntime2["NODEJS_14_X"] = "nodejs14.x";
    })(CustomResourceProviderRuntime = exports.CustomResourceProviderRuntime || (exports.CustomResourceProviderRuntime = {}));
    var CustomResourceProvider = class extends construct_compat_1.Construct {
      constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        const stack = stack_1.Stack.of(scope);
        fs.copyFileSync(ENTRYPOINT_NODEJS_SOURCE, path.join(props.codeDirectory, `${ENTRYPOINT_FILENAME}.js`));
        if (!fs.existsSync(path.join(props.codeDirectory, "index.js"))) {
          throw new Error(`cannot find ${props.codeDirectory}/index.js`);
        }
        const staging = new asset_staging_1.AssetStaging(this, "Staging", {
          sourcePath: props.codeDirectory
        });
        const asset = stack.addFileAsset({
          fileName: staging.relativeStagedPath(stack),
          sourceHash: staging.sourceHash,
          packaging: assets_1.FileAssetPackaging.ZIP_DIRECTORY
        });
        const policies = !props.policyStatements ? void 0 : [
          {
            PolicyName: "Inline",
            PolicyDocument: {
              Version: "2012-10-17",
              Statement: props.policyStatements
            }
          }
        ];
        const role = new cfn_resource_1.CfnResource(this, "Role", {
          type: "AWS::IAM::Role",
          properties: {
            AssumeRolePolicyDocument: {
              Version: "2012-10-17",
              Statement: [{ Action: "sts:AssumeRole", Effect: "Allow", Principal: { Service: "lambda.amazonaws.com" } }]
            },
            ManagedPolicyArns: [
              { "Fn::Sub": "arn:${AWS::Partition}:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole" }
            ],
            Policies: policies
          }
        });
        this.roleArn = token_1.Token.asString(role.getAtt("Arn"));
        const timeout = (_b = props.timeout) !== null && _b !== void 0 ? _b : duration_1.Duration.minutes(15);
        const memory = (_c = props.memorySize) !== null && _c !== void 0 ? _c : size_1.Size.mebibytes(128);
        const handler2 = new cfn_resource_1.CfnResource(this, "Handler", {
          type: "AWS::Lambda::Function",
          properties: {
            Code: {
              S3Bucket: asset.bucketName,
              S3Key: asset.objectKey
            },
            Timeout: timeout.toSeconds(),
            MemorySize: memory.toMebibytes(),
            Handler: `${ENTRYPOINT_FILENAME}.handler`,
            Role: role.getAtt("Arn"),
            Runtime: props.runtime,
            Environment: this.renderEnvironmentVariables(props.environment),
            Description: (_d = props.description) !== null && _d !== void 0 ? _d : void 0
          }
        });
        handler2.addDependsOn(role);
        this.serviceToken = token_1.Token.asString(handler2.getAtt("Arn"));
      }
      static getOrCreate(scope, uniqueid, props) {
        return this.getOrCreateProvider(scope, uniqueid, props).serviceToken;
      }
      static getOrCreateProvider(scope, uniqueid, props) {
        var _b;
        const id = `${uniqueid}CustomResourceProvider`;
        const stack = stack_1.Stack.of(scope);
        const provider = (_b = stack.node.tryFindChild(id)) !== null && _b !== void 0 ? _b : new CustomResourceProvider(stack, id, props);
        return provider;
      }
      renderEnvironmentVariables(env2) {
        if (!env2 || Object.keys(env2).length === 0) {
          return void 0;
        }
        const variables = {};
        const keys = Object.keys(env2).sort();
        for (const key of keys) {
          variables[key] = env2[key];
        }
        return { Variables: variables };
      }
    };
    exports.CustomResourceProvider = CustomResourceProvider;
    _a = JSII_RTTI_SYMBOL_1;
    CustomResourceProvider[_a] = { fqn: "@aws-cdk/core.CustomResourceProvider", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/custom-resource-provider/index.js
var require_custom_resource_provider2 = __commonJS({
  "node_modules/@aws-cdk/core/lib/custom-resource-provider/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_custom_resource_provider(), exports);
  }
});

// node_modules/@aws-cdk/core/lib/private/cfn-utils-provider.js
var require_cfn_utils_provider = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/cfn-utils-provider.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnUtils = exports.CfnUtilsProvider = void 0;
    var construct_compat_1 = require_construct_compat();
    var custom_resource_1 = require_custom_resource();
    var custom_resource_provider_1 = require_custom_resource_provider2();
    var CfnUtilsProvider = class extends construct_compat_1.Construct {
      static getOrCreate(scope) {
        return custom_resource_provider_1.CustomResourceProvider.getOrCreate(scope, "AWSCDKCfnUtilsProvider", {
          runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_12_X,
          codeDirectory: `${__dirname}/cfn-utils-provider`
        });
      }
    };
    exports.CfnUtilsProvider = CfnUtilsProvider;
    var CfnUtils = class {
      static stringify(scope, id, value) {
        const resource = new custom_resource_1.CustomResource(scope, id, {
          serviceToken: CfnUtilsProvider.getOrCreate(scope),
          resourceType: "Custom::AWSCDKCfnJsonStringify",
          properties: {
            Value: value
          }
        });
        return resource.getAttString("Value");
      }
    };
    exports.CfnUtils = CfnUtils;
  }
});

// node_modules/@aws-cdk/core/lib/private/cloudformation-lang.js
var require_cloudformation_lang = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/cloudformation-lang.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isNameOfCloudFormationIntrinsic = exports.minimalCloudFormationJoin = exports.CLOUDFORMATION_TOKEN_RESOLVER = exports.CloudFormationLang = void 0;
    var lazy_1 = require_lazy();
    var resolvable_1 = require_resolvable();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var cfn_utils_provider_1 = require_cfn_utils_provider();
    var resolve_1 = require_resolve();
    var CloudFormationLang = class {
      static toJSON(obj, space) {
        return lazy_1.Lazy.uncachedString({
          produce: (ctx) => tokenAwareStringify(obj, space !== null && space !== void 0 ? space : 0, ctx)
        });
      }
      static concat(left, right) {
        if (left === void 0 && right === void 0) {
          return "";
        }
        const parts = new Array();
        if (left !== void 0) {
          parts.push(left);
        }
        if (right !== void 0) {
          parts.push(right);
        }
        if (parts.length === 1) {
          return parts[0];
        }
        if (parts.length === 2 && typeof parts[0] === "string" && typeof parts[1] === "string") {
          return parts[0] + parts[1];
        }
        return fnJoinConcat(parts);
      }
    };
    exports.CloudFormationLang = CloudFormationLang;
    function fnJoinConcat(parts) {
      return { "Fn::Join": ["", minimalCloudFormationJoin("", parts)] };
    }
    function tokenAwareStringify(root, space, ctx) {
      let indent = 0;
      const ret = new Array();
      recurse(ctx.resolve(root, { allowIntrinsicKeys: true }));
      switch (ret.length) {
        case 0:
          return void 0;
        case 1:
          return renderSegment(ret[0]);
        default:
          return fnJoinConcat(ret.map(renderSegment));
      }
      function recurse(obj) {
        if (obj === void 0) {
          return;
        }
        if (token_1.Token.isUnresolved(obj)) {
          throw new Error("This shouldnt happen anymore");
        }
        if (Array.isArray(obj)) {
          return renderCollection("[", "]", obj, recurse);
        }
        if (typeof obj === "object" && obj != null && !(obj instanceof Date)) {
          if (isIntrinsic(obj) && resolve_1.resolvedTypeHint(obj)) {
            renderIntrinsic(obj);
            return;
          }
          return renderCollection("{", "}", definedEntries(obj), ([key, value]) => {
            if (key.startsWith(resolve_1.INTRINSIC_KEY_PREFIX)) {
              [key, value] = value;
            }
            recurse(key);
            pushLiteral(prettyPunctuation(":"));
            recurse(value);
          });
        }
        pushLiteral(JSON.stringify(obj));
      }
      function renderCollection(pre, post, xs, each) {
        pushLiteral(pre);
        indent += space;
        let atLeastOne = false;
        for (const [comma, item] of sepIter(xs)) {
          if (comma) {
            pushLiteral(",");
          }
          pushLineBreak();
          each(item);
          atLeastOne = true;
        }
        indent -= space;
        if (atLeastOne) {
          pushLineBreak();
        }
        pushLiteral(post);
      }
      function renderIntrinsic(intrinsic) {
        switch (resolve_1.resolvedTypeHint(intrinsic)) {
          case resolve_1.ResolutionTypeHint.STRING:
            pushLiteral('"');
            pushIntrinsic(deepQuoteStringLiterals(intrinsic));
            pushLiteral('"');
            return;
          case resolve_1.ResolutionTypeHint.LIST:
            const stack = stack_1.Stack.of(ctx.scope);
            const stringifyResponse = stringifyCache.obtain(stack, JSON.stringify(intrinsic), () => cfn_utils_provider_1.CfnUtils.stringify(stack, `CdkJsonStringify${stringifyCounter++}`, intrinsic));
            pushIntrinsic(stringifyResponse);
            return;
          case resolve_1.ResolutionTypeHint.NUMBER:
            pushIntrinsic(intrinsic);
            return;
        }
        throw new Error(`Unexpected type hint: ${resolve_1.resolvedTypeHint(intrinsic)}`);
      }
      function pushLiteral(lit) {
        let last = ret[ret.length - 1];
        if ((last === null || last === void 0 ? void 0 : last.type) !== "literal") {
          last = { type: "literal", parts: [] };
          ret.push(last);
        }
        last.parts.push(lit);
      }
      function pushIntrinsic(intrinsic) {
        ret.push({ type: "intrinsic", intrinsic });
      }
      function pushLineBreak() {
        if (space > 0) {
          pushLiteral(`
${" ".repeat(indent)}`);
        }
      }
      function prettyPunctuation(punc) {
        return space > 0 ? `${punc} ` : punc;
      }
    }
    function renderSegment(s) {
      switch (s.type) {
        case "literal":
          return s.parts.join("");
        case "intrinsic":
          return s.intrinsic;
      }
    }
    var CLOUDFORMATION_CONCAT = {
      join(left, right) {
        return CloudFormationLang.concat(left, right);
      }
    };
    exports.CLOUDFORMATION_TOKEN_RESOLVER = new resolvable_1.DefaultTokenResolver(CLOUDFORMATION_CONCAT);
    function minimalCloudFormationJoin(delimiter, values) {
      let i = 0;
      while (i < values.length) {
        const el = values[i];
        if (isSplicableFnJoinIntrinsic(el)) {
          values.splice(i, 1, ...el["Fn::Join"][1]);
        } else if (i > 0 && isPlainString(values[i - 1]) && isPlainString(values[i])) {
          values[i - 1] += delimiter + values[i];
          values.splice(i, 1);
        } else {
          i += 1;
        }
      }
      return values;
      function isPlainString(obj) {
        return typeof obj === "string" && !token_1.Token.isUnresolved(obj);
      }
      function isSplicableFnJoinIntrinsic(obj) {
        if (!isIntrinsic(obj)) {
          return false;
        }
        if (Object.keys(obj)[0] !== "Fn::Join") {
          return false;
        }
        const [delim, list] = obj["Fn::Join"];
        if (delim !== delimiter) {
          return false;
        }
        if (token_1.Token.isUnresolved(list)) {
          return false;
        }
        if (!Array.isArray(list)) {
          return false;
        }
        return true;
      }
    }
    exports.minimalCloudFormationJoin = minimalCloudFormationJoin;
    function isIntrinsic(x) {
      if (Array.isArray(x) || x === null || typeof x !== "object") {
        return false;
      }
      const keys = Object.keys(x);
      if (keys.length !== 1) {
        return false;
      }
      return keys[0] === "Ref" || isNameOfCloudFormationIntrinsic(keys[0]);
    }
    function isNameOfCloudFormationIntrinsic(name) {
      if (!name.startsWith("Fn::")) {
        return false;
      }
      return name !== "Fn::GetArtifactAtt" && name !== "Fn::GetParam";
    }
    exports.isNameOfCloudFormationIntrinsic = isNameOfCloudFormationIntrinsic;
    function* sepIter(xs) {
      let comma = false;
      for (const item of xs) {
        yield [comma, item];
        comma = true;
      }
    }
    function* definedEntries(xs) {
      for (const [key, value] of Object.entries(xs)) {
        if (value !== void 0) {
          yield [key, value];
        }
      }
    }
    function deepQuoteStringLiterals(x) {
      if (Array.isArray(x)) {
        return x.map(deepQuoteStringLiterals);
      }
      if (typeof x === "object" && x != null) {
        const ret = {};
        for (const [key, value] of Object.entries(x)) {
          ret[deepQuoteStringLiterals(key)] = deepQuoteStringLiterals(value);
        }
        return ret;
      }
      if (typeof x === "string") {
        return quoteString(x);
      }
      return x;
    }
    function quoteString(s) {
      s = JSON.stringify(s);
      return s.substring(1, s.length - 1);
    }
    var stringifyCounter = 1;
    var ScopedCache = class {
      constructor() {
        this.cache = /* @__PURE__ */ new WeakMap();
      }
      obtain(object, key, init) {
        let kvMap = this.cache.get(object);
        if (!kvMap) {
          kvMap = /* @__PURE__ */ new Map();
          this.cache.set(object, kvMap);
        }
        let ret = kvMap.get(key);
        if (ret === void 0) {
          ret = init();
          kvMap.set(key, ret);
        }
        return ret;
      }
    };
    var stringifyCache = new ScopedCache();
  }
});

// node_modules/@aws-cdk/core/lib/cfn-fn.js
var require_cfn_fn = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-fn.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Fn = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cloudformation_lang_1 = require_cloudformation_lang();
    var intrinsic_1 = require_intrinsic();
    var reference_1 = require_reference();
    var stack_trace_1 = require_stack_trace2();
    var token_1 = require_token();
    var Fn = class {
      constructor() {
      }
      static ref(logicalName) {
        return new FnRef(logicalName).toString();
      }
      static getAtt(logicalNameOfResource, attributeName) {
        return new FnGetAtt(logicalNameOfResource, attributeName);
      }
      static join(delimiter, listOfValues) {
        if (listOfValues.length === 0) {
          throw new Error("FnJoin requires at least one value to be provided");
        }
        return new FnJoin(delimiter, listOfValues).toString();
      }
      static split(delimiter, source, assumedLength) {
        if (!token_1.Token.isUnresolved(source)) {
          return source.split(delimiter);
        }
        if (token_1.Token.isUnresolved(delimiter)) {
          throw new Error("Fn.split: 'delimiter' may not be a token value");
        }
        const split = token_1.Token.asList(new FnSplit(delimiter, source));
        if (assumedLength === void 0) {
          return split;
        }
        if (token_1.Token.isUnresolved(assumedLength)) {
          throw new Error("Fn.split: 'assumedLength' may not be a token value");
        }
        return range(assumedLength).map((i) => Fn.select(i, split));
      }
      static select(index, array) {
        if (!token_1.Token.isUnresolved(array)) {
          return array[index];
        }
        return new FnSelect(index, array).toString();
      }
      static sub(body, variables) {
        return new FnSub(body, variables).toString();
      }
      static base64(data) {
        return new FnBase64(data).toString();
      }
      static cidr(ipBlock, count, sizeMask) {
        return token_1.Token.asList(new FnCidr(ipBlock, count, sizeMask));
      }
      static parseDomainName(url) {
        const noHttps = Fn.select(1, Fn.split("//", url));
        return Fn.select(0, Fn.split("/", noHttps));
      }
      static getAzs(region) {
        return token_1.Token.asList(new FnGetAZs(region));
      }
      static importValue(sharedValueToImport) {
        return new FnImportValue(sharedValueToImport).toString();
      }
      static importListValue(sharedValueToImport, assumedLength, delimiter = ",") {
        return Fn.split(delimiter, Fn.importValue(sharedValueToImport), assumedLength);
      }
      static findInMap(mapName, topLevelKey, secondLevelKey) {
        return Fn._findInMap(mapName, topLevelKey, secondLevelKey).toString();
      }
      static _findInMap(mapName, topLevelKey, secondLevelKey) {
        return new FnFindInMap(mapName, topLevelKey, secondLevelKey);
      }
      static transform(macroName, parameters) {
        return new FnTransform(macroName, parameters);
      }
      static conditionAnd(...conditions) {
        if (conditions.length === 0) {
          throw new Error("Fn.conditionAnd() needs at least one argument");
        }
        if (conditions.length === 1) {
          return conditions[0];
        }
        return Fn.conditionAnd(..._inGroupsOf(conditions, 10).map((group) => new FnAnd(...group)));
      }
      static conditionEquals(lhs, rhs) {
        return new FnEquals(lhs, rhs);
      }
      static conditionIf(conditionId, valueIfTrue, valueIfFalse) {
        return new FnIf(conditionId, valueIfTrue, valueIfFalse);
      }
      static conditionNot(condition) {
        return new FnNot(condition);
      }
      static conditionOr(...conditions) {
        if (conditions.length === 0) {
          throw new Error("Fn.conditionOr() needs at least one argument");
        }
        if (conditions.length === 1) {
          return conditions[0];
        }
        return Fn.conditionOr(..._inGroupsOf(conditions, 10).map((group) => new FnOr(...group)));
      }
      static conditionContains(listOfStrings, value) {
        return new FnContains(listOfStrings, value);
      }
      static conditionEachMemberEquals(listOfStrings, value) {
        return new FnEachMemberEquals(listOfStrings, value);
      }
      static conditionEachMemberIn(stringsToCheck, stringsToMatch) {
        return new FnEachMemberIn(stringsToCheck, stringsToMatch);
      }
      static refAll(parameterType) {
        return token_1.Token.asList(new FnRefAll(parameterType));
      }
      static valueOf(parameterOrLogicalId, attribute) {
        return new FnValueOf(parameterOrLogicalId, attribute).toString();
      }
      static valueOfAll(parameterType, attribute) {
        return token_1.Token.asList(new FnValueOfAll(parameterType, attribute));
      }
    };
    exports.Fn = Fn;
    _a = JSII_RTTI_SYMBOL_1;
    Fn[_a] = { fqn: "@aws-cdk/core.Fn", version: "1.128.0" };
    var FnBase = class extends intrinsic_1.Intrinsic {
      constructor(name, value) {
        super({ [name]: value });
      }
    };
    var FnRef = class extends FnBase {
      constructor(logicalName) {
        super("Ref", logicalName);
      }
    };
    var FnFindInMap = class extends FnBase {
      constructor(mapName, topLevelKey, secondLevelKey) {
        super("Fn::FindInMap", [mapName, topLevelKey, secondLevelKey]);
      }
    };
    var FnTransform = class extends FnBase {
      constructor(macroName, parameters) {
        super("Fn::Transform", { Name: macroName, Parameters: parameters });
      }
    };
    var FnGetAtt = class extends FnBase {
      constructor(logicalNameOfResource, attributeName) {
        super("Fn::GetAtt", [logicalNameOfResource, attributeName]);
      }
    };
    var FnGetAZs = class extends FnBase {
      constructor(region) {
        super("Fn::GetAZs", region || "");
      }
    };
    var FnImportValue = class extends FnBase {
      constructor(sharedValueToImport) {
        super("Fn::ImportValue", sharedValueToImport);
      }
    };
    var FnSelect = class extends FnBase {
      constructor(index, array) {
        super("Fn::Select", [index, array]);
      }
    };
    var FnSplit = class extends FnBase {
      constructor(delimiter, source) {
        super("Fn::Split", [delimiter, source]);
      }
    };
    var FnSub = class extends FnBase {
      constructor(body, variables) {
        super("Fn::Sub", variables ? [body, variables] : body);
      }
    };
    var FnBase64 = class extends FnBase {
      constructor(data) {
        super("Fn::Base64", data);
      }
    };
    var FnCidr = class extends FnBase {
      constructor(ipBlock, count, sizeMask) {
        if (count < 1 || count > 256) {
          throw new Error(`Fn::Cidr's count attribute must be betwen 1 and 256, ${count} was provided.`);
        }
        super("Fn::Cidr", [ipBlock, count, sizeMask]);
      }
    };
    var FnConditionBase = class extends intrinsic_1.Intrinsic {
      constructor(type, value) {
        super({ [type]: value });
        this.disambiguator = true;
      }
    };
    var FnAnd = class extends FnConditionBase {
      constructor(...condition) {
        super("Fn::And", condition);
      }
    };
    var FnEquals = class extends FnConditionBase {
      constructor(lhs, rhs) {
        super("Fn::Equals", [lhs, rhs]);
      }
    };
    var FnIf = class extends FnConditionBase {
      constructor(condition, valueIfTrue, valueIfFalse) {
        super("Fn::If", [condition, valueIfTrue, valueIfFalse]);
      }
    };
    var FnNot = class extends FnConditionBase {
      constructor(condition) {
        super("Fn::Not", [condition]);
      }
    };
    var FnOr = class extends FnConditionBase {
      constructor(...condition) {
        super("Fn::Or", condition);
      }
    };
    var FnContains = class extends FnConditionBase {
      constructor(listOfStrings, value) {
        super("Fn::Contains", [listOfStrings, value]);
      }
    };
    var FnEachMemberEquals = class extends FnConditionBase {
      constructor(listOfStrings, value) {
        super("Fn::EachMemberEquals", [listOfStrings, value]);
      }
    };
    var FnEachMemberIn = class extends FnConditionBase {
      constructor(stringsToCheck, stringsToMatch) {
        super("Fn::EachMemberIn", [stringsToCheck, stringsToMatch]);
      }
    };
    var FnRefAll = class extends FnBase {
      constructor(parameterType) {
        super("Fn::RefAll", parameterType);
      }
    };
    var FnValueOf = class extends FnBase {
      constructor(parameterOrLogicalId, attribute) {
        super("Fn::ValueOf", [parameterOrLogicalId, attribute]);
      }
    };
    var FnValueOfAll = class extends FnBase {
      constructor(parameterType, attribute) {
        super("Fn::ValueOfAll", [parameterType, attribute]);
      }
    };
    var FnJoin = class {
      constructor(delimiter, listOfValues) {
        if (listOfValues.length === 0) {
          throw new Error("FnJoin requires at least one value to be provided");
        }
        this.delimiter = delimiter;
        this.listOfValues = listOfValues;
        this.creationStack = stack_trace_1.captureStackTrace();
      }
      resolve(context) {
        if (token_1.Token.isUnresolved(this.listOfValues)) {
          return { "Fn::Join": [this.delimiter, this.listOfValues] };
        }
        const resolved = this.resolveValues(context);
        if (resolved.length === 1) {
          return resolved[0];
        }
        return { "Fn::Join": [this.delimiter, resolved] };
      }
      toString() {
        return token_1.Token.asString(this, { displayHint: "Fn::Join" });
      }
      toJSON() {
        return "<Fn::Join>";
      }
      resolveValues(context) {
        const resolvedValues = this.listOfValues.map((x) => reference_1.Reference.isReference(x) ? x : context.resolve(x));
        return cloudformation_lang_1.minimalCloudFormationJoin(this.delimiter, resolvedValues);
      }
    };
    function _inGroupsOf(array, maxGroup) {
      const result = new Array();
      for (let i = 0; i < array.length; i += maxGroup) {
        result.push(array.slice(i, i + maxGroup));
      }
      return result;
    }
    function range(n) {
      const ret = [];
      for (let i = 0; i < n; i++) {
        ret.push(i);
      }
      return ret;
    }
  }
});

// node_modules/@aws-cdk/core/lib/util.js
var require_util = __commonJS({
  "node_modules/@aws-cdk/core/lib/util.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.undefinedIfAllValuesAreEmpty = exports.findLastCommonElement = exports.pathToTopLevelStack = exports.PostResolveToken = exports.filterUndefined = exports.ignoreEmpty = exports.capitalizePropertyNames = void 0;
    var intrinsic_1 = require_intrinsic();
    var stack_1 = require_stack();
    function capitalizePropertyNames(construct, obj) {
      const stack = stack_1.Stack.of(construct);
      obj = stack.resolve(obj);
      if (typeof obj !== "object") {
        return obj;
      }
      if (Array.isArray(obj)) {
        return obj.map((x) => capitalizePropertyNames(construct, x));
      }
      const newObj = {};
      for (const key of Object.keys(obj)) {
        const value = obj[key];
        const first = key.charAt(0).toUpperCase();
        const newKey = first + key.slice(1);
        newObj[newKey] = capitalizePropertyNames(construct, value);
      }
      return newObj;
    }
    exports.capitalizePropertyNames = capitalizePropertyNames;
    function ignoreEmpty(obj) {
      return new PostResolveToken(obj, (o) => {
        if (o == null) {
          return o;
        }
        if (Array.isArray(o) && o.length === 0) {
          return void 0;
        }
        if (typeof o === "object" && Object.keys(o).length === 0) {
          return void 0;
        }
        return o;
      });
    }
    exports.ignoreEmpty = ignoreEmpty;
    function filterUndefined(obj) {
      if (Array.isArray(obj)) {
        return obj.filter((x) => x != null).map((x) => filterUndefined(x));
      }
      if (typeof obj === "object") {
        const ret = {};
        for (const [key, value] of Object.entries(obj)) {
          if (value == null) {
            continue;
          }
          ret[key] = filterUndefined(value);
        }
        return ret;
      }
      return obj;
    }
    exports.filterUndefined = filterUndefined;
    var PostResolveToken = class extends intrinsic_1.Intrinsic {
      constructor(value, processor) {
        super(value, { stackTrace: false });
        this.processor = processor;
      }
      resolve(context) {
        context.registerPostProcessor(this);
        return super.resolve(context);
      }
      postProcess(o, _context) {
        return this.processor(o);
      }
    };
    exports.PostResolveToken = PostResolveToken;
    function pathToTopLevelStack(s) {
      if (s.nestedStackParent) {
        return [...pathToTopLevelStack(s.nestedStackParent), s];
      } else {
        return [s];
      }
    }
    exports.pathToTopLevelStack = pathToTopLevelStack;
    function findLastCommonElement(path1, path2) {
      let i = 0;
      while (i < path1.length && i < path2.length) {
        if (path1[i] !== path2[i]) {
          break;
        }
        i++;
      }
      return path1[i - 1];
    }
    exports.findLastCommonElement = findLastCommonElement;
    function undefinedIfAllValuesAreEmpty(object) {
      return Object.values(object).some((v) => v !== void 0) ? object : void 0;
    }
    exports.undefinedIfAllValuesAreEmpty = undefinedIfAllValuesAreEmpty;
  }
});

// node_modules/@aws-cdk/core/lib/arn.js
var require_arn = __commonJS({
  "node_modules/@aws-cdk/core/lib/arn.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Arn = exports.ArnFormat = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_fn_1 = require_cfn_fn();
    var token_1 = require_token();
    var util_1 = require_util();
    var ArnFormat;
    (function(ArnFormat2) {
      ArnFormat2["NO_RESOURCE_NAME"] = "arn:aws:service:region:account:resource";
      ArnFormat2["COLON_RESOURCE_NAME"] = "arn:aws:service:region:account:resource:resourceName";
      ArnFormat2["SLASH_RESOURCE_NAME"] = "arn:aws:service:region:account:resource/resourceName";
      ArnFormat2["SLASH_RESOURCE_SLASH_RESOURCE_NAME"] = "arn:aws:service:region:account:/resource/resourceName";
    })(ArnFormat = exports.ArnFormat || (exports.ArnFormat = {}));
    var Arn = class {
      constructor() {
      }
      static format(components, stack) {
        var _b, _c, _d, _e;
        const partition = (_b = components.partition) !== null && _b !== void 0 ? _b : stack.partition;
        const region = (_c = components.region) !== null && _c !== void 0 ? _c : stack.region;
        const account = (_d = components.account) !== null && _d !== void 0 ? _d : stack.account;
        const sep = (_e = components.sep) !== null && _e !== void 0 ? _e : components.arnFormat === ArnFormat.COLON_RESOURCE_NAME ? ":" : "/";
        const values = [
          "arn",
          ":",
          partition,
          ":",
          components.service,
          ":",
          region,
          ":",
          account,
          ":",
          ...components.arnFormat === ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME ? ["/"] : [],
          components.resource
        ];
        if (sep !== "/" && sep !== ":" && sep !== "") {
          throw new Error('resourcePathSep may only be ":", "/" or an empty string');
        }
        if (components.resourceName != null) {
          values.push(sep);
          values.push(components.resourceName);
        }
        return values.join("");
      }
      static parse(arn, sepIfToken = "/", hasName = true) {
        let arnFormat;
        if (!hasName) {
          arnFormat = ArnFormat.NO_RESOURCE_NAME;
        } else {
          arnFormat = sepIfToken === "/" ? ArnFormat.SLASH_RESOURCE_NAME : ArnFormat.COLON_RESOURCE_NAME;
        }
        return this.split(arn, arnFormat);
      }
      static split(arn, arnFormat) {
        const components = parseArnShape(arn);
        if (components === "token") {
          return parseTokenArn(arn, arnFormat);
        }
        const [, partition, service, region, account, resourceTypeOrName, ...rest] = components;
        let resource;
        let resourceName;
        let sep;
        let resourcePartStartIndex = 0;
        let detectedArnFormat;
        let slashIndex = resourceTypeOrName.indexOf("/");
        if (slashIndex === 0) {
          slashIndex = resourceTypeOrName.indexOf("/", 1);
          resourcePartStartIndex = 1;
          detectedArnFormat = ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME;
        }
        if (slashIndex !== -1) {
          if (arnFormat === ArnFormat.NO_RESOURCE_NAME) {
            sep = void 0;
            slashIndex = -1;
            detectedArnFormat = ArnFormat.NO_RESOURCE_NAME;
          } else {
            sep = "/";
            detectedArnFormat = resourcePartStartIndex === 0 ? ArnFormat.SLASH_RESOURCE_NAME : ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME;
          }
        } else if (rest.length > 0) {
          sep = ":";
          slashIndex = -1;
          detectedArnFormat = ArnFormat.COLON_RESOURCE_NAME;
        } else {
          sep = void 0;
          detectedArnFormat = ArnFormat.NO_RESOURCE_NAME;
        }
        if (slashIndex !== -1) {
          resource = resourceTypeOrName.substring(resourcePartStartIndex, slashIndex);
          resourceName = resourceTypeOrName.substring(slashIndex + 1);
        } else {
          resource = resourceTypeOrName;
        }
        if (rest.length > 0) {
          if (!resourceName) {
            resourceName = "";
          } else {
            resourceName += ":";
          }
          resourceName += rest.join(":");
        }
        return util_1.filterUndefined({
          service: service || void 0,
          resource: resource || void 0,
          partition: partition || void 0,
          region,
          account,
          resourceName,
          sep,
          arnFormat: detectedArnFormat
        });
      }
      static extractResourceName(arn, resourceType) {
        const components = parseArnShape(arn);
        if (components === "token") {
          return cfn_fn_1.Fn.select(1, cfn_fn_1.Fn.split(`:${resourceType}/`, arn));
        }
        const parsed = Arn.parse(arn, "/", true);
        if (!token_1.Token.isUnresolved(parsed.resource) && parsed.resource !== resourceType) {
          throw new Error(`Expected resource type '${resourceType}' in ARN, got '${parsed.resource}' in '${arn}'`);
        }
        if (!parsed.resourceName) {
          throw new Error(`Expected resource name in ARN, didn't find one: '${arn}'`);
        }
        return parsed.resourceName;
      }
    };
    exports.Arn = Arn;
    _a = JSII_RTTI_SYMBOL_1;
    Arn[_a] = { fqn: "@aws-cdk/core.Arn", version: "1.128.0" };
    function parseTokenArn(arnToken, arnFormat) {
      const components = cfn_fn_1.Fn.split(":", arnToken);
      const partition = cfn_fn_1.Fn.select(1, components).toString();
      const service = cfn_fn_1.Fn.select(2, components).toString();
      const region = cfn_fn_1.Fn.select(3, components).toString();
      const account = cfn_fn_1.Fn.select(4, components).toString();
      let resource;
      let resourceName;
      let sep;
      if (arnFormat === ArnFormat.NO_RESOURCE_NAME || arnFormat === ArnFormat.COLON_RESOURCE_NAME) {
        resource = cfn_fn_1.Fn.select(5, components);
        if (arnFormat === ArnFormat.COLON_RESOURCE_NAME) {
          resourceName = cfn_fn_1.Fn.select(6, components);
          sep = ":";
        } else {
          resourceName = void 0;
          sep = void 0;
        }
      } else {
        const lastComponents = cfn_fn_1.Fn.split("/", cfn_fn_1.Fn.select(5, components));
        if (arnFormat === ArnFormat.SLASH_RESOURCE_NAME) {
          resource = cfn_fn_1.Fn.select(0, lastComponents);
          resourceName = cfn_fn_1.Fn.select(1, lastComponents);
        } else {
          resource = cfn_fn_1.Fn.select(1, lastComponents);
          resourceName = cfn_fn_1.Fn.select(2, lastComponents);
        }
        sep = "/";
      }
      return { partition, service, region, account, resource, resourceName, sep, arnFormat };
    }
    function parseArnShape(arn) {
      const looksLikeArn = arn.startsWith("arn:");
      if (!looksLikeArn) {
        if (token_1.Token.isUnresolved(arn)) {
          return "token";
        } else {
          throw new Error(`ARNs must start with "arn:" and have at least 6 components: ${arn}`);
        }
      }
      const components = arn.split(":");
      const partition = components.length > 1 ? components[1] : void 0;
      if (!partition) {
        throw new Error("The `partition` component (2nd component) of an ARN is required: " + arn);
      }
      const service = components.length > 2 ? components[2] : void 0;
      if (!service) {
        throw new Error("The `service` component (3rd component) of an ARN is required: " + arn);
      }
      const resource = components.length > 5 ? components[5] : void 0;
      if (!resource) {
        throw new Error("The `resource` component (6th component) of an ARN is required: " + arn);
      }
      return components;
    }
  }
});

// node_modules/@aws-cdk/core/lib/private/cfn-reference.js
var require_cfn_reference = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/cfn-reference.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnReference = exports.ReferenceRendering = void 0;
    var reference_1 = require_reference();
    var CFN_REFERENCE_SYMBOL = Symbol.for("@aws-cdk/core.CfnReference");
    var ReferenceRendering;
    (function(ReferenceRendering2) {
      ReferenceRendering2[ReferenceRendering2["FN_SUB"] = 0] = "FN_SUB";
      ReferenceRendering2[ReferenceRendering2["GET_ATT_STRING"] = 1] = "GET_ATT_STRING";
    })(ReferenceRendering = exports.ReferenceRendering || (exports.ReferenceRendering = {}));
    var CfnReference = class extends reference_1.Reference {
      constructor(value, displayName, target) {
        super(value, target, displayName);
        this.replacementTokens = /* @__PURE__ */ new Map();
        this.targetStack = stack_1.Stack.of(target);
        Object.defineProperty(this, CFN_REFERENCE_SYMBOL, { value: true });
      }
      static isCfnReference(x) {
        return CFN_REFERENCE_SYMBOL in x;
      }
      static for(target, attribute, refRender) {
        return CfnReference.singletonReference(target, attribute, refRender, () => {
          const cfnIntrinsic = refRender === ReferenceRendering.FN_SUB ? "${" + target.logicalId + (attribute === "Ref" ? "" : `.${attribute}`) + "}" : attribute === "Ref" ? { Ref: target.logicalId } : {
            "Fn::GetAtt": refRender === ReferenceRendering.GET_ATT_STRING ? `${target.logicalId}.${attribute}` : [target.logicalId, attribute]
          };
          return new CfnReference(cfnIntrinsic, attribute, target);
        });
      }
      static forPseudo(pseudoName, scope) {
        return CfnReference.singletonReference(scope, `Pseudo:${pseudoName}`, void 0, () => {
          const cfnIntrinsic = { Ref: pseudoName };
          return new CfnReference(cfnIntrinsic, pseudoName, scope);
        });
      }
      static singletonReference(target, attribKey, refRender, fresh) {
        let attribs = CfnReference.referenceTable.get(target);
        if (!attribs) {
          attribs = /* @__PURE__ */ new Map();
          CfnReference.referenceTable.set(target, attribs);
        }
        let cacheKey = attribKey;
        switch (refRender) {
          case ReferenceRendering.FN_SUB:
            cacheKey += "Fn::Sub";
            break;
          case ReferenceRendering.GET_ATT_STRING:
            cacheKey += "Fn::GetAtt::String";
            break;
        }
        let ref = attribs.get(cacheKey);
        if (!ref) {
          ref = fresh();
          attribs.set(cacheKey, ref);
        }
        return ref;
      }
      resolve(context) {
        const consumingStack = stack_1.Stack.of(context.scope);
        const token = this.replacementTokens.get(consumingStack);
        if (token) {
          return token.resolve(context);
        } else {
          return super.resolve(context);
        }
      }
      hasValueForStack(stack) {
        if (stack === this.targetStack) {
          return true;
        }
        return this.replacementTokens.has(stack);
      }
      assignValueForStack(stack, value) {
        if (stack === this.targetStack) {
          throw new Error("cannot assign a value for the same stack");
        }
        if (this.hasValueForStack(stack)) {
          throw new Error("Cannot assign a reference value twice to the same stack. Use hasValueForStack to check first");
        }
        this.replacementTokens.set(stack, value);
      }
      toString() {
        return token_1.Token.asString(this, {
          displayHint: `${this.target.node.id}.${this.displayName}`
        });
      }
    };
    exports.CfnReference = CfnReference;
    CfnReference.referenceTable = /* @__PURE__ */ new Map();
    var stack_1 = require_stack();
    var token_1 = require_token();
  }
});

// node_modules/@aws-cdk/core/lib/cfn-pseudo.js
var require_cfn_pseudo = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-pseudo.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ScopedAws = exports.Aws = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_reference_1 = require_cfn_reference();
    var token_1 = require_token();
    var AWS_ACCOUNTID = "AWS::AccountId";
    var AWS_URLSUFFIX = "AWS::URLSuffix";
    var AWS_NOTIFICATIONARNS = "AWS::NotificationARNs";
    var AWS_PARTITION = "AWS::Partition";
    var AWS_REGION = "AWS::Region";
    var AWS_STACKID = "AWS::StackId";
    var AWS_STACKNAME = "AWS::StackName";
    var AWS_NOVALUE = "AWS::NoValue";
    var Aws = class {
      constructor() {
      }
    };
    exports.Aws = Aws;
    _a = JSII_RTTI_SYMBOL_1;
    Aws[_a] = { fqn: "@aws-cdk/core.Aws", version: "1.128.0" };
    Aws.ACCOUNT_ID = pseudoString(AWS_ACCOUNTID);
    Aws.URL_SUFFIX = pseudoString(AWS_URLSUFFIX);
    Aws.NOTIFICATION_ARNS = token_1.Token.asList({ Ref: AWS_NOTIFICATIONARNS }, { displayHint: AWS_NOTIFICATIONARNS });
    Aws.PARTITION = pseudoString(AWS_PARTITION);
    Aws.REGION = pseudoString(AWS_REGION);
    Aws.STACK_ID = pseudoString(AWS_STACKID);
    Aws.STACK_NAME = pseudoString(AWS_STACKNAME);
    Aws.NO_VALUE = pseudoString(AWS_NOVALUE);
    var ScopedAws = class {
      constructor(scope) {
        this.scope = scope;
      }
      get accountId() {
        return this.asString(AWS_ACCOUNTID);
      }
      get urlSuffix() {
        return this.asString(AWS_URLSUFFIX);
      }
      get notificationArns() {
        return token_1.Token.asList(cfn_reference_1.CfnReference.forPseudo(AWS_NOTIFICATIONARNS, this.scope), {
          displayHint: AWS_NOTIFICATIONARNS
        });
      }
      get partition() {
        return this.asString(AWS_PARTITION);
      }
      get region() {
        return this.asString(AWS_REGION);
      }
      get stackId() {
        return this.asString(AWS_STACKID);
      }
      get stackName() {
        return this.asString(AWS_STACKNAME);
      }
      asString(name) {
        return token_1.Token.asString(cfn_reference_1.CfnReference.forPseudo(name, this.scope), { displayHint: name });
      }
    };
    exports.ScopedAws = ScopedAws;
    _b = JSII_RTTI_SYMBOL_1;
    ScopedAws[_b] = { fqn: "@aws-cdk/core.ScopedAws", version: "1.128.0" };
    function pseudoString(name) {
      return token_1.Token.asString({ Ref: name }, { displayHint: name.replace("::", ".") });
    }
  }
});

// node_modules/@aws-cdk/core/lib/context-provider.js
var require_context_provider = __commonJS({
  "node_modules/@aws-cdk/core/lib/context-provider.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ContextProvider = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_lib5();
    var constructs_1 = require_lib4();
    var annotations_1 = require_annotations();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var ContextProvider = class {
      constructor() {
      }
      static getKey(scope, options) {
        const stack = stack_1.Stack.of(scope);
        const props = __spreadValues({
          account: stack.account,
          region: stack.region
        }, options.props || {});
        if (Object.values(props).find((x) => token_1.Token.isUnresolved(x))) {
          throw new Error(`Cannot determine scope for context provider ${options.provider}.
This usually happens when one or more of the provider props have unresolved tokens`);
        }
        const propStrings = propsToArray(props);
        return {
          key: `${options.provider}:${propStrings.join(":")}`,
          props
        };
      }
      static getValue(scope, options) {
        const stack = stack_1.Stack.of(scope);
        if (token_1.Token.isUnresolved(stack.account) || token_1.Token.isUnresolved(stack.region)) {
          throw new Error(`Cannot retrieve value from context provider ${options.provider} since account/region are not specified at the stack level. Configure "env" with an account and region when you define your stack.See https://docs.aws.amazon.com/cdk/latest/guide/environments.html for more details.`);
        }
        const { key, props } = this.getKey(scope, options);
        const value = constructs_1.Node.of(scope).tryGetContext(key);
        const providerError = extractProviderError(value);
        if (value === void 0 || providerError !== void 0) {
          stack.reportMissingContext({
            key,
            provider: options.provider,
            props
          });
          if (providerError !== void 0) {
            annotations_1.Annotations.of(scope).addError(providerError);
          }
          return { value: options.dummyValue };
        }
        return { value };
      }
    };
    exports.ContextProvider = ContextProvider;
    _a = JSII_RTTI_SYMBOL_1;
    ContextProvider[_a] = { fqn: "@aws-cdk/core.ContextProvider", version: "1.128.0" };
    function extractProviderError(value) {
      if (typeof value === "object" && value !== null) {
        return value[cxapi.PROVIDER_ERROR_KEY];
      }
      return void 0;
    }
    function colonQuote(xs) {
      return xs.replace("$", "$$").replace(":", "$:");
    }
    function propsToArray(props, keyPrefix = "") {
      const ret = [];
      for (const key of Object.keys(props)) {
        if (props[key] === void 0) {
          continue;
        }
        switch (typeof props[key]) {
          case "object": {
            ret.push(...propsToArray(props[key], `${keyPrefix}${key}.`));
            break;
          }
          case "string": {
            ret.push(`${keyPrefix}${key}=${colonQuote(props[key])}`);
            break;
          }
          default: {
            ret.push(`${keyPrefix}${key}=${JSON.stringify(props[key])}`);
            break;
          }
        }
      }
      ret.sort();
      return ret;
    }
  }
});

// node_modules/@aws-cdk/core/lib/feature-flags.js
var require_feature_flags = __commonJS({
  "node_modules/@aws-cdk/core/lib/feature-flags.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.FeatureFlags = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_lib5();
    var FeatureFlags = class {
      constructor(construct) {
        this.construct = construct;
      }
      static of(scope) {
        return new FeatureFlags(scope);
      }
      isEnabled(featureFlag) {
        const context = this.construct.node.tryGetContext(featureFlag);
        if (cxapi.FUTURE_FLAGS_EXPIRED.includes(featureFlag)) {
          if (context !== void 0) {
            throw new Error(`Unsupported feature flag '${featureFlag}'. This flag existed on CDKv1 but has been removed in CDKv2. CDK will now behave as the same as when the flag is enabled.`);
          }
          return true;
        }
        return context !== null && context !== void 0 ? context : cxapi.futureFlagDefault(featureFlag);
      }
    };
    exports.FeatureFlags = FeatureFlags;
    _a = JSII_RTTI_SYMBOL_1;
    FeatureFlags[_a] = { fqn: "@aws-cdk/core.FeatureFlags", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/private/logical-id.js
var require_logical_id = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/logical-id.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.LogicalIDs = void 0;
    var LogicalIDs = class {
      constructor() {
        this.renames = {};
        this.reverse = {};
      }
      addRename(oldId, newId) {
        if (oldId in this.renames) {
          throw new Error(`A rename has already been registered for '${oldId}'`);
        }
        this.renames[oldId] = newId;
      }
      applyRename(oldId) {
        let newId = oldId;
        if (oldId in this.renames) {
          newId = this.renames[oldId];
        }
        if (newId in this.reverse && this.reverse[newId] !== oldId) {
          throw new Error(`Two objects have been assigned the same Logical ID: '${this.reverse[newId]}' and '${oldId}' are now both named '${newId}'.`);
        }
        this.reverse[newId] = oldId;
        validateLogicalId(newId);
        return newId;
      }
      assertAllRenamesApplied() {
        const keys = /* @__PURE__ */ new Set();
        Object.keys(this.renames).forEach(keys.add.bind(keys));
        Object.keys(this.reverse).map((newId) => {
          keys.delete(this.reverse[newId]);
        });
        if (keys.size !== 0) {
          const unusedRenames = Array.from(keys.values());
          throw new Error(`The following Logical IDs were attempted to be renamed, but not found: ${unusedRenames.join(", ")}`);
        }
      }
    };
    exports.LogicalIDs = LogicalIDs;
    var VALID_LOGICALID_REGEX = /^[A-Za-z][A-Za-z0-9]{1,254}$/;
    function validateLogicalId(logicalId) {
      if (!VALID_LOGICALID_REGEX.test(logicalId)) {
        throw new Error(`Logical ID must adhere to the regular expression: ${VALID_LOGICALID_REGEX.toString()}, got '${logicalId}'`);
      }
    }
  }
});

// node_modules/@aws-cdk/core/lib/cfn-output.js
var require_cfn_output = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-output.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnOutput = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var CfnOutput = class extends cfn_element_1.CfnElement {
      constructor(scope, id, props) {
        super(scope, id);
        if (props.value === void 0) {
          throw new Error(`Missing value for CloudFormation output at path "${this.node.path}"`);
        }
        this._description = props.description;
        this._value = props.value;
        this._condition = props.condition;
        this._exportName = props.exportName;
      }
      get description() {
        return this._description;
      }
      set description(description) {
        this._description = description;
      }
      get value() {
        return this._value;
      }
      set value(value) {
        this._value = value;
      }
      get condition() {
        return this._condition;
      }
      set condition(condition) {
        this._condition = condition;
      }
      get exportName() {
        return this._exportName;
      }
      set exportName(exportName) {
        this._exportName = exportName;
      }
      get importValue() {
        return cfn_fn_1.Fn.importValue(lazy_1.Lazy.stringValue({
          produce: (ctx) => {
            if (stack_1.Stack.of(ctx.scope) === this.stack) {
              throw new Error(`'importValue' property of '${this.node.path}' should only be used in a different Stack`);
            }
            if (!this._exportName) {
              throw new Error(`Add an exportName to the CfnOutput at '${this.node.path}' in order to use 'output.importValue'`);
            }
            return this._exportName;
          }
        }));
      }
      _toCloudFormation() {
        return {
          Outputs: {
            [this.logicalId]: {
              Description: this._description,
              Value: this._value,
              Export: this._exportName != null ? { Name: this._exportName } : void 0,
              Condition: this._condition ? this._condition.logicalId : void 0
            }
          }
        };
      }
      validate() {
        if (this._exportName && !token_1.Token.isUnresolved(this._exportName) && this._exportName.length > 255) {
          return [`Export name cannot exceed 255 characters (got ${this._exportName.length} characters)`];
        }
        return [];
      }
    };
    exports.CfnOutput = CfnOutput;
    _a = JSII_RTTI_SYMBOL_1;
    CfnOutput[_a] = { fqn: "@aws-cdk/core.CfnOutput", version: "1.128.0" };
    var cfn_fn_1 = require_cfn_fn();
    var lazy_1 = require_lazy();
    var stack_1 = require_stack();
    var token_1 = require_token();
  }
});

// node_modules/@aws-cdk/core/lib/deps.js
var require_deps = __commonJS({
  "node_modules/@aws-cdk/core/lib/deps.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.addDependency = void 0;
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var util_1 = require_util();
    function addDependency(source, target, reason) {
      if (source === target) {
        return;
      }
      const sourceStack = stack_1.Stack.of(source);
      const targetStack = stack_1.Stack.of(target);
      const sourceStage = stage_1.Stage.of(sourceStack);
      const targetStage = stage_1.Stage.of(targetStack);
      if (sourceStage !== targetStage) {
        throw new Error(`You cannot add a dependency from '${source.node.path}' (in ${describeStage(sourceStage)}) to '${target.node.path}' (in ${describeStage(targetStage)}): dependency cannot cross stage boundaries`);
      }
      const sourcePath = util_1.pathToTopLevelStack(sourceStack);
      const targetPath = util_1.pathToTopLevelStack(targetStack);
      const commonStack = util_1.findLastCommonElement(sourcePath, targetPath);
      if (!commonStack) {
        const topLevelSource = sourcePath[0];
        const topLevelTarget = targetPath[0];
        topLevelSource._addAssemblyDependency(topLevelTarget, reason);
        return;
      }
      if (commonStack === source) {
        return;
      }
      if (commonStack === target) {
        throw new Error(`Nested stack '${sourceStack.node.path}' cannot depend on a parent stack '${targetStack.node.path}': ${reason}`);
      }
      const sourceResource = resourceInCommonStackFor(source);
      const targetResource = resourceInCommonStackFor(target);
      sourceResource._addResourceDependency(targetResource);
      function resourceInCommonStackFor(element) {
        const resource = stack_1.Stack.isStack(element) ? element.nestedStackResource : element;
        if (!resource) {
          throw new Error("assertion failure");
        }
        const resourceStack = stack_1.Stack.of(resource);
        if (commonStack === resourceStack) {
          return resource;
        }
        return resourceInCommonStackFor(resourceStack);
      }
    }
    exports.addDependency = addDependency;
    function describeStage(assembly) {
      if (!assembly) {
        return "an unrooted construct tree";
      }
      if (!assembly.parentStage) {
        return "the App";
      }
      return `Stage '${assembly.node.path}'`;
    }
  }
});

// node_modules/@aws-cdk/core/lib/stack-synthesizers/types.js
var require_types = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack-synthesizers/types.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/@aws-cdk/core/lib/cfn-parameter.js
var require_cfn_parameter = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-parameter.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnParameter = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var cfn_reference_1 = require_cfn_reference();
    var token_1 = require_token();
    var CfnParameter = class extends cfn_element_1.CfnElement {
      constructor(scope, id, props = {}) {
        super(scope, id);
        this._type = props.type || "String";
        this._default = props.default;
        this._allowedPattern = props.allowedPattern;
        this._allowedValues = props.allowedValues;
        this._constraintDescription = props.constraintDescription;
        this._description = props.description;
        this._maxLength = props.maxLength;
        this._maxValue = props.maxValue;
        this._minLength = props.minLength;
        this._minValue = props.minValue;
        this._noEcho = props.noEcho;
      }
      get type() {
        return this._type;
      }
      set type(type) {
        this._type = type;
      }
      get default() {
        return this._default;
      }
      set default(value) {
        this._default = value;
      }
      get allowedPattern() {
        return this._allowedPattern;
      }
      set allowedPattern(pattern) {
        this._allowedPattern = pattern;
      }
      get allowedValues() {
        return this._allowedValues;
      }
      set allowedValues(values) {
        this._allowedValues = values;
      }
      get constraintDescription() {
        return this._constraintDescription;
      }
      set constraintDescription(desc) {
        this._constraintDescription = desc;
      }
      get description() {
        return this._description;
      }
      set description(desc) {
        this._description = desc;
      }
      get maxLength() {
        return this._maxLength;
      }
      set maxLength(len) {
        this._maxLength = len;
      }
      get minLength() {
        return this._minLength;
      }
      set minLength(len) {
        this._minLength = len;
      }
      get maxValue() {
        return this._maxValue;
      }
      set maxValue(len) {
        this._maxValue = len;
      }
      get minValue() {
        return this._minValue;
      }
      set minValue(len) {
        this._minValue = len;
      }
      get noEcho() {
        return !!this._noEcho;
      }
      set noEcho(echo) {
        this._noEcho = echo;
      }
      get value() {
        return cfn_reference_1.CfnReference.for(this, "Ref");
      }
      get valueAsString() {
        if (!isStringType(this.type) && !isNumberType(this.type)) {
          throw new Error(`Parameter type (${this.type}) is not a string or number type`);
        }
        return token_1.Token.asString(this.value);
      }
      get valueAsList() {
        if (!isListType(this.type)) {
          throw new Error(`Parameter type (${this.type}) is not a string list type`);
        }
        return token_1.Token.asList(this.value);
      }
      get valueAsNumber() {
        if (!isNumberType(this.type)) {
          throw new Error(`Parameter type (${this.type}) is not a number type`);
        }
        return token_1.Token.asNumber(this.value);
      }
      _toCloudFormation() {
        return {
          Parameters: {
            [this.logicalId]: {
              Type: this.type,
              Default: this.default,
              AllowedPattern: this.allowedPattern,
              AllowedValues: this.allowedValues,
              ConstraintDescription: this.constraintDescription,
              Description: this.description,
              MaxLength: this.maxLength,
              MaxValue: this.maxValue,
              MinLength: this.minLength,
              MinValue: this.minValue,
              NoEcho: this._noEcho
            }
          }
        };
      }
      resolve(_context) {
        return this.value;
      }
    };
    exports.CfnParameter = CfnParameter;
    _a = JSII_RTTI_SYMBOL_1;
    CfnParameter[_a] = { fqn: "@aws-cdk/core.CfnParameter", version: "1.128.0" };
    function isListType(type) {
      return type.indexOf("List<") >= 0 || type.indexOf("CommaDelimitedList") >= 0;
    }
    function isNumberType(type) {
      return type === "Number";
    }
    function isStringType(type) {
      return !isListType(type) && !isNumberType(type);
    }
  }
});

// node_modules/@aws-cdk/core/lib/cfn-rule.js
var require_cfn_rule = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-rule.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnRule = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var util_1 = require_util();
    var CfnRule = class extends cfn_element_1.CfnRefElement {
      constructor(scope, id, props) {
        super(scope, id);
        this.ruleCondition = props && props.ruleCondition;
        this.assertions = props && props.assertions;
      }
      addAssertion(condition, description) {
        if (!this.assertions) {
          this.assertions = [];
        }
        this.assertions.push({
          assert: condition,
          assertDescription: description
        });
      }
      _toCloudFormation() {
        return {
          Rules: {
            [this.logicalId]: {
              RuleCondition: this.ruleCondition,
              Assertions: util_1.capitalizePropertyNames(this, this.assertions)
            }
          }
        };
      }
    };
    exports.CfnRule = CfnRule;
    _a = JSII_RTTI_SYMBOL_1;
    CfnRule[_a] = { fqn: "@aws-cdk/core.CfnRule", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/stack-synthesizers/_shared.js
var require_shared = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack-synthesizers/_shared.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.assertBound = exports.contentHash = exports.addStackArtifactToAssembly = void 0;
    var crypto = require("crypto");
    var cxschema = require_lib3();
    var construct_compat_1 = require_construct_compat();
    var stack_1 = require_stack();
    function addStackArtifactToAssembly(session, stack, stackProps, additionalStackDependencies) {
      if (stack.tags.hasTags()) {
        stack.node.addMetadata(cxschema.ArtifactMetadataEntryType.STACK_TAGS, stack.tags.renderTags());
      }
      const deps = [
        ...stack.dependencies.map((s) => s.artifactId),
        ...additionalStackDependencies
      ];
      const meta = collectStackMetadata(stack);
      const stackNameProperty = stack.stackName === stack.artifactId ? {} : { stackName: stack.stackName };
      const properties = __spreadValues(__spreadValues({
        templateFile: stack.templateFile,
        terminationProtection: stack.terminationProtection,
        tags: nonEmptyDict(stack.tags.tagValues()),
        validateOnSynth: session.validateOnSynth
      }, stackProps), stackNameProperty);
      session.assembly.addArtifact(stack.artifactId, {
        type: cxschema.ArtifactType.AWS_CLOUDFORMATION_STACK,
        environment: stack.environment,
        properties,
        dependencies: deps.length > 0 ? deps : void 0,
        metadata: Object.keys(meta).length > 0 ? meta : void 0,
        displayName: stack.node.path
      });
    }
    exports.addStackArtifactToAssembly = addStackArtifactToAssembly;
    function collectStackMetadata(stack) {
      const output = {};
      visit(stack);
      return output;
      function visit(node) {
        const parent = findParentStack(node);
        if (parent !== stack) {
          return;
        }
        if (node.node.metadata.length > 0) {
          output[construct_compat_1.ConstructNode.PATH_SEP + node.node.path] = node.node.metadata.map((md) => stack.resolve(md));
        }
        for (const child of node.node.children) {
          visit(child);
        }
      }
      function findParentStack(node) {
        if (node instanceof stack_1.Stack && node.nestedStackParent === void 0) {
          return node;
        }
        if (!node.node.scope) {
          return void 0;
        }
        return findParentStack(node.node.scope);
      }
    }
    function contentHash(content) {
      return crypto.createHash("sha256").update(content).digest("hex");
    }
    exports.contentHash = contentHash;
    function assertBound(x) {
      if (x === null && x === void 0) {
        throw new Error("You must call bindStack() first");
      }
    }
    exports.assertBound = assertBound;
    function nonEmptyDict(xs) {
      return Object.keys(xs).length > 0 ? xs : void 0;
    }
  }
});

// node_modules/@aws-cdk/core/lib/stack-synthesizers/stack-synthesizer.js
var require_stack_synthesizer = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack-synthesizers/stack-synthesizer.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.StackSynthesizer = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var _shared_1 = require_shared();
    var StackSynthesizer = class {
      synthesizeStackTemplate(stack, session) {
        stack._synthesizeTemplate(session);
      }
      emitStackArtifact(stack, session, options = {}) {
        var _b;
        _shared_1.addStackArtifactToAssembly(session, stack, options !== null && options !== void 0 ? options : {}, (_b = options.additionalDependencies) !== null && _b !== void 0 ? _b : []);
      }
    };
    exports.StackSynthesizer = StackSynthesizer;
    _a = JSII_RTTI_SYMBOL_1;
    StackSynthesizer[_a] = { fqn: "@aws-cdk/core.StackSynthesizer", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/stack-synthesizers/default-synthesizer.js
var require_default_synthesizer = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack-synthesizers/default-synthesizer.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DefaultStackSynthesizer = exports.BOOTSTRAP_QUALIFIER_CONTEXT = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var cxschema = require_lib3();
    var cxapi = require_lib5();
    var assets_1 = require_assets3();
    var cfn_fn_1 = require_cfn_fn();
    var cfn_parameter_1 = require_cfn_parameter();
    var cfn_rule_1 = require_cfn_rule();
    var token_1 = require_token();
    var _shared_1 = require_shared();
    var stack_synthesizer_1 = require_stack_synthesizer();
    exports.BOOTSTRAP_QUALIFIER_CONTEXT = "@aws-cdk/core:bootstrapQualifier";
    var MIN_BOOTSTRAP_STACK_VERSION = 6;
    var DefaultStackSynthesizer = class extends stack_synthesizer_1.StackSynthesizer {
      constructor(props = {}) {
        super();
        this.props = props;
        this.files = {};
        this.dockerImages = {};
        for (const key in props) {
          if (props.hasOwnProperty(key)) {
            validateNoToken(key);
          }
        }
        function validateNoToken(key) {
          const prop = props[key];
          if (typeof prop === "string" && token_1.Token.isUnresolved(prop)) {
            throw new Error(`DefaultSynthesizer property '${key}' cannot contain tokens; only the following placeholder strings are allowed: ` + [
              "${Qualifier}",
              cxapi.EnvironmentPlaceholders.CURRENT_REGION,
              cxapi.EnvironmentPlaceholders.CURRENT_ACCOUNT,
              cxapi.EnvironmentPlaceholders.CURRENT_PARTITION
            ].join(", "));
          }
        }
      }
      bind(stack) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        if (this._stack !== void 0) {
          throw new Error("A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack");
        }
        this._stack = stack;
        const qualifier = (_c = (_b = this.props.qualifier) !== null && _b !== void 0 ? _b : stack.node.tryGetContext(exports.BOOTSTRAP_QUALIFIER_CONTEXT)) !== null && _c !== void 0 ? _c : DefaultStackSynthesizer.DEFAULT_QUALIFIER;
        this.qualifier = qualifier;
        const specialize = (s) => {
          s = replaceAll(s, "${Qualifier}", qualifier);
          return cxapi.EnvironmentPlaceholders.replace(s, {
            region: resolvedOr(stack.region, cxapi.EnvironmentPlaceholders.CURRENT_REGION),
            accountId: resolvedOr(stack.account, cxapi.EnvironmentPlaceholders.CURRENT_ACCOUNT),
            partition: cxapi.EnvironmentPlaceholders.CURRENT_PARTITION
          });
        };
        this.bucketName = specialize((_d = this.props.fileAssetsBucketName) !== null && _d !== void 0 ? _d : DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME);
        this.repositoryName = specialize((_e = this.props.imageAssetsRepositoryName) !== null && _e !== void 0 ? _e : DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME);
        this._deployRoleArn = specialize((_f = this.props.deployRoleArn) !== null && _f !== void 0 ? _f : DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN);
        this._cloudFormationExecutionRoleArn = specialize((_g = this.props.cloudFormationExecutionRole) !== null && _g !== void 0 ? _g : DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN);
        this.fileAssetPublishingRoleArn = specialize((_h = this.props.fileAssetPublishingRoleArn) !== null && _h !== void 0 ? _h : DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN);
        this.imageAssetPublishingRoleArn = specialize((_j = this.props.imageAssetPublishingRoleArn) !== null && _j !== void 0 ? _j : DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN);
        this.lookupRoleArn = specialize((_k = this.props.lookupRoleArn) !== null && _k !== void 0 ? _k : DefaultStackSynthesizer.DEFAULT_LOOKUP_ROLE_ARN);
        this.bucketPrefix = specialize((_l = this.props.bucketPrefix) !== null && _l !== void 0 ? _l : DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX);
        this.bootstrapStackVersionSsmParameter = replaceAll((_m = this.props.bootstrapStackVersionSsmParameter) !== null && _m !== void 0 ? _m : DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER, "${Qualifier}", qualifier);
      }
      addFileAsset(asset) {
        _shared_1.assertBound(this.stack);
        _shared_1.assertBound(this.bucketName);
        validateFileAssetSource(asset);
        const extension = asset.fileName != void 0 ? path.extname(asset.fileName) : "";
        const objectKey = this.bucketPrefix + asset.sourceHash + (asset.packaging === assets_1.FileAssetPackaging.ZIP_DIRECTORY ? ".zip" : extension);
        this.files[asset.sourceHash] = {
          source: {
            path: asset.fileName,
            executable: asset.executable,
            packaging: asset.packaging
          },
          destinations: {
            [this.manifestEnvName]: {
              bucketName: this.bucketName,
              objectKey,
              region: resolvedOr(this.stack.region, void 0),
              assumeRoleArn: this.fileAssetPublishingRoleArn,
              assumeRoleExternalId: this.props.fileAssetPublishingExternalId
            }
          }
        };
        const { region, urlSuffix } = stackLocationOrInstrinsics(this.stack);
        const httpUrl = cfnify(`https://s3.${region}.${urlSuffix}/${this.bucketName}/${objectKey}`);
        const s3ObjectUrl = cfnify(`s3://${this.bucketName}/${objectKey}`);
        return {
          bucketName: cfnify(this.bucketName),
          objectKey,
          httpUrl,
          s3ObjectUrl,
          s3Url: httpUrl
        };
      }
      addDockerImageAsset(asset) {
        _shared_1.assertBound(this.stack);
        _shared_1.assertBound(this.repositoryName);
        validateDockerImageAssetSource(asset);
        const imageTag = asset.sourceHash;
        this.dockerImages[asset.sourceHash] = {
          source: {
            executable: asset.executable,
            directory: asset.directoryName,
            dockerBuildArgs: asset.dockerBuildArgs,
            dockerBuildTarget: asset.dockerBuildTarget,
            dockerFile: asset.dockerFile
          },
          destinations: {
            [this.manifestEnvName]: {
              repositoryName: this.repositoryName,
              imageTag,
              region: resolvedOr(this.stack.region, void 0),
              assumeRoleArn: this.imageAssetPublishingRoleArn,
              assumeRoleExternalId: this.props.imageAssetPublishingExternalId
            }
          }
        };
        const { account, region, urlSuffix } = stackLocationOrInstrinsics(this.stack);
        return {
          repositoryName: cfnify(this.repositoryName),
          imageUri: cfnify(`${account}.dkr.ecr.${region}.${urlSuffix}/${this.repositoryName}:${imageTag}`)
        };
      }
      synthesizeStackTemplate(stack, session) {
        stack._synthesizeTemplate(session, this.lookupRoleArn);
      }
      synthesize(session) {
        var _b;
        _shared_1.assertBound(this.stack);
        _shared_1.assertBound(this.qualifier);
        if ((_b = this.props.generateBootstrapVersionRule) !== null && _b !== void 0 ? _b : true) {
          addBootstrapVersionRule(this.stack, MIN_BOOTSTRAP_STACK_VERSION, this.bootstrapStackVersionSsmParameter);
        }
        this.synthesizeStackTemplate(this.stack, session);
        const templateManifestUrl = this.addStackTemplateToAssetManifest(session);
        const artifactId = this.writeAssetManifest(session);
        this.emitStackArtifact(this.stack, session, {
          assumeRoleExternalId: this.props.deployRoleExternalId,
          assumeRoleArn: this._deployRoleArn,
          cloudFormationExecutionRoleArn: this._cloudFormationExecutionRoleArn,
          stackTemplateAssetObjectUrl: templateManifestUrl,
          requiresBootstrapStackVersion: MIN_BOOTSTRAP_STACK_VERSION,
          bootstrapStackVersionSsmParameter: this.bootstrapStackVersionSsmParameter,
          additionalDependencies: [artifactId]
        });
      }
      get deployRoleArn() {
        if (!this._deployRoleArn) {
          throw new Error("deployRoleArn getter can only be called after the synthesizer has been bound to a Stack");
        }
        return this._deployRoleArn;
      }
      get cloudFormationExecutionRoleArn() {
        if (!this._cloudFormationExecutionRoleArn) {
          throw new Error("cloudFormationExecutionRoleArn getter can only be called after the synthesizer has been bound to a Stack");
        }
        return this._cloudFormationExecutionRoleArn;
      }
      get stack() {
        return this._stack;
      }
      addStackTemplateToAssetManifest(session) {
        _shared_1.assertBound(this.stack);
        const templatePath = path.join(session.assembly.outdir, this.stack.templateFile);
        const template = fs.readFileSync(templatePath, { encoding: "utf-8" });
        const sourceHash = _shared_1.contentHash(template);
        this.addFileAsset({
          fileName: this.stack.templateFile,
          packaging: assets_1.FileAssetPackaging.FILE,
          sourceHash
        });
        const extension = path.extname(this.stack.templateFile);
        return `s3://${this.bucketName}/${this.bucketPrefix}${sourceHash}${extension}`;
      }
      writeAssetManifest(session) {
        _shared_1.assertBound(this.stack);
        const artifactId = `${this.stack.artifactId}.assets`;
        const manifestFile = `${artifactId}.json`;
        const outPath = path.join(session.assembly.outdir, manifestFile);
        const manifest = {
          version: cxschema.Manifest.version(),
          files: this.files,
          dockerImages: this.dockerImages
        };
        fs.writeFileSync(outPath, JSON.stringify(manifest, void 0, 2));
        session.assembly.addArtifact(artifactId, {
          type: cxschema.ArtifactType.ASSET_MANIFEST,
          properties: {
            file: manifestFile,
            requiresBootstrapStackVersion: MIN_BOOTSTRAP_STACK_VERSION,
            bootstrapStackVersionSsmParameter: this.bootstrapStackVersionSsmParameter
          }
        });
        return artifactId;
      }
      get manifestEnvName() {
        _shared_1.assertBound(this.stack);
        return [
          resolvedOr(this.stack.account, "current_account"),
          resolvedOr(this.stack.region, "current_region")
        ].join("-");
      }
    };
    exports.DefaultStackSynthesizer = DefaultStackSynthesizer;
    _a = JSII_RTTI_SYMBOL_1;
    DefaultStackSynthesizer[_a] = { fqn: "@aws-cdk/core.DefaultStackSynthesizer", version: "1.128.0" };
    DefaultStackSynthesizer.DEFAULT_QUALIFIER = "hnb659fds";
    DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-cfn-exec-role-${AWS::AccountId}-${AWS::Region}";
    DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-deploy-role-${AWS::AccountId}-${AWS::Region}";
    DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-file-publishing-role-${AWS::AccountId}-${AWS::Region}";
    DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-image-publishing-role-${AWS::AccountId}-${AWS::Region}";
    DefaultStackSynthesizer.DEFAULT_LOOKUP_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-lookup-role-${AWS::AccountId}-${AWS::Region}";
    DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME = "cdk-${Qualifier}-container-assets-${AWS::AccountId}-${AWS::Region}";
    DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME = "cdk-${Qualifier}-assets-${AWS::AccountId}-${AWS::Region}";
    DefaultStackSynthesizer.DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME = "CdkBootstrap-${Qualifier}-FileAssetKeyArn";
    DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX = "";
    DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER = "/cdk-bootstrap/${Qualifier}/version";
    function resolvedOr(x, def) {
      return token_1.Token.isUnresolved(x) ? def : x;
    }
    function replaceAll(s, search, replace) {
      return s.split(search).join(replace);
    }
    function cfnify(s) {
      return s.indexOf("${") > -1 ? cfn_fn_1.Fn.sub(s) : s;
    }
    function stackLocationOrInstrinsics(stack) {
      return {
        account: resolvedOr(stack.account, "${AWS::AccountId}"),
        region: resolvedOr(stack.region, "${AWS::Region}"),
        urlSuffix: resolvedOr(stack.urlSuffix, "${AWS::URLSuffix}")
      };
    }
    function addBootstrapVersionRule(stack, requiredVersion, bootstrapStackVersionSsmParameter) {
      if (stack.node.tryFindChild("BootstrapVersion")) {
        return;
      }
      const param = new cfn_parameter_1.CfnParameter(stack, "BootstrapVersion", {
        type: "AWS::SSM::Parameter::Value<String>",
        description: "Version of the CDK Bootstrap resources in this environment, automatically retrieved from SSM Parameter Store.",
        default: bootstrapStackVersionSsmParameter
      });
      const oldVersions = range(1, requiredVersion).map((n) => `${n}`);
      new cfn_rule_1.CfnRule(stack, "CheckBootstrapVersion", {
        assertions: [
          {
            assert: cfn_fn_1.Fn.conditionNot(cfn_fn_1.Fn.conditionContains(oldVersions, param.valueAsString)),
            assertDescription: `CDK bootstrap stack version ${requiredVersion} required. Please run 'cdk bootstrap' with a recent version of the CDK CLI.`
          }
        ]
      });
    }
    function range(startIncl, endExcl) {
      const ret = new Array();
      for (let i = startIncl; i < endExcl; i++) {
        ret.push(i);
      }
      return ret;
    }
    function validateFileAssetSource(asset) {
      if (!!asset.executable === !!asset.fileName) {
        throw new Error(`Exactly one of 'fileName' or 'executable' is required, got: ${JSON.stringify(asset)}`);
      }
      if (!!asset.packaging !== !!asset.fileName) {
        throw new Error(`'packaging' is expected in combination with 'fileName', got: ${JSON.stringify(asset)}`);
      }
    }
    function validateDockerImageAssetSource(asset) {
      if (!!asset.executable === !!asset.directoryName) {
        throw new Error(`Exactly one of 'directoryName' or 'executable' is required, got: ${JSON.stringify(asset)}`);
      }
      check("dockerBuildArgs");
      check("dockerBuildTarget");
      check("dockerFile");
      function check(key) {
        if (asset[key] && !asset.directoryName) {
          throw new Error(`'${key}' is only allowed in combination with 'directoryName', got: ${JSON.stringify(asset)}`);
        }
      }
    }
  }
});

// node_modules/@aws-cdk/core/lib/private/asset-parameters.js
var require_asset_parameters = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/asset-parameters.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.FileAssetParameters = void 0;
    var cfn_parameter_1 = require_cfn_parameter();
    var construct_compat_1 = require_construct_compat();
    var FileAssetParameters = class extends construct_compat_1.Construct {
      constructor(scope, id) {
        super(scope, id);
        this.bucketNameParameter = new cfn_parameter_1.CfnParameter(this, "S3Bucket", {
          type: "String",
          description: `S3 bucket for asset "${id}"`
        });
        this.objectKeyParameter = new cfn_parameter_1.CfnParameter(this, "S3VersionKey", {
          type: "String",
          description: `S3 key for asset version "${id}"`
        });
        this.artifactHashParameter = new cfn_parameter_1.CfnParameter(this, "ArtifactHash", {
          description: `Artifact hash for asset "${id}"`,
          type: "String"
        });
      }
    };
    exports.FileAssetParameters = FileAssetParameters;
  }
});

// node_modules/@aws-cdk/core/lib/stack-synthesizers/legacy.js
var require_legacy = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack-synthesizers/legacy.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.LegacyStackSynthesizer = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxschema = require_lib3();
    var cxapi = require_lib5();
    var cfn_fn_1 = require_cfn_fn();
    var construct_compat_1 = require_construct_compat();
    var asset_parameters_1 = require_asset_parameters();
    var _shared_1 = require_shared();
    var stack_synthesizer_1 = require_stack_synthesizer();
    var ASSETS_ECR_REPOSITORY_NAME = "aws-cdk/assets";
    var ASSETS_ECR_REPOSITORY_NAME_OVERRIDE_CONTEXT_KEY = "assets-ecr-repository-name";
    var LegacyStackSynthesizer = class extends stack_synthesizer_1.StackSynthesizer {
      constructor() {
        super(...arguments);
        this.cycle = false;
        this.addedImageAssets = /* @__PURE__ */ new Set();
      }
      bind(stack) {
        if (this.stack !== void 0) {
          throw new Error("A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack");
        }
        this.stack = stack;
      }
      addFileAsset(asset) {
        _shared_1.assertBound(this.stack);
        if (this.cycle) {
          return this.doAddFileAsset(asset);
        }
        this.cycle = true;
        try {
          return this.stack.addFileAsset(asset);
        } finally {
          this.cycle = false;
        }
      }
      addDockerImageAsset(asset) {
        _shared_1.assertBound(this.stack);
        if (this.cycle) {
          return this.doAddDockerImageAsset(asset);
        }
        this.cycle = true;
        try {
          return this.stack.addDockerImageAsset(asset);
        } finally {
          this.cycle = false;
        }
      }
      synthesize(session) {
        _shared_1.assertBound(this.stack);
        this.synthesizeStackTemplate(this.stack, session);
        this.emitStackArtifact(this.stack, session);
      }
      doAddDockerImageAsset(asset) {
        var _b, _c;
        _shared_1.assertBound(this.stack);
        const repositoryNameOverride = this.stack.node.tryGetContext(ASSETS_ECR_REPOSITORY_NAME_OVERRIDE_CONTEXT_KEY);
        const repositoryName = (_c = (_b = asset.repositoryName) !== null && _b !== void 0 ? _b : repositoryNameOverride) !== null && _c !== void 0 ? _c : ASSETS_ECR_REPOSITORY_NAME;
        const imageTag = asset.sourceHash;
        const assetId = asset.sourceHash;
        if (!this.addedImageAssets.has(assetId)) {
          if (!asset.directoryName) {
            throw new Error(`LegacyStackSynthesizer does not support this type of file asset: ${JSON.stringify(asset)}`);
          }
          const metadata = {
            repositoryName,
            imageTag,
            id: assetId,
            packaging: "container-image",
            path: asset.directoryName,
            sourceHash: asset.sourceHash,
            buildArgs: asset.dockerBuildArgs,
            target: asset.dockerBuildTarget,
            file: asset.dockerFile
          };
          this.stack.node.addMetadata(cxschema.ArtifactMetadataEntryType.ASSET, metadata);
          this.addedImageAssets.add(assetId);
        }
        return {
          imageUri: `${this.stack.account}.dkr.ecr.${this.stack.region}.${this.stack.urlSuffix}/${repositoryName}:${imageTag}`,
          repositoryName
        };
      }
      doAddFileAsset(asset) {
        _shared_1.assertBound(this.stack);
        let params = this.assetParameters.node.tryFindChild(asset.sourceHash);
        if (!params) {
          params = new asset_parameters_1.FileAssetParameters(this.assetParameters, asset.sourceHash);
          if (!asset.fileName || !asset.packaging) {
            throw new Error(`LegacyStackSynthesizer does not support this type of file asset: ${JSON.stringify(asset)}`);
          }
          const metadata = {
            path: asset.fileName,
            id: asset.sourceHash,
            packaging: asset.packaging,
            sourceHash: asset.sourceHash,
            s3BucketParameter: params.bucketNameParameter.logicalId,
            s3KeyParameter: params.objectKeyParameter.logicalId,
            artifactHashParameter: params.artifactHashParameter.logicalId
          };
          this.stack.node.addMetadata(cxschema.ArtifactMetadataEntryType.ASSET, metadata);
        }
        const bucketName = params.bucketNameParameter.valueAsString;
        const encodedKey = params.objectKeyParameter.valueAsString;
        const s3Prefix = cfn_fn_1.Fn.select(0, cfn_fn_1.Fn.split(cxapi.ASSET_PREFIX_SEPARATOR, encodedKey));
        const s3Filename = cfn_fn_1.Fn.select(1, cfn_fn_1.Fn.split(cxapi.ASSET_PREFIX_SEPARATOR, encodedKey));
        const objectKey = `${s3Prefix}${s3Filename}`;
        const httpUrl = `https://s3.${this.stack.region}.${this.stack.urlSuffix}/${bucketName}/${objectKey}`;
        const s3ObjectUrl = `s3://${bucketName}/${objectKey}`;
        return { bucketName, objectKey, httpUrl, s3ObjectUrl, s3Url: httpUrl };
      }
      get assetParameters() {
        _shared_1.assertBound(this.stack);
        if (!this._assetParameters) {
          this._assetParameters = new construct_compat_1.Construct(this.stack, "AssetParameters");
        }
        return this._assetParameters;
      }
    };
    exports.LegacyStackSynthesizer = LegacyStackSynthesizer;
    _a = JSII_RTTI_SYMBOL_1;
    LegacyStackSynthesizer[_a] = { fqn: "@aws-cdk/core.LegacyStackSynthesizer", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/stack-synthesizers/bootstrapless-synthesizer.js
var require_bootstrapless_synthesizer = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack-synthesizers/bootstrapless-synthesizer.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.BootstraplessSynthesizer = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var _shared_1 = require_shared();
    var default_synthesizer_1 = require_default_synthesizer();
    var BootstraplessSynthesizer = class extends default_synthesizer_1.DefaultStackSynthesizer {
      constructor(props) {
        super({
          deployRoleArn: props.deployRoleArn,
          cloudFormationExecutionRole: props.cloudFormationExecutionRoleArn,
          generateBootstrapVersionRule: false
        });
      }
      addFileAsset(_asset) {
        throw new Error("Cannot add assets to a Stack that uses the BootstraplessSynthesizer");
      }
      addDockerImageAsset(_asset) {
        throw new Error("Cannot add assets to a Stack that uses the BootstraplessSynthesizer");
      }
      synthesize(session) {
        _shared_1.assertBound(this.stack);
        this.synthesizeStackTemplate(this.stack, session);
        this.emitStackArtifact(this.stack, session, {
          assumeRoleArn: this.deployRoleArn,
          cloudFormationExecutionRoleArn: this.cloudFormationExecutionRoleArn
        });
      }
    };
    exports.BootstraplessSynthesizer = BootstraplessSynthesizer;
    _a = JSII_RTTI_SYMBOL_1;
    BootstraplessSynthesizer[_a] = { fqn: "@aws-cdk/core.BootstraplessSynthesizer", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/stack-synthesizers/nested.js
var require_nested = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack-synthesizers/nested.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.NestedStackSynthesizer = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var _shared_1 = require_shared();
    var stack_synthesizer_1 = require_stack_synthesizer();
    var NestedStackSynthesizer = class extends stack_synthesizer_1.StackSynthesizer {
      constructor(parentDeployment) {
        super();
        this.parentDeployment = parentDeployment;
      }
      bind(stack) {
        if (this.stack !== void 0) {
          throw new Error("A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack");
        }
        this.stack = stack;
      }
      addFileAsset(asset) {
        return this.parentDeployment.addFileAsset(asset);
      }
      addDockerImageAsset(asset) {
        return this.parentDeployment.addDockerImageAsset(asset);
      }
      synthesize(session) {
        _shared_1.assertBound(this.stack);
        this.synthesizeStackTemplate(this.stack, session);
      }
    };
    exports.NestedStackSynthesizer = NestedStackSynthesizer;
    _a = JSII_RTTI_SYMBOL_1;
    NestedStackSynthesizer[_a] = { fqn: "@aws-cdk/core.NestedStackSynthesizer", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/stack-synthesizers/index.js
var require_stack_synthesizers = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack-synthesizers/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_types(), exports);
    __exportStar(require_default_synthesizer(), exports);
    __exportStar(require_legacy(), exports);
    __exportStar(require_bootstrapless_synthesizer(), exports);
    __exportStar(require_nested(), exports);
    __exportStar(require_stack_synthesizer(), exports);
  }
});

// node_modules/@aws-cdk/core/lib/private/refs.js
var require_refs = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/refs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.referenceNestedStackValueInParent = exports.resolveReferences = void 0;
    var cfn_element_1 = require_cfn_element();
    var cfn_output_1 = require_cfn_output();
    var cfn_parameter_1 = require_cfn_parameter();
    var names_1 = require_names();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var cfn_reference_1 = require_cfn_reference();
    var resolve_1 = require_resolve();
    function resolveReferences(scope) {
      const edges = findAllReferences(scope);
      for (const { source, value } of edges) {
        const consumer = stack_1.Stack.of(source);
        if (!value.hasValueForStack(consumer)) {
          const resolved = resolveValue(consumer, value);
          value.assignValueForStack(consumer, resolved);
        }
      }
    }
    exports.resolveReferences = resolveReferences;
    function resolveValue(consumer, reference) {
      const producer = stack_1.Stack.of(reference.target);
      if (producer === consumer) {
        return reference;
      }
      if (producer.node.root !== consumer.node.root) {
        throw new Error("Cannot reference across apps. Consuming and producing stacks must be defined within the same CDK app.");
      }
      if (producer.environment !== consumer.environment) {
        throw new Error(`Stack "${consumer.node.path}" cannot consume a cross reference from stack "${producer.node.path}". Cross stack references are only supported for stacks deployed to the same environment or between nested stacks and their parent stack`);
      }
      if (consumer.nestedStackParent && isNested(consumer, producer)) {
        const parameterValue = resolveValue(consumer.nestedStackParent, reference);
        return createNestedStackParameter(consumer, reference, parameterValue);
      }
      if (producer.nested) {
        const outputValue = createNestedStackOutput(producer, reference);
        return resolveValue(consumer, outputValue);
      }
      consumer.addDependency(producer, `${consumer.node.path} -> ${reference.target.node.path}.${reference.displayName}`);
      return createImportValue(reference);
    }
    function findAllReferences(root) {
      const result = new Array();
      for (const consumer of root.node.findAll()) {
        if (!cfn_element_1.CfnElement.isCfnElement(consumer)) {
          continue;
        }
        try {
          const tokens = resolve_1.findTokens(consumer, () => consumer._toCloudFormation());
          for (const token of tokens) {
            if (!cfn_reference_1.CfnReference.isCfnReference(token)) {
              continue;
            }
            result.push({
              source: consumer,
              value: token
            });
          }
        } catch (e) {
          if (e.type === "CfnSynthesisError") {
            continue;
          }
          throw e;
        }
      }
      return result;
    }
    function createImportValue(reference) {
      const exportingStack = stack_1.Stack.of(reference.target);
      const importExpr = exportingStack.exportValue(reference);
      return token_1.Tokenization.reverseCompleteString(importExpr);
    }
    function createNestedStackParameter(nested, reference, value) {
      const paramId = generateUniqueId(nested, reference, "reference-to-");
      let param = nested.node.tryFindChild(paramId);
      if (!param) {
        param = new cfn_parameter_1.CfnParameter(nested, paramId, { type: "String" });
        if (!("setParameter" in nested)) {
          throw new Error('assertion failed: nested stack should have a "setParameter" method');
        }
        nested.setParameter(param.logicalId, token_1.Token.asString(value));
      }
      return param.value;
    }
    function createNestedStackOutput(producer, reference) {
      const outputId = generateUniqueId(producer, reference);
      let output = producer.node.tryFindChild(outputId);
      if (!output) {
        output = new cfn_output_1.CfnOutput(producer, outputId, { value: token_1.Token.asString(reference) });
      }
      if (!producer.nestedStackResource) {
        throw new Error("assertion failed");
      }
      return producer.nestedStackResource.getAtt(`Outputs.${output.logicalId}`);
    }
    function referenceNestedStackValueInParent(reference, targetStack) {
      let currentStack = stack_1.Stack.of(reference.target);
      if (currentStack !== targetStack && !isNested(currentStack, targetStack)) {
        throw new Error(`Referenced resource must be in stack '${targetStack.node.path}', got '${reference.target.node.path}'`);
      }
      while (currentStack !== targetStack) {
        reference = createNestedStackOutput(stack_1.Stack.of(reference.target), reference);
        currentStack = stack_1.Stack.of(reference.target);
      }
      return reference;
    }
    exports.referenceNestedStackValueInParent = referenceNestedStackValueInParent;
    function isNested(nested, parent) {
      if (nested.nestedStackParent === parent) {
        return true;
      }
      if (!nested.nestedStackParent) {
        return false;
      }
      return isNested(nested.nestedStackParent, parent);
    }
    function generateUniqueId(stack, ref, prefix = "") {
      return stack.resolve(`${prefix}${names_1.Names.nodeUniqueId(ref.target.node)}${ref.displayName}`);
    }
  }
});

// node_modules/@aws-cdk/core/lib/stack.js
var require_stack = __commonJS({
  "node_modules/@aws-cdk/core/lib/stack.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.rootPathTo = exports.Stack = exports.STACK_RESOURCE_LIMIT_CONTEXT = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var cxschema = require_lib3();
    var cxapi = require_lib5();
    var constructs_1 = require_lib4();
    var annotations_1 = require_annotations();
    var app_1 = require_app2();
    var arn_1 = require_arn();
    var cfn_element_1 = require_cfn_element();
    var cfn_fn_1 = require_cfn_fn();
    var cfn_pseudo_1 = require_cfn_pseudo();
    var cfn_resource_1 = require_cfn_resource();
    var context_provider_1 = require_context_provider();
    var feature_flags_1 = require_feature_flags();
    var cloudformation_lang_1 = require_cloudformation_lang();
    var logical_id_1 = require_logical_id();
    var resolve_1 = require_resolve();
    var uniqueid_1 = require_uniqueid2();
    var construct_compat_1 = require_construct_compat();
    var STACK_SYMBOL = Symbol.for("@aws-cdk/core.Stack");
    var MY_STACK_CACHE = Symbol.for("@aws-cdk/core.Stack.myStack");
    exports.STACK_RESOURCE_LIMIT_CONTEXT = "@aws-cdk/core:stackResourceLimit";
    var VALID_STACK_NAME_REGEX = /^[A-Za-z][A-Za-z0-9-]*$/;
    var MAX_RESOURCES = 500;
    var Stack = class extends construct_compat_1.Construct {
      constructor(scope, id, props = {}) {
        var _b, _c, _d;
        scope = scope !== null && scope !== void 0 ? scope : new app_1.App({
          autoSynth: false,
          outdir: fs_1.FileSystem.mkdtemp("cdk-test-app-")
        });
        id = id !== null && id !== void 0 ? id : "Default";
        super(scope, id);
        this._missingContext = new Array();
        this._stackDependencies = {};
        this.templateOptions = {};
        Object.defineProperty(this, STACK_SYMBOL, { value: true });
        this._logicalIds = new logical_id_1.LogicalIDs();
        const { account, region, environment } = this.parseEnvironment(props.env);
        this.account = account;
        this.region = region;
        this.environment = environment;
        this.terminationProtection = props.terminationProtection;
        if (props.description !== void 0) {
          if (props.description.length > 512) {
            throw new Error(`Stack description must be <= 1024 bytes. Received description: '${props.description}'`);
          }
          this.templateOptions.description = props.description;
        }
        this._stackName = (_b = props.stackName) !== null && _b !== void 0 ? _b : this.generateStackName();
        this.tags = new tag_manager_1.TagManager(cfn_resource_1.TagType.KEY_VALUE, "aws:cdk:stack", props.tags);
        if (!VALID_STACK_NAME_REGEX.test(this.stackName)) {
          throw new Error(`Stack name must match the regular expression: ${VALID_STACK_NAME_REGEX.toString()}, got '${this.stackName}'`);
        }
        const featureFlags = feature_flags_1.FeatureFlags.of(this);
        const stackNameDupeContext = featureFlags.isEnabled(cxapi.ENABLE_STACK_NAME_DUPLICATES_CONTEXT);
        const newStyleSynthesisContext = featureFlags.isEnabled(cxapi.NEW_STYLE_STACK_SYNTHESIS_CONTEXT);
        this.artifactId = stackNameDupeContext || newStyleSynthesisContext ? this.generateStackArtifactId() : this.stackName;
        this.templateFile = `${this.artifactId}.template.json`;
        this._versionReportingEnabled = ((_c = props.analyticsReporting) !== null && _c !== void 0 ? _c : this.node.tryGetContext(cxapi.ANALYTICS_REPORTING_ENABLED_CONTEXT)) && !this.nestedStackParent;
        this.synthesizer = (_d = props.synthesizer) !== null && _d !== void 0 ? _d : newStyleSynthesisContext ? new stack_synthesizers_1.DefaultStackSynthesizer() : new stack_synthesizers_1.LegacyStackSynthesizer();
        this.synthesizer.bind(this);
      }
      static isStack(x) {
        return x !== null && typeof x === "object" && STACK_SYMBOL in x;
      }
      static of(construct) {
        const cache = construct[MY_STACK_CACHE];
        if (cache) {
          return cache;
        } else {
          const value = _lookup(construct);
          Object.defineProperty(construct, MY_STACK_CACHE, {
            enumerable: false,
            writable: false,
            configurable: false,
            value
          });
          return value;
        }
        function _lookup(c) {
          var _b, _c;
          if (Stack.isStack(c)) {
            return c;
          }
          const _scope = constructs_1.Node.of(c).scope;
          if (stage_1.Stage.isStage(c) || !_scope) {
            throw new Error(`${(_c = (_b = construct.constructor) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : "Construct"} at '${constructs_1.Node.of(construct).path}' should be created in the scope of a Stack, but no Stack found`);
          }
          return _lookup(_scope);
        }
      }
      resolve(obj) {
        return resolve_1.resolve(obj, {
          scope: this,
          prefix: [],
          resolver: cloudformation_lang_1.CLOUDFORMATION_TOKEN_RESOLVER,
          preparing: false
        });
      }
      toJsonString(obj, space) {
        return cloudformation_lang_1.CloudFormationLang.toJSON(obj, space).toString();
      }
      reportMissingContext(report) {
        if (!Object.values(cxschema.ContextProvider).includes(report.provider)) {
          throw new Error(`Unknown context provider requested in: ${JSON.stringify(report)}`);
        }
        this.reportMissingContextKey(report);
      }
      reportMissingContextKey(report) {
        this._missingContext.push(report);
      }
      renameLogicalId(oldId, newId) {
        this._logicalIds.addRename(oldId, newId);
      }
      getLogicalId(element) {
        const logicalId = this.allocateLogicalId(element);
        return this._logicalIds.applyRename(logicalId);
      }
      addDependency(target, reason) {
        deps_1.addDependency(this, target, reason);
      }
      get dependencies() {
        return Object.values(this._stackDependencies).map((x) => x.stack);
      }
      get stackName() {
        return this._stackName;
      }
      get partition() {
        return cfn_pseudo_1.Aws.PARTITION;
      }
      get urlSuffix() {
        return cfn_pseudo_1.Aws.URL_SUFFIX;
      }
      get stackId() {
        return new cfn_pseudo_1.ScopedAws(this).stackId;
      }
      get notificationArns() {
        return new cfn_pseudo_1.ScopedAws(this).notificationArns;
      }
      get nested() {
        return this.nestedStackResource !== void 0;
      }
      formatArn(components) {
        return arn_1.Arn.format(components, this);
      }
      parseArn(arn, sepIfToken = "/", hasName = true) {
        return arn_1.Arn.parse(arn, sepIfToken, hasName);
      }
      splitArn(arn, arnFormat) {
        return arn_1.Arn.split(arn, arnFormat);
      }
      get availabilityZones() {
        const agnostic = token_1.Token.isUnresolved(this.account) || token_1.Token.isUnresolved(this.region);
        if (agnostic) {
          return this.node.tryGetContext(cxapi.AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY) || [
            cfn_fn_1.Fn.select(0, cfn_fn_1.Fn.getAzs()),
            cfn_fn_1.Fn.select(1, cfn_fn_1.Fn.getAzs())
          ];
        }
        const value = context_provider_1.ContextProvider.getValue(this, {
          provider: cxschema.ContextProvider.AVAILABILITY_ZONE_PROVIDER,
          dummyValue: ["dummy1a", "dummy1b", "dummy1c"]
        }).value;
        if (!Array.isArray(value)) {
          throw new Error(`Provider ${cxschema.ContextProvider.AVAILABILITY_ZONE_PROVIDER} expects a list`);
        }
        return value;
      }
      addFileAsset(asset) {
        return this.synthesizer.addFileAsset(asset);
      }
      addDockerImageAsset(asset) {
        return this.synthesizer.addDockerImageAsset(asset);
      }
      get nestedStackParent() {
        return this.nestedStackResource && Stack.of(this.nestedStackResource);
      }
      get parentStack() {
        return this.nestedStackParent;
      }
      addTransform(transform) {
        if (!this.templateOptions.transforms) {
          this.templateOptions.transforms = [];
        }
        this.templateOptions.transforms.push(transform);
      }
      _addAssemblyDependency(target, reason) {
        if (this.nested || target.nested) {
          throw new Error("Cannot add assembly-level dependencies for nested stacks");
        }
        reason = reason || "dependency added using stack.addDependency()";
        const cycle = target.stackDependencyReasons(this);
        if (cycle !== void 0) {
          throw new Error(`'${target.node.path}' depends on '${this.node.path}' (${cycle.join(", ")}). Adding this dependency (${reason}) would create a cyclic reference.`);
        }
        let dep = this._stackDependencies[names_1.Names.uniqueId(target)];
        if (!dep) {
          dep = this._stackDependencies[names_1.Names.uniqueId(target)] = {
            stack: target,
            reasons: []
          };
        }
        dep.reasons.push(reason);
        if (process.env.CDK_DEBUG_DEPS) {
          console.error(`[CDK_DEBUG_DEPS] stack "${this.node.path}" depends on "${target.node.path}" because: ${reason}`);
        }
      }
      _synthesizeTemplate(session, lookupRoleArn) {
        const builder = session.assembly;
        const template = this._toCloudFormation();
        const outPath = path.join(builder.outdir, this.templateFile);
        if (this.maxResources > 0) {
          const resources = template.Resources || {};
          const numberOfResources = Object.keys(resources).length;
          if (numberOfResources > this.maxResources) {
            throw new Error(`Number of resources in stack '${this.node.path}': ${numberOfResources} is greater than allowed maximum of ${this.maxResources}`);
          } else if (numberOfResources >= this.maxResources * 0.8) {
            annotations_1.Annotations.of(this).addInfo(`Number of resources: ${numberOfResources} is approaching allowed maximum of ${this.maxResources}`);
          }
        }
        fs.writeFileSync(outPath, JSON.stringify(template, void 0, 2));
        for (const ctx of this._missingContext) {
          if (lookupRoleArn != null) {
            builder.addMissing(__spreadProps(__spreadValues({}, ctx), { props: __spreadProps(__spreadValues({}, ctx.props), { lookupRoleArn }) }));
          } else {
            builder.addMissing(ctx);
          }
        }
      }
      exportValue(exportedValue, options = {}) {
        if (options.name) {
          new cfn_output_1.CfnOutput(this, `Export${options.name}`, {
            value: exportedValue,
            exportName: options.name
          });
          return cfn_fn_1.Fn.importValue(options.name);
        }
        const resolvable = token_1.Tokenization.reverse(exportedValue);
        if (!resolvable || !reference_1.Reference.isReference(resolvable)) {
          throw new Error("exportValue: either supply 'name' or make sure to export a resource attribute (like 'bucket.bucketName')");
        }
        const exportable = refs_1.referenceNestedStackValueInParent(resolvable, this);
        const exportsScope = getCreateExportsScope(this);
        const resolved = this.resolve(exportable);
        const id = "Output" + JSON.stringify(resolved);
        const exportName = generateExportName(exportsScope, id);
        if (token_1.Token.isUnresolved(exportName)) {
          throw new Error(`unresolved token in generated export name: ${JSON.stringify(this.resolve(exportName))}`);
        }
        const output = exportsScope.node.tryFindChild(id);
        if (!output) {
          new cfn_output_1.CfnOutput(exportsScope, id, { value: token_1.Token.asString(exportable), exportName });
        }
        return cfn_fn_1.Fn.importValue(exportName);
      }
      allocateLogicalId(cfnElement) {
        const scopes = cfnElement.node.scopes;
        const stackIndex = scopes.indexOf(cfnElement.stack);
        const pathComponents = scopes.slice(stackIndex + 1).map((x) => x.node.id);
        return uniqueid_1.makeUniqueId(pathComponents);
      }
      _validateId(name) {
        if (name && !VALID_STACK_NAME_REGEX.test(name)) {
          throw new Error(`Stack name must match the regular expression: ${VALID_STACK_NAME_REGEX.toString()}, got '${name}'`);
        }
      }
      _toCloudFormation() {
        let transform;
        if (this.templateOptions.transform) {
          annotations_1.Annotations.of(this).addWarning("This stack is using the deprecated `templateOptions.transform` property. Consider switching to `addTransform()`.");
          this.addTransform(this.templateOptions.transform);
        }
        if (this.templateOptions.transforms) {
          if (this.templateOptions.transforms.length === 1) {
            transform = this.templateOptions.transforms[0];
          } else {
            transform = Array.from(new Set(this.templateOptions.transforms));
          }
        }
        const template = {
          Description: this.templateOptions.description,
          Transform: transform,
          AWSTemplateFormatVersion: this.templateOptions.templateFormatVersion,
          Metadata: this.templateOptions.metadata
        };
        const elements = cfnElements(this);
        const fragments = elements.map((e) => this.resolve(e._toCloudFormation()));
        for (const fragment of fragments) {
          merge(template, fragment);
        }
        const ret = this.resolve(template) || {};
        this._logicalIds.assertAllRenamesApplied();
        return ret;
      }
      prepareCrossReference(_sourceStack, reference) {
        return reference;
      }
      parseEnvironment(env2 = {}) {
        var _b, _c, _d, _e;
        const containingAssembly = stage_1.Stage.of(this);
        const account = (_c = (_b = env2.account) !== null && _b !== void 0 ? _b : containingAssembly === null || containingAssembly === void 0 ? void 0 : containingAssembly.account) !== null && _c !== void 0 ? _c : cfn_pseudo_1.Aws.ACCOUNT_ID;
        const region = (_e = (_d = env2.region) !== null && _d !== void 0 ? _d : containingAssembly === null || containingAssembly === void 0 ? void 0 : containingAssembly.region) !== null && _e !== void 0 ? _e : cfn_pseudo_1.Aws.REGION;
        const envAccount = !token_1.Token.isUnresolved(account) ? account : cxapi.UNKNOWN_ACCOUNT;
        const envRegion = !token_1.Token.isUnresolved(region) ? region : cxapi.UNKNOWN_REGION;
        return {
          account,
          region,
          environment: cxapi.EnvironmentUtils.format(envAccount, envRegion)
        };
      }
      get maxResources() {
        const contextLimit = this.node.tryGetContext(exports.STACK_RESOURCE_LIMIT_CONTEXT);
        return contextLimit !== void 0 ? parseInt(contextLimit, 10) : MAX_RESOURCES;
      }
      stackDependencyReasons(other) {
        if (this === other) {
          return [];
        }
        for (const dep of Object.values(this._stackDependencies)) {
          const ret = dep.stack.stackDependencyReasons(other);
          if (ret !== void 0) {
            return [...dep.reasons, ...ret];
          }
        }
        return void 0;
      }
      generateStackName() {
        const assembly = stage_1.Stage.of(this);
        const prefix = assembly && assembly.stageName ? `${assembly.stageName}-` : "";
        return `${prefix}${this.generateStackId(assembly)}`;
      }
      generateStackArtifactId() {
        return this.generateStackId(this.node.root);
      }
      generateStackId(container) {
        const rootPath = rootPathTo(this, container);
        const ids = rootPath.map((c) => constructs_1.Node.of(c).id);
        if (ids.length === 1 && !ids[0]) {
          throw new Error("unexpected: stack id must always be defined");
        }
        return makeStackName(ids);
      }
    };
    exports.Stack = Stack;
    _a = JSII_RTTI_SYMBOL_1;
    Stack[_a] = { fqn: "@aws-cdk/core.Stack", version: "1.128.0" };
    function merge(template, fragment) {
      for (const section of Object.keys(fragment)) {
        const src = fragment[section];
        const dest = template[section];
        if (!dest) {
          template[section] = src;
        } else {
          template[section] = mergeSection(section, dest, src);
        }
      }
    }
    function mergeSection(section, val1, val2) {
      switch (section) {
        case "Description":
          return `${val1}
${val2}`;
        case "AWSTemplateFormatVersion":
          if (val1 != null && val2 != null && val1 !== val2) {
            throw new Error(`Conflicting CloudFormation template versions provided: '${val1}' and '${val2}`);
          }
          return val1 !== null && val1 !== void 0 ? val1 : val2;
        case "Transform":
          return mergeSets(val1, val2);
        default:
          return mergeObjectsWithoutDuplicates(section, val1, val2);
      }
    }
    function mergeSets(val1, val2) {
      const array1 = val1 == null ? [] : Array.isArray(val1) ? val1 : [val1];
      const array2 = val2 == null ? [] : Array.isArray(val2) ? val2 : [val2];
      for (const value of array2) {
        if (!array1.includes(value)) {
          array1.push(value);
        }
      }
      return array1.length === 1 ? array1[0] : array1;
    }
    function mergeObjectsWithoutDuplicates(section, dest, src) {
      if (typeof dest !== "object") {
        throw new Error(`Expecting ${JSON.stringify(dest)} to be an object`);
      }
      if (typeof src !== "object") {
        throw new Error(`Expecting ${JSON.stringify(src)} to be an object`);
      }
      for (const id of Object.keys(src)) {
        if (id in dest) {
          throw new Error(`section '${section}' already contains '${id}'`);
        }
        dest[id] = src[id];
      }
      return dest;
    }
    function cfnElements(node, into = []) {
      if (cfn_element_1.CfnElement.isCfnElement(node)) {
        into.push(node);
      }
      for (const child of constructs_1.Node.of(node).children) {
        if (Stack.isStack(child)) {
          continue;
        }
        cfnElements(child, into);
      }
      return into;
    }
    function rootPathTo(construct, ancestor) {
      const scopes = constructs_1.Node.of(construct).scopes;
      for (let i = scopes.length - 2; i >= 0; i--) {
        if (scopes[i] === ancestor) {
          return scopes.slice(i + 1);
        }
      }
      return scopes;
    }
    exports.rootPathTo = rootPathTo;
    function makeStackName(components) {
      if (components.length === 1) {
        return components[0];
      }
      return uniqueid_1.makeUniqueId(components);
    }
    function getCreateExportsScope(stack) {
      const exportsName = "Exports";
      let stackExports = stack.node.tryFindChild(exportsName);
      if (stackExports === void 0) {
        stackExports = new construct_compat_1.Construct(stack, exportsName);
      }
      return stackExports;
    }
    function generateExportName(stackExports, id) {
      const stackRelativeExports = feature_flags_1.FeatureFlags.of(stackExports).isEnabled(cxapi.STACK_RELATIVE_EXPORTS_CONTEXT);
      const stack = Stack.of(stackExports);
      const components = [
        ...stackExports.node.scopes.slice(stackRelativeExports ? stack.node.scopes.length : 2).map((c) => c.node.id),
        id
      ];
      const prefix = stack.stackName ? stack.stackName + ":" : "";
      const localPart = uniqueid_1.makeUniqueId(components);
      const maxLength = 255;
      return prefix + localPart.slice(Math.max(0, localPart.length - maxLength + prefix.length));
    }
    var cfn_output_1 = require_cfn_output();
    var deps_1 = require_deps();
    var fs_1 = require_fs2();
    var names_1 = require_names();
    var reference_1 = require_reference();
    var stack_synthesizers_1 = require_stack_synthesizers();
    var stage_1 = require_stage();
    var tag_manager_1 = require_tag_manager();
    var token_1 = require_token();
    var refs_1 = require_refs();
  }
});

// node_modules/@aws-cdk/region-info/lib/default.js
var require_default = __commonJS({
  "node_modules/@aws-cdk/region-info/lib/default.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Default = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var Default = class {
      constructor() {
      }
      static servicePrincipal(service, region, urlSuffix) {
        const matches = service.match(/^([^.]+)(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))?$/);
        if (!matches) {
          return service;
        }
        service = matches[1];
        const US_ISO_EXCEPTIONS = /* @__PURE__ */ new Set([
          "cloudhsm",
          "config",
          "states",
          "workspaces"
        ]);
        const US_ISOB_EXCEPTIONS = /* @__PURE__ */ new Set([
          "dms",
          "states"
        ]);
        if (region.startsWith("us-iso-") && US_ISO_EXCEPTIONS.has(service)) {
          switch (service) {
            case "states":
              return `${service}.amazonaws.com`;
            default:
              return `${service}.${urlSuffix}`;
          }
        }
        if (region.startsWith("us-isob-") && US_ISOB_EXCEPTIONS.has(service)) {
          switch (service) {
            case "states":
              return `${service}.amazonaws.com`;
            default:
              return `${service}.${urlSuffix}`;
          }
        }
        switch (service) {
          case "codedeploy":
          case "logs":
            return `${service}.${region}.${urlSuffix}`;
          case "states":
            return `${service}.${region}.amazonaws.com`;
          case "ec2":
            return `${service}.${urlSuffix}`;
          default:
            return `${service}.amazonaws.com`;
        }
      }
    };
    exports.Default = Default;
    _a = JSII_RTTI_SYMBOL_1;
    Default[_a] = { fqn: "@aws-cdk/region-info.Default", version: "1.128.0" };
    Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX = "com.amazonaws.vpce";
  }
});

// node_modules/@aws-cdk/region-info/lib/fact.js
var require_fact = __commonJS({
  "node_modules/@aws-cdk/region-info/lib/fact.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.FactName = exports.Fact = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var Fact = class {
      constructor() {
        throw new Error("Use the static methods of Fact instead!");
      }
      static get regions() {
        return Object.keys(this.database);
      }
      static find(region, name) {
        const regionFacts = this.database[region];
        return regionFacts && regionFacts[name];
      }
      static requireFact(region, name) {
        const foundFact = this.find(region, name);
        if (!foundFact) {
          throw new Error(`No fact ${name} could be found for region: ${region} and name: ${name}`);
        }
        return foundFact;
      }
      static register(fact, allowReplacing = false) {
        const regionFacts = this.database[fact.region] || (this.database[fact.region] = {});
        if (fact.name in regionFacts && regionFacts[fact.name] !== fact.value && !allowReplacing) {
          throw new Error(`Region ${fact.region} already has a fact ${fact.name}, with value ${regionFacts[fact.name]}`);
        }
        if (fact.value !== void 0) {
          regionFacts[fact.name] = fact.value;
        }
      }
      static unregister(region, name, value) {
        const regionFacts = this.database[region] || {};
        if (name in regionFacts && value && regionFacts[name] !== value) {
          throw new Error(`Attempted to remove ${name} from ${region} with value ${value}, but the fact's value is ${regionFacts[name]}`);
        }
        delete regionFacts[name];
      }
    };
    exports.Fact = Fact;
    _a = JSII_RTTI_SYMBOL_1;
    Fact[_a] = { fqn: "@aws-cdk/region-info.Fact", version: "1.128.0" };
    Fact.database = {};
    var FactName = class {
      static cloudwatchLambdaInsightsVersion(version) {
        return `cloudwatch-lambda-insights-version:${version.split(".").join("_")}`;
      }
      static servicePrincipal(service) {
        return `service-principal:${service.replace(/\.amazonaws\.com(\.cn)?$/, "")}`;
      }
    };
    exports.FactName = FactName;
    _b = JSII_RTTI_SYMBOL_1;
    FactName[_b] = { fqn: "@aws-cdk/region-info.FactName", version: "1.128.0" };
    FactName.PARTITION = "partition";
    FactName.DOMAIN_SUFFIX = "domainSuffix";
    FactName.CDK_METADATA_RESOURCE_AVAILABLE = "cdk:metadata-resource:available";
    FactName.S3_STATIC_WEBSITE_ENDPOINT = "s3-static-website:endpoint";
    FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID = "s3-static-website:route-53-hosted-zone-id";
    FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX = "vpcEndpointServiceNamePrefix";
    FactName.ELBV2_ACCOUNT = "elbv2Account";
    FactName.DLC_REPOSITORY_ACCOUNT = "dlcRepositoryAccount";
    FactName.APPMESH_ECR_ACCOUNT = "appMeshRepositoryAccount";
    FactName.FIREHOSE_CIDR_BLOCK = "firehoseCidrBlock";
  }
});

// node_modules/@aws-cdk/region-info/lib/region-info.js
var require_region_info = __commonJS({
  "node_modules/@aws-cdk/region-info/lib/region-info.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.RegionInfo = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fact_1 = require_fact();
    var RegionInfo = class {
      constructor(name) {
        this.name = name;
      }
      static get regions() {
        return fact_1.Fact.regions.map(RegionInfo.get);
      }
      static regionMap(factName) {
        const ret = {};
        for (const regionInfo of RegionInfo.regions) {
          const fact = fact_1.Fact.find(regionInfo.name, factName);
          if (fact) {
            ret[regionInfo.name] = fact;
          }
        }
        return ret;
      }
      static get(name) {
        return new RegionInfo(name);
      }
      get cdkMetadataResourceAvailable() {
        return fact_1.Fact.find(this.name, fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE) === "YES";
      }
      get domainSuffix() {
        return fact_1.Fact.find(this.name, fact_1.FactName.DOMAIN_SUFFIX);
      }
      get partition() {
        return fact_1.Fact.find(this.name, fact_1.FactName.PARTITION);
      }
      get s3StaticWebsiteEndpoint() {
        return fact_1.Fact.find(this.name, fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT);
      }
      get s3StaticWebsiteHostedZoneId() {
        return fact_1.Fact.find(this.name, fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID);
      }
      get vpcEndpointServiceNamePrefix() {
        return fact_1.Fact.find(this.name, fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX);
      }
      servicePrincipal(service) {
        return fact_1.Fact.find(this.name, fact_1.FactName.servicePrincipal(service));
      }
      get elbv2Account() {
        return fact_1.Fact.find(this.name, fact_1.FactName.ELBV2_ACCOUNT);
      }
      get dlcRepositoryAccount() {
        return fact_1.Fact.find(this.name, fact_1.FactName.DLC_REPOSITORY_ACCOUNT);
      }
      cloudwatchLambdaInsightsArn(insightsVersion) {
        return fact_1.Fact.find(this.name, fact_1.FactName.cloudwatchLambdaInsightsVersion(insightsVersion));
      }
      get appMeshRepositoryAccount() {
        return fact_1.Fact.find(this.name, fact_1.FactName.APPMESH_ECR_ACCOUNT);
      }
      get firehoseCidrBlock() {
        return fact_1.Fact.find(this.name, fact_1.FactName.FIREHOSE_CIDR_BLOCK);
      }
    };
    exports.RegionInfo = RegionInfo;
    _a = JSII_RTTI_SYMBOL_1;
    RegionInfo[_a] = { fqn: "@aws-cdk/region-info.RegionInfo", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/region-info/lib/built-ins.generated.js
var require_built_ins_generated = __commonJS({
  "node_modules/@aws-cdk/region-info/lib/built-ins.generated.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.BuiltIns = void 0;
    var fact_1 = require_fact();
    var BuiltIns = class {
      static register() {
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.af-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z11KHD8FBVPUYU" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "098369216593" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "924023996002" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.244.121.224/27" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.af-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.af-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.af-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:8" });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ap-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "ZNB98KWMFR0R6" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "754344448648" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "871362719292" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "856666278305" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "18.162.221.32/27" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:8" });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-ap-northeast-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2M4EHUR26P7ZW" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "582318560864" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.113.196.224/27" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-northeast-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-northeast-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-northeast-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ap-northeast-2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3W03O7B5YMIYP" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "600734575887" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.209.1.64/27" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-northeast-2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-northeast-2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-northeast-2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ap-northeast-3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2YQB5RD63NC85" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.ELBV2_ACCOUNT, value: "383597477331" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.208.177.192/27" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-northeast-3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-northeast-3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-northeast-3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: void 0 });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ap-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z11RGJOFQNVJUP" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "718504428378" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.232.67.32/27" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-ap-southeast-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3O0J2DXBE1FTB" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "114774131450" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.228.64.192/27" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-southeast-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-southeast-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-southeast-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-ap-southeast-2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z1WCIGYICN2BYD" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "783225319266" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.210.67.224/27" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-southeast-2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-southeast-2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-southeast-2.amazonaws.com" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ca-central-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z1QDHH18159H29" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "985666609251" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "35.183.92.128/27" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ca-central-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ca-central-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ca-central-1.amazonaws.com" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.PARTITION, value: "aws-cn" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.cn-north-1.amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "638102146993" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "727897471807" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.81.151.32/27" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "cn.com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.cn-north-1.amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.cn-north-1.amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.cn-north-1.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:8" });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.PARTITION, value: "aws-cn" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.cn-northwest-1.amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "037604701340" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "727897471807" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "161.189.23.64/27" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "cn.com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.cn-northwest-1.amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.cn-northwest-1.amazonaws.com.cn" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.cn-northwest-1.amazonaws.com" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:8" });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-central-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z21DNDUVLTQW6Q" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "054676820928" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "35.158.127.160/27" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-central-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-central-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-central-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-north-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3BAZG2TWCNX0D" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "897822967062" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.53.63.224/27" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-north-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-north-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-north-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3IXVV8C73GIO3" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "635631232127" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "422531588944" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "15.161.135.128/27" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:8" });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-eu-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z1BKCTXD74EZPE" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "156460612806" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.19.239.192/27" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-west-2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3GKZC51ZF0DB4" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "652711504416" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "18.130.1.96/27" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-west-2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-west-2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-west-2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-west-3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3R1K369G5AVDG" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.ELBV2_ACCOUNT, value: "009996457667" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "35.180.1.96/27" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-west-3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-west-3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-west-3.amazonaws.com" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.me-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z1MPMWCPA7YB62" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "076674570225" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "217643126080" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "772975370895" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "15.185.91.0/27" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.me-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.me-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.me-south-1.amazonaws.com" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:8" });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-sa-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z7KQH4QJS55SO" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "507241528517" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "18.228.1.128/27" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.sa-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.sa-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.sa-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-us-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3AQBSTGFYJSTF" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "127311923021" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.70.63.192/27" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.us-east-2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2O1EMRO9K5GLX" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "033677994240" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.58.135.96/27" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-east-2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-east-2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-east-2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.PARTITION, value: "aws-us-gov" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.us-gov-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2NIFVYYW2VKV1" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "190560391635" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "18.253.138.96/27" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-gov-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-gov-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-gov-east-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.PARTITION, value: "aws-us-gov" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-us-gov-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z31GFT0UA1I2HV" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "048591011584" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.61.204.160/27" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-gov-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-gov-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-gov-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.PARTITION, value: "aws-iso" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "c2s.ic.gov" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.us-iso-east-1.c2s.ic.gov" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "gov.ic.c2s.vpce" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-iso-east-1.c2s.ic.gov" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.c2s.ic.gov" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-iso-east-1.c2s.ic.gov" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.amazonaws.com" });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.PARTITION, value: "aws-iso-b" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "sc2s.sgov.gov" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.us-isob-east-1.sc2s.sgov.gov" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "gov.sgov.sc2s.vpce" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-isob-east-1.sc2s.sgov.gov" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.sc2s.sgov.gov" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-isob-east-1.sc2s.sgov.gov" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.amazonaws.com" });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: void 0 });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-us-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2F56UZL2M1ACD" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "027434742980" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.57.135.192/27" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-west-1.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:2" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.PARTITION, value: "aws" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-us-west-2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3BJ6K6RIION7M" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "797873946194" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.89.255.224/27" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-west-2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-west-2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-west-2.amazonaws.com" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:14" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:12" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:11" });
        fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:2" });
      }
      constructor() {
      }
    };
    exports.BuiltIns = BuiltIns;
  }
});

// node_modules/@aws-cdk/region-info/lib/index.js
var require_lib7 = __commonJS({
  "node_modules/@aws-cdk/region-info/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_default(), exports);
    __exportStar(require_fact(), exports);
    __exportStar(require_region_info(), exports);
    var built_ins_generated_1 = require_built_ins_generated();
    built_ins_generated_1.BuiltIns.register();
  }
});

// node_modules/@aws-cdk/core/lib/cfn-condition.js
var require_cfn_condition = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-condition.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnCondition = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var CfnCondition = class extends cfn_element_1.CfnElement {
      constructor(scope, id, props) {
        super(scope, id);
        this.expression = props && props.expression;
      }
      _toCloudFormation() {
        if (!this.expression) {
          return {};
        }
        return {
          Conditions: {
            [this.logicalId]: this.expression
          }
        };
      }
      resolve(_context) {
        return { Condition: this.logicalId };
      }
    };
    exports.CfnCondition = CfnCondition;
    _a = JSII_RTTI_SYMBOL_1;
    CfnCondition[_a] = { fqn: "@aws-cdk/core.CfnCondition", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/private/metadata-resource.js
var require_metadata_resource = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/metadata-resource.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.formatAnalytics = exports.MetadataResource = void 0;
    var zlib = require("zlib");
    var region_info_1 = require_lib7();
    var cfn_condition_1 = require_cfn_condition();
    var cfn_fn_1 = require_cfn_fn();
    var cfn_pseudo_1 = require_cfn_pseudo();
    var cfn_resource_1 = require_cfn_resource();
    var construct_compat_1 = require_construct_compat();
    var lazy_1 = require_lazy();
    var token_1 = require_token();
    var runtime_info_1 = require_runtime_info();
    var MetadataResource = class extends construct_compat_1.Construct {
      constructor(scope, id) {
        super(scope, id);
        const metadataServiceExists = token_1.Token.isUnresolved(scope.region) || region_info_1.RegionInfo.get(scope.region).cdkMetadataResourceAvailable;
        if (metadataServiceExists) {
          const resource = new cfn_resource_1.CfnResource(this, "Default", {
            type: "AWS::CDK::Metadata",
            properties: {
              Analytics: lazy_1.Lazy.string({ produce: () => formatAnalytics(runtime_info_1.constructInfoFromStack(scope)) })
            }
          });
          if (token_1.Token.isUnresolved(scope.region)) {
            const condition = new cfn_condition_1.CfnCondition(this, "Condition", {
              expression: makeCdkMetadataAvailableCondition()
            });
            condition.overrideLogicalId("CDKMetadataAvailable");
            resource.cfnOptions.condition = condition;
          }
        }
      }
    };
    exports.MetadataResource = MetadataResource;
    function makeCdkMetadataAvailableCondition() {
      return cfn_fn_1.Fn.conditionOr(...region_info_1.RegionInfo.regions.filter((ri) => ri.cdkMetadataResourceAvailable).map((ri) => cfn_fn_1.Fn.conditionEquals(cfn_pseudo_1.Aws.REGION, ri.name)));
    }
    var Trie = class extends Map {
    };
    function formatAnalytics(infos) {
      const trie = new Trie();
      infos.forEach((info) => insertFqnInTrie(`${info.version}!${info.fqn}`, trie));
      const plaintextEncodedConstructs = prefixEncodeTrie(trie);
      const compressedConstructsBuffer = zlib.gzipSync(Buffer.from(plaintextEncodedConstructs));
      setGzipOperatingSystemToUnknown(compressedConstructsBuffer);
      const compressedConstructs = compressedConstructsBuffer.toString("base64");
      return `v2:deflate64:${compressedConstructs}`;
    }
    exports.formatAnalytics = formatAnalytics;
    function insertFqnInTrie(fqn, trie) {
      var _a;
      for (const fqnPart of fqn.replace(/[^a-z0-9]/gi, "$& ").split(" ")) {
        const nextLevelTreeRef = (_a = trie.get(fqnPart)) !== null && _a !== void 0 ? _a : new Trie();
        trie.set(fqnPart, nextLevelTreeRef);
        trie = nextLevelTreeRef;
      }
      return trie;
    }
    function prefixEncodeTrie(trie) {
      let prefixEncoded = "";
      let isFirstEntryAtLevel = true;
      [...trie.entries()].forEach(([key, value]) => {
        if (!isFirstEntryAtLevel) {
          prefixEncoded += ",";
        }
        isFirstEntryAtLevel = false;
        prefixEncoded += key;
        if (value.size > 1) {
          prefixEncoded += "{";
          prefixEncoded += prefixEncodeTrie(value);
          prefixEncoded += "}";
        } else {
          prefixEncoded += prefixEncodeTrie(value);
        }
      });
      return prefixEncoded;
    }
    function setGzipOperatingSystemToUnknown(gzipBuffer) {
      if (gzipBuffer[0] !== 31 || gzipBuffer[1] !== 139) {
        throw new Error("Expecting a gzip buffer (must start with 0x1f8b)");
      }
      gzipBuffer[9] = 255;
    }
  }
});

// node_modules/@aws-cdk/core/lib/private/prepare-app.js
var require_prepare_app = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/prepare-app.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.prepareApp = void 0;
    var constructs_1 = require_lib4();
    var cfn_resource_1 = require_cfn_resource();
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var refs_1 = require_refs();
    function prepareApp(root) {
      for (const dependency of root.node.dependencies) {
        const targetCfnResources = findCfnResources(dependency.target);
        const sourceCfnResources = findCfnResources(dependency.source);
        for (const target of targetCfnResources) {
          for (const source of sourceCfnResources) {
            source.addDependsOn(target);
          }
        }
      }
      refs_1.resolveReferences(root);
      const queue = findAllNestedStacks(root);
      if (queue.length > 0) {
        while (queue.length > 0) {
          const nested = queue.shift();
          defineNestedStackAsset(nested);
        }
        refs_1.resolveReferences(root);
      }
    }
    exports.prepareApp = prepareApp;
    function defineNestedStackAsset(nestedStack) {
      const nested = nestedStack;
      nested._prepareTemplateAsset();
    }
    function findAllNestedStacks(root) {
      const result = new Array();
      const includeStack = (stack) => {
        if (!stack_1.Stack.isStack(stack)) {
          return false;
        }
        if (!stack.nested) {
          return false;
        }
        if (!stage_1.Stage.of(stack)) {
          return true;
        }
        return stage_1.Stage.of(stack) === root;
      };
      for (const stack of root.node.findAll(constructs_1.ConstructOrder.POSTORDER)) {
        if (includeStack(stack)) {
          result.push(stack);
        }
      }
      return result;
    }
    function findCfnResources(root) {
      return root.node.findAll().filter(cfn_resource_1.CfnResource.isCfnResource);
    }
  }
});

// node_modules/@aws-cdk/core/lib/private/synthesis.js
var require_synthesis = __commonJS({
  "node_modules/@aws-cdk/core/lib/private/synthesis.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.addCustomSynthesis = exports.synthesize = void 0;
    var cxapi = require_lib5();
    var constructs = require_lib4();
    var annotations_1 = require_annotations();
    var aspect_1 = require_aspect();
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var metadata_resource_1 = require_metadata_resource();
    var prepare_app_1 = require_prepare_app();
    var tree_metadata_1 = require_tree_metadata();
    function synthesize(root, options = {}) {
      synthNestedAssemblies(root, options);
      invokeAspects(root);
      injectMetadataResources(root);
      prepareTree(root);
      prepare_app_1.prepareApp(root);
      if (!options.skipValidation) {
        validateTree(root);
      }
      const builder = stage_1.Stage.isStage(root) ? root._assemblyBuilder : new cxapi.CloudAssemblyBuilder(options.outdir);
      synthesizeTree(root, builder, options.validateOnSynthesis);
      return builder.buildAssembly();
    }
    exports.synthesize = synthesize;
    var CUSTOM_SYNTHESIS_SYM = Symbol.for("@aws-cdk/core:customSynthesis");
    function addCustomSynthesis(construct, synthesis) {
      Object.defineProperty(construct, CUSTOM_SYNTHESIS_SYM, {
        value: synthesis,
        enumerable: false
      });
    }
    exports.addCustomSynthesis = addCustomSynthesis;
    function getCustomSynthesis(construct) {
      return construct[CUSTOM_SYNTHESIS_SYM];
    }
    function synthNestedAssemblies(root, options) {
      for (const child of root.node.children) {
        if (stage_1.Stage.isStage(child)) {
          child.synth(options);
        } else {
          synthNestedAssemblies(child, options);
        }
      }
    }
    function invokeAspects(root) {
      const invokedByPath = {};
      let nestedAspectWarning = false;
      recurse(root, []);
      function recurse(construct, inheritedAspects) {
        const node = construct.node;
        const aspects = aspect_1.Aspects.of(construct);
        const allAspectsHere = [...inheritedAspects !== null && inheritedAspects !== void 0 ? inheritedAspects : [], ...aspects.aspects];
        const nodeAspectsCount = aspects.aspects.length;
        for (const aspect of allAspectsHere) {
          let invoked = invokedByPath[node.path];
          if (!invoked) {
            invoked = invokedByPath[node.path] = [];
          }
          if (invoked.includes(aspect)) {
            continue;
          }
          aspect.visit(construct);
          if (!nestedAspectWarning && nodeAspectsCount !== aspects.aspects.length) {
            annotations_1.Annotations.of(construct).addWarning("We detected an Aspect was added via another Aspect, and will not be applied");
            nestedAspectWarning = true;
          }
          invoked.push(aspect);
        }
        for (const child of construct.node.children) {
          if (!stage_1.Stage.isStage(child)) {
            recurse(child, allAspectsHere);
          }
        }
      }
    }
    function prepareTree(root) {
      visit(root, "post", (construct) => construct.onPrepare());
    }
    function injectMetadataResources(root) {
      visit(root, "post", (construct) => {
        if (!stack_1.Stack.isStack(construct) || !construct._versionReportingEnabled) {
          return;
        }
        const CDKMetadata = "CDKMetadata";
        if (construct.node.tryFindChild(CDKMetadata)) {
          return;
        }
        new metadata_resource_1.MetadataResource(construct, CDKMetadata);
      });
    }
    function synthesizeTree(root, builder, validateOnSynth = false) {
      visit(root, "post", (construct) => {
        const session = {
          outdir: builder.outdir,
          assembly: builder,
          validateOnSynth
        };
        if (stack_1.Stack.isStack(construct)) {
          construct.synthesizer.synthesize(session);
        } else if (construct instanceof tree_metadata_1.TreeMetadata) {
          construct._synthesizeTree(session);
        } else {
          const custom = getCustomSynthesis(construct);
          custom === null || custom === void 0 ? void 0 : custom.onSynthesize(session);
        }
        construct.onSynthesize(session);
      });
    }
    function validateTree(root) {
      const errors = new Array();
      errors.push(...constructs.Node.of(root).validate().map((e) => ({
        message: e.message,
        source: e.source
      })));
      if (errors.length > 0) {
        const errorList = errors.map((e) => `[${e.source.node.path}] ${e.message}`).join("\n  ");
        throw new Error(`Validation failed with the following errors:
  ${errorList}`);
      }
    }
    function visit(root, order, cb) {
      if (order === "pre") {
        cb(root);
      }
      for (const child of root.node.children) {
        if (stage_1.Stage.isStage(child)) {
          continue;
        }
        visit(child, order, cb);
      }
      if (order === "post") {
        cb(root);
      }
    }
  }
});

// node_modules/@aws-cdk/core/lib/construct-compat.js
var require_construct_compat = __commonJS({
  "node_modules/@aws-cdk/core/lib/construct-compat.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ConstructNode = exports.ConstructOrder = exports.Construct = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_lib5();
    var constructs = require_lib4();
    var annotations_1 = require_annotations();
    var aspect_1 = require_aspect();
    var token_1 = require_token();
    var ORIGINAL_CONSTRUCT_NODE_SYMBOL = Symbol.for("@aws-cdk/core.ConstructNode");
    var CONSTRUCT_SYMBOL = Symbol.for("@aws-cdk/core.Construct");
    var Construct = class extends constructs.Construct {
      constructor(scope, id) {
        super(scope, id, {
          nodeFactory: {
            createNode: (h, s, i) => new ConstructNode(h, s, i)._actualNode
          }
        });
        if (token_1.Token.isUnresolved(id)) {
          throw new Error(`Cannot use tokens in construct ID: ${id}`);
        }
        Object.defineProperty(this, CONSTRUCT_SYMBOL, { value: true });
        this.node = ConstructNode._unwrap(constructs.Node.of(this));
        const disableTrace = this.node.tryGetContext(cxapi.DISABLE_METADATA_STACK_TRACE) || this.node.tryGetContext(constructs.ConstructMetadata.DISABLE_STACK_TRACE_IN_METADATA) || process.env.CDK_DISABLE_STACK_TRACE;
        if (disableTrace) {
          this.node.setContext(cxapi.DISABLE_METADATA_STACK_TRACE, true);
          this.node.setContext(constructs.ConstructMetadata.DISABLE_STACK_TRACE_IN_METADATA, true);
          process.env.CDK_DISABLE_STACK_TRACE = "1";
        }
      }
      static isConstruct(x) {
        return typeof x === "object" && x !== null && CONSTRUCT_SYMBOL in x;
      }
      onValidate() {
        return this.validate();
      }
      onPrepare() {
        this.prepare();
      }
      onSynthesize(session) {
        this.synthesize({
          outdir: session.outdir,
          assembly: session.assembly
        });
      }
      validate() {
        return [];
      }
      prepare() {
        return;
      }
      synthesize(session) {
        ignore(session);
      }
    };
    exports.Construct = Construct;
    _a = JSII_RTTI_SYMBOL_1;
    Construct[_a] = { fqn: "@aws-cdk/core.Construct", version: "1.128.0" };
    var ConstructOrder;
    (function(ConstructOrder2) {
      ConstructOrder2[ConstructOrder2["PREORDER"] = 0] = "PREORDER";
      ConstructOrder2[ConstructOrder2["POSTORDER"] = 1] = "POSTORDER";
    })(ConstructOrder = exports.ConstructOrder || (exports.ConstructOrder = {}));
    var ConstructNode = class {
      constructor(host, scope, id) {
        this.host = host;
        this._actualNode = new constructs.Node(host, scope, id);
        Object.defineProperty(this._actualNode, ORIGINAL_CONSTRUCT_NODE_SYMBOL, {
          value: this,
          configurable: false,
          enumerable: false
        });
      }
      static _unwrap(c) {
        const x = c[ORIGINAL_CONSTRUCT_NODE_SYMBOL];
        if (!x) {
          throw new Error("invalid ConstructNode type");
        }
        return x;
      }
      static synth(node, options = {}) {
        const a = require_synthesis();
        return a.synthesize(node.root, options);
      }
      static prepare(node) {
        const p = require_prepare_app();
        p.prepareApp(node.root);
        return node._actualNode.prepare();
      }
      static validate(node) {
        return node._actualNode.validate().map((e) => ({ source: e.source, message: e.message }));
      }
      get scope() {
        return this._actualNode.scope;
      }
      get id() {
        return this._actualNode.id;
      }
      get path() {
        return this._actualNode.path;
      }
      get uniqueId() {
        return this._actualNode.uniqueId;
      }
      get addr() {
        return this._actualNode.addr;
      }
      tryFindChild(id) {
        return this._actualNode.tryFindChild(id);
      }
      findChild(id) {
        return this._actualNode.findChild(id);
      }
      get defaultChild() {
        return this._actualNode.defaultChild;
      }
      set defaultChild(value) {
        this._actualNode.defaultChild = value;
      }
      get children() {
        return this._actualNode.children;
      }
      findAll(order = ConstructOrder.PREORDER) {
        return this._actualNode.findAll(order);
      }
      setContext(key, value) {
        if (token_1.Token.isUnresolved(key)) {
          throw new Error("Invalid context key: context keys can't include tokens");
        }
        this._actualNode.setContext(key, value);
      }
      tryGetContext(key) {
        if (token_1.Token.isUnresolved(key)) {
          throw new Error("Invalid context key: context keys can't include tokens");
        }
        return this._actualNode.tryGetContext(key);
      }
      get metadata() {
        return this._actualNode.metadata;
      }
      get metadataEntry() {
        return this._actualNode.metadata;
      }
      addMetadata(type, data, fromFunction) {
        this._actualNode.addMetadata(type, data, fromFunction);
      }
      addInfo(message) {
        annotations_1.Annotations.of(this.host).addInfo(message);
      }
      addWarning(message) {
        annotations_1.Annotations.of(this.host).addWarning(message);
      }
      addError(message) {
        annotations_1.Annotations.of(this.host).addError(message);
      }
      applyAspect(aspect) {
        annotations_1.Annotations.of(this.host).addDeprecation("@aws-cdk/core.ConstructNode.applyAspect", 'Use "Aspects.of(construct).add(aspect)" instead');
        aspect_1.Aspects.of(this.host).add(aspect);
      }
      addValidation(validation) {
        this._actualNode.addValidation(validation);
      }
      get scopes() {
        return this._actualNode.scopes;
      }
      get root() {
        return this._actualNode.root;
      }
      get locked() {
        return this._actualNode.locked;
      }
      addDependency(...dependencies) {
        this._actualNode.addDependency(...dependencies);
      }
      get dependencies() {
        return this._actualNode.dependencies;
      }
      tryRemoveChild(childName) {
        return this._actualNode.tryRemoveChild(childName);
      }
    };
    exports.ConstructNode = ConstructNode;
    _b = JSII_RTTI_SYMBOL_1;
    ConstructNode[_b] = { fqn: "@aws-cdk/core.ConstructNode", version: "1.128.0" };
    ConstructNode.PATH_SEP = "/";
    function ignore(_x) {
      return;
    }
  }
});

// node_modules/@aws-cdk/core/lib/cfn-element.js
var require_cfn_element = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-element.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnRefElement = exports.CfnElement = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxschema = require_lib3();
    var constructs_1 = require_lib4();
    var construct_compat_1 = require_construct_compat();
    var lazy_1 = require_lazy();
    var CFN_ELEMENT_SYMBOL = Symbol.for("@aws-cdk/core.CfnElement");
    var CfnElement = class extends construct_compat_1.Construct {
      constructor(scope, id) {
        super(scope, id);
        Object.defineProperty(this, CFN_ELEMENT_SYMBOL, { value: true });
        this.stack = stack_1.Stack.of(this);
        this.logicalId = lazy_1.Lazy.uncachedString({ produce: () => this.synthesizeLogicalId() }, {
          displayHint: `${notTooLong(constructs_1.Node.of(this).path)}.LogicalID`
        });
        constructs_1.Node.of(this).addMetadata(cxschema.ArtifactMetadataEntryType.LOGICAL_ID, this.logicalId, this.constructor);
      }
      static isCfnElement(x) {
        return CFN_ELEMENT_SYMBOL in x;
      }
      overrideLogicalId(newLogicalId) {
        this._logicalIdOverride = newLogicalId;
      }
      get creationStack() {
        const trace = constructs_1.Node.of(this).metadata.find((md) => md.type === cxschema.ArtifactMetadataEntryType.LOGICAL_ID).trace;
        if (!trace) {
          return [];
        }
        return filterStackTrace(trace);
        function filterStackTrace(stack) {
          const result = Array.of(...stack);
          while (result.length > 0 && shouldFilter(result[result.length - 1])) {
            result.pop();
          }
          return result.length === 0 ? stack : result;
        }
        function shouldFilter(str) {
          return str.match(/[^(]+\(internal\/.*/) !== null;
        }
      }
      synthesizeLogicalId() {
        if (this._logicalIdOverride) {
          return this._logicalIdOverride;
        } else {
          return this.stack.getLogicalId(this);
        }
      }
    };
    exports.CfnElement = CfnElement;
    _a = JSII_RTTI_SYMBOL_1;
    CfnElement[_a] = { fqn: "@aws-cdk/core.CfnElement", version: "1.128.0" };
    var CfnRefElement = class extends CfnElement {
      get ref() {
        return token_1.Token.asString(cfn_reference_1.CfnReference.for(this, "Ref"));
      }
    };
    exports.CfnRefElement = CfnRefElement;
    _b = JSII_RTTI_SYMBOL_1;
    CfnRefElement[_b] = { fqn: "@aws-cdk/core.CfnRefElement", version: "1.128.0" };
    function notTooLong(x) {
      if (x.length < 100) {
        return x;
      }
      return x.substr(0, 47) + "..." + x.substr(x.length - 47);
    }
    var cfn_reference_1 = require_cfn_reference();
    var stack_1 = require_stack();
    var token_1 = require_token();
  }
});

// node_modules/@aws-cdk/core/lib/cfn-resource-policy.js
var require_cfn_resource_policy = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-resource-policy.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnDeletionPolicy = void 0;
    var CfnDeletionPolicy;
    (function(CfnDeletionPolicy2) {
      CfnDeletionPolicy2["DELETE"] = "Delete";
      CfnDeletionPolicy2["RETAIN"] = "Retain";
      CfnDeletionPolicy2["SNAPSHOT"] = "Snapshot";
    })(CfnDeletionPolicy = exports.CfnDeletionPolicy || (exports.CfnDeletionPolicy = {}));
  }
});

// node_modules/@aws-cdk/core/lib/cfn-resource.js
var require_cfn_resource = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-resource.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TagType = exports.CfnResource = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_lib5();
    var cfn_element_1 = require_cfn_element();
    var cfn_resource_policy_1 = require_cfn_resource_policy();
    var constructs_1 = require_lib4();
    var deps_1 = require_deps();
    var cfn_reference_1 = require_cfn_reference();
    var cloudformation_lang_1 = require_cloudformation_lang();
    var removal_policy_1 = require_removal_policy();
    var tag_manager_1 = require_tag_manager();
    var token_1 = require_token();
    var util_1 = require_util();
    var CfnResource = class extends cfn_element_1.CfnRefElement {
      constructor(scope, id, props) {
        super(scope, id);
        this.cfnOptions = {};
        this.rawOverrides = {};
        this.dependsOn = /* @__PURE__ */ new Set();
        if (!props.type) {
          throw new Error("The `type` property is required");
        }
        this.cfnResourceType = props.type;
        this._cfnProperties = props.properties || {};
        if (constructs_1.Node.of(this).tryGetContext(cxapi.PATH_METADATA_ENABLE_CONTEXT)) {
          this.addMetadata(cxapi.PATH_METADATA_KEY, constructs_1.Node.of(this).path);
        }
      }
      static isCfnResource(construct) {
        return construct.cfnResourceType !== void 0;
      }
      applyRemovalPolicy(policy, options = {}) {
        policy = policy || options.default || removal_policy_1.RemovalPolicy.RETAIN;
        let deletionPolicy;
        switch (policy) {
          case removal_policy_1.RemovalPolicy.DESTROY:
            deletionPolicy = cfn_resource_policy_1.CfnDeletionPolicy.DELETE;
            break;
          case removal_policy_1.RemovalPolicy.RETAIN:
            deletionPolicy = cfn_resource_policy_1.CfnDeletionPolicy.RETAIN;
            break;
          case removal_policy_1.RemovalPolicy.SNAPSHOT:
            deletionPolicy = cfn_resource_policy_1.CfnDeletionPolicy.SNAPSHOT;
            break;
          default:
            throw new Error(`Invalid removal policy: ${policy}`);
        }
        this.cfnOptions.deletionPolicy = deletionPolicy;
        if (options.applyToUpdateReplacePolicy !== false) {
          this.cfnOptions.updateReplacePolicy = deletionPolicy;
        }
      }
      getAtt(attributeName) {
        return cfn_reference_1.CfnReference.for(this, attributeName);
      }
      addOverride(path, value) {
        const parts = splitOnPeriods(path);
        let curr = this.rawOverrides;
        while (parts.length > 1) {
          const key = parts.shift();
          const isObject = curr[key] != null && typeof curr[key] === "object" && !Array.isArray(curr[key]);
          if (!isObject) {
            curr[key] = {};
          }
          curr = curr[key];
        }
        const lastKey = parts.shift();
        curr[lastKey] = value;
      }
      addDeletionOverride(path) {
        this.addOverride(path, void 0);
      }
      addPropertyOverride(propertyPath, value) {
        this.addOverride(`Properties.${propertyPath}`, value);
      }
      addPropertyDeletionOverride(propertyPath) {
        this.addPropertyOverride(propertyPath, void 0);
      }
      addDependsOn(target) {
        if (!target.shouldSynthesize()) {
          return;
        }
        deps_1.addDependency(this, target, `"${constructs_1.Node.of(this).path}" depends on "${constructs_1.Node.of(target).path}"`);
      }
      addMetadata(key, value) {
        if (!this.cfnOptions.metadata) {
          this.cfnOptions.metadata = {};
        }
        this.cfnOptions.metadata[key] = value;
      }
      getMetadata(key) {
        var _b;
        return (_b = this.cfnOptions.metadata) === null || _b === void 0 ? void 0 : _b[key];
      }
      toString() {
        return `${super.toString()} [${this.cfnResourceType}]`;
      }
      _addResourceDependency(target) {
        this.dependsOn.add(target);
      }
      _toCloudFormation() {
        if (!this.shouldSynthesize()) {
          return {};
        }
        try {
          const ret = {
            Resources: {
              [this.logicalId]: new util_1.PostResolveToken({
                Type: this.cfnResourceType,
                Properties: util_1.ignoreEmpty(this.cfnProperties),
                DependsOn: util_1.ignoreEmpty(renderDependsOn(this.dependsOn)),
                CreationPolicy: util_1.capitalizePropertyNames(this, renderCreationPolicy(this.cfnOptions.creationPolicy)),
                UpdatePolicy: util_1.capitalizePropertyNames(this, this.cfnOptions.updatePolicy),
                UpdateReplacePolicy: util_1.capitalizePropertyNames(this, this.cfnOptions.updateReplacePolicy),
                DeletionPolicy: util_1.capitalizePropertyNames(this, this.cfnOptions.deletionPolicy),
                Version: this.cfnOptions.version,
                Description: this.cfnOptions.description,
                Metadata: util_1.ignoreEmpty(this.cfnOptions.metadata),
                Condition: this.cfnOptions.condition && this.cfnOptions.condition.logicalId
              }, (resourceDef) => {
                const renderedProps = this.renderProperties(resourceDef.Properties || {});
                if (renderedProps) {
                  const hasDefined = Object.values(renderedProps).find((v) => v !== void 0);
                  resourceDef.Properties = hasDefined !== void 0 ? renderedProps : void 0;
                }
                const resolvedRawOverrides = token_1.Tokenization.resolve(this.rawOverrides, {
                  scope: this,
                  resolver: cloudformation_lang_1.CLOUDFORMATION_TOKEN_RESOLVER,
                  removeEmpty: false
                });
                return deepMerge(resourceDef, resolvedRawOverrides);
              })
            }
          };
          return ret;
        } catch (e) {
          e.message = `While synthesizing ${this.node.path}: ${e.message}`;
          const trace = this.creationStack;
          if (trace) {
            const creationStack = ["--- resource created at ---", ...trace].join("\n  at ");
            const problemTrace = e.stack.substr(e.stack.indexOf(e.message) + e.message.length);
            e.stack = `${e.message}
  ${creationStack}
  --- problem discovered at ---${problemTrace}`;
          }
          throw e;
        }
        function renderDependsOn(dependsOn) {
          return Array.from(dependsOn).sort((x, y) => x.node.path.localeCompare(y.node.path)).map((r) => r.logicalId);
        }
        function renderCreationPolicy(policy) {
          if (!policy) {
            return void 0;
          }
          const result = __spreadValues({}, policy);
          if (policy.resourceSignal && policy.resourceSignal.timeout) {
            result.resourceSignal = policy.resourceSignal;
          }
          return result;
        }
      }
      get cfnProperties() {
        const props = this._cfnProperties || {};
        if (tag_manager_1.TagManager.isTaggable(this)) {
          const tagsProp = {};
          tagsProp[this.tags.tagPropertyName] = this.tags.renderTags();
          return deepMerge(props, tagsProp);
        }
        return props;
      }
      renderProperties(props) {
        return props;
      }
      get updatedProperites() {
        return this._cfnProperties;
      }
      validateProperties(_properties) {
      }
      shouldSynthesize() {
        return true;
      }
    };
    exports.CfnResource = CfnResource;
    _a = JSII_RTTI_SYMBOL_1;
    CfnResource[_a] = { fqn: "@aws-cdk/core.CfnResource", version: "1.128.0" };
    var TagType;
    (function(TagType2) {
      TagType2["STANDARD"] = "StandardTag";
      TagType2["AUTOSCALING_GROUP"] = "AutoScalingGroupTag";
      TagType2["MAP"] = "StringToStringMap";
      TagType2["KEY_VALUE"] = "KeyValue";
      TagType2["NOT_TAGGABLE"] = "NotTaggable";
    })(TagType = exports.TagType || (exports.TagType = {}));
    function deepMerge(target, ...sources) {
      for (const source of sources) {
        if (typeof source !== "object" || typeof target !== "object") {
          throw new Error(`Invalid usage. Both source (${JSON.stringify(source)}) and target (${JSON.stringify(target)}) must be objects`);
        }
        for (const key of Object.keys(source)) {
          const value = source[key];
          if (typeof value === "object" && value != null && !Array.isArray(value)) {
            if (typeof target[key] !== "object") {
              target[key] = {};
            }
            deepMerge(target[key], value);
            const output = target[key];
            if (typeof output === "object" && Object.keys(output).length === 0) {
              delete target[key];
            }
          } else if (value === void 0) {
            delete target[key];
          } else {
            target[key] = value;
          }
        }
      }
      return target;
    }
    function splitOnPeriods(x) {
      const ret = [""];
      for (let i = 0; i < x.length; i++) {
        if (x[i] === "\\" && i + 1 < x.length) {
          ret[0] += x[i + 1];
          i++;
        } else if (x[i] === ".") {
          ret.unshift("");
        } else {
          ret[0] += x[i];
        }
      }
      ret.reverse();
      return ret;
    }
  }
});

// node_modules/@aws-cdk/core/lib/tag-manager.js
var require_tag_manager = __commonJS({
  "node_modules/@aws-cdk/core/lib/tag-manager.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TagManager = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_resource_1 = require_cfn_resource();
    var StandardFormatter = class {
      parseTags(cfnPropertyTags, priority) {
        if (!Array.isArray(cfnPropertyTags)) {
          throw new Error(`Invalid tag input expected array of {key, value} have ${JSON.stringify(cfnPropertyTags)}`);
        }
        const tags = [];
        for (const tag of cfnPropertyTags) {
          if (tag.key === void 0 || tag.value === void 0) {
            throw new Error(`Invalid tag input expected {key, value} have ${JSON.stringify(tag)}`);
          }
          tags.push({
            key: `${tag.key}`,
            value: `${tag.value}`,
            priority
          });
        }
        return tags;
      }
      formatTags(tags) {
        const cfnTags = [];
        for (const tag of tags) {
          cfnTags.push({
            key: tag.key,
            value: tag.value
          });
        }
        return cfnTags.length === 0 ? void 0 : cfnTags;
      }
    };
    var AsgFormatter = class {
      parseTags(cfnPropertyTags, priority) {
        const tags = [];
        if (!Array.isArray(cfnPropertyTags)) {
          throw new Error(`Invalid tag input expected array of {key, value, propagateAtLaunch} have ${JSON.stringify(cfnPropertyTags)}`);
        }
        for (const tag of cfnPropertyTags) {
          if (tag.key === void 0 || tag.value === void 0 || tag.propagateAtLaunch === void 0) {
            throw new Error(`Invalid tag input expected {key, value, propagateAtLaunch} have ${JSON.stringify(tag)}`);
          }
          tags.push({
            key: `${tag.key}`,
            value: `${tag.value}`,
            priority,
            applyToLaunchedInstances: !!tag.propagateAtLaunch
          });
        }
        return tags;
      }
      formatTags(tags) {
        const cfnTags = [];
        for (const tag of tags) {
          cfnTags.push({
            key: tag.key,
            value: tag.value,
            propagateAtLaunch: tag.applyToLaunchedInstances !== false
          });
        }
        return cfnTags.length === 0 ? void 0 : cfnTags;
      }
    };
    var MapFormatter = class {
      parseTags(cfnPropertyTags, priority) {
        const tags = [];
        if (Array.isArray(cfnPropertyTags) || typeof cfnPropertyTags !== "object") {
          throw new Error(`Invalid tag input expected map of {key: value} have ${JSON.stringify(cfnPropertyTags)}`);
        }
        for (const [key, value] of Object.entries(cfnPropertyTags)) {
          tags.push({
            key,
            value: `${value}`,
            priority
          });
        }
        return tags;
      }
      formatTags(tags) {
        const cfnTags = {};
        for (const tag of tags) {
          cfnTags[`${tag.key}`] = `${tag.value}`;
        }
        return Object.keys(cfnTags).length === 0 ? void 0 : cfnTags;
      }
    };
    var KeyValueFormatter = class {
      parseTags(keyValueTags, priority) {
        const tags = [];
        for (const key in keyValueTags) {
          if (keyValueTags.hasOwnProperty(key)) {
            const value = keyValueTags[key];
            tags.push({
              key,
              value,
              priority
            });
          }
        }
        return tags;
      }
      formatTags(unformattedTags) {
        const tags = [];
        unformattedTags.forEach((tag) => {
          tags.push({
            Key: tag.key,
            Value: tag.value
          });
        });
        return tags;
      }
    };
    var NoFormat = class {
      parseTags(_cfnPropertyTags) {
        return [];
      }
      formatTags(_tags) {
        return void 0;
      }
    };
    var _tagFormattersCache;
    function TAG_FORMATTERS() {
      return _tagFormattersCache !== null && _tagFormattersCache !== void 0 ? _tagFormattersCache : _tagFormattersCache = {
        [cfn_resource_1.TagType.AUTOSCALING_GROUP]: new AsgFormatter(),
        [cfn_resource_1.TagType.STANDARD]: new StandardFormatter(),
        [cfn_resource_1.TagType.MAP]: new MapFormatter(),
        [cfn_resource_1.TagType.KEY_VALUE]: new KeyValueFormatter(),
        [cfn_resource_1.TagType.NOT_TAGGABLE]: new NoFormat()
      };
    }
    var TagManager = class {
      constructor(tagType, resourceTypeName, tagStructure, options = {}) {
        this.tags = /* @__PURE__ */ new Map();
        this.priorities = /* @__PURE__ */ new Map();
        this.initialTagPriority = 50;
        this.resourceTypeName = resourceTypeName;
        this.tagFormatter = TAG_FORMATTERS()[tagType];
        if (tagStructure !== void 0) {
          this._setTag(...this.tagFormatter.parseTags(tagStructure, this.initialTagPriority));
        }
        this.tagPropertyName = options.tagPropertyName || "tags";
      }
      static isTaggable(construct) {
        return construct.tags !== void 0;
      }
      setTag(key, value, priority = 0, applyToLaunchedInstances = true) {
        this._setTag({ key, value, priority, applyToLaunchedInstances });
      }
      removeTag(key, priority) {
        if (priority >= (this.priorities.get(key) || 0)) {
          this.tags.delete(key);
          this.priorities.set(key, priority);
        }
      }
      renderTags() {
        return this.tagFormatter.formatTags(this.sortedTags);
      }
      tagValues() {
        const ret = {};
        for (const tag of this.sortedTags) {
          ret[tag.key] = tag.value;
        }
        return ret;
      }
      applyTagAspectHere(include, exclude) {
        if (exclude && exclude.length > 0 && exclude.indexOf(this.resourceTypeName) !== -1) {
          return false;
        }
        if (include && include.length > 0 && include.indexOf(this.resourceTypeName) === -1) {
          return false;
        }
        return true;
      }
      hasTags() {
        return this.tags.size > 0;
      }
      _setTag(...tags) {
        for (const tag of tags) {
          if (tag.priority >= (this.priorities.get(tag.key) || 0)) {
            this.tags.set(tag.key, tag);
            this.priorities.set(tag.key, tag.priority);
          }
        }
      }
      get sortedTags() {
        return Array.from(this.tags.values()).sort((a, b) => a.key.localeCompare(b.key));
      }
    };
    exports.TagManager = TagManager;
    _a = JSII_RTTI_SYMBOL_1;
    TagManager[_a] = { fqn: "@aws-cdk/core.TagManager", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/tag-aspect.js
var require_tag_aspect = __commonJS({
  "node_modules/@aws-cdk/core/lib/tag-aspect.js"(exports) {
    "use strict";
    var _a;
    var _b;
    var _c;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.RemoveTag = exports.Tags = exports.Tag = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var annotations_1 = require_annotations();
    var aspect_1 = require_aspect();
    var tag_manager_1 = require_tag_manager();
    var TagBase = class {
      constructor(key, props = {}) {
        this.key = key;
        this.props = props;
      }
      visit(construct) {
        if (tag_manager_1.TagManager.isTaggable(construct)) {
          this.applyTag(construct);
        }
      }
    };
    var Tag = class extends TagBase {
      constructor(key, value, props = {}) {
        super(key, props);
        this.defaultPriority = 100;
        if (value === void 0) {
          throw new Error("Tag must have a value");
        }
        this.value = value;
      }
      static add(scope, key, value, props = {}) {
        annotations_1.Annotations.of(scope).addDeprecation("@aws-cdk/core.Tag.add(scope,k,v)", 'Use "Tags.of(scope).add(k,v)" instead');
        Tags.of(scope).add(key, value, props);
      }
      static remove(scope, key, props = {}) {
        annotations_1.Annotations.of(scope).addDeprecation("@aws-cdk/core.Tag.remove(scope,k,v)", 'Use "Tags.of(scope).remove(k,v)" instead');
        Tags.of(scope).remove(key, props);
      }
      applyTag(resource) {
        var _d;
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
          resource.tags.setTag(this.key, this.value, (_d = this.props.priority) !== null && _d !== void 0 ? _d : this.defaultPriority, this.props.applyToLaunchedInstances !== false);
        }
      }
    };
    exports.Tag = Tag;
    _a = JSII_RTTI_SYMBOL_1;
    Tag[_a] = { fqn: "@aws-cdk/core.Tag", version: "1.128.0" };
    var Tags = class {
      constructor(scope) {
        this.scope = scope;
      }
      static of(scope) {
        return new Tags(scope);
      }
      add(key, value, props = {}) {
        aspect_1.Aspects.of(this.scope).add(new Tag(key, value, props));
      }
      remove(key, props = {}) {
        aspect_1.Aspects.of(this.scope).add(new RemoveTag(key, props));
      }
    };
    exports.Tags = Tags;
    _b = JSII_RTTI_SYMBOL_1;
    Tags[_b] = { fqn: "@aws-cdk/core.Tags", version: "1.128.0" };
    var RemoveTag = class extends TagBase {
      constructor(key, props = {}) {
        super(key, props);
        this.defaultPriority = 200;
      }
      applyTag(resource) {
        var _d;
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
          resource.tags.removeTag(this.key, (_d = this.props.priority) !== null && _d !== void 0 ? _d : this.defaultPriority);
        }
      }
    };
    exports.RemoveTag = RemoveTag;
    _c = JSII_RTTI_SYMBOL_1;
    RemoveTag[_c] = { fqn: "@aws-cdk/core.RemoveTag", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/dependency.js
var require_dependency2 = __commonJS({
  "node_modules/@aws-cdk/core/lib/dependency.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DependableTrait = exports.ConcreteDependable = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var ConcreteDependable = class {
      constructor() {
        this._dependencyRoots = new Array();
        const self = this;
        DependableTrait.implement(this, {
          get dependencyRoots() {
            return self._dependencyRoots;
          }
        });
      }
      add(construct) {
        this._dependencyRoots.push(construct);
      }
    };
    exports.ConcreteDependable = ConcreteDependable;
    _a = JSII_RTTI_SYMBOL_1;
    ConcreteDependable[_a] = { fqn: "@aws-cdk/core.ConcreteDependable", version: "1.128.0" };
    var DEPENDABLE_SYMBOL = Symbol.for("@aws-cdk/core.DependableTrait");
    var DependableTrait = class {
      static implement(instance, trait) {
        instance[DEPENDABLE_SYMBOL] = trait;
      }
      static get(instance) {
        const ret = instance[DEPENDABLE_SYMBOL];
        if (!ret) {
          throw new Error(`${instance} does not implement DependableTrait`);
        }
        return ret;
      }
    };
    exports.DependableTrait = DependableTrait;
    _b = JSII_RTTI_SYMBOL_1;
    DependableTrait[_b] = { fqn: "@aws-cdk/core.DependableTrait", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/cfn-hook.js
var require_cfn_hook = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-hook.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnHook = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var util_1 = require_util();
    var CfnHook = class extends cfn_element_1.CfnElement {
      constructor(scope, id, props) {
        super(scope, id);
        this.type = props.type;
        this._cfnHookProperties = props.properties;
      }
      _toCloudFormation() {
        return {
          Hooks: {
            [this.logicalId]: {
              Type: this.type,
              Properties: util_1.ignoreEmpty(this.renderProperties(this._cfnHookProperties))
            }
          }
        };
      }
      renderProperties(props) {
        return props;
      }
    };
    exports.CfnHook = CfnHook;
    _a = JSII_RTTI_SYMBOL_1;
    CfnHook[_a] = { fqn: "@aws-cdk/core.CfnHook", version: "1.128.0" };
  }
});

// node_modules/@aws-cdk/core/lib/cfn-codedeploy-blue-green-hook.js
var require_cfn_codedeploy_blue_green_hook = __commonJS({
  "node_modules/@aws-cdk/core/lib/cfn-codedeploy-blue-green-hook.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.CfnCodeDeployBlueGreenHook = exports.CfnTrafficRoutingType = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_hook_1 = require_cfn_hook();
    var util_1 = require_util();
    var CfnTrafficRoutingType;
    (function(CfnTrafficRoutingType2) {
      CfnTrafficRoutingType2["ALL_AT_ONCE"] = "AllAtOnce";
      CfnTrafficRoutingType2["TIME_BASED_CANARY"] = "TimeBasedCanary";
      CfnTrafficRoutingType2["TIME_BASED_LINEAR"] = "TimeBasedLinear";
    })(CfnTrafficRoutingType = exports.CfnTrafficRoutingType || (exports.CfnTrafficRoutingType = {}));
    var CfnCodeDeployBlueGreenHook = class extends cfn_hook_1.CfnHook {
      constructor(scope, id, props) {
        super(scope, id, {
          type: "AWS::CodeDeploy::BlueGreen"
        });
        this._serviceRole = props.serviceRole;
        this._applications = props.applications;
        this._trafficRoutingConfig = props.trafficRoutingConfig;
        this._additionalOptions = props.additionalOptions;
        this._lifecycleEventHooks = props.lifecycleEventHooks;
      }
      static _fromCloudFormation(scope, id, hookAttributes, options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        hookAttributes = hookAttributes || {};
        const hookProperties = options.parser.parseValue(hookAttributes.Properties);
        return new CfnCodeDeployBlueGreenHook(scope, id, {
          serviceRole: hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.ServiceRole,
          applications: (_b = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.Applications) === null || _b === void 0 ? void 0 : _b.map(applicationFromCloudFormation),
          trafficRoutingConfig: {
            type: (_c = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _c === void 0 ? void 0 : _c.Type,
            timeBasedCanary: {
              stepPercentage: (_e = (_d = hookProperties === null || hookProperties === void 0 ? void 0 : hookProperties.TrafficRoutingConfig) === null || _d === void 0 ? void 0 : _d.TimeBasedCanary) === null || _e === void 0 ? void 0 : _e.StepPercentage,
              bakeTimeMins: (_g = (_f = hookProperties === null || hookProperties === void 0 ? void 