# Kodx Documentation Overview

This page provides a concise entry point to the Kodx documentation.

## Key Topics
- **Quick Start:** [quickstart.md](quickstart.md)
- **Repository Analysis Feature:** [features_ask.md](features_ask.md)
- **Docker Configuration:** [docker-config.md](docker-config.md) (includes network isolation settings)
- **Architecture Details:** [architecture.md](architecture.md)
- **API Reference:** [api.md](api.md)
- **Testing Guide:** [testing.md](testing.md)
- **GitHub Actions:** [github-action-examples.md](github-action-examples.md)

## CLI Commands
- **`kodx` Core Command:** [kodx-core.md](kodx-core.md) (general-purpose with custom programs)
- **`kodx ask` Command:** [kodx-ask.md](kodx-ask.md) (specialized for code analysis)
- **`kodx code` Command:** [kodx-code.md](kodx-code.md) (git-integrated implementation)
- **Git Integration:** [git-integration.md](git-integration.md)
- **Dry Run Mode:** All commands support `--dry-run`.

For a guided tour of all documentation see [README.md](README.md).

---

## Documentation Navigation

[Back to Documentation Map](README.md)
